// Copyright (C) 2008 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * @fileoverview
 * Registers a language handler for MAXScript.
 *
 *
 * To use, include prettify.js and this file in your HTML page.
 * Then put your code in an HTML tag like
 *      <pre class="prettyprint lang-maxscript">(my code)</pre>
 *
 * This is ripped off from the Lua lexer, with a new list of keywords.
 *
 * @author robb.surridge@autodesk.com
 */

PR.registerLangHandler(
    PR.createSimpleLexer(
        [
         // Whitespace
         [PR.PR_PLAIN,       /^[\t\n\r \xA0]+/, null, '\t\n\r \xA0'],
         // A path.
		 ['pathn', /^\$(?:\'.*\'|[A-Za-z0-9_\/\*\?\.]*)/, null, '\$'],
         // A verbatim, possibly multi-line, string.
         ['verb',      /^(?:@\"(?:[^\"\\]|\\[\s\S])*(?:\"|$)|\'(?:[^\'\\]|\\[\s\S])*(?:\'|$))/, null, '@'],
         // A double or single quoted, possibly multi-line, string.
         [PR.PR_STRING,      /^(?:\"(?:[^\"\\]|\\[\s\S])*(?:\"|$)|\'(?:[^\'\\]|\\[\s\S])*(?:\'|$))/, null, '"\'']
        ],
        [
         // A comment is a line comment that starts with two dashes, or /* */.
         [PR.PR_COMMENT, /^--[^\r\n]*/],
         [PR.PR_COMMENT, /^\/\*[^*]*\*+(?:[^\/*][^*]*\*+)*\//],
		 ['namev', /^#[\w]+/i, null],
		 ['param', /^(?:[\w]*:)/],
		 [PR.PR_PLAIN, /^(?:<.*?>)/i, null],
         ['kwd1', /^(?:and|animate|as|about|at|attributes|by|collect|case|continue|catch|coordsys|do|dropscript|else|exit|for|from|function|fn|global|if|in|local|macroscript|mapped|max|not|or|of|on|off|parameters|persistent|plugin|private|public|rcmenu|return|rollout|struct|set|then|throw|to|tool|try|utility|undo|while|where|with|when)\b/i, null],
         ['kwd2', /^(?:group|label|button|edittext|combobox|dropdownlist|listbox|spinner|slider|pickbutton|radiobuttons|checkbox|checkbutton|colorpicker|bitmap|mapbutton|materialbutton|subrollout|activexcontrol|angle|groupbox|imgtag|hyperlink|progressbar|timer|multilistbox|curvecontrol|dotnetcontrol|utility|struct|rollout|fn|function|on|plugin|tool|rcmennu|macroscript|mapped|attributes|with|set)\b/i, null],
         ['kwd3', /^(?:bindspacewarp|getfilenametype|getdialogsize|setreactionfalloff|shelllaunch|tanh|setgroupopen|setkeystepsusetrans|releaseoleobject|lockaxistripods|networklicensestatusmanager.isbusy|networklicensestatusmanager.setbusy|networklicensestatusmanager.lock|networklicensestatusmanager.unlock|networklicensestatusmanager.islocked|networklicensestatusmanager.ispaused|networklicensestatusmanager.getlaststampduration|networklicensestatusmanager.gettotalidletime|subdividesegment|getuniversaltime|workspacemanager.createnewworkspace|workspacemanager.getworkspaceidentifier|workspacemanager.getworkspacename|workspacemanager.getworkspacenamewithidentifier|workspacemanager.getworkspacecount|workspacemanager.getcurrentworkspaceidentifier|workspacemanager.setcurrentworkspacebyidentifier|workspacemanager.deleteworkspace|workspacemanager.getwritedirectory|workspacemanager.setworkspacename|workspacemanager.setworkspacenamewithidentifier|workspacemanager.resettodefaults|workspacemanager.getrunscript|workspacemanager.togglerunscript|workspacemanager.getentryscript|workspacemanager.setentryscript|workspacemanager.getexitscript|workspacemanager.setexitscript|workspacemanager.getallsubsystemscount|workspacemanager.getsubsystemname|workspacemanager.issubsystemsaving|workspacemanager.togglesubsystemsaving|workspacemanager.issystemworkspace|removerollout|hasnotetracks|resetxform|squadrev|units.decodevalue|units.formatvalue|getprodtess|refine|polybuvlineup|pbstarttrack|getwarpedtimeatorgtime|vfields.computevectors|vfields.blendvectors|getchannelasmask|collapseface|wm3_mc_buildfromnode|collapsestack|setsplineselection|getfilenamefile|getdialogpos|setreactionstrength|tan|setgrouphead|getkeystepsusetrans|createoleobject|getnumaxis|maxops.canimportbitmap|maxops.displayactivecameraviewwithmultipasseffect|maxops.setactiveviewporttransparencydisplay|maxops.loadcuifile|maxops.isfeaturelicensed|maxops.getcurrenderelementmgr|maxops.getrenderelementmgr|maxops.collapsenode|maxops.collapsenodeto|maxops.clonenodes|maxops.setselectiontype|maxops.getnodebyhandle|maxops.gettrackbar|maxops.activatesetkeymode|maxops.alltrackscommitsetkeybuffer|maxops.alltracksrevertsetkeybuffer|maxops.alltrackssetkeybufferpresent|maxops.getsetkeymode|maxops.getsetkeyfilterstate|maxops.setsetkeyfilterstate|maxops.startnewshape|maxops.beginprogressivemode|maxops.endprogressivemode|maxops.deleteselectedanimation|maxops.getdefaulttangenttype|maxops.setdefaulttangenttype|maxops.colorbyid|maxops.findnodes|maxops.deleteselectedtrajectorykey|maxops.gettransformgizmotm|maxops.getviewportshadingsettings|maxops.persistfilelanguagesettings|getseglengths|getlocaltime|xrefs.addnewxrefobject|xrefs.getxreffile|xrefs.deleteallxrefs|xrefs.updatechangedxrefs|xrefs.addnewxreffile|xrefs.attemptunresolvedxrefs|xrefs.getxreffilecount|xrefs.findunresolvedxrefs|addrollout|deletenotetrack|gettexturesurface|setcv|polybuvgrowring|polybsetsize|getorgtimeatwarpedtime|getchannel|deleteface|wm3_numberofchannels|deletemodifier|getsplineselection|getfilenamepath|thehold.superlevel|thehold.begin|thehold.restore|thehold.enableundo|thehold.getmaxundolevels|thehold.resume|thehold.getbegindepth|thehold.accept|thehold.redoing|thehold.supercancel|thehold.isundodisabled|thehold.issuspended|thehold.end|thehold.getcurrentundolevels|thehold.restoring|thehold.superaccept|thehold.disableundo|thehold.getglobalputcount|thehold.suspend|thehold.cancel|thehold.release|thehold.setmaxundolevels|thehold.holding|thehold.superbegin|thehold.restoreorredoing|setdialogpos|setreactioninfluence|qorthog|sqrt|setgroupmember|setkeystepsselonly|registeroleinterface|enablerefcoordsys|tangentbezier3d|writefloatasdouble|closeutility|addnotetrack|gw.starttriangles|gw.clearscreen|gw.getwinsizex|gw.getfocaldist|gw.wpolygon|gw.getrndlimits|gw.isperspectiveview|gw.nonscalingobjectsize|gw.hpolyline|gw.getviewportdib|gw.gethithercoord|gw.marker|gw.wtranspoint|gw.querysupport|gw.setdirectxdisplayalltriangle|gw.getvpworldwidth|gw.hrect|gw.enlargeupdaterect|gw.isperspview|gw.tristrip|gw.setcolor|gw.setpos|gw.snaplength|gw.wpolyline|gw.setrndlimits|gw.getdriverstring|gw.triangle|gw.hmarker|gw.getwindepth|gw.wrect|gw.htranspoint|gw.getskipcount|gw.getcpdisp|gw.htristrip|gw.resetupdaterect|gw.polygon|gw.getflipped|gw.settransform|gw.snappoint|gw.wmarker|gw.updatescreen|gw.endtriangles|gw.htext|gw.getwinsizey|gw.gettextextent|gw.wtristrip|gw.getrndmode|gw.setskipcount|gw.getpointoncp|gw.text|gw.hpolygon|gw.getyoncoord|gw.polyline|gw.transpoint|gw.getmaxlights|gw.mapcptoworld|gw.wtext|gw.getupdaterect|settexturesurface|getcv|polybuvshrinkloop|polybadjustspinner2|gettwwarptime|setindexedpixels|deletevert|wm3_setchannelsel|addmodifier|setsegselection|makedir|destroydialog|setreactionvalue|squad|sinh|isopengrouphead|getkeystepsselonly|setmorphtargetname|setrefcoordsys|filelinkmgr.bind|filelinkmgr.isanylinked|filelinkmgr.changefilename|filelinkmgr.selectnodes|filelinkmgr.isnodelinked|filelinkmgr.getrecord|filelinkmgr.detach|filelinkmgr.attach|filelinkmgr.attachwithpreset|filelinkmgr.reload|filelinkmgr.getrecordfile|filelinkmgr.setdefaultview|interpbezier3d|readdoubleasfloat|openutility|genguid|setfliptrim|setknot|polybuvgrowloop|polybadjustspinner1|gettworgtime|iscontroller|getindexedpixels|extrudeface|listview.getindent|listview.hittest|listview.setindent|wm3_setchannelpos|getsegselection|copyfile|createdialog|setreactionstate|qcompa|sin|isopengroupmember|setkeystepsscale|deletemorphtarget|getrefcoordsys|cacheops.setchannel|cacheops.disablebelow|cacheops.enablebelow|cacheops.clearchannel|cacheops.recordcache|cacheops.reload|cacheops.unload|findlengthsegandparam|mouseconfigmanager.getzoomshortcut|mouseconfigmanager.setzoomshortcut|mouseconfigmanager.getpanshortcut|mouseconfigmanager.setpanshortcut|mouseconfigmanager.getrotateshortcut|mouseconfigmanager.setrotateshortcut|readstring|timestamp|genclassid|rendermessagemanager.openwindow|rendermessagemanager.hidewindow|rendermessagemanager.clearwindow|getfliptrim|getknot|polybuvring|polybsetflowspinner|initializetimewarp|isstruct|setpixels|wm3_refreshchannelparamsui|setknotselection|renamefile|getselectedreactionnum|brushpresetmgr.isactive|brushpresetmgr.openpresetmgr|brushpresetmgr.addpreset|brushpresetmgr.loadpresetfile|brushpresetmgr.savepresetfile|lndif|log10|isgroupmember|include|getkeystepsscale|setmorphtarget|enablecoordcenter|autotangentman.supportsautotangent|autotangentman.getautotangentalgorithm|autotangentman.setautotangentalgorithm|gettextextent|findpathsegandparam|readdouble|cui.getconfigfile|cui.dockdialogbar|cui.getexpertmode|cui.setconfigfile|cui.setapptitle|cui.getdir|cui.loadconfig|cui.unregisterdialogbar|cui.expertmodeoff|cui.getdockstate|cui.saveconfigas|cui.showtoolbar|cui.registerdialogbar|cui.expertmodeon|cui.floatdialogbar|cui.saveconfig|sleep|getfileversion|viewcubeops.gohome|viewcubeops.setcurrentviewashome|viewcubeops.setcurrentviewasfront|viewcubeops.orthographic|viewcubeops.perspective|viewcubeops.resetfront|viewcubeops.saveoptions|settrimsurface|evaltangent|polybuvloop|polybadjustcancel|deactivatetimewarp|isstructdef|getpixels|wm3_refreshchannellistui|autodeskmaterialmanager.getcategorycount|autodeskmaterialmanager.getcategoryuiname|autodeskmaterialmanager.getdefinitioncount|autodeskmaterialmanager.getdefinitionuiname|autodeskmaterialmanager.getdefinitionthumbnailurl|autodeskmaterialmanager.getdefinitionidentifier|autodeskmaterialmanager.createautodeskmaterial|autodeskmaterialmanager.createautodesktexmap|getknotselection|setsplitmesh|instance|deletefile|sceneradiosity.showpanel|sceneradiosity.closepanel|sceneradiosity.minimizepanel|selectreaction|slerp|log|isgrouphead|setkeystepsrot|addmorphtarget|enableundo|getsplitmesh|reference|weldspline|redrawviews|readfloat|doscommand|setiniforceutf16default|mocap.loadparameters|mocap.saveparameters|gettrimsurface|evalpos|polybtexturewrap|polybadjustundo|activatetimewarp|getpointcontroller|setasbackground|setsubdivisiondisplacement|isvalidmorphermod|addandweld|getdirectories|deletereaction|logn|floor|getviscontroller|getkeystepsrot|getsubdivisiondisplacement|createmorphobject|setcoordcenter|pastebitmap|readlonglong|setprogresscancel|hasinisetting|setradius|trimextend|polybseltobitmap|patch.addhook|patch.subdivideedges|patch.setmappatch|patch.getnumpatches|patch.changepatchinteriortype|patch.getadaptive|patch.getmapsupport|patch.getedgevert1|patch.hookfixtopology|patch.addtripatch|patch.setmeshsteps|patch.getvec|patch.getvert|patch.makequadpatch|patch.getvectors|patch.update|patch.getedgevec21|patch.unifynormals|patch.edgenormal|patch.getmeshstepsrender|patch.getvertpatches|patch.interpquadpatch|patch.clonepatchparts|patch.getmappatch|patch.getmapvert|patch.setnumvecs|patch.getverttype|patch.weldedges|patch.setadaptive|patch.setmapsupport|patch.getvecpatches|patch.updatehooks|patch.addquadpatch|patch.setpatchmtlid|patch.setnumedges|patch.getnumedges|patch.getmesh|patch.getpatches|patch.getnummapverts|patch.getedgevec12|patch.updatepatchnormals|patch.setmeshstepsrender|patch.getvertvecs|patch.getpatchtype|patch.interptripatch|patch.deletepatchparts|patch.setmapvert|patch.setnummappatches|patch.getnumvecs|patch.changeverttype|patch.weldverts|patch.getshowinterior|patch.getnummaps|patch.getvecvert|patch.setnumverts|patch.removehook|patch.autosmooth|patch.subdividepatches|patch.getpatchmtlid|patch.setnumpatches|patch.getnumverts|patch.getpatchinteriortype|patch.getedges|patch.setnummapverts|patch.getedgevert2|patch.patchnormal|patch.getmeshsteps|patch.setvec|patch.setvert|patch.maketripatch|patch.weld2verts|patch.maxmapchannels|patch.flippatchnormal|patch.transform|patch.setshowinterior|patch.setnummaps|patch.getvertedges|setdisplacementmapping|istimewarpactive|getpointcontrollers|loadpicture|pointcacheman.getmemoryused|materialid|getfiles|getdisplacementmapping|createreaction|conjugate|cosh|getmastercontroller|setkeystepspos|getmktargetweights|getcoordcenter|vld.enablemodule|vld.restore|vld.testleakmemory|vld.enable|vld.resolvecallstacks|vld.disable|vld.refreshmodules|vld.disablemodule|vld.reportleaks|appendifunique|readlong|getprogresscancel|delinisetting|setnumcpvverts|getradius|applyoffset|isundodisabled|polybocclusionmap|vcget2dviewmenuheight|loadmaxanimationfile|nvpx.getsimulationfps|nvpx.printsimulationfps|nvpx.addrigidbody|nvpx.addconstraint|nvpx.adddistancejoint|nvpx.captureinittransform|nvpx.setrigidbodyshapeflag|nvpx.removerigidbody|nvpx.removeall|nvpx.showvalidatescene|nvpx.hwavailable|nvpx.getscreenheight|nvpx.describeme|nvpx.setsdkparameter|nvpx.getsdkparameter|nvpx.setsdkdefaultparameter|nvpx.createconvexhull|nvpx.createconvexfrompoints|nvpx.getgravity|nvpx.setgravity|nvpx.setgeometryscale|nvpx.getgeometryscale|nvpx.setusecontactreport|nvpx.getcontactscount|nvpx.selectfirstcontact|nvpx.getnextcontact|nvpx.getcontactforce|nvpx.getcontactpoint|nvpx.getcontactnode0|nvpx.getcontactnode1|nvpx.setcontactfilter|nvpx.getcontactfilter|nvpx.findsleepingactors|nvpx.getsleepingactor|nvpx.rbbroken|nvpx.printtm|nvpx.printnodeparams|nvpx.ragdollgetrootbone|nvpx.isragdollnode|nvpx.physiqueload|nvpx.physiquegetnumbones|nvpx.physiquegetbone|nvpx.physiquegetnumbonevertices|nvpx.physiquegetbonevertex|nvpx.isconvex|nvpx.calcvolume|nvpx.connectpvd|nvpx.saveclothingtemplate|nvpx.loadclothingtemplate|nvpx.rebuildselectedclothingnode|nvpx.saveapexclothing|nvpx.setbuttoncheck|nvpx.destroyphysx|nvpx.parseskininfo|nvpx.getverticesfromskinnedbone|nvpx.getverticescountfromskinnedbone|nvpx.releaseskininfo|nvpx.havebonefloatlimitcontrol|nvpx.getbonefloatlimitvalue|nvpx.isbone|nvpx.isbiped|nvpx.isbipedroot|nvpx.isbipedfootsteps|nvpx.bipedsetkeys|nvpx.getsolveriterations|nvpx.setsolveriterations|nvpx.createground|nvpx.removeground|nvpx.setrbdisplaymaterial|nvpx.getbonepose|nvpx.loadragdollhelpermesh|nvpx.setnullcm|nvpx.removenullcm|nvpx.readsystemunit|nvpx.copyrigidbody|nvpx.getrbmeshcount|nvpx.getrbmeshtm|nvpx.setrbmeshtm|nvpx.addrbmesh|nvpx.deleterbmesh|nvpx.clipboardcopyrbmesh|nvpx.clipboardpasterbmesh|nvpx.getrbmeshname|nvpx.setrbmeshname|nvpx.getrbmeshtype|nvpx.setrbmeshtype|nvpx.getrbmeshradius|nvpx.setrbmeshradius|nvpx.getrbmeshlength|nvpx.setrbmeshlength|nvpx.getrbmeshwidth|nvpx.setrbmeshwidth|nvpx.getrbmeshheight|nvpx.setrbmeshheight|nvpx.getrbmeshcustomnode|nvpx.setrbmeshcustomnode|nvpx.getrbmeshvertexlimit|nvpx.setrbmeshvertexlimit|nvpx.getrbmeshinflation|nvpx.setrbmeshinflation|nvpx.getrbmeshshape|nvpx.setrbmeshshape|nvpx.getrbmeshoverridemastermat|nvpx.setrbmeshoverridemastermat|nvpx.setmetertosystemunit|nvpx.getmetertosystemunit|nvpx.startindirectdrag|nvpx.onindirectdrag|nvpx.endindirectdrag|nvpx.getobjectclass|nvpx.isapexavailable|nvpx.materialgetcount|nvpx.materialgetid|nvpx.materialgettype|nvpx.materialislocked|nvpx.materialfind|nvpx.materialcreate|nvpx.materialremove|nvpx.materialgetparam|nvpx.materialsetparam|nvpx.ragdollregenerate|nvpx.ragdolladdbone|nvpx.ragdollremovebone|nvpx.ragdollsave|nvpx.ragdollload|nvpx.visualizergetenabled|nvpx.visualizersetenabled|nvpx.visualizergetscale|nvpx.visualizersetscale|nvpx.visualizergetphysxparamcount|nvpx.visualizergetphysxparamname|nvpx.visualizergetphysxparam|nvpx.visualizersetphysxparam|nvpx.visualizergetapexparamcount|nvpx.visualizergetapexparamname|nvpx.visualizergetapexparam|nvpx.visualizersetapexparam|nvpx.getpmvisibleforrigidbodies|nvpx.setpmvisibleforrigidbodies|nvpx.profilerbegin|nvpx.profilerend|nvpx.profilerdump|nvpx.createragdollhelper|nvpx.supportmultithread|nvpx.usemultithread|nvpx.ismultithreadon|nvpx.supporthardwarescene|nvpx.usehardwarescene|nvpx.ishardwaresceneon|nvpx.unittest_materialcreate|nvpx.unittest_materialfind|nvpx.unittest_materialdelete|nvpx.unittest_materialassign|nvpx.unittest_materialpick|nvpx.openhelpfile|nvpx.physxpaneltooltip|nvpx.setccdmotionthreshold|nvpx.getphysxplugincount|nvpx.getphysxpluginversion|nvpx.getphysxpluginversionstring|nvpx.getphysxpluginversionmajor|nvpx.getphysxpluginversionminor|nvpx.getphysxpluginversionbugfix|nvpx.usephysxplugin|nvpx.detachphysx|nvpx.attachphysx|nvpx.getscriptpath|nvpx.isautodeskversion|nvpx.getplugincompanyname|nvpx.setanimationstate|nvpx.getanimationstate|nvpx.createviewer|nvpx.precreateviewer|nvpx.postcreateviewer|nvpx.getpluginbuild|nvpx.showaboutdialog|nvpx.getbehaviorreason|nvpx.setbehaviorreason|nvpx.getbehavioruseselection|nvpx.setbehavioruseselection|nvpx.getbehaviorplaymode|nvpx.setbehaviorplaymode|nvpx.getbakedflag|nvpx.setbakedflag|nvpx.getinitialpose|nvpx.setinitialpose|nvpx.captureinittransforms|nvpx.shouldviewersync|nvpx.getviewercommand|nvpx.setviewercommand|nvpx.checkviewerstate|nvpx.updateviewerplayback|nvpx.getvirtualscreenx|nvpx.getvirtualscreeny|nvpx.dumpcontentcore|nvpx.setshapeperelement|nvpx.createdestruction|nvpx.getexportermode|nvpx.setexportermode|nvpx.togglebomb|nvpx.togglehammer|nvpx.updatedamageforces|nvpx.updateccdctrlstate|nvpx.switchsdkonpaneldata|nvpx.getphysxsdkversion|nvpx.getphysxsdkversionstring|nvpx.getphysxsdkversionmajor|nvpx.getphysxsdkversionminor|nvpx.getphysxsdkversionbugfix|nvpx.getapexsdkversion|nvpx.initializephysx|nvpx.createtoolbar|nvpx.showtoolbar|nvpx.notifybeforefirstframe|nvpx.clearinvalidnodes|nvpx.pausesimulation|nvpx.simulate|nvpx.setsimulationsubsteps|nvpx.simulationreset|nvpx.beforeaddphysxactors|nvpx.setsimulationstate|nvpx.getsimulationstate|nvpx.issimulating|nvpx.exportphysxscene|nvpx.exportphysxprojectfile|nvpx.exportphysxproject|nvpx.prepexportphysxscene|nvpx.prepexportapexclothing|nvpx.prepexportapexdestruction|nvpx.getlinearvelocity|nvpx.getangularvelocity|nvpx.setlinearvelocity|nvpx.setangularvelocity|nvpx.getglobalposition|nvpx.setglobalposition|nvpx.getglobalpose|nvpx.setglobalpose|nvpx.getmass|nvpx.setmass|nvpx.getdynamicfriction|nvpx.getstaticfriction|nvpx.getrestitution|nvpx.setdynamicfriction|nvpx.setstaticfriction|nvpx.setrestitution|nvpx.savematerial|nvpx.loadmaterialdynfric|nvpx.loadmaterialstaticfric|nvpx.loadmaterialbounciness|nvpx.loadmaterialdensity|nvpx.createboundingbox|nvpx.createboundingsphere|nvpx.createboundingcapsule|nvpx.createboundingcapsulefrompoints|nvpx.createboundingshapeconvex|nvpx.createboundingconvex|nvpx.createboundingconvexfromnodes|nvpx.setasdynamic|nvpx.setsleepstate|nvpx.setrbparam|nvpx.getrbparam|nvpx.setrbshapeparam|nvpx.getrbshapeparam|nvpx.setconstraintparam|nvpx.getconstraintparam|nvpx.debugprint|gethashvalue|updatewindow|deletetracker|bindknot|getnumcpvverts|filenamefrompath|dotnet.compareenums|dotnet.gettype|dotnet.removeeventhandler|dotnet.combineenums|dotnet.setlifetimecontrol|dotnet.addeventhandler|dotnet.removealleventhandlers|dotnet.loadassembly|dotnet.showconstructors|dotnet.valuetodotnetobject|dotnet.removeeventhandlers|gepmakeramp|inverse|cos|gettmcontroller|getkeystepspos|getmktargetnames|settoolbtnstate|render|close_enough|setnumtverts|readshort|progressend|setinisetting|bipfilter.angsmoothing|bipfilter.angblurring|bipfilter.angboosting|bipfilter.advangsmoothing|bipfilter.possmoothing|bipfilter.posblurring|bipfilter.posboosting|bipfilter.keyreduction|bipfilter.keyperframe|bipfilter.enablepossubanim|bipfilter.enablerotsubanim|bipfilter.enablescalesubanim|bipfilter.collapsepossubanim|bipfilter.collapserotsubanim|bipfilter.createpossubanim|bipfilter.createrotsubanim|bipfilter.createscalesubanim|bipfilter.dokneewobblefilter|bipfilter.dokneeextensionfilter|invert|getseed|measureoffset|polybsubsurfacemap|vcget2dviewsize|globaloutpoint|quattoeuler|getcursorpos|fileresolutionmanager.getfullfilepath|fileresolutionmanager.getfullfilepath_assetid|fileresolutionmanager.getmaximumcacheduration|fileresolutionmanager.setmaximumcacheduration|fileresolutionmanager.iscachingenabled|fileresolutionmanager.enablecaching|fileresolutionmanager.disablecaching|fileresolutionmanager.dogetuniversalfilename|fileresolutionmanager.getnumcachehit|fileresolutionmanager.getnumassettypes|fileresolutionmanager.getassettypestring|getnumtverts|setfacenormal|gettracker|unbindknot|getsavepath|gepcanmakeramp|isidentity|isolateselection.enterisolateselectionmode|isolateselection.exitisolateselectionmode|isolateselection.isolateselectionmodeactive|isolateselection.isnodeisolated|isolateselection.suppressisolateselectionwarningdialogue|ceil|settrajectoryon|issceneredrawdisabled|getmkkeyindex|getcrossing|setnumfaces|trackselectionsets.remove|trackselectionsets.getcurrent|trackselectionsets.gettracks|trackselectionsets.create|trackselectionsets.setname|trackselectionsets.add|trackselectionsets.delete|trackselectionsets.getname|quatarraytoeulerarray|readbyte|isanimated|progressupdate|getinisetting|surfacearrivebhvr.getstate|surfacearrivebhvr.getpos|setseed|usetup|polybdustmap|vcview2dfullsize|globalinpoint|systemtools.setmaxstdio|systemtools.iswindows98or2000|systemtools.getenvvariable|systemtools.isdebugging|systemtools.iswindows9x|systemtools.getscreenheight|systemtools.getmaxstdio|systemtools.numberofprocessors|systemtools.releasememory|systemtools.getscreenwidth|systemtools.setenvvariable|systemtools.debugprint|systemtools.allocatememory|setnumverts|eulertoquat|removesubrollout|mappoint|gotoframe|updatebindlist|getsavefilename|hair.purge|hair.addmod|hair.addeffect|hair.canuselights|hair.addhairproperties|hair.removehairproperties|hair.exportdra|hair.exportdra2|gepgetdisplaytype|prerotate|listctrl.getactive|listctrl.setname|listctrl.setactive|listctrl.getname|atan|settaskaxisstate|enablesceneredraw|getmkkey|getsnapmode|quadmenusettings.resetdefaults|quadmenusettings.setbordersize|quadmenusettings.getbordersize|quadmenusettings.sethorizontalmargininpoints|quadmenusettings.gethorizontalmargininpoints|quadmenusettings.setverticalmargininpoints|quadmenusettings.getverticalmargininpoints|quadmenusettings.setitemfontface|quadmenusettings.getitemfontface|quadmenusettings.settitlefontface|quadmenusettings.gettitlefontface|quadmenusettings.setitemfontsize|quadmenusettings.getitemfontsize|quadmenusettings.settitlefontsize|quadmenusettings.gettitlefontsize|quadmenusettings.setuseuniformitemheight|quadmenusettings.getuseuniformitemheight|quadmenusettings.setopacity|quadmenusettings.getopacity|quadmenusettings.setdisplaymethod|quadmenusettings.getdisplaymethod|quadmenusettings.setanimatedsteps|quadmenusettings.getanimatedsteps|quadmenusettings.setanimatedsteptime|quadmenusettings.getanimatedsteptime|quadmenusettings.setsubmenupausetime|quadmenusettings.getsubmenupausetime|quadmenusettings.setuselastexecuteditem|quadmenusettings.getuselastexecuteditem|quadmenusettings.setrepositionwhenclipped|quadmenusettings.getrepositionwhenclipped|quadmenusettings.setremoveredundantseparators|quadmenusettings.getremoveredundantseparators|quadmenusettings.setfirstquaddisplayed|quadmenusettings.getfirstquaddisplayed|quadmenusettings.setuseuniformquadwidth|quadmenusettings.getuseuniformquadwidth|quadmenusettings.setmirrorquad|quadmenusettings.getmirrorquad|quadmenusettings.setmovecursoronreposition|quadmenusettings.getmovecursoronreposition|quadmenusettings.setreturncursorafterreposition|quadmenusettings.getreturncursorafterreposition|quadmenusettings.setinitialcursorlocinbox_0to1|quadmenusettings.getinitialcursorlocxinbox_0to1|quadmenusettings.getinitialcursorlocyinbox_0to1|quadmenusettings.settitlebarbackgroundcolor|quadmenusettings.gettitlebarbackgroundcolor|quadmenusettings.settitlebartextcolor|quadmenusettings.gettitlebartextcolor|quadmenusettings.setitembackgroundcolor|quadmenusettings.getitembackgroundcolor|quadmenusettings.setitemtextcolor|quadmenusettings.getitemtextcolor|quadmenusettings.setlastexecuteditemtextcolor|quadmenusettings.getlastexecuteditemtextcolor|quadmenusettings.sethighlighteditembackgroundcolor|quadmenusettings.gethighlighteditembackgroundcolor|quadmenusettings.sethighlighteditemtextcolor|quadmenusettings.gethighlighteditemtextcolor|quadmenusettings.setbordercolor|quadmenusettings.getbordercolor|quadmenusettings.setdisabledshadowcolor|quadmenusettings.getdisabledshadowcolor|quadmenusettings.setdisabledhighlightcolor|quadmenusettings.getdisabledhighlightcolor|isempty|flippeduvwfaces.check|flippeduvwfaces.haspropertydlg|flippeduvwfaces.showpropertydlg|quattoeuler2|getvcface|writestring|progressstart|maxversion|disconnect|osnap|polybdensitymap|vcview2dfittexturetoview|scaledlocaltoglobal|gettoolbtnstate|addsubrollout|isreadonly|unhidesegments|getopenfilename|getnumfaces|reset|loadfile|prescale|eof|asin|setshadecverts|disablesceneredraw|setmkweight|getsnapstate|wsmapplyfc|setvcface|particleflow.getactionorder|particleflow.setactionorder|particleflow.getupdatetype|particleflow.setupdatetype|particleflow.beginedit|particleflow.endedit|particleflow.openparticleview|particleflow.scriptrunner|particleflow.makeunique|particleflow.delete|particleflow.cleanupparticleflow|particleflow.resetparticleview|particleflow.synchronizelayers|particleflow.repaircachesystem|particleflow.presetmanager|writedouble|undisplay|iscompatible|globalmotionclipops.savefile|globalmotionclipops.synthesize|globalmotionclipops.loadfile|setvcurvebyid|vcpastefromclipboard|polybcavitymap|vcview2dwiretoggle|globaltoscaledlocal|flexops.clearedgevertices|flexops.getnumbervertices|flexops.setvertexweights|flexops.getvertexweight|flexops.setedgevertices|flexops.selectvertices|flexops.isedgevertex|displaycontroldialog|unregisterdisplayfiltercallback|setindexedproperty|hideselectedsegments|globalvars.remove|globalvars.isglobal|globalvars.gather|globalvars.getvaluetag|globalvars.get|globalvars.gettypetag|globalvars.set|getnumverts|flushlog|prerotatez|acos|setrottaskweight|clearnodeselection|getmkweight|setsyscur|wsmsupportsforce|setfaceselection|gettvface|writefloat|polyop.setedatachannelsupport|polyop.setmapface|polyop.capholesbyedge|polyop.cutface|polyop.capholesbyvert|polyop.getsliceplane|polyop.getborderfromedge|polyop.setfaceflags|polyop.setfaceselection|polyop.getvdatachannelsupport|polyop.getmapsupport|polyop.divideedge|polyop.setfacesmoothgroup|polyop.unhideallverts|polyop.collapsedeadstructs|polyop.getvertsusingedge|polyop.getvertflags|polyop.setedatavalue|polyop.applyuvwmap|polyop.createshape|polyop.movefacestoplane|polyop.chamferverts|polyop.getvert|polyop.getfaceverts|polyop.getdeadfaces|polyop.getnumfaces|polyop.freevdata|polyop.setnummapfaces|polyop.meshsmoothbyedge|polyop.collapsefaces|polyop.meshsmoothbyvert|polyop.forcesubdivision|polyop.getedgesusingface|polyop.getedgeflags|polyop.setvertselection|polyop.setvertcolor|polyop.chamferedges|polyop.deleteedges|polyop.deletefaces|polyop.deleteverts|polyop.getfacecenter|polyop.isedgedead|polyop.gethiddenfaces|polyop.resetedata|polyop.getnumedatachannels|polyop.getmapvert|polyop.cutedge|polyop.detachfaces|polyop.flipnormals|polyop.cutvert|polyop.resetsliceplane|polyop.ismeshfilledin|polyop.getfaceflags|polyop.getfaceselection|polyop.setvdatachannelsupport|polyop.setmapsupport|polyop.weldedges|polyop.unhideallfaces|polyop.createvert|polyop.getfacearea|polyop.getfacesusingvert|polyop.getvertsbyflag|polyop.getedatavalue|polyop.defaultmapfaces|polyop.moveedgestoplane|polyop.makefacesplanar|polyop.movevertstoplane|polyop.insliceplanemode|polyop.getedgefaces|polyop.getdeadedges|polyop.getnumedges|polyop.setvdatavalue|polyop.getnummapverts|polyop.splitedges|polyop.divideface|polyop.collapseverts|polyop.deleteisoverts|polyop.getvertsusingface|polyop.getedgesbyflag|polyop.getvertselection|polyop.setfacecolor|polyop.setedgevis|polyop.bevelfaces|polyop.setfacematid|polyop.movevert|polyop.getfacedeg|polyop.isfacedead|polyop.sethiddenverts|polyop.setnumedatachannels|polyop.setmapvert|polyop.detachedges|polyop.tessellatebyface|polyop.detachverts|polyop.fillinmesh|polyop.getvertsusedonlybyfaces|polyop.getfacesbyflag|polyop.setedgeselection|polyop.getnumvdatachannels|polyop.getnummaps|polyop.weldedgesbythreshold|polyop.createpolygon|polyop.weldverts|polyop.getfacenormal|polyop.getedgesusingvert|polyop.getopenedges|polyop.getedatachannelsupport|polyop.getmapface|polyop.makeedgesplanar|polyop.capholesbyface|polyop.autosmooth|polyop.makevertsplanar|polyop.setsliceplane|polyop.getedgeverts|polyop.getdeadverts|polyop.getnumverts|polyop.getvdatavalue|polyop.setnummapverts|polyop.collapseedges|polyop.getfacesmoothgroup|polyop.breakverts|polyop.attach|polyop.getfacesusingedge|polyop.setvertflags|polyop.freeedata|polyop.getvertsbycolor|polyop.getedgevis|polyop.extrudefaces|polyop.slice|polyop.getfacematid|polyop.setvert|polyop.getfaceedges|polyop.gethasdeadstructs|polyop.gethiddenverts|polyop.resetvdata|polyop.getnummapfaces|polyop.tessellatebyedge|polyop.meshsmoothbyface|polyop.retriangulate|polyop.tessellatebyvert|polyop.propagateflags|polyop.getelementsusingface|polyop.setedgeflags|polyop.getedgeselection|polyop.setnumvdatachannels|polyop.setnummaps|polyop.createedge|polyop.setdiagonal|polyop.weldvertsbythreshold|polyop.getsafefacecenter|polyop.isvertdead|polyop.sethiddenfaces|iscreatingobject|setvcurve|terrainops.deleteoperand|terrainops.update|terrainops.addoperand|terrainops.setoperandtm|terrainops.getoperand|terrainops.getoperandtm|vccreatetoolbuttonimage|editpolymodreadytobridge|vcsetusingnewtexture|globaltolocal|getxyzcontrollers|registerdisplayfiltercallback|getindexedproperty|getfaceselection|hideselectedsplines|closelog|selectbitmap|prerotatey|exp|setrenderid|flashnodes|setmktime|getmatlibfilename|setedgeselection|wsmsupportscollision|settvface|assertreporter.clear|assertreporter.getexceptionfailures|assertreporter.logmessage|assertreporter.getuserdata|assertreporter.getassertfailurescount|assertreporter.getmessages|assertreporter.logassertfailure|assertreporter.getassertfailures|assertreporter.setuserdata|assertreporter.getexceptionfailurescount|assertreporter.logexception|writelonglong|startobjectcreation|getvcurveid|vcisleftbuttondown|polybmodeloopring|idleareasubtractarea|localtoglobal|getedgeselection|amax|unregisterselectfiltercallback|setupevents|crop|openedges.check|openedges.haspropertydlg|openedges.showpropertydlg|hideselectedverts|openlog|openbitmap|prerotatex|setvertselection|attachctrl.update|attachctrl.addnewkey|attachctrl.getkey|abs|setrenderable|fencepicknode|getmktime|createpreview|getface|writelong|addpluginrollouts|getvertselection|getvcurve|vclayersettingchangestart|polybsetsel|idleareaaddarea|scaledlocaltolocal|amin|registerselectfiltercallback|showallactivexcontrols|camerafov.fovtomm|camerafov.fovtocurfov|camerafov.mmtofov|camerafov.curfovtofov|setoutvec|objxrefs.addnewxrefobject|objxrefs.getnumxrefobjects|objxrefs.getxrefobject|objxrefs.getnumfiles|objxrefs.reloadfile|objxrefs.isfileunresolved|objxrefs.isfiledisabled|objxrefs.getallxrefobjects|objxrefs.getemptyxrefreccount|objxrefs.getfilename|format|pretranslate|random|setpostaskweight|circlepicknode|deleteallchangehandlers|hdiksys.ikchain|hdiksys.removechain|setface|writeshort|meshop.supportvertweights|meshop.makemapplanar|meshop.setmapface|meshop.removeillegalfaces|meshop.getbubble|meshop.setssedgedist|meshop.getsubdivisionminlevels|meshop.setsubdivisiondisplacement|meshop.getvdatachannelsupport|meshop.supportvertcorners|meshop.getmapvertsusingmapface|meshop.getmapsupport|meshop.divideedge|meshop.explodefaces|meshop.getvertexangles|meshop.getvertsusingedge|meshop.setshowfnormals|meshop.getignorevisedges|meshop.setsubdivisionsteps|meshop.getnumtverts|meshop.resetvselectweights|meshop.deleteisomapverts|meshop.applyuvwmap|meshop.getvert|meshop.chamferverts|meshop.explodeallfaces|meshop.setweldthreshold|meshop.getweldpixels|meshop.setsubdivisionmaxlevels|meshop.getsubdivisionmethod|meshop.getnumfaces|meshop.freevdata|meshop.resetvalphas|meshop.getvertweight|meshop.setnummapfaces|meshop.cloneedges|meshop.collapsefaces|meshop.getfacernormals|meshop.getedgesusingface|meshop.getfalloff|meshop.setsoftsel|meshop.getsubdivisiondistance|meshop.setnumcpvverts|meshop.getvertcorner|meshop.setvertcolor|meshop.freemapverts|meshop.chamferedges|meshop.deleteedges|meshop.deletefaces|meshop.unifynormals|meshop.deleteverts|meshop.getfacecenter|meshop.getpolysusingvert|meshop.setextrusiontype|meshop.getselbyvertex|meshop.setsubdivisionstyle|meshop.gethiddenfaces|meshop.getuiparam|meshop.freevertweights|meshop.getmapvert|meshop.extrudeedges|meshop.detachfaces|meshop.flipnormals|meshop.removedegeneratefaces|meshop.setpinch|meshop.getssedgedist|meshop.setsubdivisionangle|meshop.getsubdivisiondisplacement|meshop.setvdatachannelsupport|meshop.freevertcorners|meshop.getmapfacesusingmapvert|meshop.setmapsupport|meshop.dividefaces|meshop.getfacearea|meshop.getedgesreverseedge|meshop.getfacesusingvert|meshop.getshowfnormals|meshop.setignorebackfacing|meshop.getsubdivisionsteps|meshop.setnumfaces|meshop.setvselectweight|meshop.getisomapverts|meshop.defaultmapfaces|meshop.makefacesplanar|meshop.movevertstoplane|meshop.cut|meshop.getweldthreshold|meshop.setaffectbackfacing|meshop.getsubdivisionmaxlevels|meshop.setsplitmesh|meshop.setvdatavalue|meshop.setvalpha|meshop.setvertalpha|meshop.getnummapverts|meshop.turnedge|meshop.divideface|meshop.deleteisoverts|meshop.getisoverts|meshop.getvertsusingface|meshop.setplanarthreshold|meshop.getsoftsel|meshop.setsubdivisionedge|meshop.getnumcpvverts|meshop.supportvselectweights|meshop.setfacecolor|meshop.deletemapvertset|meshop.bevelfaces|meshop.movevert|meshop.cloneverts|meshop.setnormalsize|meshop.getextrusiontype|meshop.setsubdivisionmaxtriangles|meshop.getsubdivisionstyle|meshop.sethiddenverts|meshop.supportvalphas|meshop.resetvertweights|meshop.setmapvert|meshop.edgetessellate|meshop.detachverts|meshop.minvertexdistancesfrom|meshop.getvertsusedonlybyfaces|meshop.getpinch|meshop.setssuseedgedist|meshop.getsubdivisionangle|meshop.setdisplacementmapping|meshop.getnumvdatachannels|meshop.resetvertcorners|meshop.freemapchannel|meshop.getnummaps|meshop.clonefaces|meshop.createpolygon|meshop.getpolysusingface|meshop.getedgesusingvert|meshop.setshowvnormals|meshop.getignorebackfacing|meshop.setsubdivisionview|meshop.setnumverts|meshop.getopenedges|meshop.getvselectweight|meshop.buildmapfaces|meshop.getmapface|meshop.autosmooth|meshop.makevertsplanar|meshop.optimize|meshop.setbubble|meshop.getaffectbackfacing|meshop.setsubdivisionminlevels|meshop.getsplitmesh|meshop.getnumverts|meshop.setuiparam|meshop.getvdatavalue|meshop.getvalpha|meshop.setfacealpha|meshop.setnummapverts|meshop.collapseedges|meshop.autoedge|meshop.breakverts|meshop.attach|meshop.getbarycoords|meshop.getfacesusingedge|meshop.getplanarthreshold|meshop.setignorevisedges|meshop.getsubdivisionedge|meshop.setnumtverts|meshop.freevselectweights|meshop.getvertsbycolor|meshop.deleteisomapvertsall|meshop.slice|meshop.extrudefaces|meshop.setvert|meshop.weldvertset|meshop.getnormalsize|meshop.setweldpixels|meshop.getsubdivisionmaxtriangles|meshop.setsubdivisionmethod|meshop.gethiddenverts|meshop.freevalphas|meshop.setvertweight|meshop.getnummapfaces|meshop.divideedges|meshop.minvertexdistancefrom|meshop.getelementsusingface|meshop.setfalloff|meshop.getssuseedgedist|meshop.setsubdivisiondistance|meshop.getdisplacementmapping|meshop.setnumvdatachannels|meshop.setvertcorner|meshop.freemapfaces|meshop.setnummaps|meshop.dividefacebyedges|meshop.weldvertsbythreshold|meshop.getpolysusingedge|meshop.getshowvnormals|meshop.setselbyvertex|meshop.getsubdivisionview|meshop.sethiddenfaces|clearallappdata|biped.getxtraopposite|biped.createtwistpose|biped.getclaviclevals|biped.setkey|biped.loadcopypastefile|biped.createpossubanims|biped.setlimbretargetstate|biped.maxtwistlinks|biped.savebipedbaseanimationlayer|biped.deletekeys|biped.geteuleractive|biped.mirror|biped.pastefrombuffer|biped.pastebipposture|biped.copyposture|biped.deleteprefclip|biped.getlayeractive|biped.getmultiplefsparams|biped.loadfignotwists|biped.setxtraname|biped.setdefaulttwistposes|biped.getpelvisval|biped.setslidingkey|biped.getcopycollection|biped.setpossubanim|biped.retargettobaselayer|biped.converttofreeform|biped.loadmocapfile|biped.movekeys|biped.setquaternionactive|biped.zerotwist|biped.getrotparentnode|biped.pasteposturetoxtras|biped.numcopies|biped.numprefclips|biped.setlayername|biped.maxnumnodes|biped.savebipfile|biped.settwistposebias|biped.getverticalcontrol|biped.collapsemoveallmode|biped.deleteallcopycollections|biped.collapseallpossubanims|biped.numlayers|biped.savetalentposefile|biped.savebipfiledlg|biped.creatextraopposite|biped.numtwistposes|biped.getparentnodepos|biped.getikactive|biped.setcopyname|biped.getclipattime|biped.getlimbretargetstate|biped.maxtwistnodes|biped.savebipedanimationlayer|biped.addnewkey|biped.createnew|biped.gettwistposebias|biped.clearselectedanimation|biped.convertfrombuffer|biped.copybiptrack|biped.collapserotsubanims|biped.addprefclip|biped.collapseatlayer|biped.addmultiplefootprints|biped.loadfigfile|biped.attachxtra|biped.deletetwistpose|biped.gethorseankleval|biped.setplantedkey|biped.numcopycollections|biped.createscalesubanims|biped.setretargetrefbip|biped.dosetmultiplekeysdlg|biped.loadbipedbaseanimationlayer|biped.deselectkeys|biped.seteuleractive|biped.setsnapkey|biped.getidlink|biped.pastebiptrack|biped.deleteallcopies|biped.getcurrentclip|biped.getlayername|biped.getnode|biped.savebipfilesegment|biped.settwistposetwist|biped.gethorizontalcontrol|biped.resetalllimbkeys|biped.deletecopycollection|biped.setscalesubanim|biped.gettransform|biped.unifymotion|biped.savetalentfigfile|biped.loadbipfiledlg|biped.getxtraname|biped.creatextra|biped.smoothtwist|biped.getparentnoderot|biped.setcurrentcopycollection|biped.getcopyname|biped.getprefclipprob|biped.settransform|biped.setcurrentlayer|biped.gettwiststartid|biped.savestpfile|biped.getkey|biped.gettwistposetwist|biped.clearallanimation|biped.scalefootprints|biped.copybippose|biped.collapsepossubanims|biped.clearprefclips|biped.deletelayer|biped.addfootprint|biped.loadstpfile|biped.deletextra|biped.settwistpose|biped.gethingeval|biped.setselectedkey|biped.savecopypastefile|biped.createrotsubanims|biped.getretargetrefbip|biped.setmultiplekeys|biped.loadbipedanimationlayer|biped.selectkeys|biped.geteulerorder|biped.mirrorinplace|biped.getcurrentrange|biped.pastebippose|biped.pasteposture|biped.isprefclip|biped.setlayeractive|biped.newfootprintkeys|biped.loadfigjusttwists|biped.settwistposename|biped.getfingerval|biped.setfreekey|biped.createcopycollection|biped.setrotsubanim|biped.retargettoreferencebiped|biped.converttofootsteps|biped.adjusttalentpose|biped.displayprefsdlg|biped.seteulerorder|biped.zeroall|biped.getposparentnode|biped.pastetracktoxtras|biped.deletecopy|biped.getprefclip|biped.getcurrentlayer|biped.maxnumlinks|biped.savefigfile|biped.gettwistposename|biped.getturncontrol|biped.bendfootprints|biped.copybipposture|biped.collapseallrotsubanims|biped.createlayer|biped.multiplefsdlg|biped.loadbipfile|appendvcurvebyid|vcloadbitmapintolayer|polybgetsel|idleareacreatefreeform|localtoscaledlocal|insertitem|unregisterredrawviewscallback|getoutvec|scale|filein|reactionmgr.openeditor|rotatez|setmotblur|boxpicknode|deletechangehandler|setnormal|writebyte|deleteappdata|appendvcurve|vcfillinbitmap|polybvalidobject|idleareacreatecircle|registry.getsubkeynames|registry.queryvalue|registry.flushkey|registry.isparentkeyopen|registry.createkey|registry.getsubkeyname|registry.setvalue|registry.getvaluenames|registry.closekey|registry.iskeyopen|registry.deletekey|registry.getparentkey|registry.deletevalue|registry.getvaluename|registry.queryinfokey|registry.deletesubkey|registry.getlasterror|registry.iskeyconstant|registry.openkey|bsearch|registerredrawviewscallback|persistents.remove|persistents.removeall|persistents.gather|persistents.ispersistent|persistents.show|persistents.make|rendermap|retimerman.getglobalretimer|retimerman.getnthretimer|retimerman.createretimer|retimerman.deleteretimer|retimerman.bakeanddeletelocalretimers|addnewkey|length|setinvec|rotatey|sysinfo.getlanguage|sysinfo.getmaxmemoryinfo|sysinfo.getmaxlanguage|sysinfo.getsystemmemoryinfo|setinheritvisibility|deselectnode|scaleclip|getkey|getnormal|fflush|skinops.scaleweight|skinops.mirrorpastebone|skinops.getselectedbone|skinops.addbone|skinops.setselectedboneproprelative|skinops.loadenvelope|skinops.rigidvertex|skinops.growselection|skinops.removezeroweights|skinops.selectpreviousbone|skinops.getvertexweightcount|skinops.getnumbervertices|skinops.setbonepropfalloff|skinops.selectendpoint|skinops.getnumberofgizmos|skinops.pasteweightsbypos|skinops.updatemirror|skinops.getouterradius|skinops.getcrosssectionu|skinops.getselectedbonepropenvelopevisible|skinops.buttoninclude|skinops.gizmoresetrotationplane|skinops.ringselection|skinops.selectnextsibling|skinops.multiremove|skinops.setvertexweights|skinops.getvertexweightboneid|skinops.resetselectedbone|skinops.copyselectedbone|skinops.getselectedgizmotype|skinops.bakeselectedverts|skinops.closeweighttool|skinops.blendselected|skinops.isvertexselected|skinops.setendpoint|skinops.setboneproprelative|skinops.buttonadd|skinops.buttoncopygizmo|skinops.addweight|skinops.mirrorpaste|skinops.selectbone|skinops.removebone|skinops.pastetobone|skinops.saveenvelopeasascii|skinops.isrigidvertex|skinops.buttonweighttable|skinops.closeweighttable|skinops.getselectedcrosssectionisinner|skinops.selectnextbone|skinops.getnumberbones|skinops.getbonepropenvelopevisible|skinops.buttonremovecrosssection|skinops.getselectedgizmo|skinops.pasteweights|skinops.setmirrortm|skinops.getinnerradius|skinops.removecrosssection|skinops.setselectedbonepropenvelopevisible|skinops.buttonexclude|skinops.unnormalizevertex|skinops.loopselection|skinops.selectparent|skinops.addbonefromviewend|skinops.getvertexweight|skinops.getbonenamebylistid|skinops.resetselectedverts|skinops.selectcrosssection|skinops.selectgizmotype|skinops.invalidate|skinops.isweighttoolopen|skinops.pasteallverts|skinops.setouterradius|skinops.getendpoint|skinops.getselectedbonepropfalloff|skinops.buttonpaint|skinops.buttonremovegizmo|skinops.weighttool|skinops.paintoptionsbutton|skinops.isvertexmodified|skinops.isboneselected|skinops.pastetoallbones|skinops.saveenvelope|skinops.rigidhandle|skinops.isweighttableopen|skinops.getselectedcrosssectionindex|skinops.zoomtogizmo|skinops.setstartpoint|skinops.setbonepropenvelopevisible|skinops.buttonaddcrosssection|skinops.selectgizmo|skinops.copyweights|skinops.selectmirrorbones|skinops.getnumbercrosssections|skinops.addcrosssection|skinops.getselectedboneproprelative|skinops.loadenvelopeasascii|skinops.isunnormalizevertex|skinops.shrinkselection|skinops.selectchild|skinops.addbonefromviewstart|skinops.selectvertices|skinops.getbonename|skinops.getbonepropfalloff|skinops.selectstartpoint|skinops.enablegizmo|skinops.selectbonebynode|skinops.pasteallbones|skinops.setinnerradius|skinops.setcrosssectionu|skinops.setselectedbonepropfalloff|skinops.buttonselectexcluded|skinops.buttonaddgizmo|skinops.selectverticesbybone|skinops.setweight|skinops.selectprevioussibling|skinops.paintweightsbutton|skinops.replacevertexweights|skinops.resetallbones|skinops.pastetoselectedbone|skinops.getnumberofgizmotypes|skinops.isrigidhandle|skinops.weighttable|skinops.setselectedcrosssection|skinops.zoomtobone|skinops.getstartpoint|skinops.getboneproprelative|skinops.buttonremove|skinops.buttonpastegizmo|setappdata|resetlattice|createfile|modpanel.setpinstack|modpanel.ispinstackenabled|modpanel.setcurrentobject|modpanel.addmodtoselection|modpanel.validmodifier|modpanel.getmodifierindex|modpanel.getpinstack|modpanel.getcurrentobject|setucurvebyid|vcsavepsd|polybpolyshiftsettings|idleareacreaterectangle|qsort|daylightsimulationuiops.refresh|unregisterallrightclickmenus|encryptscript|getinvec|uiaccessor.getwindowtext|uiaccessor.getwindowclassname|uiaccessor.getwindowresourceid|uiaccessor.getchildwindows|uiaccessor.getpopupdialogs|uiaccessor.getparentwindow|uiaccessor.getfirstchildwindow|uiaccessor.getprevwindow|uiaccessor.getnextwindow|uiaccessor.iswindow|uiaccessor.getwindowdllfilename|uiaccessor.getwindowdlldescription|uiaccessor.sendmessage|uiaccessor.closedialog|uiaccessor.pressdefaultbutton|uiaccessor.pressbutton|uiaccessor.pressbuttonbyname|uiaccessor.setwindowtext|uiaccessor.sendmessageid|rotatex|linkctrl.addlink|linkctrl.setlinktime|linkctrl.getlinknode|linkctrl.getlinktime|linkctrl.deletelink|linkctrl.setlinknode|linkctrl.getlinkcount|setimageblurmultiplier|getuseenvironmentmap|moveclip|defaultvcfaces|ftell|getappdata|animateall|openfile|setucurve|vccolorbalance|polybpolyshiftreset|crowdpathsetdefaultwidth|updatemtlinmedit|unregisterrightclickmenu|getviewfov|trackviews.zoomon|trackviews.clearfilter|trackviews.isopen|trackviews.exists|trackviews.picktrackdlg|trackviews.gettrackviewname|trackviews.open|trackviews.numtrackviews|trackviews.delete|trackviews.close|trackviews.setfilter|trackviews.iscurrent|trackviews.setcurrent|trackviews.gettrackview|trackviews.getallopentrackviews|trackviews.zoomselected|trackviews.openlastusedtrackview|wm3_movemorph|copypastekeys|getknotpoint|steeringwheelsops.saveoptions|steeringwheelsops.clearrewindhistory|steeringwheelsops.startsteeringwheelmode|steeringwheelsops.stopsteeringwheelmode|steeringwheelsops.miniviewobjectwheel|steeringwheelsops.minitourbuildingwheel|steeringwheelsops.minifullnavwheel|steeringwheelsops.fullnavwheel|steeringwheelsops.viewobjectwheel|steeringwheelsops.tourbuildingwheel|steeringwheelsops.increasewalkspeed|steeringwheelsops.decreasewalkspeed|steeringwheelsops.restorecenter|draganddrop.isenabled|draganddrop.enabledraganddrop|draganddrop.droppackage|draganddrop.downloadpackage|draganddrop.getdownloaddirectory|draganddrop.downloadurltodisk|draganddrop.importcontextnode|draganddrop.globalenabledraganddrop|translate|setimageblurmultcontroller|setuseenvironmentmap|appendmaxclip|snapmode.getosnapnumitems|snapmode.getosnapitemactive|snapmode.getosnapname|snapmode.getosnapitemtooltip|snapmode.setosnapitemactive|snapmode.getosnapitemname|stoptool|buildvcfaces|fseek|showsource|setdimensions|stopanimation|getucurveid|vcthreshold|polyshiftsetupconformnormals|crowddorestartpathtool|assetmanager.addreference|assetmanager.releasereference|assetmanager.getnumreference|assetmanager.getnumassetuserscreated|assetmanager.getnumassetusers|assetmanager.getnumassetscreated|assetmanager.getnumassets|assetmanager.getassetid|assetmanager.getasset|assetmanager.getassetbyindex|assetmanager.getfilename|setmtlmedittiling|registerrightclickmenu|getviewsize|wm3_swapmorph|assignkey|setknotpoint|isclosed|assert_matrix_equal|lightingunits.islightingsystemsi|lightingunits.islightingsystemas|lightingunits.setlightingsystemtosi|lightingunits.setlightingsystemtoas|lightingunits.getluminanceunits|lightingunits.getilluminanceunits|lightingunits.convertastosi|lightingunits.convertsitoas|lightingunits.converttocurrentsystem|orthogonalize|setcvertmode|getbkgframenum|gettrackinterval|starttool|buildtvfaces|fclose|getsubanimnames|getdimensions|playanimation|getucurve|vcnormalize|polybshiftsetup|crowdpathextend|getmtlmedittiling|bipworkbench.toggleshowx|bipworkbench.getshowx|bipworkbench.toggleshowy|bipworkbench.getshowy|bipworkbench.toggleshowz|bipworkbench.getshowz|bipworkbench.togglelayeredit|bipworkbench.getlayeredit|bipworkbench.toggledrawduringmove|bipworkbench.getdrawduringmove|bipworkbench.togglelimit180|bipworkbench.getlimit180|bipworkbench.showquatcurve|bipworkbench.showposcurve|bipworkbench.showangspeedcurve|bipworkbench.showangaccelcurve|bipworkbench.showangjerkcurve|bipworkbench.showposspeedcurve|bipworkbench.showposaccelcurve|bipworkbench.showposjerkcurve|bipworkbench.poscurvetoworld|bipworkbench.poscurvetobiproot|bipworkbench.poscurvetothisnode|bipworkbench.open|bipworkbench.showquatxyz|bipworkbench.showquatxzy|bipworkbench.showquatyxz|bipworkbench.showquatyzx|bipworkbench.showquatzxy|bipworkbench.showquatzyx|getviewtm|mousetrack|wm3_deleteprogressivemorphnode|appendkey|setfirstknot|assert_point3_equal|zero|getrendertype|isboneonly|getbkgsyncframe|optimizecliptransition|swap|fopen|getsubanimname|conformtoshape|quitmax|appenducurvebyid|vcmedian|polybpolyshift|crowdareagetnode|setvertcolor|setmtlmeditobjtype|getcptm|wm3_addprogressivemorphnode|clear|colorman.getcolor|colorman.setcolor|colorman.getcolorschemetype|colorman.setcolorschemetype|colorman.registercolor|colorman.loadcolorfile|colorman.savecolorfile|colorman.getcolorfile|colorman.getname|colorman.getcategory|colorman.geticoncolorscale|colorman.seticoncolorscale|colorman.geticoncolorinvert|colorman.seticoncolorinvert|colorman.getfilename|colorman.getdefaultcolor|colorman.repaintui|colorman.seticonfolder|colorman.reiniticons|colorman.geticonfolder|colorman.resolveiconfolder|assert_string_equal|identity|setrendertype)\b/i, null],
		 ['kwd3', /^(?:gettrajectoryon|setbkgsyncframe|optimizetransitions|validatereferencemakerrefs|refinesegment|getsubanim|mszip.fileinpackage|mszip.unloadpackage|setmeditmaterial|appenducurve|vcjitter|polybpolydrawsplines|crowdareagetactivetool|numknots|iskindof|mental_ray_string_options.addoption|mental_ray_string_options.removeoption|mental_ray_string_options.getoptionstring|mental_ray_string_options.getoptionvalue|getmtlmeditobjtype|multipleedges.check|multipleedges.haspropertydlg|multipleedges.showpropertydlg|mapscreentocp|geteulermatangleratio|wm3_getprogressivemorphnode|delegates.spheredisplay|delegates.iscomputing|delegates.computingbiped|delegates.speed|delegates.velocity|delegates.linedisplay|delegates.textdisplay|delegates.startvelocity|delegates.reacttome|delegates.isassignmentactive|delegates.bboxdisplay|delegates.prevvelocity|delegates.simtransform|assert_float|xformmat|getdisplayfiltername|gettaskaxisstate|getbkgstarttime|getclip|invaltrack|getcurrentexception|assetbrowser.gotourl|assetbrowser.open|setmaxfileassetmetadata|getsegmenttype|exprformaxobject|getmeditmaterial|setedge|vchighpass|polybpolydrawpolybranch|crowdareasetconstriant|superclassof|setmtlmeditflags|mapscreentoview|geteulerquatangleratio|wm3_setprogressivemorphweight|enableorts|numpoints|assert_undefined|inversehighprecision|getselectfiltername|getshadecverts|setbkgstarttime|appendclip|globaldxdisplaymanager.isdxactive|showtrack|close|getmaxfileassetmetadata|setsegmenttype|apropos|savetempmateriallibrary|displaymanager.isenabled|getedge|vcfindedges|polybpolydrawpolystrips|crowdareagetconstriant|classof|getmtlmeditflags|overlappingvertices.check|overlappingvertices.haspropertydlg|overlappingvertices.showpropertydlg|mapscreentoworldray|getpatchsteps|wm3_getprogressivemorphweight|setafterort|cmdpanel.getrollupthreshold|cmdpanel.setrollupthreshold|tabbeddialogs.ispage|tabbeddialogs.getnumpages|tabbeddialogs.setcurrentpage|tabbeddialogs.isopen|tabbeddialogs.oktocommit|tabbeddialogs.canceldialog|tabbeddialogs.getcurrentpage|tabbeddialogs.invalidate|tabbeddialogs.getpagetitle|tabbeddialogs.closedialog|tabbeddialogs.getpageid|tabbeddialogs.getdialogid|tabbeddialogs.invalidatepage|tabbeddialogs.commitpages|assert_defined|deletepoint|rotateyprmatrix|getnumberdisplayfilters|getrottaskweight|merge|getbkgortype|cleartrack|setstruct|timegettime|getd3dtimer|getknottype|deletekey|setproperty|loadtempmateriallibrary|setparentid|vcsharpenlayer|polybpolydrawpolyshapes|crowdareasetcirclesides|setpatchsteps|wm3_setprogressivemorphtension|setbeforeort|getvertcolor|assert_not_equal|insertpoint|scalematrix|getdisplayfilter|getrenderid|setbkgortype|gettrackgroupinterval|setfade|getactivecamera|getsimilarnodes|setnumberthreads|setknottype|getproperty|schematicview.getschematicviewname|schematicview.numschematicviews|schematicview.open|schematicview.close|schematicview.zoomselected|savemateriallibrary|channelinfo.ischecked|channelinfo.namechannel|channelinfo.namesubchannel|channelinfo.update|channelinfo.dialog|channelinfo.copychannel|channelinfo.copysubchannel|channelinfo.pastechannel|channelinfo.pastesubchannel|channelinfo.addchannel|channelinfo.clearchannel|channelinfo.closedialog|setparent|vcblurlayer|polybpolydrawpolysurf|crowdareagetcirclesides|matrixfromnormal|wm3_getprogressivemorphtension|getafterort|assert_equal|setselectedpts|transmatrix|setdisplayfilter|getpostaskweight|getbkgrangeval|deletetrack|resetzoom|atscustomdepsops.addfile|atscustomdepsops.setfile|atscustomdepsops.removefilebyindex|atscustomdepsops.removefilebyname|atscustomdepsops.removeall|atscustomdepsops.getfiles|atscustomdepsops.launchdialog|atscustomdepsops.numfiles|oneclickrevit.requestviews|getsourcefileoffset|isdirectorywriteable|getanimbyhandle|deleteknot|gettvert|createinstance|loadmateriallibrary|getparentid|vcfliplayer|polybpolydrawtopo|crowdareasetbrushsizepath|refs.getreference|refs.getindirectreference|refs.dependentnodes|refs.getnumrefs|refs.getnumindirectrefs|refs.dependents|refs.setindirectreference|refs.dependencylooptest|refs.replacereference|refs.dependson|averageselvertnormal|wm3_numberofprogressivemorphs|getbeforeort|actionman.executeaction|actionman.loadkeyboardfile|actionman.savekeyboardfile|actionman.getkeyboardfile|actionman.getactiontable|assert_false|getselectedpts|rotatezmatrix|getnumberselectfilters|flightstudioexport.getmatrixepsilon|flightstudioexport.setmatrixepsilon|flightstudioexport.getautogroup|flightstudioexport.setautogroup|flightstudioexport.getautoobject|flightstudioexport.setautoobject|flightstudioexport.getcopytextures|flightstudioexport.setcopytextures|getinheritvisibility|setbkgframerange|inserttrack|loadframes|normtime|getthisscriptfilename|getfilesecurityinfo|qat.swap|qat.add|qat.delete|gethandlebyanim|addknot|settvert|isproperty|getmaxfileversiondata|getparent|vcapplyimage|polybpolydrawoptimizer|crowdareagetbrushsizepath|averageselvertcenter|wm3_setmarkerdata|getmultipliervalue|assert_true|pluginmanager.plugindllname|pluginmanager.plugindlldirectory|pluginmanager.plugindllfullpath|pluginmanager.plugindllsize|pluginmanager.isplugindllloaded|pluginmanager.loadplugindll|pluginmanager.loadclass|rotateymatrix|getselectfilter|getimageblurmultcontroller|getbkgimageanimate|appendtrack|print|perspectivematch|getsourcefilename|usedmaps|hasproperty|exportfile|setedgevis|reparameterize|vcinvertlayer|polybpolydrawmove|crowdareasetbrushsize|getvalue|deselecthiddenfaces|wm3_getmarkername|nummultipliercurves|atsops.getdependentfiles|atsops.isinputfile|atsops.selectfiles|atsops.getfiles|atsops.numfiles|atsops.showpromptsdialog|atsops.showworkingcommentdialog|atsops.showstatuslogdialog|atsops.numproviders|atsops.getprovidername|atsops.getactiveprovider|atsops.setactiveprovider|atsops.login|atsops.logout|atsops.openproject|atsops.closeproject|atsops.setworkingfolder|atsops.getworkingfolder|atsops.isfileexcluded|atsops.isfilesharelocked|atsops.isinitialized|atsops.isprojectopen|atsops.launchoptions|atsops.launchprovider|atsops.openfromvault|atsops.getfromprovider|atsops.testfilestatus|atsops.getfilestatus|atsops.getfilesbystatus|atsops.getfilesbyfilesystemstatus|atsops.testfilesystemstatus|atsops.getfilesystemstatus|atsops.getresolvedpaths|atsops.getdependencyfilelist|atsops.checkin|atsops.checkout|atsops.undocheckout|atsops.getlatest|atsops.getminversion|atsops.getmaxversion|atsops.getversion|atsops.addfiles|atsops.properties|atsops.showhistory|atsops.cancheckin|atsops.cancheckout|atsops.canundocheckout|atsops.cangetlatest|atsops.canaddfiles|atsops.canproperties|atsops.canshowhistory|atsops.cangetfromprovider|atsops.checkfordependentfiles|atsops.checkforcheckedoutfiles|atsops.checkforuncontrolledfiles|atsops.checkforoutdatedfiles|atsops.checkforscenefilecheckout|atsops.setworkingcomment|atsops.getworkingcomment|atsops.appendstatuslog|atsops.clearstatuslog|atsops.getstatuslog|atsops.clearselection|atsops.numfilesselected|atsops.getselectedfiles|atsops.registernotification|atsops.unregisternotification|atsops.refresh|atsops.getnotificationid|atsops.getnotificationproviderindex|atsops.getnotificationfilelist|atsops.addattachmenttonotificationfilelistentry|atsops.isnotificationcancelled|atsops.addfiletonotificationfilelist|atsops.removefilefromnotificationfilelist|atsops.setpathonselection|atsops.retargetcommonrootofselection|atsops.retargetselection|atsops.setpath|atsops.retargetcommonroot|atsops.retargetassets|atsops.resolveselectiontounc|atsops.resolveselectionrelativetoprojectfolder|atsops.resolveselectiontoabsolute|containers.createinheritedcontainer|containers.createcontainer|containers.isincontainer|containers.iscontainernode|renderers.getdraftrenderer|renderers.cleardraftrenderer|getedgevis|crtcheckassert|getsubtexmapslotname|copy|rotatexmatrix|setselectfilter|getcvertmode|setbkgimageanimate|lightmetermanager.getnumlightmeterhelpers|lightmetermanager.getnthlightmeterhelper|lightmetermanager.getnthlightmeterhelpernode|lightmetermanager.getnumactivelightmeterhelpers|lightmetermanager.iscalculatingmeters|lightmetermanager.calculatemeters|lightmetermanager.outputactivemeterstocsvfiles|cleartrackgroup|selectctbitmap|formattedprint|getpropnames|importfile|numsegments|converttomesh|deleteobjects|vclayeradjustapply|polybpolydrawborder|crowdareagetbrushsize|mtlbrowser.browsefrom|deselecthiddenedges|wm3_getmarkerindex|deletemultipliercurve|trackview.clearfilter|trackview.picktrackdlg|trackview.gettrackviewname|trackview.open|trackview.numtrackviews|trackview.setfilter|trackview.close|trackview.zoomselected|crowds.scatterall|crowds.assigncontrollers|crowds.genclones|crowds.assignuniquepriorities|crowds.genscales|crowds.incrementpriorities|crowds.linkobjects|crowds.smooth|crowds.solve|crowds.assigngridproximitypriorities|crowds.genrotations|crowds.alignobjects|crowds.assignobjectproximitypriorities|crowds.genlocations|crowds.assignrandompriorities|daylightsimulationutilities.findvalidlights|daylightsimulationutilities.findinvalidlights|daylightsimulationutilities.findactivelights|daylightsimulationutilities.findinactivelights|daylightsimulationutilities.findlightswithvalidtype|daylightsimulationutilities.findlightswithinvalidtype|daylightsimulationutilities.findlightswithshadowson|daylightsimulationutilities.findlightswithshadowsoff|daylightsimulationutilities.findlightsusingraytracedshadows|daylightsimulationutilities.findlightsnotusingraytracedshadows|daylightsimulationutilities.findrenderableobjects|daylightsimulationutilities.findinvalidmaterials|daylightsimulationutilities.fixinvalidmaterials|daylightsimulationutilities.finddaylightsystems|daylightsimulationutilities.lightanalysisrendereffectexists|daylightsimulationutilities.islightanalysisrendereffectactive|daylightsimulationutilities.getlightanalysisrendereffectcount|daylightsimulationutilities.isvalidrenderer|daylightsimulationutilities.ismentalraysundaylightsystem|daylightsimulationutilities.ismentalrayskydaylightsystem|daylightsimulationutilities.isshadowcastingdaylightsystem|daylightsimulationutilities.isvalidsunmultiplier|daylightsimulationutilities.isvalidskymultiplier|daylightsimulationutilities.issunon|daylightsimulationutilities.isskyon|daylightsimulationutilities.setmentalrayasproductionrenderer|daylightsimulationutilities.openindirectilluminationrenderdialogpage|daylightsimulationutilities.is32bitframebuffer|daylightsimulationutilities.isrenderiterative|daylightsimulationutilities.setrenderiterative|daylightsimulationutilities.applydefaultrenderpreset|facesorientation.check|facesorientation.haspropertydlg|facesorientation.showpropertydlg|crtcorruptheap|assignvertexcolors.applynodes|setsubtexmap|windows.getchildrenhwnd|windows.addchild|windows.clienttoscreen|windows.getdesktophwnd|windows.gethwnddata|windows.sendmessage|windows.getwindowpos|windows.getmaxhwnd|windows.screentoclient|windows.processpostedmessages|windows.setwindowpos|windows.getchildhwnd|windows.postmessage|windows.getparenthwnd|matchpattern|getbkgimageaspect|setfilter|openctbitmap|dxshadermanager.isvisible|dxshadermanager.setvisible|dxshadermanager.getviewportmanager|dxshadermanager.addviewportmanager|comparebitmaps|showevents|networkmanager.send|fetchmaxfile|setuserpropbuffer|removeobject|fileproperties.findproperty|fileproperties.deleteproperty|fileproperties.getnumproperties|fileproperties.getitems|fileproperties.getpropertyvalue|fileproperties.addproperty|fileproperties.getpropertyname|vcadjustlevels|polybpolydrawswiftloop|crowdareasetaddmode|normalize|issurfaceuvclosed|wm3_deletemarker|addmultipliercurve|movekeys|macros.list|macros.load|macros.new|macros.run|macros.edit|missinguvcoordinates.check|missinguvcoordinates.haspropertydlg|missinguvcoordinates.showpropertydlg|bonesys.createbone|bonesys.refinebone|crtcheckmemory|getsubtexmap|updateshape|getdefaultuicolor|setbkgimageaspect|deselectkeys|getfilter|toupper|test_safearray|utilitypanel.closeutility|utilitypanel.openutility|ismscustattrib|showmethods|notifydependents|holdmaxfile|getuserpropbuffer|appendobject|vclayeradjust|polybpolydrawconnect|crowdareagetaddmode|selectkeys|cross|numsurfaces|wm3_createmarker|applyeasecurve|mateditor.isopen|mateditor.open|mateditor.close|nodeexposureinterface.create|nodeexposureinterface.get|ringarray.create|crtheapcheck|move|getnumsubtexmaps|deletekeys|resetshape|setuicolor|getvportbgcolor|gettrack|tolower|ismsplugin|unregistertimecallback|showproperties|enablerefmsgs|medit.getcurmtl|medit.setactivemtlslot|medit.getactivemtlslot|medit.putmtltomtleditor|medit.gettopmtlslot|medit.okmtlforscene|medit.updatemtleditorbrackets|resetmaxfile|dialogmonitorops.registernotification|dialogmonitorops.unregisternotification|dialogmonitorops.shownotification|dialogmonitorops.getwindowhandle|setuserprop|setobject|vcdeletemask|polybpolydrawbuild|crowdpathdrawing|dot|pointselection|wm3_setcurrentmarker|numeasecurves|networkrtt|getsubmtlslotname|setfirstspline|getuicolor|setvportbgcolor|setnodes|replace|ismscustattribclass|registertimecallback|showclass|disablerefmsgs|savenodes|getuserprop|getobject|vcaddmask|polybpolysplinesend|crowdareaend|patchops.selectbysg|patchops.selectedgeloop|patchops.growselection|patchops.hide|patchops.unbind|patchops.startattach|patchops.addtri|patchops.startbevel|patchops.createshapefromedges|patchops.startcreate|patchops.selectbyid|patchops.selectedgering|patchops.startpastetangent|patchops.clearallsg|patchops.unifynormal|patchops.subdivide|patchops.weld|patchops.startbind|patchops.flipnormal|patchops.patchsmooth|patchops.detach|patchops.startcopytangent|patchops.break|patchops.selectopenedges|patchops.delete|patchops.startweldtarget|patchops.shrinkselection|patchops.unhideall|patchops.startextrude|patchops.toggleshadedfaces|patchops.addquad|patchops.startflipnormalmode|isshapeobject|wm3_getcurrentmarker|deleteeasecurve|materialexplorermanager.openmaterialexplorer|materialexplorermanager.closematerialexplorer|materialexplorermanager.loadmaterialexplorerconfiguration|materialexplorermanager.savematerialexplorerconfiguration|materialexplorermanager.ismaterialexploreropen|edit|unmaz|setsubmtl|numsplines|selectsavebitmap|nodeinvalrect|getnodes|substring|ismspluginclass|setarrowcursor|getinterface|savemaxfile|nodeclonemgrtest.clonenodes|uniquename|enveffectsdialog.isopen|enveffectsdialog.open|enveffectsdialog.close|setflip|vcmovelayer|polybpolytopoend|crowdareasetup|netrender.getmanager|nummapsused|wm3_numberofmarkers|addeasecurve|display|renderpresets.save|renderpresets.load|renderpresets.saveall|renderpresets.loadall|renderpresets.isfilecompatible|renderpresets.mapindextocategory|renderpresets.mapcategorytoindex|renderpresets.mapsceneindextocategory|renderpresets.mapscenecategorytoindex|renderpresets.loadcategories|renderpresets.savecategories|maz|getsubmtl|ilayermanager.getlayerobject|deletespline|convertinttodirid|iscpedgeoninview|getmixerinterval|findpattern|namedselectionsetmanager.getnumnamedselsets|namedselectionsetmanager.getnamedselsetitemcount|namedselectionsetmanager.addnewnamedselset|namedselectionsetmanager.removenamedselsetbyindex|namedselectionsetmanager.removenamedselsetbyname|namedselectionsetmanager.replacenamedselsetbyindex|namedselectionsetmanager.replacenamedselsetbyname|namedselectionsetmanager.getnamedselsetlist|namedselectionsetmanager.setnamedselsetname|namedselectionsetmanager.getnamedselsetname|namedselectionsetmanager.getnamedselsetitem|distance|viewpanelmanager.createviewpanel|viewpanelmanager.destroyviewpanel|viewpanelmanager.setactiveviewpanel|viewpanelmanager.getviewpanelcount|viewpanelmanager.getactiveviewpanelindex|viewpanelmanager.cancreatemoreviewpanels|viewpanelmanager.getviewpanelname|viewpanelmanager.setviewpanelname|viewpanelmanager.getactiveviewpaneldib|viewpanelmanager.isviewpanellocked|viewpanelmanager.setextendedview|viewpanelmanager.setsplitterbarpos|viewpanelmanager.createviewpanelfrompreset|viewpanelmanager.getpresetcount|viewpanelmanager.getpresetname|viewpanelmanager.getpresetid|viewpanelmanager.createpresetfromactiveviewpanel|viewpanelmanager.createpresetfromviewpanel|viewpanelmanager.deletepreset|viewpanelmanager.renameviewpanelpreset|viewpanelmanager.deleteallviewpanelpresets|viewpanelmanager.doesviewpanelpresetexist|viewpanelmanager.getviewpanelpresetlayout|dependson|getclassinstances|setwaitcursor|getinterfaces|flagchanged|getmaxfileobjectnames|printstack|getflip|vcflattenlayersnoundo|polybsolvesurf|crowdareadrawing|ispointselected|wm3_rebuildinternalcache|mapkeys|menuman.loadmenufile|menuman.savemenufile|menuman.getmenufile|menuman.updatemenubar|menuman.registermenucontext|menuman.findmenu|menuman.findquadmenu|menuman.unregistermenu|menuman.unregisterquadmenu|menuman.createmenu|menuman.createquadmenu|menuman.createsubmenuitem|menuman.createseparatoritem|menuman.createactionitem|menuman.setviewportrightclickmenu|menuman.getviewportrightclickmenu|menuman.getmainmenubar|menuman.setmainmenubar|menuman.getshowallquads|menuman.setshowallquads|menuman.getquadmenuname|menuman.setquadmenuname|menuman.nummenus|menuman.getmenu|menuman.numquadmenus|menuman.getquadmenu|menuman.createmenuitemfromaction|heightmanager.customizeheights|heightmanager.setcurrentheightindex|heightmanager.getheight|heightmanager.getcurrentheightindex|heightmanager.getnumheights|heightmanager.getheightstring|layermanager.closedialog|layermanager.isdialogopen|layermanager.getlayer|layermanager.newlayer|layermanager.getlayerfromname|layermanager.newlayerfromname|layermanager.editlayerbyname|layermanager.deletelayerbyname|getfilesize|getnumsubmtls|addnewspline|convertdiridtoint|issubselenabled|select|clearmixer|findstring|polyops.startcutface|polyops.selectbysg|polyops.split|polyops.startextrudeface|polyops.removeisolatedverts|polyops.hide|polyops.startcreatevertex|polyops.resetplane|polyops.startedittri|polyops.startbevel|polyops.selectbycolor|polyops.update|polyops.namedselpaste|polyops.startdivideedge|polyops.createshapefromedges|polyops.startcutedge|polyops.selectbyid|polyops.attachlist|polyops.startextrudeedge|polyops.viewalign|polyops.clearallsg|polyops.collapse|polyops.startchamferedge|polyops.tessellate|polyops.namedselcopy|polyops.startcreateface|polyops.weld|polyops.startcutvertex|polyops.flipnormal|polyops.detach|polyops.startextrudevertex|polyops.gridalign|polyops.startweldtarget|polyops.autosmooth|polyops.break|polyops.delete|polyops.startchamfervertex|polyops.meshsmooth|polyops.unhide|polyops.startcreateedge|polyops.slice|polyops.startsliceplane|polyops.retriangulate|polyops.cap|polyops.startdivideface|polyops.makeplanar|simplefacemanager.removechannel|simplefacemanager.addchannel|simplefacemanager.getchannel|simplefacemanager.getchannels|trackbar.getnextkeytime|trackbar.getpreviouskeytime|getmaxwindowpos|enablehardwarematerial|showinterface|iksys.ikchain|iksys.solvercount|iksys.solvername|iksys.solveruiname|iksys.suspendlinknotify|iksys.resumelinknotify|iksys.islinknotifysuspended|overlappingfaces.check|overlappingfaces.haspropertydlg|overlappingfaces.showpropertydlg|mergemaxfile|intersectray|setcurvebyid|vcflattenlayers|lockedtracksman.pushuberunlockoverride|lockedtracksman.popuberunlockoverride|lockedtracksman.getuberunlockoverride|lockedtracksman.setlocks|lockedtracksman.togglelocks|lockedtracksman.setexposedui|lockedtracksman.getexposedui|lockedtracksman.getlocked|lockedtracksman.islockable|lockedtracksman.findlockedanims|lockedtracksman.unlockchildren|lockedtracksman.isanimoverrideunlocked|polybpolydrawtoposetup|refhierarchy.isreftargetinstanced|gettrimeshfacecount|wm3_mc_getmorphweight|reducekeys|frametagmanager.createnewtag|frametagmanager.deletetag|frametagmanager.resetframetags|frametagmanager.checkforloop|frametagmanager.gettagcount|frametagmanager.gettagid|frametagmanager.gettimebyid|frametagmanager.settimebyid|frametagmanager.getlockidbyid|frametagmanager.setlockidbyid|frametagmanager.getnamebyid|frametagmanager.setnamebyid|frametagmanager.getscalebyid|frametagmanager.setscalebyid|frametagmanager.finditembytime|frametagmanager.finditem|getnotekeyindex|skipspace|dof.deletecam|dof.deletefocalnode|dof.addcam|dof.addfocalnode|dof.deletefocalnodebyname|dof.deletecambyname|symbolicpaths.removeuserpath|symbolicpaths.getpathvalue|symbolicpaths.isuserpathname|symbolicpaths.adduserpath|symbolicpaths.ispathname|symbolicpaths.expandfilename|symbolicpaths.getuserpathname|symbolicpaths.setuserpathvalue|symbolicpaths.getpathname|symbolicpaths.numuserpaths|symbolicpaths.getuserpathvalue|symbolicpaths.numpaths|converttosplineshape|setdir|enablesubobjsel|savemixfile|is64bitapplication|getmaxwindowsize|showhwtexturemap|showinterfaces|internet.checkconnection|loadmaxfile|updatexref|getcurveid|vcmergedownlayer|polybpolydrawupdatevalues|getpolygoncount|wm3_mc_getmorphpoint|sortkeys|pathisnetworkpath|deletetrackviewcontroller|workingpivot.gettm|workingpivot.settm|workingpivot.aligntoview|workingpivot.resettmtonode|workingpivot.setplacepivotviewmode|workingpivot.getplacepivotviewmode|workingpivot.setplacepivotsurfacemode|workingpivot.getplacepivotsurfacemode|workingpivot.getplacepivotaligntoview|getnotekeytime|peektoken|lengthtangent|getdir|clearcurselset|loadmixfile|converttojoinbodies|ismaxfile|mxsunitresults.clear|mxsunitresults.getuserdata|mxsunitresults.getassertfailcount|mxsunitresults.getexceptioncount|mxsunitresults.getmessagecount|mxsunitresults.getassertfailure|mxsunitresults.getexceptionfailure|mxsunitresults.getmessage|getlastrenderedimage|createnumberedfilename|viewport.activeviewportex|viewport.setadaptivedegdisplaymodehide|viewport.iswire|viewport.getblowuprect|viewport.setadaptivedegcameradistancepriority|viewport.getadaptivedegdisplaymodewire|viewport.zoom|viewport.setshowedgefaces|viewport.gettype|viewport.iscanvasnavigationmode|viewport.getadaptivedegneverdegradeselected|viewport.setclipscale|viewport.getviewportdib|viewport.gettm|viewport.getadaptivedegminsize|viewport.setadaptivedegdisplaymodebox|viewport.setfocaldistance|viewport.gettransparencylevel|viewport.setadaptivedegdegradelight|viewport.getadaptivedegdisplaymodecurrent|viewport.cansettoviewport|viewport.setlayout|viewport.numviewex|viewport.getadaptivedegdisplaymodehide|viewport.isperspview|viewport.setblowuprect|viewport.getadaptivedegcameradistancepriority|viewport.setadaptivedegdisplaymodefastshaded|viewport.pan|viewport.getrenderlevel|viewport.issolidbackgroundcolormode|viewport.setadaptivedegdrawbackfaces|viewport.getclipscale|viewport.getgridvisibility|viewport.settm|viewport.setadaptivedegscreensizepriority|viewport.getadaptivedegdisplaymodebox|viewport.getfocaldistance|viewport.settransparencylevel|viewport.getadaptivedegdegradelight|viewport.setadaptivedeggoalfps|viewport.zoomtobounds|viewport.getcamera|viewport.setcanvasnavigationmode|viewport.getid|viewport.setadaptivedegdisplaymodepoint|viewport.getscreenscalefactor|viewport.isenabled|viewport.getregionrect|viewport.setadaptivedegneverredrawafterdegrade|viewport.getadaptivedegdisplaymodefastshaded|viewport.setfov|viewport.setrenderlevel|viewport.enablesolidbackgroundcolormode|viewport.getadaptivedegdrawbackfaces|viewport.getfps|viewport.setgridvisibility|viewport.settype|viewport.getadaptivedegscreensizepriority|viewport.setadaptivedegdisplaymodewire|viewport.zoomperspective|viewport.getshowedgefaces|viewport.setadaptivedegneverdegradeselected|viewport.getadaptivedeggoalfps|viewport.resetallviews|viewport.setcamera|viewport.setadaptivedegminsize|viewport.getadaptivedegdisplaymodepoint|viewport.rotate|viewport.setregionrect|viewport.getadaptivedegneverredrawafterdegrade|viewport.setadaptivedegdisplaymodecurrent|viewport.getfov|viewport.getlayout|transform|assert|detachnodesfromgroup|setcurve|vcdeletelayer|detachfaces|polybdrawnodereset|checkforsave|wm3_mc_nummpts|numselkeys|hiddendoscommand|addtrackviewcontroller|toolmode.uniformscale|toolmode.pivotcenter|toolmode.transformcenter|toolmode.coordsys|toolmode.squashscale|toolmode.nonuniformscale|toolmode.selectioncenter|paramwire.start|paramwire.disconnect2way|paramwire.connect2way|paramwire.disconnect|paramwire.connect|paramwire.openeditor|paramwire.editparams|paramwire.editparam|paramwire.editcontrollers|paramwire.editcontroller|deletenotekey|readtoken|sceneexplorermanager.addreadonlyproperty|sceneexplorermanager.removeproperty|sceneexplorermanager.getexplorercount|sceneexplorermanager.getexplorername|sceneexplorermanager.explorerexists|sceneexplorermanager.explorerisopen|sceneexplorermanager.createadefaultexplorer|sceneexplorermanager.openexplorer|sceneexplorermanager.closeexplorer|sceneexplorermanager.deleteexplorer|sceneexplorermanager.renameexplorer|sceneexplorermanager.clearallexplorers|sceneexplorermanager.sortexplorerbycolumnfieldname|sceneexplorermanager.sortexplorerbycolumncaption|sceneexplorermanager.getexplorerposition|sceneexplorermanager.setexplorerposition|sceneexplorermanager.getexplorersize|sceneexplorermanager.setexplorersize|sceneexplorermanager.configureexplorer|sceneexplorermanager.loadexplorerconfiguration|sceneexplorermanager.saveexplorerconfiguration|sceneexplorermanager.openmanageinstancesdialog|sceneexplorermanager.closemanageinstancesdialog|sceneexplorermanager.addlocalizableproperty|sceneexplorermanager.addlocalizablereadonlyproperty|sceneexplorermanager.createexplorer|sceneexplorermanager.setexplorervisiblecolumns|sceneexplorermanager.getexplorervisiblecolumns|sceneexplorermanager.addproperty|pathtangent|setsilentmode|clearsubselsets|copymixdowntobiped|converttobody|getclassname|renderscenedialog.isopen|renderscenedialog.update|renderscenedialog.commit|renderscenedialog.open|renderscenedialog.close|renderscenedialog.cancel|showtexturemap|getcurrentthreadid|attachnodestogroup|getcurve|vcduplicatelayer|polybdrawnodeinit|editatmosphere|wm3_mc_numpts|getkeyindex|arenodesinstances|deletetrackviewnode|boolobj.getshowhiddenops|boolobj.setoperandsel|boolobj.setupdatemode|boolobj.getboolcuttype|boolobj.setoptimize|boolobj.setdisplayresult|boolobj.getoperandsel|boolobj.getupdatemode|boolobj.setboolop|boolobj.getdisplayresult|boolobj.setoperandb|boolobj.setshowhiddenops|boolobj.getboolop|boolobj.getoptimize|boolobj.setboolcuttype|boolobj.createbooleanobject|deletenotekeys|trimright|particleflowutility.cleanupparticleflow|particleflowutility.resetparticleview|particleflowutility.synchronizelayers|particleflowutility.repaircachesystem|particleflowutility.presetmanager|lengthtopathparam|silentmode|appendsubselset|replaceinstances|mixdown|flush|converttobodycutter|tverts.check|tverts.haspropertydlg|tverts.showpropertydlg|resumeediting|animatevertex|heapcheck|explodegroup|appendcurvebyid|skinutils.growselection|skinutils.ringselection|skinutils.loopselection|skinutils.importskindatanodialog|skinutils.extractskindata|skinutils.importskindata|skinutils.getbonebindtm|skinutils.setbonebindtm|skinutils.getmeshbindtm|skinutils.setmeshbindtm|skinutils.getbonestretchtm|skinutils.setbonestretchtm|skinutils.shrinkselection|vcnewlayer|polybsculptvalidbuffer|s3dexporter.preview|s3dexporter.analyze|s3dexporter.authcheck|configurebitmappaths|wm3_mc_getmemuse|getkeytime|particlesize2|getfacesmoothgroup|setkey.revertbuffer|setkey.bufferpresent|setkey.subanimrevertbuffer|setkey.subanimbufferpresent|setkey.commitbuffer|setkey.subanimcommitbuffer|newtrackviewnode|addnewnotekey|trimleft|pathtolengthparam|defaultactions.getaction|defaultactions.setaction|defaultactions.deleteaction|defaultactions.getactioncount|defaultactions.getactiontitle|defaultactions.getactiontitlebyindex|defaultactions.getactionidbyindex|defaultactions.logentry|defaultactions.msglogclear|defaultactions.getmsglogcount|defaultactions.getmsglogmsg|defaultactions.getmsglogmsgs|defaultactions.getmsglogid|defaultactions.setmsglogmaxcount|loaddllsfromdir|enableshowendres|ispropertyanimatable|deletetrackgroup|vertexpainttool|setfacesmoothgroup|suspendediting|encryptfile|threads|ungroup|appendcurve|vcsetlayerbitmap|polybsculptcancelbuffer|wm3_mc_setusevertexsel|particlecenter|bipanalyzer.donoisedetectoranalysis|bipanalyzer.dospikedetectoranalysis|bipanalyzer.getresults|bipanalyzer.loadanalysisfile|bipanalyzer.saveanalysisfile|bipanalyzer.clearanalysisresults|bipanalyzer.dokneewobbleanalysis|bipanalyzer.dokneeextensionanalysis|editeffect|sortnotekeys|isspace|nearestpathparam|stopcreating|getgridmajorlines|setpropertycontroller|inserttrackgroup|fbximportocmerge|getmaxinifile|numkeys|radiositymeshops.getradiositymesh|radiositymeshops.isradiosityvalid|radiositymeshops.isnodeinsolution|seek|le.save|le.addring|le.lightindex|le.load|le.deleteelementbyname|le.addray|le.deletelightbyname|le.addmsec|le.lightname|le.deleteelement|le.addglow|le.addlightnode|le.deletelight|le.addstar|le.numlights|le.addstreak|le.addlight|le.addasec|go|setselectionlevel|refinev|vcsetcurrentlayer|polybsculptcommitbuffer|wm3_mc_getusevertexsel|particlelife|deleteeffect|empty|curvelength|selectmore|setcurnamedselset|getgridspacing|getpropertycontroller|appendtrackgroup|fbximporterfilelinkversion|setquietmode|update|movekey|filepos|setfacematid|selectbyname|locals|getselectionlevel|refineu|vcsetlayersetting|polybsculptrefreshnormals|schematicviews.numviews|schematicviews.isopen|schematicviews.getview|schematicviews.open|schematicviews.delete|schematicviews.close|schematicviews.iscurrent|schematicviews.setcurrent|schematicviews.openlastview|pluginpaths.get|pluginpaths.count|wm3_mc_setlimitmin|isanimplaying|particlesize|geteffect|composite|getfacematid|manip.makesphere|manip.maketorus|manip.makebox|manip.makeplanefrompts|manip.makeplanefromnormal|manip.makegizmoshape|manip.makecircle|execute|rectify|resetlengthinterp|clearselection|setcommandpaneltaskmode|setstatusxyz|ik.setaxisspringtension|ik.getaxislimit|ik.setbindorient|ik.getaxispreferredangle|ik.getprecedence|ik.getendtime|ik.setaxisease|ik.setaxisspringon|ik.setisterminator|ik.setposthreshold|ik.getaxismax|ik.getaxisspringtension|ik.setaxisactive|ik.getbindorient|ik.getiterations|ik.setaxisdamping|ik.setpinnode|ik.setstarttime|ik.getaxisease|ik.getaxisspringon|ik.getisterminator|ik.getposthreshold|ik.setaxismin|ik.setaxisspring|ik.getaxisactive|ik.setbindpos|ik.setrotthreshold|ik.getaxisdamping|ik.getpinnode|ik.getstarttime|ik.setaxislimit|ik.setaxispreferredangle|ik.setprecedence|ik.setiterations|ik.setendtime|ik.getaxismin|ik.getaxisspring|ik.getbindpos|ik.getrotthreshold|ik.setaxismax|gettrackgroup|fbximportergetparam|getquietmode|getcurrentselection|stack|oktocreate|setvknot|vcgetlayersetting|polybsculptsettings|wavsound.scrub|wm3_mc_setlimitmax|getnodetm|particleage|seteffect|pftparticleview.redraw|unregisterviewwindow|iskeyselected|skiptonextline|mxsdebugger.opendialog|mxsdebugger.writeline|mxsdebugger.closedialog|mxsdebugger.writestring|contains|validateid|lengthinterp|deselect|setbackgroundcontroller|enablestatusxyz|deletetraninfo|fbximportersetparam|hidebycategory.all|hidebycategory.none|clearundobuffer|daylightsystemfactory2.create|updatetoolbarbuttons|setuknot|vcsetsetting|polybsculptend|exchangestorepackagemanager.getnativeplugincount|exchangestorepackagemanager.getnativepluginfullpath|exchangestorepackagemanager.getmanagedassemblycount|exchangestorepackagemanager.getmanagedassemblyfullpath|exchangestorepackagemanager.getuischemecount|exchangestorepackagemanager.getuischemefullpath|exchangestorepackagemanager.getdefaultsettingcount|exchangestorepackagemanager.getdefaultsettingfullpath|exchangestorepackagemanager.getmaxscriptscount|exchangestorepackagemanager.getmaxscriptsfullpath|exchangestorepackagemanager.getmacroscriptscount|exchangestorepackagemanager.getmacroscriptsfullpath|exchangestorepackagemanager.getpoststartupscriptscount|exchangestorepackagemanager.getpoststartupscriptfullpath|exchangestorepackagemanager.getmetaslshaderpathcount|exchangestorepackagemanager.getmetaslshaderfullpath|exchangestorepackagemanager.getmifilecount|exchangestorepackagemanager.getmifilefullpath|exchangestorepackagemanager.getmentalrayshadercount|exchangestorepackagemanager.getmentalrayshaderfullpath|exchangestorepackagemanager.getlighticonpathscount|exchangestorepackagemanager.getlighticonpathfullpath|exchangestorepackagemanager.getdarkiconpathscount|exchangestorepackagemanager.getdarkiconpathfullpath|wm3_mc_getlimitmin|getbitmapinfo|particlevelocity|addeffect|registerviewwindow|deselectkey|skiptostring|getnurbsselection|setlistenerseltext|pathinterp|maxribbon.setribbonorientation|maxribbon.getribbonorientation|maxribbon.showribbon|maxribbon.isribbonopen|maxribbon.loadribbonconfig|maxribbon.saveribbonconfig|maxribbon.resetribbon|maxribbon.setribbondockstate|maxribbon.isribbonfloating|setbackground|disablestatusxyz|helpsystem.showproducthelp|helpsystem.searchproducthelp|addtraninfo|fbxexportergetparam|save|getsaverequired|sessionpaths.get|sessionpaths.add|sessionpaths.delete|sessionpaths.count|detachverts|isvalidobj|setsize|updatesurfacemapper|getvknot|vcgetsetting|polybsculptstart|freeze|wm3_mc_getlimitmax|setgridmajorlines|particlepos|editatmospheric|deepcopy|readdelimitedstring|setsurfacedisplay|getlistenerseltext|converttopoly|rescaleworldunits|removetempprompt|deletetransitionsto|fbxexportersetparam|setfocus|setsaverequired|selectkey|isvalidnode|nurbsextrudenode|getuknot|vccreatedisplaybitmap|polybobjspacingchangeend|unfreeze|wm3_mc_setuselimits|setgridspacing|particlecount|deleteatmospheric|readchars|aremtlandrenderercompatible|setrenderapproximation|setlistenersel|meshops.selectbysg|meshops.shownormal|meshops.removeisolatedverts|meshops.explode|meshops.hide|meshops.startattach|meshops.selectbycolor|meshops.startdivide|meshops.startchamfer|meshops.startbevel|meshops.createshapefromedges|meshops.startcreate|meshops.selectbyid|meshops.attachlist|meshops.invisibleedge|meshops.viewalign|meshops.clearallsg|meshops.unifynormal|meshops.collapse|meshops.tessellate|meshops.startcut|meshops.weld|meshops.visibleedge|meshops.flipnormal|meshops.detach|meshops.gridalign|meshops.autosmooth|meshops.selectopenedges|meshops.break|meshops.delete|meshops.startweldtarget|meshops.autoedge|meshops.unhideall|meshops.slice|meshops.startextrude|meshops.startturn|meshops.startsliceplane|meshops.makeplanar|meshops.startflipnormalmode|transpose|okmtlforscene|displaytempprompt|assemblymgr.explode|assemblymgr.assemble|assemblymgr.disassemble|assemblymgr.detach|assemblymgr.open|assemblymgr.close|assemblymgr.attach|assemblymgr.canassemble|assemblymgr.candisassemble|assemblymgr.canexplode|assemblymgr.canopen|assemblymgr.canclose|assemblymgr.canattach|assemblymgr.candetach|assemblymgr.isassembly|assemblymgr.filterassembly|deletetransition|closecameratracker|settransformlockflags|join|enumeratefiles|nurbslathenode|closev|viewportcanvascolorpicker|polybobjspacingchangestart|editrenderregion.editregion|editrenderregion.updateregion|wm3_mc_getuselimits|colorpickerdlg|getatmospheric|readchar|animlayermanager.setlayeractivenodes|animlayermanager.getactivelayersnodes|animlayermanager.getnodesactivelayer|animlayermanager.addlayer|animlayermanager.addlayerdlg|animlayermanager.setlayername|animlayermanager.getlayerweight|animlayermanager.setlayerweight|animlayermanager.getlayerweightcontrol|animlayermanager.setlayerweightcontrol|animlayermanager.getlayermute|animlayermanager.setlayermute|animlayermanager.getlayerlocked|animlayermanager.setlayerlocked|animlayermanager.getlayeroutputmute|animlayermanager.setlayeroutputmute|animlayermanager.collapselayernodes|animlayermanager.disablelayernodes|animlayermanager.animlayerpropertiesdlg|animlayermanager.refreshanimlayerpropertiesdlg|animlayermanager.setcollapsecontrollertype|animlayermanager.getcollapsecontrollertype|animlayermanager.setcollapseperframe|animlayermanager.getcollapseperframe|animlayermanager.setcollapseperframeactiverange|animlayermanager.getcollapseperframeactiverange|animlayermanager.setcollapserange|animlayermanager.getcollapserange|animlayermanager.getnodeslayers|animlayermanager.getlayername|animlayermanager.deletelayer|animlayermanager.showanimlayersmanagertoolbar|animlayermanager.enablelayersdlg|animlayermanager.enablelayers|animlayermanager.canenablelayer|animlayermanager.enablelayer|animlayermanager.getlayercount|animlayermanager.setlayeractive|animlayermanager.deletelayernodes|animlayermanager.copylayernodes|animlayermanager.pastelayernodes|setviewapproximation|getlistenersel|getcoreinterfaces|isactive|namedselsetlistchanged|replaceprompt|addtransition|startupmemorytest|splineops.startextend|splineops.fuse|splineops.explode|splineops.unbind|splineops.hide|splineops.startconnect|splineops.startunion|splineops.startattach|splineops.mirrorhoriz|splineops.startchamfer|splineops.startcrosssection|splineops.selectbyid|splineops.starttrim|splineops.attachmultiple|splineops.startpastetangent|splineops.startinsert|splineops.startbreak|splineops.intersect|splineops.startfillet|splineops.weld|splineops.startintersect|splineops.startbind|splineops.mirrorboth|splineops.detach|splineops.startoutline|splineops.makefirst|splineops.startcopytangent|splineops.startcreateline|splineops.delete|splineops.startcrossinsert|splineops.close|splineops.reverse|splineops.unhideall|splineops.startrefine|splineops.startsubtract|splineops.mirrorvert|splineops.cycle|splineops.startrefineconnect|splineops.divide|gettransformlockflags|logsystem.logentry|logsystem.getnetlogfilename|logsystem.logname|finditem|freescenebitmaps|deletecopy|xrefpaths.get|xrefpaths.add|xrefpaths.delete|xrefpaths.getfullfilepath|xrefpaths.count|nurbsnode|closeu|viewportcanvasswitchbrush|polybobjpaintsetnumfillnodes|getclipboardbitmap|wm3_mc_setactive|scanfornewplugins|attachobjects|setatmospheric|readline|open|numcopies|converttonurbssurface|getcopy|clearlistener|stricmp|setactive|getrendimageaspect|popprompt|insertsnippet|invalidateallbackgrounds|setinheritanceflags|deleteitem|openencryptedfile|gc|deleteallcopies|flightstudioimport.getvertexthreshold|flightstudioimport.setvertexthreshold|flightstudioimport.gettrivialarea|flightstudioimport.settrivialarea|flightstudioimport.getreadxrefs|flightstudioimport.setreadxrefs|flightstudioimport.getkeepfaces|flightstudioimport.setkeepfaces|flightstudioimport.setignorematerials|flightstudioimport.setignoretextures|flightstudioimport.setignorebead|flightstudioimport.setmapfacestoselections|flightstudioimport.getstats|flightstudioimport.gettexturestats|appendgizmo|makenurbstorussurface|getgenerateuvs|viewportcanvasend|paramcollectorops.newcollection|paramcollectorops.duplicatecollection|paramcollectorops.deletecollection|paramcollectorops.numcollections|paramcollectorops.getactivecollection|paramcollectorops.setcollectionname|paramcollectorops.getcollectionname|paramcollectorops.getnumparametersincollection|paramcollectorops.getselectedparameters|paramcollectorops.dolinktoobjectdialog|paramcollectorops.linktoobject|paramcollectorops.removelinktoobject|paramcollectorops.doputtoobjectdialog|paramcollectorops.puttoobject|paramcollectorops.dogetfromobjectdialog|paramcollectorops.getfromobject|paramcollectorops.doremovefromobjectdialog|paramcollectorops.removefromobject|paramcollectorops.doaddtoselecteddialog|paramcollectorops.doadddialog|paramcollectorops.deleteselectedparameters|paramcollectorops.deleteallparameters|paramcollectorops.addnewrollout|paramcollectorops.deleterollout|paramcollectorops.deleterolloutmoveup|paramcollectorops.deleterolloutmovedown|paramcollectorops.dorenamerolloutdialog|paramcollectorops.renamerollout|paramcollectorops.isrolloutselected|paramcollectorops.getselectedrollout|paramcollectorops.numrollouts|paramcollectorops.setrolloutname|paramcollectorops.getrolloutname|paramcollectorops.getnumparameters|paramcollectorops.getnumselectedparameters|paramcollectorops.anyparameters|paramcollectorops.anyrollouts|paramcollectorops.anyselected|paramcollectorops.numselected|paramcollectorops.selectall|paramcollectorops.selectallrollout|paramcollectorops.selectnone|paramcollectorops.selectinvert|paramcollectorops.addparameterbysubnum|paramcollectorops.moveselectedparameters|paramcollectorops.keyparameters|paramcollectorops.resetparameters|paramcollectorops.addparameter|paramcollectorops.addparametertraverse|paramcollectorops.getparameterindex|paramcollectorops.getparameterparentanim|paramcollectorops.getparametersubanimnum|paramcollectorops.getparameteranim|paramcollectorops.setparameternotestitle|paramcollectorops.getparameternotestitle|paramcollectorops.setparameternotesnotes|paramcollectorops.getparameternotesnotes|paramcollectorops.setparameternotesurl|paramcollectorops.getparameternotesurl|paramcollectorops.setparameterselected|paramcollectorops.getparameterselected|paramcollectorops.getparameternodes|paramcollectorops.doeditnotesdialog|paramcollectorops.refresh|polybobjpaintgetstrokefromedges|settimerange|setclipboardbitmap|wm3_mc_isactive|clearcontrollernewflag|flagforeground|addatmospheric|readexpr|viewportssb.getvideomemoryused|loadsaveanimation.loadanimationdlg|loadsaveanimation.saveanimationdlg|loadsaveanimation.saveanimation|loadsaveanimation.saveanimationnodeanim|loadsaveanimation.loadanimation|loadsaveanimation.loadanimationnodeanim|loadsaveanimation.createmapfile|loadsaveanimation.createmapfilenodeanim|loadsaveanimation.makeretargetdata|loadsaveanimation.getuserattributes|loadsaveanimation.getanimfileextension|loadsaveanimation.getanimmapfileextension|loadsaveanimation.getanimfiledirectory|loadsaveanimation.getanimmapfile|loadsaveanimation.setanimfiledirectory|loadsaveanimation.setanimmapfile|loadsaveanimation.setupanimsforsave|loadsaveanimation.setupanimsforload|loadsaveanimation.setupanimsformap|loadsaveanimation.replaceattributesinmapfile|loadsaveanimation.createdefaultmapfile|loadsaveanimation.createnodeanimsforload|loadsaveanimation.createnodeanimsforsave|loadsaveanimation.createnodeanimsformap|loadsaveanimation.loadanimationdlgfromanims|loadsaveanimation.saveanimationdlgfromanims|converttonurbscurve|pickoffsetdistance|int|isnetworkrenderserver|setrendaperturewidth|pushprompt|addsnippet|setvert|getinheritanceflags|batchrendermgr.getview|batchrendermgr.findview|batchrendermgr.createview|batchrendermgr.deleteview|batchrendermgr.duplicateview|batchrendermgr.render|deletegizmo|makenurbsconesurface|setgenerateuvs|viewportcanvassetup|objpaintsetsetting|setweightattime|gettimerange|getclipboardtext|scenemissingplugins.getmissingplugincount|scenemissingplugins.getmissingpluginclassname|scenemissingplugins.getmissingpluginfilename|scenemissingplugins.getmissingplugindescription|getvert|wm3_mc_hasdata|replace_crlf_with_lf|convertto|fractalnoise|callbacks.removescripts|callbacks.notificationparam|callbacks.addscript|callbacks.show|callbacks.broadcastcallback|readvalue|bitmapproxymgr.getproxysizefactor|bitmapproxymgr.setproxysizefactor|bitmapproxymgr.getproxyuseglobal|bitmapproxymgr.setproxyuseglobal|bitmapproxymgr.getproxyready|bitmapproxymgr.refreshall|bitmapproxymgr.generateall|bitmapproxymgr.showconfigdialog|bitmapproxymgr.showprecachedialog|makeindependent|getavailablesubstancegraphsandoutputsfrompackage|getcurnameselset|isnetserver|getrendaperturewidth|loaddefaultmatlib|deletesnippet|mappaths.get|mappaths.add|mappaths.delete|mappaths.getfullfilepath|mappaths.count|snapshotasmesh|resetpivot|getgizmo|makenurbscylindersurface|gettextureuvs|vcendtrack|objpaintgetsetting|getweightattime|getkbchar|inserttime|setclipboardtext|wm3_mc_isvalid|replace_lf_with_crlf|canconvertto|turbulence|joinsurfaces|reactto|getmaxopenfilename|ramplayer|getnumnamedselsets|filesaveasmatlib|newsnippet|invalidatews|memstreammgr.openfile|memstreammgr.openstring|memstreammgr.close|resetscale|getd3dmeshallocatedfaces|makenurbsspheresurface|settextureuvs|vcstarttrack|polybobjendpaint|setweighttime|getkbline|ismoduleloaded|reverse|scaletime|wm3_mc_settarget|substitutestring|validmodifier|break|noise4|sme.isopen|sme.getnumviews|sme.getview|sme.getmtlinparameditor|sme.setmtlinparameditor|sme.getnavigator|sme.getmaterialpool|sme.getparameditor|sme.getmainframe|sme.domtlbrowsedlg|sme.openmtlbrowsedlg|sme.open|sme.getviewindex|sme.getviewbyname|sme.close|sme.createview|sme.deleteview|setmodcontexttm|joincurves|getreactionvalue|getmaxsavefilename|bit.shift|bit.isfinite|bit.intashex|bit.and|bit.int64asdouble|bit.not|bit.isnan|bit.charasint|bit.flip|bit.hexasint|bit.floatasint|bit.xor|bit.swapbytes|bit.get|bit.intaschar|bit.intasfloat|bit.set|bit.or|bit.doubleasint64|radtodeg|getnamedselsetname|filesavematlib|computeanimation|invalidatetreetm|resettransform|getd3dmeshallocated|makenurbslathesurface|gettilingoffset|polybuvwtweakend|polybobjpaintclear|setweight|getkbpoint|dumpmaxstrings|reversetime|autosave.autobackupnow|autosave.isactive|autosave.resettimer|overlappeduvwfaces.check|overlappeduvwfaces.haspropertydlg|overlappeduvwfaces.showpropertydlg|wm3_mc_gettarget|makeuniquearray|getmodcontextbboxmax|noise3|pathconfig.pathsresolveequivalent|pathconfig.getprojectsubdirectory|pathconfig.convertpathtounc|pathconfig.isabsolutepath|pathconfig.removepathtopparent|pathconfig.removeallprojectdirectorycreatefilters|pathconfig.load|pathconfig.isusingroamingprofiles|pathconfig.isuncpath|pathconfig.resolvepathsymbols|pathconfig.doprojectsetupstepsusingdirectory|pathconfig.merge|pathconfig.ispathrootedatdriveletter|pathconfig.getprojectsubdirectorycount|pathconfig.getdir|pathconfig.convertpathtorelativeto|pathconfig.getcurrentprojectfolderpath|pathconfig.strippathtotopparent|pathconfig.removeprojectdirectorycreatefilter|pathconfig.isusingprofiledirectories|pathconfig.isrootpath|pathconfig.removepathleaf|pathconfig.doprojectsetupsteps|pathconfig.getexchangestoreplugininstallpath|pathconfig.ispathrootedatbackslash|pathconfig.setcurrentprojectfolder|pathconfig.convertpathtolowercase|pathconfig.getprojectfolderpath|pathconfig.appendpath|pathconfig.addprojectdirectorycreatefilter|pathconfig.convertpathtoabsolute|pathconfig.islegalpath|pathconfig.setdir|pathconfig.strippathtoleaf|pathconfig.getprojectdirectorycreatefilters|pathconfig.saveto|pathconfig.isuncsharepath|pathconfig.getcurrentprojectfolder|pathconfig.normalizepath|pathconfig.isprojectfolder|setmodcontextbbox|breaksurface|getreactionstate|doesdirectoryexist|degtorad|getnamedselsetitemcount|fileopenmatlib|getsnippetindex|invalidatetm|seed|epolymanipgrip.setmanipulategrip|epolymanipgrip.getmanipulategrip|setsavescenescript|aligntoparent|setd3dmeshcachesize|getcurvestartpoint|settilingoffset|polybuvwtweak|polybobjpaintcommit|deleteweight|getkbvalue|attach|deletetime|wm3_mc_hastarget|setneedsredraw|getmodcontextbboxmin|getnodebyname|breakcurve|getreactionname|doesfileexist|arbaxis|getnamedselsetitem|nodecolorpicker|getscriptindex|gettransformaxis)\b/i, null],
		 ['kwd3', /^(?:flightstudio.browser|flightstudio.refreshbrowser|flightstudio.getloddistance|flightstudio.setloddistance|flightstudio.isloddistanceset|flightstudio.lodleastdetail|flightstudio.lodlessdetail|flightstudio.lodmoredetail|flightstudio.lodmostdetail|flightstudio.creategroup|flightstudio.createobject|flightstudio.createswitch|flightstudio.createlod|flightstudio.createdof|flightstudio.createbsp|flightstudio.createclipregion|flightstudio.createexternalref|flightstudio.createlightpoint|flightstudio.getcomment|flightstudio.putcomment|flightstudio.hasdata|flightstudio.copydata|flightstudio.removedata|flightstudio.getlastimport|flightstudio.isoftype|flightstudio.setkeeptriangles|flightstudio.getkeeptriangles|flightstudio.addtextureattr|flightstudio.removetextureattr|flightstudio.getexternalreffilename|flightstudio.putexternalreffilename|flightstudio.getexternalrefflags|flightstudio.putexternalrefflags|isolatedvertices.check|isolatedvertices.haspropertydlg|isolatedvertices.showpropertydlg|browsermgr.newbrowser|browsermgr.numbrowsers|browsermgr.getbrowser|newscript|setopenscenescript|alignobject|setuseoldd3dcache|setcurvestartpoint|gettiling|polybuvwtweaksettings|polybobjinteractiveupdate|getweighttime|pickpoint|supportstimeoperations|wm3_mc_setvalue|intersectrayscene|displacementtopreset|getmodcontexttm|unhide|append|getfacenormal|popupmenu|getreactionfalloff|getbitmapsavefilename|intersectrayex|getcommandpaneltaskmode|hitbynamedlg|deletescript|affectregionval|hide|delete|yesnocancelbox|alignpivot|addnurbsset|clearprodtess|settiling|polybuvwtweaksetup|polybobjpaintsetup|getweight|pickobject|wm3_mc_getvalue|nodelocalboundingbox|sceneeffectloader.loadsceneeffect|sceneeffectloader.reseteffects|sceneeffectloader.enablesceneeffects|sceneeffectloader.issceneeffectsenabled|sceneeffectloader.getnumberofsceneeffects|sceneeffectloader.removesceneeffect|sceneeffectloader.getsceneeffect|snapshot|setfileattribute|getdialogbitmap|getreactionstrength|getbitmapopenfilename|oktobindtonode|getbackground|materialbrowsedlg|addscript|getscreenscalefactor|getmaterialid|walkthroughops.start|walkthroughops.resetstepsize|walkthroughops.stop|walkthroughops.level|group|bitmaplayermanager.getlayername|bitmaplayermanager.loadlayer|bitmaplayermanager.getlayercount|luminosityutil.illumination|querybox|worldalignobject|objxrefmgr.getrecord|objxrefmgr.findrecord|objxrefmgr.removerecordfromscene|objxrefmgr.mergerecordintoscene|objxrefmgr.setrecordsrcfile|objxrefmgr.updateallrecords|objxrefmgr.setxrefitemsrcname|objxrefmgr.setproxyitemsrcname|objxrefmgr.setxrefitemsrcfile|objxrefmgr.setproxyitemsrcfile|objxrefmgr.addxrefitemstorecord|objxrefmgr.addxrefitemsfromfile|objxrefmgr.cancombinerecords|objxrefmgr.combinerecords|objxrefmgr.removexrefitemsfromscene|objxrefmgr.mergexrefitemsintoscene|objxrefmgr.applyxrefmaterialstoxrefobjects|objxrefmgr.isnodexrefed|objxrefmgr.applyxrefcontrollerstoxrefobjects|objxrefmgr.resetxrefcontrollersprsoffset|objxrefmgr.canresetxrefcontrollersprsoffset|getnurbsset|clearviewtess|evalvtangent|polybuvtopoly|polybobjfill|insertwarpatorgtime|getsourcefileline|rotate|sort|wm3_mc_setname|nodegetboundingbox|referencereplace|getfileattribute|setdialogbitmap|getreactioninfluence|thawselection|setcacheentry|pow|nodeikparamschanged|getbackgroundcontroller|exclusionlistdlg|loadsnippetfiles|setmaterialid|messagebox|worldalignpivot|setviewtess|evalutangent|polybpolytouv|polybobjpaint|settwwarptime|wm3_mc_getname|getpointpos|instancereplace|free|getfilecreatedate|isdialogvisible|iviewportshadingmgr.selectshadowcastinglights|iviewportshadingmgr.selectilluminatinglights|iviewportshadingmgr.displayonlyselectedlights|iviewportshadingmgr.lockselectedlights|iviewportshadingmgr.getviewportshadinglights|iviewportshadingmgr.castshadowsselectedonly|iviewportshadingmgr.islightnodesupported|iviewportshadingmgr.isshadinglimitvalid|iviewportshadingmgr.reviewgpudiagnostics|iviewportshadingmgr.setviewportshadinglimits|getreactioncount|freezeselection|clearcacheentry|mod|mirrorikconstraints|forcecompleteredraw|completeredraw|savemoflowfile|xviewchecker.getnumcheckers|xviewchecker.getcheckername|xviewchecker.getcheckerid|xviewchecker.getactivecheckerid|xviewchecker.setactivecheckerid|xviewchecker.doescheckerhavepropdlg|xviewchecker.showcheckerpropdlg|xviewchecker.popupmenuselect|xviewchecker.selectresults|xviewchecker.displayresults|xviewchecker.registerchecker|xviewchecker.unregisterchecker|xviewchecker.runcheck|xviewchecker.getcurrentreturnval|xviewchecker.getcurrentoutputcount|xviewchecker.getcurrentstring|tangentcurve3d|zoom|closerolloutfloater|getnotetrack|custattributes.getpblockdefs|custattributes.getdefs|custattributes.getdef|custattributes.getdefinstances|custattributes.setdefdata|custattributes.redefine|custattributes.deletedef|custattributes.makeunique|custattributes.getdefclass|custattributes.getdefdata|custattributes.get|custattributes.add|custattributes.delete|custattributes.getscenedefs|custattributes.getowner|custattributes.count|custattributes.getdefsource|themixer.nummaxmixers|themixer.zoomextents|themixer.removemixerfromdisplay|themixer.togglemixer|themixer.setanimationrange|themixer.removemaxmixer|themixer.addmixertodisplay|themixer.hidemixer|themixer.getmaxmixer|themixer.updatedisplay|themixer.addmaxmixer|themixer.showmixer|centerobject|getviewtess|setpoint|polybuvstitch|pbtrackgettoolactive|settworgtime|wm3_mc_delete|intersects|isdeleted|pop.addidlearea|pop.addflow|pop.simulate|pop.regenerateselected|pop.deletepeople|pop.displayenv|pop.displaypeople|getfilemoddate|showdialog|nitrousgraphicsmanager.api|nitrousgraphicsmanager.isprogressiverenderingfinished|nitrousgraphicsmanager.progressiverendering|nitrousgraphicsmanager.setappwindowsize|nitrousgraphicsmanager.setappwindowpos|nitrousgraphicsmanager.pinviewpanelsize|nitrousgraphicsmanager.unpinviewpanelsize|nitrousgraphicsmanager.runmessageloop|nitrousgraphicsmanager.dumpmemoryinfo|nitrousgraphicsmanager.getsystemmemoryused|nitrousgraphicsmanager.beginperformanceprofiling|nitrousgraphicsmanager.endperformanceprofiling|nitrousgraphicsmanager.dumpmemoryinfotofile|nitrousgraphicsmanager.createdummyobjects|nitrousgraphicsmanager.settexturesizelimit|nitrousgraphicsmanager.setbackgroundtexturesizelimit|nitrousgraphicsmanager.getactiveviewportsetting|nitrousgraphicsmanager.getviewportsetting|nitrousgraphicsmanager.getworldsetting|nitrousgraphicsmanager.applyviewportviewsettingtolegacyview|nitrousgraphicsmanager.beginpartialupdatecomparetest|nitrousgraphicsmanager.endpartialupdatecomparetest|nitrousgraphicsmanager.getpartialupdatecomparetestresult|nitrousgraphicsmanager.isenabled|setreactionname|bipfixer.doangsmoothing|bipfixer.doangblurring|bipfixer.doadvangsmoothing|bipfixer.dopossmoothing|bipfixer.doposblurring|bipfixer.doremovekeys|bipfixer.dokneewobblefix|bipfixer.dokneeextensionfix|isselectionfrozen|filterstring|atan2|createlockkey|assignnewname|releasealloleobjects|axistripodlocked|loadmoflowfile|interpcurve3d|isdeformable|isspacewarpvalid|newrolloutfloater|numnotetracks|centerpivot|setprodtess|getpoint|polybuvspace|pbendtrack|deletetw|resample|timeslider.isvisible|timeslider.setvisible|setmesh|wm3_mc_rebuild)\b/i, null],
		 //[PR.PR_PLAIN, /^(?:[A-Za-z_]+[\w]*[\.][\w]*[A-Za-z_]+)/i, null],
		 [PR.PR_PLAIN, /^(?:[A-Za-z_]+[\w]*[\.][\w]*|[\w]*[\.][\w]*[A-Za-z_]+)/i, null],
         ['kwd4', /^(?:mesh|radiocontrol|progressbar|nurbs2railsweepsurface|groupboxcontrol|colorpickercontrol|binstream|nurbs1railsweepsurface|pickercontrol|anglecontrol|nurbscapsurface|slidercontrol|nurbslathesurface|spinnercontrol|nurbsextrudesurface|listboxcontrol|nurbsuvloftsurface|comboboxcontrol|nurbsuloftsurface|edittextcontrol|nurbsruledsurface|dotnetcontrol|view2dcontrol|maxmodifierarray|checkbuttoncontrol|integer|nurbsmirrorsurface|modifierclass|buttoncontrol|nurbsxformsurface|trimesh|bitmap|labelcontrol|nurbsoffsetsurface|maxmeshclass|rolloutcontrol|nurbsfilletsurface|mapsupportclass|rolloutfloater|nurbsmulticurvetrimsurface|material_editor|rolloutclass|nurbsnblendsurface|materiallibrary|mspluginclass|nurbsblendsurface|textureclass|maxcustattrib|nurbspointsurface|multimaterialclass|novalueclass|dotnetobject|hkey|maxcustattribarray|nurbscvsurface|activexcontrol|standardmaterialclass|booleanclass|dotnetmxsvalue|mscustattribdef|nurbssurface|mscommethod|unsuppliedclass|dotnetmethod|nurbstexturepoint|msdispatch|maxkey|emptyclass|dotnetclass|mousetool|set|nurbstexturesurface|okclass|maxcurvectl|nurbssurfacenormalcurve|undefinedclass|cccurve|nurbspointcurveonsurface|curvepointsarray|ctmotiontracker|class|nurbscurveonsurface|linkcontrol|maxkeyarray|ccpoint|ctbitmap|nurbssurfsurfintersectioncurve|control|ccrootclass|nurbsprojectnormalcurve|curvectlgeneric|multilistboxcontrol|nurbsprojectvectorcurve|nurbssurfaceedgecurve|color|nurbsisocurve|interval|nurbschamfercurve|nodeeventcallback|nurbsfilletcurve|datapair|hashtable|subanim|nurbsmirrorcurve|stringstream|staticmethodinterface|maxfilterclass|nurbsxformcurve|string|mixininterface|notetrack|nurbsoffsetcurve|interface|maxnotekey|nurbsblendcurve|safearraywrapper|menuitem|iobject|maxnotekeyarray|nurbspointcurve|bipedcopy|olemethod|actionpredicate|bigmatrix|nurbscvcurve|name|copycollection|oleobject|valueref|interfacefunction|bigmatrixrowarray|time|nurbscurve|mixer|pathname|structdef|usergeneric|subrollout|nurbscontrolvertex|mxtrackgroup|objectset|maxscriptfunction|nurbssurfconstpoint|mxtrack|windowstream|mappedprimitive|nurbscurvesurfaceintersectpoint|mxclip|filestream|primitive|nurbscurveintersectpoint|moflow|charstream|nodegeneric|nurbscurveconstpoint|moflowscript|mappedgeneric|nurbspointconstpoint|moflowsnippet|generic|nurbsindependentpoint|maxakey|moflowtransition|function|nurbspoint|imgtag|selectionset|moflowtraninfo|nurbsselection|arrayparameter|nurbsobject|selectionsetarray|multiplefsparams|nurbsselector|maxclass|object|nurbsgenericmethods|bitarray|bipedfskey|maxsuperclass|nurbsgenericmethodswrapper|array|value|bipedkey|shadowclass|edgeselection|msbipedrootclass|mpasscameffectclass|faceselection|bipedgeneric|effectclass|vertexselection|atmosphericclass|float|maxobject|maxtvutility|trackviewpick|rcmenu|maxtvnode|integerptr|maxrootscene|integer64|box2|maxreftarg|point2|double|point4|groupendcontrol|xrefscene|matrix3|number|groupstartcontrol|maxrootnode|motiontracker|eulerangles|mtlbuttoncontrol|changehandler|angleaxis|point3|mapbuttoncontrol|geomobject|timer|nurbsset|quat|bitmapcontrol|nodechildrenarray|nurbssurfaceapproximation|ray|checkboxcontrol|nurbsdisplay)\b/i, null],
         ['kwd5', /^(?:radiosity|wirepoint3|missing_rotation_control|thinwallrefraction|point_curveshape|ffd_3x3x3|minmaxavg|reaction_manager|sss_lambert_gamma__mi|turntogpoly|missing_osm|somniflect|paintboxstartup|sphericalcollision|jgradctldata|adt_category|physxbuoyancy|dgs_material__physics_phen|texture_vector__base|materialidrenderelement|texture_lookup__base|mia_material|planet__3dsmax|adsk_mtl_ceramic|illum_phong__base|adsk_blurred_reflection_multiplier|mib_light_point|mrarchmaterial_shader_x|edge__lume|mr_a_d_output__specular|expresssave|isolated_vertices|promaterials__metallic_paint_v2|mib_texture_filter_lookup_2|adsk_utility_shader_passthrough|kneeangle|catmotiondigitrot|motion_blur|particleview|geosphere|particlegroup|viz_radiosity|point3_list|linear_scale|missing_texturemap|cv_curveshape|projected|ffd3x3x3|global_clip_associations|reactionmanager|misss_lambert_gamma|ripplebinding|spaceffdbox|nodetransformmonitor|plug_in_manager|meshcollision|jpercent3data|adtcategory|dataopdeletecatcher|dgs_material_phen|mib_texture_vector|object_id|mib_texture_lookup|mrarchmaterialtexturemap|max_planet|simple_mtl_hardwood__adsk|mib_illum_phong|adsk_blurred_refraction_multiplier|lume_translucent_material__lambertian|mia_material_x|mradspecularresult|split_group|isolatedvertexclass|adsk_mtl_metallicpaint_v2|adsk_utility_state|adsk_shd_masonrycmu_v2|layerfloat|catmotionrotrotationcontroller|trimeshgeometry|point_surfgeometry|discreet_radiosity|point3list|bezier_scale|geo_cube__base|standarduvgen|nurbscurveshape|cameramap|globalclipassociation|reaction_master|ambient_reflective_occlusion__base|color_balance|wavebinding|sdeflector|nodemonitor|save_verification|curvecontrol|sortkey|maxscriptparticlecontainer|pluginmarkerforbox3|max_default_mtl_phen|wet_dry_mixer__lume|objectidrenderelement|max_architecturalmaterial|mia_physicalskylight|max_bitmap__3dsmax|adsk_mtl_hardwood|volume_light__3dsmax|mia_ciesky|shadow_transparency__base|simple_bumpmap_map___adsk|mr_a_d_raw__specular|lock_bond|faces_orientation|promaterials__water_v2|depth_of_field___bokeh|adsk_shd_wallpaint_v2|catclipfloat|catunitsscale|box|spin|point_surf|missing_radiosity|slave_point3|scale_expression|mib_geo_cube|missing_uvgen|cv_curve|point_cache|multiple_delegates|reactionmaster|mib_amb_occlusion|colorbalance|spacepathdeform|alpha|spaceskew|captured_object_state|base_layerbase_layer|doublepacket|raytrace_texture_paramblock|mxsparticlecontainer|popcharacter|invisible__physics_phen|wet|luminance_hdr_data|icon|max_base_translucentillumination|car_paint_shader__mi|max_bitmap|simple_mtl_concrete__adsk|max_volumelight|glaretexturemap|mib_shadow_transparency|adsk_map_simple_bumpmap|mradspecularraw|container|flippedfacesclass|adsk_mtl_water_v2|adsk_map_lens_bokeh|adsk_shd_sss_v2|imagemotionblur|layerinfo|rootnodeclass|sphere|shapestandard|cv_surf|linear_exposure_control|slavepoint3|tcb_scale|lookup_cube1__base|standardxyzgen|point_curve|pointcache|multdeleg|dwgenhcolorpacket|sss_passthrough_shader__mi|gravitybinding|path_follow|iklimb|vzobjecttablerecord|empty_flow|lzflare_data|inputstandard|transmat_phen|edge_shadow__lume|luminancerenderelement|color_average__base|mi_car_paint_phen_max|max_dummy|adsk_mtl_concrete|max_spotlight|max_glare|illum_ward_deriv__base|hdr_image_motion_blur__mi|mr_a_d_level__specular|containerhelper|overlapping_faces|promaterials__metal_v2|adsk_tex_gradient|adsk_metal_patterns__knurls_v2|nlainfo|physxshapeconvex|cylinder|film_grain|scaleparticles|nurbssurf|automaticlinearexposurecontrol|noise_point3|scalexyz|mib_lookup_cube1|missing_xyzgen|linkblockinstanceshape|old_point_cache|wander_behavior|reaction_set|misss_call_shader|windbinding|spacenoise|splineiksolver|boolpacket|emptysource|midi_device|inputcustom|missing_mtl|edgeshadow|illuminance_hdr_data|mib_color_average|max_mia_material_renderelements|light_lines|simple_mtl_generic__adsk|vertex_color__3dsmax|render_subset_of_scene_masking__mi|mib_illum_ward_deriv|mip_motionblur|mradspecularlevel|particle_paint|overlappingfacesclass|adsk_mtl_metal_v2|simple_marble_map__adsktexturemap|adsk_tex_marble|ease|physx_shape_convex|torus|filmgrain|pyramid|flow|pseudo_color_exposure_control|point3_motion_capture|scale_reactor|max_base_multilayerillumination|standardtextureoutput|simple_spline|old_pointcache|wanderbehavior|reactionset|sss_fast_render_shader__mi|displacebinding|spaceffdcyl|meshprojintersect|materialhelper|ikhisolver|dwgblockinsertfilter|jbinarydata|tvnode|input_proxy|notexture|mybricks|illuminancerenderelement|lume_glow_material__lambertian|metronome|contour_shader_lightlines|adsk_mtl_simplegeneric|max_vertexcolor|mip_render_subset|lookup_spherical__base|simple_noise_map__adsk|mr_a_d_output__reflections|spraymaster|xview|promaterials__hardwood_v2|adsk_map_simple_marble_v2|adsk_utility_mix8shader|catliftplantmod|skeleton|torus_knot|depth_of_field|linkblockinstance|popskinobject|pseudocolorexposurecontrol|missing_point3_control|scalereactor|max_topbottommaterial|missing_texture_output_plug_in|simple_shape|xform|cogcontrol|project_mapping|misss_fast_shader|deflectorbinding|missing_wsm_object|max_master_clip|shape_instance|beauty|dwgfilterlist|painterinterface|ik_controller|inputproxy|raytrace|dielectric_material__physics|hairrenderelement|max_base_metalillumination|hair_gi_atmospheric|reflect__base|simple_mtl_stone__adsk|combi__contour|motion_vector_export__mi|mib_lookup_spherical|adsk_map_simple_noise|mradreflectresult|materialcategory|geometrycheckermanager|adsk_mtl_hardwood_v2|adsk_tex_cellular|adsk_utility_colorstate|cat_liftplantmod|ragdollhelper|targetobject|dofeffect|chamfercyl|spinlimit|logarithmic_exposure_control|prs|audioscale|night__lume|default_scanline_renderer|missing_shape|symmetry|surface_arrive_behavior|projectionmodtypeuvw|sss_specular_reflections_for_skin__mi|bombbinding|targa|select_the_biped_for_use_as_a_retargeting_reference|shape_mark|beautyrenderelement|dwgenhancedlayerfilter|thepainterinterface|mouse_input_device|outputstandard|checker|dielectric_material|ambient_occlusion|max_blendmaterial|hairgiatmospheric|mib_reflect|adsk_mtl_stone|contour_shader_combi|mip_motion_vector|color_mix__base|adsk_metal_switch_color_shader|mr_a_d_raw__reflections|curveclass|particle_flow_global_actions|promaterials__mirror_v2|adsk_shd_ceramic_v2|adsk_utility_contrast|catmotionlayer|d6joint|morph|lens_effects|spring|randomwalk|lightscapeexposurecontrol|lookat|scale_list|night|defaultscanlinerenderer|slicemodifier|surfacearrivebehavior|reftargcontainer|misss_skin_specular|mcloth|vortexmod|tgaio|scene_state|shape_facing|specular|dwgtablerecord|lzflare_glow_data|joystick_input_device|outputcustom|marble|max_defaultmaterial|ambientocclusionbakeelement|color_spread__base|hair_atmospheric|falloff__3dsmax|matte_shadow_reflection__mi|volume_fog__3dsmax|adsk_utility_bitmap_tweak|mib_color_mix|environment_background_camera_map__mi|mradreflectraw|preset_flow|flipped_uvw_faces|adsk_mtl_mirror_v2|adsk_metal_cutouts_shape|adsk_tex_output|cathierarchyroot|ragdollvisualizer|tape|editable_patch|apollo_effect|railing|automatic_exposure_control|slave_control|scalelist|stain__lume|vue_file_renderer|turn_to_poly|multiple_delegate_settings|turbosmooth|lens_stencil__base|pbombmod|yuv|deleteparticles|specularrenderelement|vzobjecttable|lzflare_autosec_data|missing_reftarget|stop_gradually|outputnew|wood|falloff2__3dsmax|hairlightattr|mib_color_spread|hairatmospheric|max_falloff|adsk_mtl_matteshadowreflections|max_volumefog|architectural__environment_portal|flat_mirror__3dsmax|mip_cameramap|mr_a_d_level__reflections|presetflow|flippeduvwfacesclass|promaterials__concrete_v2|adsk_bitmaptexturemap|adsk_tex_water|catweightshift|uconstraint|point|loftobject|file_output|wall|quadpatch|garment_maker|automaticadaptiveexposurecontrol|ikcontrol|slavescale|stain|mental_ray_renderer|ffd_select|setting|projection|mib_lens_stencil|tripatch|mapscaler|ifl|force|diffuse|dwgextrusionfilter|lzglow_rend_data|bend|copy_out|outputtest|dent|blur|max_falloff2|float_mixer_controller|max_base_wardillumination|dialogmonitor|mask__3dsmax|simple_mtl_metal__adsk|contour_store_function__contour|mia_portal_light|max_flatmirror|color_correction__adsk|mradreflectlevel|prooptimizer|multiple_edges|adsk_mtl_concrete_v2|adsk_utility_scalarshaderswitcher|simple_noise_map__adsktexturemap|weightshift|nvconstraint|pointhelperobj|fileout|rmmodelgeometry|garmentize2|missing_exposure_control|splineikchain|scale_script|xyz_generator__3dsmax|missing_renderer|paste_skin_weights|path_follow_behavior|projectionmod|max_gnormal|loft|catia_v4_import|mapscalerspacewarpmodifier|bmp|position_object|diffuserenderelement|int64packet|lzflare_mansec_data|bendmod|display_script|convert|dents|max_defaultshadow|float_limit|contour_contrast_function_simple__contour|simplefacedata|max_mask|adsk_mtl_metal|contour_store_function|adsk_shd_solidglass_spider|contour_store_function_simple__contour|adsk_utility_color_correction|mr_a_d_output__transparency|quadify_mesh|multipleedgeclass|promaterials__stone_v2|adsk_shd_hardwood_v2|adsk_map_simple_noise_v2|catpivotrot|birth_file|protractor|brightness_and_contrast|spray|cloth|motion_blurmpasscameffect|tvdummycontrol|scale_wire|max_base_xyzgenerator|fog|pasteskinweights|pathfollowbehavior|skin_wrap_patch|max_physicalsun|jt_import|spacecameramap|bmpio|speedbyicon|self_illumination|contour_data_packet|jworlddata|taper|displayscriptparticles|functionreferencetarget|mask|max_base_videosuperblack|floatlimitctrl|contour_contrast_function_simple|float_layer|smoke__3dsmax|simple_mtl_water__adsk|max_scenedata|simple_colormap_map___adsk|contour_store_function_simple|simple_hemispherical_map__adsk|mradrefractresult|quadmesh|flight_studio_bitmap_class_name|adsk_mtl_stone_v2|adsk_utility_change_range|architectural__photometric_light|pivotrot|dwgcolormaterialpacket|dummy|britecon|tube|snow|clothfx|multipassmotionblur|substituion_offset_transform|wirescale|max_doublesidedmaterial|volume_fog|uvw_mapping_clear|seek_behavior|skinwrappatch|max_completebakeelement|solidworks_import|catia_v5_import|spaceconform|jpeg|keep_apart|emissionrenderelement|contour_translator|lzflare_star_data|camera_culling|scalar|masktex|bump_capture__lume|scene_effect_loader|pseudo_color_camera_exposure__3dsmaxtexturemap|layer_output|max_smoke|adsk_mtl_water|illum_blinn__base|adsk_map_simple_colormap|lookup_cylindrical__base|adsk_map_hemispherical_bitmap|mr_a_d_raw__transparency|welder|flttextureattrcustattrib|promaterials__plastic_vinyl_v2|adsk_tex_concrete_smoothbumptex_v2|mia_photometric_light|digitdata|fbxmaxrevitfactory|bone|rotation|lighting_analysis_overlay|mesher|cone|hairmod|ripple|depth_of_fieldmpasscameffect|link_transform|noise_scale|texture_polka_dot__base|volume_light|mapchanneldelete|seekbehavior|skin_wrap|max_specularbakeelement|step_import|point_cachespacewarpmodifier|jpegio|speed_by_surface|reflection|raster_image_translator|jcolordata|cameraculling|randomreferencetarget|rgb_tint|bumpcapture|sharedmotionflowsfloatcontroller|max_toneoppseudo|float_listdummyentry|perlin_marble__3dsmax|simple_mtl_metallicpaint__adsk|mib_illum_blinn|colorcorrection__3dsmax|mib_lookup_cylindrical|adsk_shd_glazing_spider|mradrefractraw|fltimport|linktimecontrol|adsk_mtl_plasticvinyl_v2|adsk_shd_concrete_v2|adsk_utility_patterngenerator|catlimbdata2|dwgcolorsplitbymaterialfilter|sound|lightinganalysisoverlay|particlemesher|teapot|importtrc|wave|multipassdof|ikchaincontrol|scale_motion_capture|mib_texture_polkadot|fire_effect|uvw_mapping_paste|avoid_behavior|meshdeformpw|max_blendbakeelement|ug_nx_import|pointcachewsm|avi|birth_script|reflectionrenderelement|texmaps_raytracemtl|raymeshgridintersect|camera_imblur|vector|rgbtint|wraparound__lume|reservoir|depth_fade__contour|point3_layer|max_perlinmarble|adsk_mtl_metallicpaint|max_gizmodata|max_colorcorrection|color_interpolate__base|adsk_shd_stone|mr_a_d_level__transparency|openfltexport|body_cutter|promaterials__masonry_cmu_v2|adsk_utility_simplemixer|simple_hemispherical_map__adsktexturemap|limbdata2|physxpanel|ik_spline_end_twist_manip|missing_render_effect|plane|editable_mesh|importhtr|edit_mesh|depth_of_field__mental_ray|transform_script|missing_scale_control|beam__lume|xrefatmoswrapper|mapchannelpaste|avoidbehavior|project_mapping_holder|lens_clamp__base|proengineer_import|old_point_cachespacewarpmodifier|rla|script_operator|refraction|dwgpointtrans|adt_syleleaf|cameramblur|objectreferencetarget|mix|wraparound|point3_mixer_controller|contour_shader_depthfade|point3layer|max_base_anisotropicillumination|simple_mtl_mirror__adsk|thin_wall_refraction__3dsmax|arch__environment_blur|mib_color_interpolate|utility_mix2shader__protein|mradrefractlevel|simple_mtl_radiance__adsk|body_object|adsk_mtl_masonrycmu_v2|color_override_ray_type_switcher|adsk_map_hemispherical_bitmap_v2|mocaplayer|physxpanelreferencetarget|ikendsptwistmanip|area|meshgrid|hedra|inventorimport|edit_spline|mrdof|link_constraint|barycentric_morph_controller|beam|renderenvironment|uvw_mapping_add|clipstate|projectionholderuvw|mib_lens_clamp|proengineer_assembly_import|old_pointcachewsm|rpf|notes|refractionrenderelement|dwgentitypacket|ring_element|mp_worldhelper|switch|mixtexture|max_defaultlight|matrix3_mixer_controller|width_from_light_dir__contour|point3_listdummyentry|illum_lambert__base|adsk_mtl_mirror|max_thinwallrefraction|mia_envblur|environment__3dsmax|adsk_utility_mix2shader|mr_a_d_output__translucency|adsk_utility_mia_basic|catbone|promaterials__wall_paint_v2|adsk_utility_color_override|adsk_utility_mix2color|mocaplayerinfo|mental_ray_material_override_options|ik_chain_object|quadratic|l_ext|missing_geomobject|exporthtr|relax|standin_for_missing_multipass_camera_effect_plugin|link|cubic_morph_controller|max_directionallight|missing_atmospheric|mapchanneladd|wall_seek_behavior|edit_poly|max_alphabakeelement|physx_and_apex_exporter|parameter|particle_cache|gif|cache|shadowrenderelement|dwgcamerapacket|dummyradmapclass|physxworld|amountchange|noise|submerge__lume|slavematrix3|contour_shader_widthfromlightdir|position_layer|mib_illum_lambert|simple_mtl_plastic_vinyl__adsk|light_spot__base|adsk_metal_noise_anodized|max_environment|max_lightmap_lightmeter_shader|mradtranslucentresult|mi_car_paint_phen|fbxmaxwrapper|adsk_mtl_wallpaint_v2|adsk_utility_xyzgenerator|adsk_shd_brick_spider|layerweights|one_click_particle_flow|slider_manip|parray|freecamera|dwf_exporter|edit_patch|linear_float|ik_controllermatrix3controller|missing_morph_control|glare__lume|link_inheritance__selected|negative|select_by_channel|wallseekbehavior|editpolymod|max_lightbakeelement|autodesk_alias_wire_export|particlecache|tif|catmull_rom|material_static|atmosphere|hsutil|radiancemap|blurwind|condition|bitmaptexture|submerge|xref_controller|curvature__contour|positionlayer|max_base_phongillumination|adsk_mtl_plasticvinyl|mib_light_spot|adsk_shd_masonrycmu_spider|parti_volume__physics|max_lightmeterlightmap|mr_a_d_raw__translucency|mi_car_paint_phen_x|body_utility|promaterials__solid_glass_v2|adsk_utility_scalarstate|adsk_utility_falloff|catclipweights|oneclicksource|crash_utility_plugin|cubic|slidermanip|spindle|targetcamera|xref_material|twist|bezier_float|missing_matrix3_control|master_point_controller|glare|instance_duplicate_maps|selectbychannel|clipassigner|skin_morph|mib_continue|wire_export|path_followmod|tifio|blackman|material_dynamic|atmosphererenderelement|stddualvs|jcolor3data|data_operator|bitmaptex|oversampling_lens__physics|ik_position_controller|contour_shader_curvature|position_listdummyentry|dgs_material_photon__physics|color_correction|max_raytracematerial|utility_elliptical_tex__protein|max2_parti_volume|utility_texlookup__protein|mradtranslucentraw|adsk_utility_color_to_bool|join_bodies|adsk_mtl_solidglass_v2|simple_mtl_metal_v2_adsk|environment_blur|layerroot|iray_plugin_options|crashonexitutility|proxsensor|apollo_param_container|missing_camera|xrefmaterial|extrude|select_object|float_expression|linear_position|block_control|water_surface__lume|instanceduplmap|melt|space_warp_behavior|morphbybone|max_normalsbakeelement|sss2_skin_displacement|motormod|eps_image|sharp_quadratic|material_frequency|blendrenderelement|dwgfactory|lzflare_rend_data|dataoperator|reflect_refract|oversampling_lens|position_mixer_controller|max_base_meditbackground|rotation_layer|dgs_material_photon|colorcorrection|max_base_curvecontrol|adsk_utility_ellipttex|max_objectdata|adsk_utility_texlookup|mr_a_d_level__translucency|adsk_utility_bool_to_int|body_join|normals_bumpmap|adsk_shd_metal_v2|adsk_environment_blur|catcliproot|substancepbwrapper|cone_angle|apolloparamcontainer|omnilight|hair_mr_geom_shader|lathe|geometryreferencetarget|tcb_float|bezier_position|masterlist|watersurface|maxscript|shell|wsmbehavior|renderable_spline|max_rttcagedata|misss_mia_skin2_phen_d|displace_mesh|psd_i_o|video|age_test|z_depth|stringpacket|renderelementmgr|data_icon|reflectrefract|xyz_coordinate__3dsmax|rotation_mixer_controller|frame_fade__contour|rotationlayer|transparency__base|adsk_metal_patterns__knurls|two_sided__base|simple_image_map__bitmap___adsk|max_nodedata|adsk_shd_water_spider|mradtranslucentlevel|adsk_area_shadow_samples|hubobject|component_falloff|adsk_shd_metallicpaint_v2_adsk|simple_color_map__adsk|catfootbend|surface|substancetexwrapper|coneanglemanip|conform|hairmrgeomshader|bevel|notesreferencetarget|block_manager_wrapper|path_constraint|masterblock|glass__lume|surface_approximation|turn_to_patch|crowdassignment|rendspline|max_shadowbakeelement|sss2_skin|dragmod|hdri|plate_match_max_r2|spawn|zrenderelement|alwaysequalfilter|this_data|directionallight|dataopericon|flat_mirror|max_xyzcoordinate|scale_mixer_controller|contour_shader_framefade|rotation_listdummyentry|mib_transparency|ambient_reflective_occlusion__3dsmax|mib_twosided|adsk_map_simple_bitmap|composite__3dsmax|adsk_shd_metal_spider|mr_a_d_output__diffuse_indirect_illumination|adsk_shd_metallicpaint_mia__adsk|muscle_strand|illumination_phong|adsk_shd_metallicpaint_v2|adsk_map_simple_color_v2|footbend|massfx_rbody|falloff_manipulator|chamferbox|stretch|blockmgrwrapper|path|master_controller_plugin_not_found|glass|substitute_manager|converttopatch|crowdteam|max_cameramap|misss_mia_skin2_phen|subdividespacewarpmodifier|cook_variable|collision|dwgenhlayerpacket|lzhilight_rend_data|data_test|flatmirror|max_shellacmaterial|point4_mixer_controller|volume__base|scale_layer|water__3dsmax|max_amb_occlusion|max_base_curve|mia_cieskylight|max_composite|adsk_shd_metallicpaint_spider|mraddiffuseindirectillumresult|adsk_shd_metallicpaint_mia|musclestrand|particles|illumination_phong_phen|unified_image_map__bitmap___adsk|adsk_utility_float3_to_float|catlegweight|physxmodrb|falloffmanip|editable_poly|alpharenderelement|hsds|targetdirectionallight|audiofloat|position_expression|bezier_point4|mist__lume|level_of_detail|stl_check|crowdgroup|light_photometric__base|mib_map_get_integer_array|uomniflectmod|qtime|soften|collision_spawn|dwgblockinsasnodehierarchyfilter|lzflare_ring_data|datatest|gradient|max_unknownmaterial|slavepoint4|mib_volume|scalelayer|max_water|sss_fast_render_shader___mi|illum_hair__base|adsk_shd_mirror_spider|color_alpha__base|bump_combiner__adsktexturemap|mr_a_d_raw__diffuse_indirect_illumination|adsk_bitmap|muscle_handle|pipereferencetarget|conversion_color_to_float|adsk_map_unifiedbitmap_v2|adsk_tex_bricks|legweight|wire_import|hotspot_manip|rgb|editablepolymesh|mib_cie_d|backgroundrenderelement|hsdsobject|ies_sun|sunlight_daylight_slave_intensity_controllerfloatcontroller|position_constraint|bezier_rgba|mist|asset_browser|cap_holes|wall_repel_behavior|adobe_illustrator_shape|mib_light_photometric|sss2_shadertexturemap|simpleosmtowsmmod2|cmb|mitchell_netravali|speed_test|dwglightpacket|raytraceglobalsettings|test_icon|compositetexturemap|adjustments__lume|procutter|illum_cooktorr__base|scale_listdummyentry|wood__3dsmax|misss_fast_shader_x|mib_illum_hair|arch__dof___bokeh|mib_color_alpha|adsk_utility_mix3bump|mraddiffuseindirectillumraw|mi_metallic_paint_x|hdlobjobj|shapecontrol|math_color_mix|adsk_utility_vectorstate|adsk_utility_float3_to_color|catpivotpos|apf_import|hotspotmanip|pcloud|shavemrhairshadows|bgndrenderelement|hsds_modifier|freeiessun|adt_object_manager_wrapper|tcb_position|tcb_point4|translucency__lume|ifl_manager|preserve|wallrepelbehavior|autocadimport|max_diffusebakeelement|misss_fast_shader2|standard|simpleosmtowsmmod|cin|blendfilter|find_target|dwgblockdefinitionfilter|auto_secondary_element|datatesticon|compositetexture|adjustments|proboolean|mib_illum_cooktorr|point4_layer|max_wood|adsk_utility_genericnoise|illum_ward__base|mia_lens_bokeh|bump_basis__base|adsk_scale_meters_to_internal|mr_a_d_xtra__diffuse_indirect_illumination_with_ao|node_visibility|catmuscle|discretizator|component_reflection|adsk_shd_metallicpaint_v2_spider|adsk_utility_intstate|pivotpos|vector_displacement|ik_swivel_manip|oiltank|mib_bent_normal_env|lighting|face_extrude|free_light|adtobjmgrwrapper|position_xyz|color_rgba|translucency|com_dcom_server_control|edit_normals|crowdtransition|fbximp|max_heightbakeelement|sss_lightmapping_shader|spacepatchdeform|portable_network_graphics|filter_kernel_plug_in_not_found|scale_test|dwghandlefilter|asec_element|presetoperator|compositemap|texture_wave__base|proboolobj|dielectric_material_photon__physics|point4layer|stucco__3dsmax|adsk_shd_masonrycmu|mib_illum_ward|adsk_utility_noise_tweakable|mib_bump_basis|max_rtt_output|mraddiffuseindirectillumwithao|max_nodevisibility|lockedobjectwrapper|objectparameter|texture_lookup_2d|adsk_ss_environment|adsk_utility_condition|catpoint3|vdm|ikswivelmanip|speed|rmmodel|contrast|shavemrhairillum|lightingrenderelement|free_point|float_script|stop|position_list|point4_xyzw|dielectric_material__3dsmax|fix_ambient|editnormals|transition|fbximporter|max_reflectrefractbakeelement|misss_lightmap_phen|pushmod|pngio|phong|script_test|dwgtableentrypacket|gradient_gradctldata|presetopericon|rgb_multiply|mib_texture_wave|mr_sky|dielectric_material_photon|point4_listdummyentry|max_stucco|adsk_environment|displace|pseudo_color_camera_exposure__3dsmax|mr_raytype_switcher__advanced|max_standardmaterial|adsk_utility_lightmapswitcher|mr_a_d_raw__ambient_occlusion|mip_rayswitch_stage__mi|catparent|colorreferencetarget|math_color_multiply|adsk_utility_int_to_float|adsk_tex_wood|catp3|max_vdm|plane_angle|bonegeometry|mib_texture_lookup2|matterenderelement|free_area|float_wire|mirror|positionlist|point4_wire|max2_dielectric_material|fixambient|splineselect|surface_follow_behavior|stl_import|sss_lightmap_write__mi|adsk_utility_color_to_booltexturemap|spacesurfdeform|phong2|send_out|dwgcolorfilter|jangledata|presettest|rgbmult|texture_checkerboard__base|mrphysskylight|factor_color__contour|dwgmaterialfilterreferencemaker|bricks__3dsmax|adsk_decal|linked_xform|contour_contrast_light_levels|mip_rayswitch_advanced|parti_volume_photon__physics|adsk_scale_meters_to_internal_inverse|mradidirectao|mip_rayswitch_stage|iktarget|input_mparticles|normals_make_normal|simple_colormap_map__adsk|adsk_tex_smoke|channel|catmotiontail|substanceshader|planeanglemanip|boneobj|sgi|max_multimaterial_contour|ink|free_rectangle|wirefloat|audioposition|wirepoint4|transmat_photon__physics|camera_tracker|materialbyelement|surfacefollowbehavior|filelinkasdwgimporter|misss_lightmap_write|misss_set_normal|udeflectormod|blinn|split_amount|custattribcontainer|jfloat3data|presettesticon|fallofftexturemap|mib_texture_checkerboard|mr_sun|contour_shader_factorcolor|dwgmaterialpacketreferencemaker|max_bricks|adsk_shd_glazing|linkedxform|material_to_shader|simple_checker_map__adsk|max2_parti_volume_photon|max_rtt_lens|mr_a_d_output__self_illumination|multi_sub_map|iktargetobj|inputphysx|conversion_float_to_color|adsk_map_simple_colormap_v2|autodesk_map|catparenttrans|adsk_utility_alpha_from_shader|spheregizmo|ringwave|flightstudioimage|height_map_displacement__3dsmax|inkrenderelement|target_linear|float_list|position_script|point4_script|transmat_photon|visual_maxscript|turn_to_mesh|smoothreferencetarget|mental_ray_import|max_is_material_editor|mib_map_get_vector|sdeflectmod|blinn2|split_source|floatpacket|jfloatdata|presetdummyoperator|output|geo_instance__base|mentalraysun|photon_basic__base|mr_proxy|particle_blur__3dsmax|adsk_shd_lightmap|affect_region|max_materialtoshader|adsk_map_simple_checker|add_uv_texsurf__base|adsk_shd_plasticvinyl|mradselfillum|max_multisubmap|musclepatch|output_mparticles|math_color_add|adsk_shd_stone_v2|autodeskmap|arbbone|substance|cylgizmo|straight_stair|nomaterial|max_heightmapdisplacement|paint|ies_sky|floatlist|position_wire|point4_list|add|geo_torus__base|visualmsutil|uvw_xform|clip_associations|mrimporter|sss_physical_shader__mi|mib_map_get_scalar_array|displace_nurbs|metalshader|split_selected|dwgplugintranslatorforwardingfilter|vzmaterialtable|presetdummyopericon|text|vertex_color|mib_geo_instance|shavestylinicon|mib_photon_basic|mental_ray_proxy|max_particleblur|adsk_shd_wallpaint|uvwmap|particle_age__3dsmax|mr_matte_shadow_reflection|mib_geo_add_uv_texsurf|utility_colorcorrection_maya_shaders__protein|mr_a_d_output__opacity_background|mi_metallic_paint_output_mixer|lockedobjectwrapper_obsolete|outputphysx|lockedmapwrapper|kelvin_temperature_color|multioutputchanneltexmaptotexmap|arbbonetrans|substancetexture|boxgizmo|c_ext|standardmaterial|max_shellacmaterial_contour|paintrenderelement|iesskylight|instance_manager_wrapper|wireposition|point4list|mib_geo_torus|strokes|patchdeform|clipassociation|iges_import|misss_physical|max_shadowwrapper|somniflectmod|metal2|go_to_rotation|nullfilter|filelink_vzmaterialtable|presetdummytest|vertexcolor|parti_volume_photon__physicstexturemap|hair_atmospheric_gizmo|lightmap_sample__base|mr_sky_portal|contour_contrast_function_levels__contour|mr_labeled_element|vol__select|max_particleage|mip_matteshadow|max_omnilight|adsk_utility_colorcorrection2|mradopacitybackgroundresult|adsk_shd_metal__blender|fbxmaxfactory|mparticles_flow|adsk_utility_nodevisibility|adsk_kelvin_2_color|quicksilver_hardware_renderer|hdltrans|substance_output|position_value|terrain|shavemrvertexillum|lumination_render_element|target_light|instancemgrwrapper|slavepos|missing_point4_control|texture_polka_sphere__base|follow_bank|nsurf_sel|repel_behavior|vrmlimp|default_sound|mib_map_get_color|pomniflectmod|oren_nayar_blinn|anchor|pointpacket|mroptions|cache_selective|topbottom|splat|parti_volume_photon|hairatmosphericgizmo|mib_lightmap_sample|mrskylightportal|contour_contrast_function_levels|max_mrstoreelement|volumeselect|max_base_output|simple_speckle_map__adsk|mix__3dsmax|utility_color_correction_internal__protein|mr_a_d_raw__opacity_background|max_toneopphoto|fbxmaxfilterlist|physxflow|adsk_mia_optimizer|simple_gradient_map__adsk|polytoolsselect|layermatrix3|substanceoutput|positionvaluemanip|oldboolean|mib_fg_occlusion|luminance_render_element|target_point|boolean_float|springpositioncontroller|mib_texture_polkasphere|channel_info|ncurve_sel|repelbehavior|xmlimp2|missing_soundobj|mib_map_get_scalar|surface_mapper|orennayarblinn|audioclip|intpacket|mrpbparameter|cacheselective|topbottommat|stucco|max_photometricpointlight|dwgmaterialfilter|dent__3dsmax|target_sphere|uv_coordinate__3dsmax|max_mrstoreelements|materialmodifier|max_raytrace|adsk_map_simple_speckle|max_mix|adsk_utility_colorcorrection|mradopacitybackgroundraw|mip_fgshooter__mi|fbxmaxtablerecord|dataviewgroup|adsk_tex_checker|adsk_map_simple_gradient_v2|polytoolsmodeling|catclipmatrix3|lens_effects_hilight_filter|awning|character|connect|shavemrrendercomp|lumrenderelement|target_area|boolcntrl|positionspring|glow__lume|treeviewutil|sweep|oldvertexpaint|scatterreferencetarget|landxml___dem_model_import|clone_and_align_tool|mib_map_get_integer|ffd_binding|strauss|billboard|blockinstancefilter|standard_flow|cache_disk|multimaterial|smoke|landscape__lume|dwgmaterialpacket|max_dent|target_disc|max_uvcoordinate|adsk_shd_solidglass|max_compositematerial|environment_probe_gray_ball__mi|fog__3dsmax|adsk_shd_stone_spider|mr_a_d_level__opacity|mip_fgshooter|fbxmaxbymaterialfilter|persistentnodeset|simple_bumpmap_map__adsk|adsk_utility_colorbyobject_switch|polytoolstopology|catgizmotransform|lens_effects_glow_filter|characterhelper|damper|shavemrhairgeomdra|illumination_render_element|target_rectangle|slavefloat|position_reactor|smoothmodifier|glow|skinutilities|pivoted|multires|objassoc|landxmlimport|angle|object_display_culling|mib_map_get_transform|missing_wsm|anisotropic|background|raster_image_packet|defaultsource|cachedisk|multisubmaterial|shader_list__environment|landscape|reftargmonitor|tint__3dsmax|free_cylinder|checker__3dsmax|adsk_utility_bitmap|gradient__3dsmax|mip_grayball|max_fog|adsk_shd_plasticvinyl_spider|mradopacity|object_color|fbxmaxobjtranslator|cachefile|adsk_map_simple_bumpmap_v2|adsk_shd_lightmap_v2|polytoolspolydraw|catdigitsegtrans|crosfade|luminaire|gengon|max_blendmaterial_contour|illuminance_render_element|free_linear|block|positionreactor|normalmodifier|texture_turbulence__base|skintools|bifold|mrmmod|physique|displayculling|inverse_of_photographic_exposure|spacebend|edge|multi_layer|timesensor|adtobjtranslator|jbooldata|displaydata|doublesided|shader_list__texture|texture_rotate__base|indirectreftargcontainer|max_tint|free_disc|max_checker|adsk_shd_hardwood_spider|max_gradient|max_lightmetermaterial|lookup_background__base|adsk_shd_ceramic_spider|mr_labeled_elementrenderelement|max_wirecolor|fbxmaxbyrevitcategoryfilter|persistentisolationdata|adsk_utility_miadecomposer|adsk_utility_color_to_float3|polytoolspaintdeform|digitsegtrans|optimize|luminairehelper|foliage|max_doublesidedmaterial_contour|illumrenderelement|skylight|float_reactor|noise_position|skin|mib_texture_turbulence|resource_collector|fade|casement|skew|vector_field_modifier|adobe_illustrator|default_color_picker|mia_exposure_photographic_rev|smooth|bendmodwsm|multilayer|navinfo|missing_refmaker|jpercentdata|mp_shape|doublesidedmat|gradient_ramp|subdivide|mib_texture_rotate|arch___design__mi|contour_ps__contour|target_cylinder|speckle__3dsmax|adsk_shd_hardwood|simple__contour|simple_marble_map__adsk|mib_lookup_background|utility_bumplookup__protein|mrnamedrenderelement|adsk_shd_sss|fbxmaxbyobjectfilter|particle_face_creator|adsk_utility_luminancetointensity|adsk_light_default|polytoolsshift|hubtrans|linkoriginpthelper|pf_source|max_base_gbuffer_lens|missing_render_element_plug_in|texture_sky|floatreactor|attachment|unwrap_uvw|physical_light__physics|rayfx|fixed|vertex_weld|vector_field|dwg_exportexporterplugin|parametereditor|shavemrsatdata|spacetaper|translucent_shader|foghelper|ray_engine|lzfocus_data|physxshape|blend|shader_list__output|texture_remap__base|mrarchmaterial|contour_ps|free_sphere|max_speckle|adsk_shd_concrete|contour_shader_simple|adsk_map_simple_marble|fire_effect__3dsmax|adsk_utility_bumplookup|mr_photographic_exposure_control|rgb_to_bw|fbxmaxbyrevittypefilter|particlecreatorosm|adsk_utility_curve|adsk_utility_invertscalar|polytoolsuvwtweak|hub|daylightassemblyhead|cookie|polymorphicgeom|max_compositematerial_contour|completemap|texskylight|sunlight_daylight_slave_intensity_controller|surface_position|uvwunwrap|physical_light|rayfxutil|panorama_exporter|vertexweld|vectorfield|dwg_export|walkthroughgup|sss2_surface_shader|spaceripple|translucent|lod|morph_angle_deformer|dwglayertable|mp_collision|shell_material|perlin_marble|mib_texture_remap|car_paint_material__mi|noise__3dsmax|axis_helper|opacity__base|adsk_shd_concrete_spider|dgs_material_photon__3dsmax|mr_binary_proxy|max_fireeffect|utility_colorpassthrough__protein|mrtonemapexposurecontrol|to_bw|fbxmaxoneobjectfilter|particle_skinner|adsk_shd_glazing_v2|adsk_utility_vectorcoords|caddy|catmotionhub2|reactor_angle_manip|boolean2|mib_blackbody|missing_light|noise_float|position_motion_capture|spline_ik_control|geo_instnace_mlist__base|uvw_remove|biped_object|mesh_select|motion_clip|stl_export|gamenavgup|lens_effects_focus_filter|misss_mia_skin2_surface_phen|spacewave|missing_shader_plug_in|inline|gizmojointmorph|filelink_dwglayertable|physxcollision|bakeshell|perlinmarble|water_surface_shadow__lume|mi_car_paint_mtl_phen_max|max_noise|axishelperobj|mib_opacity|utility_mia_material__protein|max2_dgs_material_photon|mip_binaryproxy|bump_map__base|adsk_utility_colorpassthrough|particle_paint_cursor|directx_shader_default|pb2parameter|particleskinnerosm|adsk_utility_curvecontrol|adsk_utility_scale_zero_up|gripmanager|catmotionplatform|reactoranglemanip|blizzard|max_genericbakeelement|splineshape|shadowsmap|waveform_float|missing_position_control|push|mib_geo_instance_mlist|camera_match|controlcontainergeometry|meshselect|motion_clip_slavefloat|fbxexp|parserloader|pmalpha|sss2_shader|spacetwist|shadowmap|missing_helper|joint_angle_deformer|lzflare_mansec_base|mp_switch|matteshadow|foliagetexturemap|watersurfaceshadow|hair_instanced_geometry_mr_shader|swirl__3dsmax|lightmeter|marble__3dsmax|adsk_utility_mia|max_shaderlist|environment_probe_chrome_ball__mi|mib_bump_map|simple_mtl_metal_adsk_v1|spraycursor|adsk_shd_metallicpaint_flakes__adsk|taildata2|pflow_collision_shape|adsk_utility_colorshaderswitcher|adsk_utility_float_to_float3|smegup|catrigrootnodectrl|campoint|spiral_stair|mib_bump_map2|linearshape|lightingmap|on_off|linear_rotation|mapscalerosm|max_stdrenderelements|clean_multimaterial|global_container|surfdeform|biped_subanim|fbxexporter|parametercollectorca|pdalpha|misss_fast_shader2_x|spacestretch|raytraceshadow|bones|gizmojoint|glow_element|physxswitch|matte|shader_list__lens|max_base_videocolorcorrect|hairmrintancegeomshader|max_swirl|dwgsunpacket|max_marble|adsk_shd_wallpaint_spider|width_from_color__contour|mip_mirrorball|lookup_cube6__base|adsk_shd_metal|shapelibrary|adsk_shd_metallicpaint_flakes|lockedmodifierwrapper|physxshapewsm|adsk_metal_noise_anodized_v2|adsk_shd_metallicpaint_mia_v2_adsk|catmonograph|catbonesegtrans|substitute_object|scatter|shavemrhairgeom|normalsmap|filelink_linktable|bezier_rotation|mapscalermodifier|illumination__lume|mmclean|delegate|substitute|motion_clipfloatcontroller|iges_export|expose_float_control|lens_effects_flare_filter|pathdeformspacewarp|area_shadows|ring_array|bulge_angle_deformer|jsubtex|mp_intercollision|inknpaint|combustion|texture_filter_lookup__base|mr_physical_sky|color_intensity__base|daeimp|max_base_gbuffer|utility_combine3bump__protein|contour_shader_widthfromcolor|simple_wave_map__adsk|mib_lookup_cube6|adsk_tex_concrete_smoothbumptex|birth_paint|ngon|prosound|sketchup|max_vectormap|adsk_metal_switch_color_shader_v2|adsk_shd_metallicpaint_mia_v2|monograph|bonesegtrans|substituteobject|polymeshobject|shavemrhaircomp|blendmap|lod_controller|euler_xyz|trim_extend|illumination|measure|crowddelegate|substitutemod|motion_clip_slavepoint3|sw3d_exp|expose_point3_control|stars|animation_store|gravity|adv__ray_traced|daylight|gizmobulge|lzglow_aux_data|physxintercollision|velocity|directx_9_shader|shader_list__photon_volume|mib_texture_filter_lookup|mrskyenv|mib_color_intensity|daeimporter|max_mattematerial|adsk_utility_combine3bump|contour_only__contour|adsk_map_simple_wave|lume_metal_material__phong|utility_multimixer__protein|spraybirth|donut|waveobject|satimport|vector_map|adsk_utility_multiplydivide|adsk_light_photometric|cathierarchybranch|iktargtrans|position_manip|u_type_stair|max_topbottommaterial_contour|alphamap|float_motion_capture|local_euler_xyz|vertex_colors|uv_generator__3dsmax|assign_vertex_colors|crowd|disp_approx|footsteps|asciiexp|expose_euler_control|wipe|mixamo|wind|advanced_ray_traced|sunlight|lzhilight_aux_data|lzflare_rays_data|mp_force|dxmaterial|planet|transmat__physics|shavemrgeompasser|refract__base|objimp|displacement_3d__3dsmax|adsk_shd_ceramic|contour_only|simple_tile_map__adsk|facade__lume|adsk_utility_multimixer|utility|egg|audiofile|acis_sat|vectormap|adsk_utility_color_to_float|adsk_utility_simplefloatmixer|cathierarchybranch2|palmtrans|adsk_kelvintocolor|positionmanip|utypestair|heightmap|missing_float_control|orientation_constraint|max_base_uvgenerator|max_file_finder|bipedsystem|bevel_profile|bipslave_control|vrbl_export|hair_mr_object|iray_renderer|spacedisplace|stdshadowgen|xrefobject|lzglow_data|jworld3data|physxforce|architectural|shader_list__volume|transmat|shavemrinstancegeom|mib_refract|daeexp|max_displacement|environment_background_switcher__mi|dgs_material__3dsmax|adsk_map_simple_tile|facade|euler_filter|cleanup|rectangle|wavemaster|satexport|orbaz_mix|adsk_utility_float_to_color|adsk_mrstoreelements|catmotionlimb|tailtrans|squeeze|compass|linkcomposite|macutilities|missing_texture_bake_element|bezier_point3|tessellate|lookat_constraint|path_material__physics|material_xml_exporter|priority|poly_select|vertical_horizontal_turn|mpg|hairmrobj|mental_ray_iray_renderer|deflector|mental_ray_shadow_map|missing_system|lzhilight_data|lightmap|mp_glue|architecturalmaterial|speckle|dielectric_material_photon__3dsmax|architectural__round_corners_bump|lightmap_write__base|daeexporter|meshsmooth|splat__3dsmax|mip_rayswitch_environment|max2_dgs_material|contour_shader_maxcolor|ocean__lume|autocam|initial_state|ellipse|particle_flow_utility|openexr|perspective_match|adsk_utility_output|adsk_base_uvgenerator|cathierarchyleaf|cattransformoffset|deletesplinemodifier|ik_spline_start_twist_manip|prism|mental_ray__material_custom_attribute|bezier_color|tcb_rotation|path_material|xmlmtlexporter|speed_vary_behavior|polymesh_select|motion_clip_slavepos|sss_physical_material__mi|halfround|physx_debug_visualizer|retimer|bomb|mrshadowmap|paramblock2paramblock2|streak_element|adt_style|physxglue|raytracematerial|philbitmap|max2_dielectric_material_photon|mia_roundcorners|mib_lightmap_write|objexp|max_splat|mib_fast_occlusion|refraction_index__base|simple_wood_map__adsk|ocean|lighting_analysis_data|initialstate|polygon_counter|fopenexr|massfx_loader_linkage|adsk_utility_noise|adsk_utility_switch8color|catstepshape|catspinetrans2|crosssection|ikstartsptwistmanip|controlcontainer|hairmaxutility|mrmaterialcustattrib|point3_expression|rotation_reactor|parti_volume__physics_legacy|helix|motion_capture|speedvarybehavior|vertexpaint|motion_clip_slaverotation|misss_physical_phen|quarterround|physicalmaterialmanager|retimerctrl|mapscalerspacewarp|missing_shadow_type|material_editorreferencemaker|manual_secondary_element|adtstyle|mp_solvent|advanced_lighting_override|bricks|max_base_orennayarblinnillumination|mi_metallic_paint|output__3dsmax|simple_mtl_glazing__adsk|max_multimaterial|arch__exposure___photographic|mib_refraction_index|adsk_map_simple_wood|metal__lume|lightinganalysisdatarenderelement|group_select|flight_studio|autodesk_material|particle_flow_tools_global_utility|simple_image_map__bitmap___adsktexturemap|adsk_shd_plasticvinyl_v2|stepshape|spinetrans2|touchsensor|hose|scene_effect_loaderutilityplugin|mental_ray__indirect_illumination_custom_attribute|tcb_point3|rotationreactor|parti_volume|star|shineexp|lattice|sharedmotionflows|paintlayermod|motion_clip_slavescale|sss_fast_skin_material_displace__mi|pipe|oneclick|catspinedata2floatcontroller|vortex|mb_select|deform_curve|msec_element|lzflare_inferno_data|physxsolvent|line|radiosity_override|tiles|geo_cylinder__base|mia_exposure_simple|max_output|adsk_mtl_glazing|gradient_ramp__3dsmax|mia_exposure_photographic|logarithmic_camera_exposure__3dsmax|utility_switch8shader__protein|metal|mr_shader_element|groupselection|batch_prooptimizer|autodeskmaterial|box_2_global_utility|adsk_map_simple_bitmap_v2|adsk_toneoplog|catspinedata2|layertransform|viewport_render|linkleaf|scene_state_manager|mriicustattrib|color_rgb|rotation_script|ink__n_paint__3dsmax|arc|shape_check|fillet_chamfer|sharedmoflowlist|deletepatch|max_motionclip_implementation|misss_fast_skin_phen_d|physxpanelglobalutilityplugin|digitdatafloatcontroller|uomniflect|maxrenderer_com_server|mtllib|ray_element|pview_manager|mp_drag|collapse|discreetradiositymaterial|shader_list__bump|mib_geo_cylinder|shavemrshadowmatte|max_particledata|simple_mtl_wall_paint__adsk|max_gradientramp|architectural__self_illuminator|max_toneoplog|adsk_utility_switch8shader|geo_plane__base|mrarbrenderelement|group_operator|open_edges|map_to_material_conversion|cammatchdatacustattrib|adsk_tex_speckle|landscapetexturemap|spinedata2|catcollarbone|viewportrender|shapemerge|mental_ray__light_shader_custom_attribute|point3_xyz|rotation_wire|max_inknpaint|circle|reset_xform|morpher|statecreator|pathdeform|maxmotionclipimp|sss_fast_skin_material__mi|physxpanelgup|catlimbdata2floatcontroller|cameramapspacewarp|wideflange|viewportmanager|scene|adt_object_manager|pviewmanager|physxdrag|shellac|shader_list__shadow|passthrough_bump_map__base|mia_physicalsky|bump__3dsmax|adsk_mtl_wallpaint|max_base_blinnillumination|mia_light_surface|width_from_light__contour|mr_raytype_switcher|mib_geo_square|mr_a_d_output__beauty|groupoperator|openedgesclass|metaslproxymaterial|populate|adsk_core_glossy_sampler|max_landscape|catbonedata|collarbonetrans|pfengine|nurbs_imported_objects|mrlightshadercustattrib|springpoint3controller|wirerotation|shader_list__displacement|stpathclass|color_clipboard|patch_select|orientation_behavior|ffdbox|global_motion_clip|misss_fast_skin_phen|sunlight_daylight_slave_controllermatrix3controller|catdummymovemask|udeflector|tee|viewportmanagercontrol|mtlbaselib|jflagsetdata|pfactionlistpool|mp_world|morphermaterial|falloff|mib_passthrough_bump_map|mia_physicalsun|max_bump|simple_mtl_solid_glass__adsk|layer_thinner__contour|adsk_aspect_ratio_width_per_height|contour_shader_widthfromlight|mip_rayswitch|ray_marcher__base|mradbeauty|placement_paint|missing_uvw_coordinates|lockedmaterialwrapper|popsegcontrol|simple_checker_map__adsktexturemap|simple_tile_map__adsktexturemap|bonedata|cathipivottrans|displayparticles|blobmesh|batch_render_manager|mental_ray__area_light_custom_attribute|diffusemap|point3spring|rotation_list|particle_mblur|lines|file_link_manager|normalize_spl|orientationbehavior|ffdcyl|globalmotionclip|sss_fast_material__mi|sunlight_daylight_slave_controller|segtrans|pushspacewarp|animtrack|mental_ray__object_custom_attributes_manager|nodenamedselset|star_element|pfsystempool|physx_world|compositematerial|swirl|distortion__lume|mi_glossy_refraction__mi|contour_composite__contour|specularmap|adsk_mtl_solidglass|contour_shader_layerthinner|mr_card_opacity|dgs_material__physics|adsk_scale_internal_to_meters|mib_ray_marcher|mr_a_d_output__diffuse_direct_illumination|sprayplacement|missinguvcoordinatesclass|promaterials__glazing_v2|popskincontrol|adsk_map_simple_checker_v2|adsk_map_simple_tile_v2|catweight|cathdpivottrans|renderparticles|capsule|mrarealightcustattrib|point3_reactor|rotationlist|particleblur|section|bitmap_photometric_paths|normalize_spline|crowdstate|master_motion_clip|misss_fast_simple_phen|deformable_gpoly|catbonedatamatrix3controller|conformspacewarp|rvtcomponentpacket|mrobjectcustattrib_manager|namedselsetlist|adt_stylecomposite|particlecontainer|birthgrid|mental_ray|particle_bitmap|distortion|mib_glossy_refraction|contour_composite|simple_mtl_masonry_cmu__adsk|max_base_straussillumination|mip_card_opacity|dgs_material|utility_gamma___gain__mi|max_iesskylight|mraddiffusedirectillumresult|birth_texture|overlapping_vertices|adsk_mtl_glazing_v2|simple_speckle_map__adsktexturemap|simple_wave_map__adsktexturemap|catfootlift|catfoottrans2|event|spherify|slidingdoor|haireffect|grid|viewportmanagercustattrib|point3reactor|audiorotation|particle_age|walledrectangle|rescale_world_units|targetspot|ffd_2x2x2|sharedmotionflow|masterclip|normal_bump|fbxmaxtablerecordreferencemaker|mixamocontroller|drag|tracksetlist|mental_ray__material_custom_attributes_manager|dwggridpacket|pivot|adtstylecomp|pf_notifydep_catcher|birth_group|mrmaterial|water|physical_lens_dof__physics|mi_glossy_reflection__mi|light_infinite__base|adsk_mtl_masonrycmu|dielectric__base|max_renderelementhandler|max_base_imagecollector|mip_gamma_gain|geo_cone__base|mr_a_d_raw__diffuse_direct_illumination|birthtexture|overlappingverticesclass|promaterials__generic_v2|adsk_map_simple_speckle_v2|adsk_map_simple_wave_v2|freespot|footlift|foottrans|pfarrow|flex|l_type_stair|atsmax|missing_custom_attribute_plugin|audiopoint3|slaverotation|cellular|polymorphicgeomshape|ffd2x2x2|sharedmoflow|exposetm|gnormal|fbxrevitmaxtablerec|mixamo_ctrl|pbomb|rvtelementtpacket|mrmaterialcustattrib_manager|dwglayerfilter|jflagctldata|pfnotifydepcatcher|birthgroup|mybricksphenomenon|waves|physical_lens_dof|mib_glossy_reflection|mib_light_infinite|mr_matte_shadow_reflection_mtl|mib_dielectric|max_mrrenderelement|max_base_constantillumination|utility_elliptical_bump__protein|mib_geo_cone|mraddiffusedirectillumraw|mapping_object|overlapped_uvw_faces|adsk_mtl_simplegeneric_v2|adsk_shd_metal__blender_v2|simple_wood_map__adsktexturemap|catliftoffset|catunitsposition|select_keys_by_time|birth|layer_manager|ltypestair|light_tracer|point3_script|noise_rotation|cellulartex|linkcompositeshape|ffd_4x4x4|scripted_behavior|exposetransform|camera_map_per_pixel|hiddenunselectednodecache|mapping|deletemesh|pomniflect|rvtobjtranslator|particle_view_global_actions|dwgalwaysequalfilter|lzflare_prefs_data|lzflare_aux_data|birthstream|glass__physics_phen|reflect_refract__3dsmax|motionrenderelement|rgb_multiply__3dsmax|mi_bump_flakes|store_ligth_levels|mip_matteshadow_mtl|cellular__3dsmax|contour_shader_silhouette|max_texturedskylight|adsk_utility_elliptbump|geo_sphere__base|mr_a_d_level__diffuse|mappingobject|overlappeduvwfacesclass|promaterials__ceramic_v2|adsk_utility_bump|adsk_map_simple_wood_v2|cat_liftoffset|catmotiontailrot|create_out_of_range_keys|position_icon|nodeobject|slidingwindow|lighttrace|point3_wire|rotation_motion_capture|thin_wall_refraction|linkleafshape|ffd4x4x4|scriptedbehavior|dwgextrusionpacket|cameramaptexture|turn_to_gpoly|noisemodifier|motor|trackset|vertex_paint_startup_gup|planarcollision|lzflare_streak_data|lzflare_autosec_base|mp_buoyancy|dielectric_material_phen|max_reflectrefract|material_id|max_rgbmultiplier|mrarchmaterial_shader|contour_store_light|simple_mtl_ceramic__adsk|max_cellular|adsk_aspect_ratio_height_per_width|light_point__base|adsk_shd_fabric_spider|mib_geo_sphere|mraddiffuselevel|express_save|fltgup|adsk_mtl_ceramic_v2|adsk_utility_gamma|adsk_shd_solidglass_v2|catkneeangle|catmotionrot|randomize_keys|particle_view|paramblockparamblock|superspray)\b/i, null],
         ['kwd6', /^(?:importerplugin|mpasscameffect|iksolver|paramblock2|atmospheric|paramblock|bitmapio|toneoperator|radiosityeffect|bakeelement|rendereffect|renderelement|rendererclass|custattrib|referencemaker|referencetarget|shadow|camera|globalutilityplugin|utilityplugin|attributedef|light|system|texoutputclass|xyzgenclass|shape|uvgenclass|material|shader|base_layer|masterpointcontroller|masterblockcontroller|colorpicker|morphcontroller|trackviewutility|modifier|matrix3controller|scalecontroller|rotationcontroller|quatcontroller|positioncontroller|point4controller|texturemap|point3controller|floatcontroller|spacewarpmodifier|node|spacewarpobject|geometryclass|maxwrappernonreftarg|maxwrapper|filter|videopostfilter|soundclass|schematicviewutility|exporterplugin|helper)\b/i, null],
         ['kwd7', /^(?:networklicensestatusmanager|workspacemanager|maxops|physxpanelinterface|mtlbrowserfilter_manager|filelinkmgr|cuimouseconfigmanagerimplement|perezallweather|imerge|instancemgr|mouseconfigmanager|rendermessagemanager|mental_ray_preferences|brushpresetmgr|iceflowshapecontrol|autotangentman|viewcubeops|autodeskmaterialmanager|custattribcollapsemanager|sceneradiosity|sceneexposurecontrol|xmlmaterial|projectionrendermgr|nvpx|stylemgr|mental_ray_public_interface|bipfilter|fileresolutionmanager|isolateselection|trackselectionsets|hair|quadmenusettings|flippeduvwfaces|tmgizmos|particleflow|maxnetworkerinterface|radiositypreferences|visualms|idisplaygamma|openedges|objxrefs|ishadermanagercreator|hdiksys|reactionmgr|retimerman|batchprooptimizer|daylightsimulationuiops|uiaccessor|nvpxconsts|nullinterface|flowraytraceinterface|trackviews|steeringwheelsops|draganddrop|iinteractionmode|assetmanager|statuspanel|lightingunits|revitdbmanager|bipworkbench|colorman|pseudocolormanager|mainthreadexecuterequestmanager|mszip|mental_ray_string_options|multipleedges|globaldxdisplaymanager|displaymanager|overlappingvertices|cmdpanel|rollup|channelinfo|containerpreferences|crashonexitmanager|atscustomdepsops|oneclickrevit|blockmgr|actionman|flightstudioexport|qat|pluginmanager|dwfexportpreferences|atsops|containers|lightmetermanager|iparserloader|daylightsimulationutilities|facesorientation|assignvertexcolors|dxshadermanager|networkmanager|missinguvcoordinates|bonesys|utilitypanel|ringarray|medit|dialogmonitorops|materialexplorermanager|ogsdiagnostics|valueconverter|nodeclonemgrtest|netrender|renderpresets|ilightref|namedselectionsetmanager|viewpanelmanager|menuman|heightmanager|layermanager|simplefacemanager|iksys|overlappingfaces|lockedtracksman|refhierarchy|frametagmanager|interfaceidregistry|workingpivot|mxsunitresults|paramwire|sceneexplorermanager|particleflowutility|tverts|daylightsystemfactory|skinutils|s3dexporter|ghostingmanager|defaultactions|bipanalyzer|substmanager|scenestatemgr|radiositymeshops|schematicviews|manip|pftparticleview|mxsdebugger|daylightsystemfactory2|exchangestorepackagemanager|iceflowfilebirthsetup|maxribbon|helpsystem|irtshadetreecompiler|iceflowsystemfactory|actionitemoverridemanager|assemblymgr|editrenderregion|netcreatehelpers|animlayermanager|srr_exports|flightstudioimport|paramcollectorops|viewportssb|loadsaveanimation|projectionintersectormgr|batchrendermgr|scenemissingplugins|bitmapproxymgr|ibitmappager|mentalmillcompiler|viewportbuttonmgr|memstreammgr|sme|paintsoftselpresetcontext|autosave|overlappeduvwfaces|meshinspector|epolymanipgrip|renderenhancements|flightstudio|isolatedvertices|browsermgr|sceneeffectloader|lockedcomponentsman|walkthroughops|bitmaplayermanager|luminosityutil|objxrefmgr|imetadatamanager|itabdialogmanager|iviewportshadingmgr|gridprefs|grip|xviewchecker|pop|nitrousgraphicsmanager|bipfixer|lightinganalysisoverlayfactory|timeslider)\b/i, null],
         ['kwd8', /^(?:objects|geometry|lights|cameras|helpers|shapes|systems|spacewarps|selection)\b/i, null],
         ['kwd9', /^(?:units|vfields|timeconfiguration|xrefs|thehold|tcbdefaultparams|gw|listview|cacheops|cui|mocap|patch|pointcacheman|vld|bezierdefaultparams|dotnet|surfacearrivebhvr|systemtools|listctrl|globalmotionclipops|flexops|globalvars|polyop|keyboard|terrainops|assertreporter|attachctrl|camerafov|meshop|biped|assetmetadata_structdef|registry|scanlinerender|persistents|sysinfo|skinops|modpanel|linkctrl|snapmode|delegates|assetbrowser|tabbeddialogs|schematicview|displaycolor|autobackup|refs|renderers|mtlbrowser|trackview|crowds|windows|fileproperties|macros|mateditor|nodeexposureinterface|patchops|enveffectsdialog|ilayermanager|polyops|trackbar|dof|symbolicpaths|internet|viewport|toolmode|renderscenedialog|boolobj|mouse|setkey|le|pluginpaths|ik|wavsound|hidebycategory|sessionpaths|meshops|preferences|splineops|logsystem|xrefpaths|options|callbacks|mappaths|bit|pathconfig|custattributes|themixer)\b/i, null],
         ['kwd10', /^(?:civil_view_path___surface_constraintmatrix3controller|directx_9_shaderreferencetarget|civil_view_guard_rail|dynxfccv3|dyngrail|dynxfccm3|civil_view_spline_to_mesh|civil_view_traffic_data_constraint|dynsmesh|metal_bump9|dsimdscc|red|civil_view_divide_spline|metal_bump|dyndiv|pi|civil_view_road_marking|dynmarks|e|true|civil_view_swept_object|false|blue|dynsos|undefined|dontcollect|unsupplied|ok|emptyval|selectionsets|meditmaterials|hkey_classes_root|x_axis|y_axis|hkey_current_config|z_axis|hkey_current_user|emulator|hkey_local_machine|dds|mesh|msemulator|white|hkey_users|black|hkey_performance_data|gray|orange|yellow|brown|module_snooper|test_sound_object|civil_view_sight_checker__calc|slap|nurbs_api_test|c___object_output|utility_tester|assetuser|app_data_tester|green|civil_view_path___surface_constraint|dynxfcc)\b/i, null],
         ['kwd11', /^(?:lighttintcolor|rendatmosphere|lightlevel|renddithertrue|timedisplaymode|backgroundcolorcontroller|renddither256|ambientcolorcontroller|rendmultithread|enableaccelerators|lighttintcolorcontroller|rendnthserial|lightlevelcontroller|rendvidcorrectmethod|rootnode|rendfieldorder|rendsimplifyarealights|useenvironmentmap|rendntsc_pal|numatmospherics|rendlockimageaspectratio|numeffects|renderer|rendimageaspectratio|trackviewnodes|rendlockpixelaspectratio|globaltracks|rendpixelaspectratio|videoposttracks|rootscene|displaygamma|rendfilenumberbase|fileoutgamma|rendpickupframes|environmentmap|fileingamma|subobjectlevel|numsubobjectlevels|activemeditslot|lyricdirectory|heapsize|heapfree|inputtextcolor|outputtextcolor|messagetextcolor|rendoutputfilename|stacklimit|renduseactiveview|rendviewindex|rendviewid|rendcamnode|renduseimgseq|rendereffects|productappid|rendimgseqtype|prerendscript|useprerendscript|macrorecorder|localprerendscript|superclasses|postrendscript|animationrange|usepostrendscript|slidertime|manipulatemode|renderpresetmrulist|currenttime|realtimeplayback|ticksperframe|playactiveonly|framerate|playbackloop|renderwidth|animbuttonenabled|renderheight|animbuttonstate|renderpixelaspect|flyofftime|backgroundimagefilename|renderdisplacements|displaysafeframes|skiprenderedframes|currentmateriallibrary|showendresult|scenematerials|rendtimetype|hardwarelockid|rendstart|activegrid|rendend|maxfilename|rendnthframe|maxfilepath|rendhidden|escapeenable|scriptspath|rendforce2side|editorfont|rendsavefile|listener|editorfontsize|rendshowvfb|editorshowpath|rendusedevice|editortabwidth|rendusenet|localtime|rendfieldrender|hotspotangleseparation|rendcolorcheck|backgroundcolor|rendsuperblack|ambientcolor|rendsuperblackthresh)\b/i, null],
         // A number is a hex integer literal, a decimal real literal, or in
         // scientific notation.
         [PR.PR_LITERAL,
          /^[+-]?(?:0x[\da-f]+|(?:(?:\.\d+|\d+(?:\.\d*)?)(?:e[+\-]?\d+)?f?))/i],
         // An identifier
         [PR.PR_PLAIN, /^[a-z_]\w*/i],
         // A run of punctuation
         [PR.PR_PUNCTUATION, /^[^\w\t\n\r \xA0][^\w\t\n\r \xA0\"\'\-\+=\$]*/]
        ]),
    ['maxscript']);
