var searchResultProvider = new SearchResultsProvider("", "Autodesk FBX SDK Documentation");
searchResultProvider.setTopicInfoList([{"title":"FBX SDK Programmer\'s Guide",
"href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm",
"description":"",
"ancestors":[]},
{"title":"FBX SDK Programmer\'s Guide",
"href":"./files/fbx_sdk_landing.htm",
"description":"© Copyright 2013 Autodesk Inc. All rights reserved.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"Legal Notices",
"href":"./files/legal-notice.htm",
"description":"Python is a registered trademark of Python Software Foundation. All other brand names, product names or trademarks belong to their respective holders.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX SDK Programmer\'s Guide","href":"./files/fbx_sdk_landing.htm"}]},
{"title":"Welcome to the FBX SDK",
"href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm",
"description":"Autodesk® FBX® SDK is a C++ software development kit (SDK) that lets you create plug-ins, converters, and other applications that use Autodesk FBX technology. FBX technology allows you to translate and exchange 3D assets and media from a variety of sources quickly and easily.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"What is Autodesk FBX Technology?",
"href":"./files/GUID-274163DA-9E89-4DCC-8AF6-10B0C498582E.htm",
"description":"The FBX SDK is part of Autodesk FBX technology, a family of tools which allow 3D content developers to import and export 3D data. Autodesk FBX contributes to the flexibility of organizations involved in the media and entertainment industry by allowing them to mix and match a variety of 2D and 3D digital content creation applications.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"}]},
{"title":"Sample FBX Applications",
"href":"./files/GUID-E16AA044-30EC-4625-A7C0-2FC2F36F4B1F.htm",
"description":"FBX Plug-ins for Autodesk 3ds Max and Autodesk Maya Autodesk 3ds Max allows users to import all or part of a scene stored in an FBX file into a 3ds Max scene, and to export all or part of a 3ds Max",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"},{"title": "What is Autodesk FBX Technology?","href":"./files/GUID-274163DA-9E89-4DCC-8AF6-10B0C498582E.htm"}]},
{"title":"Where FBX Fits in the Creation Pipeline",
"href":"./files/GUID-F8D00075-A916-4AE2-AD7E-ED9DA2E5CF2C.htm",
"description":"What Content Developers Can Do With FBX Technology Content developers are the people who work on 3D modeling and animation for films, television and games. Here are some of the ways that content dev",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"},{"title": "What is Autodesk FBX Technology?","href":"./files/GUID-274163DA-9E89-4DCC-8AF6-10B0C498582E.htm"}]},
{"title":"What\'s new/What\'s changed",
"href":"./files/GUID-9B5DFB40-E9B1-477E-B1DA-9259DAC40866.htm",
"description":"Details about all changes since the previous version of the FBX SDK are in the readme.txt file located in the FBX SDK installation root directory.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"}]},
{"title":"FBX SDK 2014",
"href":"./files/GUID-8539417A-1589-4152-88FD-677D798AD425.htm",
"description":"2014.1 New features and improvements Introduced the FBXSDK_ENV_WINRT preprocessor define (previously known as FBXSDK_ENV_WINMETRO). This disables unsupported functions when targeting Microsoft Wind",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"},{"title": "What\'s new/What\'s changed","href":"./files/GUID-9B5DFB40-E9B1-477E-B1DA-9259DAC40866.htm"}]},
{"title":"FBX SDK 2013",
"href":"./files/GUID-A753EE31-7DCF-409E-9270-CD2578FFB633.htm",
"description":"The following topic presents the changes made in the 2013 release of the FBX SDK. Consult the readme.txt for additional information, including fixed and known issues.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"},{"title": "What\'s new/What\'s changed","href":"./files/GUID-9B5DFB40-E9B1-477E-B1DA-9259DAC40866.htm"}]},
{"title":"FBX SDK 2012",
"href":"./files/GUID-19B34654-ADBB-43D6-915A-8EF3B3579A1A.htm",
"description":"Windows Platform Packaging The packaging of the FBX SDK for the Microsoft Windows platform has changed to reduce the size of the download. The preprocessor identifier that must be defined when linki",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"},{"title": "What\'s new/What\'s changed","href":"./files/GUID-9B5DFB40-E9B1-477E-B1DA-9259DAC40866.htm"}]},
{"title":"2012.2",
"href":"./files/GUID-8EA6A733-8B78-4698-85A7-F19F426E9DD1.htm",
"description":"New Features Added Area Light support to KFbxLight. Added Barn Doors support to KFbxLight. Deprecated Features HotSpot property of KFbxLight has been changed to InnerAngle. ConeAngle property of",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"},{"title": "What\'s new/What\'s changed","href":"./files/GUID-9B5DFB40-E9B1-477E-B1DA-9259DAC40866.htm"},{"title": "FBX SDK 2012","href":"./files/GUID-19B34654-ADBB-43D6-915A-8EF3B3579A1A.htm"}]},
{"title":"2012.1",
"href":"./files/GUID-08159356-B8CA-42D2-82F3-954409C41A8F.htm",
"description":"Changelog Added support for Image Sequences into KFbxVideo. Improved the reference documentation quite substantially. Refined how visibility inheritance works: added a new property for each node al",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"},{"title": "What\'s new/What\'s changed","href":"./files/GUID-9B5DFB40-E9B1-477E-B1DA-9259DAC40866.htm"},{"title": "FBX SDK 2012","href":"./files/GUID-19B34654-ADBB-43D6-915A-8EF3B3579A1A.htm"}]},
{"title":"FBX SDK 2011",
"href":"./files/GUID-58688B00-09E8-40A3-A601-5709AEBDD559.htm",
"description":"New Animation System The FBX animation system has been completely redesigned. Take nodes, take node containers, current takes, and FCurves have all been replaced by animation stacks (KFbxAnimStack),",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"},{"title": "What\'s new/What\'s changed","href":"./files/GUID-9B5DFB40-E9B1-477E-B1DA-9259DAC40866.htm"}]},
{"title":"Using the Help",
"href":"./files/GUID-6389AA40-FF46-4F07-96E7-036E4C15F3F8.htm",
"description":"Supported Browsers The following browsers support the HTML help. Internet Explorer version 7 or later. Apple Safari version 4 or later. Mozilla Firefox version 3.6 or later. Other browsers are not",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"}]},
{"title":"Platform Requirements",
"href":"./files/GUID-B67EE33C-B913-4CAB-A39B-F929BA592B67.htm",
"description":"The FBX SDK runs on the 32-bit and 64-bit versions of the following platforms:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"}]},
{"title":"Supported File Formats",
"href":"./files/GUID-0B122E01-7DB8-48E3-AADA-5E85A197FEE1.htm",
"description":"The FBX SDK can:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"}]},
{"title":"Supported Scene Elements",
"href":"./files/GUID-2F7D6FDB-82D6-41EC-977C-01FFCA5EC382.htm",
"description":"The FBX SDK lets you access, create, or modify the following elements of a scene (FbxScene):",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"}]},
{"title":"Information and Technical Support",
"href":"./files/GUID-CC2D0441-C24A-457A-8C00-878760682B2D.htm",
"description":"An array of sources of information are available for FBX SDK users including the Autodesk FBX website, the FBX SDK Programmer\'s Guide, the C++ Reference, the Autodesk Developer Network, The AREA discussion forums, and the FBX SDK development team itself.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Welcome to the FBX SDK","href":"./files/GUID-105ED19A-9A5A-425E-BFD7-C1BBADA67AAB.htm"}]},
{"title":"Getting Started",
"href":"./files/GUID-9090538F-E7E3-4AC7-A8EE-2978F88415EB.htm",
"description":"",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"Installing and Configuring",
"href":"./files/GUID-063B70C4-CADC-42B5-9DCC-55274A8B0837.htm",
"description":"If you are planning to use Python FBX rather than the C++ interface to FBX SDK, see Scripting with Python FBX.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Getting Started","href":"./files/GUID-9090538F-E7E3-4AC7-A8EE-2978F88415EB.htm"}]},
{"title":"Recommended Development Environments",
"href":"./files/GUID-98FC4C3A-583A-453E-A8D1-5CD85B08B23E.htm",
"description":"The following table lists the platforms and compilers recommended for developing plug-ins, converters, and other applications with FBX SDK:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Getting Started","href":"./files/GUID-9090538F-E7E3-4AC7-A8EE-2978F88415EB.htm"},{"title": "Installing and Configuring","href":"./files/GUID-063B70C4-CADC-42B5-9DCC-55274A8B0837.htm"}]},
{"title":"Directory Structure",
"href":"./files/GUID-38052D36-6A33-4C1E-927E-CB16126292B8.htm",
"description":"Directory structure The directory structure of the FBX SDK is identical on all the supported platforms: Windows, Mac OS, and Linux. Directory Path Description <yourFBXSDKpath>\\ The root of the FBX",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Getting Started","href":"./files/GUID-9090538F-E7E3-4AC7-A8EE-2978F88415EB.htm"},{"title": "Installing and Configuring","href":"./files/GUID-063B70C4-CADC-42B5-9DCC-55274A8B0837.htm"}]},
{"title":"Configuring the FBX SDK for Windows",
"href":"./files/GUID-6E7B1A2E-584C-49C6-999E-CD8367841B7C.htm",
"description":"Downloading and installing the FBX SDK To download and install the FBX SDK on WIndows:Go to http://www.autodesk.com/fbx. Navigate to the Downloads page, and follow any instructions. Find the version",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Getting Started","href":"./files/GUID-9090538F-E7E3-4AC7-A8EE-2978F88415EB.htm"},{"title": "Installing and Configuring","href":"./files/GUID-063B70C4-CADC-42B5-9DCC-55274A8B0837.htm"}]},
{"title":"Configuring the FBX SDK for Mac OS",
"href":"./files/GUID-724E9FAD-AFA0-4348-BDAA-6CF2FDF2FF55.htm",
"description":"Downloading and installing the FBX SDK To download and install the FBX SDK for Mac OS:Go to http://www.autodesk.com/fbx. Navigate to the Downloads page, and follow any instructions. Find the distribu",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Getting Started","href":"./files/GUID-9090538F-E7E3-4AC7-A8EE-2978F88415EB.htm"},{"title": "Installing and Configuring","href":"./files/GUID-063B70C4-CADC-42B5-9DCC-55274A8B0837.htm"}]},
{"title":"Configuring the FBX SDK for Linux",
"href":"./files/GUID-408B9928-104E-463E-994D-ACD4CB8341A9.htm",
"description":"Downloading and installing FBX SDK To download and install FBX SDK for Linux:Go to http://www.autodesk.com/fbx. Navigate to the Downloads page, and follow any instructions. Find the distribution file",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Getting Started","href":"./files/GUID-9090538F-E7E3-4AC7-A8EE-2978F88415EB.htm"},{"title": "Installing and Configuring","href":"./files/GUID-063B70C4-CADC-42B5-9DCC-55274A8B0837.htm"}]},
{"title":"Your First FBX SDK Program",
"href":"./files/GUID-29C09995-47A9-4B49-9535-2F6BDC5C4107.htm",
"description":"This program uses the statically linked version of the FBX SDK. For additional information on how to install and configure the FBX SDK for your environment, see Installing and Configuring.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Getting Started","href":"./files/GUID-9090538F-E7E3-4AC7-A8EE-2978F88415EB.htm"}]},
{"title":"Sample Programs",
"href":"./files/GUID-7C3F336C-EC50-4C1A-87BD-8CF04A851EC0.htm",
"description":"",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"Building and Running the Sample Programs",
"href":"./files/GUID-AB36BF12-CFA7-4789-8CFA-0F1F026472A2.htm",
"description":"Windows To build and run ImportExport using Visual Studio:Start Visual Studio. Click mFileOpenProject/Solution. Navigate to the folder that contains the version of ImportExport for your version of V",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Sample Programs","href":"./files/GUID-7C3F336C-EC50-4C1A-87BD-8CF04A851EC0.htm"}]},
{"title":"Feature-Oriented Programs",
"href":"./files/GUID-618465BC-5060-406C-9E83-097430B2C3A2.htm",
"description":"The FBX SDK ships with the following sample programs that run on all platforms supported by FBX SDK.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Sample Programs","href":"./files/GUID-7C3F336C-EC50-4C1A-87BD-8CF04A851EC0.htm"}]},
{"title":"Tutorial Programs",
"href":"./files/GUID-1DC632BF-7DB3-4961-9731-5C6DA7B5BA52.htm",
"description":"These tutorial programs are aimed at programmers who are learning the FBX SDK. These tutorials run on Windows only. Each tutorial program:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Sample Programs","href":"./files/GUID-7C3F336C-EC50-4C1A-87BD-8CF04A851EC0.htm"}]},
{"title":"Tutorial: ImportExport",
"href":"./files/GUID-49A795C5-28F1-457A-8C56-73CAD77B9ED9.htm",
"description":"The ImportExport tutorial program shows how to convert a file from one file format (FBX binary, FBX ASCII, DAE, etc.) to another. For more information, see Importing and Exporting a Scene.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Sample Programs","href":"./files/GUID-7C3F336C-EC50-4C1A-87BD-8CF04A851EC0.htm"},{"title": "Tutorial Programs","href":"./files/GUID-1DC632BF-7DB3-4961-9731-5C6DA7B5BA52.htm"}]},
{"title":"Tutorial: SceneTreeView",
"href":"./files/GUID-3DE46B9A-A7EE-403E-866B-427B800F9F9D.htm",
"description":"Shows how to traverse all the nodes in an FBX scene, and how to determine the content of each node, i.e., whether a node contains a camera, a light, a mesh, etc. For more information, see Nodes and the Scene Graph.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Sample Programs","href":"./files/GUID-7C3F336C-EC50-4C1A-87BD-8CF04A851EC0.htm"},{"title": "Tutorial Programs","href":"./files/GUID-1DC632BF-7DB3-4961-9731-5C6DA7B5BA52.htm"}]},
{"title":"Tutorial: CubeCreator",
"href":"./files/GUID-6CEF4934-120D-4162-87B0-8B30D8032FDB.htm",
"description":"This tutorial program shows how to add textures, materials, and animation to meshes representing a model (in this case, a cube). Operations include:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Sample Programs","href":"./files/GUID-7C3F336C-EC50-4C1A-87BD-8CF04A851EC0.htm"},{"title": "Tutorial Programs","href":"./files/GUID-1DC632BF-7DB3-4961-9731-5C6DA7B5BA52.htm"}]},
{"title":"Importing and Exporting a Scene",
"href":"./files/GUID-B0455682-8B84-41FC-BCAA-D746F032261F.htm",
"description":"Importing and Exporting a Scene Importing and exporting data is performed by the FbxImporter and FbxExporter classes respectively. The FbxIOSettings class is used to specify the scene data which is i",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"I/O Settings",
"href":"./files/GUID-50489A8A-457C-4B54-80E1-5572A16F7F17.htm",
"description":"Creating an I/O Settings Object The FbxIOSettings class is responsible for specifying which elements of a scene are imported from a file, or exported to a file. Such elements include cameras, lights",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Importing and Exporting a Scene","href":"./files/GUID-B0455682-8B84-41FC-BCAA-D746F032261F.htm"}]},
{"title":"Importing a Scene",
"href":"./files/GUID-ABFC58F1-C10D-42AE-A204-D79EB1D84B24.htm",
"description":"A scene can be imported by the FBX SDK from various file formats. The FBX file format can either be in binary (also known as the native format), or in ASCII. Note that only the binary FBX file format supports embedded media (see I/O Settings). The Collada file format and other non-FBX file formats can also be used to import scenes. For more information, see Supported File Formats.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Importing and Exporting a Scene","href":"./files/GUID-B0455682-8B84-41FC-BCAA-D746F032261F.htm"}]},
{"title":"Exporting a Scene",
"href":"./files/GUID-4E8F95CA-CD9B-4E24-B8AD-7C399EA78137.htm",
"description":"The FBX SDK can export a scene into various file formats (see Supported File Formats), including both binary and ASCII FBX file formats. Note that only the binary FBX file format supports embedded media (see I/O Settings).",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Importing and Exporting a Scene","href":"./files/GUID-B0455682-8B84-41FC-BCAA-D746F032261F.htm"}]},
{"title":"Referencing Media",
"href":"./files/GUID-6766AFC0-4F25-4436-A5EE-BCDAFC6CB583.htm",
"description":"Referencing Embedded Media When a binary FBX file containing embedded media is imported, the media will be extracted from the file and copied into a subdirectory. This subdirectory will be created a",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Importing and Exporting a Scene","href":"./files/GUID-B0455682-8B84-41FC-BCAA-D746F032261F.htm"}]},
{"title":"Customizing File Formats with FBX SDK I/O Plug-ins",
"href":"./files/GUID-75CD0DC4-05C8-4497-AC6E-EA11406EAE26.htm",
"description":"Loading an FBX SDK I/O Plug-in The FBX SDK uses a plug-in architecture to implement its file reading and writing capabilities. FBX SDK I/O Plug-ins consist of dynamically loaded library (DLL) files w",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Importing and Exporting a Scene","href":"./files/GUID-B0455682-8B84-41FC-BCAA-D746F032261F.htm"}]},
{"title":"FBX SDK Object Model",
"href":"./files/GUID-E802CA6C-4608-41ED-A35A-017CE6E9E8DD.htm",
"description":"Memory Management Memory management within the FBX SDK is performed by the FBX SDK Manager object (FbxManager). The FbxManager singleton is responsible for creating, manipulating, and destroying obje",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"Managing Memory with the FBX SDK Manager",
"href":"./files/GUID-B3BF2A41-2262-4706-ABB3-D3C861B3F03B.htm",
"description":"Creating an FBX SDK Manager The FbxManager class is responsible for creating, managing, and destroying FBX SDK objects. Only one FbxManager instance is required for a given program. The creation of t",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX SDK Object Model","href":"./files/GUID-E802CA6C-4608-41ED-A35A-017CE6E9E8DD.htm"}]},
{"title":"FBX Objects",
"href":"./files/GUID-5D8BFE45-723E-4BD9-846B-E2B2540157C9.htm",
"description":"FBX Object Creation and Destruction An FBX object is an instance of FbxObject, or any other class derived from FbxObject. An instance of an object is created by invoking its class\' Create() function,",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX SDK Object Model","href":"./files/GUID-E802CA6C-4608-41ED-A35A-017CE6E9E8DD.htm"}]},
{"title":"FBX Properties",
"href":"./files/GUID-283ED424-E506-4A29-848F-9EAC8F1C4AF9.htm",
"description":"Managing Properties The FbxProperty template class is used to ensure that the data of a FbxObject is strongly typed. For example, the local translation vector of a FbxNode is described using a FbxTyp",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX SDK Object Model","href":"./files/GUID-E802CA6C-4608-41ED-A35A-017CE6E9E8DD.htm"}]},
{"title":"Connections",
"href":"./files/GUID-BB63A93A-7663-4256-B060-8EA35CB0FF3A.htm",
"description":"Visualizing Connections A connection is an FBX SDK data structure which manages the two-way relationship between FBX objects and/or FBX properties. To guarantee the consistency of connections within",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX SDK Object Model","href":"./files/GUID-E802CA6C-4608-41ED-A35A-017CE6E9E8DD.htm"}]},
{"title":"Error Handling",
"href":"./files/GUID-5509751F-8679-4D32-987D-8343FD8F6D1A.htm",
"description":"Errors Many member functions of FBX classes may trigger an error. In such a case: The function returns false. objectname->GetLastErrorString() returns a string with an error message. objectname-",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX SDK Object Model","href":"./files/GUID-E802CA6C-4608-41ED-A35A-017CE6E9E8DD.htm"}]},
{"title":"Supported String Formats",
"href":"./files/GUID-D3844B1D-4E74-4C64-AD79-14B00EB1FE4C.htm",
"description":"FBX SDK uses UTF-8 strings internally. UTF-8 (8-bit UCS/Unicode Transformation Format) is a variable-length character encoding for Unicode. It is able to represent any character in the Unicode standard, yet is backwards compatible with ASCII. For a good introduction to UTF-8, see Wikipedia (wikipedia.com).",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX SDK Object Model","href":"./files/GUID-E802CA6C-4608-41ED-A35A-017CE6E9E8DD.htm"}]},
{"title":"Customizing the FBX SDK",
"href":"./files/GUID-5FAF6FE0-5904-45C3-915A-DB0C9586D45B.htm",
"description":"",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX SDK Object Model","href":"./files/GUID-E802CA6C-4608-41ED-A35A-017CE6E9E8DD.htm"}]},
{"title":"Nodes and the Scene Graph",
"href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm",
"description":"Nodes The position of a scene element such as a mesh, a light, a camera, a skeleton, or a line can be described by a sequence of translations, rotations, and scaling operations. This geometric transf",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"FBX Scenes",
"href":"./files/GUID-4F644045-380D-4B75-A2A3-D39DDE53BEDD.htm",
"description":"Scene Graph Organization Summary The FBX SDK scene graph is abstracted by the FbxScene class. The scene is organized as a hierarchy of nodes (FbxNode). The root node of the scene is accessed via FbxS",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"}]},
{"title":"Merging Two Scenes",
"href":"./files/GUID-C08BAE05-B074-441C-9DBE-CE1811C0E6E2.htm",
"description":"The steps taken for merging two scenes are as follows:Load a scene. Modify a node within the loaded scene. Move the contents of the loaded scene into a reference scene. Load a different scene. Update",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"},{"title": "FBX Scenes","href":"./files/GUID-4F644045-380D-4B75-A2A3-D39DDE53BEDD.htm"}]},
{"title":"Scene Axis and Unit Conversion",
"href":"./files/GUID-CC93340E-C4A1-49EE-B048-E898F856CFBF.htm",
"description":"Scene Axis and Unit Conversion Objects in the FBX SDK are always created in the right handed, Y-Up axis system. The scene\'s axis system may need to be converted to suit your application\'s needs. Cons",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"},{"title": "FBX Scenes","href":"./files/GUID-4F644045-380D-4B75-A2A3-D39DDE53BEDD.htm"}]},
{"title":"FBX Nodes",
"href":"./files/GUID-02CF7021-71FF-4F31-A072-291EF86CCA5A.htm",
"description":"What is a Node? Nodes are primarily used to specify the position, rotation and scale of scene elements within a scene. Nodes are abstracted by the FbxNode class. A FbxScene contains a parent-child hi",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"}]},
{"title":"Transformation Data",
"href":"./files/GUID-C35D98CB-5148-4B46-82D1-51077D8970EE.htm",
"description":"Translation, Rotation and Scaling Vectors The default translation, rotation, and scaling (default TRS properties) of a node are accessed using the FbxNode::LclTranslation, FbxNode::LclRotation, and F",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"},{"title": "FBX Nodes","href":"./files/GUID-02CF7021-71FF-4F31-A072-291EF86CCA5A.htm"}]},
{"title":"Computing Transformation Matrices",
"href":"./files/GUID-10CDD63C-79C1-4F2D-BB28-AD2BE65A02ED.htm",
"description":"The FBX SDK and Maya use the same formula to compute a transformation matrix. However, 3ds Max uses a different formula.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"},{"title": "FBX Nodes","href":"./files/GUID-02CF7021-71FF-4F31-A072-291EF86CCA5A.htm"}]},
{"title":"FBX Node Attributes",
"href":"./files/GUID-FCD71AFF-F753-4D58-B96E-453ED84BF5C4.htm",
"description":"Creating a Node Attribute A FbxNodeAttribute is paired with a FbxNode to define a scene element with a specific position, rotation and scale. Calling FbxNode::GetNodeAttribute() will return NULL if n",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"}]},
{"title":"Lights",
"href":"./files/GUID-2F4395F9-5BB3-413C-BCC4-C519DAF6A484.htm",
"description":"Creating a Light Lights in the FBX SDK are abstracted by the FbxLight class. A FbxLight is created like any other object in a scene. By default, a FbxLight points along a node\'s negative Y axis. //",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"},{"title": "FBX Node Attributes","href":"./files/GUID-FCD71AFF-F753-4D58-B96E-453ED84BF5C4.htm"}]},
{"title":"Cameras",
"href":"./files/GUID-5A05DFB2-4985-4FE5-B0EF-C2855F925AAF.htm",
"description":"Creating a Camera Cameras in the FBX SDK are abstracted by the FbxCamera class. Stereocameras for 3D imaging are abstracted by the FbxCameraStereo class. In this topic, we will only look at the basic",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"},{"title": "FBX Node Attributes","href":"./files/GUID-FCD71AFF-F753-4D58-B96E-453ED84BF5C4.htm"}]},
{"title":"Geometry",
"href":"./files/GUID-4665F563-661B-4FC7-B867-2D1AE8032A1F.htm",
"description":"Geometry FbxGeometry is the base class for geometric objects which support control point deformations. Instances of FbxGeometry can be bound to FbxNode objects as node attributes to via FbxNode::SetN",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Nodes and the Scene Graph","href":"./files/GUID-F194000D-5AD4-49C1-86CC-5DAC2CE64E97.htm"},{"title": "FBX Node Attributes","href":"./files/GUID-FCD71AFF-F753-4D58-B96E-453ED84BF5C4.htm"}]},
{"title":"Meshes, Materials and Textures",
"href":"./files/GUID-8A69CD20-B8FB-4B23-925A-372E408390AA.htm",
"description":"Meshes Meshes are abstracted by the FbxMesh class. A FbxMesh defines a list of control points, also known in common literature as vertices. A single instance of FbxMesh can be bound to multiple insta",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"Meshes",
"href":"./files/GUID-5EDC0280-E000-4B0B-88DF-5D215A589D5E.htm",
"description":"Creating a Mesh Meshes in the FBX SDK are abstracted by the FbxMesh class. A mesh is defined by a set of per-face vertices, or \"control points\", and by a group of layers to define the mesh\'s normals,",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Meshes, Materials and Textures","href":"./files/GUID-8A69CD20-B8FB-4B23-925A-372E408390AA.htm"}]},
{"title":"Instancing - Sharing a Mesh",
"href":"./files/GUID-0D483705-23D9-476D-A567-09609396B190.htm",
"description":"To reduce memory requirements, a single instance of FbxMesh can be bound to multiple instances of FbxNode. Imagine that you need a program where all cubes looked alike, but you needed many thousands of them. You could save memory by creating one FbxMesh object when the program starts up. Then, every time you needed a new cube, you create a new FbxNode object, then point that node to the one mesh. This is called instancing.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Meshes, Materials and Textures","href":"./files/GUID-8A69CD20-B8FB-4B23-925A-372E408390AA.htm"},{"title": "Meshes","href":"./files/GUID-5EDC0280-E000-4B0B-88DF-5D215A589D5E.htm"}]},
{"title":"Materials",
"href":"./files/GUID-3E0DCCD0-5F9A-44D0-8D5E-423237D49DB6.htm",
"description":"The sample code in this topic is also presented in the ExportScene03/main.cxx sample program. Creating a Material The FbxSurfaceMaterial class is the base class for Lambertian (FbxSurfaceLambert) an",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Meshes, Materials and Textures","href":"./files/GUID-8A69CD20-B8FB-4B23-925A-372E408390AA.htm"}]},
{"title":"Using hardware shaders to create materials",
"href":"./files/GUID-78414234-8644-4725-9FAF-51F2175D3D2D.htm",
"description":"CGFX and DirectX hardware shaders are supported by FBX SDK starting with version 2010. You can set up a material with a CGFX or DirectX implementation using class FbxImplementation and class FbxBindingTable.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Meshes, Materials and Textures","href":"./files/GUID-8A69CD20-B8FB-4B23-925A-372E408390AA.htm"},{"title": "Materials","href":"./files/GUID-3E0DCCD0-5F9A-44D0-8D5E-423237D49DB6.htm"}]},
{"title":"Textures",
"href":"./files/GUID-AD69D141-C5DD-4609-AD5A-4805321FADD4.htm",
"description":"The sample code in this topic is also presented in the ExportScene03/main.cxx sample program. Creating a Texture From a File FbxTexture is the base class for textures in the FBX SDK. Textures rely on",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Meshes, Materials and Textures","href":"./files/GUID-8A69CD20-B8FB-4B23-925A-372E408390AA.htm"}]},
{"title":"Layered Textures",
"href":"./files/GUID-452768B5-7A4F-45BD-AC37-DC1A034DCF3B.htm",
"description":"In this tutorial topic, we present the use of FbxLayeredTexture to layer four instances of FbxFileTexture. We also expand on the concept of FbxLayerElement to define a mesh\'s normals and UV coordinates. The code in this topic is written in Python, which applies directly to C++.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Meshes, Materials and Textures","href":"./files/GUID-8A69CD20-B8FB-4B23-925A-372E408390AA.htm"},{"title": "Textures","href":"./files/GUID-AD69D141-C5DD-4609-AD5A-4805321FADD4.htm"}]},
{"title":"Animation",
"href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm",
"description":"",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"Animation Data Structures",
"href":"./files/GUID-E8A5224C-488F-4477-AFE1-FC1EDB6934CB.htm",
"description":"The FBX SDK uses these data structures for animation: animation stacks (FbxAnimStack), animation layers (FbxAnimLayer), animation curve nodes (FbxAnimCurveNode), animation curves (FbxAnimCurve), and animation curve keys (FbxAnimCurveKey). The data structures are connected to each other through object-to-object (OO) connections and object-to-property (OP) connections in a FBX scene (FbxScene). See for more information about these data structures.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"}]},
{"title":"Animation Classes and their Interrelationships",
"href":"./files/GUID-386BAD6A-82F9-4148-BD5F-3FE2E90A87D0.htm",
"description":"Following are the classes that store animation-related data in a scene: Class Description FbxScene A scene can contain one or more animation stacks. You do not need to use animation stacks or other animation classes if there is no animation in the scene. FbxAnimStack The animation stack is the highest-level container for the animation data and contains one or more animation layers. FbxAnimLayer An animation layer contains one or more animation curve nodes that are connected to the animation curves. The animation stack must have at least one animation layer known as the base layer. For blended animation, more than one animation layer is required. FbxAnimCurve An animation curve, also known as function curve or FCurve defines how a FBX property (FbxProperty) of a FBX object is animated or different from the default value in the animation layer. The animation curves are connected to the animation curve nodes. The same animation curve can be connected to multiple animation curve nodes regardless of the referred FBX property. Accordingly, one animation curve can animate many FBX properties of many FBX objects. The values in the animation curves are dependent on the FBX property type and is validated by the application. Animation curves are not mandatory. To save the memory and processing time, FBX properties that are not animated can be left without using the animation curves. FbxAnimCurveNode An animation curve node (FbxAnimCurveNode) is the connection point between the animation curves and the FBX properties. To connect an animation curve to a FBX property, you can connect the animation curve and the FBX property to one animation curve node. An animation curve node can be connected to only one FBX property of one FBX object. FBX properties such as FbxNode::LclTranslation contain more than one value (X, Y, Z). If you create an animation curve node by calling FbxAnimCurveNode::CreateTypedCurveNode, you must specify a FBX property of the data type you need, for example, the function CreateTypedCurveNode() in LclTranslation creates an animation curve node with the necessary animation channels. In this example, channels X, Y, and Z. However, the animation curve node is not actually connected to the specified FBX property. See the animation sample program in <yourFBXSDKpath>\\samples\\Animation\\. To allow the same FBX property to have different values on each animation layer, an animation curve node must be connected to a single animation layer. If the same animation curve node is connected to multiple animation layers, the same value is used for the FBX property in each of these animation layers. FbxAnimCurveKey A key or keyframe marks the beginning and the end of an animation curve. FbxObject A FBX object can contain zero or more FBX properties. Class FbxNode contains the properties that deal with the location of an object as a point in space. FbxProperty A FBX property is strongly typed data that belongs to a FBX object. To animate a scene, you can set the appropriate FBX properties (LclTranslation is the most common) contained in the FBX objects. For more information, see .",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"},{"title": "Animation Data Structures","href":"./files/GUID-E8A5224C-488F-4477-AFE1-FC1EDB6934CB.htm"}]},
{"title":"Scene Showing Interrelationships among Data Structures",
"href":"./files/GUID-E7B43ABC-7F96-4A75-8769-3B7574F768AB.htm",
"description":"This example helps in understanding how the data structures are interrelated in a typical scene.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"},{"title": "Animation Data Structures","href":"./files/GUID-E8A5224C-488F-4477-AFE1-FC1EDB6934CB.htm"},{"title": "Animation Classes and their Interrelationships","href":"./files/GUID-386BAD6A-82F9-4148-BD5F-3FE2E90A87D0.htm"}]},
{"title":"Migrating to the New Data Structures for Animation",
"href":"./files/GUID-3DC64450-58B7-45D6-B7DD-F18190C247DB.htm",
"description":"The current FBX SDK animation system is completely redesigned. The data structures in FBX SDK 2010 such as take node, take node container, take info, and others have been replaced with new data structures. The following table explains the differences between the current data structures and the data structures in FBX SDK 2010.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"},{"title": "Animation Data Structures","href":"./files/GUID-E8A5224C-488F-4477-AFE1-FC1EDB6934CB.htm"}]},
{"title":"Writing and Using your Own Evaluator",
"href":"./files/GUID-D6A250C3-1014-4FAF-AB0A-5EC21B14A055.htm",
"description":"You can use the FbxAnimEvaluator class to evaluate the animation in a scene.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"},{"title": "Animation Data Structures","href":"./files/GUID-E8A5224C-488F-4477-AFE1-FC1EDB6934CB.htm"}]},
{"title":"Storing Animation in a Vertex Cache",
"href":"./files/GUID-92A66661-1A95-4D9F-81CD-6F41B15D2FA6.htm",
"description":"Vertex animation occurs at the sub-object (vertex) level, for example, moving four vertices in a sphere. A vertex cache is a method to store the vertex animations inside a cache file or point cache file so that the vertex animation is not lost during export from a program. To export the sub-object animation from a program like 3ds Max, every vertex position must be evaluated and stored in cache files.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"},{"title": "Animation Data Structures","href":"./files/GUID-E8A5224C-488F-4477-AFE1-FC1EDB6934CB.htm"}]},
{"title":"Blending Animation",
"href":"./files/GUID-9B6410C4-6441-4CAB-BFF5-FE6B07764232.htm",
"description":"Blending creates a smooth transition of motion from one animation to another. You can blend two animations that share common attributes and are a part of the same character set. When blending animation, you will get the best results if you blend animation that have similar motion. For example, creating a blend between a walking animation and a running animation.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"}]},
{"title":"Using the Blend Modes",
"href":"./files/GUID-29727281-5732-4F89-A06A-BBADD4C8993F.htm",
"description":"The blend mode specifies how the animation in an animation layer is blended with the animation in the preceding animation layers of the animation stack. The following table explains the blend modes: Mode Description Example Additive The animation layer adds the animation to the preceding animation layers in the animation stack. The preceding animation layers must affect the same FBX properties. If AnimLayerA and AnimLayerB both contain animation curve nodes that control the X translation of a FBX object, the resulting X translation is the sum of the X translation values in both the animation layers. Override The animation layer overrides the animation in the preceding animation layers of the animation stack. The preceding animation layers must control the same FBX properties. If AnimLayerA and AnimLayerB are in override mode, and the X translation of a FBX object on AnimLayerA is 10, and on AnimLayerB the X translation is 15, then the resulting X translation of the FBX object is 15. Override-Passthrough Unlike, the override mode that completely blocks the animation in the preceding animation layers, in the override-passthrough mode, you can control the opacity of the animation layer. The preceding animation layers must affect the same FBX properties. If AnimLayerC is in the override mode, then it is completely opaque and blocks the animation in the preceding animation layers. However, if AnimLayerC is in the override-passthrough mode, you can control the opacity of AnimLayerC by setting the weight value.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"},{"title": "Blending Animation","href":"./files/GUID-9B6410C4-6441-4CAB-BFF5-FE6B07764232.htm"}]},
{"title":"Bypassing the Blend Mode for Specific Data Types",
"href":"./files/GUID-8F28D5B6-C43D-47A5-8AD1-234F7092FE70.htm",
"description":"Each animation layer can contain animation curve nodes that specify many FBX properties of different data types. For FBX properties of a specific data type, you might not want the animation in one layer to blend with the animation in another layer, such as for the boolean data types.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"},{"title": "Blending Animation","href":"./files/GUID-9B6410C4-6441-4CAB-BFF5-FE6B07764232.htm"}]},
{"title":"Extracting the Animation Data from a FBX File",
"href":"./files/GUID-9481A726-315C-4A58-A347-8AC95C2AF0F2.htm",
"description":"You can extract and query the animation data from a scene (FBX file) without loading the entire FBX file.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"}]},
{"title":"Evaluating the Animation in a Scene",
"href":"./files/GUID-1870771B-1A50-4B8C-B2A0-6979509DE0C1.htm",
"description":"To render an animated scene (FbxScene), you must evaluate the animated properties of objects (FbxObject) in a scene at different points in time. For example, to display a moving race car that is represented by a mesh, you must animate the local translation property of the node whose node attribute is the mesh. See FbxNode::LclTranslation.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"}]},
{"title":"Example",
"href":"./files/GUID-F1FA12CF-0E40-44D6-82FC-EEB2DC23E06D.htm",
"description":"This section contains an example animation that will help you get familiar with the animation feature in the FBX SDK. This section is based on the CubeCreator tutorial program, located in <yourFBXSDKpath>\\samples\\UI Examples\\CubeCreator.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"}]},
{"title":"Animating a Node",
"href":"./files/GUID-E5C89F5F-09D1-4C32-BA83-28F63D0B2A6C.htm",
"description":"Setting up the data structures for animation is simple if you are not using blended animation. You need at least one animation stack, one animation layer, and one animation curve node for every FBX property.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Animation","href":"./files/GUID-B3311B8D-5390-4C63-AB9F-662AC7D5C6CC.htm"},{"title": "Example","href":"./files/GUID-F1FA12CF-0E40-44D6-82FC-EEB2DC23E06D.htm"}]},
{"title":"Scripting with Python FBX",
"href":"./files/GUID-724D83D7-02E2-4BD0-8610-9EF516508FD3.htm",
"description":"What is Python FBX? Python FBX is a Python binding for the C++ library of FBX SDK. It allows you to write Python scripts that can use many of the classes and member functions of FBX SDK. Python FBX",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"Platforms supported",
"href":"./files/GUID-CBF90ED2-798D-42E8-91DA-2AD0D3E82739.htm",
"description":"Python FBX is distributed with FBX SDK. There are separate distributions of FBX SDK for Windows, Linux, and Mac OS. Within these distributions, there are separate directories for each combination of Python version (2.6 or 3.1) and machine type (32-bit or 64-bit).",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Scripting with Python FBX","href":"./files/GUID-724D83D7-02E2-4BD0-8610-9EF516508FD3.htm"}]},
{"title":"Installing Python FBX",
"href":"./files/GUID-2F3A42FA-4C19-42F2-BC4F-B9EC64EA16AA.htm",
"description":"We assume that you have already installed and configured Python 2.6 or Python 3.1 on your computer. Let’s call the directory where you installed Python yourPythonPath .",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Scripting with Python FBX","href":"./files/GUID-724D83D7-02E2-4BD0-8610-9EF516508FD3.htm"}]},
{"title":"Using Python FBX with Eclipse",
"href":"./files/GUID-42C4206E-B67B-45D0-B783-18C6D5B5CB29.htm",
"description":"This topic presents a series of steps which allow you to use the Python FBX module (\"fbx\") in Eclipse - a cross-platform integrated development environment (IDE). Python code can be written in any text editor, however Eclipse provides an environment to write, debug, and execute Python code.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Scripting with Python FBX","href":"./files/GUID-724D83D7-02E2-4BD0-8610-9EF516508FD3.htm"}]},
{"title":"Importing FBX libraries into your Python script",
"href":"./files/GUID-A16EBF9E-4C5F-41E3-8957-6DB0D1D118A6.htm",
"description":"To write a script using Python FBX, you must import the Python FBX libraries into your script. Put the following statement at the beginning of your script:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Scripting with Python FBX","href":"./files/GUID-724D83D7-02E2-4BD0-8610-9EF516508FD3.htm"}]},
{"title":"Classes and member functions",
"href":"./files/GUID-46FE3BF9-C8D6-40B5-B105-858696409FD8.htm",
"description":"Python FBX provides Python equivalents to most of the classes and member functions of FBX SDK. For documentation about specific classes and member functions, see the documentation for the equivalent C++ class or member function.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Scripting with Python FBX","href":"./files/GUID-724D83D7-02E2-4BD0-8610-9EF516508FD3.htm"}]},
{"title":"Differences between FBX SDK and Python FBX",
"href":"./files/GUID-363E55D8-6EDB-40F8-8F58-E42F8D525D3D.htm",
"description":"Python FBX contains most of the classes and member functions that are available in FBX SDK itself. Here are the important differences:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Scripting with Python FBX","href":"./files/GUID-724D83D7-02E2-4BD0-8610-9EF516508FD3.htm"}]},
{"title":"List of Python Fbx classes",
"href":"./files/GUID-75F58D2F-1C2F-4315-AA77-608C857848D0.htm",
"description":"Here are the classes included in Python Fbx. In Fbx SDK Help, each of these classes is linked to the corresponding C++ documentation in Fbx SDK Reference.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "Scripting with Python FBX","href":"./files/GUID-724D83D7-02E2-4BD0-8610-9EF516508FD3.htm"}]},
{"title":"FBX Extensions SDK",
"href":"./files/GUID-E03E1C4B-FAD9-4E7B-9BBB-4F6782282402.htm",
"description":"What is the FBX Extensions SDK? The FBX Extensions SDK is a set of callback functions that you can define in a dynamically loaded library (.dll) to customize the behaviour of the FBX importing and ex",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"}]},
{"title":"Installing the FBX Extensions SDK",
"href":"./files/GUID-7AC48DE4-E90E-4F3C-B0E4-17F43C660E91.htm",
"description":"Runtime Requirements To run FBX Extensions written with the FBX Extensions SDK, you will need at least one of the following applications installed: Host Application Supported Platforms FBX Plug-in f",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX Extensions SDK","href":"./files/GUID-E03E1C4B-FAD9-4E7B-9BBB-4F6782282402.htm"}]},
{"title":"FBX Extensions to Maya",
"href":"./files/GUID-46861D48-8EFE-43DB-A0EA-2EE5AB6D441A.htm",
"description":"Maya FBX Extension Interface FBX Extensions to the FBX Plug-in for Maya can implement any or all of the following functions. Note that the MObject class refers to the Maya SDK. EXPORT_DLL bool MayaE",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX Extensions SDK","href":"./files/GUID-E03E1C4B-FAD9-4E7B-9BBB-4F6782282402.htm"}]},
{"title":"FBX Extensions to 3ds Max",
"href":"./files/GUID-93C4013B-3C05-447E-AECE-D63D23A87523.htm",
"description":"3ds Max FBX Extension Interface FBX Extensions to the FBX Plug-in for 3ds Max can implement any or all of the following functions. Note that the INode class refers to the 3ds Max SDK. EXPORT_DLL boo",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX Extensions SDK","href":"./files/GUID-E03E1C4B-FAD9-4E7B-9BBB-4F6782282402.htm"}]},
{"title":"FBX Extensions to MotionBuilder",
"href":"./files/GUID-520D5AE8-D35C-45F2-8C0F-CDC7F2295546.htm",
"description":"MotionBuilder FBX Extension Interface FBX Extensions to MotionBuilder can implement any or all of the following functions. Note that the HFBComponent class refers to the MotionBuilder 2012 SDK. EXPO",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX Extensions SDK","href":"./files/GUID-E03E1C4B-FAD9-4E7B-9BBB-4F6782282402.htm"}]},
{"title":"Exporting with the FBX Extensions SDK",
"href":"./files/GUID-6006F800-34F3-47B2-A208-E36DED53BEB3.htm",
"description":"Host Application Flow The following pseudocode shows the order of execution of an FBX Extension while a scene is being exported by the host application. Before translating any scene objects to FBX:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX Extensions SDK","href":"./files/GUID-E03E1C4B-FAD9-4E7B-9BBB-4F6782282402.htm"}]},
{"title":"Importing with the FBX Extensions SDK",
"href":"./files/GUID-963050F3-70DC-448B-BA52-AED9B32B6DEC.htm",
"description":"Host Application Flow The following pseudocode shows the order of execution of an FBX Extension while a scene is being imported by the host application. At the beginning of the import process:",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX Extensions SDK","href":"./files/GUID-E03E1C4B-FAD9-4E7B-9BBB-4F6782282402.htm"}]},
{"title":"Customizing File Formats",
"href":"./files/GUID-403ED27A-3B7B-4EB4-A46D-AC7E9857D43D.htm",
"description":"The file formats supported by the FBX SDK can be found in Supported File Formats. It is possible to customize your own file format for use with the FBX SDK. For more information, see Customizing File Formats with FBX SDK I/O Plug-ins.",
"ancestors":[{"title": "FBX SDK Programmer\'s Guide","href":"./files/GUID-7A590C04-D849-4514-B243-21B981B1132E.htm"},{"title": "FBX Extensions SDK","href":"./files/GUID-E03E1C4B-FAD9-4E7B-9BBB-4F6782282402.htm"}]},
{"title":"C++: AnimationElement Class Reference",
"href":"cpp_ref/class_animation_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: ElementBase Class Reference",
"href":"cpp_ref/class_element_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: Fbx6ClassTemplateMap Class Reference",
"href":"cpp_ref/class_fbx6_class_template_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: Fbx6ClassTemplateMap::FbxClassIdCompare Class Reference",
"href":"cpp_ref/class_fbx6_class_template_map_1_1_fbx_class_id_compare.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAccumulatorEntry Class Reference",
"href":"cpp_ref/class_fbx_accumulator_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAddBOF Class Reference",
"href":"cpp_ref/class_fbx_add_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurve Class Reference",
"href":"cpp_ref/class_fbx_anim_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveBase Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveDef Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilter Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterConstantKeyReducer Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_constant_key_reducer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterGimbleKiller Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_gimble_killer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterKeyReducer Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_key_reducer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterKeySync Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_key_sync.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterMatrixConverter Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_matrix_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterResample Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_resample.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterScale Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_scale.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterScaleByCurve Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_scale_by_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterScaleCompensate Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_scale_compensate.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterTSS Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_t_s_s.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveFilterUnroll Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_filter_unroll.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveKey Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveKeyBase Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_key_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveKey_Impl Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_key___impl.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveNode Class Reference",
"href":"cpp_ref/class_fbx_anim_curve_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimEvaluator Class Reference",
"href":"cpp_ref/class_fbx_anim_evaluator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimEvalClassic Class Reference",
"href":"cpp_ref/class_fbx_anim_eval_classic.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimEvalState Class Reference",
"href":"cpp_ref/class_fbx_anim_eval_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimLayer Class Reference",
"href":"cpp_ref/class_fbx_anim_layer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimStack Class Reference",
"href":"cpp_ref/class_fbx_anim_stack.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimUtilities Class Reference",
"href":"cpp_ref/class_fbx_anim_utilities.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimUtilities::CurveIntfce Class Reference",
"href":"cpp_ref/class_fbx_anim_utilities_1_1_curve_intfce.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimUtilities::CurveNodeIntfce Class Reference",
"href":"cpp_ref/class_fbx_anim_utilities_1_1_curve_node_intfce.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimUtilities::FbxAnimSplitDef Class Reference",
"href":"cpp_ref/class_fbx_anim_utilities_1_1_fbx_anim_split_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxArray< T > Class Template Reference",
"href":"cpp_ref/class_fbx_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAssignBOF Class Reference",
"href":"cpp_ref/class_fbx_assign_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAtomOp Class Reference",
"href":"cpp_ref/class_fbx_atom_op.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAutoDeletePtr< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_auto_delete_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAutoDestroyPtr< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_auto_destroy_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAutoFreePtr< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_auto_free_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAutoPtr< Type, Policy > Class Template Reference",
"href":"cpp_ref/class_fbx_auto_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAxisSystem Class Reference",
"href":"cpp_ref/class_fbx_axis_system.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAMatrix Class Reference",
"href":"cpp_ref/class_fbx_a_matrix.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBase64Decoder Class Reference",
"href":"cpp_ref/class_fbx_base64_decoder.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBase64Encoder Class Reference",
"href":"cpp_ref/class_fbx_base64_encoder.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBaseAllocator Class Reference",
"href":"cpp_ref/class_fbx_base_allocator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingsEntryView Class Reference",
"href":"cpp_ref/class_fbx_bindings_entry_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingOperator Class Reference",
"href":"cpp_ref/class_fbx_binding_operator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingOperator::Function Class Reference",
"href":"cpp_ref/class_fbx_binding_operator_1_1_function.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingOperator::FunctionCreator< FUNCTION > Class Template Reference",
"href":"cpp_ref/class_fbx_binding_operator_1_1_function_creator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingOperator::FunctionCreatorBase Class Reference",
"href":"cpp_ref/class_fbx_binding_operator_1_1_function_creator_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingOperator::FunctionRegistry Class Reference",
"href":"cpp_ref/class_fbx_binding_operator_1_1_function_registry.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingTable Class Reference",
"href":"cpp_ref/class_fbx_binding_table.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingTableBase Class Reference",
"href":"cpp_ref/class_fbx_binding_table_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBindingTableEntry Class Reference",
"href":"cpp_ref/class_fbx_binding_table_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBitSet Class Reference",
"href":"cpp_ref/class_fbx_bit_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBlendShape Class Reference",
"href":"cpp_ref/class_fbx_blend_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBlendShapeChannel Class Reference",
"href":"cpp_ref/class_fbx_blend_shape_channel.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBlob Class Reference",
"href":"cpp_ref/class_fbx_blob.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxBoundary Class Reference",
"href":"cpp_ref/class_fbx_boundary.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCache Class Reference",
"href":"cpp_ref/class_fbx_cache.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCachedEffect Class Reference",
"href":"cpp_ref/class_fbx_cached_effect.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCamera Class Reference",
"href":"cpp_ref/class_fbx_camera.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCameraManipulator Class Reference",
"href":"cpp_ref/class_fbx_camera_manipulator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCameraStereo Class Reference",
"href":"cpp_ref/class_fbx_camera_stereo.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCameraSwitcher Class Reference",
"href":"cpp_ref/class_fbx_camera_switcher.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCharacter Class Reference",
"href":"cpp_ref/class_fbx_character.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCharacterLink Class Reference",
"href":"cpp_ref/class_fbx_character_link.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCharacterPose Class Reference",
"href":"cpp_ref/class_fbx_character_pose.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCharacterPropertyInfo Class Reference",
"href":"cpp_ref/class_fbx_character_property_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCharCompare Class Reference",
"href":"cpp_ref/class_fbx_char_compare.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCharPtrSet Class Reference",
"href":"cpp_ref/class_fbx_char_ptr_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxClassId Class Reference",
"href":"cpp_ref/class_fbx_class_id.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCloneManager Class Reference",
"href":"cpp_ref/class_fbx_clone_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCloneManager::ObjectCompare Class Reference",
"href":"cpp_ref/class_fbx_clone_manager_1_1_object_compare.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCluster Class Reference",
"href":"cpp_ref/class_fbx_cluster.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCollection Class Reference",
"href":"cpp_ref/class_fbx_collection.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCollectionExclusive Class Reference",
"href":"cpp_ref/class_fbx_collection_exclusive.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxColor Class Reference",
"href":"cpp_ref/class_fbx_color.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConditionalBOF Class Reference",
"href":"cpp_ref/class_fbx_conditional_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConnection Class Reference",
"href":"cpp_ref/class_fbx_connection.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConnectionPoint Class Reference",
"href":"cpp_ref/class_fbx_connection_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConnectionPointFilter Class Reference",
"href":"cpp_ref/class_fbx_connection_point_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstantEntryView Class Reference",
"href":"cpp_ref/class_fbx_constant_entry_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraint Class Reference",
"href":"cpp_ref/class_fbx_constraint.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraintAim Class Reference",
"href":"cpp_ref/class_fbx_constraint_aim.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraintCustom Class Reference",
"href":"cpp_ref/class_fbx_constraint_custom.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraintParent Class Reference",
"href":"cpp_ref/class_fbx_constraint_parent.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraintPosition Class Reference",
"href":"cpp_ref/class_fbx_constraint_position.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraintRotation Class Reference",
"href":"cpp_ref/class_fbx_constraint_rotation.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraintScale Class Reference",
"href":"cpp_ref/class_fbx_constraint_scale.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraintSingleChainIK Class Reference",
"href":"cpp_ref/class_fbx_constraint_single_chain_i_k.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxConstraintUtils Class Reference",
"href":"cpp_ref/class_fbx_constraint_utils.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxContainer Class Reference",
"href":"cpp_ref/class_fbx_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxContainerTemplate Class Reference",
"href":"cpp_ref/class_fbx_container_template.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxControlSet Class Reference",
"href":"cpp_ref/class_fbx_control_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxControlSetLink Class Reference",
"href":"cpp_ref/class_fbx_control_set_link.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxControlSetPlug Class Reference",
"href":"cpp_ref/class_fbx_control_set_plug.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCriteria Class Reference",
"href":"cpp_ref/class_fbx_criteria.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDataType Class Reference",
"href":"cpp_ref/class_fbx_data_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDateTime Class Reference",
"href":"cpp_ref/class_fbx_date_time.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDefaultComparator< T > Class Template Reference",
"href":"cpp_ref/class_fbx_default_comparator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDeformationsEvaluator Class Reference",
"href":"cpp_ref/class_fbx_deformations_evaluator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDeformer Class Reference",
"href":"cpp_ref/class_fbx_deformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDegreeToRadianBOF Class Reference",
"href":"cpp_ref/class_fbx_degree_to_radian_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDeletionPolicyDefault< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_deletion_policy_default.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDeletionPolicyDelete< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_deletion_policy_delete.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDeletionPolicyFree< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_deletion_policy_free.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDeletionPolicyObject< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_deletion_policy_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDisplayLayer Class Reference",
"href":"cpp_ref/class_fbx_display_layer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDistance Class Reference",
"href":"cpp_ref/class_fbx_distance.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDocument Class Reference",
"href":"cpp_ref/class_fbx_document.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDocumentInfo Class Reference",
"href":"cpp_ref/class_fbx_document_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDualQuaternion Class Reference",
"href":"cpp_ref/class_fbx_dual_quaternion.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxDynamicArray< VALUE_TYPE, ALLOCATOR > Class Template Reference",
"href":"cpp_ref/class_fbx_dynamic_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEffector Class Reference",
"href":"cpp_ref/class_fbx_effector.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEmbeddedFilesAccumulator Class Reference",
"href":"cpp_ref/class_fbx_embedded_files_accumulator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEmitter Class Reference",
"href":"cpp_ref/class_fbx_emitter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEntryView Class Reference",
"href":"cpp_ref/class_fbx_entry_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEnvironment Class Reference",
"href":"cpp_ref/class_fbx_environment.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEuler Class Reference",
"href":"cpp_ref/class_fbx_euler.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEvent< T > Class Template Reference",
"href":"cpp_ref/class_fbx_event.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEventBase Class Reference",
"href":"cpp_ref/class_fbx_event_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEventHandler Class Reference",
"href":"cpp_ref/class_fbx_event_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEventPostExport Class Reference",
"href":"cpp_ref/class_fbx_event_post_export.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEventPostImport Class Reference",
"href":"cpp_ref/class_fbx_event_post_import.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEventPreExport Class Reference",
"href":"cpp_ref/class_fbx_event_pre_export.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEventPreImport Class Reference",
"href":"cpp_ref/class_fbx_event_pre_import.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEventReferencedDocument Class Reference",
"href":"cpp_ref/class_fbx_event_referenced_document.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxExporter Class Reference",
"href":"cpp_ref/class_fbx_exporter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxExternalDocRefListener Class Reference",
"href":"cpp_ref/class_fbx_external_doc_ref_listener.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxFile Class Reference",
"href":"cpp_ref/class_fbx_file.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxFileTexture Class Reference",
"href":"cpp_ref/class_fbx_file_texture.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxFileUtils Class Reference",
"href":"cpp_ref/class_fbx_file_utils.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxFolder Class Reference",
"href":"cpp_ref/class_fbx_folder.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGate Class Reference",
"href":"cpp_ref/class_fbx_gate.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGenericNode Class Reference",
"href":"cpp_ref/class_fbx_generic_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGeometry Class Reference",
"href":"cpp_ref/class_fbx_geometry.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGeometryBase Class Reference",
"href":"cpp_ref/class_fbx_geometry_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGeometryConverter Class Reference",
"href":"cpp_ref/class_fbx_geometry_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGeometryWeightedMap Class Reference",
"href":"cpp_ref/class_fbx_geometry_weighted_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGlobalCameraSettings Class Reference",
"href":"cpp_ref/class_fbx_global_camera_settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGlobalLightSettings Class Reference",
"href":"cpp_ref/class_fbx_global_light_settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGlobalSettings Class Reference",
"href":"cpp_ref/class_fbx_global_settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGobo Class Reference",
"href":"cpp_ref/class_fbx_gobo.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxHalfFloat Class Reference",
"href":"cpp_ref/class_fbx_half_float.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxHashMap< KEY, VALUE, HASH, Destruct, Comparator > Class Template Reference",
"href":"cpp_ref/class_fbx_hash_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxHashMap< KEY, VALUE, HASH, Destruct, Comparator >::Iterator Class Reference",
"href":"cpp_ref/class_fbx_hash_map_1_1_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxHungryAllocator Class Reference",
"href":"cpp_ref/class_fbx_hungry_allocator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxImplementation Class Reference",
"href":"cpp_ref/class_fbx_implementation.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxImplementationFilter Class Reference",
"href":"cpp_ref/class_fbx_implementation_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxImporter Class Reference",
"href":"cpp_ref/class_fbx_importer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIsYupBOF Class Reference",
"href":"cpp_ref/class_fbx_is_yup_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIterator< FbxProperty > Class Template Reference",
"href":"cpp_ref/class_fbx_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIteratorDst< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_iterator_dst.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIteratorDstBase Class Reference",
"href":"cpp_ref/class_fbx_iterator_dst_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIteratorSrc< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_iterator_src.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIteratorSrcBase Class Reference",
"href":"cpp_ref/class_fbx_iterator_src_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIO Class Reference",
"href":"cpp_ref/class_fbx_i_o.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIOBase Class Reference",
"href":"cpp_ref/class_fbx_i_o_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIODefaultRenderResolution Class Reference",
"href":"cpp_ref/class_fbx_i_o_default_render_resolution.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIOFileHeaderInfo Class Reference",
"href":"cpp_ref/class_fbx_i_o_file_header_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIOPluginRegistry Class Reference",
"href":"cpp_ref/class_fbx_i_o_plugin_registry.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIOSettings Class Reference",
"href":"cpp_ref/class_fbx_i_o_settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayer Class Reference",
"href":"cpp_ref/class_fbx_layer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayeredTexture Class Reference",
"href":"cpp_ref/class_fbx_layered_texture.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerContainer Class Reference",
"href":"cpp_ref/class_fbx_layer_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElement Class Reference",
"href":"cpp_ref/class_fbx_layer_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementArray Class Reference",
"href":"cpp_ref/class_fbx_layer_element_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementArrayTemplate< T > Class Template Reference",
"href":"cpp_ref/class_fbx_layer_element_array_template.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementBinormal Class Reference",
"href":"cpp_ref/class_fbx_layer_element_binormal.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementCrease Class Reference",
"href":"cpp_ref/class_fbx_layer_element_crease.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementHole Class Reference",
"href":"cpp_ref/class_fbx_layer_element_hole.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementMaterial Class Reference",
"href":"cpp_ref/class_fbx_layer_element_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementMaterial::LayerElementArrayProxy Class Reference",
"href":"cpp_ref/class_fbx_layer_element_material_1_1_layer_element_array_proxy.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementNormal Class Reference",
"href":"cpp_ref/class_fbx_layer_element_normal.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementPolygonGroup Class Reference",
"href":"cpp_ref/class_fbx_layer_element_polygon_group.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementSmoothing Class Reference",
"href":"cpp_ref/class_fbx_layer_element_smoothing.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementTangent Class Reference",
"href":"cpp_ref/class_fbx_layer_element_tangent.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementTemplate< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_layer_element_template.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementTexture Class Reference",
"href":"cpp_ref/class_fbx_layer_element_texture.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementUserData Class Reference",
"href":"cpp_ref/class_fbx_layer_element_user_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementUV Class Reference",
"href":"cpp_ref/class_fbx_layer_element_u_v.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementVertexColor Class Reference",
"href":"cpp_ref/class_fbx_layer_element_vertex_color.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementVisibility Class Reference",
"href":"cpp_ref/class_fbx_layer_element_visibility.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerEntryView Class Reference",
"href":"cpp_ref/class_fbx_layer_entry_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLibrary Class Reference",
"href":"cpp_ref/class_fbx_library.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLight Class Reference",
"href":"cpp_ref/class_fbx_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLimits Class Reference",
"href":"cpp_ref/class_fbx_limits.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLimitsUtilities Class Reference",
"href":"cpp_ref/class_fbx_limits_utilities.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLine Class Reference",
"href":"cpp_ref/class_fbx_line.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxListener Class Reference",
"href":"cpp_ref/class_fbx_listener.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLoadingStrategy Class Reference",
"href":"cpp_ref/class_fbx_loading_strategy.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLocalTime Class Reference",
"href":"cpp_ref/class_fbx_local_time.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLODGroup Class Reference",
"href":"cpp_ref/class_fbx_l_o_d_group.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxManager Class Reference",
"href":"cpp_ref/class_fbx_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMap< Key, Type, Compare, Allocator > Class Template Reference",
"href":"cpp_ref/class_fbx_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMap< Key, Type, Compare, Allocator >::KeyValuePair Class Reference",
"href":"cpp_ref/class_fbx_map_1_1_key_value_pair.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMarker Class Reference",
"href":"cpp_ref/class_fbx_marker.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMaterialConverter Class Reference",
"href":"cpp_ref/class_fbx_material_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMatrix Class Reference",
"href":"cpp_ref/class_fbx_matrix.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMemoryPool Class Reference",
"href":"cpp_ref/class_fbx_memory_pool.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh Class Reference",
"href":"cpp_ref/class_fbx_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh::DuplicateVertex Class Reference",
"href":"cpp_ref/class_fbx_mesh_1_1_duplicate_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh::VertexNormalInfo Class Reference",
"href":"cpp_ref/class_fbx_mesh_1_1_vertex_normal_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMultiplyBOF Class Reference",
"href":"cpp_ref/class_fbx_multiply_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMultiplyDistBOF Class Reference",
"href":"cpp_ref/class_fbx_multiply_dist_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMutex Class Reference",
"href":"cpp_ref/class_fbx_mutex.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNameFilter Class Reference",
"href":"cpp_ref/class_fbx_name_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNameHandler Class Reference",
"href":"cpp_ref/class_fbx_name_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNameMapCompare Class Reference",
"href":"cpp_ref/class_fbx_name_map_compare.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNode Class Reference",
"href":"cpp_ref/class_fbx_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNodeAttribute Class Reference",
"href":"cpp_ref/class_fbx_node_attribute.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNodeDirectionBOF Class Reference",
"href":"cpp_ref/class_fbx_node_direction_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNodeEvalState Class Reference",
"href":"cpp_ref/class_fbx_node_eval_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNodePositionBOF Class Reference",
"href":"cpp_ref/class_fbx_node_position_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNoOpDestruct< T > Class Template Reference",
"href":"cpp_ref/class_fbx_no_op_destruct.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNull Class Reference",
"href":"cpp_ref/class_fbx_null.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNurbs Class Reference",
"href":"cpp_ref/class_fbx_nurbs.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNurbsCurve Class Reference",
"href":"cpp_ref/class_fbx_nurbs_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxNurbsSurface Class Reference",
"href":"cpp_ref/class_fbx_nurbs_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxObject Class Reference",
"href":"cpp_ref/class_fbx_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxObjectsContainer Class Reference",
"href":"cpp_ref/class_fbx_objects_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxObjectFilter Class Reference",
"href":"cpp_ref/class_fbx_object_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxObjectMap< Type, Compare > Class Template Reference",
"href":"cpp_ref/class_fbx_object_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxObjectMetaData Class Reference",
"href":"cpp_ref/class_fbx_object_meta_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxObjectStringMap Class Reference",
"href":"cpp_ref/class_fbx_object_string_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxOneOverXBOF Class Reference",
"href":"cpp_ref/class_fbx_one_over_x_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxOperatorEntryView Class Reference",
"href":"cpp_ref/class_fbx_operator_entry_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxOpticalReference Class Reference",
"href":"cpp_ref/class_fbx_optical_reference.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPair< S, T > Class Template Reference",
"href":"cpp_ref/class_fbx_pair.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPatch Class Reference",
"href":"cpp_ref/class_fbx_patch.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPathUtils Class Reference",
"href":"cpp_ref/class_fbx_path_utils.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPeripheral Class Reference",
"href":"cpp_ref/class_fbx_peripheral.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPlugin Class Reference",
"href":"cpp_ref/class_fbx_plugin.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPluginContainer Class Reference",
"href":"cpp_ref/class_fbx_plugin_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPose Class Reference",
"href":"cpp_ref/class_fbx_pose.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPowerBOF Class Reference",
"href":"cpp_ref/class_fbx_power_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProceduralGeometry Class Reference",
"href":"cpp_ref/class_fbx_procedural_geometry.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProceduralTexture Class Reference",
"href":"cpp_ref/class_fbx_procedural_texture.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProcessor Class Reference",
"href":"cpp_ref/class_fbx_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProcessorShaderDependency Class Reference",
"href":"cpp_ref/class_fbx_processor_shader_dependency.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProcessorXRefCopy Class Reference",
"href":"cpp_ref/class_fbx_processor_x_ref_copy.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProcessorXRefCopy::MissingUrlHandler Class Reference",
"href":"cpp_ref/class_fbx_processor_x_ref_copy_1_1_missing_url_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProcessorXRefCopyUserLibrary Class Reference",
"href":"cpp_ref/class_fbx_processor_x_ref_copy_user_library.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProgress Class Reference",
"href":"cpp_ref/class_fbx_progress.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProperty Class Reference",
"href":"cpp_ref/class_fbx_property.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProperty::FbxPropertyNameCache Class Reference",
"href":"cpp_ref/class_fbx_property_1_1_fbx_property_name_cache.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyAttr Class Reference",
"href":"cpp_ref/class_fbx_property_attr.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyConnect Class Reference",
"href":"cpp_ref/class_fbx_property_connect.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyEntry Class Reference",
"href":"cpp_ref/class_fbx_property_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyEntryView Class Reference",
"href":"cpp_ref/class_fbx_property_entry_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyFlagsExt Class Reference",
"href":"cpp_ref/class_fbx_property_flags_ext.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyHandle Class Reference",
"href":"cpp_ref/class_fbx_property_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyIdGenerator Class Reference",
"href":"cpp_ref/class_fbx_property_id_generator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyInfo Class Reference",
"href":"cpp_ref/class_fbx_property_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyPage Class Reference",
"href":"cpp_ref/class_fbx_property_page.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyT< T > Class Template Reference",
"href":"cpp_ref/class_fbx_property_t.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPropertyValue Class Reference",
"href":"cpp_ref/class_fbx_property_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPtrDestruct< T > Class Template Reference",
"href":"cpp_ref/class_fbx_ptr_destruct.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxQuaternion Class Reference",
"href":"cpp_ref/class_fbx_quaternion.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxQuery Class Reference",
"href":"cpp_ref/class_fbx_query.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxQueryEvent< QueryT > Class Template Reference",
"href":"cpp_ref/class_fbx_query_event.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxReader Class Reference",
"href":"cpp_ref/class_fbx_reader.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxReaderCollada Class Reference",
"href":"cpp_ref/class_fbx_reader_collada.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxReaderFbx5 Class Reference",
"href":"cpp_ref/class_fbx_reader_fbx5.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxReaderFbx6 Class Reference",
"href":"cpp_ref/class_fbx_reader_fbx6.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxReaderFbx7 Class Reference",
"href":"cpp_ref/class_fbx_reader_fbx7.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRenamingStrategy Class Reference",
"href":"cpp_ref/class_fbx_renaming_strategy.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRenamingStrategyBase Class Reference",
"href":"cpp_ref/class_fbx_renaming_strategy_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRenamingStrategyFbx5 Class Reference",
"href":"cpp_ref/class_fbx_renaming_strategy_fbx5.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRenamingStrategyFbx6 Class Reference",
"href":"cpp_ref/class_fbx_renaming_strategy_fbx6.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRenamingStrategyFbx7 Class Reference",
"href":"cpp_ref/class_fbx_renaming_strategy_fbx7.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRenamingStrategyInterface Class Reference",
"href":"cpp_ref/class_fbx_renaming_strategy_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRenamingStrategyNumber Class Reference",
"href":"cpp_ref/class_fbx_renaming_strategy_number.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRenamingStrategyUtils Class Reference",
"href":"cpp_ref/class_fbx_renaming_strategy_utils.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRootNodeUtility Class Reference",
"href":"cpp_ref/class_fbx_root_node_utility.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxRotationOrder Class Reference",
"href":"cpp_ref/class_fbx_rotation_order.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxScene Class Reference",
"href":"cpp_ref/class_fbx_scene.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSceneReference Class Reference",
"href":"cpp_ref/class_fbx_scene_reference.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSceneRenamer Class Reference",
"href":"cpp_ref/class_fbx_scene_renamer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxScopedLoadingDirectory Class Reference",
"href":"cpp_ref/class_fbx_scoped_loading_directory.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxScopedLoadingFileName Class Reference",
"href":"cpp_ref/class_fbx_scoped_loading_file_name.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSelectionNode Class Reference",
"href":"cpp_ref/class_fbx_selection_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSelectionSet Class Reference",
"href":"cpp_ref/class_fbx_selection_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSemanticEntryView Class Reference",
"href":"cpp_ref/class_fbx_semantic_entry_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSemaphore Class Reference",
"href":"cpp_ref/class_fbx_semaphore.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSet Class Reference",
"href":"cpp_ref/class_fbx_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSet2< Type, Compare, Allocator > Class Template Reference",
"href":"cpp_ref/class_fbx_set2.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSet2< Type, Compare, Allocator >::Value Class Reference",
"href":"cpp_ref/class_fbx_set2_1_1_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxShape Class Reference",
"href":"cpp_ref/class_fbx_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSimpleMap< Key, Type, Compare > Class Template Reference",
"href":"cpp_ref/class_fbx_simple_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSkeleton Class Reference",
"href":"cpp_ref/class_fbx_skeleton.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSkin Class Reference",
"href":"cpp_ref/class_fbx_skin.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSphericalToCartesianBOF Class Reference",
"href":"cpp_ref/class_fbx_spherical_to_cartesian_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSpinLock Class Reference",
"href":"cpp_ref/class_fbx_spin_lock.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSpotDistributionChooserBOF Class Reference",
"href":"cpp_ref/class_fbx_spot_distribution_chooser_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStatistics Class Reference",
"href":"cpp_ref/class_fbx_statistics.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStatus Class Reference",
"href":"cpp_ref/class_fbx_status.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStatusGlobal Class Reference",
"href":"cpp_ref/class_fbx_status_global.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStream Class Reference",
"href":"cpp_ref/class_fbx_stream.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxString Class Reference",
"href":"cpp_ref/class_fbx_string.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStringCompare Class Reference",
"href":"cpp_ref/class_fbx_string_compare.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStringList Class Reference",
"href":"cpp_ref/class_fbx_string_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStringListItem Class Reference",
"href":"cpp_ref/class_fbx_string_list_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStringListT< Type > Class Template Reference",
"href":"cpp_ref/class_fbx_string_list_t.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxStringSymbol Class Reference",
"href":"cpp_ref/class_fbx_string_symbol.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSubstractBOF Class Reference",
"href":"cpp_ref/class_fbx_substract_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSubDeformer Class Reference",
"href":"cpp_ref/class_fbx_sub_deformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSurfaceLambert Class Reference",
"href":"cpp_ref/class_fbx_surface_lambert.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSurfaceMaterial Class Reference",
"href":"cpp_ref/class_fbx_surface_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSurfacePhong Class Reference",
"href":"cpp_ref/class_fbx_surface_phong.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSwitchBOF Class Reference",
"href":"cpp_ref/class_fbx_switch_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSymbol Class Reference",
"href":"cpp_ref/class_fbx_symbol.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSymbolIDBOF Class Reference",
"href":"cpp_ref/class_fbx_symbol_i_d_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSyncStack Class Reference",
"href":"cpp_ref/class_fbx_sync_stack.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSystemUnit Class Reference",
"href":"cpp_ref/class_fbx_system_unit.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxTakeInfo Class Reference",
"href":"cpp_ref/class_fbx_take_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxTexture Class Reference",
"href":"cpp_ref/class_fbx_texture.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxThread Class Reference",
"href":"cpp_ref/class_fbx_thread.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxThumbnail Class Reference",
"href":"cpp_ref/class_fbx_thumbnail.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxTime Class Reference",
"href":"cpp_ref/class_fbx_time.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxTimeSpan Class Reference",
"href":"cpp_ref/class_fbx_time_span.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxTransform Class Reference",
"href":"cpp_ref/class_fbx_transform.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxTrimNurbsSurface Class Reference",
"href":"cpp_ref/class_fbx_trim_nurbs_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxTRSToMatrixBOF Class Reference",
"href":"cpp_ref/class_fbx_t_r_s_to_matrix_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxUserNotification Class Reference",
"href":"cpp_ref/class_fbx_user_notification.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxUserNotification::AESequence Class Reference",
"href":"cpp_ref/class_fbx_user_notification_1_1_a_e_sequence.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxUserNotificationFilteredIterator Class Reference",
"href":"cpp_ref/class_fbx_user_notification_filtered_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxVector2 Class Reference",
"href":"cpp_ref/class_fbx_vector2.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxVector4 Class Reference",
"href":"cpp_ref/class_fbx_vector4.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxVectorDegreeToVectorRadianBOF Class Reference",
"href":"cpp_ref/class_fbx_vector_degree_to_vector_radian_b_o_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxVectorTemplate2< T > Class Template Reference",
"href":"cpp_ref/class_fbx_vector_template2.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxVectorTemplate3< T > Class Template Reference",
"href":"cpp_ref/class_fbx_vector_template3.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxVectorTemplate4< T > Class Template Reference",
"href":"cpp_ref/class_fbx_vector_template4.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxVertexCacheDeformer Class Reference",
"href":"cpp_ref/class_fbx_vertex_cache_deformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxVideo Class Reference",
"href":"cpp_ref/class_fbx_video.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxWeightedMapping Class Reference",
"href":"cpp_ref/class_fbx_weighted_mapping.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxWriter Class Reference",
"href":"cpp_ref/class_fbx_writer.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxWriterCollada Class Reference",
"href":"cpp_ref/class_fbx_writer_collada.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxWriterFbx5 Class Reference",
"href":"cpp_ref/class_fbx_writer_fbx5.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxWriterFbx6 Class Reference",
"href":"cpp_ref/class_fbx_writer_fbx6.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxWriterFbx7 Class Reference",
"href":"cpp_ref/class_fbx_writer_fbx7.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxXRefManager Class Reference",
"href":"cpp_ref/class_fbx_x_ref_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: HIK2FbxCharacterPropertyBridge Class Reference",
"href":"cpp_ref/class_h_i_k2_fbx_character_property_bridge.html",
"description":"",
"ancestors":[]},
{"title":"C++: LockAccessStatus Class Reference",
"href":"cpp_ref/class_lock_access_status.html",
"description":"",
"ancestors":[]},
{"title":"C++: XmlNodeDeletionPolicy Class Reference",
"href":"cpp_ref/class_xml_node_deletion_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: Examples",
"href":"cpp_ref/examples.html",
"description":"",
"ancestors":[]},
{"title":"C++: examples.txt0 File Reference",
"href":"cpp_ref/examples_8txt0.html",
"description":"",
"ancestors":[]},
{"title":"C++: examples.txt0 Source File",
"href":"cpp_ref/examples_8txt0_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxaffinematrix.h File Reference",
"href":"cpp_ref/fbxaffinematrix_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxaffinematrix.h Source File",
"href":"cpp_ref/fbxaffinematrix_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxalloc.h File Reference",
"href":"cpp_ref/fbxalloc_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxalloc.h Source File",
"href":"cpp_ref/fbxalloc_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimcurvebase.h File Reference",
"href":"cpp_ref/fbxanimcurvebase_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimcurvebase.h Source File",
"href":"cpp_ref/fbxanimcurvebase_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimcurvefilters.h File Reference",
"href":"cpp_ref/fbxanimcurvefilters_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimcurvefilters.h Source File",
"href":"cpp_ref/fbxanimcurvefilters_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimcurvenode.h File Reference",
"href":"cpp_ref/fbxanimcurvenode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimcurvenode.h Source File",
"href":"cpp_ref/fbxanimcurvenode_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimcurve.h File Reference",
"href":"cpp_ref/fbxanimcurve_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimcurve.h Source File",
"href":"cpp_ref/fbxanimcurve_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimevalclassic.h File Reference",
"href":"cpp_ref/fbxanimevalclassic_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimevalclassic.h Source File",
"href":"cpp_ref/fbxanimevalclassic_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimevalstate.h File Reference",
"href":"cpp_ref/fbxanimevalstate_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimevalstate.h Source File",
"href":"cpp_ref/fbxanimevalstate_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimevaluator.h File Reference",
"href":"cpp_ref/fbxanimevaluator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimevaluator.h Source File",
"href":"cpp_ref/fbxanimevaluator_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimlayer.h File Reference",
"href":"cpp_ref/fbxanimlayer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimlayer.h Source File",
"href":"cpp_ref/fbxanimlayer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimstack.h File Reference",
"href":"cpp_ref/fbxanimstack_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimstack.h Source File",
"href":"cpp_ref/fbxanimstack_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimutilities.h File Reference",
"href":"cpp_ref/fbxanimutilities_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/animation/fbxanimutilities.h Source File",
"href":"cpp_ref/fbxanimutilities_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxarch.h File Reference",
"href":"cpp_ref/fbxarch_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxarch.h Source File",
"href":"cpp_ref/fbxarch_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxarray.h File Reference",
"href":"cpp_ref/fbxarray_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxarray.h Source File",
"href":"cpp_ref/fbxarray_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/sync/fbxatomic.h File Reference",
"href":"cpp_ref/fbxatomic_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/sync/fbxatomic.h Source File",
"href":"cpp_ref/fbxatomic_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxaxissystem.h File Reference",
"href":"cpp_ref/fbxaxissystem_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxaxissystem.h Source File",
"href":"cpp_ref/fbxaxissystem_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxbase64coder.h File Reference",
"href":"cpp_ref/fbxbase64coder_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxbase64coder.h Source File",
"href":"cpp_ref/fbxbase64coder_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingoperator.h File Reference",
"href":"cpp_ref/fbxbindingoperator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingoperator.h Source File",
"href":"cpp_ref/fbxbindingoperator_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingsentryview.h File Reference",
"href":"cpp_ref/fbxbindingsentryview_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingsentryview.h Source File",
"href":"cpp_ref/fbxbindingsentryview_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingtablebase.h File Reference",
"href":"cpp_ref/fbxbindingtablebase_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingtablebase.h Source File",
"href":"cpp_ref/fbxbindingtablebase_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingtableentry.h File Reference",
"href":"cpp_ref/fbxbindingtableentry_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingtableentry.h Source File",
"href":"cpp_ref/fbxbindingtableentry_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingtable.h File Reference",
"href":"cpp_ref/fbxbindingtable_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxbindingtable.h Source File",
"href":"cpp_ref/fbxbindingtable_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxbitset.h File Reference",
"href":"cpp_ref/fbxbitset_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxbitset.h Source File",
"href":"cpp_ref/fbxbitset_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxblendshapechannel.h File Reference",
"href":"cpp_ref/fbxblendshapechannel_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxblendshapechannel.h Source File",
"href":"cpp_ref/fbxblendshapechannel_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxblendshape.h File Reference",
"href":"cpp_ref/fbxblendshape_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxblendshape.h Source File",
"href":"cpp_ref/fbxblendshape_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcachedeffect.h File Reference",
"href":"cpp_ref/fbxcachedeffect_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcachedeffect.h Source File",
"href":"cpp_ref/fbxcachedeffect_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcache.h File Reference",
"href":"cpp_ref/fbxcache_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcache.h Source File",
"href":"cpp_ref/fbxcache_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcamerastereo.h File Reference",
"href":"cpp_ref/fbxcamerastereo_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcamerastereo.h Source File",
"href":"cpp_ref/fbxcamerastereo_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcameraswitcher.h File Reference",
"href":"cpp_ref/fbxcameraswitcher_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcameraswitcher.h Source File",
"href":"cpp_ref/fbxcameraswitcher_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcamera.h File Reference",
"href":"cpp_ref/fbxcamera_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcamera.h Source File",
"href":"cpp_ref/fbxcamera_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxcharacternodename.h File Reference",
"href":"cpp_ref/fbxcharacternodename_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxcharacternodename.h Source File",
"href":"cpp_ref/fbxcharacternodename_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxcharacterpose.h File Reference",
"href":"cpp_ref/fbxcharacterpose_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxcharacterpose.h Source File",
"href":"cpp_ref/fbxcharacterpose_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxcharacter.h File Reference",
"href":"cpp_ref/fbxcharacter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxcharacter.h Source File",
"href":"cpp_ref/fbxcharacter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxcharptrset.h File Reference",
"href":"cpp_ref/fbxcharptrset_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxcharptrset.h Source File",
"href":"cpp_ref/fbxcharptrset_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxclassid.h File Reference",
"href":"cpp_ref/fbxclassid_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxclassid.h Source File",
"href":"cpp_ref/fbxclassid_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/sync/fbxclock.h File Reference",
"href":"cpp_ref/fbxclock_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/sync/fbxclock.h Source File",
"href":"cpp_ref/fbxclock_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxclonemanager.h File Reference",
"href":"cpp_ref/fbxclonemanager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxclonemanager.h Source File",
"href":"cpp_ref/fbxclonemanager_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcluster.h File Reference",
"href":"cpp_ref/fbxcluster_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxcluster.h Source File",
"href":"cpp_ref/fbxcluster_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladaanimationelement.h File Reference",
"href":"cpp_ref/fbxcolladaanimationelement_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladaanimationelement.h Source File",
"href":"cpp_ref/fbxcolladaanimationelement_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladaelement.h File Reference",
"href":"cpp_ref/fbxcolladaelement_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladaelement.h Source File",
"href":"cpp_ref/fbxcolladaelement_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladaiostream.h File Reference",
"href":"cpp_ref/fbxcolladaiostream_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladaiostream.h Source File",
"href":"cpp_ref/fbxcolladaiostream_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladanamespace.h File Reference",
"href":"cpp_ref/fbxcolladanamespace_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladanamespace.h Source File",
"href":"cpp_ref/fbxcolladanamespace_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladatokens.h File Reference",
"href":"cpp_ref/fbxcolladatokens_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladatokens.h Source File",
"href":"cpp_ref/fbxcolladatokens_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladautils.h File Reference",
"href":"cpp_ref/fbxcolladautils_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxcolladautils.h Source File",
"href":"cpp_ref/fbxcolladautils_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxcollectionexclusive.h File Reference",
"href":"cpp_ref/fbxcollectionexclusive_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxcollectionexclusive.h Source File",
"href":"cpp_ref/fbxcollectionexclusive_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxcollection.h File Reference",
"href":"cpp_ref/fbxcollection_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxcollection.h Source File",
"href":"cpp_ref/fbxcollection_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxconnectionpoint.h File Reference",
"href":"cpp_ref/fbxconnectionpoint_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxconnectionpoint.h Source File",
"href":"cpp_ref/fbxconnectionpoint_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxconstantentryview.h File Reference",
"href":"cpp_ref/fbxconstantentryview_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxconstantentryview.h Source File",
"href":"cpp_ref/fbxconstantentryview_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintaim.h File Reference",
"href":"cpp_ref/fbxconstraintaim_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintaim.h Source File",
"href":"cpp_ref/fbxconstraintaim_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintcustom.h File Reference",
"href":"cpp_ref/fbxconstraintcustom_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintcustom.h Source File",
"href":"cpp_ref/fbxconstraintcustom_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintparent.h File Reference",
"href":"cpp_ref/fbxconstraintparent_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintparent.h Source File",
"href":"cpp_ref/fbxconstraintparent_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintposition.h File Reference",
"href":"cpp_ref/fbxconstraintposition_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintposition.h Source File",
"href":"cpp_ref/fbxconstraintposition_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintrotation.h File Reference",
"href":"cpp_ref/fbxconstraintrotation_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintrotation.h Source File",
"href":"cpp_ref/fbxconstraintrotation_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintscale.h File Reference",
"href":"cpp_ref/fbxconstraintscale_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintscale.h Source File",
"href":"cpp_ref/fbxconstraintscale_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintsinglechainik.h File Reference",
"href":"cpp_ref/fbxconstraintsinglechainik_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintsinglechainik.h Source File",
"href":"cpp_ref/fbxconstraintsinglechainik_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintutils.h File Reference",
"href":"cpp_ref/fbxconstraintutils_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraintutils.h Source File",
"href":"cpp_ref/fbxconstraintutils_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraint.h File Reference",
"href":"cpp_ref/fbxconstraint_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxconstraint.h Source File",
"href":"cpp_ref/fbxconstraint_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxcontainerallocators.h File Reference",
"href":"cpp_ref/fbxcontainerallocators_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxcontainerallocators.h Source File",
"href":"cpp_ref/fbxcontainerallocators_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxcontainertemplate.h File Reference",
"href":"cpp_ref/fbxcontainertemplate_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxcontainertemplate.h Source File",
"href":"cpp_ref/fbxcontainertemplate_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxcontainer.h File Reference",
"href":"cpp_ref/fbxcontainer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxcontainer.h Source File",
"href":"cpp_ref/fbxcontainer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxcontrolset.h File Reference",
"href":"cpp_ref/fbxcontrolset_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxcontrolset.h Source File",
"href":"cpp_ref/fbxcontrolset_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxdatatypes.h File Reference",
"href":"cpp_ref/fbxdatatypes_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxdatatypes.h Source File",
"href":"cpp_ref/fbxdatatypes_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxdebug.h File Reference",
"href":"cpp_ref/fbxdebug_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxdebug.h Source File",
"href":"cpp_ref/fbxdebug_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxdeformationsevaluator.h File Reference",
"href":"cpp_ref/fbxdeformationsevaluator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxdeformationsevaluator.h Source File",
"href":"cpp_ref/fbxdeformationsevaluator_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxdeformer.h File Reference",
"href":"cpp_ref/fbxdeformer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxdeformer.h Source File",
"href":"cpp_ref/fbxdeformer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxdisplaylayer.h File Reference",
"href":"cpp_ref/fbxdisplaylayer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxdisplaylayer.h Source File",
"href":"cpp_ref/fbxdisplaylayer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxdocumentinfo.h File Reference",
"href":"cpp_ref/fbxdocumentinfo_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxdocumentinfo.h Source File",
"href":"cpp_ref/fbxdocumentinfo_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxdocument.h File Reference",
"href":"cpp_ref/fbxdocument_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxdocument.h Source File",
"href":"cpp_ref/fbxdocument_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxdualquaternion.h File Reference",
"href":"cpp_ref/fbxdualquaternion_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxdualquaternion.h Source File",
"href":"cpp_ref/fbxdualquaternion_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxdynamicarray.h File Reference",
"href":"cpp_ref/fbxdynamicarray_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxdynamicarray.h Source File",
"href":"cpp_ref/fbxdynamicarray_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxembeddedfilesaccumulator.h File Reference",
"href":"cpp_ref/fbxembeddedfilesaccumulator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxembeddedfilesaccumulator.h Source File",
"href":"cpp_ref/fbxembeddedfilesaccumulator_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxemitter.h File Reference",
"href":"cpp_ref/fbxemitter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxemitter.h Source File",
"href":"cpp_ref/fbxemitter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxentryview.h File Reference",
"href":"cpp_ref/fbxentryview_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxentryview.h Source File",
"href":"cpp_ref/fbxentryview_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxenvironment.h File Reference",
"href":"cpp_ref/fbxenvironment_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxenvironment.h Source File",
"href":"cpp_ref/fbxenvironment_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxeventhandler.h File Reference",
"href":"cpp_ref/fbxeventhandler_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxeventhandler.h Source File",
"href":"cpp_ref/fbxeventhandler_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxevent.h File Reference",
"href":"cpp_ref/fbxevent_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxevent.h Source File",
"href":"cpp_ref/fbxevent_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxexporter.h File Reference",
"href":"cpp_ref/fbxexporter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxexporter.h Source File",
"href":"cpp_ref/fbxexporter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxexternaldocreflistener.h File Reference",
"href":"cpp_ref/fbxexternaldocreflistener_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxexternaldocreflistener.h Source File",
"href":"cpp_ref/fbxexternaldocreflistener_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxfiletexture.h File Reference",
"href":"cpp_ref/fbxfiletexture_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxfiletexture.h Source File",
"href":"cpp_ref/fbxfiletexture_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxfiletokens.h File Reference",
"href":"cpp_ref/fbxfiletokens_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxfiletokens.h Source File",
"href":"cpp_ref/fbxfiletokens_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxfile.h File Reference",
"href":"cpp_ref/fbxfile_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxfile.h Source File",
"href":"cpp_ref/fbxfile_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxfolder.h File Reference",
"href":"cpp_ref/fbxfolder_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxfolder.h Source File",
"href":"cpp_ref/fbxfolder_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxgenericnode.h File Reference",
"href":"cpp_ref/fbxgenericnode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxgenericnode.h Source File",
"href":"cpp_ref/fbxgenericnode_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxgeometrybase.h File Reference",
"href":"cpp_ref/fbxgeometrybase_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxgeometrybase.h Source File",
"href":"cpp_ref/fbxgeometrybase_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxgeometryconverter.h File Reference",
"href":"cpp_ref/fbxgeometryconverter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxgeometryconverter.h Source File",
"href":"cpp_ref/fbxgeometryconverter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxgeometryweightedmap.h File Reference",
"href":"cpp_ref/fbxgeometryweightedmap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxgeometryweightedmap.h Source File",
"href":"cpp_ref/fbxgeometryweightedmap_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxgeometry.h File Reference",
"href":"cpp_ref/fbxgeometry_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxgeometry.h Source File",
"href":"cpp_ref/fbxgeometry_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxglobalcamerasettings.h File Reference",
"href":"cpp_ref/fbxglobalcamerasettings_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxglobalcamerasettings.h Source File",
"href":"cpp_ref/fbxglobalcamerasettings_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxgloballightsettings.h File Reference",
"href":"cpp_ref/fbxgloballightsettings_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxgloballightsettings.h Source File",
"href":"cpp_ref/fbxgloballightsettings_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxglobalsettings.h File Reference",
"href":"cpp_ref/fbxglobalsettings_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxglobalsettings.h Source File",
"href":"cpp_ref/fbxglobalsettings_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxgobo.h File Reference",
"href":"cpp_ref/fbxgobo_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxgobo.h Source File",
"href":"cpp_ref/fbxgobo_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxgroupname.h File Reference",
"href":"cpp_ref/fbxgroupname_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxgroupname.h Source File",
"href":"cpp_ref/fbxgroupname_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxhashmap.h File Reference",
"href":"cpp_ref/fbxhashmap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxhashmap.h Source File",
"href":"cpp_ref/fbxhashmap_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxhik2fbxcharacter.h File Reference",
"href":"cpp_ref/fbxhik2fbxcharacter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/constraint/fbxhik2fbxcharacter.h Source File",
"href":"cpp_ref/fbxhik2fbxcharacter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbximplementationfilter.h File Reference",
"href":"cpp_ref/fbximplementationfilter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbximplementationfilter.h Source File",
"href":"cpp_ref/fbximplementationfilter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbximplementationutils.h File Reference",
"href":"cpp_ref/fbximplementationutils_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbximplementationutils.h Source File",
"href":"cpp_ref/fbximplementationutils_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbximplementation.h File Reference",
"href":"cpp_ref/fbximplementation_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbximplementation.h Source File",
"href":"cpp_ref/fbximplementation_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbximporter.h File Reference",
"href":"cpp_ref/fbximporter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbximporter.h Source File",
"href":"cpp_ref/fbximporter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxintrusivelist.h File Reference",
"href":"cpp_ref/fbxintrusivelist_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxintrusivelist.h Source File",
"href":"cpp_ref/fbxintrusivelist_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxiobase.h File Reference",
"href":"cpp_ref/fbxiobase_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxiobase.h Source File",
"href":"cpp_ref/fbxiobase_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxiopluginregistry.h File Reference",
"href":"cpp_ref/fbxiopluginregistry_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxiopluginregistry.h Source File",
"href":"cpp_ref/fbxiopluginregistry_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxiosettingspath.h File Reference",
"href":"cpp_ref/fbxiosettingspath_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxiosettingspath.h Source File",
"href":"cpp_ref/fbxiosettingspath_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxiosettings.h File Reference",
"href":"cpp_ref/fbxiosettings_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxiosettings.h Source File",
"href":"cpp_ref/fbxiosettings_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxio.h File Reference",
"href":"cpp_ref/fbxio_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxio.h Source File",
"href":"cpp_ref/fbxio_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlayercontainer.h File Reference",
"href":"cpp_ref/fbxlayercontainer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlayercontainer.h Source File",
"href":"cpp_ref/fbxlayercontainer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxlayeredtexture.h File Reference",
"href":"cpp_ref/fbxlayeredtexture_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxlayeredtexture.h Source File",
"href":"cpp_ref/fbxlayeredtexture_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxlayerentryview.h File Reference",
"href":"cpp_ref/fbxlayerentryview_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxlayerentryview.h Source File",
"href":"cpp_ref/fbxlayerentryview_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlayer.h File Reference",
"href":"cpp_ref/fbxlayer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlayer.h Source File",
"href":"cpp_ref/fbxlayer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxlibrary.h File Reference",
"href":"cpp_ref/fbxlibrary_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxlibrary.h Source File",
"href":"cpp_ref/fbxlibrary_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlight.h File Reference",
"href":"cpp_ref/fbxlight_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlight.h Source File",
"href":"cpp_ref/fbxlight_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlimitsutilities.h File Reference",
"href":"cpp_ref/fbxlimitsutilities_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlimitsutilities.h Source File",
"href":"cpp_ref/fbxlimitsutilities_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxline.h File Reference",
"href":"cpp_ref/fbxline_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxline.h Source File",
"href":"cpp_ref/fbxline_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxlistener.h File Reference",
"href":"cpp_ref/fbxlistener_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxlistener.h Source File",
"href":"cpp_ref/fbxlistener_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxloadingstrategy.h File Reference",
"href":"cpp_ref/fbxloadingstrategy_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxloadingstrategy.h Source File",
"href":"cpp_ref/fbxloadingstrategy_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlodgroup.h File Reference",
"href":"cpp_ref/fbxlodgroup_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxlodgroup.h Source File",
"href":"cpp_ref/fbxlodgroup_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxmanager.h File Reference",
"href":"cpp_ref/fbxmanager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxmanager.h Source File",
"href":"cpp_ref/fbxmanager_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxmanipulators.h File Reference",
"href":"cpp_ref/fbxmanipulators_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxmanipulators.h Source File",
"href":"cpp_ref/fbxmanipulators_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxmap.h File Reference",
"href":"cpp_ref/fbxmap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxmap.h Source File",
"href":"cpp_ref/fbxmap_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxmarker.h File Reference",
"href":"cpp_ref/fbxmarker_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxmarker.h Source File",
"href":"cpp_ref/fbxmarker_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxmaterialconverter.h File Reference",
"href":"cpp_ref/fbxmaterialconverter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxmaterialconverter.h Source File",
"href":"cpp_ref/fbxmaterialconverter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxmath.h File Reference",
"href":"cpp_ref/fbxmath_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxmath.h Source File",
"href":"cpp_ref/fbxmath_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxmatrix.h File Reference",
"href":"cpp_ref/fbxmatrix_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxmatrix.h Source File",
"href":"cpp_ref/fbxmatrix_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxmemorypool.h File Reference",
"href":"cpp_ref/fbxmemorypool_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxmemorypool.h Source File",
"href":"cpp_ref/fbxmemorypool_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxmesh.h File Reference",
"href":"cpp_ref/fbxmesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxmesh.h Source File",
"href":"cpp_ref/fbxmesh_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxmodule.h File Reference",
"href":"cpp_ref/fbxmodule_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxmodule.h Source File",
"href":"cpp_ref/fbxmodule_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxnamehandler.h File Reference",
"href":"cpp_ref/fbxnamehandler_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxnamehandler.h Source File",
"href":"cpp_ref/fbxnamehandler_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxnew.h File Reference",
"href":"cpp_ref/fbxnew_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxnew.h Source File",
"href":"cpp_ref/fbxnew_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnodeattribute.h File Reference",
"href":"cpp_ref/fbxnodeattribute_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnodeattribute.h Source File",
"href":"cpp_ref/fbxnodeattribute_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnode.h File Reference",
"href":"cpp_ref/fbxnode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnode.h Source File",
"href":"cpp_ref/fbxnode_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnull.h File Reference",
"href":"cpp_ref/fbxnull_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnull.h Source File",
"href":"cpp_ref/fbxnull_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnurbscurve.h File Reference",
"href":"cpp_ref/fbxnurbscurve_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnurbscurve.h Source File",
"href":"cpp_ref/fbxnurbscurve_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnurbssurface.h File Reference",
"href":"cpp_ref/fbxnurbssurface_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnurbssurface.h Source File",
"href":"cpp_ref/fbxnurbssurface_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnurbs.h File Reference",
"href":"cpp_ref/fbxnurbs_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxnurbs.h Source File",
"href":"cpp_ref/fbxnurbs_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxobjectfilter.h File Reference",
"href":"cpp_ref/fbxobjectfilter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxobjectfilter.h Source File",
"href":"cpp_ref/fbxobjectfilter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxobjectmetadata.h File Reference",
"href":"cpp_ref/fbxobjectmetadata_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxobjectmetadata.h Source File",
"href":"cpp_ref/fbxobjectmetadata_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxobjectscontainer.h File Reference",
"href":"cpp_ref/fbxobjectscontainer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxobjectscontainer.h Source File",
"href":"cpp_ref/fbxobjectscontainer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxobject.h File Reference",
"href":"cpp_ref/fbxobject_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxobject.h Source File",
"href":"cpp_ref/fbxobject_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxoperatorentryview.h File Reference",
"href":"cpp_ref/fbxoperatorentryview_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxoperatorentryview.h Source File",
"href":"cpp_ref/fbxoperatorentryview_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxopticalreference.h File Reference",
"href":"cpp_ref/fbxopticalreference_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxopticalreference.h Source File",
"href":"cpp_ref/fbxopticalreference_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxpair.h File Reference",
"href":"cpp_ref/fbxpair_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxpair.h Source File",
"href":"cpp_ref/fbxpair_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxpatch.h File Reference",
"href":"cpp_ref/fbxpatch_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxpatch.h Source File",
"href":"cpp_ref/fbxpatch_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxperipheral.h File Reference",
"href":"cpp_ref/fbxperipheral_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxperipheral.h Source File",
"href":"cpp_ref/fbxperipheral_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxplugincontainer.h File Reference",
"href":"cpp_ref/fbxplugincontainer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxplugincontainer.h Source File",
"href":"cpp_ref/fbxplugincontainer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxplugin.h File Reference",
"href":"cpp_ref/fbxplugin_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxplugin.h Source File",
"href":"cpp_ref/fbxplugin_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxpose.h File Reference",
"href":"cpp_ref/fbxpose_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxpose.h Source File",
"href":"cpp_ref/fbxpose_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxproceduralgeometry.h File Reference",
"href":"cpp_ref/fbxproceduralgeometry_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxproceduralgeometry.h Source File",
"href":"cpp_ref/fbxproceduralgeometry_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxproceduraltexture.h File Reference",
"href":"cpp_ref/fbxproceduraltexture_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxproceduraltexture.h Source File",
"href":"cpp_ref/fbxproceduraltexture_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxprocessorshaderdependency.h File Reference",
"href":"cpp_ref/fbxprocessorshaderdependency_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxprocessorshaderdependency.h Source File",
"href":"cpp_ref/fbxprocessorshaderdependency_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxprocessorxrefuserlib.h File Reference",
"href":"cpp_ref/fbxprocessorxrefuserlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxprocessorxrefuserlib.h Source File",
"href":"cpp_ref/fbxprocessorxrefuserlib_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxprocessorxref.h File Reference",
"href":"cpp_ref/fbxprocessorxref_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxprocessorxref.h Source File",
"href":"cpp_ref/fbxprocessorxref_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxprocessor.h File Reference",
"href":"cpp_ref/fbxprocessor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxprocessor.h Source File",
"href":"cpp_ref/fbxprocessor_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxprogress.h File Reference",
"href":"cpp_ref/fbxprogress_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxprogress.h Source File",
"href":"cpp_ref/fbxprogress_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxpropertydef.h File Reference",
"href":"cpp_ref/fbxpropertydef_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxpropertydef.h Source File",
"href":"cpp_ref/fbxpropertydef_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxpropertyentryview.h File Reference",
"href":"cpp_ref/fbxpropertyentryview_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxpropertyentryview.h Source File",
"href":"cpp_ref/fbxpropertyentryview_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxpropertyhandle.h File Reference",
"href":"cpp_ref/fbxpropertyhandle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxpropertyhandle.h Source File",
"href":"cpp_ref/fbxpropertyhandle_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxpropertypage.h File Reference",
"href":"cpp_ref/fbxpropertypage_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxpropertypage.h Source File",
"href":"cpp_ref/fbxpropertypage_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxpropertytypes.h File Reference",
"href":"cpp_ref/fbxpropertytypes_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxpropertytypes.h Source File",
"href":"cpp_ref/fbxpropertytypes_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxproperty.h File Reference",
"href":"cpp_ref/fbxproperty_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxproperty.h Source File",
"href":"cpp_ref/fbxproperty_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxquaternion.h File Reference",
"href":"cpp_ref/fbxquaternion_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxquaternion.h Source File",
"href":"cpp_ref/fbxquaternion_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxqueryevent.h File Reference",
"href":"cpp_ref/fbxqueryevent_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxqueryevent.h Source File",
"href":"cpp_ref/fbxqueryevent_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxquery.h File Reference",
"href":"cpp_ref/fbxquery_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxquery.h Source File",
"href":"cpp_ref/fbxquery_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxreadercollada14.h File Reference",
"href":"cpp_ref/fbxreadercollada14_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxreadercollada14.h Source File",
"href":"cpp_ref/fbxreadercollada14_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxreaderfbx5.h File Reference",
"href":"cpp_ref/fbxreaderfbx5_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxreaderfbx5.h Source File",
"href":"cpp_ref/fbxreaderfbx5_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxreaderfbx6.h File Reference",
"href":"cpp_ref/fbxreaderfbx6_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxreaderfbx6.h Source File",
"href":"cpp_ref/fbxreaderfbx6_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxreaderfbx7.h File Reference",
"href":"cpp_ref/fbxreaderfbx7_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxreaderfbx7.h Source File",
"href":"cpp_ref/fbxreaderfbx7_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxreader.h File Reference",
"href":"cpp_ref/fbxreader_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxreader.h Source File",
"href":"cpp_ref/fbxreader_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxredblacktree.h File Reference",
"href":"cpp_ref/fbxredblacktree_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxredblacktree.h Source File",
"href":"cpp_ref/fbxredblacktree_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxreference.h File Reference",
"href":"cpp_ref/fbxreference_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxreference.h Source File",
"href":"cpp_ref/fbxreference_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategybase.h File Reference",
"href":"cpp_ref/fbxrenamingstrategybase_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategybase.h Source File",
"href":"cpp_ref/fbxrenamingstrategybase_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategyfbx5.h File Reference",
"href":"cpp_ref/fbxrenamingstrategyfbx5_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategyfbx5.h Source File",
"href":"cpp_ref/fbxrenamingstrategyfbx5_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategyfbx6.h File Reference",
"href":"cpp_ref/fbxrenamingstrategyfbx6_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategyfbx6.h Source File",
"href":"cpp_ref/fbxrenamingstrategyfbx6_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategyfbx7.h File Reference",
"href":"cpp_ref/fbxrenamingstrategyfbx7_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategyfbx7.h Source File",
"href":"cpp_ref/fbxrenamingstrategyfbx7_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategyutilities.h File Reference",
"href":"cpp_ref/fbxrenamingstrategyutilities_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategyutilities.h Source File",
"href":"cpp_ref/fbxrenamingstrategyutilities_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategy.h File Reference",
"href":"cpp_ref/fbxrenamingstrategy_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrenamingstrategy.h Source File",
"href":"cpp_ref/fbxrenamingstrategy_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrootnodeutility.h File Reference",
"href":"cpp_ref/fbxrootnodeutility_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxrootnodeutility.h Source File",
"href":"cpp_ref/fbxrootnodeutility_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxscene.h File Reference",
"href":"cpp_ref/fbxscene_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxscene.h Source File",
"href":"cpp_ref/fbxscene_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxscopedloadingdirectory.h File Reference",
"href":"cpp_ref/fbxscopedloadingdirectory_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxscopedloadingdirectory.h Source File",
"href":"cpp_ref/fbxscopedloadingdirectory_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxscopedloadingfilename.h File Reference",
"href":"cpp_ref/fbxscopedloadingfilename_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxscopedloadingfilename.h Source File",
"href":"cpp_ref/fbxscopedloadingfilename_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk.h File Reference",
"href":"cpp_ref/fbxsdk_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk.h Source File",
"href":"cpp_ref/fbxsdk_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fbxsdk_def.h File Reference",
"href":"cpp_ref/fbxsdk__def_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fbxsdk_def.h Source File",
"href":"cpp_ref/fbxsdk__def_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fbxsdk_nsbegin.h File Reference",
"href":"cpp_ref/fbxsdk__nsbegin_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fbxsdk_nsbegin.h Source File",
"href":"cpp_ref/fbxsdk__nsbegin_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fbxsdk_nsend.h File Reference",
"href":"cpp_ref/fbxsdk__nsend_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fbxsdk_nsend.h Source File",
"href":"cpp_ref/fbxsdk__nsend_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fbxsdk_version.h File Reference",
"href":"cpp_ref/fbxsdk__version_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fbxsdk_version.h Source File",
"href":"cpp_ref/fbxsdk__version_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxselectionnode.h File Reference",
"href":"cpp_ref/fbxselectionnode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxselectionnode.h Source File",
"href":"cpp_ref/fbxselectionnode_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxselectionset.h File Reference",
"href":"cpp_ref/fbxselectionset_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxselectionset.h Source File",
"href":"cpp_ref/fbxselectionset_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxsemanticentryview.h File Reference",
"href":"cpp_ref/fbxsemanticentryview_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxsemanticentryview.h Source File",
"href":"cpp_ref/fbxsemanticentryview_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxset.h File Reference",
"href":"cpp_ref/fbxset_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxset.h Source File",
"href":"cpp_ref/fbxset_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxshadingconventions.h File Reference",
"href":"cpp_ref/fbxshadingconventions_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxshadingconventions.h Source File",
"href":"cpp_ref/fbxshadingconventions_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxshape.h File Reference",
"href":"cpp_ref/fbxshape_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxshape.h Source File",
"href":"cpp_ref/fbxshape_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxskeleton.h File Reference",
"href":"cpp_ref/fbxskeleton_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxskeleton.h Source File",
"href":"cpp_ref/fbxskeleton_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxskin.h File Reference",
"href":"cpp_ref/fbxskin_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxskin.h Source File",
"href":"cpp_ref/fbxskin_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxstatisticsfbx.h File Reference",
"href":"cpp_ref/fbxstatisticsfbx_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxstatisticsfbx.h Source File",
"href":"cpp_ref/fbxstatisticsfbx_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxstatistics.h File Reference",
"href":"cpp_ref/fbxstatistics_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxstatistics.h Source File",
"href":"cpp_ref/fbxstatistics_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxstatus.h File Reference",
"href":"cpp_ref/fbxstatus_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxstatus.h Source File",
"href":"cpp_ref/fbxstatus_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxstdcompliant.h File Reference",
"href":"cpp_ref/fbxstdcompliant_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxstdcompliant.h Source File",
"href":"cpp_ref/fbxstdcompliant_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxstream.h File Reference",
"href":"cpp_ref/fbxstream_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxstream.h Source File",
"href":"cpp_ref/fbxstream_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxstringlist.h File Reference",
"href":"cpp_ref/fbxstringlist_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxstringlist.h Source File",
"href":"cpp_ref/fbxstringlist_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxstring.h File Reference",
"href":"cpp_ref/fbxstring_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxstring.h Source File",
"href":"cpp_ref/fbxstring_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxsubdeformer.h File Reference",
"href":"cpp_ref/fbxsubdeformer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxsubdeformer.h Source File",
"href":"cpp_ref/fbxsubdeformer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxsubdiv.h File Reference",
"href":"cpp_ref/fbxsubdiv_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxsubdiv.h Source File",
"href":"cpp_ref/fbxsubdiv_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxsurfacelambert.h File Reference",
"href":"cpp_ref/fbxsurfacelambert_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxsurfacelambert.h Source File",
"href":"cpp_ref/fbxsurfacelambert_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxsurfacematerial.h File Reference",
"href":"cpp_ref/fbxsurfacematerial_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxsurfacematerial.h Source File",
"href":"cpp_ref/fbxsurfacematerial_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxsurfacephong.h File Reference",
"href":"cpp_ref/fbxsurfacephong_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxsurfacephong.h Source File",
"href":"cpp_ref/fbxsurfacephong_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxsymbol.h File Reference",
"href":"cpp_ref/fbxsymbol_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxsymbol.h Source File",
"href":"cpp_ref/fbxsymbol_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/sync/fbxsync.h File Reference",
"href":"cpp_ref/fbxsync_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/sync/fbxsync.h Source File",
"href":"cpp_ref/fbxsync_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxsystemunit.h File Reference",
"href":"cpp_ref/fbxsystemunit_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxsystemunit.h Source File",
"href":"cpp_ref/fbxsystemunit_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxtakeinfo.h File Reference",
"href":"cpp_ref/fbxtakeinfo_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxtakeinfo.h Source File",
"href":"cpp_ref/fbxtakeinfo_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxtexture.h File Reference",
"href":"cpp_ref/fbxtexture_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/shading/fbxtexture.h Source File",
"href":"cpp_ref/fbxtexture_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/sync/fbxthread.h File Reference",
"href":"cpp_ref/fbxthread_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/sync/fbxthread.h Source File",
"href":"cpp_ref/fbxthread_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxthumbnail.h File Reference",
"href":"cpp_ref/fbxthumbnail_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxthumbnail.h Source File",
"href":"cpp_ref/fbxthumbnail_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxtimecode.h File Reference",
"href":"cpp_ref/fbxtimecode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxtimecode.h Source File",
"href":"cpp_ref/fbxtimecode_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxtime.h File Reference",
"href":"cpp_ref/fbxtime_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxtime.h Source File",
"href":"cpp_ref/fbxtime_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxtransforms.h File Reference",
"href":"cpp_ref/fbxtransforms_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxtransforms.h Source File",
"href":"cpp_ref/fbxtransforms_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxtrimnurbssurface.h File Reference",
"href":"cpp_ref/fbxtrimnurbssurface_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxtrimnurbssurface.h Source File",
"href":"cpp_ref/fbxtrimnurbssurface_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxtypes.h File Reference",
"href":"cpp_ref/fbxtypes_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/arch/fbxtypes.h Source File",
"href":"cpp_ref/fbxtypes_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxusernotification.h File Reference",
"href":"cpp_ref/fbxusernotification_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/utils/fbxusernotification.h Source File",
"href":"cpp_ref/fbxusernotification_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxutils.h File Reference",
"href":"cpp_ref/fbxutils_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/base/fbxutils.h Source File",
"href":"cpp_ref/fbxutils_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxvector2.h File Reference",
"href":"cpp_ref/fbxvector2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxvector2.h Source File",
"href":"cpp_ref/fbxvector2_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxvector4.h File Reference",
"href":"cpp_ref/fbxvector4_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/math/fbxvector4.h Source File",
"href":"cpp_ref/fbxvector4_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxvertexcachedeformer.h File Reference",
"href":"cpp_ref/fbxvertexcachedeformer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxvertexcachedeformer.h Source File",
"href":"cpp_ref/fbxvertexcachedeformer_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxvideo.h File Reference",
"href":"cpp_ref/fbxvideo_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/fbxvideo.h Source File",
"href":"cpp_ref/fbxvideo_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxweightedmapping.h File Reference",
"href":"cpp_ref/fbxweightedmapping_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/scene/geometry/fbxweightedmapping.h Source File",
"href":"cpp_ref/fbxweightedmapping_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxwritercollada14.h File Reference",
"href":"cpp_ref/fbxwritercollada14_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/collada/fbxwritercollada14.h Source File",
"href":"cpp_ref/fbxwritercollada14_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxwriterfbx5.h File Reference",
"href":"cpp_ref/fbxwriterfbx5_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxwriterfbx5.h Source File",
"href":"cpp_ref/fbxwriterfbx5_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxwriterfbx6.h File Reference",
"href":"cpp_ref/fbxwriterfbx6_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxwriterfbx6.h Source File",
"href":"cpp_ref/fbxwriterfbx6_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxwriterfbx7.h File Reference",
"href":"cpp_ref/fbxwriterfbx7_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbx/fbxwriterfbx7.h Source File",
"href":"cpp_ref/fbxwriterfbx7_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxwriter.h File Reference",
"href":"cpp_ref/fbxwriter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/fileio/fbxwriter.h Source File",
"href":"cpp_ref/fbxwriter_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxxref.h File Reference",
"href":"cpp_ref/fbxxref_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fbxsdk/core/fbxxref.h Source File",
"href":"cpp_ref/fbxxref_8h_source.html",
"description":"",
"ancestors":[]},
{"title":"C++: FBX SDK Reference",
"href":"cpp_ref/index.html",
"description":"",
"ancestors":[]},
{"title":"C++: ColladaLayerTraits Struct Reference",
"href":"cpp_ref/struct_collada_layer_traits.html",
"description":"",
"ancestors":[]},
{"title":"C++: ElementContentAccessor Struct Reference",
"href":"cpp_ref/struct_element_content_accessor.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxAnimCurveTangentInfo Struct Reference",
"href":"cpp_ref/struct_fbx_anim_curve_tangent_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxCloneManager::CloneSetElement Struct Reference",
"href":"cpp_ref/struct_fbx_clone_manager_1_1_clone_set_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxColladaNamespace Struct Reference",
"href":"cpp_ref/struct_fbx_collada_namespace.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEmbeddedFilesAccumulator::EmbeddedFileInfo Struct Reference",
"href":"cpp_ref/struct_fbx_embedded_files_accumulator_1_1_embedded_file_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEmbeddedFilesAccumulator::PropertyUrlIndex Struct Reference",
"href":"cpp_ref/struct_fbx_embedded_files_accumulator_1_1_property_url_index.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxEmbeddedFilesAccumulator::PropertyUrlIndexCompare Struct Reference",
"href":"cpp_ref/struct_fbx_embedded_files_accumulator_1_1_property_url_index_compare.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxExternalDocumentInfo Struct Reference",
"href":"cpp_ref/struct_fbx_external_document_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGlobalLightSettings::ShadowPlane Struct Reference",
"href":"cpp_ref/struct_fbx_global_light_settings_1_1_shadow_plane.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxGlobalSettings::TimeMarker Struct Reference",
"href":"cpp_ref/struct_fbx_global_settings_1_1_time_marker.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIncompatibleWithArray< T > Struct Template Reference",
"href":"cpp_ref/struct_fbx_incompatible_with_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxIO::FbxAutoResetXRefManager Struct Reference",
"href":"cpp_ref/struct_fbx_i_o_1_1_fbx_auto_reset_x_ref_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLayerElementArrayReadLock< T > Struct Template Reference",
"href":"cpp_ref/struct_fbx_layer_element_array_read_lock.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxLessCompare< Type > Struct Template Reference",
"href":"cpp_ref/struct_fbx_less_compare.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh::ComponentMap Struct Reference",
"href":"cpp_ref/struct_fbx_mesh_1_1_component_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh::EdgeLookupDef Struct Reference",
"href":"cpp_ref/struct_fbx_mesh_1_1_edge_lookup_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh::PolygonDef Struct Reference",
"href":"cpp_ref/struct_fbx_mesh_1_1_polygon_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh::PolygonIndexDef Struct Reference",
"href":"cpp_ref/struct_fbx_mesh_1_1_polygon_index_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh::SplitEdgeData Struct Reference",
"href":"cpp_ref/struct_fbx_mesh_1_1_split_edge_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxMesh::V2PVMap Struct Reference",
"href":"cpp_ref/struct_fbx_mesh_1_1_v2_p_v_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPluginData Struct Reference",
"href":"cpp_ref/struct_fbx_plugin_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPluginDef Struct Reference",
"href":"cpp_ref/struct_fbx_plugin_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxPoseInfo Struct Reference",
"href":"cpp_ref/struct_fbx_pose_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProcessorXRefCopy::AutoRevertPropertyChanges Struct Reference",
"href":"cpp_ref/struct_fbx_processor_x_ref_copy_1_1_auto_revert_property_changes.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxProcessorXRefCopy::PropertyUpdate Struct Reference",
"href":"cpp_ref/struct_fbx_processor_x_ref_copy_1_1_property_update.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSimpleType< T > Struct Template Reference",
"href":"cpp_ref/struct_fbx_simple_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSimpleType< const T > Struct Template Reference",
"href":"cpp_ref/struct_fbx_simple_type_3_01const_01_t_01_4.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSimpleType< T[n]> Struct Template Reference",
"href":"cpp_ref/struct_fbx_simple_type_3_01_t[n]_4.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSimpleType< T * > Struct Template Reference",
"href":"cpp_ref/struct_fbx_simple_type_3_01_t_01_5_01_4.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSyncStack::Item Struct Reference",
"href":"cpp_ref/struct_fbx_sync_stack_1_1_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxSystemUnit::ConversionOptions Struct Reference",
"href":"cpp_ref/struct_fbx_system_unit_1_1_conversion_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxTakeLayerInfo Struct Reference",
"href":"cpp_ref/struct_fbx_take_layer_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FbxWeightedMapping::Element Struct Reference",
"href":"cpp_ref/struct_fbx_weighted_mapping_1_1_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: SourceElementContentAccessor< TYPE > Struct Template Reference",
"href":"cpp_ref/struct_source_element_content_accessor.html",
"description":"",
"ancestors":[]},
{"title":"C++: Animation/main.cxx",
"href":"cpp_ref/_animation_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Camera/main.cxx",
"href":"cpp_ref/_camera_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Common/AnimationUtility.cxx",
"href":"cpp_ref/_common_2_animation_utility_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Common/AnimationUtility.h",
"href":"cpp_ref/_common_2_animation_utility_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Common/Common.cxx",
"href":"cpp_ref/_common_2_common_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Common/Common.h",
"href":"cpp_ref/_common_2_common_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Common/GeometryUtility.cxx",
"href":"cpp_ref/_common_2_geometry_utility_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Common/GeometryUtility.h",
"href":"cpp_ref/_common_2_geometry_utility_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConvertScene/main.cxx",
"href":"cpp_ref/_convert_scene_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportDocument/main.cxx",
"href":"cpp_ref/_export_document_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportScene01/main.cxx",
"href":"cpp_ref/_export_scene01_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportScene01/Thumbnail.h",
"href":"cpp_ref/_export_scene01_2_thumbnail_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportScene02/main.cxx",
"href":"cpp_ref/_export_scene02_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportScene03/main.cxx",
"href":"cpp_ref/_export_scene03_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportScene03/MyKFbxMesh.cxx",
"href":"cpp_ref/_export_scene03_2_my_k_fbx_mesh_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportScene03/MyKFbxMesh.h",
"href":"cpp_ref/_export_scene03_2_my_k_fbx_mesh_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportScene04/main.cxx",
"href":"cpp_ref/_export_scene04_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportScene05/main.cxx",
"href":"cpp_ref/_export_scene05_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExportShader/main.cxx",
"href":"cpp_ref/_export_shader_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/main.cxx",
"href":"cpp_ref/_import_scene_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayAnimation.cxx",
"href":"cpp_ref/_import_scene_2_display_animation_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayAnimation.h",
"href":"cpp_ref/_import_scene_2_display_animation_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayCamera.cxx",
"href":"cpp_ref/_import_scene_2_display_camera_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayCamera.h",
"href":"cpp_ref/_import_scene_2_display_camera_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayCommon.cxx",
"href":"cpp_ref/_import_scene_2_display_common_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayCommon.h",
"href":"cpp_ref/_import_scene_2_display_common_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayGenericInfo.cxx",
"href":"cpp_ref/_import_scene_2_display_generic_info_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayGenericInfo.h",
"href":"cpp_ref/_import_scene_2_display_generic_info_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayGlobalSettings.cxx",
"href":"cpp_ref/_import_scene_2_display_global_settings_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayGlobalSettings.h",
"href":"cpp_ref/_import_scene_2_display_global_settings_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayHierarchy.cxx",
"href":"cpp_ref/_import_scene_2_display_hierarchy_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayHierarchy.h",
"href":"cpp_ref/_import_scene_2_display_hierarchy_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayLight.cxx",
"href":"cpp_ref/_import_scene_2_display_light_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayLight.h",
"href":"cpp_ref/_import_scene_2_display_light_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayLink.cxx",
"href":"cpp_ref/_import_scene_2_display_link_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayLink.h",
"href":"cpp_ref/_import_scene_2_display_link_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayLodGroup.cxx",
"href":"cpp_ref/_import_scene_2_display_lod_group_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayLodGroup.h",
"href":"cpp_ref/_import_scene_2_display_lod_group_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayMarker.cxx",
"href":"cpp_ref/_import_scene_2_display_marker_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayMarker.h",
"href":"cpp_ref/_import_scene_2_display_marker_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayMaterial.cxx",
"href":"cpp_ref/_import_scene_2_display_material_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayMaterial.h",
"href":"cpp_ref/_import_scene_2_display_material_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayMesh.cxx",
"href":"cpp_ref/_import_scene_2_display_mesh_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayMesh.h",
"href":"cpp_ref/_import_scene_2_display_mesh_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayNurb.cxx",
"href":"cpp_ref/_import_scene_2_display_nurb_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayNurb.h",
"href":"cpp_ref/_import_scene_2_display_nurb_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayPatch.cxx",
"href":"cpp_ref/_import_scene_2_display_patch_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayPatch.h",
"href":"cpp_ref/_import_scene_2_display_patch_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayPivotsAndLimits.cxx",
"href":"cpp_ref/_import_scene_2_display_pivots_and_limits_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayPivotsAndLimits.h",
"href":"cpp_ref/_import_scene_2_display_pivots_and_limits_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayPose.cxx",
"href":"cpp_ref/_import_scene_2_display_pose_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayPose.h",
"href":"cpp_ref/_import_scene_2_display_pose_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayShape.cxx",
"href":"cpp_ref/_import_scene_2_display_shape_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayShape.h",
"href":"cpp_ref/_import_scene_2_display_shape_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplaySkeleton.cxx",
"href":"cpp_ref/_import_scene_2_display_skeleton_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplaySkeleton.h",
"href":"cpp_ref/_import_scene_2_display_skeleton_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayTexture.cxx",
"href":"cpp_ref/_import_scene_2_display_texture_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayTexture.h",
"href":"cpp_ref/_import_scene_2_display_texture_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayUserProperties.cxx",
"href":"cpp_ref/_import_scene_2_display_user_properties_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportScene/DisplayUserProperties.h",
"href":"cpp_ref/_import_scene_2_display_user_properties_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Instances/main.cxx",
"href":"cpp_ref/_instances_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Layers/main.cxx",
"href":"cpp_ref/_layers_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: MyOwnWriterReader/MyOwnReader.cxx",
"href":"cpp_ref/_my_own_writer_reader_2_my_own_reader_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: MyOwnWriterReader/MyOwnReader.h",
"href":"cpp_ref/_my_own_writer_reader_2_my_own_reader_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: MyOwnWriterReader/MyOwnWriter.cxx",
"href":"cpp_ref/_my_own_writer_reader_2_my_own_writer_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: MyOwnWriterReader/MyOwnWriter.h",
"href":"cpp_ref/_my_own_writer_reader_2_my_own_writer_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: MyOwnWriterReader/MyOwnWriterReader.cxx",
"href":"cpp_ref/_my_own_writer_reader_2_my_own_writer_reader_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: MyOwnWriterReader/MyOwnWriterReader.h",
"href":"cpp_ref/_my_own_writer_reader_2_my_own_writer_reader_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Normals/main.cxx",
"href":"cpp_ref/_normals_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Pivot/main.cxx",
"href":"cpp_ref/_pivot_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ProceduralTexture/main.cxx",
"href":"cpp_ref/_procedural_texture_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: StereoCamera/main.cxx",
"href":"cpp_ref/_stereo_camera_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: SwitchBinding/main.cxx",
"href":"cpp_ref/_switch_binding_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Transformations/main.cxx",
"href":"cpp_ref/_transformations_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Transformations/DisplayCommon.cxx",
"href":"cpp_ref/_transformations_2_display_common_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: Transformations/DisplayCommon.h",
"href":"cpp_ref/_transformations_2_display_common_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UserProperties/main.cxx",
"href":"cpp_ref/_user_properties_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/Common/ImportExport.cxx",
"href":"cpp_ref/_u_i__examples_2_common_2_import_export_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/Common/ImportExport.h",
"href":"cpp_ref/_u_i__examples_2_common_2_import_export_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/CubeCreator/resource.h",
"href":"cpp_ref/_u_i__examples_2_cube_creator_2resource_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/CubeCreator/stdafx.h",
"href":"cpp_ref/_u_i__examples_2_cube_creator_2stdafx_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/CubeCreator/SDK_Utility.cxx",
"href":"cpp_ref/_u_i__examples_2_cube_creator_2_s_d_k__utility_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/CubeCreator/SDK_Utility.h",
"href":"cpp_ref/_u_i__examples_2_cube_creator_2_s_d_k__utility_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/CubeCreator/UI.cxx",
"href":"cpp_ref/_u_i__examples_2_cube_creator_2_u_i_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/CubeCreator/UI.h",
"href":"cpp_ref/_u_i__examples_2_cube_creator_2_u_i_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/ImportExport/resource.h",
"href":"cpp_ref/_u_i__examples_2_import_export_2resource_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/ImportExport/stdafx.h",
"href":"cpp_ref/_u_i__examples_2_import_export_2stdafx_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/ImportExport/UI.cxx",
"href":"cpp_ref/_u_i__examples_2_import_export_2_u_i_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/ImportExport/UI.h",
"href":"cpp_ref/_u_i__examples_2_import_export_2_u_i_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/SceneTreeView/resource.h",
"href":"cpp_ref/_u_i__examples_2_scene_tree_view_2resource_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/SceneTreeView/stdafx.h",
"href":"cpp_ref/_u_i__examples_2_scene_tree_view_2stdafx_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/SceneTreeView/SDK_Utility.cxx",
"href":"cpp_ref/_u_i__examples_2_scene_tree_view_2_s_d_k__utility_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/SceneTreeView/SDK_Utility.h",
"href":"cpp_ref/_u_i__examples_2_scene_tree_view_2_s_d_k__utility_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/SceneTreeView/UI.cxx",
"href":"cpp_ref/_u_i__examples_2_scene_tree_view_2_u_i_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UI_Examples/SceneTreeView/UI.h",
"href":"cpp_ref/_u_i__examples_2_scene_tree_view_2_u_i_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVSample/main.cxx",
"href":"cpp_ref/_u_v_sample_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/main.cxx",
"href":"cpp_ref/_view_scene_2main_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/targa.cxx",
"href":"cpp_ref/_view_scene_2targa_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/targa.h",
"href":"cpp_ref/_view_scene_2targa_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/DrawScene.cxx",
"href":"cpp_ref/_view_scene_2_draw_scene_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/DrawScene.h",
"href":"cpp_ref/_view_scene_2_draw_scene_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/DrawText.cxx",
"href":"cpp_ref/_view_scene_2_draw_text_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/DrawText.h",
"href":"cpp_ref/_view_scene_2_draw_text_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/GetPosition.cxx",
"href":"cpp_ref/_view_scene_2_get_position_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/GetPosition.h",
"href":"cpp_ref/_view_scene_2_get_position_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/GlFunctions.cxx",
"href":"cpp_ref/_view_scene_2_gl_functions_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/GlFunctions.h",
"href":"cpp_ref/_view_scene_2_gl_functions_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/GL/glew.h",
"href":"cpp_ref/_view_scene_2_g_l_2glew_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/GL/glut.h",
"href":"cpp_ref/_view_scene_2_g_l_2glut_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/SceneCache.cxx",
"href":"cpp_ref/_view_scene_2_scene_cache_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/SceneCache.h",
"href":"cpp_ref/_view_scene_2_scene_cache_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/SceneContext.cxx",
"href":"cpp_ref/_view_scene_2_scene_context_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/SceneContext.h",
"href":"cpp_ref/_view_scene_2_scene_context_8h-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/SetCamera.cxx",
"href":"cpp_ref/_view_scene_2_set_camera_8cxx-example.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewScene/SetCamera.h",
"href":"cpp_ref/_view_scene_2_set_camera_8h-example.html",
"description":"",
"ancestors":[]}]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIZNgYJKoZIhvcNAQcCoIIZJzCCGSMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFHiKZiL4wQxl
// SIG // HKlBKx+rHvfBBp9YoIIUMDCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIFhTCCBG2gAwIBAgIQKcFbP6rNUmpOZ708
// SIG // Tn4/8jANBgkqhkiG9w0BAQUFADCBtDELMAkGA1UEBhMC
// SIG // VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
// SIG // VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYD
// SIG // VQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cu
// SIG // dmVyaXNpZ24uY29tL3JwYSAoYykxMDEuMCwGA1UEAxMl
// SIG // VmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAx
// SIG // MCBDQTAeFw0xMjA3MjUwMDAwMDBaFw0xNTA5MjAyMzU5
// SIG // NTlaMIHIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2Fs
// SIG // aWZvcm5pYTETMBEGA1UEBxMKU2FuIFJhZmFlbDEWMBQG
// SIG // A1UEChQNQXV0b2Rlc2ssIEluYzE+MDwGA1UECxM1RGln
// SIG // aXRhbCBJRCBDbGFzcyAzIC0gTWljcm9zb2Z0IFNvZnR3
// SIG // YXJlIFZhbGlkYXRpb24gdjIxHzAdBgNVBAsUFkRlc2ln
// SIG // biBTb2x1dGlvbnMgR3JvdXAxFjAUBgNVBAMUDUF1dG9k
// SIG // ZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCoYmDrmd0Gq8ezSsDlfgaJFEFplNPNhWzM
// SIG // 2uFQaYAB/ggpQ11+N4B6ao+TqrNIWDIqt3JKhaU889nx
// SIG // l/7teWGwuOurstI2Z0bEDhXiXam/bicK2HVLyntliQ+6
// SIG // tT+nlgfN8tgB2NzM0BpE1YCnU2b6DwQw4V7BV+/F//83
// SIG // yGFOpePlumzXxNw9EKWkaq81slmmTxf7UxZgP9PGbLw8
// SIG // gLAPk4PTJI97+5BBqhkLb1YqSfWn3PNMfsNKhw/VwAN0
// SIG // dRKeM6H8SkOdz+osr+NyH86lsKQuics4fwK5uFSHQHsI
// SIG // t6Z0tqWvminRqceUi9ugRlGryh9X1ZqCqfL/ggdzYa3Z
// SIG // AgMBAAGjggF7MIIBdzAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDBABgNVHR8EOTA3MDWgM6Axhi9odHRwOi8v
// SIG // Y3NjMy0yMDEwLWNybC52ZXJpc2lnbi5jb20vQ1NDMy0y
// SIG // MDEwLmNybDBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBxcD
// SIG // MCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9ycGEwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // cQYIKwYBBQUHAQEEZTBjMCQGCCsGAQUFBzABhhhodHRw
// SIG // Oi8vb2NzcC52ZXJpc2lnbi5jb20wOwYIKwYBBQUHMAKG
// SIG // L2h0dHA6Ly9jc2MzLTIwMTAtYWlhLnZlcmlzaWduLmNv
// SIG // bS9DU0MzLTIwMTAuY2VyMB8GA1UdIwQYMBaAFM+Zqep7
// SIG // JvRLyY6P1/AFJu/j0qedMBEGCWCGSAGG+EIBAQQEAwIE
// SIG // EDAWBgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG
// SIG // 9w0BAQUFAAOCAQEA2OkGvuiY7TyI6yVTQAYmTO+MpOFG
// SIG // C8MflHSbofJiuLxrS1KXbkzsAPFPPsU1ouftFhsXFtDQ
// SIG // 8rMTq/jwugTpbJUREV0buEkLl8AKRhYQTKBKg1I/puBv
// SIG // bkJocDE0pRwtBz3xSlXXEwyYPcbCOnrM3OZ5bKx1Qiii
// SIG // vixlcGWhO3ws904ssutPFf4mV5PDi3U2Yp1HgbBK/Um/
// SIG // FLr6YAYeZaA8KY1CfQEisF3UKTwm72d7S+fJf++SOGea
// SIG // K0kumehVcbavQJTOVebuZ9V+qU0nk1lMrqve9BnQK69B
// SIG // QqNZu77vCO0wm81cfynAxkOYKZG3idY47qPJOgXKkwmI
// SIG // 2+92ozCCBgowggTyoAMCAQICEFIA5aolVvwahu2WydRL
// SIG // M8cwDQYJKoZIhvcNAQEFBQAwgcoxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UE
// SIG // CxMxKGMpIDIwMDYgVmVyaVNpZ24sIEluYy4gLSBGb3Ig
// SIG // YXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVy
// SIG // aVNpZ24gQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0
// SIG // aWZpY2F0aW9uIEF1dGhvcml0eSAtIEc1MB4XDTEwMDIw
// SIG // ODAwMDAwMFoXDTIwMDIwNzIzNTk1OVowgbQxCzAJBgNV
// SIG // BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEf
// SIG // MB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7
// SIG // MDkGA1UECxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8v
// SIG // d3d3LnZlcmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNV
// SIG // BAMTJVZlcmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5n
// SIG // IDIwMTAgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQD1I0tepdeKuzLp1Ff37+THJn6tGZj+qJ19
// SIG // lPY2axDXdYEwfwRof8srdR7NHQiM32mUpzejnHuA4Jnh
// SIG // 7jdNX847FO6G1ND1JzW8JQs4p4xjnRejCKWrsPvNamKC
// SIG // TNUh2hvZ8eOEO4oqT4VbkAFPyad2EH8nA3y+rn59wd35
// SIG // BbwbSJxp58CkPDxBAD7fluXF5JRx1lUBxwAmSkA8taEm
// SIG // qQynbYCOkCV7z78/HOsvlvrlh3fGtVayejtUMFMb32I0
// SIG // /x7R9FqTKIXlTBdOflv9pJOZf9/N76R17+8V9kfn+Bly
// SIG // 2C40Gqa0p0x+vbtPDD1X8TDWpjaO1oB21xkupc1+NC2J
// SIG // AgMBAAGjggH+MIIB+jASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MHAGA1UdIARpMGcwZQYLYIZIAYb4RQEHFwMwVjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L2NwczAqBggrBgEFBQcCAjAeGhxodHRwczovL3d3dy52
// SIG // ZXJpc2lnbi5jb20vcnBhMA4GA1UdDwEB/wQEAwIBBjBt
// SIG // BggrBgEFBQcBDARhMF+hXaBbMFkwVzBVFglpbWFnZS9n
// SIG // aWYwITAfMAcGBSsOAwIaBBSP5dMahqyNjmvDz4Bq1EgY
// SIG // LHsZLjAlFiNodHRwOi8vbG9nby52ZXJpc2lnbi5jb20v
// SIG // dnNsb2dvLmdpZjA0BgNVHR8ELTArMCmgJ6AlhiNodHRw
// SIG // Oi8vY3JsLnZlcmlzaWduLmNvbS9wY2EzLWc1LmNybDA0
// SIG // BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6
// SIG // Ly9vY3NwLnZlcmlzaWduLmNvbTAdBgNVHSUEFjAUBggr
// SIG // BgEFBQcDAgYIKwYBBQUHAwMwKAYDVR0RBCEwH6QdMBsx
// SIG // GTAXBgNVBAMTEFZlcmlTaWduTVBLSS0yLTgwHQYDVR0O
// SIG // BBYEFM+Zqep7JvRLyY6P1/AFJu/j0qedMB8GA1UdIwQY
// SIG // MBaAFH/TZafC3ey78DAJ80M5+gKvMzEzMA0GCSqGSIb3
// SIG // DQEBBQUAA4IBAQBWIuY0pMRhy0i5Aa1WqGQP2YyRxLvM
// SIG // DOWteqAif99HOEotbNF/cRp87HCpsfBP5A8MU/oVXv50
// SIG // mEkkhYEmHJEUR7BMY4y7oTTUxkXoDYUmcwPQqYxkbdxx
// SIG // kuZFBWAVWVE5/FgUa/7UpO15awgMQXLnNyIGCb4j6T9E
// SIG // mh7pYZ3MsZBc/D3SjaxCPWU21LQ9QCiPmxDPIybMSyDL
// SIG // kB9djEw0yjzY5TfWb6UgvTTrJtmuDefFmvehtCGRM2+G
// SIG // 6Fi7JXx0Dlj+dRtjP84xfJuPG5aexVN2hFucrZH6rO2T
// SIG // ul3IIVPCglNjrxINUIcRGz1UUpaKLJw9khoImgUux5Ol
// SIG // SJHTMYIEcjCCBG4CAQEwgckwgbQxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7MDkGA1UE
// SIG // CxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZl
// SIG // cmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNVBAMTJVZl
// SIG // cmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5nIDIwMTAg
// SIG // Q0ECECnBWz+qzVJqTme9PE5+P/IwCQYFKw4DAhoFAKBw
// SIG // MBAGCisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBRs611mBjhS
// SIG // qq+1a61yLtWz1SyDCDANBgkqhkiG9w0BAQEFAASCAQBP
// SIG // 54qYUio7Q6JRqg0C1A9l2xILBJozGCPoRsF/TKaGJkeW
// SIG // 3vxMvglFSmqAyvp0bzMjuonrIk6CcWr/DrxX+PC+08ET
// SIG // 4Oh+hZga7ASDwE3SR0tvMgZ4DD7BvfOMvpwR+G+37s3+
// SIG // H5du+VsVGP0pMPCqWBk4ygURiRdPDjPrJiCV3oXFJXpo
// SIG // s77PJf6Qa1dOtG7g/YSzjMcjw3MF2o9xI00WptIM5mS1
// SIG // ry8LBEwBWXUhIm0fVdRmce8D7BmqizDheK2428Q5nn8e
// SIG // S64u3IM2uz1JNX69wi/zCPMMF9n3UFQD3/voguKs2qtA
// SIG // TTC0M563dvlYsLaXuYf8FuZ/y9PcyAdgoYICCzCCAgcG
// SIG // CSqGSIb3DQEJBjGCAfgwggH0AgEBMHIwXjELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMTAwLgYDVQQDEydTeW1hbnRlYyBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBIC0gRzICEA7P9DjI/r81bgTY
// SIG // apgbGlAwCQYFKw4DAhoFAKBdMBgGCSqGSIb3DQEJAzEL
// SIG // BgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTEzMDcw
// SIG // NDE3MDk1M1owIwYJKoZIhvcNAQkEMRYEFDLpXYtdiEmY
// SIG // wecbshfGdnD3E/QfMA0GCSqGSIb3DQEBAQUABIIBACQa
// SIG // hFjtUaRfOqWYqOP8Nx9kSu12jtJPK86Ue83qLqN+Jqay
// SIG // AOsIo/9xS1SGONwxjc/4Q5D+VjlgI4++XjZjK+sThdwt
// SIG // prjN9TA4v5p3pev1JN/gc8LQKmVuOoC97nNAfIPdDp8e
// SIG // cnNyWslDgs4GndbdfSWgqh6SRSBZimzyhAfjrTfbBBGx
// SIG // n3CNBheuVa/qEuZV4N0fx8RIQpj/OAWMdBJeinxUJMxw
// SIG // njCainKvLQHyK23kgau0yn6oaDzUCW8iXD7gKVu+rG2n
// SIG // F8bqcwqZo3RT7rNcEfpCu4gup+3GReSAOoPvf2oXJhTE
// SIG // 6LM2yxhZ2bIE+ePABXNZdj6X1FhyPu8=
// SIG // End signature block
