var searchResultProvider = new SearchResultsProvider("", "Autodesk 3ds Max SDK Documentation");
searchResultProvider.setTopicInfoList([{"title":"3ds Max SDK Programmer\'s Guide",
"href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm",
"description":"The 3ds Max SDK Programmer\'s Guide describes how to use the 3ds Max Software Development Kit (SDK) to extend the features, functionality, and interface of 3ds Max primarily using C++. For extending 3ds Max with the MAXScript scripting language see the MAXScript documentation included with the 3ds Max documentation.",
"ancestors":[]},
{"title":"About the 3ds Max SDK",
"href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"}]},
{"title":"Using the Help",
"href":"./files/GUID-6389AA40-FF46-4F07-96E7-036E4C15F3F8.htm",
"description":"Supported Browsers The following browsers support the HTML help. Internet Explorer version 7 or later. Apple Safari version 4 or later. Mozilla Firefox version 3.6 or later. Other browsers are not",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"}]},
{"title":"Directory Structure",
"href":"./files/GUID-83C4B5A7-0920-4B6B-804C-7D7332F0BEFD.htm",
"description":"You can click Install Tools & Utilities in the 3ds Max Installation window to install the SDK. By default, the SDK is installed in the 3ds Max 2014 SDK folder, which is located outside the 3ds Max 2014 installation folder. The 3ds Max 2014 SDK folder contains the following:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"}]},
{"title":"Library File Descriptions",
"href":"./files/GUID-F50148FA-74EE-4271-9FDA-FBAD66BE1947.htm",
"description":"Each plug-in must be linked to at least these two libraries: MAXUTIL.LIB and CORE.LIB. The following table describes the library files in the 3ds Max SDK:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"}]},
{"title":"Sample Plug-ins",
"href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm",
"description":"Extensions to 3ds Max are called plug-ins. A plug-in is implemented as a DLL. Much of the functionality of 3ds Max is provided as plug-ins. This section lists most of the over 50 different plug-in types that can be built using the 3ds Max SDK.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"}]},
{"title":"Animation Plug-ins",
"href":"./files/GUID-B902D0C4-5B94-46EB-BD9F-BC3F0CB955CA.htm",
"description":"Animation Controllers Animation controllers are plug-ins that are responsible for managing animation. The most common controllers are interpolating or keyframe controllers. Other controller types ar",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Character Studio Plug-ins",
"href":"./files/GUID-EAF74503-AE5B-4F0E-A62C-2C770374CDCB.htm",
"description":"Crowd Behavior Plug-ins A behavior plug-in is used with the 3ds Max character studio crowd system to simulate crowd activities. Behavior plug-ins typically derive from the class BaseBehavior. How-t",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Data Import and Export Plug-ins",
"href":"./files/GUID-7E534A02-03FE-48CC-9728-DA4C688F02C4.htm",
"description":"3ds Max Data Exchange (3DXI) 3DXI (previously known as IGame) is used for exporting 3ds Max data. 3DXI Export Sample - \\samples\\igame\\export Demonstrates usage of 3DXI to export data. File Expor",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Material and Texture Map Plug-ins",
"href":"./files/GUID-DCE4B277-D3C7-4526-BD7F-A3B6AC319832.htm",
"description":"Color Modifier Texture Maps Color Modifier maps alter the colors of pixels in a material. A color modifier derives from MultiTex. RGB Tint - \\samples\\materials\\tint.cpp The RGB tint material adjus",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"MAXScript Extension Plug-ins",
"href":"./files/GUID-D5ADE38E-DF13-4AC4-8686-67FCC8298BEF.htm",
"description":"MAXScript plug-ins demonstrate extend the MAXScript scripting engine.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Mental Ray Plug-ins",
"href":"./files/GUID-01495FC9-221B-4571-9AB1-F5938D783104.htm",
"description":"A 3ds Max material plug-in may be used as a wrapper around a mental ray shader to share its parameters (using the mental ray translation API), thus providing a custom user interface for the mental ray shader from within 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Miscellaneous Samples and Plug-ins",
"href":"./files/GUID-4FF67724-A5B9-41F3-AC7F-7149247EAF83.htm",
"description":"Asset Tracking System Sample ATS provider - \\samples\\assettrackingsystem\\SampleATSProvider The sample ATS provider is a template project for creating asset tracking system (ATS) providers, and demon",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Modifier Plug-ins",
"href":"./files/GUID-BCB63331-F93B-488A-A68E-522FCE34A225.htm",
"description":"Object Space Modifiers Modifiers provide a way to edit an object\'s parameters and geometry. A modifier derives from the Modifier class. Basic modifiers - \\samples\\modifiers\\basicOps Implements num",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Object Plug-ins",
"href":"./files/GUID-045B0575-27B1-4F4A-A6A3-21A318367D02.htm",
"description":"Camera Objects Plug-in cameras derive from CameraObject and GenCamera. Camera - \\samples\\objects\\camera.cpp Cameras present a scene from a particular point of view. Camera objects simulate still-ima",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Particle System Plug-ins",
"href":"./files/GUID-0D5CC59C-1F68-463A-ABD0-6CA41A989767.htm",
"description":"Atmospheric Effects An atmospheric effect is a function in 3ds space. Atmospheric plug-ins are used for effects such as 3ds Max\'s Fog and Volume Fog. Certain particle effects can be accomplished usi",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Rendering Plug-ins",
"href":"./files/GUID-40ED5D02-BBCF-4EE3-9EE7-E59425B49CBB.htm",
"description":"Anti-Aliasing Filters Anti-aliasing filter plug-in are used for filtering and anti-aliasing an image Anti Aliasing Filters - \\samples\\render\\aaFilters Implements numerous anti-aliasing filters.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Utility Plug-ins",
"href":"./files/GUID-84C58032-D25F-4D17-A0B4-BE4809C19EDE.htm",
"description":"Color Selection Plug-ins A color selection plug-in (i.e. color picker) is a utility plug-in that provides the user with a custom color picker that appears whenever a standard 3ds Max color swatch co",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Sample Plug-ins","href":"./files/GUID-4039E6B2-0292-4246-87A7-214661BA2CAB.htm"}]},
{"title":"Support for Developers",
"href":"./files/GUID-0B83CD11-F095-41A2-BAB0-715D3E8A54CF.htm",
"description":"The following section lists the various support options for 3ds Max SDK developers.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"}]},
{"title":"3ds Max SDK Documentation Online",
"href":"./files/GUID-F96F1502-8E4C-465E-94DD-EFD9CAD782AE.htm",
"description":"The 3ds Max SDK documentation is periodically updated online and can be downloaded from the Autodesk web site at www.autodesk.com/3dsmax-sdk-docs.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Support for Developers","href":"./files/GUID-0B83CD11-F095-41A2-BAB0-715D3E8A54CF.htm"}]},
{"title":"Basic and Community Based Support",
"href":"./files/GUID-BD78E633-A703-4D67-943F-C13BD7156955.htm",
"description":"Basic 3ds Max SDK developer support is available through the Autodesk 3ds Max Developer Center (www.autodesk.com/develop3dsmax). Here you will find links to documentation, samples, presentations, plug-ins, utilities, and other 3ds Max SDK developer resources.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Support for Developers","href":"./files/GUID-0B83CD11-F095-41A2-BAB0-715D3E8A54CF.htm"}]},
{"title":"Premium Support - Autodesk Developer Network",
"href":"./files/GUID-E48291EC-CCC9-4E5D-B8FE-0FBC425334DA.htm",
"description":"The Autodesk Developer Network (ADN) partner program gives you access to frequently asked 3ds Max development questions, white papers on the 3ds Max SDK, debug builds, tools, and direct professional API technical support through the ADN members only website (http://adnsparks.autodesk.com/). Note that the ADN support program for 3ds Max is called ADN Sparks.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"},{"title": "Support for Developers","href":"./files/GUID-0B83CD11-F095-41A2-BAB0-715D3E8A54CF.htm"}]},
{"title":"SDK Requirements",
"href":"./files/GUID-6E179A56-5552-4D0B-BA61-BBD37B9E52DB.htm",
"description":"This topic provides information about the platform requirements for building plug-ins in different versions of 3ds Max (from 3ds Max 4.0 to 3ds Max 2014).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"}]},
{"title":"Legal Notices",
"href":"./files/legal-notice.htm",
"description":"Autodesk® 3ds Max® 2014 © 2013 Autodesk, Inc. All rights reserved. Except as otherwise permitted by Autodesk, Inc., this publication, or parts thereof, may not be reproduced in any form, by any met",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "About the 3ds Max SDK","href":"./files/GUID-BAC35B44-B2A9-4876-B73B-99D073B0DEA5.htm"}]},
{"title":"What\'s New",
"href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm",
"description":"When upgrading a plug-in that is built with earlier versions of 3ds Max SDK, it is recommended to read the what\'s new sections for each intermediate release from the last version of 3d Max in chronological order.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"}]},
{"title":"What\'s New: 3ds Max 2014 SDK",
"href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm",
"description":"The 3ds Max 2014 SDK is binary backward compatible with the 3ds Max 2013 SDK. Therefore, you can run plug-ins compiled with the 3ds Max 2013 SDK in 3ds Max 2014 without recompilation. The changes in the 3ds Max 2014 SDK are mostly additions and extensions.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"}]},
{"title":"New Files",
"href":"./files/GUID-C3DB8399-6DA9-45BC-8CA4-8095619E15B0.htm",
"description":"The following new files are added: 3dsmaxconfig.h 3dsmaxdlport.h mergeable.h util\\bailout.h util\\idlgshowingstatusforpolyobj.h",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"}]},
{"title":"New Classes and Methods",
"href":"./files/GUID-B5D3E422-1376-4AF5-8BFD-4FE825192C35.htm",
"description":"New Classes Following are the new classes: BezFontEX2 – Replaces the BezFontEX class. BitmapIOMetaData – Exposes extended parameters for the BitmapIO class that relates to things like gamma correct",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"}]},
{"title":"Deprecated Types",
"href":"./files/GUID-57411DF8-41F6-4C89-B784-FBD8D7941D0B.htm",
"description":"Each deprecated API uses the doxygen tag \\deprecated. Many virtual methods were sealed in 3ds Max 2013 for the Unicode port. Sealing the method prevented any other method from overriding it. These sealed methods were not removed in the last year, and they are not removed this year as well. A few of the build times use the MAX_DEPRECATED macro which results in a build warning.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"}]},
{"title":"Build Changes",
"href":"./files/GUID-34ED0855-EEDA-4B15-830E-E6E0FB11F7B2.htm",
"description":"The official build configuration has changed in 3ds Max 2014. In 3ds Max 2013, the official MSBuild configuration property was DebugUnicode, HybridUnicode, and RelaseUnicode. In 3ds Max 2014, the Unicode part is removed and the official build configurations are Debug, Hybrid, and Release.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"}]},
{"title":"Particle Flow SDK Extensions",
"href":"./files/GUID-F16BB69E-38B5-44C9-B6D0-8AF38BC0F46A.htm",
"description":"The following headers are added to the Particle Flow SDK (maxsdk\\include\\ParticleFlow). IParticleChannelExt2.h IParticleChannelINodeHandle.h IParticleChannelShapeNodeHandle.h IParticleChannelTrueFalseIterator2.h IParticleGroupExt.h IPFActionExt.h IPFActionListMaterialHolder.h IPFOperatorPhysXWorld.h PFVrayClassIDs.h",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"}]},
{"title":"Nitrous Graphics SDK Extensions",
"href":"./files/GUID-088EF117-1D26-454C-A75A-92FFB3D853E0.htm",
"description":"The following diagram provides a high-level overview of the changes in Nitrous SDK:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"}]},
{"title":"Automatic Gamma Correction",
"href":"./files/GUID-1C7B21BA-91F0-4DC1-82DD-72518042F001.htm",
"description":"The automatic gamma correction mode is introduced to simplify gamma correction. Automatic gamma correction automatically chooses a gamma value when loading a bitmap in certain cases and always when saving a bitmap. The gamma value is determined based on the file type being used. Bitmap plug-ins that have to load and save linear data (not gamma encoded) can choose to export a new BitmapIOMetadata interface and implement a BitmapIOMetadata::UseLinearStorage() function.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"}]},
{"title":"Understanding the Automatic Gamma Correction",
"href":"./files/GUID-B1D5ABC8-8D9A-4E99-81C6-E46DF9E5FFA4.htm",
"description":"This topic describes how the gamma correction used to work previously and how it works currently.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"},{"title": "Automatic Gamma Correction","href":"./files/GUID-1C7B21BA-91F0-4DC1-82DD-72518042F001.htm"}]},
{"title":"SDK Changes for Automatic Gamma Correction",
"href":"./files/GUID-2EC6D15E-6966-4E8C-81D1-E9FB9E0ABDB5.htm",
"description":"This topic first defines how things work in general, and then describes how automatic gamma correction affects the SDK.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2014 SDK","href":"./files/GUID-FB11E625-A47E-4579-8549-C131FBDA0B7A.htm"},{"title": "Automatic Gamma Correction","href":"./files/GUID-1C7B21BA-91F0-4DC1-82DD-72518042F001.htm"}]},
{"title":"What\'s New: 3ds Max 2013 SDK",
"href":"./files/GUID-3402559A-3929-461C-96B2-93120422715B.htm",
"description":"The major changes to the 3ds Max 2013 SDK are listed as follows. Note that your plugins must be modified and recompiled to link to 3ds Max 2013\'s Unicode function signatures. For more information, see Unicode.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"}]},
{"title":"Unicode",
"href":"./files/GUID-F5D23A57-F714-496A-BEE6-A98BD6917822.htm",
"description":"Why different character encodings? Computer programmers did not expect to have much more than the English letters, numbers and few useful symbols in their texts back in 1960s. ASCII was developed as",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2013 SDK","href":"./files/GUID-3402559A-3929-461C-96B2-93120422715B.htm"}]},
{"title":"Compilation Changes",
"href":"./files/GUID-7F73D13A-7806-457A-81C7-D48D51527833.htm",
"description":"Property Sheets 3ds Max now uses Property Sheets for setting compiler and linker build settings. These are available in the SDK at maxsdk\\ProjectSettings\\propertySheets\\*.props. VC10 Compiler 3ds",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2013 SDK","href":"./files/GUID-3402559A-3929-461C-96B2-93120422715B.htm"}]},
{"title":"VC10 Compiler Porting",
"href":"./files/GUID-4F320D08-98F3-42CF-9136-431363CFF62A.htm",
"description":"Introduction 3ds Max 2013 has been upgraded to use version 10.0 of the Microsoft C/C++ compiler. This is the compiler that comes with Visual Studio 2010 Service Pack 1. Plug-in developers can now use",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2013 SDK","href":"./files/GUID-3402559A-3929-461C-96B2-93120422715B.htm"}]},
{"title":"3ds Max .NET SDK Changes",
"href":"./files/GUID-B4DA0A04-F442-4E57-9165-30D3827090F7.htm",
"description":"In 3ds Max 2013 as well as the Subscription Advantage Pack for 3ds Max 2012 there were significant enhancements to the exposure of 3ds Max SDK to .NET. Previously only a small subset of the 3ds Max SDK was exposed to .NET mostly in the ManagedServices.dll. Now nearly all of the global functions and classes in the SDK can be accessed directly from .NET using a new assembly Autodesk.Max.dll found in the application folder.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2013 SDK","href":"./files/GUID-3402559A-3929-461C-96B2-93120422715B.htm"}]},
{"title":"Stabilizing Changes",
"href":"./files/GUID-79D22B5F-2295-4E9A-8956-3424298E4C8A.htm",
"description":"Addition of operator== As part of the .NET work, the equals method (operator==) was added to many classes. These methods all implement deep comparisons to check if an instance is equal to another ins",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2013 SDK","href":"./files/GUID-3402559A-3929-461C-96B2-93120422715B.htm"}]},
{"title":"Language Packs",
"href":"./files/GUID-82AEACF1-2E25-49A4-AD31-52CC5F00B755.htm",
"description":"Overview A Language Pack (LP) is a set of files that can be installed on top of a base product to allow that product to present its User Interface (UI) in another language. An LP is distributed as a",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2013 SDK","href":"./files/GUID-3402559A-3929-461C-96B2-93120422715B.htm"}]},
{"title":"What\'s New: 3ds Max 2012 SDK",
"href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm",
"description":"3ds Max 2012 is not binary backwards compatible with 3ds Max 2011. This means that plug-ins need to be recompiled using the 3ds Max 2012 SDK.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"}]},
{"title":"Major New Features",
"href":"./files/GUID-5A969FA0-CFDC-4681-BB3E-070514E058AC.htm",
"description":"The following are the most significant changes to the 3ds Max 2012 since the previous version.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2012 SDK","href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm"}]},
{"title":"Incremental Improvements",
"href":"./files/GUID-C046B504-BE3E-4509-84B4-C9223FDEBD8A.htm",
"description":"Dark Icon Enhancements Bitmap based icons which were automatically darkened by 3ds Max for use with the dark color scheme have had readability problems. In an effort to solve this problem, 3ds Max 20",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2012 SDK","href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm"}]},
{"title":"Upgrading the target .NET framework version to .Net 4.0",
"href":"./files/GUID-A86718E5-7909-473D-9462-F9806D665647.htm",
"description":"Developers can refer to this FAQ for instructions on how to change the target .NET framework version to .NET version 4.0.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2012 SDK","href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm"}]},
{"title":"Porting Object Plug-ins to Nitrous",
"href":"./files/GUID-BF07C09F-4D4F-41E4-AF07-DCF4FAD0546B.htm",
"description":"Object Display API The object display API is a retained mode graphics API whose functionality is similar to the cached mesh support found with the DirectX viewport driver. This means that plug-ins de",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2012 SDK","href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm"}]},
{"title":"Porting Simple Material and Texture Map Plug-ins to Nitrous",
"href":"./files/GUID-E33FCB1E-C524-4854-8703-3F99E32E6463.htm",
"description":"For more information, consult Implementing Simple Material and Texture Map Plug-ins with Nitrous.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2012 SDK","href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm"}]},
{"title":"Porting Advanced Material and Texture Map Plug-ins to Nitrous",
"href":"./files/GUID-78D3CC8C-8BE9-4854-9042-0120B2CF6211.htm",
"description":"For more information, consult Implementing Advanced Material and Texture Map Plug-ins with Nitrous.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2012 SDK","href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm"}]},
{"title":"Interface Querying",
"href":"./files/GUID-6251E0E4-A7FD-4EA5-8B2D-F2F0BC4E2742.htm",
"description":"When navigating a scene, a plug-in reference will often be retrieved without knowing the concrete type of the plug-in. There are two mechanisms used for querying run-time type information from a plug-in. Each mechanism uses a function named GetInterface(). The first one is InterfaceServer::GetInterface() and the second one is Animatable:: GetInterface(). These functions both return an abstract base class (interface) using an interface identifier.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2012 SDK","href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm"}]},
{"title":"Known Issues",
"href":"./files/GUID-CB4D49C7-4B55-401E-A979-A4D91B90A442.htm",
"description":"NodeEventSystem Issue: The NodeEventSystem fails to properly report when nodes are added to the scene. This problem affects only node added events, and no other event types. Workaround: To detect",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2012 SDK","href":"./files/GUID-B2ABBFD2-828B-403C-9B75-FAAD5AB95456.htm"}]},
{"title":"What\'s New: 3ds Max 2011 SDK",
"href":"./files/GUID-17D32E20-F15A-41A9-8494-2ACF23FE2ABE.htm",
"description":"The 3ds Max 2011 SDK is a binary backwards compatible SDK release. This means that plug-ins compiled using the 3ds Max 2010 SDK, will run in 3ds Max 2011 without requiring recompilation unless they depend on the Open EXR bitmap IO plug-in.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"}]},
{"title":"Major New Features",
"href":"./files/GUID-51D932C1-8FD8-443C-B23C-6207B107E576.htm",
"description":"The following are the most significant changes to the 3ds Max 2011 since the previous version.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2011 SDK","href":"./files/GUID-17D32E20-F15A-41A9-8494-2ACF23FE2ABE.htm"}]},
{"title":"Incremental Improvements",
"href":"./files/GUID-23DD0668-7F7C-491D-A1A7-90AE73426168.htm",
"description":"The following is a list of incremental improvements to the 3ds Max SDK:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2011 SDK","href":"./files/GUID-17D32E20-F15A-41A9-8494-2ACF23FE2ABE.htm"}]},
{"title":"SDK Change Details",
"href":"./files/GUID-AB417DD2-CA8C-4D21-A303-10A5637D3506.htm",
"description":"The following is a more comprehensive list of the changes to API elements. Deprecated API elements are listed here.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2011 SDK","href":"./files/GUID-17D32E20-F15A-41A9-8494-2ACF23FE2ABE.htm"}]},
{"title":"Changes to SDK Documentation",
"href":"./files/GUID-260D2206-29EE-4956-9651-F6A965FFFE59.htm",
"description":"In addition to the obvious changes to the navigation and look and feel of the 3ds Max documentation, as well as the new features of the SDK listed in the topic What\'s New: 3ds Max 2011 SDK and API Change Summary, there have been several changes to pre-existing documentation topics.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2011 SDK","href":"./files/GUID-17D32E20-F15A-41A9-8494-2ACF23FE2ABE.htm"}]},
{"title":"What\'s New: 3ds Max 2010 SDK",
"href":"./files/GUID-DCD13789-C951-44C5-9E20-32932802FD66.htm",
"description":"3ds Max 2010 is not binary compatible with plug-ins built with previous versions of the 3ds Max SDK. Older plug-ins will not load into 3ds Max 2010 so developers will need to recompile them with the latest version of the 3ds Max SDK and usingMicrosoft Visual C++ 2008 with service pack 1 installed. A plug-in upgrade guide has been included that describes in detail the major changes required to plug-ins.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"}]},
{"title":"Upgrading to Visual Studio 2008 Service Pack 1",
"href":"./files/GUID-A661DB09-3594-4A14-9100-F63A1892D2E4.htm",
"description":"The 3ds Max 2010 SDK is compatible only with Microsoft Visual Studio 2008 (VC++ 9) with service pack 1 installed. We do not support plug-ins compiled with other versions of the compiler because 3ds Max 2010 is compiled with Microsoft Visual Studio 2008 (VC++ 9) with service pack 1, as a result plug-ins built with other versions of the compiler cannot be safely loaded.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2010 SDK","href":"./files/GUID-DCD13789-C951-44C5-9E20-32932802FD66.htm"}]},
{"title":"Major New Features",
"href":"./files/GUID-012A1698-14DD-4C8C-9D5B-AB6BDE7F8C19.htm",
"description":"The following are the most significant changes to the 3ds Max 2010 since the previous version.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2010 SDK","href":"./files/GUID-DCD13789-C951-44C5-9E20-32932802FD66.htm"}]},
{"title":"Incremental Improvements",
"href":"./files/GUID-2F7104A3-D9DF-4BCE-AC61-8F46B387DE5C.htm",
"description":"The following is a list of incremental improvements to the 3ds Max SDK:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2010 SDK","href":"./files/GUID-DCD13789-C951-44C5-9E20-32932802FD66.htm"}]},
{"title":"User Interface Updates",
"href":"./files/GUID-2C0DBA5D-7C4C-4197-9DB6-6FA6D8DDA83E.htm",
"description":"There have been many changes to the 3ds Max user interface. We advise inspecting all user interface elements (e.g. dialogs, buttons, icons, etc.) and making necessary changes. The following is a list of updates to the user interface.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2010 SDK","href":"./files/GUID-DCD13789-C951-44C5-9E20-32932802FD66.htm"}]},
{"title":"Plug-in Upgrade Guide",
"href":"./files/GUID-4C0E5633-9F5F-43BB-8B18-88EEE5CE8640.htm",
"description":"3ds Max 2010 is not binary compatible with plug-ins built with earlier versions of the 3ds Max SDK. This guide describes most changes needed to upgrade a plug-in to 3ds Max 2010. Depending on what version of 3ds Max your plug-in was compiled against you should consult the appropriate what\'s new guide for each intermediate version of 3ds Max SDK.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 2010 SDK","href":"./files/GUID-DCD13789-C951-44C5-9E20-32932802FD66.htm"}]},
{"title":"What\'s New: 3ds Max 2009 SDK",
"href":"./files/GUID-A99B6E21-0E6A-4200-A259-E8CB34B2AD82.htm",
"description":"Autodesk\'s goal was to minimize the effort required by 3rd party developers to migrate their plug-ins to 3ds Max 2009. Only important changes that benefit the robustness and flexibility of the SDK are implemented. The following is a brief summary of the new features and enhancements introduced in 3ds Max 2009 SDK, with links to more information where applicable:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"}]},
{"title":"What\'s New: 3ds Max 2008 SDK",
"href":"./files/GUID-37277E41-0035-4F0B-9744-9BD45A300D80.htm",
"description":"The following is a summary of changes in the 3ds Max 2008 SDK release:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"}]},
{"title":"What\'s New: 3ds Max 9 SDK",
"href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm",
"description":"The 3ds Max 9 SDK have added new classes and updated existing classes to introduce significant performance, functionality and, especially, memory management improvements. This means that, to achieve optimal performance of your plug-ins, you will need to visit the code of your existing plug-ins and consider making changes.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"}]},
{"title":"Upgrading to Visual Studio 2005 (Visual C++ 8.0)",
"href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm",
"description":"As of Version 9, 3ds Max 9.0 and its SDK are built using Microsoft Visual Studio 2005, which uses Microsoft\'s Visual C++ Version 8 compiler. The move from VS2002 in Max 8 to VS2005 in Max 9 required a variety of code changes necessitated by the compiler version and the build environment. This guide provides a complete list of changes required to accommodate VS2005 which either directly impact your code\'s ability to interface to the 3ds Max SDK or are simply lessons we have learned through our upgrade exercise that we want to pass on to 3ds Max SDK users. The following is a list of the topics in this section:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"Run Time Library Validation",
"href":"./files/GUID-66A6946B-A69E-4F02-B11E-2BDD298B76E1.htm",
"description":"The VS2005 Run Time Library (RTL) is considerably more strict than previous versions. This is an aspect of Microsoft\'s security initiative by which errors are caught as early as possible, avoiding the execution of random code.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"Release Builds Have Asserts Turned Off",
"href":"./files/GUID-05ABC579-25C3-4FA5-9B68-F5A920185280.htm",
"description":"The 3ds Max SDK now ships with asserts turned off. This means that users will not see assert dialogs popping up.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"Changes to DllMain()",
"href":"./files/GUID-0F00A98D-65E2-46E4-8B65-AB6650477CF1.htm",
"description":"Writing correct DllMain() functions is difficult. MSDN describes a series of restrictions, but these are so often ignored that Microsoft had to relax these restrictions by adding IJW (\"It Just Works\") technology.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"Changes to Module Definition Files(.DEF)",
"href":"./files/GUID-B26709EA-F0AF-482C-8116-A4DED61B5F1F.htm",
"description":"A typical .def file looked like the following example prior to Visual Studio 2005:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"wchar_t is Now Treated as a Type",
"href":"./files/GUID-F07F88CD-5F26-41B6-AB43-C8A2813ABAE7.htm",
"description":"In VS2002, wchar_t was a typedef over unsigned short. If you wanted to treat wchar_t as an actual type, you had to turn on a compiler flag. You could also use __wchar_t instead.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"for() Loop Scoping",
"href":"./files/GUID-2B71BC5E-7855-4DF2-997E-104682E176B9.htm",
"description":"We have upgraded all for() loops to follow the C++ standard. The following code shows an example of when for() loop scope is misunderstood:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"Implicit int Type is Invalid",
"href":"./files/GUID-AD50A4C9-6A5E-4F46-B633-5F02A3D3AD7D.htm",
"description":"In standard C, you can declare variables and functions without mentioning their type, leaving the compiler to assume their type is int. Even in VC++ 7, although you cannot call a function without a prototype, you can still rely on the default int type. The following code shows an example of this:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"Named Enums",
"href":"./files/GUID-787A1678-C87E-4BF4-BE15-0CCEE3A0A7B1.htm",
"description":"In C++, A::b::c is invalid. Consider the following declaration:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"Debugger and Symbols",
"href":"./files/GUID-A6B93589-B2E4-4707-B541-B76138B7B8B2.htm",
"description":"You can have VS2005 automatically download the \'OS\' symbols as you need them. In Tools>Options, there is a Debugging section. The last sub-section is \'Symbols\'.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"Manifests",
"href":"./files/GUID-4DF98F25-4DB1-4789-8C6A-D75D30FF3D75.htm",
"description":"Up to VS2005 Beta2, one could largely ignore Microsoft\'s.manifest and what it implied. However, with the arrival of VS2005 RC1 and VS2005 RTM, using /MANIFEST:NO became problematic. Anything that links to the Microsoft DLLs (the RTL, MFC, ATL) must use a manifest, or the DLL\'s DllMain() will not be loaded into the process\'s memory. The use of manifests is now an issue because 3rd-party developers submit plug-ins without manifests, preventing their use in debug builds.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"},{"title": "Upgrading to Visual Studio 2005 (Visual C++ 8.0)","href":"./files/GUID-50BFFE56-300E-491C-B47F-020A0D7057DC.htm"}]},
{"title":"Reference System Changes",
"href":"./files/GUID-5E606706-9B89-487E-AC93-87321A634C0B.htm",
"description":"This topic describes changes to 3ds Max\'s Reference System that affect existing plug-ins developed under Version 8 and earlier of the 3ds Max SDK.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"Relative Paths",
"href":"./files/GUID-FE79117E-B539-474F-9C88-86DF83DF3D2B.htm",
"description":"Version 9 of the 3ds Max SDK introduces the notion of a user defined project folder and a library of functions that facilitate the use of relative paths (relative to the project folder) for managing users\' assets. MaxSDK::Util::Path is a type designed for doing path-related string manipulations. It also works well with the newly introduced methods of IPathConfigMgr.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"NVIDIA Cg Support",
"href":"./files/GUID-7E39AAF8-8977-415B-A256-984B4300DBC5.htm",
"description":"The 3ds Max 8 SDK shader interface required that the shader be loaded and compiled by the material. The parser simply got the compiled object. NVIDIA has a different compile system, so without fundamental changes to the shader interface design, the material would have to include a special case for Cg support - a definite limitation. Moving the loading and compilation of the shaders removes the restriction of the type of shader the system can support. The material simply supplies a filename or buffer to compile.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"What\'s New in 3DXI",
"href":"./files/GUID-7D3F5260-4547-4C1C-976E-856E261492DC.htm",
"description":"This article summarizes features and improvements made to the 3ds Max Data eXchange Interface (3DXI) for release with the 3ds Max 9 SDK and released previously in January 2006.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"ParamBlockDesc2 Flags",
"href":"./files/GUID-18BA505F-0AD1-429E-9B07-9F01A2E2ABDD.htm",
"description":"The topic describes significant new ParamBlockDesc2 flags.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"SuperClassID Cleanup",
"href":"./files/GUID-9AA869F6-D57B-475E-AA22-6BE80D3C2F3F.htm",
"description":"Since plug-ins were never forced to overwrite the method virtualSClass_IDAnimatable::SuperClassID(), and the ReferenceMaker and ReferenceTarget classes have not been overwriting this method either, some plug-in classes were reporting an incorrect superclassid - a value of 0 or REF_MAKER_CLASS_ID when, in fact, they derive from class ReferenceTarget.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"NoRemap() was Deprecated",
"href":"./files/GUID-6C1EDD27-1A1F-4494-8739-28D1EE1F9433.htm",
"description":"The NoRemap() function was used to return a RemapDir-derived class instance. The implementation of that instance did no remapping of references during a clone operation.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"MBCS Versus Unicode",
"href":"./files/GUID-A55E7AFB-3B32-433F-8907-4344AF74F0CE.htm",
"description":"3ds Max is a multi-byte character set (MBCS) system. Yet, there is a need for certain plug-ins to support Unicode. For this release of the 3ds Max SDK, we have started the process of converting to a selectable MBCS/Unicode product. The approach permits MBCS or Unicode plug-ins to operate with 3ds Max, at the developer\'s discretion, but 3ds Max itself has yet to be converted to Unicode.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"Vault and Asset Tracking",
"href":"./files/GUID-196B6C52-BA79-444D-99CE-B582D315811F.htm",
"description":"We have improved the public 3ds Max SDK interface to the Asset Tracking System: methods and parameters have been added and method usage simplified.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"Method for Including .lib files",
"href":"./files/GUID-3E3E5824-66C0-468B-B94D-CE1562017B47.htm",
"description":"Previously, 3ds Max SDK .vcproj files included libraries as just another source file, using a relative path. This prevented building Win32 and x64 binaries in the same folder. During the project file conversion, LIB files were removed form the list of \'source files\', and moved as \'additional linker dependencies\' in the project settings. The relative paths were added to the linker options, with appropriate modifications for the x64 builds.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"size_t Considerations",
"href":"./files/GUID-404473C3-A619-400A-801F-1760FB4D4B2F.htm",
"description":"A size_t has a different size depending on the target platform.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"Max File Format Change",
"href":"./files/GUID-E09E0480-C26D-488D-8269-9E1231D4F8B6.htm",
"description":"As usual, the .max file format was changed. 3ds Max can read files created by earlier releases, but those earlier versions cannot read files created by later versions of 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "What\'s New","href":"./files/GUID-03D502BD-C5D1-4DA7-938E-39227AC7C351.htm"},{"title": "What\'s New: 3ds Max 9 SDK","href":"./files/GUID-3CACA832-70D6-429E-AED7-D068C4664D89.htm"}]},
{"title":"3ds Max SDK - The Learning Path",
"href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm",
"description":"Visit http://code.google.com/p/3ds-max-dev/ for a downloadable version of the code presented in this section.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"}]},
{"title":"Getting Started Writing Plug-ins",
"href":"./files/GUID-717D0F11-78F1-4C0E-878F-506A31911E4D.htm",
"description":"Introduction This document reviews the structure of 3ds Max plug-ins and the interactions between 3ds Max software, the plug-ins and the user. The goal is to provide a clear image of the architectur",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Installing the Plug-in Wizard (AppWizard)",
"href":"./files/GUID-D465CBEE-0923-4250-857A-DED1A4B11B77.htm",
"description":"The 3ds Max Plug-in Wizard (commonly called the AppWizard) is an add-in for Visual Studio that builds skeleton plug-ins for 3ds Max. You simply have to specify what plug-in type you would like to build, and follow the directions in the wizard. The wizard generates the Visual Studio project files, the CPP files, and skeleton code with \"TODO\" comments. The 3ds Max Plug-in Wizard (commonly called the AppWizard) is an add-in for Visual Studio that builds skeleton plug-ins for 3ds Max. You simply have to specify what plug-in type you would like to build, and follow the directions in the wizard. The wizard generates the Visual Studio project files, the CPP files, and skeleton code with \"TODO\" comments.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Lesson 1: Sample utility plug-in",
"href":"./files/GUID-E916E668-AD2E-497D-91D4-7776CFA0B7F1.htm",
"description":"Start Working with the Plug-in Wizard In this lesson we demonstrate the minimum required steps to create a plug-in that gets loaded by 3ds Max. The IDE and compiler configurations are reviewed, and",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Lesson 2: The Scene Graph and Nodes",
"href":"./files/GUID-DCD280C9-36B4-4053-9A7F-DF03CA4F41F0.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Lesson 3: the reference system",
"href":"./files/GUID-5F19208A-B95E-41A8-A788-3108F747AF0E.htm",
"description":"Plug-ins can use the 3ds Max reference system to be notified when another entity changes in the schene. In the reference system schema a plug-in creates a reference to a second plug-in so if the second plug-in (reference target) is changed, deleted or updated, the first plug-in (reference maker) will be automatically notified. A plug-in can be both a reference target and a reference maker at the same time. An example of using references is when a scene object is following a second scene object. If the first object has a reference to the second one, it will be notified whenever the coordinates of the second object changes, so it can update its own coordinates. Another example is a camera that is looking at a geometric object and its perspective needs to be updated whenever the parameters of the geometric object such as position, orientation, size, material, etc. changes or when the object is deleted. We will also see in Lesson 6 that the plug-ins have a reference to their parameters (stored in a separate objects of the class iParamBlock2) and update themselves whenever one of their parameters change. You can refer to the topic reference system in the programmers guide to have detailed information on this.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Lesson 4: Animation Controllers",
"href":"./files/GUID-A39314EC-15B4-4919-BB1B-318FFDC05DD8.htm",
"description":"Users animate their objects in 3ds Max by changing the object\'s properties over time. 3ds Max uses \"animation controllers\" for this purpose. Animation controllers - or \"controllers\" in short - are plug-ins whose main responsibility is to provide 3ds Max with the value of a parameter at a given time, whenever 3ds Max inquires them. In mathematical terms, controllers implement a function of time whose output is a point in either one dimensional space (float controllers) or in a multi dimensional space (e.g. position or rotation controllers). A common application of controllers is to update the position, rotation or scale (PRS) parameters of a node associated with an object. Note that the scene graph does not store the geometric objects but nodes associated with those objects and their own PRS parameters.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Lesson 5: Geometric Objects",
"href":"./files/GUID-ACBA3D03-0345-441F-9963-1459C5DA4D6E.htm",
"description":"Geometric objects are one of the the most important parts of 3ds Max, without whom there cannot be a scene. In this lesson we will show how to create the geometry of an object using a mesh, and then we will show how to read mouse actions to create the object.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Lesson 6: Parameter Blocks",
"href":"./files/GUID-5D9AF70B-0627-434E-AB45-03CC9941496A.htm",
"description":"3ds Max refers to the data values associated with the plug-ins as \'parameters\'. The size of a geometric object and angle of a bend modifier are examples of parameters. 3ds Max has a powerful mechanism to manage the parameters: instead of keeping them as individual data members, they are encapsulated in \"parameter blocks\" (objects of the class IParamBlock2). Parameter blocks provide a standard method for 3ds Max to read values from and write values to the parameters of the plug-ins, independent of the plug-in type and have the following advantages:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Lesson 7: Writing .Net Plug-ins",
"href":"./files/GUID-ED89ECC5-5E40-43AD-932A-CC377C5BFF55.htm",
"description":"3ds Max uses its integrated .NET assembly loaders at run time to load any valid .Net assembly that implements a 3ds Max plug-in. Such assembly DLL files should be placed in [3ds Max installation folder]\\bin\\assemblies. There are different DLL libraries providing necessary API for your .NET plug-ins to use the 3ds Max SDK. Two important DLL library for this purpose are MaxCustomControl.dll and Autodesk.max.dll. The former library provides an interface for developers to write Custom Action Items, while the latter one provides a comprehensive library to to make almost all the features of 3ds Max SDK accessible for the developers.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK - The Learning Path","href":"./files/GUID-C59F7DCE-8B96-4A49-A4E0-053EA2424A0D.htm"}]},
{"title":"Overview",
"href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"}]},
{"title":"Overview: 3ds Max Architecture",
"href":"./files/GUID-E2C41539-171A-4611-BE8F-6F7D9C21B6F3.htm",
"description":"3ds Max is an advanced modeling, rendering, and animation software package. 3ds Max has an plug-in architecture that allows the core functionality to be extended by third-party developers. Much of the functionality that 3ds Max provides can be attributed to plug-ins that are implemented as DLLs. Most of the source code to these plug-ins is provided with the 3ds Max SDK, as either samples or how-to\'s.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: 3ds Max SDK",
"href":"./files/GUID-F999A405-B1EF-4C44-9126-49169D48CB35.htm",
"description":"The 3ds Max SDK consists of a rich set of C++ abstract classes (interfaces) and libraries. Some interfaces represent services exposed by 3ds Max for plugins to use. Their implementation are stored in libraries. These services are often referred to as 3ds Max \"Core\".",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: Plug-ins",
"href":"./files/GUID-7F6A1A08-E8C7-42C9-A773-3FF1920ABCF0.htm",
"description":"A plug-in describes scene entities, such as procedural (parametric) objects, materials, etc, processes that manipulate them, such as the process of rendering or exporting a scene, or customize how 3ds Max looks and behaves. Plug-ins can be written in C++, MAXScript, or .NET. Most plug-ins are written in C++.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: Class Hierarchy",
"href":"./files/GUID-426B7197-6559-4121-9E0C-78D584AB2170.htm",
"description":"The following diagram shows the most important classes in the 3ds Max plug-in class hierarchy:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: Scene Graph and Nodes",
"href":"./files/GUID-8ACA34EE-5BA0-4EE2-9128-DF20E8DAB966.htm",
"description":"In a 3ds Max scene the objects that a user can create and manipulate in the viewports are called scene objects. Scene objects derive from the Object class. Examples of scene objects are geometric objects (GeomObject), lights (LightObject), cameras (CameraObject), particles, and world space modifiers (not to be confused with regular modifiers).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: Parameter Blocks",
"href":"./files/GUID-C20002DE-2E29-4191-9929-8CF1D514FFF1.htm",
"description":"The 3ds Max parameter block system is a mechanism used by 3ds Max to manage parameters used by a plug-in (e.g. a bend modifier\'s angle parameter, or a sphere\'s radius parameter).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: Reference System",
"href":"./files/GUID-9786FA9E-355E-40B5-A07B-D6307888D3B9.htm",
"description":"A reference indicates a dependency between two plug-ins, or a 3ds Max object and a plug-in. 3ds Max uses the reference system for several purposes:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: Animatable Hierarchy",
"href":"./files/GUID-217E07FF-C141-4318-85C1-6D6BE976DA26.htm",
"description":"Most entities in 3ds Max that the user can see and interact with, including renderable entities such as objects, and non-renderable entities such as controllers, modifiers, lights and cameras, are derived from the Animatable base class. Most plug-ins types are Animatable derived classes.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: Time and Intervals",
"href":"./files/GUID-CA70B328-ACC9-4079-B0E9-B1FF3528EAB0.htm",
"description":"Developers working with animation need to specify points in time and time intervals. The basic unit of time in 3ds Max and the SDK is 1/4800th of a second. This length of time is a data type named TimeValue. TimeValues are used throughout the class methods in the SDK when a particular instant in time needs to be specified. For example, if your plug-in needs to know the current system time (the position of the 3ds Max frame slider) it calls Interface::GetTime(), which returns a TimeValue that indicates the current time.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: User Interface",
"href":"./files/GUID-092A0FED-BCD2-4555-80EE-3620261729F1.htm",
"description":"The user interacts with 3ds Max and plug-ins mainly using the command panel roll-ups and dialogs, the mouse (or tablet), the keyboard, and the 3D viewport. The 3ds Max SDK provides developers with the ability to control each of these methods of user interaction.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Overview: MAXScript or C++",
"href":"./files/GUID-4D5790CB-BBAE-4F55-B67A-589ED24E99B6.htm",
"description":"There are three approaches to writing plug-in applications:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Overview","href":"./files/GUID-B57877A7-4124-4C1D-B076-CFE8B54C5FAD.htm"}]},
{"title":"Best Practices",
"href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"}]},
{"title":"Automatic Gamma Correction Best Practices",
"href":"./files/GUID-248877C4-EBA0-484D-BBA1-7D155A5436E8.htm",
"description":"The automatic gamma correction method chooses a gamma value based on the file type when loading a bitmap file (in certain cases) and when saving a bitmap file. You do not need to care about the gamma correction because it is automatically done based on the file type, bit depth, and other properties.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"Undo System Best Practices",
"href":"./files/GUID-1EA4990A-3B8B-4713-B7EB-B312B88BF76A.htm",
"description":"Supporting undo and redo is an important part of the user experience. The following is a list of best practices for making sure a plug-in works well with undo system.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"General Best Practices",
"href":"./files/GUID-E7D852FF-CC82-4439-AD11-4A1BE4E8E56D.htm",
"description":"Following is a list of general best practices to follow, and pitfalls to avoid.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"Reference System Best Practices",
"href":"./files/GUID-1A526B2B-C6DA-43D6-9D1C-F1AC527645CB.htm",
"description":"The following is a list of best practices regarding usage of the reference system:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"Memory Management",
"href":"./files/GUID-CF9A7D22-8158-4567-8343-1D4360B9DCB8.htm",
"description":"To ensure that a plug-in does not cause instability in the 3ds Max, the following rules must be followed for all objects that may be shared from a plug-in with 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"Smart Pointers (AutoPtr)",
"href":"./files/GUID-8625E644-9F50-42AA-BCF0-AB0EC34159A6.htm",
"description":"The AutoPtr class template allows a destruction policy to be provided, as an additional template parameter. Since not all objects have the same destruction requirements, the AutoPtr template can be parameterized to support creating various types of AutoPtrs differentiated by their destructor policy template parameter. Three templates provide specialized policies to the AutoPtr.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"},{"title": "Memory Management","href":"./files/GUID-CF9A7D22-8158-4567-8343-1D4360B9DCB8.htm"}]},
{"title":"AddAppDataChunk and MAX_malloc()",
"href":"./files/GUID-546D1AA8-3BE7-4CC0-A512-983CE024F875.htm",
"description":"Plug-ins should allocate the memory block that they pass to Animatable::AddAppDataChunk() using MAX_malloc(). This ensures that the memory buffer is allocated and de-allocated using the same heap, reducing the chances of problems related to memory corruptions.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"},{"title": "Memory Management","href":"./files/GUID-CF9A7D22-8158-4567-8343-1D4360B9DCB8.htm"}]},
{"title":"Thread Safety",
"href":"./files/GUID-610CE507-CD6B-4D82-A248-50BCB7F9CD40.htm",
"description":"3ds Max is not thread-safe. You should not call any function from multiple threads concurrently. That said plug-ins that relate to the renderer have to implement specific methods in a thread-safe manner. This is because the renderer launches several threads of execution when rendering an image. Therefore the same method could get called from several threads at the same time. If one of the methods is writing a value that the other is reading or writing this can interfere with valid values being accessed.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"RTTI and GetInterface()",
"href":"./files/GUID-00BDD9FB-83AC-49A7-A481-F57D3A0DFFAA.htm",
"description":"Although run-time type information (RTTI) allows for querying polymorphic objects at run-time and safely casting down a class hierarchy, RTTI is not a replacement for the 3ds Max SDK GetInterface mechanism. RTTI improves code robustness, as illustrated by the following example that uses BaseInterface::GetInterface() with dynamic_cast, instead of Animatable::ClassID() with static_cast.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"Exception Safety",
"href":"./files/GUID-BAD95195-4907-4BD8-891D-8FF739B1D59F.htm",
"description":"Good C++ programming practices dictates that classes should be exception-safe. This can improve the stability of code, by preventing the possibility of partial construction of objects.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"Handling WM_NOTIFY Messages",
"href":"./files/GUID-7F64FCEE-B48E-4EA7-B9DA-E303C4A574DE.htm",
"description":"Plug-in code should not assume when receiving a WM_NOTIFY message that lParam is always a pointer to a structure of type OFNOTIFY. The lParam parameter should always be interpreted as a pointer to an object of type struct NMHDR. If NMHDR::code is between [CDN_LAST, CDN_FIRST and is equal to CDN_INITDONE, lParam could then be interpreted as a pointer to a OFNOTIFY struct.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"Handling Requests for Interfaces",
"href":"./files/GUID-7E25B025-0378-4481-9F0D-7AAEA6F2E787.htm",
"description":"As mentioned in the Interface Querying topic, incorrect implementation of InterfaceServer::GetInterface() might lead to incorrect display of the plug-in in the Nitrous viewport. BaseInterface* InterfaceServer::GetInterface(Interface_ID iid);",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"Correctly Clearing XOR-ed Lines Drawn in the Viewport",
"href":"./files/GUID-15F8A179-C798-40A8-A761-993F21DA9220.htm",
"description":"Sometimes a plug-in needs to draw two-dimensional lines and shapes that are XOR-ed with the viewport image. The following is an example of drawing a XOR-ed rectangle using XORDottedRect() :",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Best Practices","href":"./files/GUID-9A4E7781-19B7-47AD-A6C2-4AD3C1571C7B.htm"}]},
{"title":"3ds Max SDK Features",
"href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"}]},
{"title":"Working with Plug-ins",
"href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm",
"description":"The 3ds Max architecture is highly componentized. Different components of 3ds Max, such as objects, modifiers, materials, cameras, lights, etc., are implemented in separate DLL\'s as plug-ins that derive from the Animatable base class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Plug-in Architecture",
"href":"./files/GUID-AB6F69EE-0632-48D0-BB68-A46E6DA0F6C4.htm",
"description":"An abstract base class (i.e. a class containing one or more abstract virtual functions) is called an interface in the 3ds Max SDK documentation. In 3ds Max interfaces are used to expose services from 3ds Max to plug-ins (called the core interfaces).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"}]},
{"title":"Plug-in Base Classes",
"href":"./files/GUID-6BFC43D7-336F-4F14-A969-800A083375FE.htm",
"description":"Each plug-in type exposes its functionality to 3ds Max by defining a class that derives from a specific base-class and providing implementations of key virtual functions. The most important base class is Animatable, which most plug-ins implement from.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"}]},
{"title":"Interface Querying",
"href":"./files/GUID-3F7E734C-065F-46FF-86AA-3B241F45E4E5.htm",
"description":"When navigating a scene a plug-in reference will often be retrieved without knowledge of the concrete type of the plug-in. There are two separate mechanism used for querying run-time type information from a plug-in. Each mechanism uses a method named \"GetInterface()\". These methods both return an abstract base class (interface) using an interface identifier.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"}]},
{"title":"Creating Instances of Plug-ins",
"href":"./files/GUID-AD0A4125-5FC6-4785-B9DB-74879C24E1EB.htm",
"description":"An instance of a plug-in, including primitive objects and modifiers, can be created from the super class id and class id using the Interface::CreateInstance() method or the global function CreateInstance(). The global function CreateInstance() is equivalent to calling GetCOREInterface()-> CreateInstance().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"}]},
{"title":"Parameter Blocks",
"href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm",
"description":"Parameter blocks provide a mechanism for storing values associated with a plug-in. The parameter block is useful for exposing the values to a user using UI controls. The parameter block managing the controller which handles the interpolation or generation of values. Parameter blocks are implemented as an object of class IParamBlock2.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"}]},
{"title":"Responsibilities of a Parameter Block",
"href":"./files/GUID-4315093A-3D2C-4427-81D0-E90532B3E1FB.htm",
"description":"Parameter blocks handle the following tasks:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"}]},
{"title":"Parameter Block UI",
"href":"./files/GUID-4A71AF47-CB94-4734-83F9-9FAFA9217088.htm",
"description":"A parameter block corresponds to a roll-out window in 3ds Max. The roll-out window contains the UI elements (widgets) that correspond to particular parameters.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"}]},
{"title":"Creating a Parameter Block",
"href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm",
"description":"Parameter blocks are created from parameter block descriptors (ParamBlockDesc2). There are two methods for a plug-in to create a parameter block. The most common method is through a call to ClassDesc2::MakeAutoParamBlocks(). This will ask 3ds Max to automatically create all parameter blocks that have been registered with the class descriptor using the method, ClassDesc2::AddParamBlockDesc(). In order for this approach to work, parameter block descriptions needs to have the P_AUTO_CONSTRUCT flag set.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"}]},
{"title":"Describing a Parameter Block",
"href":"./files/GUID-84C6EB82-F6F8-4E13-88C7-FFDA50136699.htm",
"description":"A parameter block is created with a parameter block descriptor as an argument. There is exactly one parameter block descriptor for every parameter block. A programmer must create a singleton parameter block descriptor that remains valid throughout the life of the DLL. This can be done by declaring a static instance in the DLL. The ParamBlockDesc2 constructor takes a variable amount of arguments that describe the parameter block. Alternatively you can construct the parameter block descriptor incrementally using methods such ParamBlockDesc2::AddParam() and ParamBlockDesc2::ParamOption().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"}]},
{"title":"Parameter Block Flags",
"href":"./files/GUID-FAD66C54-779B-477A-99B2-50B63A2D6A1B.htm",
"description":"The following are the block/descriptor flags. One or more of the following values (they may be OR\'d together as in P_AUTO_CONSTRUCT | P_AUTO_UI).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"}]},
{"title":"Parameter Block UI Specification Arguments",
"href":"./files/GUID-DA54ACEF-CA52-4CF0-AA82-A65DB667A97B.htm",
"description":"If the parameter block descriptor flag P_AUTO_UI is assigned it indicates that the parameter block supports automatic UI rollout management. This means that an additional set of arguments called the parameter block UI specification arguments must be provided.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"}]},
{"title":"Parameter Specification Arguments",
"href":"./files/GUID-44135D9D-FFE5-458E-BB66-67AAD6175253.htm",
"description":"A parameter specification is the sequence of arguments used in a ParamBlockDesc2 constructor or the ParamBlockDesc2::AddParam() method to describe a particular parameter. A parameter specification is required in the ParamBlockDesc2 constructor for each of the parameters.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"}]},
{"title":"Parameter Types",
"href":"./files/GUID-0E6E1942-3D58-4900-94B4-1C89D9D443F2.htm",
"description":"The parameter types are identified by a ParamType or ParamType2 enumeration. These are defined in the header file paramtype.h.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"},{"title": "Parameter Specification Arguments","href":"./files/GUID-44135D9D-FFE5-458E-BB66-67AAD6175253.htm"}]},
{"title":"Parameter Flags",
"href":"./files/GUID-4380C0D1-1A2F-48F1-A21D-6E58766685F6.htm",
"description":"The following are the flags used in the parameter specification.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"},{"title": "Parameter Specification Arguments","href":"./files/GUID-44135D9D-FFE5-458E-BB66-67AAD6175253.htm"}]},
{"title":"Parameter Tags",
"href":"./files/GUID-7C1A5EBD-C941-4119-BBF3-50AD1F2594A3.htm",
"description":"The following are the optional parameter tags. These are special values used in the ParamBlockDesc2 constructor or the ParamBlockDesc2::ParamOption() method to indicate additional information is present. They are defined as enumerated values in the enumeration ParamTags.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"},{"title": "Parameter Specification Arguments","href":"./files/GUID-44135D9D-FFE5-458E-BB66-67AAD6175253.htm"}]},
{"title":"Parameter UI Control Types",
"href":"./files/GUID-845F2303-6DBD-48E1-8BF5-FAEAC829CD3C.htm",
"description":"If the optional p_ui tag is included in a parameter block descriptor, then it is followed by the user interface control specification. This tag is followed by a variable list of arguments depending on the type of UI control specified. The first value following the p_ui tag is a control type identifier, which defines the number and type arguments which must follow.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"},{"title": "Parameter Specification Arguments","href":"./files/GUID-44135D9D-FFE5-458E-BB66-67AAD6175253.htm"}]},
{"title":"Spinner and Slider Control Types",
"href":"./files/GUID-BD4AC5F2-8C2E-441D-89A2-A915A8B7497D.htm",
"description":"A spinner control type is identified by TYPE_SPINNER and a slider control type is identified by TYPE_SLIDER. Both control types have similar requirements. They require a spinner type identifier (EditSpinnerType), list of dialog item resource IDs, and a number of ticks. The spinner type identifier can be one of the values described below:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"},{"title": "Parameter Specification Arguments","href":"./files/GUID-44135D9D-FFE5-458E-BB66-67AAD6175253.htm"},{"title": "Parameter UI Control Types","href":"./files/GUID-845F2303-6DBD-48E1-8BF5-FAEAC829CD3C.htm"}]},
{"title":"List Box Control Types",
"href":"./files/GUID-0F3A6160-A112-44D5-A206-07570C5D1003.htm",
"description":"The parameter types TYPE_INTLISTBOX and TYPE_FLOATLISTBOX specifies a series of controls for displaying and managing a list box control containing a Tab<int> or Tab<float> parameter respectively. The setup consists of a list box control, 3 buttons (for adding, replacing and deleting items) and a 3ds Max spinner to supply source values for add and replace. After the control type, you must supply 4 dialog item IDs. The first is the list box control, then dialog item IDs for 3 custom button controls for the add, replace, and delete button respectively. These are followed with a spinner type, an edit box dialog item ID a spinner dialog item ID, and a display scale You can supply the value 0 for any of the add, replace, or delete buttons if you don\'t need them in the dialog. This can only be used with the following parameter types:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"},{"title": "Parameter Specification Arguments","href":"./files/GUID-44135D9D-FFE5-458E-BB66-67AAD6175253.htm"},{"title": "Parameter UI Control Types","href":"./files/GUID-845F2303-6DBD-48E1-8BF5-FAEAC829CD3C.htm"}]},
{"title":"Combo Box Control Types",
"href":"./files/GUID-68699C8E-3FF8-451E-88C3-E63EA882139E.htm",
"description":"This combo box parameter control type can be used with parameters of type TYPE_INT and TYPE_INT_TAB. When used with parameters of type TYPE_INT, it needs to be followed by a series of controls for displaying and managing a combo-box control, as shown below:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Creating a Parameter Block","href":"./files/GUID-A232F26A-3000-471C-AD97-35C658B88A9E.htm"},{"title": "Parameter Specification Arguments","href":"./files/GUID-44135D9D-FFE5-458E-BB66-67AAD6175253.htm"},{"title": "Parameter UI Control Types","href":"./files/GUID-845F2303-6DBD-48E1-8BF5-FAEAC829CD3C.htm"}]},
{"title":"Saving, Loading, and Deleting Parameter Blocks",
"href":"./files/GUID-399C2B27-B7DC-4F5D-9DDE-07FEC74BEF67.htm",
"description":"Parameter blocks are reference targets (ReferenceTarget). A 3ds Max object always derives from ReferenceMaker, and one of its reference is the parameter block. Most of the time, a plug-in object is the only ReferenceMaker that will reference a parameter block.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"}]},
{"title":"Getting and Setting Parameter Block Values",
"href":"./files/GUID-275BCF3E-C0B6-4033-99DF-B51861B3BBDB.htm",
"description":"Parameter block values are get and set from an IParamBlock2 object using a ParamID that identifies the parameter value. This must be the same parameter identifier that is supplied as part of the parameter specification arguments.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"}]},
{"title":"Accessing and Exposing Parameter Blocks",
"href":"./files/GUID-19A9A58F-1E99-4ABF-AEEC-3F4A4E144307.htm",
"description":"A plug-in that inherits from Animatable may make its parameter block available for other plug-ins by implementing the methods:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"}]},
{"title":"Parameter Block 1",
"href":"./files/GUID-9DD9300D-ABD2-415D-B719-6CD979611DB6.htm",
"description":"This section contains topics related to the parameter block 1 system, implemented by classes such as ParamBlock and ParamArray. The parameter block 1 system remains for backwards compatibility, but is effectively deprecated. All plug-ins should be upgraded to use IParamBlock2 parameter blocks.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"}]},
{"title":"Creating a Parameter Block 1",
"href":"./files/GUID-A7B816A2-2220-433D-974E-77D27F0E8F9C.htm",
"description":"This topic describes how to create the now parameter blocks used in earlier versions of 3ds Max. The original parameter block 1 type is deprecated, but still supported for compatibility issues, and the parameter block 2 system should be used instead.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Parameter Block 1","href":"./files/GUID-9DD9300D-ABD2-415D-B719-6CD979611DB6.htm"}]},
{"title":"Loading Old Parameter Data using IParamBlock2",
"href":"./files/GUID-4C51A772-931F-4D58-8226-8A055FFD8DDF.htm",
"description":"If you have parameter data stored in the original parameter block format and want to upgrade to IParamBlock2 you can use the ParamBlock2PLCBclass (Parameter block 2 post-load call-back). An instance of this class is passed to ILoad::RegisterPostLoadCallback() to enable automatic conversion of old-parameter block versions of the plug-in. Developers give the constructor for this class a ParamVersionDesc array and the current block descriptor and it will load old parameter block objects into ParamBlock2 objects.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Parameter Block 1","href":"./files/GUID-9DD9300D-ABD2-415D-B719-6CD979611DB6.htm"}]},
{"title":"Advanced Parameter Block Topics",
"href":"./files/GUID-475F9E5A-0398-4BDE-A828-57FF553E239C.htm",
"description":"This section contains advanced topics related to parameter blocks.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"}]},
{"title":"Multiple Parameter Blocks",
"href":"./files/GUID-B0DEDB29-D397-42C0-BCC9-0F75E59703D2.htm",
"description":"A plug-in can have any number of parameter blocks. All the parameter blocks for that plug-in should be associated with the same class descriptor. This is accomplished by passing the same class descriptor object address to each parameter block descriptor constructor. For example:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Advanced Parameter Block Topics","href":"./files/GUID-475F9E5A-0398-4BDE-A828-57FF553E239C.htm"}]},
{"title":"Monitoring Parameter Changes",
"href":"./files/GUID-1F541F96-79DD-4F13-89CC-AF7A1ECEF8E8.htm",
"description":"Developers can monitor parameter changes using a call-back mechanism, by overriding the PBAccessor class. This allows continuous monitoring of the parameter change. PBAccessor has two methods PBAccessor::Get() and PBAccessor::Set(). In the bend modifier in the below example, the function Set() has been used to check the values of bend_from and bend_to.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Advanced Parameter Block Topics","href":"./files/GUID-475F9E5A-0398-4BDE-A828-57FF553E239C.htm"}]},
{"title":"Sub-Texture Map Parameters",
"href":"./files/GUID-2F96F8B4-816E-4391-A65E-4609C7063FF0.htm",
"description":"The P_SUBTEX parameter specification flag is used in materials or texture maps that contain other texture maps as parameters, in which these \'sub\' maps are not stored in the ParamBlock2 and are not accessible as direct references on the parent map or material, but are accessible via the MtlBase::GetSubTexmap() /MtlBase::SetSubTexmap() protocol.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Advanced Parameter Block Topics","href":"./files/GUID-475F9E5A-0398-4BDE-A828-57FF553E239C.htm"}]},
{"title":"Using Multiple Roll-ups",
"href":"./files/GUID-1D899F02-FB2B-4A61-A1AA-8DF52B6C6C27.htm",
"description":"The P_MULTIMAP flag in the parameter block descriptor indicates that the block being described will have more than one rollup. Here\'s a sample rework of the main parameter block in GeoSphere into two rollups:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Working with Plug-ins","href":"./files/GUID-C8636696-C2D8-43E4-8752-B85F104B2C6E.htm"},{"title": "Parameter Blocks","href":"./files/GUID-CC09846C-8115-46CF-8DC1-9C4F1A06991A.htm"},{"title": "Advanced Parameter Block Topics","href":"./files/GUID-475F9E5A-0398-4BDE-A828-57FF553E239C.htm"}]},
{"title":"Scenes and Nodes",
"href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm",
"description":"This section contains topics related to 3ds Max scenes, nodes, layers, containers, and asset management.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Scene File (Max File)",
"href":"./files/GUID-C8651C63-0B89-48EC-B963-F35D39DE3A30.htm",
"description":"In 3ds Max a three dimensional model -- including all associated objects, materials, properties, and modifiers -- constitutes the scene. The Max file format contains all information in a 3ds Max scene. This includes all of the objects, modifiers, materials, and controllers.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"}]},
{"title":"Scene Objects",
"href":"./files/GUID-BC8E3D03-720F-452B-BAC6-96C8C7043350.htm",
"description":"In C++ terminology an object is an instance of a class or struct type. In 3ds Max an object refers to a scene entity. Scene objects are represented in 3ds Max by instances of classes that derive from Object. Scene objects are associated with an INode object that manages an object\'s geometry, its transform controllers, assigned materials, assigned modifiers, and more using the reference system. Almost all scene objects are parameteric objects, that is their properties are exposed as parameters the user can control.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"}]},
{"title":"Scene Graph",
"href":"./files/GUID-6FBB60CC-4FD3-4021-AA48-3CB859382EE8.htm",
"description":"3ds Max scenes are organized internally as trees (directed acyclic graphs with single parents) of INodes. Every element of the scene corresponds to one or more node in the graph. Graph nodes are represented by INode objects. The root of the graph can be retrieved via the method Interface::GetRootNode(). The children of each node can be accessed using INode::NumberOfChildren() and INode::GetChildNode().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"}]},
{"title":"Nodes",
"href":"./files/GUID-E9CE05C0-1E31-4C15-8A44-AEDFBC951758.htm",
"description":"Every scene object in a 3ds Max scene is associated with a data structure known as a node. The node manages an object\'s geometry, transformation controllers, assigned materials, assigned modifiers, etc. Nodes also provide the building blocks for hierarchies, in which parent/child relationships are created by linking node to node. The 3ds Max tools that display nodes are Scene Explorer, Track View, and Schematic View.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"}]},
{"title":"Nodes and References",
"href":"./files/GUID-09A8606B-6AD4-44B2-8B85-64BA001C32FD.htm",
"description":"A node maintains at least six references that allow it to get notified when items that affect it change. These references are listed and defined below:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Nodes","href":"./files/GUID-E9CE05C0-1E31-4C15-8A44-AEDFBC951758.htm"}]},
{"title":"Node Parent / Child Relationships",
"href":"./files/GUID-4A6B07AA-D64A-45AE-AC20-FE8F925AF231.htm",
"description":"Nodes in 3ds Max can be linked to one another to form parent / child hierarchies. This is also called node linking. The 3ds Max SDK provides a developer with methods to work with this hierarchy via the INode class. A node that is linked to another node is referred to as a child node. A node that has children is referred to as a parent node. A node may have several children, but only a single parent.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Nodes","href":"./files/GUID-E9CE05C0-1E31-4C15-8A44-AEDFBC951758.htm"}]},
{"title":"Monitoring the Node Events",
"href":"./files/GUID-55DBA3E2-A9B1-43F4-9BC3-F9B80CB42E64.htm",
"description":"You can monitor the node events in a scene using one of these methods: Reference System – The reference system is an implementation of the subject-observer pattern. Objects (observers) that must be notified of changes to target objects (subjects) are called reference makers and are derived from the ReferenceMaker class. The target object is called the reference target and is derived from the ReferenceTarget class. Reference relationships are not represented by a specific class, but are managed by methods of the ReferenceMaker class. For example, if a node is deleted from the scene, the reference maker that references the deleted node will receive the REFMSG_TARGET_DELETED message through the ReferenceMaker::NotifyRefChanged() method, and it can respond appropriately to the node deletion event. Obtaining complete information about each node in a scene requires managing several references, which can be complex and in this case using one of the other alternative systems is recommended. See for more information. Scene Event System – The scene event system provides a simplified mechanism for monitoring all nodes in a scene simultaneously using the ISceneEventManager class. This system supports a broader range of messages than the other systems, but provides fewer details regarding single events. It is useful in situations that require high-level information about the node changes and where precision timing of messages is not a priority. For example, it is an ideal method to use for monitoring the scene to trigger a UI refresh. See ISceneEventManager class for more information Broadcast Notification System – The broadcast notification system uses callback functions when certain events occur. The header file notify.h contains the list of notification event IDs that can be handled. The following example shows how to handle a node deletion event by registering a notification callback with the broadcast notification system. When a node is deleted, the NOTIFY_SCENE_PRE_DELETED_NODE and NOTIFY_SCENE_POST_DELETED_NODE messages are sent with a callParam containing a Tab<INode*>. The following code snippet demonstrates how to register a callback to handle the NOTIFY_SCENE_PRE_DELETED_NODE message. //Declare the callback function static void NodeDeleteNotify(void *param, NotifyInfo *info) { // Get the nodes being deleted Tab<INode *> *tNode = (Tab<INode*>)(info->callParam); // Do custom processing ... } // Register the callback RegisterNotification(NodeDeleteNotify, this, NOTIFY_SCENE_PRE_DELETED_NODE); ... // When done, unregister the callback UnRegisterNotification(NodeDeleteNotify, this, NOTIFY_SCENE_PRE_DELETED_NODE); See for more information.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Nodes","href":"./files/GUID-E9CE05C0-1E31-4C15-8A44-AEDFBC951758.htm"}]},
{"title":"Getting the Nodes that Reference an Object",
"href":"./files/GUID-07609CE8-6A84-4E7E-AFF1-DF825620C382.htm",
"description":"Every object is referenced by one or more INodes. To find the first INode in the dependency graph that references an object by sending a reference message REFMSG_GET_NODE_HANDLE to its dependents using ReferenceTarget::NotifyDependents(). This will retrieve a handle of the first node that references the object. Using the method Interface::GetINodeByHandle() a node can then be retrieved.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Nodes","href":"./files/GUID-E9CE05C0-1E31-4C15-8A44-AEDFBC951758.htm"}]},
{"title":"Organizing Nodes",
"href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm",
"description":"Nodes (scene objects) can be organized using: groups, layers, named selection sets, xrefs, and containers. The various organization mechanisms are grouped as follows:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"}]},
{"title":"Node Grouping",
"href":"./files/GUID-4EEBA2E3-DA28-49D7-8984-A25F1DA6C7A4.htm",
"description":"A 3ds Max user can take a node in the scene and make it part of a group. Groups allow the user to select all the nodes in the group as one element without having to select each piece. Groups can be included in other groups so nesting can occur. INode::IsGroupMember() indicates whether a node is included in a group or not by returning TRUE if the node is in a group and FALSE if not.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"}]},
{"title":"XRef Scenes and Objects",
"href":"./files/GUID-5D94EE93-A11E-4E73-8488-CCFE32B17802.htm",
"description":"Scenes and objects can be stored in separate 3ds Max files, and referenced from a master file. This process is called external referencing or XRef for short. These XRef scenes and objects are loaded when the master file is loaded, but can not be modified from the master file.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"}]},
{"title":"Named Selection Sets",
"href":"./files/GUID-96311A8F-1BD0-427F-9DE4-5A10E3059EF3.htm",
"description":"Named selection sets, at the object level, are a mechanism by which nodes in a scenes can be grouped by a user. Named selection sets are made available to a user via the Named Selection Sets text field and drop-down list.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"}]},
{"title":"Layers",
"href":"./files/GUID-7281E9FC-D506-46D4-971B-735B8FEC1A7A.htm",
"description":"Layers in 3ds Max allow the user to group numerous scene objects together for easier workflow. Nodes contain information about what layers they are associated with. Accessing layer information in 3ds Max can be done in two methods:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"}]},
{"title":"Recovering an ILayer or ILayerProperties from an INode",
"href":"./files/GUID-96472F39-FBAC-44FB-A080-11EB6180B119.htm",
"description":"To get an ILayer pointer from an object you can call the method ReferenceMaker::GetReference() method on an INode object passing the value NODE_LAYER_REF.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"},{"title": "Layers","href":"./files/GUID-7281E9FC-D506-46D4-971B-735B8FEC1A7A.htm"}]},
{"title":"Iterating over Layers by Name",
"href":"./files/GUID-A64183C4-0B4D-442D-BD01-7C72EFE6B791.htm",
"description":"The ILayerManager class is an interface that manages all the scene layers in 3ds Max. A pointer to an ILayerManager singleton object can be obtained using the method Interace13::GetLayerManager().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"},{"title": "Layers","href":"./files/GUID-7281E9FC-D506-46D4-971B-735B8FEC1A7A.htm"}]},
{"title":"Iterating over Layers by Index",
"href":"./files/GUID-985B314A-E647-4D10-9778-F9B3544D0CA2.htm",
"description":"The IFPLayerManager class is also an interface class that manages scene layers in 3ds Max. This class however is a function published interface, and thus is quite different from the previously discussed layer manager. This class is the C++ interfaces to the MAXScript LayerManager class. This class has a useful method fro returning a layer by integer index. Thus you can iterate over scene layers without knowing the names of the layers. To get a pointer to this object you call the GetCOREInterface() function.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"},{"title": "Layers","href":"./files/GUID-7281E9FC-D506-46D4-971B-735B8FEC1A7A.htm"}]},
{"title":"Iterating over Nodes in a Layer",
"href":"./files/GUID-96530C73-D88A-482C-8C20-5ABC89DB52D9.htm",
"description":"Given a layer you can iterate over all of the nodes, by retrieving a pointer to an ILayerProperties interface and calling the method ILayerProperties::Nodes().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"},{"title": "Layers","href":"./files/GUID-7281E9FC-D506-46D4-971B-735B8FEC1A7A.htm"}]},
{"title":"Containers",
"href":"./files/GUID-D6533A05-C76A-4927-93D6-0A5467447BC1.htm",
"description":"Note: This topic discusses the container feature of 3ds Max and not the collection template classes Tab and Array which are sometimes referred to as container classes.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"}]},
{"title":"Container Manager and Container Objects",
"href":"./files/GUID-5DDB1898-1555-46E1-A0DB-5F7F068E010B.htm",
"description":"3ds Max provides a container manager object, represented by the class IContainerManager for working with containers. A pointer to the container manager object can be retrieved using the GetContainerManagerInterface() global function.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"},{"title": "Containers","href":"./files/GUID-D6533A05-C76A-4927-93D6-0A5467447BC1.htm"}]},
{"title":"Container Types",
"href":"./files/GUID-331C9A01-9450-40A6-B9D3-1ED636625558.htm",
"description":"There are two types of containers:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"},{"title": "Containers","href":"./files/GUID-D6533A05-C76A-4927-93D6-0A5467447BC1.htm"}]},
{"title":"Working with Containers",
"href":"./files/GUID-146294C1-96AA-4498-A42E-0E898812A414.htm",
"description":"It is possible to have objects linked to containers or contents of containers without being part of the container content, but this is not recommended.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Organizing Nodes","href":"./files/GUID-72985318-AF3F-4D45-8155-2E3E674849AE.htm"},{"title": "Containers","href":"./files/GUID-D6533A05-C76A-4927-93D6-0A5467447BC1.htm"}]},
{"title":"Assets",
"href":"./files/GUID-97E4F040-4DD8-4CD7-9B32-AF800BBE0BCD.htm",
"description":"An asset is a component of the scene that can be saved or loaded separately. An asset can include bitmap files, sound files, geometry files, and more. Examples of files that are not considered assets include configuration (.INI) files. Not all assets can be created directly from within 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"}]},
{"title":"Declaring and Representing Assets",
"href":"./files/GUID-EDCF7E94-BCFD-4994-9325-61AC4D2B70CF.htm",
"description":"The asset related data is represented by an object of type MaxSDK::AssetManagement::AssetUser which wraps asset specific data with a reference count and can be created in one of two ways:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Assets","href":"./files/GUID-97E4F040-4DD8-4CD7-9B32-AF800BBE0BCD.htm"}]},
{"title":"Saving and Loading Assets",
"href":"./files/GUID-FB01801F-4395-4EAE-AEFE-752A98D7415D.htm",
"description":"There are two methods of saving the asset data to a Max scene file:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Assets","href":"./files/GUID-97E4F040-4DD8-4CD7-9B32-AF800BBE0BCD.htm"}]},
{"title":"Enumerating and Exposing Assets",
"href":"./files/GUID-E585F488-60EE-4A24-95F1-AA1A01E5E9D4.htm",
"description":"In order to iterate over all assets in a scene the method Interface::EnumAuxFiles() should be used. To iterate over assets used by a particular animatable item in the scene use Animatable::EnumAuxFiles()).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Assets","href":"./files/GUID-97E4F040-4DD8-4CD7-9B32-AF800BBE0BCD.htm"}]},
{"title":"Asset File Path Resolution",
"href":"./files/GUID-50105419-69CD-4EF0-B96F-D59BBD46C743.htm",
"description":"All resolutions of asset files are performed through the MaxSDK::AssetManagement::AssetUser object which uses IFileResolutionManager. The IFileResolutionManager can also be used for resolutions of assets. File resolution is based on the asset file name and the asset type.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Assets","href":"./files/GUID-97E4F040-4DD8-4CD7-9B32-AF800BBE0BCD.htm"}]},
{"title":"Session Paths",
"href":"./files/GUID-16F02BF7-4634-4D14-91A8-936E9198B137.htm",
"description":"Session paths are a type of asset path. They function exactly the same as the paths seen in the Customize->Configure Paths dialog, \"External Files\" and \"XRefs\" tabs. However, session paths are not shown in the UI and are not saved. They exist only for the remainder of the 3ds Max session in which they are applied. They are used to specify a set of paths to be searched for assets and XRef\'d scene files.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Assets","href":"./files/GUID-97E4F040-4DD8-4CD7-9B32-AF800BBE0BCD.htm"}]},
{"title":"Custom Scene Data",
"href":"./files/GUID-493D378F-ADEE-46E5-9022-1D1F5F3F563F.htm",
"description":"There are three mechanisms that can be used by developers to create custom scene data. These are:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"}]},
{"title":"Custom Attributes",
"href":"./files/GUID-BEBCD9E4-49B5-42DA-BE6E-94C71AFBB541.htm",
"description":"Custom attributes are like custom parameters added by the user. Custom attributes are reference targets, and can be assigned to other parameters in the scene. Custom attributes behave like IParamBlock2 parameters in several ways:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Custom Scene Data","href":"./files/GUID-493D378F-ADEE-46E5-9022-1D1F5F3F563F.htm"}]},
{"title":"Custom User Properties",
"href":"./files/GUID-A4C49D13-929E-4629-958C-2CF44A958097.htm",
"description":"In addition to custom attributes another method of attaching data to a node is using custom user properties. This is data that a user can add and edit using the object properties dialog.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Custom Scene Data","href":"./files/GUID-493D378F-ADEE-46E5-9022-1D1F5F3F563F.htm"}]},
{"title":"Application Data",
"href":"./files/GUID-E88638A9-4217-4F17-AF99-230392FB3982.htm",
"description":"Application-specific data may be attached to any Animatable in the scene using application data chunks. Application data chunks are represented using AppDataChunk. With the related APIs any 3ds Max object (controller, object, node, modifier, material, etc.) can have custom data attached by other objects. These chunks are saved in the .MAX file and can be accessed through the object they are attached to.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Custom Scene Data","href":"./files/GUID-493D378F-ADEE-46E5-9022-1D1F5F3F563F.htm"}]},
{"title":"Common Scene Tasks",
"href":"./files/GUID-F840F9F8-1961-4C1B-87AE-A708EC328897.htm",
"description":"This topic contains a number of recipes for common programming tasks involving scenes and scene entitites.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"}]},
{"title":"Naming Scene Entities",
"href":"./files/GUID-CA181551-B6CB-40BE-9247-81D1C276C578.htm",
"description":"Certain scene entities (nodes, materials, layers, etc) have user visible names. Interface::MakeNameUnique() is the recommended way for creating new node names that are unique to the scene. The NameMaker class is best used to create unique names based on a set of \"root\" names used to initialize a NameMaker instance. A NameMaker can then be used to create unique names for any \"nameable\" scene entity.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Scenes and Nodes","href":"./files/GUID-59A06234-732F-469D-B2B0-FE1A00BF79BD.htm"},{"title": "Common Scene Tasks","href":"./files/GUID-F840F9F8-1961-4C1B-87AE-A708EC328897.htm"}]},
{"title":"Reference System",
"href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm",
"description":"The 3ds Max reference system is primarily a mechanism for scene objects and plug-ins to communicate. A reference between two objects models the subject-observer pattern.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"How Plug-ins Observe Reference Targets",
"href":"./files/GUID-C9A41E80-E441-40A6-8B8D-E05FCA597019.htm",
"description":"The primary use of the reference system for a plug-in is to allow it to observe 3ds Max entities derived from ReferenceTarget. To create references to a reference target a class must derive from ReferenceMaker, and override a number of functions. For more information see Writing Reference Makers.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Writing Reference Makers",
"href":"./files/GUID-1395FB57-C374-4DDF-B3E1-56492DBC27A4.htm",
"description":"Most plug-ins are reference makers (i.e. derived from ReferenceMaker). If a plug-in makes wishes to observe an object it is responsible for implementing functions from ReferenceMaker for managing the reference links and to respond to reference messages from the objects it references.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Writing Reference Targets",
"href":"./files/GUID-3BEC0107-9978-4A6D-9C56-82C4325C7026.htm",
"description":"Most plug-ins are reference targets (i.e. derived from ReferenceTarget) meaning that they can send notifications to observers.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Creating and Changing References",
"href":"./files/GUID-7E24736F-A323-4C47-AE1C-AD0B88DCD97F.htm",
"description":"The same mechanism is used for creating and changing (replacing) a reference. References from a reference maker to a reference target are created by first declaring a RefTargetHandle initialized to NULL, and then by calling ReferenceMaker::ReplaceReference() for each reference. The ReferenceMaker::ReplaceReference() method is also be used to reassign a reference instead of ReferenceMaker::SetReference().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Deleting References",
"href":"./files/GUID-E553C9A3-8B41-479A-9079-08A75290E934.htm",
"description":"The following methods are used to delete references when they are no longer needed:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Loading and Saving of References",
"href":"./files/GUID-03BDF963-01D3-4C53-B5CF-E679C4A90E2F.htm",
"description":"Reference links are loaded and saved to and from files automatically by 3ds Max. 3ds Max will call ReferenceMaker::GetReference() during the saving process and ReferenceMaker::SetReference() during the load process.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Reference Messages",
"href":"./files/GUID-72D88D95-77D1-4C4C-B711-48F5581C7E5D.htm",
"description":"A reference message is sent from a target to reference makers which maintain a direct reference (either strong or weak) to it. A reference message is represented by the type RefMessage. Reference messages are sent by a reference target in response to a call to ReferenceTarget::NotifyDependents(). The message is received by an observing reference maker in the method ReferenceMaker::NotifyRefChanged(). A plug-in will override this method to process messages received from any scene objects that it observes and depends on.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Handling Reference Messages",
"href":"./files/GUID-534585C7-0D55-44E4-ACDA-8343F9160DCF.htm",
"description":"3ds Max dispatches reference messages sent by reference targets to any dependent reference makers by calling ReferenceMaker::NotifyRefChanged(). A reference maker derived class (e.g. a plug-in) will provide a custom implementation of this function. The return result of ReferenceMaker::NotifyRefChanged() is a RefResult enumeration. Most of the time NotifyRefChanged() will return REF_SUCCEED.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Reference Messages","href":"./files/GUID-72D88D95-77D1-4C4C-B711-48F5581C7E5D.htm"}]},
{"title":"Viewing Reference Messages",
"href":"./files/GUID-65612C58-716F-4BF2-B1EB-EFB8C4D931A8.htm",
"description":"This section discusses a utility plug-in called the Reference Watcher. This plug-in is used to help understand the reference structure of a chosen item and to monitor the reference messages it sends. This provides a quick, visual way for developers to examine the use of references in 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Reference Messages","href":"./files/GUID-72D88D95-77D1-4C4C-B711-48F5581C7E5D.htm"}]},
{"title":"Kinds of References",
"href":"./files/GUID-1C8B981A-3E2D-450C-81CB-C2FA834730AF.htm",
"description":"The following lists the criteria for choosing what kind of reference to use:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Strong References",
"href":"./files/GUID-892B22A7-6D32-4849-BD75-31AE03A81EF8.htm",
"description":"In a strong reference the ReferenceMaker\'s implementation of ReferenceMaker::IsRealDependency() returns TRUE. The strong direct reference represents an ownership relationship. Ownership can be shared when multiple reference makers make strong references to a single reference target.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Kinds of References","href":"./files/GUID-1C8B981A-3E2D-450C-81CB-C2FA834730AF.htm"}]},
{"title":"Weak References",
"href":"./files/GUID-4B7A188A-0943-4A25-8057-FC068FA8BCCC.htm",
"description":"The weak direct reference represents simply the observer relationship with no additional semantics (e.g. lifetime management). Weak direct references do not prevent reference targets from being removed from a scene.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Kinds of References","href":"./files/GUID-1C8B981A-3E2D-450C-81CB-C2FA834730AF.htm"}]},
{"title":"Indirect References",
"href":"./files/GUID-3C953F29-2FAF-499A-82E6-8A62820F3DE6.htm",
"description":"An indirect reference from a reference maker to a reference target means that the reference maker contains a member reference member, which holds a direct reference to the target. Indirect references allow limited circular reference hierarchies. This could be useful, for example, if a script and expression controller variable points to a node, where the controller is under the node in the reference hierarchy.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Kinds of References","href":"./files/GUID-1C8B981A-3E2D-450C-81CB-C2FA834730AF.htm"}]},
{"title":"Node Monitors",
"href":"./files/GUID-E9BED1C4-D8D2-4757-9B4B-A82A0C6CCBEE.htm",
"description":"There are two classes that make it relatively easy to track changes to nodes (INode) via indirect references: INodeMonitor and INodeTransformMonitor. These classes are necessary to prevent circular references, and unnecessary propagation of reference messages. Both of these classes can be cast to ReferenceTarget.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Kinds of References","href":"./files/GUID-1C8B981A-3E2D-450C-81CB-C2FA834730AF.htm"},{"title": "Indirect References","href":"./files/GUID-3C953F29-2FAF-499A-82E6-8A62820F3DE6.htm"}]},
{"title":"Using Indirect References Instead of Pointers",
"href":"./files/GUID-955A2506-665C-4D4B-BBC1-02E22D021AC7.htm",
"description":"Using versions of the 3ds Max SDK prior to Version 8, when a developer needed to make a regular reference that would have led to a circular reference, there was no choice but to use a pointer to a node instead. Pointers are not managed by the Reference System and thus not stored properly to Max files. This meant that entities created by plugins that used node pointers would cause 3ds Max to crash when the plug-in data was XREF\'d and the XREF loaded. The only work-around was to avoid XREFing stored data for those plugins.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Kinds of References","href":"./files/GUID-1C8B981A-3E2D-450C-81CB-C2FA834730AF.htm"},{"title": "Indirect References","href":"./files/GUID-3C953F29-2FAF-499A-82E6-8A62820F3DE6.htm"}]},
{"title":"Indirect Reference Example",
"href":"./files/GUID-EA6355B8-588E-46F4-BB13-DF45979923B1.htm",
"description":"The following MAXScript code and diagram illustrate an example when a reference hierarchy would need to be circular. The MAXScript code creates a references that point upwards in the reference hierarchy using indirect references. A diagram of the various scene entities and their relationships follows. The dashed lines in the diagram represent indirect references. If these indirect references were assumed to be ordinary or strong references, code that followed the reference tree would find itself in an infinite loop.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Kinds of References","href":"./files/GUID-1C8B981A-3E2D-450C-81CB-C2FA834730AF.htm"},{"title": "Indirect References","href":"./files/GUID-3C953F29-2FAF-499A-82E6-8A62820F3DE6.htm"}]},
{"title":"Indirect References and Object XRefs",
"href":"./files/GUID-AEA9980B-6AE2-449C-A297-5E081990F3B0.htm",
"description":"Developers use Indirect References in situations where direct references would create circular references. This is done instead of using pointers so that when an object XRef is loaded, the references can be recreated correctly.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Kinds of References","href":"./files/GUID-1C8B981A-3E2D-450C-81CB-C2FA834730AF.htm"},{"title": "Indirect References","href":"./files/GUID-3C953F29-2FAF-499A-82E6-8A62820F3DE6.htm"}]},
{"title":"Managing Variable Number of References",
"href":"./files/GUID-76F2421C-B1CC-4650-9966-0708D0E6055B.htm",
"description":"Some plug-ins may need to manage a variable number of ReferenceTarget objects (e.g. references to other plug-ins). This should be done by creating an instance of the interface IRefTargContainer as follows:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Reference Hierarchy Functions",
"href":"./files/GUID-7D4F41E5-4C56-4CAA-A33A-FAE7B2F5809A.htm",
"description":"The following functions and classes perform operations on reference hierarchies. A reference hierarchy is a graph rooted at a particular reference maker.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Reference Object Lifetime Management",
"href":"./files/GUID-722BA7BC-C768-4FD7-900A-3A1D20FFA1BE.htm",
"description":"Objects managed by the 3ds reference system, are normally destroyed automatically when there are no more strong references to them. One exception to this are nodes (INode) which can be deleted by a user. Occasionally user code needs to destroy objects derived directly or indirectly from class Animatable, ReferenceMaker, or ReferenceTarget.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Reference System Common Tasks",
"href":"./files/GUID-A9C93EC6-6733-4064-A410-AFA7EE1F550D.htm",
"description":"This topic contains a number of recipes for common programming tasks involving the reference system.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Counting Observers of a Reference Target",
"href":"./files/GUID-616D24A9-F884-4980-A874-3E547019E7D2.htm",
"description":"The following code demonstrates how to count the number of reference makers that are directly observing a reference target.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Reference System Common Tasks","href":"./files/GUID-A9C93EC6-6733-4064-A410-AFA7EE1F550D.htm"}]},
{"title":"Cloning Reference Targets",
"href":"./files/GUID-0EDA8D31-013F-4895-A5FE-C5D97433F91C.htm",
"description":"If you wish to clone an object derived from ReferenceTarget you must use RemapDir::CloneRef() or ::CloneRefHierarchy() instead of ReferenceTarget::Clone(). This will correctly perform backpatching of references in the reference hierarchy. If backpatching is not performed, a reference graph can keep references to the original object, instead of to the copied object.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"},{"title": "Reference System Common Tasks","href":"./files/GUID-A9C93EC6-6733-4064-A410-AFA7EE1F550D.htm"}]},
{"title":"Guidelines for Changing the Reference Structure",
"href":"./files/GUID-095B4F6E-676D-4A7F-8B33-E8CF60C4F159.htm",
"description":"A plug-in can save a different reference structure than it exposes to 3ds Max at run-time (e.g. ReferenceMaker::GetReference(), ReferenceMaker::NumRefs()). You need to override the virtual function ReferenceMaker::SpecifySaveReferences() and use the ReferenceSaveManager parameter to describe the differences between its actual and to-be-saved reference structure as a series of add, remove and change operations. Changes to indirect references are also supported. A plug-in can also specify another version of plug-in to be saved instead of itself. There will be strict restrictions for changing the reference structure if the plug-in does not use the ReferenceSaveManager API. This will be discussed later.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Reference System","href":"./files/GUID-C11C8544-C5D5-4BA4-81A7-B00E8F508A03.htm"}]},
{"title":"Broadcast Notification System",
"href":"./files/GUID-6DB81A3D-6B5B-4BD5-81EC-077E5E30E264.htm",
"description":"The broadcast notification system is an alternative mechanism to the reference message system that calls callback functions when certain events occur. These are events such as the system unit settings changing, system time setting changing, or the user executing File/Reset, File/New, etc.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Modeling",
"href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm",
"description":"In 3ds Max there are two levels of editing and creation of objects.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Geometric Objects",
"href":"./files/GUID-7E9B4781-81D3-4756-B56C-23E3596217B3.htm",
"description":"A geometric object derives from the GeomObject class. A simple geometric object plug-in may derive from SimpleObject2 which derives from GeomObject. SimpleObject2 provides default implementations of many of the common virtual functions that must be implemented by a geometric object plug-in.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"}]},
{"title":"How Objects are Drawn in the Viewport",
"href":"./files/GUID-E8EE1B69-6596-4BC1-A92F-6E334633BC3E.htm",
"description":"The following steps describe how a simple object is drawn in the viewport.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometric Objects","href":"./files/GUID-7E9B4781-81D3-4756-B56C-23E3596217B3.htm"}]},
{"title":"Local Space versus World Space",
"href":"./files/GUID-7F48C13E-7FCA-4B5D-953C-72E6A9F95D14.htm",
"description":"Every object has modifiers applied to it using its own local coordinate system (local space). The representation of the object displayed in the 3ds Max viewport is in world space.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometric Objects","href":"./files/GUID-7E9B4781-81D3-4756-B56C-23E3596217B3.htm"}]},
{"title":"Deformable Objects",
"href":"./files/GUID-B37540A0-5623-4D8B-98AA-B7FCE27A040C.htm",
"description":"A deformable object is an object with modifiable points that flows through the pipeline. It is not a separate type, but rather is an instance of the Object type that will return TRUE to the Object::IsDeformable() method. Deformable objects must support the following Object methods: Object::NumPoints(), Object::GetPoint(), Object::SetPoint(), and Object::Deform().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometric Objects","href":"./files/GUID-7E9B4781-81D3-4756-B56C-23E3596217B3.htm"}]},
{"title":"Mappable Objects",
"href":"./files/GUID-EBC8D004-FBB0-425C-8EEA-B1FCD0D68FA6.htm",
"description":"A mappable object is not a separate type, but is an instance of an Object type that implements the method Object::ApplyUVWMap() and returns true from the Object::IsMappable() method.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometric Objects","href":"./files/GUID-7E9B4781-81D3-4756-B56C-23E3596217B3.htm"}]},
{"title":"Geometry Pipeline System",
"href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm",
"description":"3ds Max uses a system called a pipeline to manage the transformation of scene objects by processing objects called modifiers. Each INode in a scene graph has its own pipeline. The input of a pipeline is called the base object (an object that inherits from Object) and the output is called the derived object. If there are modifiers in the pipeline the output object will inherit from DerivedObject otherwise it will be the same object as was input into the pipeline.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"}]},
{"title":"Pipeline Overview",
"href":"./files/GUID-A47BAC47-34AB-49BE-A8CF-1BB9162F0041.htm",
"description":"This topic describes the 3ds Max pipeline architecture in high-level terms.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Pipeline Terminology",
"href":"./files/GUID-78A4F404-3912-4610-BA66-60DE1A82DAE7.htm",
"description":"The following terms have specific meanings within the context of the geometry pipeline system:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Object State",
"href":"./files/GUID-7E411D49-490D-42FB-B78E-8302FDF631C8.htm",
"description":"The object state object, represents the data that flows through the pipeline. When the Object::Eval() method is called on an object or a derived object, it returns an ObjectState. This is passed from one object reference to the next. The ObjectState contains the following elements:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Object State Transformation Matrix",
"href":"./files/GUID-4C8E39BA-219D-4EC6-B60E-A677656C865A.htm",
"description":"An ObjectState object maintains a transformation matrix as it flows up the pipeline. This matrix starts as the identity matrix. The following steps describe what happens to an object state transformation matrix as it flows through the pipeline.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Viewport Rendering and the Pipeline",
"href":"./files/GUID-1DFE5FC8-235C-4FE3-B56E-187669247CA3.htm",
"description":"This topic provides a simplified view of how the viewport interacts with the scene graph and requests objects to flow up through the pipeline, for the case of simple viewport rendering of the scene.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Pipeline Optimizations",
"href":"./files/GUID-1864E9AE-2807-4FAC-BC77-367F77C98DE4.htm",
"description":"The geometry pipeline system uses a number of optimization techniques to reduce the amount of processing necessary:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Objects Flowing through the Pipeline",
"href":"./files/GUID-224605DD-180C-4A1D-906A-517600E31C29.htm",
"description":"An object flows down the pipeline if a modifier accepts it by indicating its Class_ID in the Modifier::InputType() method.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Primitive Pipeline Objects",
"href":"./files/GUID-C3134765-D14D-4368-A6D8-31808BD4AB69.htm",
"description":"The following 3ds Max objects are designed to flow down the pipeline:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"},{"title": "Objects Flowing through the Pipeline","href":"./files/GUID-224605DD-180C-4A1D-906A-517600E31C29.htm"}]},
{"title":"Objects without Geometry in the Pipeline",
"href":"./files/GUID-938E9345-A737-46AA-98A0-CD00CA7C86D1.htm",
"description":"Some objects do not have a geometry (i.e. they have no deformable points), such as the camera object or light object, but can still flow through the pipeline. In cases where an object has no deformable points, the object state transformation matrix is used to represent the transformation, which is then applied to the object\'s gizmo. See the topic Object State for more information.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"},{"title": "Objects Flowing through the Pipeline","href":"./files/GUID-224605DD-180C-4A1D-906A-517600E31C29.htm"}]},
{"title":"Writing Pipeline Compatible Objects",
"href":"./files/GUID-BE8C6A52-57E0-4FD4-979F-99F34F7597C1.htm",
"description":"The simplest way to design a new plug-in object so that it can flow through the pipeline is to allow it to be converted to one of the commonly supported pipeline objects such as TriObject. For more information see Converting Object Types.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"},{"title": "Objects Flowing through the Pipeline","href":"./files/GUID-224605DD-180C-4A1D-906A-517600E31C29.htm"}]},
{"title":"Object Space and World Space",
"href":"./files/GUID-1C851D1B-1C8A-468A-BE93-306C8E185EF3.htm",
"description":"The geometry pipeline has three main components:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Cache System",
"href":"./files/GUID-4B8FAE08-DD17-4D87-9195-0F9C95BA9FC8.htm",
"description":"To maximize the speed with which 3ds Max evaluates the state of a node, it maintains a cache for each node in the scene that describes it appearance in world space. This world space cache is the product of the node\'s geometry pipeline. It reflects the state of the object in world space after all modifiers have been applied to it. Along with the cache, the system maintains a validity interval that indicates the period of time over which the cache accurately reflects the state of the node.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Cache Validity Intervals",
"href":"./files/GUID-459F0C3B-E1B7-410F-8019-43E9914A7C44.htm",
"description":"The object flowing down the pipeline is responsible for storing validity intervals for each channel. The validity interval is used by 3ds Max to know whether or not it can use the world space cache.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Object Locking",
"href":"./files/GUID-5F324358-E308-423B-B2BF-D583A42C4602.htm",
"description":"3ds Max uses a set of \'locks\' that indicate when it is not okay to free memory or modify the objects. The object lock and channel lock methods are both implemented and called by the system. The plug-in developer implements methods to maintain validity intervals for the channels, create new copies of channels as needed, and free the memory associated with channels that are no longer needed. Again, the main purpose of this is to minimize the overhead of the object flowing down the pipeline.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"World Space Modifiers and Object Transformations",
"href":"./files/GUID-2E4E41D4-1B52-48C8-8ABA-3D3C9910CB2C.htm",
"description":"When world space modifiers are applied to an object the points of the object may have already been transformed into world space. In this case, the points should not be transformed into world space again when they are drawn.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Channels",
"href":"./files/GUID-2A40CE07-BCB7-4ED5-9117-3C377172FACE.htm",
"description":"A channels represents a subset of an object\'s properties. This is used to optimize processing performed by the geometry pipeline system by minimizing the amount of processing that must be performed by each modifier.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"}]},
{"title":"Channel Locking",
"href":"./files/GUID-A7E06FDD-14D1-449B-92E9-6F9A8B035F51.htm",
"description":"Certain channels within an object can be locked instead of the whole object itself. For example, once a modifier is applied it may have the geometry channel cached (such as an array of vertices cached somewhere in the pipeline). When the system is evaluating this pipeline, if a certain channel it requires is cached, instead of evaluating the rest of the pipeline, it will use the cache. It will do a shallow copy of the cached channel into the object going down the pipeline. This is just copying the pointer to the cached channel into the object flowing down the pipeline. So essentially there are two TriObjects whose geometry channels are both pointing to the same array of vertices. This reduces the memory overhead required because instead of copying the whole array of vertices two meshes share the same memory. 3ds Max takes care of all of this, keeping track of who owns what so nothing is deleted twice or deleted when in use.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"},{"title": "Channels","href":"./files/GUID-2A40CE07-BCB7-4ED5-9117-3C377172FACE.htm"}]},
{"title":"Channel Copying",
"href":"./files/GUID-D54BC476-3B77-410D-9198-89A54CE23646.htm",
"description":"When an object flows through the geometry pipeline a shallow copy is made of the object, also called the shell. This shallow copy contains a full copy of modified channels and a shallow copy of unmodified channels, in order to optimize the memory footprint and performance.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"},{"title": "Channels","href":"./files/GUID-2A40CE07-BCB7-4ED5-9117-3C377172FACE.htm"}]},
{"title":"Preparing Channels for Modification",
"href":"./files/GUID-34562C0B-9E35-48C1-A35A-7073F7A179C4.htm",
"description":"At certain times the system must ask the plug-in object to prepare certain channels for modification. However, a channel that is locked should not be modified.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Geometry Pipeline System","href":"./files/GUID-B00C3E5E-A6A9-4F7C-B163-E139AB5FD55E.htm"},{"title": "Channels","href":"./files/GUID-2A40CE07-BCB7-4ED5-9117-3C377172FACE.htm"}]},
{"title":"Modifiers",
"href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm",
"description":"Modifiers apply a transform to a representation of a scene object\'s state. An ordinary modifier is sometimes referred to as an object space modifier.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"}]},
{"title":"Modifier Channels",
"href":"./files/GUID-5E90979F-C015-43A9-9B40-6E6590833807.htm",
"description":"Objects flowing down the geometry pipeline are broken into separate channels. That is, the pipeline can operate on only portions of objects and not the entire thing as a whole. Some examples of channels that objects are broken into are the geometry portion (points), the topology portion (polygons or faces), the selection level of the object (object, face, vertex, etc.), and its texture coordinates. This allows the pipeline to operate more efficiently, by only copying the necessary data.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"}]},
{"title":"Modifier Types",
"href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm",
"description":"Modifiers are divided into three main categories",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"}]},
{"title":"Object Modifiers",
"href":"./files/GUID-523448AC-EB36-4341-AD45-2731298803EB.htm",
"description":"Most modifier types are object modifiers. Object modifiers are applied to objects in their own local transform space to modify them in some way. Deformations like Bend, Taper, and Twist are examples of Object Modifier plugins. Extrude and Surface are also object modifier plugins. Examples of object modifiers a developer might create are: surface modifier plugins to alter smoothing groups, texture coordinates, and material assignments.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"},{"title": "Modifier Types","href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm"}]},
{"title":"Geometry Modifiers",
"href":"./files/GUID-5C8BCBBE-1D99-4DC5-BCC6-367DD3732611.htm",
"description":"Geometry modifiers alter the points of an object. Examples include Bend, Taper, Twist, Spherify, and Wave. Note that points mean different things for different objects. For example, a Bend modifier may be applied to both a Cylinder object and a NURBS curve object. That\'s because they both have \'points\' that can be modified, although the nature of the \'points\' is quite different between them. Modifiers that operate on these generic points are said to operate on \'deformable\' objects. For more information see Deformable Objects.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"},{"title": "Modifier Types","href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm"},{"title": "Object Modifiers","href":"./files/GUID-523448AC-EB36-4341-AD45-2731298803EB.htm"}]},
{"title":"Material Modifiers",
"href":"./files/GUID-89BE8B8F-3EE4-476D-9F42-7FCE6C64191B.htm",
"description":"Material modifiers alter the material ID stored by the object. An example of this type of modifier is the Material Modifier implemented by the MatMod class in the file \\MAXSDK\\SAMPLES\\MODIFIERS\\SURFMOD.CPP.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"},{"title": "Modifier Types","href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm"},{"title": "Object Modifiers","href":"./files/GUID-523448AC-EB36-4341-AD45-2731298803EB.htm"}]},
{"title":"Selection Modifiers",
"href":"./files/GUID-7FFEA8C9-C940-448C-BECB-1CF79BD3BE4A.htm",
"description":"Selection modifiers alter the selection level of objects. An example is the Volume Select modifier which can be found at \\MAXSDK\\SAMPLES\\MODIFIERS\\SELMOD.CPP.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"},{"title": "Modifier Types","href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm"},{"title": "Object Modifiers","href":"./files/GUID-523448AC-EB36-4341-AD45-2731298803EB.htm"}]},
{"title":"Simple Modifiers",
"href":"./files/GUID-0FD03141-9F9C-4C76-8B9C-DC78C34EC70C.htm",
"description":"A simple modifier is a special case of a geometry modifier. Simple modifiers can derive from SimpleMod2 instead of Modifier and will have fewer methods to implement. The Bend modifier example is derived from SimpleMod2.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"},{"title": "Modifier Types","href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm"},{"title": "Object Modifiers","href":"./files/GUID-523448AC-EB36-4341-AD45-2731298803EB.htm"}]},
{"title":"Topology Modifiers",
"href":"./files/GUID-2DC54FCD-70DA-4D92-98EC-ED451DE3B606.htm",
"description":"Topology modifiers alter the face or polygon structures of the objects they are applied to. Smoothing groups and materials are also part of the topology channel. Edge visibility is also part of this channels since it is an attribute of the face structure. The face normals are also part of the topology channel. The example below is from the Normals modifier which allows the user to unify and flip the face normals of a mesh. The full source code is available in \\MAXSDK\\SAMPLES\\MODIFIERS\\SURFMOD.CPP.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"},{"title": "Modifier Types","href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm"},{"title": "Object Modifiers","href":"./files/GUID-523448AC-EB36-4341-AD45-2731298803EB.htm"}]},
{"title":"Whole Object Modifiers",
"href":"./files/GUID-E6124BBF-2110-4B28-812E-B36A824BBBF7.htm",
"description":"Whole object modifiers that don\'t alter any parts of the object, instead they completely replace an object with a new object. Examples of this are the Extrude and Lathe modifiers. Both Extrude and Lathe convert a spline object into a mesh, patch or NURBS object, completely replacing the entire object. The full source code for Extrude is available in \\MAXSDK\\SAMPLES\\MODIFIERS\\EXTRUDE.CPP.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"},{"title": "Modifier Types","href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm"},{"title": "Object Modifiers","href":"./files/GUID-523448AC-EB36-4341-AD45-2731298803EB.htm"}]},
{"title":"Edit Modifiers",
"href":"./files/GUID-8B4EDC29-B1F8-4AE4-94D3-74E8FC9B1645.htm",
"description":"Edit modifiers are used to convert objects into a specific format. For example, an Edit Mesh modifier allows objects that can convert themselves into triangle meshes to be edited as an editable triangle mesh object (TriObject). An Edit Patch modifier allows objects that can convert themselves into patches to be edited as a patch mesh (Patch).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"},{"title": "Modifier Types","href":"./files/GUID-7FD3776F-08B7-4058-BDF6-BBCE850B23C1.htm"}]},
{"title":"Modifier Compatible Types",
"href":"./files/GUID-815B3376-5A88-4779-A0FE-B302CC413694.htm",
"description":"In order for the modifier to inform 3ds Max what type of object it needs it implements the method Modifier::InputType(). This method returns the Class_ID of the type of object it needs for input. For example, the Edit Spline modifier implements this method as shown below:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"}]},
{"title":"Mapping Coordinate Modifiers",
"href":"./files/GUID-D1A4EFB9-3A41-495F-95DC-C36BA27F73FC.htm",
"description":"These modifiers alter the texture mapping coordinates of an objects. They can add new mapping coordinates to unmapped objects or modify the existing mapping coordinates of objects. A modifier that adds new mapping coordinates is the UVW Mapping Modifier. The full source code is available in \\MAXSDK\\SAMPLES\\MODIFIERS\\MAPMOD.CPP. Below are the implementations of InputType(), ChannelsUsed(), and ChannelsChanged().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"}]},
{"title":"Validity Intervals",
"href":"./files/GUID-08ACD4CF-CCBE-4E2B-AE56-319DA3B617AC.htm",
"description":"A validity intervals describes a range of time over which the modification preformed by the modifier is accurate. Many things in 3ds Max can be animated and thus change over time. Validity intervals allow 3ds Max to minimize redundant evaluations of modifications.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"}]},
{"title":"Modifier Stack Branching",
"href":"./files/GUID-02D143FD-0B9C-4C0C-BF65-6F28B7FDFDA5.htm",
"description":"This section discusses the concept of modifier stack branching. This section uses the Boolean object plug-in as an example. The SDK sample code for the Boolean object is available in \\MAXSDK\\SAMPLES\\OBJECTS\\BOOLOBJ.CPP.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"}]},
{"title":"World-Space Modifiers",
"href":"./files/GUID-DA7227A8-576A-4D3D-9254-4DFA1C49B08E.htm",
"description":"World space modifiers (WSM) affect objects in world space instead of in the object\'s local space like an ordinary modifier. A WSM is a combination of non-rendering object and modifier. A WSM affect other objects in the scene based on the position and orientation of the other objects that are bound to the object. For example, the Ripple Space Warp applies a sine wave deformation to objects bound to it. Other examples of WSMs include things like explosions, wind fields, and gravity.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"}]},
{"title":"Adding Modifiers to Objects",
"href":"./files/GUID-B41DC781-221E-4DE3-8AA1-EC3C2666FC5C.htm",
"description":"When a modifier is created using CreateInstance() it is then added using the function Interface7::AddModifier(). The following code demonstrates the process:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Modifiers","href":"./files/GUID-148A990F-7BEC-4117-AA1D-73CE7AB3C867.htm"}]},
{"title":"Meshes",
"href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm",
"description":"A mesh is a collection of primitive shapes (e.g. edges and vertexes) that represent the geometry of a scene object. There are two principal kinds of meshes: triangular meshes (Mesh) and polygon meshes (MNMesh). The triangular mesh is represented in the pipeline by a TriObject object and a polygon mesh is represented in the pipeline by a PolyObject.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"}]},
{"title":"Mesh Related Classes",
"href":"./files/GUID-BB6EAF7E-B97E-4FEA-808F-85CC27A25E21.htm",
"description":"Mesh - This is the main class for working with the mesh objects. It has data members that point to the vertices, faces, texture vertices, and texture faces. Methods are provided to access all propert",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Extracting the Mesh from a Node",
"href":"./files/GUID-B2693B67-F56D-4EEB-9FB8-19700D7BAB90.htm",
"description":"The INode::EvalWorldState() method should be called when a developer needs to work with an object that is the result of the node\'s pipeline. This is the object that appears in the scene. This may be an object that is not referenced - it may just be an object that has flowed down the pipeline.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Meshes and Materials",
"href":"./files/GUID-B16BC0C9-8331-4363-AC81-403CD3E48231.htm",
"description":"A material defines the meaning of how it acts upon a mesh. For example, the 3ds Max Multi-material uses the material ID assigned to each mesh face as indices into its list of sub-materials. In this way, the user may assign several materials to a single mesh object. The Mesh class provides methods to get and set the material ID assigned to a face.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Mesh Edges",
"href":"./files/GUID-2FDFD2CE-66DC-4EA9-8716-15C26F602C22.htm",
"description":"A regular 3ds Max mesh and consists of faces and vertices; it has no edge data members. Edge characteristics such as visibility and selection are referenced by face. For example, the Mesh::edgeSel data member has 3 * Mesh::numFaces members. Each set of three values edgeSel[i*3], edgeSel[i*3+1], and edgeSel[i*3+2] represent the selection of the three edges (going from vertex 0 to vertex 1, vertex 1 to vertex 2, and vertex 2 to vertex 0, respectively) of face i.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"MNMesh Edges",
"href":"./files/GUID-DDB4737C-FB54-4255-8E5C-F3039A386108.htm",
"description":"MNMesh like the regular Mesh class has no edge data members. Edge selection and visibility data must initially be stored in the MNFace members. Before a call MNMesh::FillInMesh() to there are no MNEdges to store them in. There are a number of methods in the library (and many more the developer could design) which would invalidate the topological data, rendering the MNEdge list invalid. Also, eventually, we\'re going to want to convert each MNMesh back into a regular mesh using the OutToTri() method, so it\'s convenient to store edge selection and visibility information in the faces for this purpose.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Computing Face Normals",
"href":"./files/GUID-889D4EDF-549A-4E63-B41B-F20B9C25E597.htm",
"description":"A face normal is a vector that defines which way a face is pointing. The direction that the normal points represents the front, or outer surface of the face. To compute the face normal of a face in a mesh you simply take the cross product of two edge vectors of the face. The following code shows how this is done using the 3ds Max API. It loops through each face in a mesh and stores the computed face normal in a table of Point3s named fnorms. At the end of the code, the DebugPrint() API is used to display each normal in the table to the debug window of the VC++ IDE.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Computing Vertex Normals",
"href":"./files/GUID-9B83270D-1D20-4613-AB35-5EE9832C162E.htm",
"description":"This section discusses the way vertex normals may be computed. Two algorithms are reviewed. The first ignores smoothing groups and returns an averaged normal at the vertex. The second one looks at the smoothing information and computes multiple normals when there are faces that have different smoothing groups that share a vertex.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Computing Vertex Normals by Weighting",
"href":"./files/GUID-0FCB4578-77F8-4F05-99CD-349E85F13639.htm",
"description":"This next section discusses two additional techniques that may be used in computing vertex normals. The first technique weights the normals by the vertex angle on each face. The second weights the normal using the area of each face.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Creating Pipeline-Friendly Meshes",
"href":"./files/GUID-6A540A58-1DF6-4B19-8344-809409DE6881.htm",
"description":"Developers should follow a few simple but important rules when building meshes to function ideally with modifiers in the Geometry Pipeline. The six basic rules are:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Vertex Color Information",
"href":"./files/GUID-8EC1B2A1-740E-422C-8154-718073563E82.htm",
"description":"Vertex color information is stored with a Mesh. This information can be used in conjunction with the vertex color map (\\MAXSDK\\SAMPLES\\MATERIALS\\VERTCOL.CPP) or the Color Per Vertex utility and modifier (\\MAXSDK\\SAMPLES\\UTILITIES\\APPLYVC\\APPLYVC.CPP and AVCMOD.CPP).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Mesh Stripping",
"href":"./files/GUID-CC0865A5-F9C4-4980-BE78-9C4F4EE4AC30.htm",
"description":"Stripping is the process of taking a mesh and turning it into all set of strips as shown below. Without stripping, when a triangle mesh is sent down the graphics display pipeline, three vertices plus three normals or colors must be sent for each triangle. However, in some cases triangles occur in a \'strip\', where one triangle points up, the next points down, then the next up, etc. forming parallel lines along the top and bottom.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Retrieving Mesh Strip Data",
"href":"./files/GUID-9F883E27-E0F2-405E-BCF2-347CE1D55EF7.htm",
"description":"The mesh strip data is accessible through the Mesh::strips member variable. This is declared as a StripTab which is a Tab<> collection of Strip pointers.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Hardware Mesh Support",
"href":"./files/GUID-EA25E0B4-313B-4CF0-8F52-73D764BB139F.htm",
"description":"Plug-ins can build a mesh that is meant only for display by the graphics window system (which may or may not use hardware acceleration). The hardware mesh can be displayed without having to use the Mesh or MNMesh classes. This means that they are considerably cheaper on memory usage since the objects don\'t need to be instantiated in order to display the mesh.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Texture Vertices and Texture Faces",
"href":"./files/GUID-C563D078-C7F6-4F5E-A3D3-6BF6676240D5.htm",
"description":"The mesh class keeps a pointer to a list of texture vertices in addition to its regular vertices which are allocated on a per-need basis. For example if mapping coordinates are assigned to the mesh then these extra vertices are allocated. These vertices are completely independent of the regular vertices in the mesh.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Meshes","href":"./files/GUID-031890D6-CF79-488C-A204-B512698DB106.htm"}]},
{"title":"Transformation and Rotation",
"href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm",
"description":"This section contains articles on transforming and rotating objects in a 3ds Max scene. There are two main transforms that affect an object: the node transform which is the result of the transform controller plus inheritance, and the object offset transform which positions the geometry relative to the pivot point.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"}]},
{"title":"Matrix Representations of 3D Transformations",
"href":"./files/GUID-E867B7CF-AE06-4CF7-B157-D00C300FB64A.htm",
"description":"3ds Max uses the Matrix3 class to represent transformation matrices. This section discusses the way transformation matrices are constructed and used in 3ds Max, and various APIs that are available for working with these matrices.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Matrix Fundamentals",
"href":"./files/GUID-14497600-0839-4225-BA52-B571FCC8AEBF.htm",
"description":"A matrix is a two-dimensional array of numbers. In 3ds Max, 4x3 matrices are used. For 3ds Max matrices, the first number is the number of rows (4) and the second number is the number of columns (3). Thus there are a total of 12 elements.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"},{"title": "Matrix Representations of 3D Transformations","href":"./files/GUID-E867B7CF-AE06-4CF7-B157-D00C300FB64A.htm"}]},
{"title":"Translation (Moving)",
"href":"./files/GUID-1A457B08-358F-4415-9AF1-4602BA3ED749.htm",
"description":"Translation matrices use the following matrix positions:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"},{"title": "Matrix Representations of 3D Transformations","href":"./files/GUID-E867B7CF-AE06-4CF7-B157-D00C300FB64A.htm"}]},
{"title":"Rotation",
"href":"./files/GUID-CE8990B4-14AA-4D8E-9C1F-DE1FAB3CB829.htm",
"description":"The cells in a rotation matrix are the sines and cosines of the angle of rotation. In the Matrix3 right-handed coordinate system, positive angles move in a counterclockwise direction, when looking down an axis from positive to negative. In the diagram below, the cones along the XYZ axes point in the positive direction, and the cones in the circles around each axis point in the positive direction of rotation.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"},{"title": "Matrix Representations of 3D Transformations","href":"./files/GUID-E867B7CF-AE06-4CF7-B157-D00C300FB64A.htm"}]},
{"title":"Scaling",
"href":"./files/GUID-5570512B-75ED-4D27-A572-30A77261E866.htm",
"description":"Scale transformations can be used, for example, to multiply each component of a vector by a scale factor. Scale transformations use the following matrix positions:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"},{"title": "Matrix Representations of 3D Transformations","href":"./files/GUID-E867B7CF-AE06-4CF7-B157-D00C300FB64A.htm"}]},
{"title":"A Matrix3 as an Axis System",
"href":"./files/GUID-4515BA8E-5465-438B-B8A7-E93F4B591B7E.htm",
"description":"A Matrix3 can also be used to specify an axis system. For example, the INode method Rotate() is used to rotate a node about a specified axis system. One of the arguments to this method is a Matrix3 that specifies this axis system. Essentially, a matrix is just an axis system.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"},{"title": "Matrix Representations of 3D Transformations","href":"./files/GUID-E867B7CF-AE06-4CF7-B157-D00C300FB64A.htm"}]},
{"title":"Rotation Concepts",
"href":"./files/GUID-1A3AABDC-56AB-47BA-87AA-94DF354FD5B2.htm",
"description":"This section describes the different ways rotation is represented in the 3ds Max SDK and the various classes used in storing and interpolating rotation.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Euler Angles",
"href":"./files/GUID-E16B428A-2340-4090-BBD5-C2BF78A31136.htm",
"description":"Multiple rotations are not independent. When you rotate something twice, the second rotation rotates the first rotation. For this reason, the order of rotation is important. The 3ds Max Euler angle controller, by default, has an XYZ ordering. That is, the first rotation is done along the X axis, then along the Y axis, and finally along the Z axis. In other words, the default Euler angle controller has a type of EULERTYPE_XYZ (described below). The 3ds Max local Euler angle controller is similar, but specifies rotations around an object\'s local coordinates instead of the world coordinates. It has a type of (EULERTYPE_XYZ | EULERTYPE_RF).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"},{"title": "Rotation Concepts","href":"./files/GUID-1A3AABDC-56AB-47BA-87AA-94DF354FD5B2.htm"}]},
{"title":"Handling Sign Flips when Converting a Rotation Controller to an Euler Controller",
"href":"./files/GUID-909437E1-F7E7-465F-A70E-AD4290469688.htm",
"description":"When converting any rotation controller to an Euler controller it is possible for sign flips to occur in the resulting animation. This is due to the fact that one single rotation matrix can be expressed through many different triplets of Euler angles. Sometimes the produced Euler angles are not interpolatable. There is code in the SDK which solves this problem. It samples the whole animation range and produces Euler angles that result in the same animation as the original, if interpolated. This code is generally valuable for developers who want to convert keys of any type of 3ds Max controller that uses quaternions internally into a Euler angle keys (for example an export plugin).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"},{"title": "Rotation Concepts","href":"./files/GUID-1A3AABDC-56AB-47BA-87AA-94DF354FD5B2.htm"}]},
{"title":"Node Transformations",
"href":"./files/GUID-7BFC8DCE-5D43-4C7C-8C44-C65E8E793F0E.htm",
"description":"All transformations are represented as Matrix3 objects. The node maintains two transformations:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Transform Center (Pivot Point)",
"href":"./files/GUID-A610BB7B-D8E7-4E95-A0A3-549A0A8CFFC0.htm",
"description":"The transform center, or pivot point, is the location about which a rotation takes place, or to and from which a scale occurs. All nodes in 3ds Max have a pivot point. You can think of the pivot point as representing a node\'s local center and local coordinate system.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Node Transformation Matrix",
"href":"./files/GUID-781B9B7F-4EA1-490A-9CA3-0EDCED94E65A.htm",
"description":"The INode::GetNodeTM() method may be used to get the node transformation matrix. This method returns the world space transformation matrix of the node at the specified time. This matrix contains the node\'s controller transformation and the parent node\'s transformation. This matrix does not include the object-offset transformation, or any world space modifier (Space Warp) effects.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Object Transformation Matrix",
"href":"./files/GUID-856D0F6E-8F0F-4991-BB92-F0FB916BAF1A.htm",
"description":"This INode::GetObjectTM() returns the transformation matrix the object needs to be multiplied by to transform it into world space. It is dependent on the context when it is called -- it will either be equal to INode::GetObjectTMAfterWSM() or INode::GetObjectTMBeforeWSM().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Local Transformation Matrix",
"href":"./files/GUID-6FA37CAE-61A9-4864-87B0-BA6EC7EBBA32.htm",
"description":"To retrieve the local transformation matrix of a node (the transformation of a node relative to its parent) you must perform some matrix arithmetic on the node\'s world space transformation matrix. This is because 3ds Max does not store the local transformation matrix.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Object Offset Transformation",
"href":"./files/GUID-FDBE6AA6-36D2-47CB-81D7-BB8DE867E306.htm",
"description":"The object offset transformation provides an offset of the geometry of an object from its node. This section describes the object offset transformation and its function in 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Transforming Linked Nodes",
"href":"./files/GUID-B0F5A088-38A4-4D10-BB15-E1FDF1684485.htm",
"description":"When a parent-child link between nodes is created, the user will not want the nodes in the scene to move. To ensure that the nodes won\'t move, the transform controllers of the nodes need to be modified. This is because the reference coordinate system has changed. The transform controller is working in a coordinate system which is its parent\'s coordinates system.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Using the Node and Object Offset Transformations",
"href":"./files/GUID-B0C44B18-00A4-452D-96FC-1FBF969D68A0.htm",
"description":"The following code is from the Reset Transform utility (\\MAXSDK\\SAMPLES\\MODIFIERS\\RESETTM.CPP). This utility is used to push object rotation and scale values onto the Modifier Stack and align object pivot points and bounding boxes with the world coordinate system. Reset Transform removes all rotation and scale values from selected objects and places those transforms in an XForm modifier. The code below demonstrates the use of the node transformation and object offset transformations discussed above.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Transform Controller Coordinate Systems",
"href":"./files/GUID-1312CA59-FA87-4825-A828-1D37A0F41B11.htm",
"description":"A controller can be thought of as operating internally within its own local coordinate system. For both keyframe and procedural controllers, the data generated is provided in the local space of the controller. It is not until the controller supplies its transformation to 3ds Max does the coordinate system become relative to anything other than the controller itself.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"PRS Controllers and Node Transformation Matrices",
"href":"./files/GUID-C65B4816-5988-4905-889D-FA310F456F8B.htm",
"description":"This topic describes how 3ds Max constructs the node transformation matrix for the point rotation scale (PRS) controller.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Emulating Reset Transform and Reset Scale",
"href":"./files/GUID-EEBC2DB2-2660-4E84-B2D0-8AF63A2B1FD0.htm",
"description":"The 3ds Max user interface provides users with an Adjust Transform rollout which can be used to reset transform or reset scale.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Transformation and Rotation","href":"./files/GUID-62FCAAB5-1499-4D23-A5CB-05E3209CDC55.htm"}]},
{"title":"Shapes and Splines",
"href":"./files/GUID-BCB9E9C7-6F89-4F26-BAAB-76233EFD086A.htm",
"description":"A shape is an object made from one or more curved or straight lines. A spline is a kind of a shape, based on a polynomial function.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"}]},
{"title":"Shape and Spline Principal Classes",
"href":"./files/GUID-D5939588-DF80-4161-9221-B1C407D4B52A.htm",
"description":"The following are the main classes used when working with shapes and splines:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Shapes and Splines","href":"./files/GUID-BCB9E9C7-6F89-4F26-BAAB-76233EFD086A.htm"}]},
{"title":"Calling CopyBaseData()",
"href":"./files/GUID-88664883-105D-4B12-AA90-368BD66FDE41.htm",
"description":"The ShapeObject class has a method, ShapeObject::CopyBaseData(), which is used by derived classes to make sure that, when they copy themselves, they are also copying the data in the ShapeObject. This is usually used in the assignment operator of derived classes. It is also used in the ShallowCopy method of objects that are passed up the modifier pipeline. In this case, it is vital that you surround all calls to ShapeObject::CopyBaseData() with calls to Hold::Suspend() and Hold::Resume().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Shapes and Splines","href":"./files/GUID-BCB9E9C7-6F89-4F26-BAAB-76233EFD086A.htm"}]},
{"title":"Creating a Spline",
"href":"./files/GUID-74F32177-890A-4741-A0AC-C2F070D6BC1C.htm",
"description":"Below is a section of code from the Circle plug-in. This plug-in is derived from class SimpleSpline. This code demonstrates the key methods used in building a shape. The method SimpleSpline::BuildShape() is called to build the shape at the specified time and store the results in ashape.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Shapes and Splines","href":"./files/GUID-BCB9E9C7-6F89-4F26-BAAB-76233EFD086A.htm"}]},
{"title":"Capping a Shape with a Mesh",
"href":"./files/GUID-030D8098-C9FE-4628-8EEC-3D09204433D3.htm",
"description":"This section discusses the capping of shapes using a mesh. The SDK provides tools for easily creating these mesh caps for shapes.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Shapes and Splines","href":"./files/GUID-BCB9E9C7-6F89-4F26-BAAB-76233EFD086A.htm"}]},
{"title":"Capping a Shape with a Patch",
"href":"./files/GUID-56BFA0DE-977C-402D-9198-8A41EAF680C6.htm",
"description":"This section discusses the capping of shapes with patches. This is very similar to the mesh capping discussed above.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Shapes and Splines","href":"./files/GUID-BCB9E9C7-6F89-4F26-BAAB-76233EFD086A.htm"}]},
{"title":"Patches and Faces",
"href":"./files/GUID-C69CF322-EA82-4E4C-802B-B7B9E0D5298F.htm",
"description":"This section provides an overview of how to work with Patches. It covers the main classes used when working with patches, and an example of creating a patch mesh.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"}]},
{"title":"Principal Classes",
"href":"./files/GUID-EAFE06C7-AA20-4BD1-B94E-5F14B0778D36.htm",
"description":"The SDK provides the following classes for creating and manipulating patch objects.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Patches and Faces","href":"./files/GUID-C69CF322-EA82-4E4C-802B-B7B9E0D5298F.htm"}]},
{"title":"Creating a Patch",
"href":"./files/GUID-F0911DA8-16A0-459E-B016-1A8476ABB64F.htm",
"description":"A good sample to look at to see how patches are created is the patch grid plugin. The source code is in\\MAXSDK\\SAMPLES\\OBJECTS\\PATCHGRD.CPP.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Patches and Faces","href":"./files/GUID-C69CF322-EA82-4E4C-802B-B7B9E0D5298F.htm"}]},
{"title":"Patch Interpolation",
"href":"./files/GUID-DC7020E1-76F4-4A9B-8866-7483BDEDFA59.htm",
"description":"The patch system supports any combination of quadrilateral and triangular patches, as long as they are set up so that a single edge is only shared by at most two patches.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Patches and Faces","href":"./files/GUID-C69CF322-EA82-4E4C-802B-B7B9E0D5298F.htm"}]},
{"title":"Patch Interpolator Example",
"href":"./files/GUID-18C24D3C-1621-41B3-AAA2-0A092BFCAABE.htm",
"description":"The following is source code for a triangular and quadrilateral patch interpolator",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Patches and Faces","href":"./files/GUID-C69CF322-EA82-4E4C-802B-B7B9E0D5298F.htm"},{"title": "Patch Interpolation","href":"./files/GUID-DC7020E1-76F4-4A9B-8866-7483BDEDFA59.htm"}]},
{"title":"Patch Code Example",
"href":"./files/GUID-AD58CBA6-4AE1-4225-8602-E1F54B461044.htm",
"description":"Below is some sample code that shows the interpolation of the surface points, the book keeping code for shared edges, the construction of the mesh faces, the handling of texture vertices and faces, and how bind patches are handled.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Patches and Faces","href":"./files/GUID-C69CF322-EA82-4E4C-802B-B7B9E0D5298F.htm"}]},
{"title":"Working with NURBS",
"href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm",
"description":"This section presents an overview of working with NURBS using the SDK. It defines some terms and concepts related to NURBS, describes the main classes used, provides an overview of some key concepts when using NURBS, and discusses the sample code available in the SDK. There is also a section of reference information for some global functions available.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"}]},
{"title":"NURBS Terminology",
"href":"./files/GUID-B2367ED2-E5E0-499C-90C8-7263CBBD2B1B.htm",
"description":"This section provides definitions of various terms used later in this topic and in the NURBS classes.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"The NURBS API",
"href":"./files/GUID-A7C80273-737D-41B2-9618-E86B127C643B.htm",
"description":"The NURBS API provides an interface into the NURBS objects used by 3ds Max. Unlike much of the 3ds Max API, the NURBS objects 3ds Max provides don\'t use this API. Rather, the NURBS API has been added to allow developers to access the NURBS objects 3ds Max uses internally. Using the API developer can create new NURBS objects or modify existing ones.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"Overview of the Principal NURBS Classes",
"href":"./files/GUID-1A2B6570-8AC0-408A-95C6-159A1A294A62.htm",
"description":"This section introduces the NURBS classes.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"NURBS Base Classes",
"href":"./files/GUID-413A7F8A-5F85-4BCE-B416-0B2732B84A77.htm",
"description":"The following two classes are used as the principal two base classes for NURBS objects.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"},{"title": "Overview of the Principal NURBS Classes","href":"./files/GUID-1A2B6570-8AC0-408A-95C6-159A1A294A62.htm"}]},
{"title":"NURBS Point Classes",
"href":"./files/GUID-06E8C00C-E2C6-408E-B4CC-B740CF6739AA.htm",
"description":"Independent Points: Independent points are those that don\'t rely on other objects to define their location. This is different than the dependent (or constrained) points described later. NURBSPoint",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"},{"title": "Overview of the Principal NURBS Classes","href":"./files/GUID-1A2B6570-8AC0-408A-95C6-159A1A294A62.htm"}]},
{"title":"NURBS Curve Classes",
"href":"./files/GUID-F8F061E3-0B7D-4831-AAED-564D421941D3.htm",
"description":"Independent Curves The following classes provide the ability to create independent curves. NURBSCurve - This base class describes the properties of a NURBS curve. This includes its open/closed sta",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"},{"title": "Overview of the Principal NURBS Classes","href":"./files/GUID-1A2B6570-8AC0-408A-95C6-159A1A294A62.htm"}]},
{"title":"NURBS Surface Classes",
"href":"./files/GUID-D1FE6E27-53D7-4EDA-B328-E51C3749DC96.htm",
"description":"Independent Surface Classes NURBSSurface - This base class describes the properties of a NURBS surface. This includes its material ID, texture/tiling options, renderable state, and open/closed state",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"},{"title": "Overview of the Principal NURBS Classes","href":"./files/GUID-1A2B6570-8AC0-408A-95C6-159A1A294A62.htm"}]},
{"title":"NURBS Texture Mapping",
"href":"./files/GUID-6D0C94AE-6F60-4CCE-BB8D-60C64E4B5138.htm",
"description":"The following classes are those involved in texture mapping NURBS surfaces. There may be 99 texture channels assigned to each surface.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"},{"title": "Overview of the Principal NURBS Classes","href":"./files/GUID-1A2B6570-8AC0-408A-95C6-159A1A294A62.htm"}]},
{"title":"Using the API to Create and Modify 3ds Max NURBS Models",
"href":"./files/GUID-1B37E868-DEE5-4974-B13F-E4A3491D2A3A.htm",
"description":"As mentioned above, 3ds Max itself uses a different internal representation of NURBS objects than the API does. The API is simply a means to access these internal 3ds Max NURBS objects and allow them to be manipulated.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"Accessing Details of NURBS Objects",
"href":"./files/GUID-502AE095-1CB1-45F6-BE4F-784B1862C658.htm",
"description":"Developers that need to access that internal of 3ds Max NURBS objects can see the following methods to get at details such as knot counts, CV counts, order, weight and position data. The main call is GetNURBSSet() with the argument Relational set to FALSE. This will fill in the NURBSSet with the surfaces, curves and independent points of the object passed. The surfaces will all be NURBSCVSurface\'s and the curves will all be NURBSCVCurve\'s. These can be retrieved from the NURBSSet with: NURBSSet::GetNumObjects() and NURBSSet::GetNURBSObject().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"NURBS Curve Continuity",
"href":"./files/GUID-2C018F82-1A88-4077-B6E7-49953BDD8E85.htm",
"description":"There are different levels of continuity. A curve with an angle or cusp in it is C0 continuous -- that is, the curve is continuous but has no derivative at the cusp. A curve with no such cusps but whose curvature changes is C1 continuous. Its derivative is also continuous, but its second derivative is not. A curve with uninterrupted, unchanging curvature is C2 continuous. Both its first and second derivatives are also continuous. A curve can have still higher levels of continuity, but for computer modeling these three are adequate. Usually the eye can\'t distinguish between a C2 continuous curve and one with higher continuity. Continuity and degree are related. A degree 3 equation can generate a C2 continuous curve. This is why higher-degree curves aren\'t generally needed in NURBS modeling. Higher-degree curves are also less stable numerically, so using them isn\'t recommended. Different segments of a NURBS curve can have different levels of continuity. In particular, by placing CVs at the same location or very close together, you reduce the continuity level. Two coincident CVs sharpen the curvature. Three coincident CVs create an angular cusp in the curve. This property of NURBS curves is known as multiplicity. In effect, the additional one or two CVs combine their influence in that vicinity of the curve. By moving one of the CVs away from the other, you increase the curve\'s continuity level again. In 3ds Max, multiplicity also applies when you fuse CVs. Fused CVs create a sharper curvature or a cusp in the curve. Again, the effect goes away if you unfuse the CVs and move one away from the other.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"Parameter Ranges for Curves and Surfaces",
"href":"./files/GUID-AD4E684F-8553-45F3-AE8E-22E3AFCEDF76.htm",
"description":"Methods that deal with points in the parameter space of a curve work with arguments in U. Methods that deal with points in the parameter space of surfaces deal with arguments in U and V. For example, the function NURBSSurfConstPoint::SetUParam() sets the position of a dependent point in the parent surface\'s U parameter space. The valid U and V values that may be passed to this method must be obtained by calling NURBSSurface::GetParameterRange() on the parent surface. This methods retrieves the minimum and maximum values for U and V that may be used. For curves there is a similar function for getting the valid range for U. This is NURBSCurve::GetParameterRange().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"Materials Assignment and Texture Coordinates",
"href":"./files/GUID-D9EF61CC-9061-4039-B2BF-E1654D4B0C23.htm",
"description":"Materials and NURBS Each NURBS surface has its own material ID. If you assign a Multi-SubObject material you can apply a different material to each surface in a NURBS object. The method to do this i",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"Additional Functions for Working with NURBS",
"href":"./files/GUID-59E78094-7661-47F7-A7B8-868ADFBDF0E5.htm",
"description":"The section describes sets of global functions that are available for working with NURBS.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"}]},
{"title":"Creating and Retrieving 3ds Max NURBS Objects",
"href":"./files/GUID-2BEA3BF1-32A9-434A-9199-9C3C0B019DB0.htm",
"description":"CreateNURBSObject() The CreateNURBSObject() function takes a NURBSSet as input and outputs a pointer to an editable NURBS object whose Class_ID is EDITABLE_SURF_CLASS_ID. For example, this is what a",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"},{"title": "Additional Functions for Working with NURBS","href":"./files/GUID-59E78094-7661-47F7-A7B8-868ADFBDF0E5.htm"}]},
{"title":"Creating Primitive NURBS Objects",
"href":"./files/GUID-D7A14197-D4DB-47F0-A314-00117FB9753C.htm",
"description":"GenNURBSLatheSurface() The GenNURBSLatheSurface() function generates a NURBS surface of revolution given an input curve, origin, up axis, and start and end angles. The output of this function is a N",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"},{"title": "Additional Functions for Working with NURBS","href":"./files/GUID-59E78094-7661-47F7-A7B8-868ADFBDF0E5.htm"}]},
{"title":"Modifying Existing NURBS Objects",
"href":"./files/GUID-9C98E834-E80B-4833-A8E9-523C48C23CCA.htm",
"description":"AddNURBSObjects() AddNURBSObjects() adds the specified NURBSSet to the specified object. Parameters Object* obj - Points to the object to have the specified NURBSSet added to. This object must be",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Modeling","href":"./files/GUID-52AEE4CD-1E6E-4021-AB7C-A911BA780F2B.htm"},{"title": "Working with NURBS","href":"./files/GUID-49EBCAEA-CC8E-4BFD-9C12-9C411AA084CB.htm"},{"title": "Additional Functions for Working with NURBS","href":"./files/GUID-59E78094-7661-47F7-A7B8-868ADFBDF0E5.htm"}]},
{"title":"Rendering",
"href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm",
"description":"This folder contains advanced articles about how 3ds Max renders scenes.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Materials, Textures and Maps",
"href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm",
"description":"This section provides information on working with materials and textures.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Principal Classes for Materials and Textures",
"href":"./files/GUID-5243C5F6-2835-430C-8E17-617700BC6D0D.htm",
"description":"The following are the main classes associated with materials and textures.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Standard Materials and Textures",
"href":"./files/GUID-B365E07D-BB74-42E4-BF02-01146E33F3FD.htm",
"description":"The following global functions can be used to easily create default standard materials:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Multi-Materials",
"href":"./files/GUID-9CB9EAA5-5090-4BFC-8AB4-1DAD1B13C7C5.htm",
"description":"A multi-material (or multi/sub-object material) is used to assign different materials at the sub-object level of a geometry. A multi-material (MultiMtl) can be created with the function NewDefaultMultiMtl().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Retrieving the Material from a Node",
"href":"./files/GUID-2E6B466D-B88B-4EFB-920C-648E04CEC0CA.htm",
"description":"In 3ds Max there is only one material per node. In the INode class there are methods INode::GetMtl() and INode::SetMtl() that provide access to and allow changing of the node\'s material. INode::GetMtl() returns a pointer to an instance of class Mtl. If the value returned is NULL this means the user has not assigned a material to the node. In such a case the renderer uses the wire frame color of the node (as well as many defaults) for the rendering properties.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Accessing Material Properties",
"href":"./files/GUID-511D17BA-88AE-42EE-9ADD-AED27495EC83.htm",
"description":"This section covers how the various properties of a material may be retrieved from a node in the scene. These are properties such as color, mapping parameters, bitmaps used, etc.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Material Libraries",
"href":"./files/GUID-3D63B2E3-0088-483C-B2DC-C523A90FCC33.htm",
"description":"3ds Max stores groups of materials in a library file with the .mat file extension. The API provides methods to access the materials stored in these libraries. You can use the methods Interface::LoadMaterialLib() and Interface::SaveMaterialLib(). This class also has a method GetMaterialLibrary() which returns a reference to the currently loaded library. You may then use class MtlBaseLib to access the materials themselves. The sample code below shows how this is done. It loads a materials library, removes a single material, and saves it again.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Assigning Materials to Nodes in the Scene",
"href":"./files/GUID-E6723E9D-25A7-43B6-A723-2F79CFAB8E89.htm",
"description":"A developer may also wish to create materials and assign them to nodes in the scene.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Editing Material and Texture Parameters",
"href":"./files/GUID-2D502A78-197A-4BD7-9B88-648DB8E71D84.htm",
"description":"This section discusses the manner in which plug-in texture and materials manage their user interface in 3ds Max. This is only a concern of developers creating plug-in materials or textures.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Function and Macros for Use with Materials",
"href":"./files/GUID-B833C77F-3C4E-4BDE-B065-EBFD83876FF2.htm",
"description":"Note the following typedef\'s used with materials and textures:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Selecting a Sibling Material",
"href":"./files/GUID-7122E68E-9A06-4D15-916E-946E226151D8.htm",
"description":"In the 3ds Max Material Editor \"Go Forward To Sibling\" moves to the next map or material at the same level in the current material. This button is available only when you are not at the top level of a compound material, and there is more than one map or material at the current level.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Materials, Textures and Maps","href":"./files/GUID-9B8BEA90-374D-4645-9EA6-B4A44599E483.htm"}]},
{"title":"Textures Maps",
"href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm",
"description":"A texture map is an image or function for modifying how a surface appears. It might be a simple image, or a simple function such as for generating the Marble texture, or even a complex image-processing system such as compositors and masking systems.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Mapping Coordinates",
"href":"./files/GUID-F8693957-B3B9-45A7-81DB-07979009CD96.htm",
"description":"Mapping coordinates are the parameters that are used to tell a renderer where a bitmap should appear on the geometry. Mapping coordinates specify the placement, orientation, and scale of a texture map (for example a bitmap or a procedural map) on the geometry.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Mapping Type (Mapping Group)",
"href":"./files/GUID-11EDAFA1-3C40-4725-81B9-3F8D48242805.htm",
"description":"The mapping group determines the type of mapping coordinates used. Different kinds of mapping are distinguished by how the map is geometrically projected onto the object and how the projection interacts with the object\'s surfaces. The mapping group is used in the method Mesh::ApplyUVWMap().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Mapping Channels",
"href":"./files/GUID-5574902C-63C3-4491-9C51-A3B471B60239.htm",
"description":"A map\'s UVW map coordinates channel (or just map channel) identifies which set of an object\'s mapping coordinates to use when mapping textures to the object. Each map channel has a separate UVW vertex and face list for an object. A mapping channel is associated with a MeshMap object instance.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Categories of Texture Maps",
"href":"./files/GUID-6F3591B9-5BBF-4FF9-8200-62F656CC6A51.htm",
"description":"Developers creating texture maps should use the constant text strings shown below to distinguish between the various types of maps so they can be separated in the Material/Map Browser.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Face-Mapped Materials",
"href":"./files/GUID-1884C8E7-F509-4144-9D63-4332C7A8E255.htm",
"description":"Face-mapped materials require no application of mapping coordinates by the user. The user can create a face-mapped material in the 3ds Max Materials Editor. When a face-mapped material is applied to an object, the map is automatically applied to each facet of the object. Below is the code used internally by 3ds Max that computes the texture coordinates for face mapping:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Procedural Textures Maps",
"href":"./files/GUID-501E54D2-29BB-4ED5-ACE8-B9EF5F2E01AC.htm",
"description":"A procedural texture map computes algorithmically. Procedural texture maps usually derive from the Texmap class. This class provides methods for calculating the color of the map for a given location, and computing a perturbation to apply to a normal for bump mapping.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Bump Mapping",
"href":"./files/GUID-88FB1FC7-F557-4B78-9659-0DE6045AD45B.htm",
"description":"Bump mapping is a technique that enables a surface to appear wrinkled or dimpled without the need to model these depressions geometrically. Rather, the surface normal is perturbed according to the information in the bump map to create variations in the smooth surface.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"RPF Files and the G-Buffer",
"href":"./files/GUID-2A9A23AC-8863-42D2-A9AE-85F98C70FCFA.htm",
"description":"The RPF format is the 3ds Max Rich Pixel file format, which supports the ability to include arbitrary image channels.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Texture Coordinates",
"href":"./files/GUID-221DD915-8157-47AE-BB8B-61A82CBA2884.htm",
"description":"This section discusses how UVW texture coordinates are interpreted by the renderer for texture maps in 3ds Max. The Mesh class provides access to the texture coordinates of a Mesh. The PatchMesh class provides access to the texture coordinates of a Patch. Both use a very similar approach. In this section we\'ll look at how this is done for the Mesh class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Texture Map Indices",
"href":"./files/GUID-2F3A157C-1B1D-4BCA-BF38-FE45AF7555AB.htm",
"description":"For a standard material, the shaders do not have consistent mapping on each channel. The following tables shows the mapping from channel index to shader for the different materials.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Textures Maps","href":"./files/GUID-25E98681-2D37-48DB-AF84-06949BC21466.htm"}]},
{"title":"Lights",
"href":"./files/GUID-655264D6-C44F-41B7-A727-F8D045310DA4.htm",
"description":"This topic provides information on working with lights. Covered are the main classes used when dealing with lights and a description of how these relate to one another. Also discussed are the types of lights, and how the parameters that define their characteristics may be retrieve and assigned.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Principal Light Classes",
"href":"./files/GUID-7271915E-8AAF-4E37-AA6F-5F0930175C35.htm",
"description":"The following are the primary classes used for dealing with lights in the 3ds Max SDK.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Lights","href":"./files/GUID-655264D6-C44F-41B7-A727-F8D045310DA4.htm"}]},
{"title":"Light Parameters",
"href":"./files/GUID-0FE49160-D918-4D7E-A7BE-B08C7E0C6289.htm",
"description":"There are several approaches developers may use to access the parameters that define the properties of a light. One way is to call LightObject::EvalLightState(). This method updates the LightState structure passed to it. This structure contains basic information about the light such as its type, color, attenuation ranges, etc.). The structure is valid for a single point in time for animated lights.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Lights","href":"./files/GUID-655264D6-C44F-41B7-A727-F8D045310DA4.htm"}]},
{"title":"Global Light Scaling and Tinting",
"href":"./files/GUID-041EE6FC-805F-4D7C-A6CF-9C7D1A418464.htm",
"description":"The Environment dialog contains two controls that globally affect all lights in the scene, except the ambient light.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Lights","href":"./files/GUID-655264D6-C44F-41B7-A727-F8D045310DA4.htm"}]},
{"title":"Working with Bitmaps",
"href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm",
"description":"This section presents information about working with bitmap images. It discusses the main classes used, and presents information about concepts such as creating, loading and saving bitmaps, memory management when working with bitmaps, palettes, alpha, gamma, the geometry/graphics buffer (GBuffer), working with multi-frame images, handling errors that occur, and pixel storage formats.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Principal Bitmap Classes",
"href":"./files/GUID-2830ACA8-CF1D-42CA-BD75-1F78746F0E4D.htm",
"description":"The following are the primary classes used when working with bitmaps:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Creating Bitmaps",
"href":"./files/GUID-A23565C3-AE6E-4EA1-B13F-938366403552.htm",
"description":"To create a bitmap from scratch, we need to declare a pointer to point to it:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Loading Bitmaps",
"href":"./files/GUID-75A5B399-8C1C-433F-AF85-9201370762A5.htm",
"description":"The following code demonstrates how to load a bitmap using BitmapManager::SelectFileInput() to allow the user to choose a file to load (and initialize the BitmapInfo instance passed to it).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Saving Bitmaps",
"href":"./files/GUID-FF2BD5A8-9FAE-40FD-842B-D512679E910E.htm",
"description":"The example below demonstrates how to save files for a multi-frame file.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Multi-frame Files",
"href":"./files/GUID-4B18EEA3-D3AD-48EF-B3EB-4F665D10EB77.htm",
"description":"Certain file types (and most devices) are multi-frame. AVI, IFL, FLI, and FLC are all formats that support multiple frames. The Bitmap class has methods for dealing with these multi-frame bitmaps. For example, you can set the current frame to load or save. Also, the BitmapInfo class has methods that will let you work with only a subset of frames of a multi-frame image, for example, BitmapInfo::SetStartFrame(), BitmapInfo::SetEndFrame(), and BitmapInfo::SetCustomStep() let you specify a different start, end and frame increment to be used.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"High Dynamic Range Bitmaps",
"href":"./files/GUID-6F424506-26A2-4E0A-A7D7-11AD6346DFA8.htm",
"description":"High Dynamic Range bitmaps are implemented using the class BitmapStorageHDR. These allow access to pixel values as floating point values. Conversions between floating point and fixed point representations are handled automatically include clamping and scaling of floating point values.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Custom Bitmap Properties",
"href":"./files/GUID-8C5EFA86-C3B0-4ADB-950C-915D4E164349.htm",
"description":"You may occasionally want to work with only a portion of a bitmap or series of images. For example, when copying one file to another, if you had a 640x480, 30 frame FLC file, you might want to work with the lower right corner 160x100 portion, using every other frame, perhaps starting at frame 5 and ending at frame 15. The \'Custom\' methods of the BitmapInfo class let you specify these options. Methods such as BitmapInfo::SetCustomWidth(), BitmapInfo::SetCustomX(), and BitmapInfo::SetCustomStep() let you specify the part of the source image that should be manipulated. The method that copied the image would see that these custom properties were set and would act accordingly. See theBitmapInfo class for details on these methods.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Memory Management for Plug-ins that Work with Bitmaps",
"href":"./files/GUID-2F1D93FF-2CAE-4F9B-967F-71F38CF5CC51.htm",
"description":"Bitmap Memory Management Memory is allocated and de-allocated by the bitmap classes in various ways. It is important to understand when memory needs to be freed by the developer, and when the system",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Resolution / Palettes / Pixel Storage Topics",
"href":"./files/GUID-0218192F-EF9C-4B4C-AA03-7B6CEBD1A5EF.htm",
"description":"Bitmap Adjustment - Changes to Resolution and Color Depth There are several ways to change the resolution of a bitmap. In each case this involves creating a new bitmap and copying the existing bitma",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Pre-Multiplied Alpha",
"href":"./files/GUID-357DD9AF-67FC-4D7A-9F51-FC3C6C72A603.htm",
"description":"The following is a discussion of the concept of pre-multiplied alpha as used by 3ds Max. A 32-bit bitmap file contains four channels of data: red, green, blue, and alpha. The first three provide color information to the pixels, while the alpha channel provides transparency information. There are two methods of storing alpha in a bitmap -- pre-multiplied and non-pre-multiplied.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Dithering and Filtering",
"href":"./files/GUID-52ED0A1A-5D9C-4123-B0CB-46DDB1EA6B02.htm",
"description":"When converting images with a palette of a greater number of colors to an image with a palette of fewer colors, dithering is a means of simulating colors not in the more limited palette by mixing different colored pixels together.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Aspect Ratio",
"href":"./files/GUID-B0EAB283-53E4-4D68-93F1-469EC283831B.htm",
"description":"Aspect ratio is usually expressed either as a ratio of bitmap width over bitmap height (for example, 4:3) or as a real value relative to 1 (for example, 1.333).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Hot Check Utilities",
"href":"./files/GUID-B861E6C8-E2B6-4829-92BF-A706A9C4F302.htm",
"description":"There are functions that may be used to correct a pixel with RGB values that will give \"unsafe\" values of chrominance signal or composite signal amplitude when encoded into an NTSC or PAL color signal. This happens for certain high-intensity, high-saturation colors that are rare in real scenes, but can easily be present in computer generated images. Consult the C++ Reference\'s \"Related Pages > Lists and Functions > List of Video Color Check Utilities\" for more information.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"G-Buffer Image Channels",
"href":"./files/GUID-F209E9CC-FAAA-4456-8BFF-6DD332724F36.htm",
"description":"Image Filter and Image Layer events in Video Post can use masks that are based on geometry/graphics buffer (G-Buffer) channels instead of the more widely used RGB and alpha channels. Also, some kinds of Filter and Layer events can post-process objects or materials designated by these channels. The 3ds Max G-Buffer system allows developers to access additional data about rendered objects.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Error Reporting",
"href":"./files/GUID-0DCB13F1-D48D-420D-B1EE-A739C72D5153.htm",
"description":"When an image loader/saver plug-in (derived from class BitmapIO) encounters an error during a bitmap operation (for example \"No Disk Space\" when attempting to write a bitmap) there is a system flag that controls how the error should be reported to the user.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Utility Functions for Use with Bitmap Files",
"href":"./files/GUID-3513EC9F-AFB0-4855-B2F5-EF1FD992B42B.htm",
"description":"The following functions are general utility routines intended for dealing with bitmap files, but can be used with other file types.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Working with Bitmaps","href":"./files/GUID-FD9764C9-EE84-4A1A-BC62-87AE6AF86CC1.htm"}]},
{"title":"Bitmap Gamma Correction",
"href":"./files/GUID-55EACC61-25FE-499B-8D33-38B306AB4B29.htm",
"description":"Gamma correction compensates for the differences in color display on different output devices so that images look the same when viewed on different monitors.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Gamma Preferences",
"href":"./files/GUID-118D1C26-31AA-495C-BC61-9307763521EE.htm",
"description":"There are three kinds of gamma values which can be set via the 3ds Max preferences dialog. These values can be set and accessed using a global instance the GammaMgr class called gammaMgr defined in the file gamma.h.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Bitmap Gamma Correction","href":"./files/GUID-55EACC61-25FE-499B-8D33-38B306AB4B29.htm"}]},
{"title":"Bitmap Gamma Overview",
"href":"./files/GUID-9A15A1FA-42FD-4121-8EE4-CAD9B7373DB9.htm",
"description":"Perceptual and Physical Space The bitmap gamma is used to convert between perceptual space and physical space representation of images. The precise usage of gamma depends on the kind of bitmap. Lo",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Bitmap Gamma Correction","href":"./files/GUID-55EACC61-25FE-499B-8D33-38B306AB4B29.htm"}]},
{"title":"Changing Bitmap Texture Map Gamma",
"href":"./files/GUID-3168669B-DD1A-493D-A36E-8A6082BE3469.htm",
"description":"In order to change the gamma value of a Bitmap Texture that has been loaded, it is recommended that you reload the bitmap from disk. This can be accomplished using BitmapTex::ReloadBitmapAndUpdate().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Bitmap Gamma Correction","href":"./files/GUID-55EACC61-25FE-499B-8D33-38B306AB4B29.htm"}]},
{"title":"Cameras",
"href":"./files/GUID-DBBBDEC5-21D1-42B3-B63D-C5D3891FBCE7.htm",
"description":"Cameras present a scene from a particular point of view. A camera is a non-rendered object in the scene. Cameras derive from the base class CameraObject. Developers writing camera plug-ins will usually derived from GenObject.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Render Elements",
"href":"./files/GUID-16924907-379E-4183-91BE-C19B9BB3BD39.htm",
"description":"Render elements allow renderers to output to separate bitmaps portions of the final shaded image so that they can be manipulated/composited at a later time, without re-rendering.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"G-Buffers",
"href":"./files/GUID-5364BDB2-AEDB-41F9-8183-886E6BF89FF8.htm",
"description":"A geometry/graphics buffer (GBuffer) is used to store, at every pixel, information about the geometry at that pixel. All plug-ins in video post can request various components of the GBuffer. When video post calls the renderer, it takes the sum of all the requests and asks the renderer to produce the GBuffer. Developers can use this information to create visual effects that are impossible to achieve without access to a GBuffer.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Extending Render To Texture to Support New Materials",
"href":"./files/GUID-70E63852-3EBE-4D80-A2CB-302EFA6DF0C2.htm",
"description":"The Render to Texture feature provides the ability to render out various elements from a standard render, for example light maps and specular maps. It works in conjunction with the new UVW Unwrap modifier, which can now flatten texture coordinates. Please see the user guide for a more detailed description.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Network Rendering",
"href":"./files/GUID-B6F13371-D8C3-46EB-AA8B-A43AE17A1374.htm",
"description":"The network rendering API is exposed through the MaxNetManager class which allows clients to connect to the Network Rendering Manager to perform any and all functions offered. The API handles all the networking code and communication protocols.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Posting Messages to Video Post",
"href":"./files/GUID-FD414EB4-F383-4214-AC55-C772FEE5B430.htm",
"description":"This section discusses the posting of messages in video post. There are three message types supported:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Mental Ray Integration",
"href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm",
"description":"Note: mental images and mental ray are registered trademarks of mental images GmbH & Co. KG, Berlin, Germany.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Mental Ray Shaders in 3ds Max",
"href":"./files/GUID-64C36AC0-7666-4161-A2C4-B51BB5C2B3F3.htm",
"description":"Introduction This topic describes how a developer can use a mental ray shader to work with 3ds Max. Part of this document also applies to integrating custom phenomena. This document does not describ",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Mental Ray Integration","href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm"}]},
{"title":"Mental Ray Classes",
"href":"./files/GUID-B8C31073-43E7-475F-9895-E42D0723BE93.htm",
"description":"This topic describes the primary classes involved in making 3ds Max materials compatible with mental ray shaders.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Mental Ray Integration","href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm"}]},
{"title":"Translation of Texture Map and Materials",
"href":"./files/GUID-C1402E7A-67D3-410F-90E1-089422806459.htm",
"description":"Given a 3ds Max texture map plug-in derived from class TexMap or Material plug-in derived from Mtl, and a mental ray shader (with a DLL and .mi file) the following steps describe how to control how the plug-in is made compatible with 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Mental Ray Integration","href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm"}]},
{"title":"Mental Ray Translation System",
"href":"./files/GUID-1B0BCBBB-06F8-411E-9A07-D87EA422CEE7.htm",
"description":"When rendering a scene using mental ray 3ds Max performs a translation of meshes, materials, texture maps, etc. to mental ray formatted data for use by the mental ray renderer. The translation system allows a mapping to be done between a 3ds Max plug-in and an existing mental ray shader. In some cases you can use the default mental ray material. If no compatible mental ray shader exists, you will have to write one. For information on writing mental ray shaders consult the mental ray reference documentation provided with the 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Mental Ray Integration","href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm"}]},
{"title":"Automatic Parameter Translation",
"href":"./files/GUID-02348DAB-28C4-4F7E-A633-56BEEC6535D6.htm",
"description":"For automatic translation of parameters to be possible, a texture map plug-in must contain a ParamBlock2 which is a one-to-one match to the parameters structure in the mental ray shader. Every parameter block that you want to be automatically translated must have a matching structure in the mental ray shader. For example, if your plug-in has a parameter block that is called \"Parameters\", then the mental ray shader must have a structure that is called \"Parameters\". The contents of the parameter block will be matched with the contents of the structure.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Mental Ray Integration","href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm"}]},
{"title":"Manual Parameter Translation",
"href":"./files/GUID-C989D00D-FEB2-48E8-986E-80CDA9E4BEAE.htm",
"description":"The constraints for manual parameter translation are similar to those of automatic parameter translation. The names and parameter structures no longer have to match, but the types must still match.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Mental Ray Integration","href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm"}]},
{"title":"Advanced Parameter Translation",
"href":"./files/GUID-C2065FB8-1D97-4B45-A2D6-02AEB475B085.htm",
"description":"The method imrShaderTranslation::TranslateParameters_Advanced() can be used to translate parameters in cases where:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Mental Ray Integration","href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm"}]},
{"title":"Translation of Object Plug-ins",
"href":"./files/GUID-7BEE2CD7-A350-4B5D-812B-8C2FE4FE0912.htm",
"description":"The following steps describe how to enable custom translation of object plug-ins (derived from GeomObject or ShapeObject) to a mental ray geometry shader. Geometry shaders are functions that procedurally create geometric objects. They are different from most other shaders because they do not return a color, but a reference to the object or instance group created by the shader. For more information on writing geometry shaders see the mental ray reference documentation.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Mental Ray Integration","href":"./files/GUID-A2D32BCF-F011-440C-B88E-1F8F79DAD445.htm"}]},
{"title":"Programming Hardware Shaders",
"href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm",
"description":"This topic describes how to program hardware shaders using DirectX. Any version of the DirectX SDK can be used as long as the core runtime component is DirectX 9.0c or DirectX 10.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"}]},
{"title":"Hardware Rendered Materials",
"href":"./files/GUID-AA32173E-4C72-4A8E-A42C-5E1689B8AE56.htm",
"description":"3ds Max supports hardware rendering of materials using DirectX. The main interface to use is the IDX9DataBridge interface. This interface provides the communication between the materials and the Direct3D graphics layer. The graphics layer will query for this interface to make sure the material supports a â€œhardwareâ€ interface. The graphics layer will then continue to query for the DX9_VERTEX_SHADER_INTERFACE_ID. This interface is derived from IDX9VertexShader.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"DirectX 10",
"href":"./files/GUID-63A60683-7A42-4830-9EE8-D7799F57048E.htm",
"description":"DirectX 10 ships with and is only available with Windows Vista. The same process as for DirectX 9 is used for DirectX 10 support, however the interface ID3D10ShaderResource is used. It should be of noted that the DirectX 10 graphics driver is still maturing and is very dependent on the quality of the GPU drivers from the vendors.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"Hardware Shader UI Feature",
"href":"./files/GUID-5F581CF8-53D4-4899-919C-36B939B973A0.htm",
"description":"If your material supports hardware rendering it can indicate so the user through the interface IMaterialViewportShading. 3ds Max will query for this interface to report what support is offered to the user. This interface is defined as a ULONG, so it uses the override of Animatable::GetInterface( ULONG). The system allows for any material to define if it supports a hardware mode. A simple example is shown below. For a more complete example, see samples\\material\\StdMaterialViewportShading.cpp.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"Determining DirectX Version",
"href":"./files/GUID-4BCFF7DF-7650-46B3-9061-E21317115A91.htm",
"description":"There are two separate interfaces that provide access to the DirectX devices one for DirectX 9 (ID3D9GraphicsWindow) and one for DirectX 10 (ID3D10GraphicsWindow).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"Accessing the DirectX Device",
"href":"./files/GUID-877D59BE-851B-4016-8A05-7C821DB226CF.htm",
"description":"Full access to the Direct3D device being used by 3ds Max can be retrieved using ID3D9GraphicsWindow::GetDevice() or ID3D10GraphicsWindow::GetDevice(). For information on how to retrieve pointers to ID3D9GraphicsWindow or ID3D10GraphicsWindow see the topic Determining DirectX Version.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"Parsers and Shader Effect Files",
"href":"./files/GUID-9BEFC3D8-2506-41C5-B5E4-7C03AEDE491E.htm",
"description":"DirectX materials used by 3ds Max are described by shader effect files written in either High Level Shader Language (HLSL) or the NVIDIA Cg language. These are processes by a 3ds Max effect file parser. An effect parser implements the interface IEffectParser. The parameters of the effect file (i.e. the parameters of the hardware material) are extracted, and displayed to the user by 3ds Max. The effect manager provides access to the effect parameters and is exposed as an interface IEffectManager that is implemented in 3ds Max by the DirectX material.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"Shader Semantics and Annotations",
"href":"./files/GUID-DCFE87C8-8381-49A8-9C2F-067D89E1E3F5.htm",
"description":"Semantics are user supplied hints in a shader effect file, that describe a variable. The material uses semantics to define the transforms required by the effect, and also for what style of texture map is present.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"Supported HLSL Shader Semantics",
"href":"./files/GUID-0C7A600E-7954-42B0-86EE-586A379A2CAD.htm",
"description":"The following is a list of 3ds Max supported semantics for DirectX 9 and DirectX 10 hardware rendered materials through the original HLSL parser, identified by the paramId string \"0x0000\".",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"},{"title": "Shader Semantics and Annotations","href":"./files/GUID-DCFE87C8-8381-49A8-9C2F-067D89E1E3F5.htm"}]},
{"title":"Supported HLSL Shader Annotations",
"href":"./files/GUID-5AE40798-A8AB-4315-BF23-F7057089567A.htm",
"description":"The following are the currently supported set of shader effect file annotations by the HLSL parser. Note that case is ignored in both the names and string values, so \"IntSpinner\" is treated the same as \"INTSPINNER\" or \"intspinner\".",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"},{"title": "Shader Semantics and Annotations","href":"./files/GUID-DCFE87C8-8381-49A8-9C2F-067D89E1E3F5.htm"}]},
{"title":"Supported SAS Shader Semantics",
"href":"./files/GUID-D5ECD9DE-44C6-44C4-A77D-081EEB967773.htm",
"description":"The following is a list of 3ds Max supported semantics for DirectX 9 and DirectX 10 hardware rendered materials through the SAS based parsers. The Microsoft SAS 0.8 specification with and without scene effect source identified by the paramId strings \"0x0003\" and \"0x0001\" respectively, and the Cg parser identified by the paramId string \"0x0002\".",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"},{"title": "Shader Semantics and Annotations","href":"./files/GUID-DCFE87C8-8381-49A8-9C2F-067D89E1E3F5.htm"}]},
{"title":"Supported SAS Shader Annotations",
"href":"./files/GUID-D6E12734-4D95-4C03-932A-6BA6080B65E8.htm",
"description":"The following are the currently supported set of shader effect file annotations for the various SAS parsers. Note that case is ignored in both the names and string values, so \"IntSpinner\" is treated the same as \"INTSPINNER\" or \"intspinner\".",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"},{"title": "Shader Semantics and Annotations","href":"./files/GUID-DCFE87C8-8381-49A8-9C2F-067D89E1E3F5.htm"}]},
{"title":"Supported Direct3D Texture Formats",
"href":"./files/GUID-1906D74E-7D03-4201-A0A3-77840FEC8DD3.htm",
"description":"The following is a list of supported Direct3D supported texture formats. These are valid values for the \"Format\" annotation in the hardware shader:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"},{"title": "Shader Semantics and Annotations","href":"./files/GUID-DCFE87C8-8381-49A8-9C2F-067D89E1E3F5.htm"}]},
{"title":"Obtaining Shader Parameters",
"href":"./files/GUID-A9F26840-BA22-465F-BB06-348DB87D17F1.htm",
"description":"The IParameterManager provides access to the data acquired by the parsers. The following code snippet shows how to access an IParameterManager from an IDxMaterial3 pointer obtained from an Mtl object.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"Loading and Parsing Shader Effect Files",
"href":"./files/GUID-BF252DDD-B2DE-4143-88B6-DE98A8C1AE52.htm",
"description":"All loading and parsing for shader effect files takes place in the parser. A typical function that uses the new method of IEffectParser is shown in the following code sample:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Rendering","href":"./files/GUID-5F7BBC25-17C9-4918-B1B7-05867D573CC9.htm"},{"title": "Programming Hardware Shaders","href":"./files/GUID-D359833E-F588-494F-B2A3-49564C28BDB0.htm"}]},
{"title":"Animation, Time, and Controllers",
"href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm",
"description":"This section contains topics about working with time and animation in 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Controllers",
"href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm",
"description":"All animation in 3ds Max is managed by a plug-in type called an animation controller (or controller for short). A controller manages the animation by returning a specific value given a specific time value.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Controller API Elements",
"href":"./files/GUID-5A09D1BA-9881-495B-B9A3-F7C9FAD8B536.htm",
"description":"Principal Classes The following are the main class used when dealing with controllers in the SDK. Control - This is the base class for the creation of controller plug-ins. StdControl -This class",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"}]},
{"title":"Point Rotation Scale (PRS) Controller",
"href":"./files/GUID-CFE0CEAA-FB3A-446E-B565-71D440EF3313.htm",
"description":"The point rotation scale (PRS) controller is the default controller assigned to objects when they are created, unless another default controller is set by the 3ds Max user.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"}]},
{"title":"Constraints",
"href":"./files/GUID-10B4D620-8D40-4311-B012-88B133D1098A.htm",
"description":"Constraints are a subset of controllers. Only those controllers that need reference another object are called constraints. Some examples of constraints are: position constraint, orientation constraint, link constraint, path constraint. Controllers that are not constraints don\'t need an object for reference. Some examples of controllers that aren\'t constraints are keyframe controller, expression controller, noise, and waveforms.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"}]},
{"title":"Controllers and Parameter Blocks",
"href":"./files/GUID-FC895233-4F83-4149-B198-58349A34951C.htm",
"description":"Many plug-ins allow their parameters to be animated. When a parameter block (IParamBlock2) is used to manage a plug-in\'s parameter the parameter block also manages the controller which handles the interpolation or generation of values.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"}]},
{"title":"Transform Controllers and Nodes",
"href":"./files/GUID-23ABDE4C-56A1-4108-8964-8DCCF4229D8A.htm",
"description":"A transform controller is a controller that controls a Matrix3. Transform controllers control the 4x3 matrices used to define the position of nodes in the scene for example. The first reference of a node (i.e. accessed via INode::GetReference(0)) is to it\'s transform controller.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"}]},
{"title":"The Undo Mechanism and Transform Controllers",
"href":"./files/GUID-CEB0255C-32D3-40A8-A9B4-D16BC8B3CBE5.htm",
"description":"The following is a discussion of how a transform controller responds to movement of the mouse when the user is dragging and how the undo mechanism is involved.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"}]},
{"title":"Controller Data Access",
"href":"./files/GUID-664B6404-E5E7-4AB4-A631-0704E43462B9.htm",
"description":"This section provided an overview of accessing 3ds Max controller data. Since 3ds Max supports both keyframe and procedural controllers different techniques are required to retrieve the data. Keyframe controller can usually use the IKeyControl interface. Procedural controller must be sampled using GetValue(), usually at each frame. The values that a controller stores are in the local coordinate system of the controller. The matrix passed to GetValue() for a transform controller defines the coordinate system of the transformation.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"}]},
{"title":"Keyframe Key Data for the PRS Controller",
"href":"./files/GUID-0E5A458D-6C14-43D3-A2D7-FD2AC3CF6F9F.htm",
"description":"The default keyframe transform controller in 3ds Max is a PRS controller. This means that it handles orienting a node in the scene using separate controllers for Position, Rotation and Scale. To generate a complete transformation, first the position is applied, then the rotation, then the scaling.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"},{"title": "Controller Data Access","href":"./files/GUID-664B6404-E5E7-4AB4-A631-0704E43462B9.htm"}]},
{"title":"Keyframe Data Access Classes and Methods",
"href":"./files/GUID-15D0AC1F-736B-458A-8F4C-01D867C96EFE.htm",
"description":"This section discusses access to keyframe controller data. The 3ds Max API provides a class IKeyControl. This class provides an interface into the TCB, Bezier, and Linear keyframe controllers allowing a developer to add, delete, retrieve and update the keys of the controller.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"},{"title": "Controller Data Access","href":"./files/GUID-664B6404-E5E7-4AB4-A631-0704E43462B9.htm"}]},
{"title":"Keyframe Interpolation",
"href":"./files/GUID-16830EC4-00C2-40AE-A710-C9F5C2F71429.htm",
"description":"The function used for interpolation between keys depends on the type of controller. In general, 3ds Max uses cubic (polynomial of degree three) splines for interpolation. Rotations are done using spherical linear interpolation (slerps). Registered developers who are interested in the exact details of keyframe interpolation have the source code 3ds Max uses internally as part of the Debug SDK. The bezier interpolation code is available in <MaxDebugRoot>\\Core\\INTERP.CPP and the TCB interpolation is in <MaxDebugRoot>\\Core\\TCBINTRP.CPP. This code is not available for non-registered developers. See the Advanced Topics section on Debugging for more details on the Debug SDK.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"},{"title": "Controller Data Access","href":"./files/GUID-664B6404-E5E7-4AB4-A631-0704E43462B9.htm"}]},
{"title":"Procedural Controller Data Access",
"href":"./files/GUID-5E14A456-DC88-4361-A190-263079FFE94A.htm",
"description":"Procedural controllers compute their value algorithmically rather than interpolate between stored keyframes. Developers may need to retrieve values from these controllers but won\'t be able to use the IKeyControl interface since no keys are available. In these cases, one must sample the controller to retrieve its value at each frame required. This is done by calling the Control::GetValue() method directly. The following sample code samples the controller for each frame in the current animation interval and DebugPrint()s the values to the VC++ IDE debug window. Note how the parent matrix of the node is passed into the GetValue() call. This allows GetValue() to update the appropriate matrix. In the code below, the position coordinates printed by DebugPrint() will be in world space.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Controllers","href":"./files/GUID-18A46B21-910F-4A06-8A21-26F2D6599DD2.htm"},{"title": "Controller Data Access","href":"./files/GUID-664B6404-E5E7-4AB4-A631-0704E43462B9.htm"}]},
{"title":"Intervals",
"href":"./files/GUID-EA193629-7CF9-4B95-B996-63988B75864F.htm",
"description":"An Interval is a class that represents a length of time. The most common use is to describe a range of time over which an item is said to be \'valid\' with regards within the cache system. This type of interval is referred to as a validity interval.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Time Functions",
"href":"./files/GUID-5B1D652F-6BD8-4EAF-8380-4C489363A8C0.htm",
"description":"Time is stored internally in 3ds Max as an integer number of ticks. Each second of an animation is divided into 4800 ticks. This value is chosen in part because it is evenly divisible by the standard frame per second settings in common use (24 -- Film, 25 -- PAL, and 30 -- NTSC).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Animatables and Sub-Animatables",
"href":"./files/GUID-A91FBDB0-C0E4-4E59-BE14-3298F64A1636.htm",
"description":"The Animatable class is the base class for many of the items in 3ds Max. In addition to numerous utility functions, it contains methods related specifically to the Track View (see Track View for more information) and for enumerating the sub-animatables. A sub-animatable is an object managed by an animatable, that is itself also an animatable. For example a parameter a parameter block.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Animatable Handles",
"href":"./files/GUID-B92DAE23-26D5-45D4-BEE5-B21D143417EE.htm",
"description":"The AnimHandle system enhances sorting and searching of 3ds Max scene entities by providing a new type of identifier for Animatable objects. All Animatables have an AnimHandle. It is possible to retrieve any Animatable using its AnimHandle. An Animatable\'s AnimHandle is unchanging within a 3ds Max session, and the system does not reuse them for newer Animatables during a 3ds Max session. After an Animatable is deleted, attempting to retrieve it from its handle is completely safe, the system indicates the object is deleted by returning NULL.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Track View",
"href":"./files/GUID-72D0D6B8-10BF-4312-BE77-061C99921F5C.htm",
"description":"The track view of 3ds Max provides a view into time. Track view is organized as a nested hierarchy showing both parent/child relationships, and sub-anim (parameter) relationships.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Track View Key Operations",
"href":"./files/GUID-D39BB628-7B88-44BB-802A-06E3FC52C80D.htm",
"description":"This section discusses some of the various Animatable method for dealing with keys in track view. These methods perform operations such as adding, deleting and scaling keys.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Track View","href":"./files/GUID-72D0D6B8-10BF-4312-BE77-061C99921F5C.htm"}]},
{"title":"Deleting Controllers",
"href":"./files/GUID-C267D0C6-A037-40EE-BF79-B0D027551378.htm",
"description":"The Delete Controller button in the Track View toolbar is enabled when one or more deletable tracks are selected. This means that a plug-in can indicate to Track View that one or more of its sub-controllers can be delted via the method Control::CanDeleteSubAnim(). This provides a way for the user to delete node sub-controllers such as the visibility track, \"Image Motion Blur Multiplier\", \"Object Motion Blur On/Off\", and so on. When the user deletes a sub-animatable the method Control::DeleteSubAnim() is called.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"},{"title": "Track View","href":"./files/GUID-72D0D6B8-10BF-4312-BE77-061C99921F5C.htm"}]},
{"title":"Animation Track Locking",
"href":"./files/GUID-4EFA1A0D-582D-47BC-8B9D-1F0F0D3887BD.htm",
"description":"Animation tracks can be locked to prevent editing of animatable parameters. One example where locking animatable parameters and animation tracks would be useful is when the rigger creates a character and hands it off to animators for animation. The rigger could lock all parameters that he doesn\'t want the animators to edit, such as bone parameters (e.g. position, rotation, scale, etc.), and leave unlocked those that are meant to be used for animation.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Trajectories",
"href":"./files/GUID-EF8F8552-E249-450B-9E4B-B71CA8E14BEE.htm",
"description":"The trajectory option displays the path that an object takes over time. Trajectory mode is selected by the user from the Motion panel UI element. The user can convert from splines into trajectories, from trajectories into splines, and to collapse any transform controller into editable keys.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Reference Messages During Animation",
"href":"./files/GUID-FF1EAF82-5C3C-430E-8DBF-C86D548B540E.htm",
"description":"When playing back an animation the messaging system is quiet (e.g. there are no change notification messages) because it is known (through validity intervals) what is changing and what is not. The exception is in the geometry pipeline where we actually use the messaging system to track caches (which multiple entities may have pointers into) as they are discarded during updating.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Out-of-Range Type",
"href":"./files/GUID-1C28BABA-2610-4005-B204-3AC300B7967B.htm",
"description":"The pattern of animation for a particular track is defined by the first and last keys in the track. These keys define a range of animation between the keys. The pattern of animation before and after this range is defined by the assigned Out of Range Type. The Out of Range Type is sometimes referred to as an ORT in the documentation and source code.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Animation, Time, and Controllers","href":"./files/GUID-D05C22ED-9492-44F9-BFFA-38A2E1B459EB.htm"}]},
{"title":"Viewports and Graphics Windows",
"href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm",
"description":"The 3ds Max viewport in 3ds Max is represented using the class ViewportExp. This class provides methods to access properties of the viewport, convert points between viewport and world coordinates, snap points and lengths, etc. Many methods associated with hit testing are also here. All the methods of this class are implemented by the system.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Hit Testing",
"href":"./files/GUID-C545DC05-32C5-4947-A067-CC27534BF6DE.htm",
"description":"Hit testing is the process of determining if a given point (e.g. the location of a mouse) intersects an item (for example a node, a modifier gizmo/center, or a controller gizmo). A plug-in developer\'s responsibility regarding hit testing depends upon the type of plug-in and how much functionality is supplied by the base class the plug-in is derived from. For example, plug-ins that are derived from SimpleObject, SimpleMod or StdControl are not required to implement methods for hit testing as it is all handled internally by the base class. Other plug-ins that don\'t derive from these classes (for example the Boolean object or the Mapping modifier) must perform their own hit testing, by providing an implementation of one of the following methods:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"}]},
{"title":"Hit Testing in the Graphics Windows",
"href":"./files/GUID-22BDD90D-8D3B-4527-8BBB-2A2F0E0A3FA0.htm",
"description":"Hit testing is performed in the graphics window (GraphicsWindow) using a side-effect mechanism. There is a special rendering mode (see Rendering Modes) that performs hit testing. In this mode (called GW_PICK), the item is not actually drawn, but is instead tested for intersection with the specified hit region. When hit-testing is enabled, primitives set a flag if they pass through or are fully contained in the hit region. When in this mode, the primitives do not cause any visual side-effects -- in particular, they do not change the image or Z buffers If an item needs to be hit tested, a developer must simply draw the item using a rendering level GW_PICK and then check the result.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Hit Testing","href":"./files/GUID-C545DC05-32C5-4947-A067-CC27534BF6DE.htm"}]},
{"title":"Using setHitCode and setHitDistance",
"href":"./files/GUID-49A4035F-1C0E-49C4-BB7A-A550903639CF.htm",
"description":"The GraphicsWindow::setHitCode() and GraphicsWindows::setHitDistance() are methods that make it possible to do hit-testing in some otherwise impossible situations. An example of such a situation arises when hit-testing patch regions that consist of bezier spline-based edges.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Hit Testing","href":"./files/GUID-C545DC05-32C5-4947-A067-CC27534BF6DE.htm"}]},
{"title":"Sub-Object Hit Testing",
"href":"./files/GUID-1435A4DC-878D-420F-A4FF-8F4B1E3E1D03.htm",
"description":"The definition of a sub-object element depends on the modifier. For example it may be a modifier\'s gizmo or part of its gizmo. Consider when an FFD modifier is in vertex sub-selection mode, the sub-object elements that are being hit tested are the control points of the lattice. Edit modifiers usually hit test components of the object in the pipeline such as vertices or faces.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Hit Testing","href":"./files/GUID-C545DC05-32C5-4947-A067-CC27534BF6DE.htm"}]},
{"title":"Hit Lists",
"href":"./files/GUID-60A17D0A-ABC0-4904-98F5-F5B893E15B10.htm",
"description":"3ds Max maintains three INode lists, for successfully hit nodes in the ViewExp class after performing hit tests. The first list is an internally maintained list of all hit nodes. In addition a HitLog is provided for modifier sub-object hits and a CtrlHitLog for controller sub-object hits.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Hit Testing","href":"./files/GUID-C545DC05-32C5-4947-A067-CC27534BF6DE.htm"}]},
{"title":"Gizmo Hit Testing using PolyLines",
"href":"./files/GUID-0B01E195-BCA5-4058-9502-03CBCDE23E44.htm",
"description":"The following sample code demonstrates controller gizmo hit testing. This method hit tests a series of \'footstep\' shaped PolyLines that serves as the controller\'s gizmo.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Hit Testing","href":"./files/GUID-C545DC05-32C5-4947-A067-CC27534BF6DE.htm"}]},
{"title":"Node Level Hit Testing",
"href":"./files/GUID-61A1BFBD-1AA4-4572-B82B-DB1C4925E566.htm",
"description":"If a plug-in wants to perform hit testing of nodes in the scene it may use the following methods of the Interface class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Hit Testing","href":"./files/GUID-C545DC05-32C5-4947-A067-CC27534BF6DE.htm"}]},
{"title":"Hit Regions",
"href":"./files/GUID-F1D50C78-52B2-47D1-B873-DA6BE388FFE0.htm",
"description":"Many 3ds Max objects provide methods for hit testing (e.g. Mesh::Select(), MNMesh::Select(), PatchMesh::Select(), MNNormalSpec::HitTest(), etc.) that use a HitRegion class. A hit region is identified by its HitRegion::type member variable, and can be a point plus epsilon (POINT_RGN), rectangular region (RECT_RGN), circular region (CIRCLE_RGN), or a multi-point polygon region (FENCE_RGN).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Hit Testing","href":"./files/GUID-C545DC05-32C5-4947-A067-CC27534BF6DE.htm"}]},
{"title":"Graphics Window",
"href":"./files/GUID-426D2D83-BC73-40CC-B8EA-FF84AD278862.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"}]},
{"title":"Foreground / Background Planes",
"href":"./files/GUID-A81CDC1B-19C4-4D22-A583-0A9A159ADDE5.htm",
"description":"In order to allow 3ds Max to redraw the viewports as quickly as possible, an option is provided in the 3ds Max user interface to allow the user to use dual planes. If dual plane mode is enabled, there is an extra buffer in memory that holds what is referred to as The Background. The background contains an entire image buffer and Z buffer (if Z buffering is turned on). Consider the following example to understand how the background buffer is used to speed up screen redraws:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Graphics Window","href":"./files/GUID-426D2D83-BC73-40CC-B8EA-FF84AD278862.htm"}]},
{"title":"Rasterization and Z-Buffers",
"href":"./files/GUID-213B670D-ED53-4ECE-907E-09C874C86555.htm",
"description":"When the system creates an instance of a GraphicsWindow, the constructor opens a window for output and connects that window to an instance of a low-level rasterizer. Since the driver has complete control over the window\'s palette (if one exists), each GraphicsWindow within 3ds Max must be connected to the same driver.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Graphics Window","href":"./files/GUID-426D2D83-BC73-40CC-B8EA-FF84AD278862.htm"}]},
{"title":"Geometric Primitives Supported by the Graphics Window",
"href":"./files/GUID-0EA1CC71-2DC7-4E97-B3AF-FDDC2A76D4F0.htm",
"description":"The geometric primitives supported by the GraphicsWindow class were designed to provide optimal support for rendering triangular meshes. As noted earlier, the preferred way to render such meshes is through the Mesh::Render() method.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Graphics Window","href":"./files/GUID-426D2D83-BC73-40CC-B8EA-FF84AD278862.htm"}]},
{"title":"Rendering Modes and Rendering Limits",
"href":"./files/GUID-DFFAA9DC-C544-4142-9139-50BB28A7CAFD.htm",
"description":"A GraphicsWindow instance can be in any of several different rendering modes. The various rendering modes may be combined in a large number of ways. For example, it is possible to request Gouraud-shaded z-buffered lines, or textured flat-shaded triangles. The actual output will depend on the capabilities of the underlying device driver.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Graphics Window","href":"./files/GUID-426D2D83-BC73-40CC-B8EA-FF84AD278862.htm"}]},
{"title":"Viewport Button",
"href":"./files/GUID-BA89EB55-6B27-4094-ACD1-A809D0E0F633.htm",
"description":"The IViewportButton class represents buttons displayed in the viewport. They allow the user to perform actions associated with the buttons via mouse input.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Graphics Window","href":"./files/GUID-426D2D83-BC73-40CC-B8EA-FF84AD278862.htm"}]},
{"title":"Graphics Window Coordinate Systems",
"href":"./files/GUID-01A68C14-01E2-4CAF-AAD1-B10F71E776D4.htm",
"description":"There are two primary coordinate systems within a GraphicsWindow: device-independent 3D eye coordinates and device-dependent window coordinates.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Graphics Window","href":"./files/GUID-426D2D83-BC73-40CC-B8EA-FF84AD278862.htm"}]},
{"title":"Graphics Window Light and Materials",
"href":"./files/GUID-59106CA7-D0EA-48FB-8CC5-452A252D0D95.htm",
"description":"The geometric primitives in a GraphicsWindow do not directly support lighting. However polylines and polygons can be provided with colors for each vertex. If provided (and the current rendering mode/limit allows for it), the device driver will interpolate the vertex colors as the primitive is rasterized.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Graphics Window","href":"./files/GUID-426D2D83-BC73-40CC-B8EA-FF84AD278862.htm"}]},
{"title":"Nitrous",
"href":"./files/GUID-EC312B39-5B82-4ED4-8AF2-C4E3779097DD.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"}]},
{"title":"Plug-in Display Interface",
"href":"./files/GUID-A7262BEC-A063-4E70-A1D9-7971DBF2E883.htm",
"description":"Legacy Object/Modifier Plug-in Display Interface Traditionally in 3ds Max, the object/modifier plug-in is displayed by implementing its Display() function. In the Display() function, the plug-in uses",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Nitrous","href":"./files/GUID-EC312B39-5B82-4ED4-8AF2-C4E3779097DD.htm"}]},
{"title":"About SmartHandle",
"href":"./files/GUID-8BCFA5BE-53A0-4D9C-9D3F-2F271821DA5C.htm",
"description":"Nitrous is designed to run in a separate nitrous rendering thread. For thread-safety, plug-ins must use SmartHandle to access the pointers of Nitrous resources including buffers, textures, render items, materials, and others in main thread or nitrous rendering thread.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Nitrous","href":"./files/GUID-EC312B39-5B82-4ED4-8AF2-C4E3779097DD.htm"}]},
{"title":"About RenderItem",
"href":"./files/GUID-C7457E13-4FE7-4B8F-8F4C-818F0E9D6956.htm",
"description":"The basic element that Nitrous uses to display anything on the screen is RenderItem. The object plug-in must generate a list of RenderItems according to the scene and viewport context. The object plug-ins usually do not need to hold references to these RenderItems. Nitrous internally organizes the RenderItems and manages their lifetime.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Nitrous","href":"./files/GUID-EC312B39-5B82-4ED4-8AF2-C4E3779097DD.htm"}]},
{"title":"Low-level Device API",
"href":"./files/GUID-5647134B-D786-4CE3-B740-1C126ED9244A.htm",
"description":"The following interfaces can be used in the CustomRenderItemHandle: IVirtualDevice – This is very similar to Direct3D (D3D) IDirect3DDevice. You can use it to create, set, and draw graphics data. BaseMaterialHandle and concrete material handles – These are different material classes. A material handle can be used for shading a render item. VertexBufferHandle – This is a buffer that stores vertices with a given format. It is similar to D3D’s vertex buffer. IndexBufferHandle – This is a buffer that stores indices. It is similar to D3D’s index buffer. TextureHandle and TargetHandle – These two classes can be used as texture parameter for material.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Nitrous","href":"./files/GUID-EC312B39-5B82-4ED4-8AF2-C4E3779097DD.htm"}]},
{"title":"Material Plug-in Display Interface",
"href":"./files/GUID-6CD4E541-BC35-4F86-980C-E9BE9581E5B0.htm",
"description":"A material plug-in can customize its display in Nitrous. A material in 3ds Max can have the following display modes: Mode Description Shaded A simple phong model is used for displaying the material. Realistic An advanced material model is used in the viewport for better display.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Nitrous","href":"./files/GUID-EC312B39-5B82-4ED4-8AF2-C4E3779097DD.htm"}]},
{"title":"Implementing Simple Material and Texture Map Plug-ins with Nitrous",
"href":"./files/GUID-6105A0AF-BD5F-48E6-A593-188FD160750D.htm",
"description":"Simple Material and Texture Map Display API Nitrous SDK provides automatic support for displaying material and texture map plug-ins in both the Nitrous viewport mode and in Quicksilver renderings. 3d",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Nitrous","href":"./files/GUID-EC312B39-5B82-4ED4-8AF2-C4E3779097DD.htm"}]},
{"title":"Implementing Advanced Material and Texture Map Plug-ins with Nitrous",
"href":"./files/GUID-3DAC3B9F-8516-473A-B049-49144FFBD0CD.htm",
"description":"Advanced Material and Texture Map Display API Materials and texture maps can use MetaSL programmable shaders to describe their appearance when displayed in the Nitrous viewport, or when rendered with",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Viewports and Graphics Windows","href":"./files/GUID-94AFDEF6-5BE2-47BC-818D-3BE03DEE0040.htm"},{"title": "Nitrous","href":"./files/GUID-EC312B39-5B82-4ED4-8AF2-C4E3779097DD.htm"}]},
{"title":"User Interface",
"href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm",
"description":"This section describes the various classes and functions used to customize the user interface in 3ds Max. This includes the ability to customize the 3ds Max main pull down menus, the toolbars, quad menus and keyboard shortcuts.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Caddy Controls",
"href":"./files/GUID-45740985-8FD3-484B-837F-BFE8734ED30E.htm",
"description":"A caddy (also called a grip) is a collection of transparent UI elements that are shown in the viewport window. 3ds Max currently uses the caddy to allow the user to perform operations on editable polygon mesh surfaces, but it can be used wherever a plug-in requires convenient in-canvas controls.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Action System",
"href":"./files/GUID-FF327102-B922-44BC-99AF-E06B0F15FD2E.htm",
"description":"The action system is used for customizing the user interface. Plug-ins may use this to customize the 3ds Max main menu, toolbars, quad menus and keyboard shortcuts.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Classes Involved in the Action System",
"href":"./files/GUID-D36879B2-8310-4983-8338-58924FB11074.htm",
"description":"The following are the primary classes involved in the ACtion System.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Action System","href":"./files/GUID-FF327102-B922-44BC-99AF-E06B0F15FD2E.htm"}]},
{"title":"Building Action Tables",
"href":"./files/GUID-2E3B98AA-A65A-4BBD-A744-127E2013C17E.htm",
"description":"This section discusses the approach developers may use to build action tables and make them available to the system. In most cases building an action table is fairly easy. There is more work involved if you choose to implement your own class derived from ActionItem, but in most cases that isn\'t needed.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Action System","href":"./files/GUID-FF327102-B922-44BC-99AF-E06B0F15FD2E.htm"}]},
{"title":"When to Derive from ActionTable and ActionItem",
"href":"./files/GUID-6E2B3452-ACC0-4598-94AF-95F1834BB076.htm",
"description":"Developers have the option of deriving their own classes from ActionTable and ActionItem, but are not required to do either. Only ActionCallback is required to be derived.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Action System","href":"./files/GUID-FF327102-B922-44BC-99AF-E06B0F15FD2E.htm"}]},
{"title":"Registering Action Tables",
"href":"./files/GUID-A699B2F6-3E75-476F-B02E-C70624105CE5.htm",
"description":"In order for 3ds Max to use an action table, it need to be registered. For most plug-ins, this is done by returning it\'s action table in the following methods in the plug-ins class descriptor:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Action System","href":"./files/GUID-FF327102-B922-44BC-99AF-E06B0F15FD2E.htm"}]},
{"title":"Keyboard Accelerators and Dialog Messages",
"href":"./files/GUID-600B5841-6AFD-44B5-9E81-662AE02934E4.htm",
"description":"Keyboard Shortcuts Important Note: A new system to handle keyboard accelerators was added for R4. This system supercedes those used in previous release. For information on this system see Class Acti",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Action System","href":"./files/GUID-FF327102-B922-44BC-99AF-E06B0F15FD2E.htm"}]},
{"title":"Menu Manager",
"href":"./files/GUID-DABBD2F4-27C0-4538-ADC7-898354694E26.htm",
"description":"The menu manager API lets plugins register menus and menu contexts that are saved in 3ds Max\'s menus customization file (found at UI\\MaxMenus.mnu by default) , and can be configured by the user.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Extending 3ds Max\'s Default Menus",
"href":"./files/GUID-91C8620E-5054-4680-9293-0DC2E899E5C0.htm",
"description":"A plug-in can use a MenuContext to register new menu items on to 3ds Max\'s default menu bar or quad menus. Since 3ds Max gets its menu configuration from a file plug-ins should only register their extensions a single time. To determine if the menu extensions have been registered yet, the plug-in should register a menu context using the ImenuManager::RegisterMenuContext() method. This method will return false if the context has not been registered, and true if it has. After the context is registered, it is saved in the menu file, and the next time 3ds Max starts, the call to RegisterMenuContext()will return false.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Menu Manager","href":"./files/GUID-DABBD2F4-27C0-4538-ADC7-898354694E26.htm"}]},
{"title":"Menu Context IDs",
"href":"./files/GUID-53C39A49-8887-4AC4-B889-E89DA4946811.htm",
"description":"Every menu context needs a unique 32-bit integer identifier. The IDs for 3ds Max\'s built-in contexts are defined in the iMenuMan.h header file. New plug-ins should use a random, fixed, integer value for the context. This can be generated using the \"gencid.exe\" program in 3ds Max\'s SDK. Just use one of the 2 32-bit values generated.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Menu Manager","href":"./files/GUID-DABBD2F4-27C0-4538-ADC7-898354694E26.htm"}]},
{"title":"IMenuBarContext",
"href":"./files/GUID-F0264858-13EE-4D97-8B90-0D4E9DEB1E8B.htm",
"description":"3ds Max comes with one pre-defined IMenuBarContext, which is used to obtain the menu used on 3ds Max\'s main menu bar. Its context id is kMenuContextMenuBar. When a plugin wants to add items or sub-menus to the main menu bar, it should get the menu from the main menu bar context as follows:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Menu Manager","href":"./files/GUID-DABBD2F4-27C0-4538-ADC7-898354694E26.htm"}]},
{"title":"Units of Measurement",
"href":"./files/GUID-688177EC-210E-4547-8873-000BBCFDA613.htm",
"description":"3ds Max allows users to work with units that they are most comfortable with. Users may specify that they wish to work in US Standard units (Inches, Feet, Miles) or Metric units (Millimeters, Centimeters, Meters or Kilometers). Or they may specify a custom setting (for example perhaps they want to work in fathoms). Users may also work with generic units (these are the same as the default 3ds Max master units).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Getting and Setting User Preferences",
"href":"./files/GUID-133FD819-9B3E-463C-A735-C8EEC5834569.htm",
"description":"This section provides an overview of the global functions, classes and methods used to retrieve and set the user preferences of 3ds Max. Many of these are from the various pages of the Customize / Preferences... dialog.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Custom User Interface Controls",
"href":"./files/GUID-38B8C8F7-7572-42F3-8C2C-ED6445091BF4.htm",
"description":"A set of custom controls are available for use in the user interface design of 3ds Max plugins. The 3ds Max program itself makes extensive use of these custom controls. These controls provide an important element of consistency between the plug-in and the system, making new plugins appear fully integrated with 3ds Max. The use of these controls by the majority of developers will provide a level of familiarity for users who often work with many different plugins.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Available Custom Controls",
"href":"./files/GUID-E78066A5-88F1-4FAB-8605-687338140293.htm",
"description":"Custom Edit Controls This control is a simple text input control. The user may type any string into the field and the plugin is notified when the user presses the ENTER key. There are also method",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Custom User Interface Controls","href":"./files/GUID-38B8C8F7-7572-42F3-8C2C-ED6445091BF4.htm"}]},
{"title":"Creating a Rollup Page using Custom Controls",
"href":"./files/GUID-1B71DE38-548D-418C-85F8-D650B34305BD.htm",
"description":"The tool for creating the rollup page portion the user interface of your plugin is the dialog editor of Visual C++ Developers Studio. You use the dialog editor to create the rollup page, and place and arrange the controls.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Custom User Interface Controls","href":"./files/GUID-38B8C8F7-7572-42F3-8C2C-ED6445091BF4.htm"}]},
{"title":"Processing User Input from Custom Controls",
"href":"./files/GUID-8A3EC3AB-68EE-468A-AD8D-2005639E876C.htm",
"description":"Windows uses a \'Dialog Procedure\' created by the developer to handle the users manipulation of the controls in the dialog,. As the user works with the controls, Windows sends messages to the dialog procedure. The developer is responsible for responding to these messages and implementing the logic to process the user input. A full description of this messaging system is beyond the scope of this documentation, but below is a brief overview.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Custom User Interface Controls","href":"./files/GUID-38B8C8F7-7572-42F3-8C2C-ED6445091BF4.htm"}]},
{"title":"Methods and Classes of Custom Controls",
"href":"./files/GUID-EC7DAFCD-91D3-4EFA-9BC4-98D32123FB3B.htm",
"description":"For each control, there are two functions that you\'ll always use:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Custom User Interface Controls","href":"./files/GUID-38B8C8F7-7572-42F3-8C2C-ED6445091BF4.htm"}]},
{"title":"Parameter Editing on the Command Panel",
"href":"./files/GUID-C8AE5707-64E0-4388-85F4-774621C510A2.htm",
"description":"This section discusses the editing of an item\'s parameters in the command panel. Plug-in types such as procedural objects, modifiers, space warps, and controllers may all present their user interface in the command panel.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Command Modes and Mouse Procedures",
"href":"./files/GUID-006DE220-0F0A-4BB9-BD8B-28E6A24D5239.htm",
"description":"In addition to any user interface that a plug-in may provide in the command panel via rollup pages, a plug-in may want to process mouse interaction in any of the viewports. Command modes allow the plug-in developer to define custom user / mouse interaction procedures. The system uses command modes as well. Examples are the viewport manipulation commands such as zoom and arc-rotate. Move, rotate and scale are implemented as command modes as well.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Guidelines for Handling Character Strings",
"href":"./files/GUID-64C92BBA-4A45-40DE-9A94-E14E61FDC324.htm",
"description":"This section presents information developers need to know when using character strings in 3ds Max. It discusses the meaning of the TSTR, _T, and TCHAR macros that are commonly seen in the source code examples. This section also covers important substitutes for the standard C str* functions, and some general functions that are available for use with character strings.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Schematic View Window",
"href":"./files/GUID-F6A6830C-AB28-408B-8242-2A7E5E95DB30.htm",
"description":"The Schematic View window allows users to browse, and perform certain operations on, many of the objects that compose a 3ds Max scene. Like Track Views, multiple Schematic Views can be opened within 3ds Max, both in modeless windows and docked in viewports.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Schematic View API",
"href":"./files/GUID-9F316DF8-847E-4058-820F-F0C9F00A0AA2.htm",
"description":"There currently are three interfaces into the schematic view objects. IGraphObjectManager, IGraphNode, and IGraphRef. IGraphObjectManager represents an instance of a schematic view window and provides methods for adding nodes and node pointers, refreshing the schematic view, accessing filter bits and updating and controlling the various editors within 3ds Max in ways that are not surfaced in the general interface. IGraphNode represents a node in the schematic view graph and provides a few methods for querying information about the node. Finally, IGraphRef represents a node pointer and, currently, has no methods. Each of these three interfaces is described in greater detail below.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Schematic View Window","href":"./files/GUID-F6A6830C-AB28-408B-8242-2A7E5E95DB30.htm"}]},
{"title":"Schematic View Events",
"href":"./files/GUID-1896DD3D-9217-4CEB-9E6B-6D20E48DB486.htm",
"description":"The events that occur in the schematic view are either generated by the user (clicking on a node, etc.) or transmitted to the schematic view via a GlobalReferenceMaker::NotifyRefChanged() message.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Schematic View Window","href":"./files/GUID-F6A6830C-AB28-408B-8242-2A7E5E95DB30.htm"}]},
{"title":"Schematic View Relationships",
"href":"./files/GUID-674260BA-FF8B-4D34-9A35-0B8384C1F40C.htm",
"description":"Animatable derived classes can add relationships to schematic view by override the Animatable::SvTraverseAnimGraph() method. In Relationships are added to schematic view during scene traversal. If SvTraverseAnimGraph is already implemented, add your relationship code after the existing code. In our example, the default implementation for controllers (Control::SvTraverseAnimGraph()) is called first. Valid flags to the method Animatable::SvTraverseAnimGraph() are values of type SvRelationshipType.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"},{"title": "Schematic View Window","href":"./files/GUID-F6A6830C-AB28-408B-8242-2A7E5E95DB30.htm"}]},
{"title":"Windows Themes Support",
"href":"./files/GUID-F5CEEF33-EA90-4DFC-AEDC-3740E238CB0E.htm",
"description":"3ds Max supports Windows themes. This means that when the user changes the color theme used by Windows, the user interface of 3ds Max will update automatically to reflect the changes to the Windows theme.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Vista Aero Support",
"href":"./files/GUID-62B51442-0EBC-49B0-948B-19241959DB6D.htm",
"description":"With the introduction of Windows Vista, Microsoft offered a new visual theme called Aero. This produced incompatibility with mixing GDI draw calls with a hardware accelerated window, such as DirectX. In previous versions of 3ds Max, many viewport operations gave visual feedback implemented with XOR lines in GDI. This typical scenario would produce viewport artifacts where an XOR line is being drawn with Aero active, as illustrated by the white artifacts in the image below:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Tabbed Dialogs",
"href":"./files/GUID-CE6BC5F3-BA64-42DD-B19D-70A6000138CA.htm",
"description":"Developers can use the tabbed dialog system to create their own tabbed dialogs as well as working with 3ds Max\'s own tabbed dialogs. The steps below present a how-to guide for doing this. Theses step",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Processing Controls not Managed by the Parameter Map",
"href":"./files/GUID-19128D47-813D-445D-94CC-D65B6324FC04.htm",
"description":"Some controls may need to be processed by the developer directly. For example the sphere has a \'Create\' button in the \'Keyboard Entry\' rollup. Button controls are not processed by parameter maps. In order to process the messages sent when the user operates the button, the developer needs to derive a class from ParamMapUserDlgProc and set it as the parameter map\'s user using SetUserDialogProc().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Windows Message Filtering",
"href":"./files/GUID-B9B28ECA-3A46-42E3-8F24-9E83D6DAABFA.htm",
"description":"A common idiom used in progress dialogs is to remove all messages from the windows message queue except for paint messages and messages indicating that processing must be aborted (e.g. the escape key was pressed). By handling paint messages the application can continue to be responsive and prevent Windows from labeling the process as unresponsive.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Icons",
"href":"./files/GUID-5B25806E-6088-41C6-B420-C343C236D973.htm",
"description":"It is possible for the plug-ins to use icons in their user interfaces (e.g. command panels). These icons are alpha-composited background icons and reside as *.bmp files in the \\UI\\Icons folder and are loaded during startup. It is also possible for the developers to integrate one or more resource based icons in their plug-in DLL file. In this case, those resource based icons will need to be converted to external icons and be stored as 24-bit image files with associated 24-bit alpha mask image files. The name of these files follow a fairly standard naming convention. As an example, the material editor icons and image files will be used for the following outline. The icon image files for this example can be found in the \\UI\\Icons folder as:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Adding a Customized, Plug-in Specific Tab to the Ribbon UI",
"href":"./files/GUID-FD1CC838-BF50-4E7C-B486-7C056BA8975E.htm",
"description":"Some plug-ins might want to add a custom tab to the ribbon interface to make it more convenient for the users to use the plug-in features. The easiest method to do this is for the developers to create their desired tab including all ribbon controls, with their assigned action items and their desired properties. This is explained in the 3ds Max user help in the topic “Surface Modeling > Graphite Modeling Tools > Customizing the Ribbon”.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "User Interface","href":"./files/GUID-FCE8DA50-E6E7-42EF-B82E-BA35970AD239.htm"}]},
{"title":"Function Publishing",
"href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm",
"description":"The function publishing system allows plug-ins to publish their major functions and operations in such a way that code outside the plug-in can discover and make enquiries about these functions and is thus able to call them though a common calling mechanism. Functionality that is exposed through function publishing can be controlled from scripts written in MAXScript.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Principal Function Publishing Classes",
"href":"./files/GUID-137CD00D-17A0-4BC8-983A-D795E0F55C7D.htm",
"description":"The following are the principal classes that are involved in the function publishing API.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"The Function Publishing API",
"href":"./files/GUID-477499D8-E1E7-41B8-80FD-59C771F01F8E.htm",
"description":"The Function Publishing API consists of two main components, a function descriptor system and a function calling mechanism. The descriptor system is used by the publishing component to declare the functions it is publishing and provide necessary descriptive data and may be used by a component\'s client to enquire about published functions. The calling system is used by a component\'s client to invoke one of the published functions.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"What would a Plug-in Publish?",
"href":"./files/GUID-D0929ED4-C309-4A72-A3AC-2166118EC75F.htm",
"description":"The various kinds of functions published by a plug-in usually fall into the following categories. You can, however, publish anything you want.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Mesh Example",
"href":"./files/GUID-E5CF8DC5-A334-4234-8883-A04F27126FB1.htm",
"description":"Within your plug-in, each interface is usually organized into 3 separate sections of code:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Mixin Interfaces",
"href":"./files/GUID-36BDFD5F-6FD4-4298-984C-3A8F6CF99F7D.htm",
"description":"Object Based Mixin Interfaces A variant of the FPInterface, known as a Mixin interface, is provided and can be multiply-inherited by a plug-in\'s class and returned via its implementation of the abov",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Publishing Mixin Interface on Arbitrary Classes",
"href":"./files/GUID-FF9D3BEA-4210-4F04-A43A-FD56DA4FB5D9.htm",
"description":"Publishing Mixin Interface on Arbitrary Classes You can publish FnPub mixin interfaces on any class, not just Animatable subclasses. To do this, you inherit from, IObject, a new virtual base class i",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Passing FPInterfaces as Parameters and Results",
"href":"./files/GUID-A12519E9-8CF4-4C7B-97A1-4A65306ED01D.htm",
"description":"FPInterfaces themselves can now be passed directly as parameters and results via the new type, TYPE_INTERFACE. These turn up in MAXScript as instances of a new value class, FPInterface, with all the interface\'s methods accessible as properties.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Core Interfaces",
"href":"./files/GUID-B430D4C1-9FB0-4B8D-B11C-03B58E97B8B2.htm",
"description":"There is an interface descriptor flag, FP_CORE, which must be specified on Core interface descriptors. Static Core interface descriptors are now automatically registered with the Core, so you do not need to explicitly call RegisterCOREInterface() on them. The code examples below include a Core interface using this flag. The following example taken from the DragAndDrop manager interface.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Action Interfaces",
"href":"./files/GUID-35BA0061-F4E1-4C47-A718-E691A3A9B648.htm",
"description":"Action interfaces only contain UI Action Functions that provide a programmatic method of \"pressing\" buttons and keys in the UI for a plug-in. As mentioned in the opening section of this doc, these action functions have certain special characteristics and possess additional descriptive metadata, relative to the functions we\'ve described so far. Here\'s an annotated Action Interface example for the EdMesh system we looked at above.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"ParamMap2 Buttons",
"href":"./files/GUID-9F13BE72-999D-474E-8B06-0336FBF0057D.htm",
"description":"ParamMap2 Buttons The f_ui option for an Action Function can be used to make the ParamMap2 system connect the action function to a button in a ParamMap2-mediated rollup in your plug-in\'s UI. This me",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"The FPInterface Class Hierarchy",
"href":"./files/GUID-6E4BEA95-D9C7-4AC6-8620-AF5FEC222028.htm",
"description":"The FPInterface class hierarchy is such that static and mixin interfaces and interface descriptors each have their own types.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Parameter Validation",
"href":"./files/GUID-42707EF1-A608-44BB-BF13-BE6E86950599.htm",
"description":"An interface descriptor can now contain validation information for individual parameters, so that clients such as MAXScript can validate values given as parameters to FPInterface calls, prior to making the call. The validation info can be in the form of a range of values for int and float types, or more generally, a validator object that is called the validate a parameter value.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Exception Handling",
"href":"./files/GUID-D4B183E2-457C-41E8-8E18-56057C1E8112.htm",
"description":"FnPub interface functions can report fatal error conditions to callers by using C++ exception-handling. There is a new exception base class, MAXException, defined in iFnPub.h that can be thrown directly, or subclassed as needed for error grouping. The class is defined as follows:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Property Accessors",
"href":"./files/GUID-A6905361-A880-4139-9054-299F3CD926E1.htm",
"description":"It is possible to expose C++ functions to maxscript interfaces as a property, rather an as a function. A LayerProperties interface for example has properties such as on, lock, current etc. that can be read and written to. These properties remain as C++ level functions, but are accessed as properties in MAXScript by using the standard dot-notation for members.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Symbolic Enumerations",
"href":"./files/GUID-F6682E4B-2604-41E9-B6E7-3F98E4D7B026.htm",
"description":"One or more symbolic enums, similar to C++ enums, can now be added to an FPInterface\'s metadata, and individual int parameters and/or results for functions in that interface can be defined as TYPE_ENUM and associated with one of the enum lists. This allows metadata clients to support symbolic encodings for these parameters and results, which MAXScript now does.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Additional ParamType2 Codes for Function Publishing and MAXScript",
"href":"./files/GUID-EF5DD75B-3827-4276-90D7-2490391B99BF.htm",
"description":"ParamType2 Codes TYPE_FPVALUE // FPValue*, variant value TYPE_VALUE // MAXScript Value* TYPE_FPVALUE can be used to pass a variant data type, containing one of the types of data that FPValu",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"},{"title": "Symbolic Enumerations","href":"./files/GUID-F6682E4B-2604-41E9-B6E7-3F98E4D7B026.htm"}]},
{"title":"Parameter/Result Types",
"href":"./files/GUID-1F91B4B3-D94B-4BA8-B671-3888C481A4AC.htm",
"description":"More parameter/result types have been added and the type system has been generalized to allow you to specify pass-by-reference, pass-by-pointer and pass-by-value variations of the appropriate base types. This permits a wider range of interface method signatures in FnPub interfaces, particularly those with \'&\' reference types typically used for passing back values via parameters. The scripter has been upgraded to support all these new types and pass-by options (see also the MAXScript section here for details).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"},{"title": "Symbolic Enumerations","href":"./files/GUID-F6682E4B-2604-41E9-B6E7-3F98E4D7B026.htm"}]},
{"title":"Added Base Types",
"href":"./files/GUID-B52A964F-0199-412D-972B-6DFDAAFFFA6C.htm",
"description":"All the new base types are passed naturally as pointers, so there are _BV and _BR variants for all of them (except for TYPE_HWND). There are also _TAB, _TAB_BR, _TAB_BV variants for them all. For reference, all the currently available types are in the ParamType2 enumeration in /include/iparmb2.h. Some base types are naturally passed by value, others by pointer. Basically, all the int and float-derived types are passed naturally by-value and all the rest by pointer. The by-value base types are:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"},{"title": "Symbolic Enumerations","href":"./files/GUID-F6682E4B-2604-41E9-B6E7-3F98E4D7B026.htm"}]},
{"title":"Supported Types",
"href":"./files/GUID-CEDD7F6E-95A5-444B-824A-FE7AAAC4FD72.htm",
"description":"The type codes you can use to specify function return types or argument types are defined by the ParamType2 enumeration in \\include\\paramtype.h. Several of the type codes map to the same underlying C++ type, for example there are five float types. In most cases, the alternate codes imply different UI scaling Dimensions that are honored by systems like MAXScript. For example, using TYPE_ANGLE will cause MAXScript to convert back and forth between radians internally and degrees to the user, so you should use the most specific type code.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Published Functions and MAXScript",
"href":"./files/GUID-B69EE54B-434D-4B0B-B700-91124D948F98.htm",
"description":"MAXScript automatically provides access to all functions published by a plug-in via the FnPub system. The current scheme is experimental and may change somewhat. Each plug-in class appears in MAXScript as a 3ds Max class object, that can be used to construct instances of the plug-in, do class tests, etc. If a plug-in publishes interfaces, they are visible in MAXScript as properties on this class object. The internal name for the interface is used as the property name. All the functions in the interface are accessible as named properties on the interface. So, if the previous example interfaces were published by EditMesh, the following script frags would work:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Extending Animatable::GetInterface()",
"href":"./files/GUID-168B3A70-A7C8-49FB-9207-D5E51ECDFF5F.htm",
"description":"The following method is part of class Animatable:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Global Function Publishing API Functions",
"href":"./files/GUID-127D6E31-6996-49EA-A444-D841C3D3C588.htm",
"description":"The following are global methods for working with the function publishing API:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Using FPInterface::Invoke()",
"href":"./files/GUID-3475339A-A28B-4AB1-84D8-2114A1075F75.htm",
"description":"In some cases one might end up with a pointer to an object derived from FPInterface, which has some methods published using the function publishing system, but that are not exported in a .LIB or .DLL file. For example a third party plug-in. In this case one may used FPInterface::Invoke().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"Function Publishing Example",
"href":"./files/GUID-D169E068-990B-407A-86BC-525CD7412570.htm",
"description":"The following is an example of function publishing taken from the Position constraint controller example, in the file \\Samples\\Controllers\\Position_cnstrnt.cpp. The IPosConstPosition class represents an interface to the Position constraint. This class inherits from FPMixinInterface which means that it can expose it functionality using the function publishing API.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Function Publishing","href":"./files/GUID-D11DA39D-8190-44A6-B5B1-8F5E94FDA46F.htm"}]},
{"title":"MAXScript Scripting Engine",
"href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm",
"description":"3ds Max comes with a scripting language called MAXScript. The API for the scripting engine is included in the 3ds Max SDK in the sub-folder /maxscrpt (note the missing \'i\') and in the import library Maxscrpt.dll.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"MAXScript Compiler and Interpreter",
"href":"./files/GUID-574458F5-644A-4EF3-A21A-C7943A6B02BF.htm",
"description":"The MAXScript engine executes MAXScript code using the following steps:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"MAXScript Expression Parsing",
"href":"./files/GUID-0E7CE28A-D2C1-4772-A8EB-A4DBF3671EAA.htm",
"description":"When MAXScript parses an expression on the command line that contains names, it looks for a variable with this name in the current scope and then outer scopes, out to the global scope. If it doesn\'t find a variable with this name, it creates one in the current scope.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"MAXScript Values",
"href":"./files/GUID-42194C3D-4B99-41CD-A55D-90E06D5DF4D1.htm",
"description":"The MAXScript engine represents values using the class Value or a derived class. The Value class is defined in the file maxscrpt\\value.h. The MAXScript engine also uses wrapper classes to act as proxies for objects in the 3ds Max SDK. These wrapper classes derive from the MAXWrapper class which is defined in the file maxscrpt\\maxobj.h. The MAXWrapper class derives from both Value and ReferenceTarget. Some examples of proxy classes include MAXObject, MAXNode, MAXModifier, and MAXControl.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"The MAXScript Garbage Collector",
"href":"./files/GUID-BB424C59-28C2-40E5-B66A-F717E8D13936.htm",
"description":"All instances of Value or a class derived from Value are managed automatically by the MAXScript garbage collector unless marked as permanent.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"MAXScript Functions",
"href":"./files/GUID-D814573C-23FA-476C-A48A-017038927C0A.htm",
"description":"MAXScript functions are represented using the class MAXScriptFunction defined in the header file maxscrpt\\funcs.h. If you have an instance of MAXScriptFunction you can use the following method to evaluate the function:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"Exposing a Function to MAXScript",
"href":"./files/GUID-016E96CE-F224-458D-9AC8-84C8E8403D5E.htm",
"description":"Note: This topic is about manually exposing a function to MAXScript using the MAXScript API. Most often a plug-in would use the function publishing system to expose functions to MAXScript. For more information see the section on Function Publishing.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"MAXScript Distinguished Values",
"href":"./files/GUID-F37E84F8-405A-4336-B35C-B47C57D8A2C5.htm",
"description":"There are several distinguished values in MAXScript that are implemented as global instances of their classes. Some examples are:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"Local Variables in MAXScript Exposed Functions",
"href":"./files/GUID-5230478B-A4AB-4161-8390-4A1FA005A949.htm",
"description":"When writing functions that are exposed to MAXScript through and that use Value instances it is common practice to declare local variables using special macros found in maxscrpt/maxscrpt.h that protect them from the collector.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"Calling MAXScript from C++",
"href":"./files/GUID-5CC913A0-E7CC-457B-9EE4-EAA79B8AF2B4.htm",
"description":"The global function ExecuteMAXScriptScript() can be used to execute MAXScript from C++. This function has the following signature:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"Useful MAXScript Tips",
"href":"./files/GUID-8C5868F0-82B9-461A-8BF7-6A41101AD12B.htm",
"description":"Accessing the 3ds Max SDK You can load the Autodesk.Max.dll assembly to use the 3ds Max SDK from MAXScript. Add the following MAXScript code to your start-up scripts and use the MaxGlobal variable to",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"MAXScript Global Variables",
"href":"./files/GUID-6BCB711C-C057-4DA9-A797-34197986950A.htm",
"description":"You can define new system global variables with the define_system_global() function. It has the following signature:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"Wrapping 3ds Max Objects",
"href":"./files/GUID-F757DE47-D928-43B4-923B-FE8AACC6C240.htm",
"description":"All of the 3ds Max object types (i.e. instances of classes derived from Object) accessible in MAXScript are represented by instances of the MAXWrapper and derived classes. These are declared in the header file maxscrpt/maxobj.h. The wrapped reference is a reference created with ReferenceMaker::ReplaceReference(). The MAXWrapper class inherits from both Value and ReferenceMaker. This reference allows MAXScript to be notified of MAX-side changes to the object, particularly deletion.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"Instantiating Wrappers",
"href":"./files/GUID-D6503B56-5EFD-419D-8244-F172081841AB.htm",
"description":"There are three ways to make wrapper values for a MAX object you have in hand, depending on how much you know about what kind of object it is. In many cases you can use a wrapper class constructor directly.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"},{"title": "Wrapping 3ds Max Objects","href":"./files/GUID-F757DE47-D928-43B4-923B-FE8AACC6C240.htm"}]},
{"title":"Extracting Wrapped Objects",
"href":"./files/GUID-4AD5F97A-C4CE-4E22-B146-23C2F9343F9F.htm",
"description":"You can get MAX objects out of MAXScript wrapper values in several ways.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"},{"title": "Wrapping 3ds Max Objects","href":"./files/GUID-F757DE47-D928-43B4-923B-FE8AACC6C240.htm"}]},
{"title":"Handling Deleted Wrapped Objects",
"href":"./files/GUID-660D1581-489E-47AF-91EC-E23F0FA056A9.htm",
"description":"There is a potential in MAXScript for a wrapper value to reference a deleted MAX object. This might happen, for example, if a global variable contains a MAXNode value and the user interactively deletes the object that the MAXNode references. It is critical for any code that works with wrapper values to first check to make sure the wrapped MAX objects are not deleted using the macro: deletion_check() which takes a MAXWrapper derived class instance. This macro will throw an appropriate runtime error if the Max object referenced by \'val\' is deleted. If you want to handle the error reporting yourself or perform some conditional code, you can test the MAXWrapper::ref_deleted which holds a BOOL.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"},{"title": "Wrapping 3ds Max Objects","href":"./files/GUID-F757DE47-D928-43B4-923B-FE8AACC6C240.htm"}]},
{"title":"Advanced MAXScript Topics",
"href":"./files/GUID-65EC1DAF-84AB-4EEE-B876-488D7A70CCB1.htm",
"description":"This section contains a number of topics related to advanced usage of the MAXScript scripting engine.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"}]},
{"title":"MAXScript Functions with Optional Arguments",
"href":"./files/GUID-F303B1CA-11FB-4A47-BE50-66C566B8C0A0.htm",
"description":"MAXScript functions also support optional arguments, using a mechanism called keyword argument passing. The keyword arguments are placed in the argument list of the C++ function after all the mandatory positional argument, and are preceded by a marker value. The marker value is accessible in the global variable keyarg_marker which has type Value*. The arguments are passed in pairs, a keyword name and the argument\'s value, in the arg_list array.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"},{"title": "Advanced MAXScript Topics","href":"./files/GUID-65EC1DAF-84AB-4EEE-B876-488D7A70CCB1.htm"}]},
{"title":"Local Value Arrays",
"href":"./files/GUID-F95F920A-D10C-464F-B87B-8C5DACFE04FE.htm",
"description":"If the number of new locals to be protected is unknown at compile you can use the following macros that create protected arrays of values. One form creates the array on the stack using _alloc() and so is useful inside one function call, the other puts the array in the heap and so can be used across functions. In both cases, you also need to declare a Value** variable to hold the pointer to the array.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"},{"title": "Advanced MAXScript Topics","href":"./files/GUID-65EC1DAF-84AB-4EEE-B876-488D7A70CCB1.htm"}]},
{"title":"MAXScript Marshalling of Function Arguments",
"href":"./files/GUID-76C00831-8F07-4045-808C-3766D3C23D3D.htm",
"description":"MAXScript needs to convert arguments from the internal representation to the actual C++ function. This is commonly done using the def_visible_primitive macro found in the maxscrpt\\definsfn.h header.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "MAXScript Scripting Engine","href":"./files/GUID-7EC2A963-D8D4-44C6-AA34-21C0687268D6.htm"},{"title": "Advanced MAXScript Topics","href":"./files/GUID-65EC1DAF-84AB-4EEE-B876-488D7A70CCB1.htm"}]},
{"title":"Character Studio",
"href":"./files/GUID-A9B3817C-ACD9-4397-872B-0CF798B15C9D.htm",
"description":"The character studio functionality in 3ds Max provides professional tools for animating 3D characters. It is an environment in which you can quickly and easily build skeletons and then animate them, thus creating motion sequences. You use the animated skeletons to drive the movement of geometry, thus creating virtual characters. You can also generate crowds of these characters using character studio, and animate crowd movement using a system of delegates and procedural behaviors.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Biped Hierarchy",
"href":"./files/GUID-214B4DED-6462-4B17-975C-81AED881E2C2.htm",
"description":"The biped hierarchy that is used to determine the relationships between the biped parent and child body parts is different from the hierarchy presented by the max nodes parent/child relationships. The reason for this difference is to make the biped move more naturally when it is being animated. For example, the upper arm links inherit their rotation from the center of mass, instead of from the clavicle, to which they are connected. This enables you to animate the spine without counter rotating the arms.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Character Studio","href":"./files/GUID-A9B3817C-ACD9-4397-872B-0CF798B15C9D.htm"}]},
{"title":"Physique Export Interface",
"href":"./files/GUID-0DF3BC77-3ABF-45E5-B991-525EAC847542.htm",
"description":"Character studio includes export functionality for game developers who which to import physique vertex assignments into their game engines. The physique export API is contained in the file PhyExp.h.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Character Studio","href":"./files/GUID-A9B3817C-ACD9-4397-872B-0CF798B15C9D.htm"}]},
{"title":"Main Physique Export API Elements",
"href":"./files/GUID-744DCA21-D0C5-4564-AE4B-7508305A2D3A.htm",
"description":"The following is a list of primary classes and functions in the physique export interface contained in the file PhyExp.h.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Character Studio","href":"./files/GUID-A9B3817C-ACD9-4397-872B-0CF798B15C9D.htm"},{"title": "Physique Export Interface","href":"./files/GUID-0DF3BC77-3ABF-45E5-B991-525EAC847542.htm"}]},
{"title":"Accessing Physique Vertex Assignments",
"href":"./files/GUID-7DF6298F-D1CE-4F26-81DB-1635215951FF.htm",
"description":"To access the physique vertex assignments from a node associated with a physique modifier you must:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Character Studio","href":"./files/GUID-A9B3817C-ACD9-4397-872B-0CF798B15C9D.htm"},{"title": "Physique Export Interface","href":"./files/GUID-0DF3BC77-3ABF-45E5-B991-525EAC847542.htm"}]},
{"title":"Finding a Physique Modifier",
"href":"./files/GUID-4C860D06-7E6A-4D7D-862A-C05DAD2E7029.htm",
"description":"Below is a code example, for finding a physique modifier if it exists for a given INode:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Character Studio","href":"./files/GUID-A9B3817C-ACD9-4397-872B-0CF798B15C9D.htm"},{"title": "Physique Export Interface","href":"./files/GUID-0DF3BC77-3ABF-45E5-B991-525EAC847542.htm"}]},
{"title":"Using the Physique Export Interface",
"href":"./files/GUID-40EEB516-7B53-4890-AAFC-DB10295DA3B1.htm",
"description":"Below is a code example using the physique export interface (IPhysiqueExport) which uses the function FindPhysiqueModifier() from the topic Finding a Physique Modifier.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Character Studio","href":"./files/GUID-A9B3817C-ACD9-4397-872B-0CF798B15C9D.htm"},{"title": "Physique Export Interface","href":"./files/GUID-0DF3BC77-3ABF-45E5-B991-525EAC847542.htm"}]},
{"title":"3DXI",
"href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm",
"description":"The 3ds Max Data Exchange Interface (3DXI, previously named IGame) was developed in response to the need for easy-to-use data extraction tools. Game software developers, in particular, have their hands full programming their games while game artists are busy creating visuals using 3ds Max. These game developers needed a quick way to export artist-created 3ds Max scenes with only a minimal understanding of the extensive 3ds Max SDK. 3DXI is now used by a broader group of export tool developers as the applicability of 3ds Max has broadened to other markets.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"3DXI Overview",
"href":"./files/GUID-B8A93D0F-6D6E-4953-9D28-092D0D9C5B92.htm",
"description":"The 3ds Max Data Exchange Interface (3DXI) is used for building exporters from 3ds Max. 3DXI is built on top of the existing 3ds Max SDK, providing wrapper interfaces for the most common aspects of data export from 3ds Max. 3DXI supports the following 3ds Max objects:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Contrasted with 3ds Max SDK",
"href":"./files/GUID-D45B4E5F-554C-4777-BF79-1EA9AC9DDDBB.htm",
"description":"The following two code samples contrast extracting data using the core 3ds Max SDK and the 3DXI, by using the example of extracting controller data.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Initialization",
"href":"./files/GUID-03FB3C9E-7EDA-4A05-87BD-557F0775294D.htm",
"description":"Before you can begin using 3DXI, it must be initialized by obtaining a pointer to the main IGameScene. The following code snippet is an example:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Export Entities",
"href":"./files/GUID-D97A2357-AEF8-4D65-8514-BD927282066C.htm",
"description":"All 3ds Max objects that can be exported using 3DXI are represented in 3DXI by an object derived from IExportEntity.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Property Containers",
"href":"./files/GUID-F8F9EECA-CD69-444A-B851-E0C0A73DA39B.htm",
"description":"Each IExportEntity stored in the 3DXI database supports IPropertyContainer. This interface is responsible for finding the properties on the entity. It loops through the various places where parameter blocks can be stored, gathering custom object data and custom attributes, if applicable. Developers should request this interface if they want to access any plug-in specific parameters.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Scene",
"href":"./files/GUID-ABB55465-BC3E-475A-AC07-DC94383A5001.htm",
"description":"The IGameScene object maintains a list and count of the top-level nodes (IGameNode) and materials (IGameMaterial). Each top-level interface, whether node or material, maintains that node\'s list of children. As well as providing a count of the top-level nodes, IGameScene maintains a count of nodes in the scene. This is something that you would have had to perform as a pre-process with the main 3ds Max SDK.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Node",
"href":"./files/GUID-7FC0870E-2266-48C3-808F-90808B2FD0F7.htm",
"description":"The IGameNode is a container which maintains a scene object, any controller associated with that object, or a material in the scene. The following code demonstrates how materials are accessed at the root level using IGameScene. One call to IGameScene::GetRootMaterialCount() obtains the number of materials in the scene, and an enumeration of the count provides a direct index into the material list using IGameScene::GetRootMaterial().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Objects",
"href":"./files/GUID-3251D144-0079-4CD4-BBE7-00F9DCFD63D8.htm",
"description":"An IGameObject is a scene entity with relevant properties. IGameObject defines the type of object, whether a camera, a lights etc. IGameNode is the container for IGameObjects. The developer must then cast the object to its correct interface, as shown in the following code from the IGameExporter sample (edited for clarity):",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Lights and Cameras",
"href":"./files/GUID-B71B73F3-19B2-4F07-9163-16F588648093.htm",
"description":"All light and camera properties are exported as an IGameProperty. This includes any animated light objects and multiplier data as well as any include/exclude data for lights. The light and camera types, in addition to the nodes for the targets, are also supported.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Helper Objects",
"href":"./files/GUID-2DFB88C2-8A92-4810-98A5-10A22E68E31F.htm",
"description":"Helper objects, including bones, are wrapped as instances of IGameSupportObject. This is a very simple interface that mostly provides access to the main IPropertyContainer interface. However, an IGameMesh pointer, provides additional access to the helper\'s geometry.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Generic Objects",
"href":"./files/GUID-8D42DD95-8E9C-4849-919C-68FD7EEB3974.htm",
"description":"Any object unknown to the game interface is wrapped as an IGameGenObject. The only available access is to the basic properties of the Object, through the IPropertyContainer interface.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Mesh",
"href":"./files/GUID-12C232D0-0D9C-411A-8ED4-F8E712A101C0.htm",
"description":"The IGameMesh object provides complete access to all the mesh relevant data including normals, mapping channels, tangents and binormals, vertex information, and texture coordinates. It also takes care of such things as mirroring, which is again something that can cause unexpected results when exporting as the normals will appear to be flipped.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Materials and Textures",
"href":"./files/GUID-27144A65-7B44-47B3-99B1-9E8810D5BC5B.htm",
"description":"Materials are stored globally as IGameMaterial, with each node providing an index into this global array. The standard 3ds Max material (StdMtl2) is directly supported with methods for getting basic material data such as ambient and diffuse color, glossiness and opacity. Other material found provides access to the IPropertyContainer so that parameter extraction is possible using IGameProperty.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Controllers: IGameControl",
"href":"./files/GUID-97909672-9495-4D23-ACC1-7CDF7F8AA072.htm",
"description":"IGameControl provides direct access to standard key frame controllers in 3ds Max. This is particularly useful to game developers, because they know what type of controller they are exporting as defined by their game engine.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Animation Keys",
"href":"./files/GUID-048F8C83-CE09-4C09-9196-DF5CC582082D.htm",
"description":"Extracted keys are stored in the IGameKey class that maintains a list for all the Key types: bezier, TCB, linear and sampled. Data is accessed depending on the controller type. The code sample below retrieves all the bezier keys for position:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Splines",
"href":"./files/GUID-39A33BEB-D275-4680-8205-20B14D90ADB0.htm",
"description":"Any spline-based IGameObject can be converted to an IGameSpline object. This object is a container for the actual spline data, represented as one or multiple IGameSpline3D objects, depending on how many splines the original 3ds Max spline consisted of.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI IK Chains",
"href":"./files/GUID-3900A8A3-9E5A-4B21-9505-D9F1D7E64695.htm",
"description":"IGameIKChain provides direct access to an inverse kinematics (IK) chain. This means the character could be exported based on its IK setup. Each IK chain consists of a set of linked nodes. These nodes are then under the control of the end effector running in either IK or forward kinematic (FK) mode. This mode is determined by an On/Off controller which can be accessed through IGameIKChain interface.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Modifiers",
"href":"./files/GUID-5E05CE45-8E66-45A8-9C0C-1009247915D8.htm",
"description":"3DXI provides direct access to modifiers using the IGameObject interface with no knowledge of derived objects or internal mechanisms. IGameObject maintains a list of modifiers applied to the object with access to both the name used in the stack and the internal name, so the developer can simply determine if the modifier is needed.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Error Reporting",
"href":"./files/GUID-5886ED3F-03BA-41BF-977F-0771B41A5FB6.htm",
"description":"During an error condition most 3DXI functions set a global error code. Two global functions are available are GetLastIGameError() for retrieving the last error code and GetLastIGameErrorText() for the last error message.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"3DXI Custom User Data",
"href":"./files/GUID-71D6A1C8-32BC-4FFA-A8BF-39A174FF8010.htm",
"description":"Every node in 3ds Max can have user data added to it using the object properties dialog box. 3DXI can extract such data as an IGameProperty. Access to it is defined through the IGameProp.xml file. It uses the data found in the <ExportUserData> field to correctly extract the data found. Each piece of user data is contained in a <UserProperty>. The following table enumerates UserProperty elements:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "3DXI","href":"./files/GUID-9DB54608-A85E-417F-A5AB-97599E0E8ADD.htm"}]},
{"title":"The Undo and Redo System",
"href":"./files/GUID-E4955E4E-A358-4C66-8504-5A3CD3B20D89.htm",
"description":"3ds Max has a built-in system for handling undo and redo. This allows users to undo their previous modifications to the scene state and redo previously undone modifications. The user may undo several operations, and also redo several undo operations.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"How to Enable Undo and Redo",
"href":"./files/GUID-1B6B1C44-6D70-4A41-A720-0D1FF1A10D8D.htm",
"description":"The undo / redo system is managed by a global instance of the Hold class called theHold. To use the undo / redo system the developer must derive a class from RestoreObj and register an instance with the theHold using the method theHold::Put(). The class derived from RestoreObj saves the data needed to undo and redo the operation of the plug-in and to implement several methods required by 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "The Undo and Redo System","href":"./files/GUID-E4955E4E-A358-4C66-8504-5A3CD3B20D89.htm"}]},
{"title":"Undo and Redo Example",
"href":"./files/GUID-1C7CE1D4-B206-4206-889D-1A4CA340F58F.htm",
"description":"As a simple example consider a utility plug-in that allows the user to change the wire-frame color of a node in the scene. The restore object needs to save the previous color and a pointer to the node being changed. It also needs storage to save the current color prior to an undo. This allows it to revert the undo.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "The Undo and Redo System","href":"./files/GUID-E4955E4E-A358-4C66-8504-5A3CD3B20D89.htm"}]},
{"title":"Deriving from RestoreObj",
"href":"./files/GUID-FB4C68D7-D5A0-47D4-A1B0-03B81ACE94C6.htm",
"description":"A restore object must be defined by the developer that derives from RestoreObject. An instance of this class must be registered with the theHold global object by passing it to the Hold::Put() method. The restore object should save just enough data to restore the current scene state to where it was before it was modified by an action. In other words, the restore object must restore the state of the scene to the one it was in when theHold. Put() was called with this restore object because other actions may have occurred since Begin() was called. The restore object also saves data to allow a redo operation to occur.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "The Undo and Redo System","href":"./files/GUID-E4955E4E-A358-4C66-8504-5A3CD3B20D89.htm"}]},
{"title":"Scene State Changes that Cannot be Undone",
"href":"./files/GUID-C6082E62-D607-4024-BF51-9C5B9BEF600E.htm",
"description":"When 3ds Max is exited or reset the save requester is only brought up if there is something on the undo stack. If a plug-in makes a change that cannot be undone, a flag must be set that will indicate to the system that the save requester needs to be brought up. There are three API functions related to this:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "The Undo and Redo System","href":"./files/GUID-E4955E4E-A358-4C66-8504-5A3CD3B20D89.htm"}]},
{"title":"Flushing the Undo Buffer",
"href":"./files/GUID-59055701-36A1-447A-B94C-8D85857F750E.htm",
"description":"If a plug-in developer needs to clear the undo buffer, two API functions are available to do so. The method Interface::FlushUndoBuffer() and the global function: GetSystemSetting() with the ID SYSSET_CLEAR_UNDO as a parameter.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "The Undo and Redo System","href":"./files/GUID-E4955E4E-A358-4C66-8504-5A3CD3B20D89.htm"}]},
{"title":"Super-holds",
"href":"./files/GUID-8D79CB93-02F2-425A-B600-9D29F1560D57.htm",
"description":"The methods Hold::SuperBegin(), Hold::SuperAccept(), and Hold::SuperCancel() together form the concept of a super-hold. This allows a developer to group a set of Hold::Begin() / Hold::Accept() sequences to be undone in one operation.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "The Undo and Redo System","href":"./files/GUID-E4955E4E-A358-4C66-8504-5A3CD3B20D89.htm"}]},
{"title":"Undo Memory Limits",
"href":"./files/GUID-772414DA-0D33-45EE-BE22-1BDAB8736AC9.htm",
"description":"If RestoreObj::Size() returns a value that exceeds 4000000 (~4Mb) then 3ds Max may exhibit inconsistent behavior then not every object passed to theHold. Put() appears in then Undo/Redo Menu, some of them of them are skipped.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "The Undo and Redo System","href":"./files/GUID-E4955E4E-A358-4C66-8504-5A3CD3B20D89.htm"}]},
{"title":"Miscellaneous Topics",
"href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm",
"description":"This section contains numerous topics which do not fit nicely into the other categories.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"Collections",
"href":"./files/GUID-AC741776-FD86-4522-A049-93A75BF97915.htm",
"description":"3ds Max uses a template class called Tab (short for table) as a general purpose collection class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Color Palettes",
"href":"./files/GUID-F0845032-7059-4718-866A-91DFEBE08CFF.htm",
"description":"When operating in 8-bit mode, 3ds Max uses a 256 color palette. Plugins should avoid changing the system palette because this can cause the quality of the 3ds Max display to degrade. The palette used by 3ds Max reserves the bottom 10 slots and top 10 slots of the palette for Windows colors. It also contains a 6x6x6 RGB color cube, and a 16 gray level ramp. This palette should be adequate for most purposes. When a plugin wants to output bitmaps and colored areas with dither, so as to get good approximations of 24 bit colors in 8-bit modes, it should make use of the GPort class. The GPort also provides access to 8 \"animated palette slots\" to allow dynamically altering system palette entries.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Plugin.ini",
"href":"./files/GUID-3C9643C8-85BE-4449-9D03-4592A95EC606.htm",
"description":"The system plug-in paths are loaded from two locations:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Structure edit_window",
"href":"./files/GUID-34A66306-F763-49B2-B8D8-B58E30FCA4CF.htm",
"description":"Every MAXScript editor window has an associated edit_window struct. This can be accessed using the GetWindowLong() windows API and the GWL_USERDATA constant as follows:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Post-Load Callbacks",
"href":"./files/GUID-10B717D2-9D29-4A02-BEFF-786797853FB4.htm",
"description":"A post-load callback is a function object derived from PostLoadCallback. Post-load callbacks are used for any processing that must happen immediately after loading, for example when upgrading parameter block versions, or from parameter block 1 to parameter block 2. A post-load callback is registered with the 3ds Max file loading system through a call to ILoad::RegisterPostLoadCallback().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Parameter Maps",
"href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm",
"description":"Parameter maps are the interface between the a plug-ins command panel user interface (specifically its dialog procedure) and a parameter block. The parameter map performs a lot of the default processing of UI events. For the most part parameter maps are managed behind the scenes by the system.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"The Relationship between Parameter Blocks and Parameter Maps",
"href":"./files/GUID-07033953-2843-4A50-9E1E-EE073EE989E9.htm",
"description":"Parameter blocks handle the storage of variables, and parameter maps handle events and the UI. The UI communicates to parameter maps and the user interface communicate by methods, window & dialog procedures and other events. Parameter maps ultimately pass data back to the parameter block.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Using Parameter Maps",
"href":"./files/GUID-EA365EDC-825C-4ACB-A230-81ED7DB22161.htm",
"description":"Parameter maps handle most of the command panel user interface processing. Shown below are the three roll-up pages of the command panel added by the Sphere object. Except for the \"Create\" button, all the controls are managed by the parameter map.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Basic Concepts of Parameter Maps",
"href":"./files/GUID-854833DB-88E3-4372-A83E-B3F794E05D41.htm",
"description":"A parameter map can be considered as a table of parameter handlers. The parameter map provides the processing required to map the UI controls to the variables that these controls affect. The parameter map operates on an array of parameters. Each control is one element of the virtual array. Each roll-up page in the command panel is treated as its own virtual array.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Deriving from IParamArray",
"href":"./files/GUID-07E5EC80-09D5-4BAC-A324-FA6A57444942.htm",
"description":"A plug-in that uses parameter block 1 would usually inherit from IParamArray in addition to its basic plug-in base class. For example:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Adding the Roll-up to the Command Panel",
"href":"./files/GUID-7829592F-AABB-4099-8D79-F53446F5E8F5.htm",
"description":"When the user may edit an object\'s parameters the rollup pages must be added to the command panel. This can be done using the CreateCPParamMap() function. This function creates a parameter map to handle the display of parameters in the command panel. Shown below are two samples from the sphere\'s Animatable::BeginEditParams() method.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Removing the Roll-up from the Command Panel",
"href":"./files/GUID-2CD8E8C1-CDCC-48E6-9B45-C02722242B75.htm",
"description":"When the user is done editing the sphere\'s parameters, the DestroyCPParamMap() method is used to remove the rollup page from the command panel and release the controls associated with the parameter map. It is called from the Animatable::EndEditParams() method.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Backward Compatibility",
"href":"./files/GUID-3952B37A-7AB1-4F12-B550-0F7F398B86EF.htm",
"description":"As development evolves on a plug-in, the use of its parameter blocks may change. For example, more parameters may be added or some may be deleted. 3ds Max files that were saved using the old version of the plug-in would not normally load properly under the new format. In order to provide backward compatibility with the older format a mechanism exists to allow the old format to be converted to the new format.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Creating the Parameter Block and Referencing It",
"href":"./files/GUID-33265B4B-B6AC-4A1E-8209-3AFE89C84C24.htm",
"description":"A parameter block 1 must be created from the parameter block descriptors (ParamBlockDescID). Items in the parameter block are referred to by index. The index is derived from the order in which the descriptors appear in the ParamBlockDescID array.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Declaring the UI Variables",
"href":"./files/GUID-129581E0-7B27-4894-B448-9E51BACA6796.htm",
"description":"The developer must declare several which are pointers to IParamMaps. Each parameter map manages a single roll-up page in the command panel.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Describing the Controls",
"href":"./files/GUID-E1EC988F-0C66-4E10-82E9-CBA17AD1B2EA.htm",
"description":"The developer must define the ParamUIDesc arrays to establish the properties of the UI controls such as their type (spinner, radio button, check box, etc.), which resource ID they refer to, and which index into the virtual array they use. Below is the ParamUIDesc array for the parameters roll-up page. It calls several overloaded constructors passing the values needed to describe the controls. See the ParamUIDesc Reference section for detailed information on the constructors.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Providing a Name and Dimension for the Parameters",
"href":"./files/GUID-9779F79E-9164-4282-93D9-E52D199F7BF7.htm",
"description":"The developer must provide a name for each parameter used in a parameter block. This name is needed because the animated parameters show up in the track view and must be labeled. The parameter block takes care of displaying them in the track view, but has no idea of the name for each one, it only knows them by index. The developer provides the name to display by implementing the method GetParameterName() and returning the name of the parameter whose index into the parameter block is passed.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"Setting Up the Parameter Block",
"href":"./files/GUID-B8B3FE7D-1C1E-4506-A167-1D61801C5387.htm",
"description":"Several of the controls used allow animated values. For example, the radius, and segments parameters may be animated. The developer uses a parameter block to store these values. The developer must define the parameter block descriptor which describes the properties of each parameter.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Parameter Maps","href":"./files/GUID-2677B761-CC71-4EAB-B9C7-9C5445623C73.htm"}]},
{"title":"3ds Max Initialization and Finalization",
"href":"./files/GUID-6141404F-0513-4515-90E3-87FB0BDCABBE.htm",
"description":"The following are the initialization and finalization steps of 3ds Max that concern a plug-in\'s DLL.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"COM/DCOM Interface",
"href":"./files/GUID-92218725-669B-4735-A913-6D527EE8C9EB.htm",
"description":"The idea behind this COM (Component Object Model) object is to expose the core of 3ds Max so applications can invoke 3ds Max to generate images. The whole implementation of the COM interface was done as a plug-in itself so developers have the option of enhancing it in any manner they wish. Not just by adding interfaces to this object but also by creating entire new objects using this implementation as a code base. The code is extensively documented and the test \"Client Application\" is also extensively documented in a way where even developers who don\'t have any experience with COM objects can make use of it. For those with experience, the 3ds Max COM interface is implemented entirely using ATL which makes it very simple to add and/or modify any aspect of the code.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Snapping",
"href":"./files/GUID-2D411788-70EE-47B9-A7BD-B5FD8D9DD145.htm",
"description":"Objects snaps are a plug-in type that allow objects to provide the 3ds Max snapping system with additional points that may be snapped to. For example, the built in snap system provides the ability to snap to points such as vertices, endpoints, midpoints, etc. A developer of a procedural sphere object might want to provide additional snaps for center point and quadrant points. By deriving a class from Osnap and implement its methods a developer can seamlessly provide this functionality in 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Thread Tools",
"href":"./files/GUID-8E2308EC-0962-4D15-BA41-7A44DEC3667B.htm",
"description":"The MaxSDK::PerformanceTools::ThreadTools class allows you to control the amount of threading in various parts of 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Working with MFC",
"href":"./files/GUID-37A48634-DD42-4A25-AAF9-4EA6D83FAE18.htm",
"description":"The Microsoft Foundation Classes (MFC) can improve programmer productivity when using the Windows API heavily. There are two known issues with the interaction between 3ds Max and MFC.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Managing Scene States",
"href":"./files/GUID-34FEBFB8-683A-4A4E-83A0-B9D6B500E5BD.htm",
"description":"The scene state management feature accessible provides users a fast way to save different scene conditions with various lighting, camera, material, environment, and object properties that can be restored at any time and rendered to produce numerous interpretations of a model. The user can save and restore scene states with the Manage Scene States dialog.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"Inverse Kinematics",
"href":"./files/GUID-8258E827-D402-4043-A934-14296933C238.htm",
"description":"The Inverse Kinematics (IK) API\'s are divided over three files: IIKSys.h, IKSolver.h, and IKHierarchy.h. IIKSys.h contains the interface definition of the two types of controllers, IIKControl and IIKChainControl. They are both TM controllers. The former is used in joints (nodes on which IK will be applied), and the latter is used in the IK goals (nodes that serve as IK goals).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"}]},
{"title":"IK Concepts",
"href":"./files/GUID-C2B0D05F-1453-4518-857D-C7A3EC8A3212.htm",
"description":"Degrees of Freedom A node transform contains six degrees of freedom. Three are translational (sliding) and three are rotational. In the API, they have enum names, IKSys::TransX to IKSys::TransZ and",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Inverse Kinematics","href":"./files/GUID-8258E827-D402-4043-A934-14296933C238.htm"}]},
{"title":"IK Solvers",
"href":"./files/GUID-D3EA023A-8DAE-44F1-8FF1-7A65674B9B2C.htm",
"description":"Being a plugin itself, the IK system allows the solver to be a separate plugin. The IKSolver class defines the base class that plugin solver should derive from. The IK solver is a pure mathematical function: it does not hold state and just solves a given, self-contained, mathematical problem. In other words, the plugin solver does not have influence on when IK is invoked and what an IK problem is (what is the goal and what are the joints, etc.), but contributes to IK by answering how to solve. Structurally, it is independent of the SDK and, hence, can be built independently, except for some theoretically independent math library.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Inverse Kinematics","href":"./files/GUID-8258E827-D402-4043-A934-14296933C238.htm"}]},
{"title":"IIKChainControl",
"href":"./files/GUID-97B14C2B-19AF-4E1C-9CC5-01ECDE8A0B1B.htm",
"description":"Reference Indices The following enum constants are indices to the reference targets made by the IIKChainControl. For example, GetReference(IIKChainControl::kPBlockRef) will return a pointer to IPara",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Inverse Kinematics","href":"./files/GUID-8258E827-D402-4043-A934-14296933C238.htm"}]},
{"title":"IK System Interfaces",
"href":"./files/GUID-A46A2FBB-AF55-4FDE-9DC0-CBE90C1DA377.htm",
"description":"The IK system services two interfaces, one through the CORE, and the other through the IK Chain Controller class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"},{"title": "Miscellaneous Topics","href":"./files/GUID-56AAB72B-644D-4D88-BAB6-627E21D573A3.htm"},{"title": "Inverse Kinematics","href":"./files/GUID-8258E827-D402-4043-A934-14296933C238.htm"}]},
{"title":"Tips and Tricks",
"href":"./files/GUID-0FA27485-D808-40B7-8465-B1C293077597.htm",
"description":"This section contains a set of useful tips and tricks for working with the 3ds Max SDK.Accessing the Parameter Block of Any Plug-in – If a plug-in does not explicitly provide access to its parameter b",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max SDK Features","href":"./files/GUID-757AE68E-E42E-48FC-8E7C-108DC63F69D5.htm"}]},
{"title":"3ds Max .NET SDK",
"href":"./files/GUID-572EF4D7-A817-4ED4-B85F-4ABA8F8482AA.htm",
"description":"3ds Max exposes some of the SDK as .NET assemblies, and provides a sample .NET plug-in. 3ds Max does not provide a loader for .NET plug-ins, so you must write a .NET plug-in by using C++/CLI (also called Managed C++). This is demonstrated by the Scene Explorer Extension sample.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"}]},
{"title":"3ds Max .NET Assemblies",
"href":"./files/GUID-A08A117C-9D15-4044-BC29-3AD9F8AFD9FE.htm",
"description":"The 3ds Max .NET SDK consists of the following .NET assemblies (DLLs). They can be found in the root folder 3ds Max application installation.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max .NET SDK","href":"./files/GUID-572EF4D7-A817-4ED4-B85F-4ABA8F8482AA.htm"}]},
{"title":"Autodesk.Max.dll",
"href":"./files/GUID-11E2AFBB-E488-4DAD-927F-2A1D35E74BB4.htm",
"description":"With the release of the Subscription Advantage Pack for 3ds Max 2012 there have been significant enhancements to the exposure of 3ds Max SDK to .NET. Previously only a small subset of the 3ds Max SDK was exposed to .NET via the ManagedServices.dll. Now nearly all of the global functions and classes in the SDK can be accessed directly from .NET using the new Autodesk.Max.dll.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max .NET SDK","href":"./files/GUID-572EF4D7-A817-4ED4-B85F-4ABA8F8482AA.htm"},{"title": "3ds Max .NET Assemblies","href":"./files/GUID-A08A117C-9D15-4044-BC29-3AD9F8AFD9FE.htm"}]},
{"title":"Loading 3ds Max .NET Assemblies",
"href":"./files/GUID-BEE074AD-9B78-43B8-8F67-9C2BB25B9C23.htm",
"description":"The plug-in loader has been created specifically for .NET plug-ins which makes it safer for 3ds Max to load and unload .NET and mixed-mode 3ds Max plug-ins. Assemblies (DLLs) which contain .NET or C++/CLI plug-ins should now be placed in the bin/assemblies subfolder of the 3ds Max installation, instead of the plugins folder. Note: Placing managed mixed-mode assemblies in stdplugs and not in bin/assemblies, is risky and can crash the application.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max .NET SDK","href":"./files/GUID-572EF4D7-A817-4ED4-B85F-4ABA8F8482AA.htm"}]},
{"title":".NET Action Items",
"href":"./files/GUID-400FD28A-3D1C-4D10-9C1C-DD21377FA852.htm",
"description":"It is now possible to create custom action items in a .NET assembly. This is done by creating a public class that implements the interface ICuiActionCommand (found in MaxCustomControls.dll) and placing the DLL containing the implemented interface in the bin\\assemblies folder. 3ds Max will then dynamically load an instance of this class as an action in its CUI interface. When the action is executed by 3ds Max the method ICommand.Execute() will be called on the loaded class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max .NET SDK","href":"./files/GUID-572EF4D7-A817-4ED4-B85F-4ABA8F8482AA.htm"}]},
{"title":".NET User Interface",
"href":"./files/GUID-F5FF5286-819A-4850-AFCF-4269A5B49AE1.htm",
"description":"You can create a user interface (UI) using the .NET API and the Windows Presentation Foundation (WPF) or Windows Forms.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max .NET SDK","href":"./files/GUID-572EF4D7-A817-4ED4-B85F-4ABA8F8482AA.htm"}]},
{"title":"Using C++/CLI",
"href":"./files/GUID-38FCEFFB-7973-47C8-8032-4DE8F47192F9.htm",
"description":"To enable interoperability between managed .NET code and native unmanaged C++ code, Microsoft created the C++/CLI language as a superset of native C++. The C++/CLI compiler is available in Visual Studio 2008, and is enabled by using the command-line option /clr. The C++/CLI Language Specification is published by ECMA International as Standard ECMA-372 and is available for download at the following link:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max .NET SDK","href":"./files/GUID-572EF4D7-A817-4ED4-B85F-4ABA8F8482AA.htm"}]},
{"title":"Troubleshooting .NET Plug-ins",
"href":"./files/GUID-3EA93F6A-87AF-4383-869C-51C8253FB568.htm",
"description":"This section contains a list of common problems encountered when developing 3ds Max plug-ins in .NET. These particular issues were chosen for discussion here because they tend to have limited documentation available and were more difficult to debug or resolve. Other common issues are not listed here because they are covered by resources elsewhere, either in the MSDN documentation, in the 3ds Max SDK documentation, or in most .NET books.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "3ds Max .NET SDK","href":"./files/GUID-572EF4D7-A817-4ED4-B85F-4ABA8F8482AA.htm"}]},
{"title":"Writing Plug-ins",
"href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"}]},
{"title":"Building the Sample Plug-ins",
"href":"./files/GUID-BD77D3D4-2B5A-4A8A-A6B4-25AC8C376A87.htm",
"description":"The SDK provides sample code for many of the plug-in types. This section discusses the procedure to build and run the sample plug-ins included in the SDK. The sample plug-ins can be found in the \\samples and \\howto sub-folders of your 3ds Max SDK installation directory.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Configuring the Development Environment",
"href":"./files/GUID-F49589B2-EBB7-4C77-9F2C-1AD35488FB29.htm",
"description":"When building a new 3ds Max plug-in, Visual Studio needs to know where to find header files and library files. You can do this for each individual project, but it should be easier to update the Visual Studio global settings. This can be done by going to the Visual C++ options dialog (accessed from the menu Tools > Options ...), and selecting in the node \"Projects and Solution > VC++ Directories\".",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Building the Sample Plug-ins","href":"./files/GUID-BD77D3D4-2B5A-4A8A-A6B4-25AC8C376A87.htm"}]},
{"title":"Hybrid, Debug, and Release Build Configurations",
"href":"./files/GUID-AF966D24-7646-4EE2-AC0D-DEA05DA277B9.htm",
"description":"The Hybrid configuration is intended for use when creating debug builds of your plug-in. When you\'ve finished development and want to create your DLL for distribution change this to Release and rebuild.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Building the Sample Plug-ins","href":"./files/GUID-BD77D3D4-2B5A-4A8A-A6B4-25AC8C376A87.htm"}]},
{"title":"Running Plug-ins",
"href":"./files/GUID-C57D25D4-F9A0-4945-9C92-D63578AB8C7F.htm",
"description":"3ds Max loads plug-ins from two places: the \"plugins\" and the \"stdplugs\" subfolders of your 3ds Max installation folder. You can either copy the output file manually after it is built successfully, or you can direct Visual Studio to copy the file using the project properties dialog (see Configuration Properties > General). The location you should use depends on whether you are building a sample plug-in, or you are building a new plug-in",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Building the Sample Plug-ins","href":"./files/GUID-BD77D3D4-2B5A-4A8A-A6B4-25AC8C376A87.htm"}]},
{"title":"Creating a Plug-in Project",
"href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm",
"description":"This topic covers the steps for creating a plug-in project either manually or by using the AppWizard. Note that some plug-in types can only be created manually at this time. You can also customize one of the template plug-in projects available online at www.autodesk.com/3dsmax-sdk-docs.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Using AppWizard to Create a New Project",
"href":"./files/topichead_0.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"}]},
{"title":"Installing the Plug-in Wizard (AppWizard)",
"href":"./files/GUID-D465CBEE-0923-4250-857A-DED1A4B11B77-1.htm",
"description":"The 3ds Max Plug-in Wizard (commonly called the AppWizard) is an add-in for Visual Studio that builds skeleton plug-ins for 3ds Max. You simply have to specify what plug-in type you would like to build, and follow the directions in the wizard. The wizard generates the Visual Studio project files, the CPP files, and skeleton code with \"TODO\" comments. The 3ds Max Plug-in Wizard (commonly called the AppWizard) is an add-in for Visual Studio that builds skeleton plug-ins for 3ds Max. You simply have to specify what plug-in type you would like to build, and follow the directions in the wizard. The wizard generates the Visual Studio project files, the CPP files, and skeleton code with \"TODO\" comments.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Using AppWizard to Create a New Project","href":"./files/topichead_0.htm"}]},
{"title":"Using the Plug-in Wizard",
"href":"./files/GUID-4B706997-C946-4C1D-8A69-0A0AC14A1D9B.htm",
"description":"The 3ds Max plug-in wizard, is a Visual Studio AppWizard, that creates skeleton 3ds Max plug-ins. The plug-in wizard must be installed manually, see the topic Installing the Plug-in Wizard (AppWizard).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Using AppWizard to Create a New Project","href":"./files/topichead_0.htm"}]},
{"title":"Manually Creating a New Plug-in Project",
"href":"./files/topichead_1.htm",
"description":"",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"}]},
{"title":"Creating the DEF File",
"href":"./files/GUID-806002A3-06E6-46B5-8B07-C2F5E2BF1DB4.htm",
"description":"The DEF file is a module definition file. The DEF lists the exported DLL functions. A DEF file is an ASCII text file containing one or more module statements that describe various attributes of a DLL. A DLL requires a DEF file to create an import library (LIB) file and an export (EXP) file. The linker uses the import library to build any executable module that uses the DLL, and uses the export file to build the DLL file.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Manually Creating a New Plug-in Project","href":"./files/topichead_1.htm"}]},
{"title":"Required DLL Functions",
"href":"./files/GUID-608B1265-B25E-47BB-A49B-5AF2A27F71CC.htm",
"description":"This topic describes the functions expected by 3ds Max for most plug-in DLL.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Manually Creating a New Plug-in Project","href":"./files/topichead_1.htm"}]},
{"title":"Adding a Resource Script to the Project",
"href":"./files/GUID-E1211E01-4E62-480F-9BB2-C416EC76CE3B.htm",
"description":"The resource script file (RC file) defines all resources used by the plug-in. A resource is binary data that a resource compiler adds to an application\'s executable file. This may be a string table, icon,cursor, menu, dialog box, bitmap, etc. Any rollup pages or dialogs you create to implement your user interface will be stored in the RC file. The resource compiler will generate an include file which you must include in your source file.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Manually Creating a New Plug-in Project","href":"./files/topichead_1.htm"}]},
{"title":"Adding a String Table",
"href":"./files/GUID-BF30E97A-506D-4B49-ABF0-FC7653919D08.htm",
"description":"Most plug-ins will require string tables. Not only do they make it easier to make changes to the user interface or perform localization, they are also used by 3ds Max for retrieving the name of a parameter block as displayed on a roll-out window.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Manually Creating a New Plug-in Project","href":"./files/topichead_1.htm"}]},
{"title":"Specifying the Include Files",
"href":"./files/GUID-6BB60406-EB8A-43F8-A15F-B527DB58FF3E.htm",
"description":"You now need to specify the path of the include files for the SDK:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Manually Creating a New Plug-in Project","href":"./files/topichead_1.htm"}]},
{"title":"Specifying the Output File",
"href":"./files/GUID-CAAF72D2-52AD-4488-AE1A-F44EF000717E.htm",
"description":"You now need to specify the output file name. The output file path consists of three parts: the directory path, the filename and the extension. Starting with Visual Studio 2010, the file path specified in the Linker > General > Output Directory property needs to match the paths specified under Configuration > General. That means the directory portion of the output path must match the Configuration > General > Output Directory property. Also the filename portion of the output path must match the Configuration > General > Target Name property. And the file extension part of the output path must match the Configuration > General >Target Extension property. If the paths do not match, the compiler will emit a long verbose warning. Therefore the easiest and best way to specify the output path is to specify the three separate elements of the output path under Configuration > General. For example:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Manually Creating a New Plug-in Project","href":"./files/topichead_1.htm"}]},
{"title":"Plug-in File Extensions",
"href":"./files/GUID-D51D5C82-D7E6-4837-957D-E5AA484BC8D7.htm",
"description":"There are certain file name extensions that plug-in DLLs must use. 3ds Max uses these standard extensions as part of its search algorithm to determine which files it will attempt to load. Below is a list of the extensions and the plug-in types associated with each one:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Manually Creating a New Plug-in Project","href":"./files/topichead_1.htm"}]},
{"title":"Specifying Library Files for the Project",
"href":"./files/GUID-74A47E55-1111-47A9-90DE-8A5BAD8013A4.htm",
"description":"The library (LIB) files required varies depending on the type of plug-in that is being created. The document Library File Descriptions lists the library files and their uses. Most plug-ins will require the maxutil.lib and core.lib 3ds Max library files.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Creating a Plug-in Project","href":"./files/GUID-BBAC7CB4-CA0C-4D55-8DC4-25DAF484E9E4.htm"},{"title": "Manually Creating a New Plug-in Project","href":"./files/topichead_1.htm"}]},
{"title":"Writing Simple Geometric Object Plug-Ins",
"href":"./files/GUID-1C28E870-4849-4FB7-9516-1CFE189C86B9.htm",
"description":"This section outlines topics specific to writing simple geometric object plug-ins. A geometric object plug-in derives from the class GeomObject. If a geometric object is deformable and represents itself using a mesh it can derive from SimpleObject2. The SimpleObject2 class provides default implementations for a number of functions typically required of a geometric object plug-in.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Object Creation Methods",
"href":"./files/GUID-7DD7407D-E638-4B5A-81C9-AFFB5050D8DD.htm",
"description":"A plug-in can control its interactive creation process in two primary ways:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Simple Geometric Object Plug-Ins","href":"./files/GUID-1C28E870-4849-4FB7-9516-1CFE189C86B9.htm"}]},
{"title":"Programmatic Object Creation",
"href":"./files/GUID-57083AB5-1D18-49B4-BFE4-932B667A96BE.htm",
"description":"Plug-ins that need to instantiate another object should do so from the super class ID and class ID via the global method CreateInstance(). The object will not appear in the scene until a node is associated with the object using the method Interface::CreateObjectNode().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Simple Geometric Object Plug-Ins","href":"./files/GUID-1C28E870-4849-4FB7-9516-1CFE189C86B9.htm"},{"title": "Object Creation Methods","href":"./files/GUID-7DD7407D-E638-4B5A-81C9-AFFB5050D8DD.htm"}]},
{"title":"Handling Mouse Procedures",
"href":"./files/GUID-312D9F64-E451-426E-B93F-928DB432B0E2.htm",
"description":"3ds Max uses a callback mechanism to allow objects to be constructed using the mouse. To support mouse construction a plug-in must return an instance of a class derived from CreateMouseCallBack in its implementation of the function: BaseObject::GetCreateMouseCallBack().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Simple Geometric Object Plug-Ins","href":"./files/GUID-1C28E870-4849-4FB7-9516-1CFE189C86B9.htm"},{"title": "Object Creation Methods","href":"./files/GUID-7DD7407D-E638-4B5A-81C9-AFFB5050D8DD.htm"}]},
{"title":"Dialog Based Creation of Objects",
"href":"./files/GUID-34353741-FB63-49A4-B811-C03F1A2255E6.htm",
"description":"The Interface::NonMouseCreate() method can be used to create a new object / node without going through the usual create mouse procedure sequence. This call must be made when the system is ready to create -- that is during execution of the system-provided default object creation process. To understand how this works consider the example of the Sphere object.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Simple Geometric Object Plug-Ins","href":"./files/GUID-1C28E870-4849-4FB7-9516-1CFE189C86B9.htm"},{"title": "Object Creation Methods","href":"./files/GUID-7DD7407D-E638-4B5A-81C9-AFFB5050D8DD.htm"}]},
{"title":"Creating the Mesh",
"href":"./files/GUID-8573C5B8-347E-4232-84AD-5C9595456647.htm",
"description":"When you develop a geometric object that inherits from SimpleObject2 you will have to construct and initialize the SimpleObject::mesh member variable which is of type Mesh. This is usually done in an override of the SimpleObject::BuildMesh() virtual member function which is called by 3ds Max when the mesh needs to be recreated.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Simple Geometric Object Plug-Ins","href":"./files/GUID-1C28E870-4849-4FB7-9516-1CFE189C86B9.htm"}]},
{"title":"Plug-in Basics",
"href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm",
"description":"This section contains topics that are relevant for writing most kinds of plug-ins.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Generating Class IDs",
"href":"./files/GUID-7733E8C0-A872-4A53-B77F-287FE43DFC8E.htm",
"description":"Almost all plug-ins require a class ID that uniquely identifies the plug-in. A unique class ID can be generated using a program supplied with the 3ds Max SDK gencid.exe. The following screen capture shows the dialog that gencid.exe presents.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Class Descriptors",
"href":"./files/GUID-9C5B4241-2FCE-4EBD-9732-6E2F52368E24.htm",
"description":"Class descriptors provide 3ds Max with information about each plug-ins that is implemented in a DLL, and allows 3ds Max to instantiate them. A plug-in will implement its own class descriptor by deriving from ClassDesc2 which in turn derives from ClassDesc.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Plug-in Identification",
"href":"./files/GUID-D0ECFBAE-2BBE-4592-883B-0AAC597D90FE.htm",
"description":"Each individual plug-in is identified by a Class ID (Class_ID) and the plug-in category is identified by a super class ID (SClass_ID).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Accessing Core 3ds Max Functionality",
"href":"./files/GUID-1123C05C-C5A3-4BC9-B9B6-F3148223C986.htm",
"description":"When writing a plug-in that derives from a base class, 3ds Max will expose much of the necessary functionality through the arguments to the virtual functions that you override. In cases where you need access to additional functionality provided by 3ds Max the global function GetCOREInterface14() can be very useful. This function returns a pointer to a global object of type Interface14, which provides access to much of the core functionality of 3ds Max.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Creating and Destroying Plug-in Instances",
"href":"./files/GUID-33D32EAB-E14A-4087-A894-1E752E53AD3F.htm",
"description":"The 3ds Max API provides a method used to allocate memory when a new instance of a plug-in class is required. It also provides several different ways to deallocate this memory depending on the plug-in type. In the most common case, these methods are ClassDesc::Create() and Animatable::DeleteThis().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Loading and Saving Plug-in Data",
"href":"./files/GUID-D47D210B-A10A-47B2-BFDE-5477ACE40E89.htm",
"description":"3ds Max automatically saves all items referenced by a plug-in when saving the plug-in to a scene file. All parameter blocks are expected to be exposed as references and will therefore be saved and loaded automatically. Any additional data that is not explicitly referenced by the plug-in or contained in a parameter block must be saved or loaded manually.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Creating Parameter Blocks",
"href":"./files/GUID-A8E70985-1F04-4814-B7EF-B1C5EFCAFBA5.htm",
"description":"Parameter blocks are covered in detail in the Parameter Blocks section of the documentation. This section walks through the parameter block construction used by the widget how-to sample. See the file howto/objects/widget/widget.cpp.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Exposing Parameter Blocks to 3ds Max",
"href":"./files/GUID-A501241D-D44D-41D4-8571-2BF1188FD9DD.htm",
"description":"If a plug-in uses parameter blocks, and inherits from Animatable, it must expose the parameter blocks to 3ds Max by overriding the following methods of Animatable:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Command Panel Input",
"href":"./files/GUID-9AE81D5A-DEDA-49CF-9194-2E11981FB5D8.htm",
"description":"A plug-in is responsible for implementing two methods that manage the beginning and ending of user input in the command panel: Animatable::BeginEditParams() and Animatable::EndEditParams(). Animatable::BeginEditParams() is called by the system when the user may edit the entities parameters (this may be during creation or when modifying an existing entity). It is responsible for adding rollup pages to the panel, and registering the rollup page with the system. The method to add a rollup page is called with a dialog procedure function.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Exposing and Managing References",
"href":"./files/GUID-592714A4-B203-4508-8CE9-B2797B15AD3E.htm",
"description":"Virtually all plug-ins derive from ReferenceMaker. This allows them to be notified of changes to that certain functions must be implemented. See the topic Reference Makers and Reference Targets for more information.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Enumerating and Identifying Sub-Animatables",
"href":"./files/GUID-466CDB58-024C-495F-88E8-C0658CA28D56.htm",
"description":"If your plug-in wishes to support the animatable interface and appear in the track view you must identify which sub-objects are animatable. These are called sub-animatables. You can do this by overriding the following methods from the Animatable class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Viewport Functionality",
"href":"./files/GUID-BCBB28D5-E386-4F29-A94B-50EF46FB55BC.htm",
"description":"Many plug-ins (e.g. modifiers and objects) have visual representations in a viewport and must implement a number of functions for displaying themselves in the viewport and interacting with the user.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Implementing Clone in a Plug-in",
"href":"./files/GUID-12F9AC01-4AEA-4AC6-83CA-C8A89885BE51.htm",
"description":"The following code illustrates the recommended method to implement ReferenceTarget::Clone() and ReferenceTarget::BaseClone() in a plug-in when you only have strong references.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Plug-in Versioning",
"href":"./files/GUID-413D6EDB-E80E-4C3D-A33D-DE639B217919.htm",
"description":"When writing a a plug-in it is important to consider that a plug-in should be both backwards and forwards data compatible with other versions of the plug-in.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"}]},
{"title":"Remapping References on Load",
"href":"./files/GUID-FA1119FD-FEA3-4C5B-BACD-376B3C027DB4.htm",
"description":"While loading, a plug-in\'s references are not in place during execution of its ReferenceMaker::Load() method - not until 3ds Max loads the entire file\'s contents. A reference maker can remap an old reference structure to a new one by providing a custom implementation of the function ReferenceMaker::RemapRefOnLoad()",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"},{"title": "Plug-in Versioning","href":"./files/GUID-413D6EDB-E80E-4C3D-A33D-DE639B217919.htm"}]},
{"title":"Parameter Block Versioning",
"href":"./files/GUID-F35959BB-2660-492F-B082-56304C70293A.htm",
"description":"The parameter block versioning system - also known as parameter block revisioning - is implemented as post-load callback that is triggered by 3ds Max when the current parameter block version differs from the previous version. The versioning system is triggered when the following conditions are met:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"},{"title": "Plug-in Versioning","href":"./files/GUID-413D6EDB-E80E-4C3D-A33D-DE639B217919.htm"}]},
{"title":"Adding and Deleting Parameters",
"href":"./files/GUID-7DE0E432-37A3-4FDA-96EF-4FCAC721708E.htm",
"description":"When adding parameters, new parameter IDs may be added at the end or between other parameters",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"},{"title": "Plug-in Versioning","href":"./files/GUID-413D6EDB-E80E-4C3D-A33D-DE639B217919.htm"},{"title": "Parameter Block Versioning","href":"./files/GUID-F35959BB-2660-492F-B082-56304C70293A.htm"}]},
{"title":"Changing Parameter Types",
"href":"./files/GUID-7C740439-15DC-47FB-8562-B4BD19A35CDC.htm",
"description":"Parameter types can be changed by deleting and adding a new parameter. To migrate from the old value a post-load callback must be used. The old parameter ids will be used until after the load and all post-load callbacks are completed",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"},{"title": "Plug-in Versioning","href":"./files/GUID-413D6EDB-E80E-4C3D-A33D-DE639B217919.htm"},{"title": "Parameter Block Versioning","href":"./files/GUID-F35959BB-2660-492F-B082-56304C70293A.htm"}]},
{"title":"Getting and Setting Parameter Block Version",
"href":"./files/GUID-C30143E0-E8F1-4985-8D10-8D849F3086BE.htm",
"description":"The parameter block version is set in the ParamBlockDesc2 constructor as follows:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"},{"title": "Plug-in Versioning","href":"./files/GUID-413D6EDB-E80E-4C3D-A33D-DE639B217919.htm"},{"title": "Parameter Block Versioning","href":"./files/GUID-F35959BB-2660-492F-B082-56304C70293A.htm"}]},
{"title":"Supporting Save to Previous",
"href":"./files/GUID-3473278F-D311-4506-890A-73DFC3537A6A.htm",
"description":"The save to previous feature allows a user to save a scene created in one version of 3ds Max (e.g. 3ds Max 2011) into a file version compatible with an earlier version of the product (e.g. 3ds Max 2010).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Plug-in Basics","href":"./files/GUID-8650A1D4-22E5-4F37-A456-026637CC0786.htm"},{"title": "Plug-in Versioning","href":"./files/GUID-413D6EDB-E80E-4C3D-A33D-DE639B217919.htm"}]},
{"title":"Writing Object Plug-ins",
"href":"./files/GUID-DBB205A2-92C3-4E6A-B2E5-126DA577EA8F.htm",
"description":"This topic covers subjects specific to writing object plug-ins.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Converting Objects to Compatible Types",
"href":"./files/GUID-E164BDB1-94FD-4038-A30E-EE9D2780677D.htm",
"description":"3ds Max objects aren\'t always in a form suitable for a particular type of modifier. Consider the case of a 3ds Max user putting a volume select modifier on a procedural sphere in order to select some vertices within it. A procedural sphere is not defined by vertices and faces. Rather it is defined by it procedural definition, i.e. its radius, segment count, hemisphere setting, etc. But a user can put a volume select modifier on a sphere. The way this is handled is that 3ds Max asks the object if it can be converted to a triangle mesh object (which has vertices and faces). If the sphere responds yes, then 3ds Max asks the sphere to convert itself to one. Then, once the objects is in the form of the triangle mesh, the modifier may alter it. There are two methods that procedural objects implement to allow this to happen. These are Object::CanConvertToType() and Object::ConvertToType().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Object Plug-ins","href":"./files/GUID-DBB205A2-92C3-4E6A-B2E5-126DA577EA8F.htm"}]},
{"title":"Displaying the Object in the Viewport",
"href":"./files/GUID-B7D7291B-BA61-42F2-8910-85B229BB4C81.htm",
"description":"When deriving from a SimpleObject2, a plug-in only has to build the mesh in its override of the virtual function SimpleObject::BuildMesh(). In other plug-ins that derives from BaseObject, the plug-in must draw itself in the viewport in its implementation of BaseObject::Display() function.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Object Plug-ins","href":"./files/GUID-DBB205A2-92C3-4E6A-B2E5-126DA577EA8F.htm"}]},
{"title":"Writing Modifier Plug-ins",
"href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm",
"description":"This section describes the primary steps involved in writing a simple modifier plug-in. The running example used is the Bend modifier derived from class SimpleMod2 that bends existing vertices. The source code to this example can be found in the file \\maxsdk\\samples\\modifiers\\bend.cpp.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Indicating Required Input Object Types",
"href":"./files/GUID-E67791B3-0B31-4E47-AB07-912CCEB7F507.htm",
"description":"A modifier plug-in must implement the method Modifier::InputType() to inform 3ds Max which kinds of input object it requires in order to perform a modification. Most modifiers will ask for deformable objects. See Deformable Objects for more information.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Indicating Required Channels",
"href":"./files/GUID-D53E38D7-8946-4419-B3CE-ABC75092B3A7.htm",
"description":"A modifier must indicate to the system which channels of the pipeline it requires in order to perform its modification. To do this the developer must override the method Modifer::ChannelsUsed(). This specifies the channels that a modifier needs in order to apply its deformation. This should at least contain the channels indicated by the Modifer::ChannelsChanged() method, but may be more. For example, a modifier that applies a UV mapping may need the geometry channel but may only modify the texture map channel.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Indicating Changed Channels",
"href":"./files/GUID-5254C217-6360-4B60-A075-345EDCA3D0B8.htm",
"description":"An object modifier must indicate to the system which channels of the pipeline it is going to modify. To do this, the modifier needs to override the method Modifier::ChannelsChanged(). This method returns a ChannelMask to indicate what channels are changed and that need to be copied by the geometry pipeline. For example, consider a TriObject and a modifier that modifies the geometry channel. Only the geometry channel (vertices) of the TriObject need to be copied before the modifier is applied to the object (not the faces, UV coordinates, material assignments, or anything else).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Performing Object Modification",
"href":"./files/GUID-13C6068F-F1EF-46CD-B77A-065B3659E9CB.htm",
"description":"The plug-in modifier must provide a mechanism to actually modify or deform the object. When a modifier needs to be applied to an object, 3ds Max calls the Modifier::ModifyObject() method. This method is responsible for deforming the object and updating the validity interval of the object to reflect the validity interval of the modifier.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Using a Deformer",
"href":"./files/GUID-F7D688AA-BAF4-4D45-BF64-F814B263FD9E.htm",
"description":"A Deformer derived object implements a Deformer::Map() method that takes an object\'s point and returns a new object. Any modifier can use a deformer, but a simple modifier requires that this mechanism is used. A modifier that inherits from SimpleMod must override SimpleMod::GetDeformer() and return an object that inherits from the Deformer base class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Modifier Validity",
"href":"./files/GUID-E4B616A5-7249-48FD-807B-764E46AFD45D.htm",
"description":"When a modifier is finished deforming the object, it needs to include its validity interval in the validity interval of the object.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Displaying the Modifier Gizmo",
"href":"./files/GUID-525A8226-35C4-4607-88A5-FB9DFE983E05.htm",
"description":"Gizmos (also called the modifier apparatus) are viewport icons that provide a visual representation in the scene of a modifier at that the user can manipulate. They can be as simple as the 3D box used by the bend modifier, or as complex as an FFD lattice.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Sub-Object Selection",
"href":"./files/GUID-156BE43F-5E87-41B3-8C84-917AFBACCE24.htm",
"description":"If the modifier supports sub-object selection, the plug-in must provide methods to allow the system to manipulate the sub-object components of the modifier. When a modifier\'s parameters are being edited, it has the option of providing the system with different levels of sub-object selection. There are two types of sub-object selection:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Implementing Sub-Object Selection",
"href":"./files/GUID-BE07AEE2-C47F-4AE6-AD84-84C9D4B39379.htm",
"description":"A modifier registers its sub-object selection levels when Animatable::BeginEditParams() method is called. The method Interface::RegisterSubObjectTypes() can be used to handle this. It provides the system with a list of strings. These strings are the names of the sub-object selection levels that will appear in the Sub-Object drop down list. For example, the following code would register two sub-object levels, \"Gizmo\" and \"Center\".",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"},{"title": "Sub-Object Selection","href":"./files/GUID-156BE43F-5E87-41B3-8C84-917AFBACCE24.htm"}]},
{"title":"Modifier Selection Methods",
"href":"./files/GUID-F2897A59-5324-4D8A-A7C1-24AACCB92DEA.htm",
"description":"The overall process of sub-object selection relies upon the implementation of several methods in the modifier. These methods are from class BaseObject. These involve selecting, identifying, moving, rotating and scaling sub-object components. These methods are:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"},{"title": "Sub-Object Selection","href":"./files/GUID-156BE43F-5E87-41B3-8C84-917AFBACCE24.htm"}]},
{"title":"Sub-Object Selection in Edit Modifiers",
"href":"./files/GUID-9863CDA7-94A9-4DD9-947A-370CB38353F4.htm",
"description":"The sub-object selection levels for edit modifiers reflect the sub-object types for the object type that the edit modifier is designed to edit. For example, the Edit Mesh modifier supports three sub-object selection levels: vertex, face and edge. These correspond to actual elements of a TriObject. In contrast, the sub-object levels of the Bend modifier, are gizmo and center. These have no correspondence with the object that the bend modifier is modifying.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"},{"title": "Sub-Object Selection","href":"./files/GUID-156BE43F-5E87-41B3-8C84-917AFBACCE24.htm"}]},
{"title":"Edit Mesh Selection Example",
"href":"./files/GUID-714885D1-B3D4-4F64-8EE5-0B22B689C95B.htm",
"description":"The sample code below is from \\MAXSDK\\SAMPLES\\MODIFIERS\\EDITMESH.H. It shows how the extrude command mode of the Edit Mesh modifier uses the SelectionProcessor class to handle selection yet performs its own work after the selection process has been handled. The extrude command mode allows the user to select items with the mouse using all the standard logic such as box selection, and using the Ctrl and Alt keys. If the user drags the mouse however, the extrude operation is performed. By using the selection processor all the logic for selection is handled automatically.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"},{"title": "Sub-Object Selection","href":"./files/GUID-156BE43F-5E87-41B3-8C84-917AFBACCE24.htm"}]},
{"title":"Named Sub-Object Selection Sets",
"href":"./files/GUID-2C6E8EC2-4378-4F7A-A501-705DEB894B41.htm",
"description":"A modifier that supports sub-object selection can choose to support named sub-object selection sets. This allows the user to save and restore certain sub-object selection sets and not have to pick them over and over. The modifier indicates it wishes to do so by returning TRUE from BaseObject::SupportsNamedSubSels().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"},{"title": "Sub-Object Selection","href":"./files/GUID-156BE43F-5E87-41B3-8C84-917AFBACCE24.htm"}]},
{"title":"Sub-Object Coordinate Systems",
"href":"./files/GUID-8ABA408D-9A92-4554-AE37-AEBCF0F12785.htm",
"description":"When a modifier or controller is in a sub-object selection level, it has the ability to define the meaning of some of 3ds Max\'s reference coordinate systems. 3ds Max\'s reference coordinate system has two parts:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"},{"title": "Sub-Object Selection","href":"./files/GUID-156BE43F-5E87-41B3-8C84-917AFBACCE24.htm"}]},
{"title":"Managing Modifier Parameters",
"href":"./files/GUID-C4E90B5B-EC3D-4420-B315-37BB5C3785E6.htm",
"description":"A modifier plug-in may have parameters which are animated or which are constant. The developer decides which of the modifier\'s parameters may be animated. Typically in 3ds Max, every parameter is animatable (provided it makes sense). For instance, the angle and direction parameters of the Bend modifier are animated while the Axis of the bend is not.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Improving Modifier Responsiveness",
"href":"./files/GUID-2EEC93E3-2FDB-4D98-AFA6-054EE3866782.htm",
"description":"When a modifier is being adjusted interactively (i.e. edited) the responsiveness can be improved by forcing the cache to be built after the preceding modifier in the pipeline. This can be done by returning the value NEVER in the implementation of Modifier::LocalValidity().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Modifier Plug-ins","href":"./files/GUID-BEEC36B3-473E-4C59-9ACE-8C03B5FFE01D.htm"}]},
{"title":"Writing Animation Controller Plug-ins",
"href":"./files/GUID-63058407-062E-4119-B138-047DB8FA69FB.htm",
"description":"Controllers are the plug-in type responsible for directing all animation in 3ds Max. The section uses the Position constraint controller as a running example. The files that are relevant for this discussion are:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Serializing Controllers",
"href":"./files/GUID-EE4CF7C1-2B09-495D-9CDA-2C8EE12A54CA.htm",
"description":"When writing the ReferenceMaker::Load() and ReferenceMaker::Save() methods of a controller it is important that the before you read or write any custom data (i.e. chunks) that you call the Control::Load() and Control::Save() functions.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Animation Controller Plug-ins","href":"./files/GUID-63058407-062E-4119-B138-047DB8FA69FB.htm"}]},
{"title":"Position Constraint Workflow",
"href":"./files/GUID-513C7B1D-0404-4820-AF84-81B4523AC5E8.htm",
"description":"The user can employ the Position Constraint to make a source object move to and be coincident with another object, called the target object. Position Constraint,which constrains the position of an object to a target, is similar to instancing the position controller of one object and pasting it on another. Rotation and scaling is completely free. Once engaged, the source object becomes constrained to the target object\'s position. Animating the target object\'s position causes the source (constrained) object to follow.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Animation Controller Plug-ins","href":"./files/GUID-63058407-062E-4119-B138-047DB8FA69FB.htm"}]},
{"title":"Control Virtual Methods",
"href":"./files/GUID-3DC6B273-13BD-41C6-BCAD-1C387D9C4D9A.htm",
"description":"The following methods of Control are often overridden by a plug-in controller.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Animation Controller Plug-ins","href":"./files/GUID-63058407-062E-4119-B138-047DB8FA69FB.htm"}]},
{"title":"CTRL_RELATIVE and CTRL_ABSOLUTE",
"href":"./files/GUID-5846B807-E04A-4714-A662-F9F97204F15A.htm",
"description":"The absolute (CTRL_ABSOLUTE) and relative (CTRL_RELATIVE) options are used by both Control::GetValue() and Control::SetValue() in a similar way.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Animation Controller Plug-ins","href":"./files/GUID-63058407-062E-4119-B138-047DB8FA69FB.htm"}]},
{"title":"Undo and Redo in a Controller",
"href":"./files/GUID-756C5D8F-0A13-48AD-A112-FD69FD0D12EC.htm",
"description":"Controllers, like objects and modifiers, need to be able to undo and redo themselves. Whenever a controller is about to modify its data, it checks the state of the global Hold object (theHold) to see if it is holding. If so it must register a RestoreObject with the hold. Controllers also support another type of undo and redo through two methods: Control::CommitValue() and Control::RestoreValue().",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Animation Controller Plug-ins","href":"./files/GUID-63058407-062E-4119-B138-047DB8FA69FB.htm"}]},
{"title":"Responding to Changes in Parameters",
"href":"./files/GUID-1507B166-717B-40DA-9D61-5D877F840644.htm",
"description":"When the position target weight parameter is changed for the Position Constraint controller, the list box must be redrawn. To do this the Position Constraint controller implements ReferenceMaker::NotifyRefDependent(). The message parameters passed into this method is the specific message which needs to be handled. The hTarget parameter is a pointer to the reference target that sent the message. The reference maker uses this handle to know specifically which reference target sent the message.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Animation Controller Plug-ins","href":"./files/GUID-63058407-062E-4119-B138-047DB8FA69FB.htm"}]},
{"title":"Making Controllers Lockable",
"href":"./files/GUID-653E2BBF-ACE5-47B0-BA0E-6393D73364EC.htm",
"description":"Follow these steps to make a controller lockable. Also, note that the samples in maxsdk\\samples\\controllers are lockable.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Animation Controller Plug-ins","href":"./files/GUID-63058407-062E-4119-B138-047DB8FA69FB.htm"}]},
{"title":"Writing System Plug-ins",
"href":"./files/GUID-13C3CE2C-4243-4ECA-BFF5-9E4A9001FE9B.htm",
"description":"System plug-ins are combinations of one or more objects, along with optional controllers, or modifiers, or space warps, all working together. These plug-ins can provide high-order parametric control over a complex collection of scene entities. An example system is Biped which uses objects and master/slave controllers.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Ring Array Classes",
"href":"./files/GUID-D48F7FC7-20DC-4E37-8833-8B352929B5A7.htm",
"description":"The ring array plug-in has several key classes:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing System Plug-ins","href":"./files/GUID-13C3CE2C-4243-4ECA-BFF5-9E4A9001FE9B.htm"}]},
{"title":"Ring Array Slave and Master Controllers",
"href":"./files/GUID-14298B34-3643-419E-BBCF-F14373066092.htm",
"description":"This section discusses the use of controllers within the Ring Array plug-in.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing System Plug-ins","href":"./files/GUID-13C3CE2C-4243-4ECA-BFF5-9E4A9001FE9B.htm"}]},
{"title":"Ring Array References",
"href":"./files/GUID-F45C6984-0657-4EEA-8BAB-8C189FD8E7D0.htm",
"description":"There are several classes in the Ring Array that make references. This section provides an overview of how the references are used by the classes. For a general introduction to the 3ds Max reference mechanism topic on References.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing System Plug-ins","href":"./files/GUID-13C3CE2C-4243-4ECA-BFF5-9E4A9001FE9B.htm"}]},
{"title":"Ring Array Creation Process",
"href":"./files/GUID-978F2888-1988-4219-AD7C-B6C76F22F4F2.htm",
"description":"The Ring Array\'s implementation of ClassDesc::BeginCreate() installs a command mode that manages the creation process. This command mode is an instance of class RingMasterCreateMode. See the section onCommandModes and Mouse Procs for more details on command modes. Below is the method of ClassDesc to begin the creation of the Ring Array. Note how the command mode is pushed on the command stack.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing System Plug-ins","href":"./files/GUID-13C3CE2C-4243-4ECA-BFF5-9E4A9001FE9B.htm"}]},
{"title":"Writing World Space Modifier Plug-ins",
"href":"./files/GUID-6B0DE109-8B9C-40F0-925D-20231427744B.htm",
"description":"World space modifiers (WSM), also called space warps, are objects in a scene that affect the objects that are bound to them in world space. A world space modifier has a representation in the viewport, but is not rendered in the final scene. World space modifiers affect other nodes in the scene based on the position and orientation of the bound nodes to the space warp object.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"World Space Modifier Plug-in Overview",
"href":"./files/GUID-919E28F8-3A3B-4EB1-8EA0-071812177AFE.htm",
"description":"Writing a WSM involves creating instances of two key classes. One is derived from class WSMObject. The other class is derived from Modifier. These two classes work together. The object handles the display and management of its user interface parameters, the display of the WSM node in the scene, and provides a world space orientation. The modifier handles the actual deformation of the geometry of nodes bound to the space warp.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing World Space Modifier Plug-ins","href":"./files/GUID-6B0DE109-8B9C-40F0-925D-20231427744B.htm"}]},
{"title":"Writing MAXScript Plug-ins",
"href":"./files/GUID-CDCA4CC5-8462-44B5-AAB7-6D2F041FFBCD.htm",
"description":"The section describes how to write MAXScript plug-ins. A MAXScript plug-in might extends MAXScript with new functionality such as new global variables or functions. MAXScript plug-ins have the file extension .DLX.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"MAXScript Plug-in Basics",
"href":"./files/GUID-78448103-E4F3-4D9F-80F9-2648F8E7DC6C.htm",
"description":"MAXScript plug-ins do not generally use ClassDesc so their .cpp and .def files are simpler, because they do not export the functions GetClassDesc() and GetNumClasses(). A MAXScript plug-in DLL should have the file-extension .dlx.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing MAXScript Plug-ins","href":"./files/GUID-CDCA4CC5-8462-44B5-AAB7-6D2F041FFBCD.htm"}]},
{"title":"Writing Other Plug-in Types",
"href":"./files/GUID-F1FD388B-2068-4B45-A4F0-4540AC5B4123.htm",
"description":"This section contains a number of topics related to writing less common plug-in types.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Writing Global Utility Plug-ins (GUPs)",
"href":"./files/GUID-E3FF67D3-1D25-40F1-9E9C-7D0320A0EB86.htm",
"description":"A global utility plug-in should inherit from the GUP class, and may implement one ore more of the following functions.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Other Plug-in Types","href":"./files/GUID-F1FD388B-2068-4B45-A4F0-4540AC5B4123.htm"}]},
{"title":"Writing Utility Plug-ins",
"href":"./files/GUID-9D824C6F-2448-425B-B104-FC84A234430A.htm",
"description":"Utility plug-ins derive from the class UtilityObj. A utility plug-in differs from a global-utility plug-in (GUP) in that it has an associated roll-out panel and appears in the utilities section of the command panel.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Other Plug-in Types","href":"./files/GUID-F1FD388B-2068-4B45-A4F0-4540AC5B4123.htm"}]},
{"title":"Writing Exporter Plug-ins",
"href":"./files/GUID-1EBD96DA-8717-4D04-AA1B-254BD7C70AAA.htm",
"description":"Global utility plug-ins inherit from the SceneExport class. An exporter plug-in must implement the following virtual functions:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Other Plug-in Types","href":"./files/GUID-F1FD388B-2068-4B45-A4F0-4540AC5B4123.htm"}]},
{"title":"Writing Importer Plug-ins",
"href":"./files/GUID-FF19E82C-9E5D-4AD2-8BCA-C3B55217510C.htm",
"description":"Importer plug-ins are like export plug-ins except that they inherit from the SceneExport class instead of the GUP class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Other Plug-in Types","href":"./files/GUID-F1FD388B-2068-4B45-A4F0-4540AC5B4123.htm"}]},
{"title":"Writing Image IO Plug-ins",
"href":"./files/GUID-71A824E6-8548-4B57-80CA-DFEE578FB879.htm",
"description":"Image IO plug-ins load and save the various file types are derived from class BitmapIO. Examples of this type of plug-in are the GIF, FLC and JPG IO modules. When writing these kind of plug-ins the memory handling of bitmaps requires special attention.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Other Plug-in Types","href":"./files/GUID-F1FD388B-2068-4B45-A4F0-4540AC5B4123.htm"}]},
{"title":"Writing Rendering Plug-Ins",
"href":"./files/GUID-3375E235-B5B1-4C4F-B58F-FDA616066088.htm",
"description":"Renderer plug-ins are derived from the class Renderer. The standard 3ds Max scan line renderer used in the viewport is itself derived from this class.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Other Plug-in Types","href":"./files/GUID-F1FD388B-2068-4B45-A4F0-4540AC5B4123.htm"}]},
{"title":"Writing Crowd Behavior Plug-ins",
"href":"./files/GUID-2F6C2FFE-4E36-488E-BF17-F4A522C7D60A.htm",
"description":"A crowd behavior plug-in for character studio inherits from the BaseBehavior class found in bhvr.h. A behavior plug-in has a super class of BEHAVIOR_SUPER_CLASS_ID exists in the 3ds Max plug-in directory. The 3ds Max crowd system uses the super class id to find the plug-in as an available behavior.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Writing Other Plug-in Types","href":"./files/GUID-F1FD388B-2068-4B45-A4F0-4540AC5B4123.htm"}]},
{"title":"Troubleshooting",
"href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm",
"description":"This section provides information about debugging and troubleshooting your 3ds Max plug-ins.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Common Problems and Solutions",
"href":"./files/GUID-26368EDF-561E-453D-B806-E60B5709B121.htm",
"description":"This topic provides a series of commonly-encountered problems and their solutions when writing 3ds Max plug-ins.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"Debugging 3ds Max plug-ins using Visual Studio",
"href":"./files/GUID-77CCF2FD-0CD7-45C1-B4BC-877E3A28A5D5.htm",
"description":"Overview Developers may use the VC++ IDE to debug 3ds Max plug-ins. This provides source code level debugging capabilities while execution is taking place inside the context of the plug-in. One can",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"DebugPrint()",
"href":"./files/GUID-BBC15D65-ADF5-405D-B3B4-0EFEB2BA082C.htm",
"description":"The DebugPrint() function can be used to send information to the debug window in the Visual Studio IDE. This is handy for outputting debug information, as it only appears while debugging. This window can be scrolled so a developer can print a lot of information to it, then go back to look it over. The debug window contents can also be saved. The format string works like the standard C printf() function in that it takes a formatting string, and a variable number of arguments.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"Debugging in Release Mode",
"href":"./files/GUID-40A8C98B-6085-4F1D-8EA5-08A7AF166651.htm",
"description":"If 3ds Max crashes in release mode, the user sees the following: The user either sends the report, or not. Either way, 3ds Max then finishes crashing, and that\'s the end of it. But as a plug-in",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"Debug Builds of 3ds Max",
"href":"./files/GUID-037B63DE-61BE-49A5-8E49-E02A06A7AAA3.htm",
"description":"Autodesk Developer Network members (see the topic Developer Support) have access to a debug version of the 3ds Max SDK and a special build of 3ds Max in that is compiled in debug mode.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"Using 3ds Max Generated Minidump Files",
"href":"./files/GUID-5C1C7B6C-A2A1-45EE-ABE2-FCDAC59F4568.htm",
"description":"When an application crashes for any reason, a minidump file is created. The Minidump file provides information for debugging the program. It is most useful in the cases that the crash happens on a machine on which there is no access to the source code, and local debugging is not an option. The Microsoft Visual Studio Debugger open minidump files and allow developers to investigate the reasons for the crash.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"Profiling Plug-in Performance",
"href":"./files/GUID-36FA7BBB-ABAA-4FBC-AE4A-F5192221F443.htm",
"description":"There 3ds Max Profiler is a utility plug-in that allows developers to analyze the execution and performance of their plug-ins. The profiler supports analyzing Release build plug-ins. This allows profiling to take place with full optimization, inlining, etc. (Hybrid and Debug builds can also be profiled however this doesn\'t provide accurate information since the code is not optimized).",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"Geometry Checker",
"href":"./files/GUID-10F2BCBF-8C92-4263-80F2-006B1BB831FF.htm",
"description":"The geometry checker system allows for interactively examining and testing meshes and poly objects for possible errors such as flipped faces, etc., and visualizing the results in the viewport. When the system is turned on it will perform a user supplied test on the current selection of objects and show the results of the test in the current viewport.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"MNMesh Note on Debugging",
"href":"./files/GUID-11AD2234-BCBF-4645-BCF2-964BFD1CACDB.htm",
"description":"The functions MNVert::MNDebugPrint(), MNEdge::MNDebugPrint(), MNFace::MNDebugPrint(), MNMesh::MNDebugPrint(), and MNMeshBorder::MNDebugPrint() print out detailed ASCII summaries of the component or mesh, which can be an invaluable aid in tracking bugs.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Troubleshooting","href":"./files/GUID-32AB4228-F5FB-4C0B-A75C-DB24CFCC5C4F.htm"}]},
{"title":"Advanced Plug-in Topics",
"href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm",
"description":"This section contains a number of advanced topics regarding writing plug-ins.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"}]},
{"title":"Responding to Parameter Edits",
"href":"./files/GUID-0EFC65D6-EC3F-4E7D-960D-1780221898D2.htm",
"description":"If the parameter is changed, a reference message will be sent to your plug-in. However, in some scenarios you may want to know when the parameter is begin edited in the UI by the user.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Plugging in to 3ds Max SDK Help",
"href":"./files/GUID-25151CF8-1184-40BB-AE35-26CD48DA7A3F.htm",
"description":"Plug-in developers may add on-line help for their applications and make this available to users via the 3ds Max Help menu.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Deferred Loading of Plug-ins",
"href":"./files/GUID-0C178DAC-7F0C-47E8-8994-8C2E2AAA4112.htm",
"description":"Plug-in DLL Defer Loading A defer loaded plug-in DLL will not be loaded into memory until required by 3ds Max for the first time. Deferring a plug-in is a useful technique for improving the start-up",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"3ds Max Install Directory Registry Key",
"href":"./files/GUID-3D358AC5-F7BE-4A03-896B-ED92AFFD24E4.htm",
"description":"3ds Max stores its installation directory in the registry under the following key for 3ds Max standard:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Registry Key Structure",
"href":"./files/GUID-7716660A-00FE-435F-A080-698291E43206.htm",
"description":"The following chain of Registry keys establishes the base for all plug-in descriptions:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"What Happens when Plug-in DLLs are Unavailable",
"href":"./files/GUID-6E2E1B7D-98B9-4219-8E50-B5ACB92C49BA.htm",
"description":"If a scene is loaded but a plug-in\'s implementing DLL is not found a string describing the DLL is presented to the user. This string is exported by a DLL in the function LibDescription() and is stored in the scene file.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Plug-in Directory Search Mechanism",
"href":"./files/GUID-CFFCDE3D-867E-473C-A1BE-8FA31B4A7C4A.htm",
"description":"In the root directory with the 3ds Max executable is a file PLUGIN.INI. This file contains a one-line entry for each plug-in search location. When 3ds Max begins execution it searches each path listed in this file looking for plug-in DLLs. When a plug-in DLL is found it is loaded. This system allows developers to store their plug-ins in whatever sub-directory structure they wish. The format for the PLUGIN.INI file is:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Plug-in Configuration System",
"href":"./files/GUID-9CEBD96D-90FB-434A-8926-7827A78B71A9.htm",
"description":"Developers often need to store configuration files for use with their plugin applications. There is a standard location defined for these files. This allows a 3ds Max user to have all their configuration files stored together and not spread around different hard-to-find locations.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Custom Plug-in Creation Processes",
"href":"./files/GUID-9A4EBC7C-16AF-4E16-9D3E-2E45090AF7C0.htm",
"description":"Two methods of the plug-in\'s class descriptor ClassDesc::BeginCreate() and ClassDesc::EndCreate(), allow the plug-in to customize the process of creation. When the system is about to create a plug-in object ClassDesc::BeginCreate() is called. The default implementation of this method returns 0, which tells the system to use the default process. If the plug-in does require a custom creation phase, it does so in its implementation of this method. When it is finished it returns nonzero to indicate it does not want the default process invoked.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Facilitating Translation and Localization",
"href":"./files/GUID-97DBB58E-FA66-4522-A43F-B9BADB132009.htm",
"description":"3ds Max is sold in numerous countries outside Canada and the United States. To allow your plug-in to have the largest possible audience, it is a good practice to ensure that text strings used in the plug-in can be easily translated to another language, or easily adapted to differences in usage between countries that speak the same language.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Upgrading to 64-Bit",
"href":"./files/GUID-B9E44914-E7EE-465B-9057-B56559C8A8B6.htm",
"description":"The conversion of 3ds Max and its SDK to the 64-bit Windows environment presents a number challenges beyond the obvious memory-management changes. For example, for 3ds Max to operate in both 32-bit and 64-bit environments, a new folder structure under the main program folder needed to be created. 3ds Max SDK users need to be aware of all this to negotiate the new interface and create plug-ins that operate successfully under these changed circumstances.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"}]},
{"title":"Mixing 32-bit and 64-bit Environments",
"href":"./files/GUID-278ECD0E-579B-4804-8368-4B35FE60BEBA.htm",
"description":"Here is the list of environment-mixing restrictions within which you must operate when developing plug-ins with Version 9 and later of the 3ds Max SDK:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"},{"title": "Upgrading to 64-Bit","href":"./files/GUID-B9E44914-E7EE-465B-9057-B56559C8A8B6.htm"}]},
{"title":"32-bit and 64-bit Max Files",
"href":"./files/GUID-950847C2-C2BC-4DD8-87F9-05D87722A6F1.htm",
"description":"Files can be interchanged between 32-bit and 64-bit versions of 3ds Max, but with limitations:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"},{"title": "Upgrading to 64-Bit","href":"./files/GUID-B9E44914-E7EE-465B-9057-B56559C8A8B6.htm"}]},
{"title":"SetWindowLong() and GetWindowLong()",
"href":"./files/GUID-3217C170-638C-4C48-8C9B-37A1319A0655.htm",
"description":"It is typical of windows UI code to store a pointer to a C++ object into the GWL_USERDATA slot of an HWND, using code like this:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"},{"title": "Upgrading to 64-Bit","href":"./files/GUID-B9E44914-E7EE-465B-9057-B56559C8A8B6.htm"}]},
{"title":"Dialog and Window Procedures",
"href":"./files/GUID-50A8A03A-0759-4EDB-962D-D4BA1883D305.htm",
"description":"A windows procedure must have the following signature:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"},{"title": "Upgrading to 64-Bit","href":"./files/GUID-B9E44914-E7EE-465B-9057-B56559C8A8B6.htm"}]},
{"title":"In-line Assembly Code",
"href":"./files/GUID-84F7A41E-3559-43C8-9537-3BFB11E9BE49.htm",
"description":"You can use assembly code in x64 code, but not in-line -- it must be in an external .asm file, compiled with ml64.exe, and called as a function. For small functions, the overhead of the function call can negate performance gains obtained by using assembly code.",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"},{"title": "Upgrading to 64-Bit","href":"./files/GUID-B9E44914-E7EE-465B-9057-B56559C8A8B6.htm"}]},
{"title":"Using printf",
"href":"./files/GUID-0DA95E7A-52C1-4433-844A-C1FF1C08B1C0.htm",
"description":"With the larger 64-bit data types, printf \"%\" codes needed to be upgraded to include them. Full documentation is available on MSDN but here is a brief overview:",
"ancestors":[{"title": "3ds Max SDK Programmer\'s Guide","href":"./files/GUID-A65AEDA8-744F-4F1D-8036-3933BA846AE9.htm"},{"title": "Writing Plug-ins","href":"./files/GUID-4366F3C4-E40F-4051-8C17-8AE306E1DEFC.htm"},{"title": "Advanced Plug-in Topics","href":"./files/GUID-F4437AB0-C703-448B-B80C-1092666E199E.htm"},{"title": "Upgrading to 64-Bit","href":"./files/GUID-B9E44914-E7EE-465B-9057-B56559C8A8B6.htm"}]},
{"title":"C++: maxscript/foundation/3dmath.h File Reference",
"href":"cpp_ref/3dmath_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: 3dsmaxconfig.h File Reference",
"href":"cpp_ref/3dsmaxconfig_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: 3dsmaxdlport.h File Reference",
"href":"cpp_ref/3dsmaxdlport_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: 3dsmaxport.h File Reference",
"href":"cpp_ref/3dsmaxport_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: acolor.h File Reference",
"href":"cpp_ref/acolor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: actiontable.h File Reference",
"href":"cpp_ref/actiontable_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: actiontableTypedefs.h File Reference",
"href":"cpp_ref/actiontable_typedefs_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: animtbl.h File Reference",
"href":"cpp_ref/animtbl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: appio.h File Reference",
"href":"cpp_ref/appio_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: arcdlg.h File Reference",
"href":"cpp_ref/arcdlg_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/arrays.h File Reference",
"href":"cpp_ref/arrays_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/arrays.inl File Reference",
"href":"cpp_ref/arrays_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: assert1.h File Reference",
"href":"cpp_ref/assert1_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetManagement/assetmanagementExport.h File Reference",
"href":"cpp_ref/assetmanagement_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/atmospherics.inl File Reference",
"href":"cpp_ref/atmospherics_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: autoptr.h File Reference",
"href":"cpp_ref/autoptr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: baseinterface.h File Reference",
"href":"cpp_ref/baseinterface_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: bezfont.h File Reference",
"href":"cpp_ref/bezfont_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/bhvr.h File Reference",
"href":"cpp_ref/bhvr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/bigmatrix.inl File Reference",
"href":"cpp_ref/bigmatrix_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/biped.inl File Reference",
"href":"cpp_ref/biped_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: bitarray.h File Reference",
"href":"cpp_ref/bitarray_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/bitmaps.h File Reference",
"href":"cpp_ref/bitmaps_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/bitmaps.inl File Reference",
"href":"cpp_ref/bitmaps_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: bitmap.h File Reference",
"href":"cpp_ref/bitmap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: bmmlib.h File Reference",
"href":"cpp_ref/bmmlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: box2.h File Reference",
"href":"cpp_ref/box2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: box3.h File Reference",
"href":"cpp_ref/box3_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/box.inl File Reference",
"href":"cpp_ref/box_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: buildnumber.h File Reference",
"href":"cpp_ref/buildnumber_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: osx/buildver.h File Reference",
"href":"cpp_ref/buildver_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/cameratracker.inl File Reference",
"href":"cpp_ref/cameratracker_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: captypes.h File Reference",
"href":"cpp_ref/captypes_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: channels.h File Reference",
"href":"cpp_ref/channels_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: chkmtlapi.h File Reference",
"href":"cpp_ref/chkmtlapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: bmmHistoryList Class Reference",
"href":"cpp_ref/classbmm_history_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrAdvancedTranslation Class Reference",
"href":"cpp_ref/classimr_advanced_translation.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrGeomShaderTranslation Class Reference",
"href":"cpp_ref/classimr_geom_shader_translation.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrLightTranslation Class Reference",
"href":"cpp_ref/classimr_light_translation.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrMaterialCustAttrib Class Reference",
"href":"cpp_ref/classimr_material_cust_attrib.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrMaterialPhenomenonTranslation Class Reference",
"href":"cpp_ref/classimr_material_phenomenon_translation.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrPreferences Class Reference",
"href":"cpp_ref/classimr_preferences.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrShader Class Reference",
"href":"cpp_ref/classimr_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrShaderClassDesc Class Reference",
"href":"cpp_ref/classimr_shader_class_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrShaderCreation Class Reference",
"href":"cpp_ref/classimr_shader_creation.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrShaderTranslation Class Reference",
"href":"cpp_ref/classimr_shader_translation.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrShaderTranslation_ClassInfo Class Reference",
"href":"cpp_ref/classimr_shader_translation___class_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrTranslation Class Reference",
"href":"cpp_ref/classimr_translation.html",
"description":"",
"ancestors":[]},
{"title":"C++: mrShaderButtonHandler Class Reference",
"href":"cpp_ref/classmr_shader_button_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: mrShaderFilter Class Reference",
"href":"cpp_ref/classmr_shader_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: msgdata Class Reference",
"href":"cpp_ref/classmsgdata.html",
"description":"",
"ancestors":[]},
{"title":"C++: mxs_notify_ref_data Class Reference",
"href":"cpp_ref/classmxs__notify__ref__data.html",
"description":"",
"ancestors":[]},
{"title":"C++: path_properties Class Reference",
"href":"cpp_ref/classpath__properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: path_property Class Reference",
"href":"cpp_ref/classpath__property.html",
"description":"",
"ancestors":[]},
{"title":"C++: src_info Class Reference",
"href":"cpp_ref/classsrc__info.html",
"description":"",
"ancestors":[]},
{"title":"C++: tooltabentry Class Reference",
"href":"cpp_ref/classtooltabentry.html",
"description":"",
"ancestors":[]},
{"title":"C++: vector Class Reference",
"href":"cpp_ref/classvector.html",
"description":"",
"ancestors":[]},
{"title":"C++: AccessorError Class Reference",
"href":"cpp_ref/class_accessor_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: ActionCallback Class Reference",
"href":"cpp_ref/class_action_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ActionContext Class Reference",
"href":"cpp_ref/class_action_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: ActionItem Class Reference",
"href":"cpp_ref/class_action_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: ActionItemStandin Class Reference",
"href":"cpp_ref/class_action_item_standin.html",
"description":"",
"ancestors":[]},
{"title":"C++: ActionTable Class Reference",
"href":"cpp_ref/class_action_table.html",
"description":"",
"ancestors":[]},
{"title":"C++: ActiveXLicensor Class Reference",
"href":"cpp_ref/class_active_x_licensor.html",
"description":"",
"ancestors":[]},
{"title":"C++: AddExposureMaterialControl< B > Class Template Reference",
"href":"cpp_ref/class_add_exposure_material_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: AdjEdgeList Class Reference",
"href":"cpp_ref/class_adj_edge_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: AdjFace Class Reference",
"href":"cpp_ref/class_adj_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: AdjFaceList Class Reference",
"href":"cpp_ref/class_adj_face_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: AngAxis Class Reference",
"href":"cpp_ref/class_ang_axis.html",
"description":"",
"ancestors":[]},
{"title":"C++: Animatable Class Reference",
"href":"cpp_ref/class_animatable.html",
"description":"",
"ancestors":[]},
{"title":"C++: Animatable::EnumAnimList Class Reference",
"href":"cpp_ref/class_animatable_1_1_enum_anim_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Animatable",
"href":"cpp_ref/class_animatable_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimateSuspend Class Reference",
"href":"cpp_ref/class_animate_suspend.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimAppData Class Reference",
"href":"cpp_ref/class_anim_app_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimEnum Class Reference",
"href":"cpp_ref/class_anim_enum.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimProperty Class Reference",
"href":"cpp_ref/class_anim_property.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimPropertyList Class Reference",
"href":"cpp_ref/class_anim_property_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnyKey Class Reference",
"href":"cpp_ref/class_any_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: AppendGizmoRestore Class Reference",
"href":"cpp_ref/class_append_gizmo_restore.html",
"description":"",
"ancestors":[]},
{"title":"C++: AppDataChunk Class Reference",
"href":"cpp_ref/class_app_data_chunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: AppLoad Class Reference",
"href":"cpp_ref/class_app_load.html",
"description":"",
"ancestors":[]},
{"title":"C++: AppSave Class Reference",
"href":"cpp_ref/class_app_save.html",
"description":"",
"ancestors":[]},
{"title":"C++: ArcballCallback Class Reference",
"href":"cpp_ref/class_arcball_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ArcballDialog Class Reference",
"href":"cpp_ref/class_arcball_dialog.html",
"description":"",
"ancestors":[]},
{"title":"C++: AreaShadowGenerator Class Reference",
"href":"cpp_ref/class_area_shadow_generator.html",
"description":"",
"ancestors":[]},
{"title":"C++: AreaShadowSampler Class Reference",
"href":"cpp_ref/class_area_shadow_sampler.html",
"description":"",
"ancestors":[]},
{"title":"C++: ArgCountError Class Reference",
"href":"cpp_ref/class_arg_count_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetEnumCallback Class Reference",
"href":"cpp_ref/class_asset_enum_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssignControllerRestore Class Reference",
"href":"cpp_ref/class_assign_controller_restore.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssignToConstError Class Reference",
"href":"cpp_ref/class_assign_to_const_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: Atmospheric Class Reference",
"href":"cpp_ref/class_atmospheric.html",
"description":"",
"ancestors":[]},
{"title":"C++: AttachMatDlgUser Class Reference",
"href":"cpp_ref/class_attach_mat_dlg_user.html",
"description":"",
"ancestors":[]},
{"title":"C++: AvailableFont Class Reference",
"href":"cpp_ref/class_available_font.html",
"description":"",
"ancestors":[]},
{"title":"C++: AxisChangeCallback Class Reference",
"href":"cpp_ref/class_axis_change_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: AColor Class Reference",
"href":"cpp_ref/class_a_color.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATSClientInfo Class Reference",
"href":"cpp_ref/class_a_t_s_client_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATSExploreProviderParams Class Reference",
"href":"cpp_ref/class_a_t_s_explore_provider_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATSFileEntry Class Reference",
"href":"cpp_ref/class_a_t_s_file_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATSFileList Class Reference",
"href":"cpp_ref/class_a_t_s_file_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATSNotification Class Reference",
"href":"cpp_ref/class_a_t_s_notification.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATSNotifyParams Class Reference",
"href":"cpp_ref/class_a_t_s_notify_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATSUserEntry Class Reference",
"href":"cpp_ref/class_a_t_s_user_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATSUserList Class Reference",
"href":"cpp_ref/class_a_t_s_user_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseBehavior Class Reference",
"href":"cpp_ref/class_base_behavior.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseInterface Class Reference",
"href":"cpp_ref/class_base_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseInterfaceServer Class Reference",
"href":"cpp_ref/class_base_interface_server.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseObject Class Reference",
"href":"cpp_ref/class_base_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class BaseObject",
"href":"cpp_ref/class_base_object_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseShader Class Reference",
"href":"cpp_ref/class_base_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class BaseShader",
"href":"cpp_ref/class_base_shader_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseSimpleData Class Reference",
"href":"cpp_ref/class_base_simple_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: BasisFinder Class Reference",
"href":"cpp_ref/class_basis_finder.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezierShape Class Reference",
"href":"cpp_ref/class_bezier_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class BezierShape",
"href":"cpp_ref/class_bezier_shape_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezierShapeInterface_Ex41 Class Reference",
"href":"cpp_ref/class_bezier_shape_interface___ex41.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezierShapeTopology Class Reference",
"href":"cpp_ref/class_bezier_shape_topology.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFont Class Reference",
"href":"cpp_ref/class_bez_font.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFontDll Class Reference",
"href":"cpp_ref/class_bez_font_dll.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFontEnumProc Class Reference",
"href":"cpp_ref/class_bez_font_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFontEX Class Reference",
"href":"cpp_ref/class_bez_font_e_x.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFontEX2 Class Reference",
"href":"cpp_ref/class_bez_font_e_x2.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFontInfo Class Reference",
"href":"cpp_ref/class_bez_font_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFontManager Class Reference",
"href":"cpp_ref/class_bez_font_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFontMetrics Class Reference",
"href":"cpp_ref/class_bez_font_metrics.html",
"description":"",
"ancestors":[]},
{"title":"C++: BezFontMgrEnumProc Class Reference",
"href":"cpp_ref/class_bez_font_mgr_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: BigMatrix Class Reference",
"href":"cpp_ref/class_big_matrix.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Class Reference",
"href":"cpp_ref/class_bitmap.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapDither Class Reference",
"href":"cpp_ref/class_bitmap_dither.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapDropType Class Reference",
"href":"cpp_ref/class_bitmap_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapFileInputDialog Class Reference",
"href":"cpp_ref/class_bitmap_file_input_dialog.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapFileOutputDialog Class Reference",
"href":"cpp_ref/class_bitmap_file_output_dialog.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapFilter Class Reference",
"href":"cpp_ref/class_bitmap_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Bitmap",
"href":"cpp_ref/class_bitmap_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapInfo Class Reference",
"href":"cpp_ref/class_bitmap_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class BitmapInfo",
"href":"cpp_ref/class_bitmap_info_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapIO Class Reference",
"href":"cpp_ref/class_bitmap_i_o.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class BitmapIO",
"href":"cpp_ref/class_bitmap_i_o_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapIOLayer Class Reference",
"href":"cpp_ref/class_bitmap_i_o_layer.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapIOMetaData Class Reference",
"href":"cpp_ref/class_bitmap_i_o_meta_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapLayerUtl Class Reference",
"href":"cpp_ref/class_bitmap_layer_utl.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapManager Class Reference",
"href":"cpp_ref/class_bitmap_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class BitmapManager",
"href":"cpp_ref/class_bitmap_manager_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapNotify Class Reference",
"href":"cpp_ref/class_bitmap_notify.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapProxyTemporaryDisableGuard Class Reference",
"href":"cpp_ref/class_bitmap_proxy_temporary_disable_guard.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapStorage Class Reference",
"href":"cpp_ref/class_bitmap_storage.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapStorageHDR Class Reference",
"href":"cpp_ref/class_bitmap_storage_h_d_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapStorageLDR Class Reference",
"href":"cpp_ref/class_bitmap_storage_l_d_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapTex Class Reference",
"href":"cpp_ref/class_bitmap_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitArray Class Reference",
"href":"cpp_ref/class_bit_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitArray::NumberSetProxy Class Reference",
"href":"cpp_ref/class_bit_array_1_1_number_set_proxy.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitArrayCallback Class Reference",
"href":"cpp_ref/class_bit_array_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: Boolean Class Reference",
"href":"cpp_ref/class_boolean.html",
"description":"",
"ancestors":[]},
{"title":"C++: Box2 Class Reference",
"href":"cpp_ref/class_box2.html",
"description":"",
"ancestors":[]},
{"title":"C++: Box2D Class Reference",
"href":"cpp_ref/class_box2_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: Box3 Class Reference",
"href":"cpp_ref/class_box3.html",
"description":"",
"ancestors":[]},
{"title":"C++: BoxGizmoObject Class Reference",
"href":"cpp_ref/class_box_gizmo_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: BoxLineProc Class Reference",
"href":"cpp_ref/class_box_line_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_IOHandler Class Reference",
"href":"cpp_ref/class_b_m_m___i_o_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_IOList Class Reference",
"href":"cpp_ref/class_b_m_m___i_o_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: CacheClass Class Reference",
"href":"cpp_ref/class_cache_class.html",
"description":"",
"ancestors":[]},
{"title":"C++: CallbackScript Class Reference",
"href":"cpp_ref/class_callback_script.html",
"description":"",
"ancestors":[]},
{"title":"C++: CallContext Class Reference",
"href":"cpp_ref/class_call_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: Camera Class Reference",
"href":"cpp_ref/class_camera.html",
"description":"",
"ancestors":[]},
{"title":"C++: CameraObject Class Reference",
"href":"cpp_ref/class_camera_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: Candidate Class Reference",
"href":"cpp_ref/class_candidate.html",
"description":"",
"ancestors":[]},
{"title":"C++: CapFace Class Reference",
"href":"cpp_ref/class_cap_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: CapPatch Class Reference",
"href":"cpp_ref/class_cap_patch.html",
"description":"",
"ancestors":[]},
{"title":"C++: CapVert Class Reference",
"href":"cpp_ref/class_cap_vert.html",
"description":"",
"ancestors":[]},
{"title":"C++: ChangeForegroundCallback Class Reference",
"href":"cpp_ref/class_change_foreground_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ChangeFGObject Class Reference",
"href":"cpp_ref/class_change_f_g_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: ChangeHandler Class Reference",
"href":"cpp_ref/class_change_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: CharBinaryStream Class Reference",
"href":"cpp_ref/class_char_binary_stream.html",
"description":"",
"ancestors":[]},
{"title":"C++: CheckAbortCallback Class Reference",
"href":"cpp_ref/class_check_abort_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ClassDesc Class Reference",
"href":"cpp_ref/class_class_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ClassDesc2 Class Reference",
"href":"cpp_ref/class_class_desc2.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class ClassDesc",
"href":"cpp_ref/class_class_desc_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: ClassDirectory Class Reference",
"href":"cpp_ref/class_class_directory.html",
"description":"",
"ancestors":[]},
{"title":"C++: ClassEntry Class Reference",
"href":"cpp_ref/class_class_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: Class_ID Class Reference",
"href":"cpp_ref/class_class___i_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: ClearAnimFlagEnumProc Class Reference",
"href":"cpp_ref/class_clear_anim_flag_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: CodeBlock Class Reference",
"href":"cpp_ref/class_code_block.html",
"description":"",
"ancestors":[]},
{"title":"C++: CodeBlockLocalThunk Class Reference",
"href":"cpp_ref/class_code_block_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: CodeTree Class Reference",
"href":"cpp_ref/class_code_tree.html",
"description":"",
"ancestors":[]},
{"title":"C++: Collectable Class Reference",
"href":"cpp_ref/class_collectable.html",
"description":"",
"ancestors":[]},
{"title":"C++: Collection Class Reference",
"href":"cpp_ref/class_collection.html",
"description":"",
"ancestors":[]},
{"title":"C++: CollisionMesh Class Reference",
"href":"cpp_ref/class_collision_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: CollisionObject Class Reference",
"href":"cpp_ref/class_collision_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: CollisionOps Class Reference",
"href":"cpp_ref/class_collision_ops.html",
"description":"",
"ancestors":[]},
{"title":"C++: CollisionPlane Class Reference",
"href":"cpp_ref/class_collision_plane.html",
"description":"",
"ancestors":[]},
{"title":"C++: CollisionSphere Class Reference",
"href":"cpp_ref/class_collision_sphere.html",
"description":"",
"ancestors":[]},
{"title":"C++: CollisionVNormal Class Reference",
"href":"cpp_ref/class_collision_v_normal.html",
"description":"",
"ancestors":[]},
{"title":"C++: Color Class Reference",
"href":"cpp_ref/class_color.html",
"description":"",
"ancestors":[]},
{"title":"C++: ColorPacker Class Reference",
"href":"cpp_ref/class_color_packer.html",
"description":"",
"ancestors":[]},
{"title":"C++: ColorPicker Class Reference",
"href":"cpp_ref/class_color_picker.html",
"description":"",
"ancestors":[]},
{"title":"C++: ColPick Class Reference",
"href":"cpp_ref/class_col_pick.html",
"description":"",
"ancestors":[]},
{"title":"C++: CommandMode Class Reference",
"href":"cpp_ref/class_command_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: CommandModeChangedCallback Class Reference",
"href":"cpp_ref/class_command_mode_changed_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: CompileError Class Reference",
"href":"cpp_ref/class_compile_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConstColorValue Class Reference",
"href":"cpp_ref/class_const_color_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConstGlobalThunk Class Reference",
"href":"cpp_ref/class_const_global_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConstObject Class Reference",
"href":"cpp_ref/class_const_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConstPluginLocalThunk Class Reference",
"href":"cpp_ref/class_const_plugin_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConstPoint3Value Class Reference",
"href":"cpp_ref/class_const_point3_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConstRolloutLocalThunk Class Reference",
"href":"cpp_ref/class_const_rollout_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: ContextThunk Class Reference",
"href":"cpp_ref/class_context_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: Control Class Reference",
"href":"cpp_ref/class_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Control",
"href":"cpp_ref/class_control_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConversionError Class Reference",
"href":"cpp_ref/class_conversion_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConvertToRestore Class Reference",
"href":"cpp_ref/class_convert_to_restore.html",
"description":"",
"ancestors":[]},
{"title":"C++: CreateInstanceCallParam Class Reference",
"href":"cpp_ref/class_create_instance_call_param.html",
"description":"",
"ancestors":[]},
{"title":"C++: CreateMouseCallBack Class Reference",
"href":"cpp_ref/class_create_mouse_call_back.html",
"description":"",
"ancestors":[]},
{"title":"C++: CreateRendImgSeqCallback Class Reference",
"href":"cpp_ref/class_create_rend_img_seq_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: CropCallback Class Reference",
"href":"cpp_ref/class_crop_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: CtrlHitLog Class Reference",
"href":"cpp_ref/class_ctrl_hit_log.html",
"description":"",
"ancestors":[]},
{"title":"C++: CtrlHitRecord Class Reference",
"href":"cpp_ref/class_ctrl_hit_record.html",
"description":"",
"ancestors":[]},
{"title":"C++: CurvePoint Class Reference",
"href":"cpp_ref/class_curve_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: CurSelObjectSet Class Reference",
"href":"cpp_ref/class_cur_sel_object_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: CustomParticleDisplay Class Reference",
"href":"cpp_ref/class_custom_particle_display.html",
"description":"",
"ancestors":[]},
{"title":"C++: CustAttrib Class Reference",
"href":"cpp_ref/class_cust_attrib.html",
"description":"",
"ancestors":[]},
{"title":"C++: CylGizmoObject Class Reference",
"href":"cpp_ref/class_cyl_gizmo_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: CAssertCB Class Reference",
"href":"cpp_ref/class_c_assert_c_b.html",
"description":"",
"ancestors":[]},
{"title":"C++: CExcepInfo Class Reference",
"href":"cpp_ref/class_c_excep_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: CHRedrawViewsCallback Class Reference",
"href":"cpp_ref/class_c_h_redraw_views_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: CJobText Class Reference",
"href":"cpp_ref/class_c_job_text.html",
"description":"",
"ancestors":[]},
{"title":"C++: CStr Class Reference",
"href":"cpp_ref/class_c_str.html",
"description":"",
"ancestors":[]},
{"title":"C++: CUIFrameMgr Class Reference",
"href":"cpp_ref/class_c_u_i_frame_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: CUIFrameMsgHandler Class Reference",
"href":"cpp_ref/class_c_u_i_frame_msg_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: CUIPosData Class Reference",
"href":"cpp_ref/class_c_u_i_pos_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: DataEntryMouseProc Class Reference",
"href":"cpp_ref/class_data_entry_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: DebuggerRuntimeError Class Reference",
"href":"cpp_ref/class_debugger_runtime_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: DefaultActionSys Class Reference",
"href":"cpp_ref/class_default_action_sys.html",
"description":"",
"ancestors":[]},
{"title":"C++: DefaultLight Class Reference",
"href":"cpp_ref/class_default_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: DefaultRemapDir Class Reference",
"href":"cpp_ref/class_default_remap_dir.html",
"description":"",
"ancestors":[]},
{"title":"C++: Deformer Class Reference",
"href":"cpp_ref/class_deformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: DefNoteTrack Class Reference",
"href":"cpp_ref/class_def_note_track.html",
"description":"",
"ancestors":[]},
{"title":"C++: DelayedMatrix3 Class Reference",
"href":"cpp_ref/class_delayed_matrix3.html",
"description":"",
"ancestors":[]},
{"title":"C++: DelayedNodeMat Class Reference",
"href":"cpp_ref/class_delayed_node_mat.html",
"description":"",
"ancestors":[]},
{"title":"C++: DeletedRestore Class Reference",
"href":"cpp_ref/class_deleted_restore.html",
"description":"",
"ancestors":[]},
{"title":"C++: DeleteGizmoRestore Class Reference",
"href":"cpp_ref/class_delete_gizmo_restore.html",
"description":"",
"ancestors":[]},
{"title":"C++: DependentEnumProc Class Reference",
"href":"cpp_ref/class_dependent_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: DependentIterator Class Reference",
"href":"cpp_ref/class_dependent_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: DerefThunk Class Reference",
"href":"cpp_ref/class_deref_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: DeviceRect Class Reference",
"href":"cpp_ref/class_device_rect.html",
"description":"",
"ancestors":[]},
{"title":"C++: DialogItemSizeData Class Reference",
"href":"cpp_ref/class_dialog_item_size_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: DialogResizer Class Reference",
"href":"cpp_ref/class_dialog_resizer.html",
"description":"",
"ancestors":[]},
{"title":"C++: DisplayFilterCallback Class Reference",
"href":"cpp_ref/class_display_filter_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: DllData Class Reference",
"href":"cpp_ref/class_dll_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: DllDesc Class Reference",
"href":"cpp_ref/class_dll_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: DllDir Class Reference",
"href":"cpp_ref/class_dll_dir.html",
"description":"",
"ancestors":[]},
{"title":"C++: DotRunParser Class Reference",
"href":"cpp_ref/class_dot_run_parser.html",
"description":"",
"ancestors":[]},
{"title":"C++: Double Class Reference",
"href":"cpp_ref/class_double.html",
"description":"",
"ancestors":[]},
{"title":"C++: DragAndDropHandler Class Reference",
"href":"cpp_ref/class_drag_and_drop_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: DrawLineProc Class Reference",
"href":"cpp_ref/class_draw_line_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: DropClipFormat Class Reference",
"href":"cpp_ref/class_drop_clip_format.html",
"description":"",
"ancestors":[]},
{"title":"C++: DropScriptClipFmt Class Reference",
"href":"cpp_ref/class_drop_script_clip_fmt.html",
"description":"",
"ancestors":[]},
{"title":"C++: DropScriptDropType Class Reference",
"href":"cpp_ref/class_drop_script_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: DropScriptFileDropType Class Reference",
"href":"cpp_ref/class_drop_script_file_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: DropType Class Reference",
"href":"cpp_ref/class_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: DummyObject Class Reference",
"href":"cpp_ref/class_dummy_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: DynamicMenu Class Reference",
"href":"cpp_ref/class_dynamic_menu.html",
"description":"",
"ancestors":[]},
{"title":"C++: DynamicMenuCallback Class Reference",
"href":"cpp_ref/class_dynamic_menu_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: DynamHelperObject Class Reference",
"href":"cpp_ref/class_dynam_helper_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: DynamModObject Class Reference",
"href":"cpp_ref/class_dynam_mod_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: DADBitmapCarrier Class Reference",
"href":"cpp_ref/class_d_a_d_bitmap_carrier.html",
"description":"",
"ancestors":[]},
{"title":"C++: DADMgr Class Reference",
"href":"cpp_ref/class_d_a_d_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: DOFParams Class Reference",
"href":"cpp_ref/class_d_o_f_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: DPoint3 Class Reference",
"href":"cpp_ref/class_d_point3.html",
"description":"",
"ancestors":[]},
{"title":"C++: DWORDTab Class Reference",
"href":"cpp_ref/class_d_w_o_r_d_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: EaseCurveAnimProp Class Reference",
"href":"cpp_ref/class_ease_curve_anim_prop.html",
"description":"",
"ancestors":[]},
{"title":"C++: EaseCurveList Class Reference",
"href":"cpp_ref/class_ease_curve_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: EdgeBondage Class Reference",
"href":"cpp_ref/class_edge_bondage.html",
"description":"",
"ancestors":[]},
{"title":"C++: EdgeClusterList Class Reference",
"href":"cpp_ref/class_edge_cluster_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: EditorStyleDef Class Reference",
"href":"cpp_ref/class_editor_style_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: Editor_Interface Class Reference",
"href":"cpp_ref/class_editor___interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: EditSSCB Class Reference",
"href":"cpp_ref/class_edit_s_s_c_b.html",
"description":"",
"ancestors":[]},
{"title":"C++: EditSSMode Class Reference",
"href":"cpp_ref/class_edit_s_s_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: Effect Class Reference",
"href":"cpp_ref/class_effect.html",
"description":"",
"ancestors":[]},
{"title":"C++: Effect8 Class Reference",
"href":"cpp_ref/class_effect8.html",
"description":"",
"ancestors":[]},
{"title":"C++: EffectDescriptor Class Reference",
"href":"cpp_ref/class_effect_descriptor.html",
"description":"",
"ancestors":[]},
{"title":"C++: EventRouter Class Reference",
"href":"cpp_ref/class_event_router.html",
"description":"",
"ancestors":[]},
{"title":"C++: EventUser Class Reference",
"href":"cpp_ref/class_event_user.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExclList Class Reference",
"href":"cpp_ref/class_excl_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExitMAXCallback Class Reference",
"href":"cpp_ref/class_exit_m_a_x_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExitMAXCallback2 Class Reference",
"href":"cpp_ref/class_exit_m_a_x_callback2.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExposureMaterialControl Class Reference",
"href":"cpp_ref/class_exposure_material_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExposureMaterialControlDesc Class Reference",
"href":"cpp_ref/class_exposure_material_control_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExposureMaterialControlImp< T, B > Class Template Reference",
"href":"cpp_ref/class_exposure_material_control_imp.html",
"description":"",
"ancestors":[]},
{"title":"C++: Expr Class Reference",
"href":"cpp_ref/class_expr.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExprVar Class Reference",
"href":"cpp_ref/class_expr_var.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExpInterface Class Reference",
"href":"cpp_ref/class_exp_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExtrudeData Class Reference",
"href":"cpp_ref/class_extrude_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: EPoly Class Reference",
"href":"cpp_ref/class_e_poly.html",
"description":"",
"ancestors":[]},
{"title":"C++: EPoly13 Class Reference",
"href":"cpp_ref/class_e_poly13.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class EPoly",
"href":"cpp_ref/class_e_poly_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: EPolyMod Class Reference",
"href":"cpp_ref/class_e_poly_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: EPolyMod13 Class Reference",
"href":"cpp_ref/class_e_poly_mod13.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_BevelCMode Class Reference",
"href":"cpp_ref/class_e_p___bevel_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_BevelMouseProc Class Reference",
"href":"cpp_ref/class_e_p___bevel_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_BevelSelectionProcessor Class Reference",
"href":"cpp_ref/class_e_p___bevel_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_BindCMode Class Reference",
"href":"cpp_ref/class_e_p___bind_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_BindMouseProc Class Reference",
"href":"cpp_ref/class_e_p___bind_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_CopyTangentCMode Class Reference",
"href":"cpp_ref/class_e_p___copy_tangent_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_CopyTangentMouseProc Class Reference",
"href":"cpp_ref/class_e_p___copy_tangent_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_CreatePatchCMode Class Reference",
"href":"cpp_ref/class_e_p___create_patch_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_CreatePatchMouseProc Class Reference",
"href":"cpp_ref/class_e_p___create_patch_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_CreateVertCMode Class Reference",
"href":"cpp_ref/class_e_p___create_vert_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_CreateVertMouseProc Class Reference",
"href":"cpp_ref/class_e_p___create_vert_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_ExtrudeCMode Class Reference",
"href":"cpp_ref/class_e_p___extrude_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_ExtrudeMouseProc Class Reference",
"href":"cpp_ref/class_e_p___extrude_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_ExtrudeSelectionProcessor Class Reference",
"href":"cpp_ref/class_e_p___extrude_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_NormalFlipCMode Class Reference",
"href":"cpp_ref/class_e_p___normal_flip_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_NormalFlipMouseProc Class Reference",
"href":"cpp_ref/class_e_p___normal_flip_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_PasteTangentCMode Class Reference",
"href":"cpp_ref/class_e_p___paste_tangent_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_PasteTangentMouseProc Class Reference",
"href":"cpp_ref/class_e_p___paste_tangent_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_VertWeldCMode Class Reference",
"href":"cpp_ref/class_e_p___vert_weld_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: EP_VertWeldMouseProc Class Reference",
"href":"cpp_ref/class_e_p___vert_weld_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: Face Class Reference",
"href":"cpp_ref/class_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: FaceChange Class Reference",
"href":"cpp_ref/class_face_change.html",
"description":"",
"ancestors":[]},
{"title":"C++: FaceClusterList Class Reference",
"href":"cpp_ref/class_face_cluster_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: FaceCreate Class Reference",
"href":"cpp_ref/class_face_create.html",
"description":"",
"ancestors":[]},
{"title":"C++: FaceDataFromPatch Class Reference",
"href":"cpp_ref/class_face_data_from_patch.html",
"description":"",
"ancestors":[]},
{"title":"C++: FaceElementList Class Reference",
"href":"cpp_ref/class_face_element_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: FaceEx Class Reference",
"href":"cpp_ref/class_face_ex.html",
"description":"",
"ancestors":[]},
{"title":"C++: FaceRemap Class Reference",
"href":"cpp_ref/class_face_remap.html",
"description":"",
"ancestors":[]},
{"title":"C++: FaceSmooth Class Reference",
"href":"cpp_ref/class_face_smooth.html",
"description":"",
"ancestors":[]},
{"title":"C++: FileDropType Class Reference",
"href":"cpp_ref/class_file_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: FilterKernel Class Reference",
"href":"cpp_ref/class_filter_kernel.html",
"description":"",
"ancestors":[]},
{"title":"C++: FilterList Class Reference",
"href":"cpp_ref/class_filter_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: FilterManager Class Reference",
"href":"cpp_ref/class_filter_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: FindCustAttribOwnerDEP Class Reference",
"href":"cpp_ref/class_find_cust_attrib_owner_d_e_p.html",
"description":"",
"ancestors":[]},
{"title":"C++: FindMAXWrapperEnum Class Reference",
"href":"cpp_ref/class_find_m_a_x_wrapper_enum.html",
"description":"",
"ancestors":[]},
{"title":"C++: FlagUser Class Reference",
"href":"cpp_ref/class_flag_user.html",
"description":"",
"ancestors":[]},
{"title":"C++: FlyOffData Class Reference",
"href":"cpp_ref/class_fly_off_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: FnCallPropertyThunk Class Reference",
"href":"cpp_ref/class_fn_call_property_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: FontMgrInterface Class Reference",
"href":"cpp_ref/class_font_mgr_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: ForceField Class Reference",
"href":"cpp_ref/class_force_field.html",
"description":"",
"ancestors":[]},
{"title":"C++: FragmentData Class Reference",
"href":"cpp_ref/class_fragment_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: FragmentDataMat Class Reference",
"href":"cpp_ref/class_fragment_data_mat.html",
"description":"",
"ancestors":[]},
{"title":"C++: FragmentDataMatTex Class Reference",
"href":"cpp_ref/class_fragment_data_mat_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: FragmentDataTex Class Reference",
"href":"cpp_ref/class_fragment_data_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: FrameRange Class Reference",
"href":"cpp_ref/class_frame_range.html",
"description":"",
"ancestors":[]},
{"title":"C++: FrameRendParams Class Reference",
"href":"cpp_ref/class_frame_rend_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: FreeThunk Class Reference",
"href":"cpp_ref/class_free_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: FunctionReturn Class Reference",
"href":"cpp_ref/class_function_return.html",
"description":"",
"ancestors":[]},
{"title":"C++: FLTInterface Class Reference",
"href":"cpp_ref/class_f_l_t_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: FLT_FilterHandler Class Reference",
"href":"cpp_ref/class_f_l_t___filter_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: FLT_FilterList Class Reference",
"href":"cpp_ref/class_f_l_t___filter_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPActionDef Class Reference",
"href":"cpp_ref/class_f_p_action_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPEnum Class Reference",
"href":"cpp_ref/class_f_p_enum.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPFunctionDef Class Reference",
"href":"cpp_ref/class_f_p_function_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPInterface Class Reference",
"href":"cpp_ref/class_f_p_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPInterfaceDesc Class Reference",
"href":"cpp_ref/class_f_p_interface_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPMacroEmitter Class Reference",
"href":"cpp_ref/class_f_p_macro_emitter.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPMixinInterface Class Reference",
"href":"cpp_ref/class_f_p_mixin_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPParams Class Reference",
"href":"cpp_ref/class_f_p_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPParamDef Class Reference",
"href":"cpp_ref/class_f_p_param_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPParamOptions Class Reference",
"href":"cpp_ref/class_f_p_param_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPPropDef Class Reference",
"href":"cpp_ref/class_f_p_prop_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPStaticInterface Class Reference",
"href":"cpp_ref/class_f_p_static_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPValidator Class Reference",
"href":"cpp_ref/class_f_p_validator.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPValue Class Reference",
"href":"cpp_ref/class_f_p_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: GammaMgr Class Reference",
"href":"cpp_ref/class_gamma_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: GamConvert16 Class Reference",
"href":"cpp_ref/class_gam_convert16.html",
"description":"",
"ancestors":[]},
{"title":"C++: GamConvert8 Class Reference",
"href":"cpp_ref/class_gam_convert8.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenericCallback Class Reference",
"href":"cpp_ref/class_generic_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenericHierarchy Class Reference",
"href":"cpp_ref/class_generic_hierarchy.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenericNamedSelSetList Class Reference",
"href":"cpp_ref/class_generic_named_sel_set_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenBoxObject Class Reference",
"href":"cpp_ref/class_gen_box_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenCamera Class Reference",
"href":"cpp_ref/class_gen_camera.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenControlSelectionProcessor Class Reference",
"href":"cpp_ref/class_gen_control_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenCylinder Class Reference",
"href":"cpp_ref/class_gen_cylinder.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenLight Class Reference",
"href":"cpp_ref/class_gen_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenModSelectionProcessor Class Reference",
"href":"cpp_ref/class_gen_mod_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenSphere Class Reference",
"href":"cpp_ref/class_gen_sphere.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenSubObjType Class Reference",
"href":"cpp_ref/class_gen_sub_obj_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: GeomObject Class Reference",
"href":"cpp_ref/class_geom_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: GeomPipelineEnumProc Class Reference",
"href":"cpp_ref/class_geom_pipeline_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: GeoTableItem Class Reference",
"href":"cpp_ref/class_geo_table_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: GetParamDim Class Reference",
"href":"cpp_ref/class_get_param_dim.html",
"description":"",
"ancestors":[]},
{"title":"C++: GetParamName Class Reference",
"href":"cpp_ref/class_get_param_name.html",
"description":"",
"ancestors":[]},
{"title":"C++: GizmoClass Class Reference",
"href":"cpp_ref/class_gizmo_class.html",
"description":"",
"ancestors":[]},
{"title":"C++: GizmoObject Class Reference",
"href":"cpp_ref/class_gizmo_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: GizmoShape Class Reference",
"href":"cpp_ref/class_gizmo_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: GlobalReferenceMaker Class Reference",
"href":"cpp_ref/class_global_reference_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: GlobalReferenceMaker::GlobalReferenceDisableGuard Class Reference",
"href":"cpp_ref/class_global_reference_maker_1_1_global_reference_disable_guard.html",
"description":"",
"ancestors":[]},
{"title":"C++: GlobalThunk Class Reference",
"href":"cpp_ref/class_global_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: GradTex Class Reference",
"href":"cpp_ref/class_grad_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: GraphicsWindow Class Reference",
"href":"cpp_ref/class_graphics_window.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class GraphicsWindow",
"href":"cpp_ref/class_graphics_window_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: GripChangedCallback Class Reference",
"href":"cpp_ref/class_grip_changed_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: GBuffer Class Reference",
"href":"cpp_ref/class_g_buffer.html",
"description":"",
"ancestors":[]},
{"title":"C++: GBufReader Class Reference",
"href":"cpp_ref/class_g_buf_reader.html",
"description":"",
"ancestors":[]},
{"title":"C++: GBufWriter Class Reference",
"href":"cpp_ref/class_g_buf_writer.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWIndex16Bit Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_h_w_index16_bit.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWIndex32Bit Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_h_w_index32_bit.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWIndexBuffer Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_h_w_index_buffer.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWTupleMesh Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_h_w_tuple_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWTupleMeshContainer Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_h_w_tuple_mesh_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWVertex Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_h_w_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWVertexBuffer Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_h_w_vertex_buffer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHWDrawMesh Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_i_h_w_draw_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHWSubMesh Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_i_h_w_sub_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshVertex Class Reference",
"href":"cpp_ref/class_g_f_x___m_e_s_h_1_1_mesh_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: GMatrix Class Reference",
"href":"cpp_ref/class_g_matrix.html",
"description":"",
"ancestors":[]},
{"title":"C++: GPort Class Reference",
"href":"cpp_ref/class_g_port.html",
"description":"",
"ancestors":[]},
{"title":"C++: GPort2 Class Reference",
"href":"cpp_ref/class_g_port2.html",
"description":"",
"ancestors":[]},
{"title":"C++: GUP Class Reference",
"href":"cpp_ref/class_g_u_p.html",
"description":"",
"ancestors":[]},
{"title":"C++: GUPHandler Class Reference",
"href":"cpp_ref/class_g_u_p_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: GUPInterface Class Reference",
"href":"cpp_ref/class_g_u_p_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: GUPList Class Reference",
"href":"cpp_ref/class_g_u_p_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: GUPManager Class Reference",
"href":"cpp_ref/class_g_u_p_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: GWinSetup Class Reference",
"href":"cpp_ref/class_g_win_setup.html",
"description":"",
"ancestors":[]},
{"title":"C++: GWFace Class Reference",
"href":"cpp_ref/class_g_w_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: HashTabMapper Class Reference",
"href":"cpp_ref/class_hash_tab_mapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: HelperObject Class Reference",
"href":"cpp_ref/class_helper_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: HierarchyEntry Class Reference",
"href":"cpp_ref/class_hierarchy_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: HitByNameDlgCallback Class Reference",
"href":"cpp_ref/class_hit_by_name_dlg_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: HitData Class Reference",
"href":"cpp_ref/class_hit_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: HitListWrapper Class Reference",
"href":"cpp_ref/class_hit_list_wrapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: HitLog Class Reference",
"href":"cpp_ref/class_hit_log.html",
"description":"",
"ancestors":[]},
{"title":"C++: HitMesh Class Reference",
"href":"cpp_ref/class_hit_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: HitRecord Class Reference",
"href":"cpp_ref/class_hit_record.html",
"description":"",
"ancestors":[]},
{"title":"C++: HitRegion Class Reference",
"href":"cpp_ref/class_hit_region.html",
"description":"",
"ancestors":[]},
{"title":"C++: Hold Class Reference",
"href":"cpp_ref/class_hold.html",
"description":"",
"ancestors":[]},
{"title":"C++: HoldSuspend Class Reference",
"href":"cpp_ref/class_hold_suspend.html",
"description":"",
"ancestors":[]},
{"title":"C++: HookPoint Class Reference",
"href":"cpp_ref/class_hook_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: HSVCallback Class Reference",
"href":"cpp_ref/class_h_s_v_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: I3DXIXRefManager Class Reference",
"href":"cpp_ref/class_i3_d_x_i_x_ref_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IdentityTM Class Reference",
"href":"cpp_ref/class_identity_t_m.html",
"description":"",
"ancestors":[]},
{"title":"C++: IlluminateComponents Class Reference",
"href":"cpp_ref/class_illuminate_components.html",
"description":"",
"ancestors":[]},
{"title":"C++: IllumParams Class Reference",
"href":"cpp_ref/class_illum_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImageFileDropType Class Reference",
"href":"cpp_ref/class_image_file_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImageFilter Class Reference",
"href":"cpp_ref/class_image_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class ImageFilter",
"href":"cpp_ref/class_image_filter_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImageFilterInfo Class Reference",
"href":"cpp_ref/class_image_filter_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportFileDropType Class Reference",
"href":"cpp_ref/class_import_file_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImpInterface Class Reference",
"href":"cpp_ref/class_imp_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImpNode Class Reference",
"href":"cpp_ref/class_imp_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: IncompatibleTypes Class Reference",
"href":"cpp_ref/class_incompatible_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: IndexThunk Class Reference",
"href":"cpp_ref/class_index_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: IndirectFreeThunk Class Reference",
"href":"cpp_ref/class_indirect_free_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: IndirectLocalThunk Class Reference",
"href":"cpp_ref/class_indirect_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: InitJointData Class Reference",
"href":"cpp_ref/class_init_joint_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: InitJointData2 Class Reference",
"href":"cpp_ref/class_init_joint_data2.html",
"description":"",
"ancestors":[]},
{"title":"C++: InitJointData3 Class Reference",
"href":"cpp_ref/class_init_joint_data3.html",
"description":"",
"ancestors":[]},
{"title":"C++: Inst Class Reference",
"href":"cpp_ref/class_inst.html",
"description":"",
"ancestors":[]},
{"title":"C++: InstanceData Class Reference",
"href":"cpp_ref/class_instance_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: InstanceDataMat Class Reference",
"href":"cpp_ref/class_instance_data_mat.html",
"description":"",
"ancestors":[]},
{"title":"C++: InstanceDataMatTex Class Reference",
"href":"cpp_ref/class_instance_data_mat_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: InstanceDataTex Class Reference",
"href":"cpp_ref/class_instance_data_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: Integer Class Reference",
"href":"cpp_ref/class_integer.html",
"description":"",
"ancestors":[]},
{"title":"C++: Integer64 Class Reference",
"href":"cpp_ref/class_integer64.html",
"description":"",
"ancestors":[]},
{"title":"C++: IntegerPtr Class Reference",
"href":"cpp_ref/class_integer_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface Class Reference",
"href":"cpp_ref/class_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface10 Class Reference",
"href":"cpp_ref/class_interface10.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface11 Class Reference",
"href":"cpp_ref/class_interface11.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface12 Class Reference",
"href":"cpp_ref/class_interface12.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface13 Class Reference",
"href":"cpp_ref/class_interface13.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface14 Class Reference",
"href":"cpp_ref/class_interface14.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface7 Class Reference",
"href":"cpp_ref/class_interface7.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface8 Class Reference",
"href":"cpp_ref/class_interface8.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface9 Class Reference",
"href":"cpp_ref/class_interface9.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface::SuspendSceneRedrawGuard Class Reference",
"href":"cpp_ref/class_interface_1_1_suspend_scene_redraw_guard.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Interface",
"href":"cpp_ref/class_interface_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: InterfaceMethod Class Reference",
"href":"cpp_ref/class_interface_method.html",
"description":"",
"ancestors":[]},
{"title":"C++: InterfaceNotifyCallback Class Reference",
"href":"cpp_ref/class_interface_notify_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: InterfaceServer Class Reference",
"href":"cpp_ref/class_interface_server.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface_ID Class Reference",
"href":"cpp_ref/class_interface___i_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: InterpCtrlUI Class Reference",
"href":"cpp_ref/class_interp_ctrl_u_i.html",
"description":"",
"ancestors":[]},
{"title":"C++: InterpKeyInfo Class Reference",
"href":"cpp_ref/class_interp_key_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: IntersectionCallback2D Class Reference",
"href":"cpp_ref/class_intersection_callback2_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: IntersectionCallback3D Class Reference",
"href":"cpp_ref/class_intersection_callback3_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interval Class Reference",
"href":"cpp_ref/class_interval.html",
"description":"",
"ancestors":[]},
{"title":"C++: ItemID Class Reference",
"href":"cpp_ref/class_item_i_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: IActionItemOverride Class Reference",
"href":"cpp_ref/class_i_action_item_override.html",
"description":"",
"ancestors":[]},
{"title":"C++: IActionItemOverrideManager Class Reference",
"href":"cpp_ref/class_i_action_item_override_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IActionItemStandin Class Reference",
"href":"cpp_ref/class_i_action_item_standin.html",
"description":"",
"ancestors":[]},
{"title":"C++: IActionManager Class Reference",
"href":"cpp_ref/class_i_action_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IActionManager10 Class Reference",
"href":"cpp_ref/class_i_action_manager10.html",
"description":"",
"ancestors":[]},
{"title":"C++: IActionOptions Class Reference",
"href":"cpp_ref/class_i_action_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAdjustMultipleTangents Class Reference",
"href":"cpp_ref/class_i_adjust_multiple_tangents.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAnalyzer Class Reference",
"href":"cpp_ref/class_i_analyzer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAnimLayerControlManager Class Reference",
"href":"cpp_ref/class_i_anim_layer_control_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAnimTrack Class Reference",
"href":"cpp_ref/class_i_anim_track.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAreaShadowType Class Reference",
"href":"cpp_ref/class_i_area_shadow_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssembly Class Reference",
"href":"cpp_ref/class_i_assembly.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssembly2 Class Reference",
"href":"cpp_ref/class_i_assembly2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssemblyMgr Class Reference",
"href":"cpp_ref/class_i_assembly_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssetAccessor Class Reference",
"href":"cpp_ref/class_i_asset_accessor.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssignVertexColors Class Reference",
"href":"cpp_ref/class_i_assign_vertex_colors.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssignVertexColors::Options Class Reference",
"href":"cpp_ref/class_i_assign_vertex_colors_1_1_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssignVertexColors_R7 Class Reference",
"href":"cpp_ref/class_i_assign_vertex_colors___r7.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssignVertexColors_R7::Options2 Class Reference",
"href":"cpp_ref/class_i_assign_vertex_colors___r7_1_1_options2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAttachCtrl Class Reference",
"href":"cpp_ref/class_i_attach_ctrl.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAutoEParamDlg Class Reference",
"href":"cpp_ref/class_i_auto_e_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAutoMParamDlg Class Reference",
"href":"cpp_ref/class_i_auto_m_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAutoTangentMan Class Reference",
"href":"cpp_ref/class_i_auto_tangent_man.html",
"description":"",
"ancestors":[]},
{"title":"C++: IADTCategory Class Reference",
"href":"cpp_ref/class_i_a_d_t_category.html",
"description":"",
"ancestors":[]},
{"title":"C++: IADTObjMgr Class Reference",
"href":"cpp_ref/class_i_a_d_t_obj_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IADTStyle Class Reference",
"href":"cpp_ref/class_i_a_d_t_style.html",
"description":"",
"ancestors":[]},
{"title":"C++: IATSClientAccess Class Reference",
"href":"cpp_ref/class_i_a_t_s_client_access.html",
"description":"",
"ancestors":[]},
{"title":"C++: IATSCustomDeps Class Reference",
"href":"cpp_ref/class_i_a_t_s_custom_deps.html",
"description":"",
"ancestors":[]},
{"title":"C++: IATSMax Class Reference",
"href":"cpp_ref/class_i_a_t_s_max.html",
"description":"",
"ancestors":[]},
{"title":"C++: IATSNotifyCallback Class Reference",
"href":"cpp_ref/class_i_a_t_s_notify_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IATSProvider Class Reference",
"href":"cpp_ref/class_i_a_t_s_provider.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBaseGrip Class Reference",
"href":"cpp_ref/class_i_base_grip.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBaseGrip2 Class Reference",
"href":"cpp_ref/class_i_base_grip2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBaseScriptControl Class Reference",
"href":"cpp_ref/class_i_base_script_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBaseScriptControl8 Class Reference",
"href":"cpp_ref/class_i_base_script_control8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBaseWireControl Class Reference",
"href":"cpp_ref/class_i_base_wire_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBatchRenderManager Class Reference",
"href":"cpp_ref/class_i_batch_render_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBatchRenderView Class Reference",
"href":"cpp_ref/class_i_batch_render_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBezFloatKey Class Reference",
"href":"cpp_ref/class_i_bez_float_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBezPoint2Key Class Reference",
"href":"cpp_ref/class_i_bez_point2_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBezPoint3Key Class Reference",
"href":"cpp_ref/class_i_bez_point3_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBezPoint4Key Class Reference",
"href":"cpp_ref/class_i_bez_point4_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBezQuatKey Class Reference",
"href":"cpp_ref/class_i_bez_quat_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBezScaleKey Class Reference",
"href":"cpp_ref/class_i_bez_scale_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedBodyKey Class Reference",
"href":"cpp_ref/class_i_biped_body_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedCopy Class Reference",
"href":"cpp_ref/class_i_biped_copy.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedExport Class Reference",
"href":"cpp_ref/class_i_biped_export.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedFSKey Class Reference",
"href":"cpp_ref/class_i_biped_f_s_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedHeadKey Class Reference",
"href":"cpp_ref/class_i_biped_head_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedHorzKey Class Reference",
"href":"cpp_ref/class_i_biped_horz_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedKey Class Reference",
"href":"cpp_ref/class_i_biped_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedPropKey Class Reference",
"href":"cpp_ref/class_i_biped_prop_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedTurnKey Class Reference",
"href":"cpp_ref/class_i_biped_turn_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipedVertKey Class Reference",
"href":"cpp_ref/class_i_biped_vert_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipFootStep Class Reference",
"href":"cpp_ref/class_i_bip_foot_step.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipMaster Class Reference",
"href":"cpp_ref/class_i_bip_master.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipMaster10 Class Reference",
"href":"cpp_ref/class_i_bip_master10.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipMaster11 Class Reference",
"href":"cpp_ref/class_i_bip_master11.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipMaster12 Class Reference",
"href":"cpp_ref/class_i_bip_master12.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipMaster8 Class Reference",
"href":"cpp_ref/class_i_bip_master8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBipMaster9 Class Reference",
"href":"cpp_ref/class_i_bip_master9.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBitmapIO_Bmp Class Reference",
"href":"cpp_ref/class_i_bitmap_i_o___bmp.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBitmapIO_Jpeg Class Reference",
"href":"cpp_ref/class_i_bitmap_i_o___jpeg.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBitmapIO_Png Class Reference",
"href":"cpp_ref/class_i_bitmap_i_o___png.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBitmapIO_Rgb Class Reference",
"href":"cpp_ref/class_i_bitmap_i_o___rgb.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBitmapIO_RLA Class Reference",
"href":"cpp_ref/class_i_bitmap_i_o___r_l_a.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBitmapIO_Tga Class Reference",
"href":"cpp_ref/class_i_bitmap_i_o___tga.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBitmapPager Class Reference",
"href":"cpp_ref/class_i_bitmap_pager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBitmapProxyManager Class Reference",
"href":"cpp_ref/class_i_bitmap_proxy_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBlobMesh Class Reference",
"href":"cpp_ref/class_i_blob_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBlockMgr Class Reference",
"href":"cpp_ref/class_i_block_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBlockRefComponent Class Reference",
"href":"cpp_ref/class_i_block_ref_component.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBoolCntrl Class Reference",
"href":"cpp_ref/class_i_bool_cntrl.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBoolFloatKey Class Reference",
"href":"cpp_ref/class_i_bool_float_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBoolObject Class Reference",
"href":"cpp_ref/class_i_bool_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBrowser Class Reference",
"href":"cpp_ref/class_i_browser.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBrowserMgr Class Reference",
"href":"cpp_ref/class_i_browser_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBrushPreset Class Reference",
"href":"cpp_ref/class_i_brush_preset.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBrushPresetContext Class Reference",
"href":"cpp_ref/class_i_brush_preset_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBrushPresetMgr Class Reference",
"href":"cpp_ref/class_i_brush_preset_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBrushPresetParams Class Reference",
"href":"cpp_ref/class_i_brush_preset_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICatRegistry Class Reference",
"href":"cpp_ref/class_i_cat_registry.html",
"description":"",
"ancestors":[]},
{"title":"C++: IChannelContainer Class Reference",
"href":"cpp_ref/class_i_channel_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IChkMtlAPI Class Reference",
"href":"cpp_ref/class_i_chk_mtl_a_p_i.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICollision Class Reference",
"href":"cpp_ref/class_i_collision.html",
"description":"",
"ancestors":[]},
{"title":"C++: IColorCorrectionMgr Class Reference",
"href":"cpp_ref/class_i_color_correction_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IColorManager Class Reference",
"href":"cpp_ref/class_i_color_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IColorSwatch Class Reference",
"href":"cpp_ref/class_i_color_swatch.html",
"description":"",
"ancestors":[]},
{"title":"C++: IColorSwatchDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_color_swatch_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: IColorSwatchRenamer Class Reference",
"href":"cpp_ref/class_i_color_swatch_renamer.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICommandPanel Class Reference",
"href":"cpp_ref/class_i_command_panel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IContainerManager Class Reference",
"href":"cpp_ref/class_i_container_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IContainerObject Class Reference",
"href":"cpp_ref/class_i_container_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IContainerObject13 Class Reference",
"href":"cpp_ref/class_i_container_object13.html",
"description":"",
"ancestors":[]},
{"title":"C++: IContainerPreferences Class Reference",
"href":"cpp_ref/class_i_container_preferences.html",
"description":"",
"ancestors":[]},
{"title":"C++: IContainerUpdateReplacedNode Class Reference",
"href":"cpp_ref/class_i_container_update_replaced_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICopyCollection Class Reference",
"href":"cpp_ref/class_i_copy_collection.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICurve Class Reference",
"href":"cpp_ref/class_i_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICurveCtl Class Reference",
"href":"cpp_ref/class_i_curve_ctl.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustomControl Class Reference",
"href":"cpp_ref/class_i_custom_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustomRenderPresets Class Reference",
"href":"cpp_ref/class_i_custom_render_presets.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustAttribCollapseManager Class Reference",
"href":"cpp_ref/class_i_cust_attrib_collapse_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustAttribContainer Class Reference",
"href":"cpp_ref/class_i_cust_attrib_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustButton Class Reference",
"href":"cpp_ref/class_i_cust_button.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustButtonDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_cust_button_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustEdit Class Reference",
"href":"cpp_ref/class_i_cust_edit.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustEditDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_cust_edit_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustImage Class Reference",
"href":"cpp_ref/class_i_cust_image.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustImageDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_cust_image_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustSeparator Class Reference",
"href":"cpp_ref/class_i_cust_separator.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustSeparatorDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_cust_separator_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustStatus Class Reference",
"href":"cpp_ref/class_i_cust_status.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustStatusDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_cust_status_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustStatusEdit Class Reference",
"href":"cpp_ref/class_i_cust_status_edit.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustStatusEditDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_cust_status_edit_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustToolbar Class Reference",
"href":"cpp_ref/class_i_cust_toolbar.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustToolbarDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_cust_toolbar_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICUIFrame Class Reference",
"href":"cpp_ref/class_i_c_u_i_frame.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICUIFrameDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_c_u_i_frame_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ID3D10GraphicsWindow Class Reference",
"href":"cpp_ref/class_i_d3_d10_graphics_window.html",
"description":"",
"ancestors":[]},
{"title":"C++: ID3D10HardwareRenderer Class Reference",
"href":"cpp_ref/class_i_d3_d10_hardware_renderer.html",
"description":"",
"ancestors":[]},
{"title":"C++: ID3D10ShaderResource Class Reference",
"href":"cpp_ref/class_i_d3_d10_shader_resource.html",
"description":"",
"ancestors":[]},
{"title":"C++: ID3D9GraphicsWindow Class Reference",
"href":"cpp_ref/class_i_d3_d9_graphics_window.html",
"description":"",
"ancestors":[]},
{"title":"C++: ID3DHWMeshCacheManager Class Reference",
"href":"cpp_ref/class_i_d3_d_h_w_mesh_cache_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDataChannel Class Reference",
"href":"cpp_ref/class_i_data_channel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightControlledLightSystem Class Reference",
"href":"cpp_ref/class_i_daylight_controlled_light_system.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightSystem Class Reference",
"href":"cpp_ref/class_i_daylight_system.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightSystem2 Class Reference",
"href":"cpp_ref/class_i_daylight_system2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightSystem3 Class Reference",
"href":"cpp_ref/class_i_daylight_system3.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightSystemFactory Class Reference",
"href":"cpp_ref/class_i_daylight_system_factory.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightSystemFactory2 Class Reference",
"href":"cpp_ref/class_i_daylight_system_factory2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDelegate Class Reference",
"href":"cpp_ref/class_i_delegate.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDerivedObject Class Reference",
"href":"cpp_ref/class_i_derived_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDialogMonitor Class Reference",
"href":"cpp_ref/class_i_dialog_monitor.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDialogMonitorNotification Class Reference",
"href":"cpp_ref/class_i_dialog_monitor_notification.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDragAndDropMgr Class Reference",
"href":"cpp_ref/class_i_drag_and_drop_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDropPackageClipFmt Class Reference",
"href":"cpp_ref/class_i_drop_package_clip_fmt.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDxMaterial Class Reference",
"href":"cpp_ref/class_i_dx_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDxMaterial2 Class Reference",
"href":"cpp_ref/class_i_dx_material2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDxMaterial3 Class Reference",
"href":"cpp_ref/class_i_dx_material3.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDxSceneManager Class Reference",
"href":"cpp_ref/class_i_dx_scene_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDxSceneTransformManager Class Reference",
"href":"cpp_ref/class_i_dx_scene_transform_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDADWindow Class Reference",
"href":"cpp_ref/class_i_d_a_d_window.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDADWindowDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_d_a_d_window_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDX8PixelShader Class Reference",
"href":"cpp_ref/class_i_d_x8_pixel_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDX8VertexShader Class Reference",
"href":"cpp_ref/class_i_d_x8_vertex_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDX9DataBridge Class Reference",
"href":"cpp_ref/class_i_d_x9_data_bridge.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDX9PixelShader Class Reference",
"href":"cpp_ref/class_i_d_x9_pixel_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDX9VertexShader Class Reference",
"href":"cpp_ref/class_i_d_x9_vertex_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDXDataBridge Class Reference",
"href":"cpp_ref/class_i_d_x_data_bridge.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDXShaderManagerInterface Class Reference",
"href":"cpp_ref/class_i_d_x_shader_manager_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: IEditNormalsMod Class Reference",
"href":"cpp_ref/class_i_edit_normals_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: IEffectFile Class Reference",
"href":"cpp_ref/class_i_effect_file.html",
"description":"",
"ancestors":[]},
{"title":"C++: IEffectManager Class Reference",
"href":"cpp_ref/class_i_effect_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IEffectParser Class Reference",
"href":"cpp_ref/class_i_effect_parser.html",
"description":"",
"ancestors":[]},
{"title":"C++: IEmissionColor Class Reference",
"href":"cpp_ref/class_i_emission_color.html",
"description":"",
"ancestors":[]},
{"title":"C++: IEnumAuxAssetsCallback Class Reference",
"href":"cpp_ref/class_i_enum_aux_assets_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IEulerControl Class Reference",
"href":"cpp_ref/class_i_euler_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IExportEntity Class Reference",
"href":"cpp_ref/class_i_export_entity.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFaceDataChannel Class Reference",
"href":"cpp_ref/class_i_face_data_channel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFaceDataChannelsEnumCallBack Class Reference",
"href":"cpp_ref/class_i_face_data_channels_enum_call_back.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFaceDataMgr Class Reference",
"href":"cpp_ref/class_i_face_data_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFileResolutionManager Class Reference",
"href":"cpp_ref/class_i_file_resolution_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFilter Class Reference",
"href":"cpp_ref/class_i_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFixer Class Reference",
"href":"cpp_ref/class_i_fixer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFrameTagManager Class Reference",
"href":"cpp_ref/class_i_frame_tag_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFFDMod< T > Class Template Reference",
"href":"cpp_ref/class_i_f_f_d_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFPLayerManager Class Reference",
"href":"cpp_ref/class_i_f_p_layer_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameBezierKey Class Reference",
"href":"cpp_ref/class_i_game_bezier_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameCamera Class Reference",
"href":"cpp_ref/class_i_game_camera.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameConstraint Class Reference",
"href":"cpp_ref/class_i_game_constraint.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameControl Class Reference",
"href":"cpp_ref/class_i_game_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameConversionManager Class Reference",
"href":"cpp_ref/class_i_game_conversion_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameErrorCallBack Class Reference",
"href":"cpp_ref/class_i_game_error_call_back.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameFX Class Reference",
"href":"cpp_ref/class_i_game_f_x.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameFXFunction Class Reference",
"href":"cpp_ref/class_i_game_f_x_function.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameFXPass Class Reference",
"href":"cpp_ref/class_i_game_f_x_pass.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameFXProperty Class Reference",
"href":"cpp_ref/class_i_game_f_x_property.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameFXTechnique Class Reference",
"href":"cpp_ref/class_i_game_f_x_technique.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameGenMod Class Reference",
"href":"cpp_ref/class_i_game_gen_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameGenObject Class Reference",
"href":"cpp_ref/class_i_game_gen_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameIKChain Class Reference",
"href":"cpp_ref/class_i_game_i_k_chain.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameKey Class Reference",
"href":"cpp_ref/class_i_game_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameKnot Class Reference",
"href":"cpp_ref/class_i_game_knot.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameLight Class Reference",
"href":"cpp_ref/class_i_game_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameLinearKey Class Reference",
"href":"cpp_ref/class_i_game_linear_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameMaterial Class Reference",
"href":"cpp_ref/class_i_game_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameMesh Class Reference",
"href":"cpp_ref/class_i_game_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameModifier Class Reference",
"href":"cpp_ref/class_i_game_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameMorpher Class Reference",
"href":"cpp_ref/class_i_game_morpher.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameNode Class Reference",
"href":"cpp_ref/class_i_game_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameObject Class Reference",
"href":"cpp_ref/class_i_game_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameProperty Class Reference",
"href":"cpp_ref/class_i_game_property.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameRenderedSurface Class Reference",
"href":"cpp_ref/class_i_game_rendered_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameSampleKey Class Reference",
"href":"cpp_ref/class_i_game_sample_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameScene Class Reference",
"href":"cpp_ref/class_i_game_scene.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameSkin Class Reference",
"href":"cpp_ref/class_i_game_skin.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameSpline Class Reference",
"href":"cpp_ref/class_i_game_spline.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameSpline3D Class Reference",
"href":"cpp_ref/class_i_game_spline3_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameSupportObject Class Reference",
"href":"cpp_ref/class_i_game_support_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameTextureMap Class Reference",
"href":"cpp_ref/class_i_game_texture_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameTCBKey Class Reference",
"href":"cpp_ref/class_i_game_t_c_b_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameUVGen Class Reference",
"href":"cpp_ref/class_i_game_u_v_gen.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGameXRefObject Class Reference",
"href":"cpp_ref/class_i_game_x_ref_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGeometryChecker Class Reference",
"href":"cpp_ref/class_i_geometry_checker.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGeometryCheckerManager Class Reference",
"href":"cpp_ref/class_i_geometry_checker_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGizmoBuffer Class Reference",
"href":"cpp_ref/class_i_gizmo_buffer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGizmoClass2 Class Reference",
"href":"cpp_ref/class_i_gizmo_class2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGizmoClass3 Class Reference",
"href":"cpp_ref/class_i_gizmo_class3.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGlobalDXDisplayManager Class Reference",
"href":"cpp_ref/class_i_global_d_x_display_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGlobalDXDisplayManager2 Class Reference",
"href":"cpp_ref/class_i_global_d_x_display_manager2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGraphNode Class Reference",
"href":"cpp_ref/class_i_graph_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGraphObjectManager Class Reference",
"href":"cpp_ref/class_i_graph_object_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGraphRef Class Reference",
"href":"cpp_ref/class_i_graph_ref.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGripManager Class Reference",
"href":"cpp_ref/class_i_grip_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGuest Class Reference",
"href":"cpp_ref/class_i_guest.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHardwareMaterial Class Reference",
"href":"cpp_ref/class_i_hardware_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHardwareMaterial2 Class Reference",
"href":"cpp_ref/class_i_hardware_material2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHardwareMaterial3 Class Reference",
"href":"cpp_ref/class_i_hardware_material3.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHardwareMesh Class Reference",
"href":"cpp_ref/class_i_hardware_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHardwareMNMesh Class Reference",
"href":"cpp_ref/class_i_hardware_m_n_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHardwareRenderer Class Reference",
"href":"cpp_ref/class_i_hardware_renderer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHardwareRendererST Class Reference",
"href":"cpp_ref/class_i_hardware_renderer_s_t.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHardwareShader Class Reference",
"href":"cpp_ref/class_i_hardware_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHeightManager Class Reference",
"href":"cpp_ref/class_i_height_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHost Class Reference",
"href":"cpp_ref/class_i_host.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIlluminationComponents Class Reference",
"href":"cpp_ref/class_i_illumination_components.html",
"description":"",
"ancestors":[]},
{"title":"C++: IImageViewer Class Reference",
"href":"cpp_ref/class_i_image_viewer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IImageViewer::PostDisplayCallback Class Reference",
"href":"cpp_ref/class_i_image_viewer_1_1_post_display_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IImageViewer::PreEventHandlerCallback Class Reference",
"href":"cpp_ref/class_i_image_viewer_1_1_pre_event_handler_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIndirectReferenceMaker Class Reference",
"href":"cpp_ref/class_i_indirect_reference_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIndirectRefTargContainer Class Reference",
"href":"cpp_ref/class_i_indirect_ref_targ_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IInstanceMgr Class Reference",
"href":"cpp_ref/class_i_instance_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IInteractiveRender Class Reference",
"href":"cpp_ref/class_i_interactive_render.html",
"description":"",
"ancestors":[]},
{"title":"C++: IICEFlowFileBirthSetup Class Reference",
"href":"cpp_ref/class_i_i_c_e_flow_file_birth_setup.html",
"description":"",
"ancestors":[]},
{"title":"C++: IICEFlowParticleFactory Class Reference",
"href":"cpp_ref/class_i_i_c_e_flow_particle_factory.html",
"description":"",
"ancestors":[]},
{"title":"C++: IICEFlowShapeControl Class Reference",
"href":"cpp_ref/class_i_i_c_e_flow_shape_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIKChainControl Class Reference",
"href":"cpp_ref/class_i_i_k_chain_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIKControl Class Reference",
"href":"cpp_ref/class_i_i_k_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIKKeyProp Class Reference",
"href":"cpp_ref/class_i_i_k_key_prop.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIRenderMgr Class Reference",
"href":"cpp_ref/class_i_i_render_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIRenderMgrSelector Class Reference",
"href":"cpp_ref/class_i_i_render_mgr_selector.html",
"description":"",
"ancestors":[]},
{"title":"C++: IJiggle Class Reference",
"href":"cpp_ref/class_i_jiggle.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKey Class Reference",
"href":"cpp_ref/class_i_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKeyControl Class Reference",
"href":"cpp_ref/class_i_key_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKeyControl2 Class Reference",
"href":"cpp_ref/class_i_key_control2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKeyProperty Class Reference",
"href":"cpp_ref/class_i_key_property.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKChainActions Class Reference",
"href":"cpp_ref/class_i_k_chain_actions.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKClipObject Class Reference",
"href":"cpp_ref/class_i_k_clip_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKCmdOps Class Reference",
"href":"cpp_ref/class_i_k_cmd_ops.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKCmdOpsEx Class Reference",
"href":"cpp_ref/class_i_k_cmd_ops_ex.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKDeriv Class Reference",
"href":"cpp_ref/class_i_k_deriv.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKEnumCallback Class Reference",
"href":"cpp_ref/class_i_k_enum_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKMasterControl Class Reference",
"href":"cpp_ref/class_i_k_master_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKSlaveControl Class Reference",
"href":"cpp_ref/class_i_k_slave_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKSolver Class Reference",
"href":"cpp_ref/class_i_k_solver.html",
"description":"",
"ancestors":[]},
{"title":"C++: IterJoint Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_iter_joint.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHIIKGoal Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_i_h_i_i_k_goal.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIKGoal Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_i_i_k_goal.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISplineIKGoal Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_i_spline_i_k_goal.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISplineIKGoal2 Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_i_spline_i_k_goal2.html",
"description":"",
"ancestors":[]},
{"title":"C++: Link Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_link.html",
"description":"",
"ancestors":[]},
{"title":"C++: LinkChain Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_link_chain.html",
"description":"",
"ancestors":[]},
{"title":"C++: RootLink Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_root_link.html",
"description":"",
"ancestors":[]},
{"title":"C++: ZeroPlaneMap Class Reference",
"href":"cpp_ref/class_i_k_sys_1_1_zero_plane_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILagMod Class Reference",
"href":"cpp_ref/class_i_lag_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILayer Class Reference",
"href":"cpp_ref/class_i_layer.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILayerControl Class Reference",
"href":"cpp_ref/class_i_layer_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILayerDisplayProperties Class Reference",
"href":"cpp_ref/class_i_layer_display_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILayerManager Class Reference",
"href":"cpp_ref/class_i_layer_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILayerProperties Class Reference",
"href":"cpp_ref/class_i_layer_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILightingData Class Reference",
"href":"cpp_ref/class_i_lighting_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILightingUnits Class Reference",
"href":"cpp_ref/class_i_lighting_units.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILightManager Class Reference",
"href":"cpp_ref/class_i_light_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILimitControl Class Reference",
"href":"cpp_ref/class_i_limit_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILinkCtrl Class Reference",
"href":"cpp_ref/class_i_link_ctrl.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILinkTMCtrl Class Reference",
"href":"cpp_ref/class_i_link_t_m_ctrl.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILinFloatKey Class Reference",
"href":"cpp_ref/class_i_lin_float_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILinPoint3Key Class Reference",
"href":"cpp_ref/class_i_lin_point3_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILinRotKey Class Reference",
"href":"cpp_ref/class_i_lin_rot_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILinScaleKey Class Reference",
"href":"cpp_ref/class_i_lin_scale_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IListControl Class Reference",
"href":"cpp_ref/class_i_list_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILoad Class Reference",
"href":"cpp_ref/class_i_load.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILoadSaveAnimation Class Reference",
"href":"cpp_ref/class_i_load_save_animation.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILoadSaveAnimation10 Class Reference",
"href":"cpp_ref/class_i_load_save_animation10.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILockedContainerUpdate Class Reference",
"href":"cpp_ref/class_i_locked_container_update.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILockedTrack Class Reference",
"href":"cpp_ref/class_i_locked_track.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILockedTracksMan Class Reference",
"href":"cpp_ref/class_i_locked_tracks_man.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILockedTrackClient Class Reference",
"href":"cpp_ref/class_i_locked_track_client.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILockedTrackImp Class Reference",
"href":"cpp_ref/class_i_locked_track_imp.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILookatControl Class Reference",
"href":"cpp_ref/class_i_lookat_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILookatControl_Extension Class Reference",
"href":"cpp_ref/class_i_lookat_control___extension.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILookAtConstRotation Class Reference",
"href":"cpp_ref/class_i_look_at_const_rotation.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILuminaire Class Reference",
"href":"cpp_ref/class_i_luminaire.html",
"description":"",
"ancestors":[]},
{"title":"C++: IManipulatorMgr Class Reference",
"href":"cpp_ref/class_i_manipulator_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMaterial Class Reference",
"href":"cpp_ref/class_i_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMaterialBrowserEntryInfo Class Reference",
"href":"cpp_ref/class_i_material_browser_entry_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMaterialViewportShading Class Reference",
"href":"cpp_ref/class_i_material_viewport_shading.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMaxBitmapViewer Class Reference",
"href":"cpp_ref/class_i_max_bitmap_viewer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenu Class Reference",
"href":"cpp_ref/class_i_menu.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuBar Class Reference",
"href":"cpp_ref/class_i_menu_bar.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuBarContext Class Reference",
"href":"cpp_ref/class_i_menu_bar_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuContext Class Reference",
"href":"cpp_ref/class_i_menu_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuElement Class Reference",
"href":"cpp_ref/class_i_menu_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuGlobalContext Class Reference",
"href":"cpp_ref/class_i_menu_global_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuItem Class Reference",
"href":"cpp_ref/class_i_menu_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuItemExtension Class Reference",
"href":"cpp_ref/class_i_menu_item_extension.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuLocalContext Class Reference",
"href":"cpp_ref/class_i_menu_local_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuManager Class Reference",
"href":"cpp_ref/class_i_menu_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuManagerExtension Class Reference",
"href":"cpp_ref/class_i_menu_manager_extension.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuSettings Class Reference",
"href":"cpp_ref/class_i_menu_settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMenuTimer Class Reference",
"href":"cpp_ref/class_i_menu_timer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMergeManager Class Reference",
"href":"cpp_ref/class_i_merge_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMeshDeformPWMod Class Reference",
"href":"cpp_ref/class_i_mesh_deform_p_w_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMeshSelect Class Reference",
"href":"cpp_ref/class_i_mesh_select.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMeshSelectData Class Reference",
"href":"cpp_ref/class_i_mesh_select_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMeshWrapper Class Reference",
"href":"cpp_ref/class_i_mesh_wrapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMetaDataManager Class Reference",
"href":"cpp_ref/class_i_meta_data_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMixer Class Reference",
"href":"cpp_ref/class_i_mixer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMixer8 Class Reference",
"href":"cpp_ref/class_i_mixer8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMixSlave Class Reference",
"href":"cpp_ref/class_i_mix_slave.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMorphByBone Class Reference",
"href":"cpp_ref/class_i_morph_by_bone.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMoFlow Class Reference",
"href":"cpp_ref/class_i_mo_flow.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMrSkyPortalLight Class Reference",
"href":"cpp_ref/class_i_mr_sky_portal_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMtlBrowserFilter Class Reference",
"href":"cpp_ref/class_i_mtl_browser_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMtlBrowserFilter_Manager Class Reference",
"href":"cpp_ref/class_i_mtl_browser_filter___manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMtlEditInterface Class Reference",
"href":"cpp_ref/class_i_mtl_edit_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMtlParams Class Reference",
"href":"cpp_ref/class_i_mtl_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMtlRender_Compatibility_MtlBase Class Reference",
"href":"cpp_ref/class_i_mtl_render___compatibility___mtl_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMtlRender_Compatibility_Renderer Class Reference",
"href":"cpp_ref/class_i_mtl_render___compatibility___renderer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMultiMenu Class Reference",
"href":"cpp_ref/class_i_multi_menu.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMultiPassCameraEffect Class Reference",
"href":"cpp_ref/class_i_multi_pass_camera_effect.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMBOps Class Reference",
"href":"cpp_ref/class_i_m_b_ops.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMCapManager Class Reference",
"href":"cpp_ref/class_i_m_cap_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMCControl Class Reference",
"href":"cpp_ref/class_i_m_c_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMCParamDlg Class Reference",
"href":"cpp_ref/class_i_m_c_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMNMeshUtilities10 Class Reference",
"href":"cpp_ref/class_i_m_n_mesh_utilities10.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMNMeshUtilities13 Class Reference",
"href":"cpp_ref/class_i_m_n_mesh_utilities13.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMNMeshUtilities8 Class Reference",
"href":"cpp_ref/class_i_m_n_mesh_utilities8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMNTempData10 Class Reference",
"href":"cpp_ref/class_i_m_n_temp_data10.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMRPhysicalSkyEnvironmentMap Class Reference",
"href":"cpp_ref/class_i_m_r_physical_sky_environment_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMRPhysicalSkyInterface Class Reference",
"href":"cpp_ref/class_i_m_r_physical_sky_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMRPhysicalSkyInterface2 Class Reference",
"href":"cpp_ref/class_i_m_r_physical_sky_interface2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMRPhysicalSunLight Class Reference",
"href":"cpp_ref/class_i_m_r_physical_sun_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMSZipMgr Class Reference",
"href":"cpp_ref/class_i_m_s_zip_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXclip Class Reference",
"href":"cpp_ref/class_i_m_xclip.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXclip8 Class Reference",
"href":"cpp_ref/class_i_m_xclip8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXtrack Class Reference",
"href":"cpp_ref/class_i_m_xtrack.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXtrack8 Class Reference",
"href":"cpp_ref/class_i_m_xtrack8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXtrackgroup Class Reference",
"href":"cpp_ref/class_i_m_xtrackgroup.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXtrackgroup8 Class Reference",
"href":"cpp_ref/class_i_m_xtrackgroup8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXSDebugger Class Reference",
"href":"cpp_ref/class_i_m_x_s_debugger.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXSParticleContainer Class Reference",
"href":"cpp_ref/class_i_m_x_s_particle_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: INamedSelectionSetManager Class Reference",
"href":"cpp_ref/class_i_named_selection_set_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: INaturalLightClass Class Reference",
"href":"cpp_ref/class_i_natural_light_class.html",
"description":"",
"ancestors":[]},
{"title":"C++: INetCreateHelpers Class Reference",
"href":"cpp_ref/class_i_net_create_helpers.html",
"description":"",
"ancestors":[]},
{"title":"C++: INewSubTexmapNotification Class Reference",
"href":"cpp_ref/class_i_new_sub_texmap_notification.html",
"description":"",
"ancestors":[]},
{"title":"C++: INode Class Reference",
"href":"cpp_ref/class_i_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeBakeProjProperties Class Reference",
"href":"cpp_ref/class_i_node_bake_proj_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeBakeProperties Class Reference",
"href":"cpp_ref/class_i_node_bake_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeDisplayControl Class Reference",
"href":"cpp_ref/class_i_node_display_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeDisplayProperties Class Reference",
"href":"cpp_ref/class_i_node_display_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeEventCallback Class Reference",
"href":"cpp_ref/class_i_node_event_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeExposure Class Reference",
"href":"cpp_ref/class_i_node_exposure.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class INode",
"href":"cpp_ref/class_i_node_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeGIProperties Class Reference",
"href":"cpp_ref/class_i_node_g_i_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeGIProperties2 Class Reference",
"href":"cpp_ref/class_i_node_g_i_properties2.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeLayerProperties Class Reference",
"href":"cpp_ref/class_i_node_layer_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeMentalRayProperties Class Reference",
"href":"cpp_ref/class_i_node_mental_ray_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeMonitor Class Reference",
"href":"cpp_ref/class_i_node_monitor.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeShadingProperties Class Reference",
"href":"cpp_ref/class_i_node_shading_properties.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeTab Class Reference",
"href":"cpp_ref/class_i_node_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeTransformed Class Reference",
"href":"cpp_ref/class_i_node_transformed.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeTransformMonitor Class Reference",
"href":"cpp_ref/class_i_node_transform_monitor.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeValidity Class Reference",
"href":"cpp_ref/class_i_node_validity.html",
"description":"",
"ancestors":[]},
{"title":"C++: INoiseControl Class Reference",
"href":"cpp_ref/class_i_noise_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IObject Class Reference",
"href":"cpp_ref/class_i_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IObjCreate Class Reference",
"href":"cpp_ref/class_i_obj_create.html",
"description":"",
"ancestors":[]},
{"title":"C++: IObjParam Class Reference",
"href":"cpp_ref/class_i_obj_param.html",
"description":"",
"ancestors":[]},
{"title":"C++: IObjXRefManager Class Reference",
"href":"cpp_ref/class_i_obj_x_ref_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IObjXRefManager8 Class Reference",
"href":"cpp_ref/class_i_obj_x_ref_manager8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IObjXRefRecord Class Reference",
"href":"cpp_ref/class_i_obj_x_ref_record.html",
"description":"",
"ancestors":[]},
{"title":"C++: IOffScreenBuf Class Reference",
"href":"cpp_ref/class_i_off_screen_buf.html",
"description":"",
"ancestors":[]},
{"title":"C++: IOperatorInterface Class Reference",
"href":"cpp_ref/class_i_operator_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: IOrientConstRotation Class Reference",
"href":"cpp_ref/class_i_orient_const_rotation.html",
"description":"",
"ancestors":[]},
{"title":"C++: IOsnapManager Class Reference",
"href":"cpp_ref/class_i_osnap_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IOsnapManager7 Class Reference",
"href":"cpp_ref/class_i_osnap_manager7.html",
"description":"",
"ancestors":[]},
{"title":"C++: IOurBipExport Class Reference",
"href":"cpp_ref/class_i_our_bip_export.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPainterCanvasInterface_V5 Class Reference",
"href":"cpp_ref/class_i_painter_canvas_interface___v5.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPainterCanvasInterface_V5_1 Class Reference",
"href":"cpp_ref/class_i_painter_canvas_interface___v5__1.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPainterCanvasInterface_V7 Class Reference",
"href":"cpp_ref/class_i_painter_canvas_interface___v7.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPainterInterface_V14 Class Reference",
"href":"cpp_ref/class_i_painter_interface___v14.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPainterInterface_V5 Class Reference",
"href":"cpp_ref/class_i_painter_interface___v5.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPainterInterface_V7 Class Reference",
"href":"cpp_ref/class_i_painter_interface___v7.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPainterRightClickHandler Class Reference",
"href":"cpp_ref/class_i_painter_right_click_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParameterManager Class Reference",
"href":"cpp_ref/class_i_parameter_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParamArray Class Reference",
"href":"cpp_ref/class_i_param_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParamBlock Class Reference",
"href":"cpp_ref/class_i_param_block.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParamBlock2 Class Reference",
"href":"cpp_ref/class_i_param_block2.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class IParamBlock2",
"href":"cpp_ref/class_i_param_block2_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParamBlock2PostLoadInfo Class Reference",
"href":"cpp_ref/class_i_param_block2_post_load_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParamMap Class Reference",
"href":"cpp_ref/class_i_param_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParamMap2 Class Reference",
"href":"cpp_ref/class_i_param_map2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParamWireMgr Class Reference",
"href":"cpp_ref/class_i_param_wire_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParserLoader Class Reference",
"href":"cpp_ref/class_i_parser_loader.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleCache Class Reference",
"href":"cpp_ref/class_i_particle_cache.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannel Class Reference",
"href":"cpp_ref/class_i_particle_channel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelAmountR Class Reference",
"href":"cpp_ref/class_i_particle_channel_amount_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelAmountW Class Reference",
"href":"cpp_ref/class_i_particle_channel_amount_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelAngAxisR Class Reference",
"href":"cpp_ref/class_i_particle_channel_ang_axis_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelAngAxisW Class Reference",
"href":"cpp_ref/class_i_particle_channel_ang_axis_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelBoolR Class Reference",
"href":"cpp_ref/class_i_particle_channel_bool_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelBoolW Class Reference",
"href":"cpp_ref/class_i_particle_channel_bool_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelExt Class Reference",
"href":"cpp_ref/class_i_particle_channel_ext.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelExt2 Class Reference",
"href":"cpp_ref/class_i_particle_channel_ext2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelFloatR Class Reference",
"href":"cpp_ref/class_i_particle_channel_float_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelFloatW Class Reference",
"href":"cpp_ref/class_i_particle_channel_float_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelIntR Class Reference",
"href":"cpp_ref/class_i_particle_channel_int_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelIntW Class Reference",
"href":"cpp_ref/class_i_particle_channel_int_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelIDR Class Reference",
"href":"cpp_ref/class_i_particle_channel_i_d_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelIDW Class Reference",
"href":"cpp_ref/class_i_particle_channel_i_d_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelINodeHandleR Class Reference",
"href":"cpp_ref/class_i_particle_channel_i_node_handle_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelINodeHandleW Class Reference",
"href":"cpp_ref/class_i_particle_channel_i_node_handle_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelINodeR Class Reference",
"href":"cpp_ref/class_i_particle_channel_i_node_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelINodeW Class Reference",
"href":"cpp_ref/class_i_particle_channel_i_node_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMapR Class Reference",
"href":"cpp_ref/class_i_particle_channel_map_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMapW Class Reference",
"href":"cpp_ref/class_i_particle_channel_map_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMatrix3R Class Reference",
"href":"cpp_ref/class_i_particle_channel_matrix3_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMatrix3W Class Reference",
"href":"cpp_ref/class_i_particle_channel_matrix3_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMeshMapR Class Reference",
"href":"cpp_ref/class_i_particle_channel_mesh_map_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMeshMapW Class Reference",
"href":"cpp_ref/class_i_particle_channel_mesh_map_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMeshR Class Reference",
"href":"cpp_ref/class_i_particle_channel_mesh_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMeshW Class Reference",
"href":"cpp_ref/class_i_particle_channel_mesh_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelNewR Class Reference",
"href":"cpp_ref/class_i_particle_channel_new_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelNewW Class Reference",
"href":"cpp_ref/class_i_particle_channel_new_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelPoint3R Class Reference",
"href":"cpp_ref/class_i_particle_channel_point3_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelPoint3W Class Reference",
"href":"cpp_ref/class_i_particle_channel_point3_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelPTVR Class Reference",
"href":"cpp_ref/class_i_particle_channel_p_t_v_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelPTVW Class Reference",
"href":"cpp_ref/class_i_particle_channel_p_t_v_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelQuatR Class Reference",
"href":"cpp_ref/class_i_particle_channel_quat_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelQuatW Class Reference",
"href":"cpp_ref/class_i_particle_channel_quat_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelTabTVFaceR Class Reference",
"href":"cpp_ref/class_i_particle_channel_tab_t_v_face_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelTabTVFaceW Class Reference",
"href":"cpp_ref/class_i_particle_channel_tab_t_v_face_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelTabUVVertR Class Reference",
"href":"cpp_ref/class_i_particle_channel_tab_u_v_vert_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelTabUVVertW Class Reference",
"href":"cpp_ref/class_i_particle_channel_tab_u_v_vert_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelTrueFalseIterator Class Reference",
"href":"cpp_ref/class_i_particle_channel_true_false_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelTrueFalseIterator2 Class Reference",
"href":"cpp_ref/class_i_particle_channel_true_false_iterator2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelVoidR Class Reference",
"href":"cpp_ref/class_i_particle_channel_void_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelVoidW Class Reference",
"href":"cpp_ref/class_i_particle_channel_void_w.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleContainer Class Reference",
"href":"cpp_ref/class_i_particle_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleGroup Class Reference",
"href":"cpp_ref/class_i_particle_group.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleGroupExt Class Reference",
"href":"cpp_ref/class_i_particle_group_ext.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleObjectExt Class Reference",
"href":"cpp_ref/class_i_particle_object_ext.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPatchDeformPWMod Class Reference",
"href":"cpp_ref/class_i_patch_deform_p_w_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPatchOps Class Reference",
"href":"cpp_ref/class_i_patch_ops.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPatchSelect Class Reference",
"href":"cpp_ref/class_i_patch_select.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPatchSelectData Class Reference",
"href":"cpp_ref/class_i_patch_select_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPathConfigMgr Class Reference",
"href":"cpp_ref/class_i_path_config_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPathConfigMgrEx Class Reference",
"href":"cpp_ref/class_i_path_config_mgr_ex.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPathPosition Class Reference",
"href":"cpp_ref/class_i_path_position.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhysiqueExport Class Reference",
"href":"cpp_ref/class_i_physique_export.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhysiqueImport Class Reference",
"href":"cpp_ref/class_i_physique_import.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyBlendedRigidVertex Class Reference",
"href":"cpp_ref/class_i_phy_blended_rigid_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyBlendedRigidVertexImport Class Reference",
"href":"cpp_ref/class_i_phy_blended_rigid_vertex_import.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyContextExport Class Reference",
"href":"cpp_ref/class_i_phy_context_export.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyContextImport Class Reference",
"href":"cpp_ref/class_i_phy_context_import.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyDeformableOffsetVertex Class Reference",
"href":"cpp_ref/class_i_phy_deformable_offset_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyFloatingVertex Class Reference",
"href":"cpp_ref/class_i_phy_floating_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyRigidVertex Class Reference",
"href":"cpp_ref/class_i_phy_rigid_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyRigidVertexImport Class Reference",
"href":"cpp_ref/class_i_phy_rigid_vertex_import.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyVertexExport Class Reference",
"href":"cpp_ref/class_i_phy_vertex_export.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPhyVertexImport Class Reference",
"href":"cpp_ref/class_i_phy_vertex_import.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPipelineClient Class Reference",
"href":"cpp_ref/class_i_pipeline_client.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPoint2 Class Reference",
"href":"cpp_ref/class_i_point2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPoint3 Class Reference",
"href":"cpp_ref/class_i_point3.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPointCache Class Reference",
"href":"cpp_ref/class_i_point_cache.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPointCacheWSM Class Reference",
"href":"cpp_ref/class_i_point_cache_w_s_m.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPopupMenu Class Reference",
"href":"cpp_ref/class_i_popup_menu.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPosConstPosition Class Reference",
"href":"cpp_ref/class_i_pos_const_position.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionIntersector Class Reference",
"href":"cpp_ref/class_i_projection_intersector.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionIntersectorMgr Class Reference",
"href":"cpp_ref/class_i_projection_intersector_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionMod Class Reference",
"href":"cpp_ref/class_i_projection_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionMod10 Class Reference",
"href":"cpp_ref/class_i_projection_mod10.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionModData Class Reference",
"href":"cpp_ref/class_i_projection_mod_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionModType Class Reference",
"href":"cpp_ref/class_i_projection_mod_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionRenderHandler Class Reference",
"href":"cpp_ref/class_i_projection_render_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionRenderMgr Class Reference",
"href":"cpp_ref/class_i_projection_render_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjection_WorkingModelInfo Class Reference",
"href":"cpp_ref/class_i_projection___working_model_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPropertyContainer Class Reference",
"href":"cpp_ref/class_i_property_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFAction Class Reference",
"href":"cpp_ref/class_i_p_f_action.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionExt Class Reference",
"href":"cpp_ref/class_i_p_f_action_ext.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionList Class Reference",
"href":"cpp_ref/class_i_p_f_action_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionListMaterialHolder Class Reference",
"href":"cpp_ref/class_i_p_f_action_list_material_holder.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionListPool Class Reference",
"href":"cpp_ref/class_i_p_f_action_list_pool.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionListSet Class Reference",
"href":"cpp_ref/class_i_p_f_action_list_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionState Class Reference",
"href":"cpp_ref/class_i_p_f_action_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFArrow Class Reference",
"href":"cpp_ref/class_i_p_f_arrow.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFIntegrator Class Reference",
"href":"cpp_ref/class_i_p_f_integrator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFOperator Class Reference",
"href":"cpp_ref/class_i_p_f_operator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFOperatorPhysXWorld Class Reference",
"href":"cpp_ref/class_i_p_f_operator_phys_x_world.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFRender Class Reference",
"href":"cpp_ref/class_i_p_f_render.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFSystem Class Reference",
"href":"cpp_ref/class_i_p_f_system.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFSystemPool Class Reference",
"href":"cpp_ref/class_i_p_f_system_pool.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFTest Class Reference",
"href":"cpp_ref/class_i_p_f_test.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFViewport Class Reference",
"href":"cpp_ref/class_i_p_f_viewport.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFViewportExtension2 Class Reference",
"href":"cpp_ref/class_i_p_f_viewport_extension2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFViewportExtention Class Reference",
"href":"cpp_ref/class_i_p_f_viewport_extention.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPViewItem Class Reference",
"href":"cpp_ref/class_i_p_view_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPViewItemCreator Class Reference",
"href":"cpp_ref/class_i_p_view_item_creator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPViewManager Class Reference",
"href":"cpp_ref/class_i_p_view_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IQuadMenu Class Reference",
"href":"cpp_ref/class_i_quad_menu.html",
"description":"",
"ancestors":[]},
{"title":"C++: IQuadMenuContext Class Reference",
"href":"cpp_ref/class_i_quad_menu_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: IQuadMenuSettings Class Reference",
"href":"cpp_ref/class_i_quad_menu_settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRadiosityEffectExtension Class Reference",
"href":"cpp_ref/class_i_radiosity_effect_extension.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRadiosityPreferences Class Reference",
"href":"cpp_ref/class_i_radiosity_preferences.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRadiosityRenderParameters Class Reference",
"href":"cpp_ref/class_i_radiosity_render_parameters.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRayTexmap Class Reference",
"href":"cpp_ref/class_i_ray_texmap.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRefHierarchy Class Reference",
"href":"cpp_ref/class_i_ref_hierarchy.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRefTargContainer Class Reference",
"href":"cpp_ref/class_i_ref_targ_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRefTargMonitor Class Reference",
"href":"cpp_ref/class_i_ref_targ_monitor.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRefTargMonitorClass Class Reference",
"href":"cpp_ref/class_i_ref_targ_monitor_class.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRendererRequirements Class Reference",
"href":"cpp_ref/class_i_renderer_requirements.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderElement Class Reference",
"href":"cpp_ref/class_i_render_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderElementCompatible Class Reference",
"href":"cpp_ref/class_i_render_element_compatible.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderElementMgr Class Reference",
"href":"cpp_ref/class_i_render_element_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderElementRequirements Class Reference",
"href":"cpp_ref/class_i_render_element_requirements.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderMesh Class Reference",
"href":"cpp_ref/class_i_render_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderMeshCache Class Reference",
"href":"cpp_ref/class_i_render_mesh_cache.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderPresetsManager Class Reference",
"href":"cpp_ref/class_i_render_presets_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderProgressCallback Class Reference",
"href":"cpp_ref/class_i_render_progress_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderSSEControl Class Reference",
"href":"cpp_ref/class_i_render_s_s_e_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRendParams Class Reference",
"href":"cpp_ref/class_i_rend_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: IReshadeFragment Class Reference",
"href":"cpp_ref/class_i_reshade_fragment.html",
"description":"",
"ancestors":[]},
{"title":"C++: IReshading Class Reference",
"href":"cpp_ref/class_i_reshading.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRollupCallback Class Reference",
"href":"cpp_ref/class_i_rollup_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRollupPanel Class Reference",
"href":"cpp_ref/class_i_rollup_panel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRollupRCMenuItem Class Reference",
"href":"cpp_ref/class_i_rollup_r_c_menu_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRollupSettings Class Reference",
"href":"cpp_ref/class_i_rollup_settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRollupWindow Class Reference",
"href":"cpp_ref/class_i_rollup_window.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRollupWindowDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_rollup_window_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRotWindup Class Reference",
"href":"cpp_ref/class_i_rot_windup.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRTShaderManager Class Reference",
"href":"cpp_ref/class_i_r_t_shader_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRTShaderManager2 Class Reference",
"href":"cpp_ref/class_i_r_t_shader_manager2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRTShaderNode Class Reference",
"href":"cpp_ref/class_i_r_t_shader_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRTShaderParameterBinding Class Reference",
"href":"cpp_ref/class_i_r_t_shader_parameter_binding.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISave Class Reference",
"href":"cpp_ref/class_i_save.html",
"description":"",
"ancestors":[]},
{"title":"C++: IScanRenderer Class Reference",
"href":"cpp_ref/class_i_scan_renderer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IScanRenderer2 Class Reference",
"href":"cpp_ref/class_i_scan_renderer2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IScene Class Reference",
"href":"cpp_ref/class_i_scene.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISceneCallbackPriority Class Reference",
"href":"cpp_ref/class_i_scene_callback_priority.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISceneEventCallback Class Reference",
"href":"cpp_ref/class_i_scene_event_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISceneEventManager Class Reference",
"href":"cpp_ref/class_i_scene_event_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISceneStateManager Class Reference",
"href":"cpp_ref/class_i_scene_state_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISceneTraversal Class Reference",
"href":"cpp_ref/class_i_scene_traversal.html",
"description":"",
"ancestors":[]},
{"title":"C++: IScriptCtrl Class Reference",
"href":"cpp_ref/class_i_script_ctrl.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISectList Class Reference",
"href":"cpp_ref/class_i_sect_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISetIKKeyProp Class Reference",
"href":"cpp_ref/class_i_set_i_k_key_prop.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISetKey Class Reference",
"href":"cpp_ref/class_i_set_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: IShadeContextExtension8 Class Reference",
"href":"cpp_ref/class_i_shade_context_extension8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IShadowLightData Class Reference",
"href":"cpp_ref/class_i_shadow_light_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: IShapeRectRenderParams Class Reference",
"href":"cpp_ref/class_i_shape_rect_render_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISimpleFaceDataChannel Class Reference",
"href":"cpp_ref/class_i_simple_face_data_channel.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISimpleFaceDataManager Class Reference",
"href":"cpp_ref/class_i_simple_face_data_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISimpleManipulator Class Reference",
"href":"cpp_ref/class_i_simple_manipulator.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISkin Class Reference",
"href":"cpp_ref/class_i_skin.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISkin2 Class Reference",
"href":"cpp_ref/class_i_skin2.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISkinContextData Class Reference",
"href":"cpp_ref/class_i_skin_context_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISkinImportData Class Reference",
"href":"cpp_ref/class_i_skin_import_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISkinPose Class Reference",
"href":"cpp_ref/class_i_skin_pose.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISkyLight Class Reference",
"href":"cpp_ref/class_i_sky_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISliderControl Class Reference",
"href":"cpp_ref/class_i_slider_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISliderControlDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_slider_control_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISoftSelect Class Reference",
"href":"cpp_ref/class_i_soft_select.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISpecularCompositeShader Class Reference",
"href":"cpp_ref/class_i_specular_composite_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISpinnerControl Class Reference",
"href":"cpp_ref/class_i_spinner_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISpinnerControlDestructorPolicy Class Reference",
"href":"cpp_ref/class_i_spinner_control_destructor_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISplineIKControl Class Reference",
"href":"cpp_ref/class_i_spline_i_k_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISplineIKControl2 Class Reference",
"href":"cpp_ref/class_i_spline_i_k_control2.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISplineOps Class Reference",
"href":"cpp_ref/class_i_spline_ops.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISplineSelect Class Reference",
"href":"cpp_ref/class_i_spline_select.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISplineSelectData Class Reference",
"href":"cpp_ref/class_i_spline_select_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: IStatusPanel Class Reference",
"href":"cpp_ref/class_i_status_panel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IStdDualVS Class Reference",
"href":"cpp_ref/class_i_std_dual_v_s.html",
"description":"",
"ancestors":[]},
{"title":"C++: IStdDualVSCallback Class Reference",
"href":"cpp_ref/class_i_std_dual_v_s_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISubMap Class Reference",
"href":"cpp_ref/class_i_sub_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISubMtlAPI Class Reference",
"href":"cpp_ref/class_i_sub_mtl_a_p_i.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISubMtlMap_BrowserFilter Class Reference",
"href":"cpp_ref/class_i_sub_mtl_map___browser_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISubObjType Class Reference",
"href":"cpp_ref/class_i_sub_obj_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISubTargetCtrl Class Reference",
"href":"cpp_ref/class_i_sub_target_ctrl.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISunLight Class Reference",
"href":"cpp_ref/class_i_sun_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISunLightPosition Class Reference",
"href":"cpp_ref/class_i_sun_light_position.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISurfPosition Class Reference",
"href":"cpp_ref/class_i_surf_position.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISystemXRef Class Reference",
"href":"cpp_ref/class_i_system_x_ref.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabbedDialog Class Reference",
"href":"cpp_ref/class_i_tabbed_dialog.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabDialogFilter Class Reference",
"href":"cpp_ref/class_i_tab_dialog_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabDialogManager Class Reference",
"href":"cpp_ref/class_i_tab_dialog_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabDialogObject Class Reference",
"href":"cpp_ref/class_i_tab_dialog_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabDialogPluginTab Class Reference",
"href":"cpp_ref/class_i_tab_dialog_plugin_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabDialogProc Class Reference",
"href":"cpp_ref/class_i_tab_dialog_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabPage Class Reference",
"href":"cpp_ref/class_i_tab_page.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabPageProc Class Reference",
"href":"cpp_ref/class_i_tab_page_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITargetedIO Class Reference",
"href":"cpp_ref/class_i_targeted_i_o.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITestInterface Class Reference",
"href":"cpp_ref/class_i_test_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITextObject Class Reference",
"href":"cpp_ref/class_i_text_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITimeBasedConverter Class Reference",
"href":"cpp_ref/class_i_time_based_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITimeSlider Class Reference",
"href":"cpp_ref/class_i_time_slider.html",
"description":"",
"ancestors":[]},
{"title":"C++: IToneOperatorExtension Class Reference",
"href":"cpp_ref/class_i_tone_operator_extension.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITrackBar Class Reference",
"href":"cpp_ref/class_i_track_bar.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITrackBarFilterManager Class Reference",
"href":"cpp_ref/class_i_track_bar_filter_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITrackViewArray Class Reference",
"href":"cpp_ref/class_i_track_view_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITrackViewNode Class Reference",
"href":"cpp_ref/class_i_track_view_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITreeEnumProc Class Reference",
"href":"cpp_ref/class_i_tree_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITreeView Class Reference",
"href":"cpp_ref/class_i_tree_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITreeViewOps Class Reference",
"href":"cpp_ref/class_i_tree_view_ops.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITreeViewUI Class Reference",
"href":"cpp_ref/class_i_tree_view_u_i.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITCBFloatKey Class Reference",
"href":"cpp_ref/class_i_t_c_b_float_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITCBKey Class Reference",
"href":"cpp_ref/class_i_t_c_b_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITCBPoint3Key Class Reference",
"href":"cpp_ref/class_i_t_c_b_point3_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITCBPoint4Key Class Reference",
"href":"cpp_ref/class_i_t_c_b_point4_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITCBRotKey Class Reference",
"href":"cpp_ref/class_i_t_c_b_rot_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITCBScaleKey Class Reference",
"href":"cpp_ref/class_i_t_c_b_scale_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITVUtility Class Reference",
"href":"cpp_ref/class_i_t_v_utility.html",
"description":"",
"ancestors":[]},
{"title":"C++: IUnwrapMod Class Reference",
"href":"cpp_ref/class_i_unwrap_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: IUnwrapMod2 Class Reference",
"href":"cpp_ref/class_i_unwrap_mod2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IUnwrapMod3 Class Reference",
"href":"cpp_ref/class_i_unwrap_mod3.html",
"description":"",
"ancestors":[]},
{"title":"C++: IUnwrapMod4 Class Reference",
"href":"cpp_ref/class_i_unwrap_mod4.html",
"description":"",
"ancestors":[]},
{"title":"C++: IUnReplaceableControl Class Reference",
"href":"cpp_ref/class_i_un_replaceable_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: IUtil Class Reference",
"href":"cpp_ref/class_i_util.html",
"description":"",
"ancestors":[]},
{"title":"C++: IUtilityPanel Class Reference",
"href":"cpp_ref/class_i_utility_panel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IValidateNodeCallback Class Reference",
"href":"cpp_ref/class_i_validate_node_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IValidityToken Class Reference",
"href":"cpp_ref/class_i_validity_token.html",
"description":"",
"ancestors":[]},
{"title":"C++: IValidityTokenImp Class Reference",
"href":"cpp_ref/class_i_validity_token_imp.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVertexPaint Class Reference",
"href":"cpp_ref/class_i_vertex_paint.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVertexPaint_R7 Class Reference",
"href":"cpp_ref/class_i_vertex_paint___r7.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVertexShader Class Reference",
"href":"cpp_ref/class_i_vertex_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportButton Class Reference",
"href":"cpp_ref/class_i_viewport_button.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportButtonManager Class Reference",
"href":"cpp_ref/class_i_viewport_button_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportShaderManager Class Reference",
"href":"cpp_ref/class_i_viewport_shader_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportShaderManager2 Class Reference",
"href":"cpp_ref/class_i_viewport_shader_manager2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportShaderManager3 Class Reference",
"href":"cpp_ref/class_i_viewport_shader_manager3.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportShadingMgr Class Reference",
"href":"cpp_ref/class_i_viewport_shading_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportShadingMgr2 Class Reference",
"href":"cpp_ref/class_i_viewport_shading_mgr2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewPanel Class Reference",
"href":"cpp_ref/class_i_view_panel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewPanelManager Class Reference",
"href":"cpp_ref/class_i_view_panel_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVisualMSCallback Class Reference",
"href":"cpp_ref/class_i_visual_m_s_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVisualMSForm Class Reference",
"href":"cpp_ref/class_i_visual_m_s_form.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVisualMSItem Class Reference",
"href":"cpp_ref/class_i_visual_m_s_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVisualMSMgr Class Reference",
"href":"cpp_ref/class_i_visual_m_s_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IWavePaint Class Reference",
"href":"cpp_ref/class_i_wave_paint.html",
"description":"",
"ancestors":[]},
{"title":"C++: IWaveSound Class Reference",
"href":"cpp_ref/class_i_wave_sound.html",
"description":"",
"ancestors":[]},
{"title":"C++: IWorkingPivot Class Reference",
"href":"cpp_ref/class_i_working_pivot.html",
"description":"",
"ancestors":[]},
{"title":"C++: IWorkBench Class Reference",
"href":"cpp_ref/class_i_work_bench.html",
"description":"",
"ancestors":[]},
{"title":"C++: IWorkBench2 Class Reference",
"href":"cpp_ref/class_i_work_bench2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IXRefAtmospheric Class Reference",
"href":"cpp_ref/class_i_x_ref_atmospheric.html",
"description":"",
"ancestors":[]},
{"title":"C++: IXRefCtrl Class Reference",
"href":"cpp_ref/class_i_x_ref_ctrl.html",
"description":"",
"ancestors":[]},
{"title":"C++: IXRefItem Class Reference",
"href":"cpp_ref/class_i_x_ref_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: IXRefMaterial Class Reference",
"href":"cpp_ref/class_i_x_ref_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: IXRefObject Class Reference",
"href":"cpp_ref/class_i_x_ref_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IXRefObject8 Class Reference",
"href":"cpp_ref/class_i_x_ref_object8.html",
"description":"",
"ancestors":[]},
{"title":"C++: IXRefProxy Class Reference",
"href":"cpp_ref/class_i_x_ref_proxy.html",
"description":"",
"ancestors":[]},
{"title":"C++: IXTCAccess Class Reference",
"href":"cpp_ref/class_i_x_t_c_access.html",
"description":"",
"ancestors":[]},
{"title":"C++: JointDlgData Class Reference",
"href":"cpp_ref/class_joint_dlg_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: JointParams Class Reference",
"href":"cpp_ref/class_joint_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: JointParams2 Class Reference",
"href":"cpp_ref/class_joint_params2.html",
"description":"",
"ancestors":[]},
{"title":"C++: JPLimitsRestore Class Reference",
"href":"cpp_ref/class_j_p_limits_restore.html",
"description":"",
"ancestors":[]},
{"title":"C++: KeyReduceStatus Class Reference",
"href":"cpp_ref/class_key_reduce_status.html",
"description":"",
"ancestors":[]},
{"title":"C++: LagModData Class Reference",
"href":"cpp_ref/class_lag_mod_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: LayerProperty Class Reference",
"href":"cpp_ref/class_layer_property.html",
"description":"",
"ancestors":[]},
{"title":"C++: Light Class Reference",
"href":"cpp_ref/class_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightscapeLight Class Reference",
"href":"cpp_ref/class_lightscape_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightscapeLight::AreaLightCustAttrib Class Reference",
"href":"cpp_ref/class_lightscape_light_1_1_area_light_cust_attrib.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightDesc Class Reference",
"href":"cpp_ref/class_light_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightObject Class Reference",
"href":"cpp_ref/class_light_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightRayTraversal Class Reference",
"href":"cpp_ref/class_light_ray_traversal.html",
"description":"",
"ancestors":[]},
{"title":"C++: LinearShape Class Reference",
"href":"cpp_ref/class_linear_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: LineBuffer Class Reference",
"href":"cpp_ref/class_line_buffer.html",
"description":"",
"ancestors":[]},
{"title":"C++: LinkedEntryT< T > Class Template Reference",
"href":"cpp_ref/class_linked_entry_t.html",
"description":"",
"ancestors":[]},
{"title":"C++: LinkedListT< T, TE > Class Template Reference",
"href":"cpp_ref/class_linked_list_t.html",
"description":"",
"ancestors":[]},
{"title":"C++: Listener Class Reference",
"href":"cpp_ref/class_listener.html",
"description":"",
"ancestors":[]},
{"title":"C++: ListenerMessageData Class Reference",
"href":"cpp_ref/class_listener_message_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: ListenerViewWindow Class Reference",
"href":"cpp_ref/class_listener_view_window.html",
"description":"",
"ancestors":[]},
{"title":"C++: LoadSaveRetargetData Class Reference",
"href":"cpp_ref/class_load_save_retarget_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: LocalModData Class Reference",
"href":"cpp_ref/class_local_mod_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: LocalThunk Class Reference",
"href":"cpp_ref/class_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: LockableControl Class Reference",
"href":"cpp_ref/class_lockable_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: LockableStdControl Class Reference",
"href":"cpp_ref/class_lockable_std_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: LogSys Class Reference",
"href":"cpp_ref/class_log_sys.html",
"description":"",
"ancestors":[]},
{"title":"C++: LoopContinue Class Reference",
"href":"cpp_ref/class_loop_continue.html",
"description":"",
"ancestors":[]},
{"title":"C++: LoopExit Class Reference",
"href":"cpp_ref/class_loop_exit.html",
"description":"",
"ancestors":[]},
{"title":"C++: MacroButtonData Class Reference",
"href":"cpp_ref/class_macro_button_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MacroDir Class Reference",
"href":"cpp_ref/class_macro_dir.html",
"description":"",
"ancestors":[]},
{"title":"C++: MacroEntry Class Reference",
"href":"cpp_ref/class_macro_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: MacroEntry::DisableCompileGuard Class Reference",
"href":"cpp_ref/class_macro_entry_1_1_disable_compile_guard.html",
"description":"",
"ancestors":[]},
{"title":"C++: MacroRecorder Class Reference",
"href":"cpp_ref/class_macro_recorder.html",
"description":"",
"ancestors":[]},
{"title":"C++: MacroRecorder::MacroRecorderDisable Class Reference",
"href":"cpp_ref/class_macro_recorder_1_1_macro_recorder_disable.html",
"description":"",
"ancestors":[]},
{"title":"C++: Maker Class Reference",
"href":"cpp_ref/class_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: Manipulator Class Reference",
"href":"cpp_ref/class_manipulator.html",
"description":"",
"ancestors":[]},
{"title":"C++: ManipulatorGizmo Class Reference",
"href":"cpp_ref/class_manipulator_gizmo.html",
"description":"",
"ancestors":[]},
{"title":"C++: ManipHitData Class Reference",
"href":"cpp_ref/class_manip_hit_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MapBitArray Class Reference",
"href":"cpp_ref/class_map_bit_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: MapDelta Class Reference",
"href":"cpp_ref/class_map_delta.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class MapDelta",
"href":"cpp_ref/class_map_delta_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: MapSampler Class Reference",
"href":"cpp_ref/class_map_sampler.html",
"description":"",
"ancestors":[]},
{"title":"C++: MarketDefaults Class Reference",
"href":"cpp_ref/class_market_defaults.html",
"description":"",
"ancestors":[]},
{"title":"C++: MarketDefaults13 Class Reference",
"href":"cpp_ref/class_market_defaults13.html",
"description":"",
"ancestors":[]},
{"title":"C++: MarketDefaults::Range< T, low, high > Class Template Reference",
"href":"cpp_ref/class_market_defaults_1_1_range.html",
"description":"",
"ancestors":[]},
{"title":"C++: MasterPointControl Class Reference",
"href":"cpp_ref/class_master_point_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material Class Reference",
"href":"cpp_ref/class_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: Matrix2 Class Reference",
"href":"cpp_ref/class_matrix2.html",
"description":"",
"ancestors":[]},
{"title":"C++: Matrix3 Class Reference",
"href":"cpp_ref/class_matrix3.html",
"description":"",
"ancestors":[]},
{"title":"C++: Matrix3Indirect Class Reference",
"href":"cpp_ref/class_matrix3_indirect.html",
"description":"",
"ancestors":[]},
{"title":"C++: Matrix3Stack Class Reference",
"href":"cpp_ref/class_matrix3_stack.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxBakeElement Class Reference",
"href":"cpp_ref/class_max_bake_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxBakeElement10 Class Reference",
"href":"cpp_ref/class_max_bake_element10.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxBakeElement8 Class Reference",
"href":"cpp_ref/class_max_bake_element8.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxBmpFileIcon Class Reference",
"href":"cpp_ref/class_max_bmp_file_icon.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxHeapOperators Class Reference",
"href":"cpp_ref/class_max_heap_operators.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxIcon Class Reference",
"href":"cpp_ref/class_max_icon.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxLocaleHandler Class Reference",
"href":"cpp_ref/class_max_locale_handler.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxMixerManager Class Reference",
"href":"cpp_ref/class_max_mixer_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxNet Class Reference",
"href":"cpp_ref/class_max_net.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxNetworkInterface Class Reference",
"href":"cpp_ref/class_max_network_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxNetworkInterface2 Class Reference",
"href":"cpp_ref/class_max_network_interface2.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxNetCallBack Class Reference",
"href":"cpp_ref/class_max_net_call_back.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxNetEngine Class Reference",
"href":"cpp_ref/class_max_net_engine.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxNetFile Class Reference",
"href":"cpp_ref/class_max_net_file.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxNetJob Class Reference",
"href":"cpp_ref/class_max_net_job.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxNetManager Class Reference",
"href":"cpp_ref/class_max_net_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class MaxNetManager",
"href":"cpp_ref/class_max_net_manager_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxRenderElement Class Reference",
"href":"cpp_ref/class_max_render_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: Array< T > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: ArrayAutoPtr< Type > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_array_auto_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: ArrayPointerDestructor< Type > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_array_pointer_destructor.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetUser Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_asset_management_1_1_asset_user.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAssetManager Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_asset_management_1_1_i_asset_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: AutoPtr< Type, DestructorPolicy > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_auto_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMouseConfigManager Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_c_u_i_1_1_i_mouse_config_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: DeleteThisAutoPtr< Type > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_delete_this_auto_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: DeleteThisDestructor Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_delete_this_destructor.html",
"description":"",
"ancestors":[]},
{"title":"C++: AtomicRefCounter Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_atomic_ref_counter.html",
"description":"",
"ancestors":[]},
{"title":"C++: AutoRestoreWorldMatrix Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_auto_restore_world_matrix.html",
"description":"",
"ancestors":[]},
{"title":"C++: ARefObject Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_a_ref_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseMaterialHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_base_material_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseRasterHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_base_raster_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: BlendState Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_blend_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: ChildObjectDisplayCallback Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_child_object_display_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: CompoundObjectAddRenderItemsHelper Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_compound_object_add_render_items_helper.html",
"description":"",
"ancestors":[]},
{"title":"C++: CustomRenderItemHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_custom_render_item_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: DefaultLifeTimePolicy< RefObjectType > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_default_life_time_policy.html",
"description":"",
"ancestors":[]},
{"title":"C++: DepthStencilState Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_depth_stencil_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: DisplayCallbackContext Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_display_callback_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: DisplayTextureHelper Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_display_texture_helper.html",
"description":"",
"ancestors":[]},
{"title":"C++: DrawContext Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_draw_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenerateMeshRenderItemsContext Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_generate_mesh_render_items_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: GeometryRenderItemHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_geometry_render_item_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: HLSLMaterialHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_h_l_s_l_material_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImmediateFragment Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_immediate_fragment.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImmediateRenderItemHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_immediate_render_item_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: IndexBufferHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_index_buffer_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAddRenderItemsHelper Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_add_render_items_helper.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustomRenderItem Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_custom_render_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDisplayCallback Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_display_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDisplayManager Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_display_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDisplayManager2 Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_display_manager2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDisposable Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_disposable.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHLSLMaterialTranslator Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_h_l_s_l_material_translator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMeshDisplay2 Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_mesh_display2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IObjectDisplay Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_object_display.html",
"description":"",
"ancestors":[]},
{"title":"C++: IObjectDisplay2 Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_object_display2.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParameterTranslator Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_parameter_translator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPrimitiveRenderer Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_primitive_renderer.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRefObject Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_ref_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderGeometry Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_render_geometry.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderItemContainer Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_render_item_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRenderStateManager Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_render_state_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IShaderManager Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_shader_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IShaderManagerCreator Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_shader_manager_creator.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISimpleMaterial Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_simple_material.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITextureDisplay Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_texture_display.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportViewSetting Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_viewport_view_setting.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVirtualDevice Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_i_virtual_device.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaterialRequiredStreams Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_material_required_streams.html",
"description":"",
"ancestors":[]},
{"title":"C++: Matrix44 Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_matrix44.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxContext Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_max_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshElementDescription Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_mesh_element_description.html",
"description":"",
"ancestors":[]},
{"title":"C++: PresentableTargetHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_presentable_target_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: RasterizerState Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_rasterizer_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: RefPtr< RefObjectType, SafeRefObjectType, LifeTimePolicy > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_ref_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderItemHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_render_item_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderItemHandleArray Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_render_item_handle_array.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderItemHandleDecorator Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_render_item_handle_decorator.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderNodeHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_render_node_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: SafeReferenceObjectProxy< RefObjectType > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_safe_reference_object_proxy.html",
"description":"",
"ancestors":[]},
{"title":"C++: SmartHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_smart_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: SolidColorMaterialHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_solid_color_material_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: StandardMaterialHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_standard_material_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: StencilOperation Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_stencil_operation.html",
"description":"",
"ancestors":[]},
{"title":"C++: TargetBlendState Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_target_blend_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: TargetHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_target_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: TextureHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_texture_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: TextureHandleUtility Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_texture_handle_utility.html",
"description":"",
"ancestors":[]},
{"title":"C++: TextureMaterialHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_texture_material_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: UpdateDisplayContext Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_update_display_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: UpdateNodeContext Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_update_node_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: UpdateViewContext Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_update_view_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertexBufferHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_vertex_buffer_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertexColorMaterialHandle Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_graphics_1_1_vertex_color_material_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: HoldBegin Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_hold_begin.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHelpSystem Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_i_help_system.html",
"description":"",
"ancestors":[]},
{"title":"C++: ThreadTools Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_performance_tools_1_1_thread_tools.html",
"description":"",
"ancestors":[]},
{"title":"C++: Timer Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_performance_tools_1_1_timer.html",
"description":"",
"ancestors":[]},
{"title":"C++: SinglePointerDestructor< Type > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_single_pointer_destructor.html",
"description":"",
"ancestors":[]},
{"title":"C++: SingleWeakRefMaker Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_single_weak_ref_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: AutoPtr< Type > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_auto_ptr.html",
"description":"",
"ancestors":[]},
{"title":"C++: BinaryStream Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_binary_stream.html",
"description":"",
"ancestors":[]},
{"title":"C++: BinaryStreamMemory Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_binary_stream_memory.html",
"description":"",
"ancestors":[]},
{"title":"C++: Char Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_char.html",
"description":"",
"ancestors":[]},
{"title":"C++: CharAccumulator Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_char_accumulator.html",
"description":"",
"ancestors":[]},
{"title":"C++: CharIterator< ChType > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_char_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: Exception Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBailOutBusyProcessManager Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_i_bail_out_busy_process_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDlgShowingStatusForPolyObj Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_i_dlg_showing_status_for_poly_obj.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxString Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_max_string.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxStringCast< ChType > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_max_string_cast.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxStringCastCP Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_max_string_cast_c_p.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxStringCastUTF8 Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_max_string_cast_u_t_f8.html",
"description":"",
"ancestors":[]},
{"title":"C++: Noncopyable Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_noncopyable.html",
"description":"",
"ancestors":[]},
{"title":"C++: NullDereferenceException Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_null_dereference_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: OutOfRangeException Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_out_of_range_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: Path Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_path.html",
"description":"",
"ancestors":[]},
{"title":"C++: RunTimeException Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_run_time_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: TabOutOfRangeException Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_tab_out_of_range_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseTextReader Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_text_file_1_1_base_text_reader.html",
"description":"",
"ancestors":[]},
{"title":"C++: BaseTextWriter Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_text_file_1_1_base_text_writer.html",
"description":"",
"ancestors":[]},
{"title":"C++: Reader Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_text_file_1_1_reader.html",
"description":"",
"ancestors":[]},
{"title":"C++: ReaderWriter Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_text_file_1_1_reader_writer.html",
"description":"",
"ancestors":[]},
{"title":"C++: Writer Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_util_1_1_text_file_1_1_writer.html",
"description":"",
"ancestors":[]},
{"title":"C++: VariableGuard< T > Class Template Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_variable_guard.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertexNormal Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_vertex_normal.html",
"description":"",
"ancestors":[]},
{"title":"C++: WindowsMessageFilter Class Reference",
"href":"cpp_ref/class_max_s_d_k_1_1_windows_message_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: MenuColors Class Reference",
"href":"cpp_ref/class_menu_colors.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mergeable Class Reference",
"href":"cpp_ref/class_mergeable.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mesh Class Reference",
"href":"cpp_ref/class_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshAccess Class Reference",
"href":"cpp_ref/class_mesh_access.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshCapper Class Reference",
"href":"cpp_ref/class_mesh_capper.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshCapInfo Class Reference",
"href":"cpp_ref/class_mesh_cap_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshCapPoly Class Reference",
"href":"cpp_ref/class_mesh_cap_poly.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshCapVert Class Reference",
"href":"cpp_ref/class_mesh_cap_vert.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshChamferData Class Reference",
"href":"cpp_ref/class_mesh_chamfer_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshData Class Reference",
"href":"cpp_ref/class_mesh_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshDelta Class Reference",
"href":"cpp_ref/class_mesh_delta.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class MeshDelta",
"href":"cpp_ref/class_mesh_delta_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshDeltaUser Class Reference",
"href":"cpp_ref/class_mesh_delta_user.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshDeltaUserData Class Reference",
"href":"cpp_ref/class_mesh_delta_user_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshFaceData Class Reference",
"href":"cpp_ref/class_mesh_face_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Mesh",
"href":"cpp_ref/class_mesh_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshMap Class Reference",
"href":"cpp_ref/class_mesh_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshNamedSelClip Class Reference",
"href":"cpp_ref/class_mesh_named_sel_clip.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshNormalFace Class Reference",
"href":"cpp_ref/class_mesh_normal_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshNormalSpec Class Reference",
"href":"cpp_ref/class_mesh_normal_spec.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshOpProgress Class Reference",
"href":"cpp_ref/class_mesh_op_progress.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshRenderData Class Reference",
"href":"cpp_ref/class_mesh_render_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshSelection Class Reference",
"href":"cpp_ref/class_mesh_selection.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshSelectionConverter Class Reference",
"href":"cpp_ref/class_mesh_selection_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshSubHitRec Class Reference",
"href":"cpp_ref/class_mesh_sub_hit_rec.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshTempData Class Reference",
"href":"cpp_ref/class_mesh_temp_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class MeshTempData",
"href":"cpp_ref/class_mesh_temp_data_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: MetaParticle Class Reference",
"href":"cpp_ref/class_meta_particle.html",
"description":"",
"ancestors":[]},
{"title":"C++: MetaPartData Class Reference",
"href":"cpp_ref/class_meta_part_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MetaPartDataMat Class Reference",
"href":"cpp_ref/class_meta_part_data_mat.html",
"description":"",
"ancestors":[]},
{"title":"C++: MetaPartDataMatTex Class Reference",
"href":"cpp_ref/class_meta_part_data_mat_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: MetaPartDataTex Class Reference",
"href":"cpp_ref/class_meta_part_data_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: MixerManager Class Reference",
"href":"cpp_ref/class_mixer_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: MocapManager Class Reference",
"href":"cpp_ref/class_mocap_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: Modifier Class Reference",
"href":"cpp_ref/class_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Modifier",
"href":"cpp_ref/class_modifier_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: ModContext Class Reference",
"href":"cpp_ref/class_mod_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: ModContextEnumProc Class Reference",
"href":"cpp_ref/class_mod_context_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ModContextList Class Reference",
"href":"cpp_ref/class_mod_context_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: MorphControl Class Reference",
"href":"cpp_ref/class_morph_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: MouseCallBack Class Reference",
"href":"cpp_ref/class_mouse_call_back.html",
"description":"",
"ancestors":[]},
{"title":"C++: MouseManager Class Reference",
"href":"cpp_ref/class_mouse_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: MouseToolCallBack Class Reference",
"href":"cpp_ref/class_mouse_tool_call_back.html",
"description":"",
"ancestors":[]},
{"title":"C++: MouseToolCommandMode Class Reference",
"href":"cpp_ref/class_mouse_tool_command_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: MoveCtrlApparatus Class Reference",
"href":"cpp_ref/class_move_ctrl_apparatus.html",
"description":"",
"ancestors":[]},
{"title":"C++: MoveCtrlApparatusCMode Class Reference",
"href":"cpp_ref/class_move_ctrl_apparatus_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: MoveModBox Class Reference",
"href":"cpp_ref/class_move_mod_box.html",
"description":"",
"ancestors":[]},
{"title":"C++: MoveModBoxCMode Class Reference",
"href":"cpp_ref/class_move_mod_box_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: MoveTransformer Class Reference",
"href":"cpp_ref/class_move_transformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: MsgFromMax Class Reference",
"href":"cpp_ref/class_msg_from_max.html",
"description":"",
"ancestors":[]},
{"title":"C++: MsgFromSrv Class Reference",
"href":"cpp_ref/class_msg_from_srv.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mtl Class Reference",
"href":"cpp_ref/class_mtl.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlBase Class Reference",
"href":"cpp_ref/class_mtl_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class MtlBase",
"href":"cpp_ref/class_mtl_base_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlBaseLib Class Reference",
"href":"cpp_ref/class_mtl_base_lib.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlBaseList Class Reference",
"href":"cpp_ref/class_mtl_base_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlDADMgr Class Reference",
"href":"cpp_ref/class_mtl_d_a_d_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Mtl",
"href":"cpp_ref/class_mtl_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlLib Class Reference",
"href":"cpp_ref/class_mtl_lib.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlList Class Reference",
"href":"cpp_ref/class_mtl_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlMakerCallback Class Reference",
"href":"cpp_ref/class_mtl_maker_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlRemap Class Reference",
"href":"cpp_ref/class_mtl_remap.html",
"description":"",
"ancestors":[]},
{"title":"C++: MultiMtl Class Reference",
"href":"cpp_ref/class_multi_mtl.html",
"description":"",
"ancestors":[]},
{"title":"C++: MultiSelectCallback Class Reference",
"href":"cpp_ref/class_multi_select_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: MultiTex Class Reference",
"href":"cpp_ref/class_multi_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: MultCurveAnimProp Class Reference",
"href":"cpp_ref/class_mult_curve_anim_prop.html",
"description":"",
"ancestors":[]},
{"title":"C++: MultCurveList Class Reference",
"href":"cpp_ref/class_mult_curve_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: MultFprintParams Class Reference",
"href":"cpp_ref/class_mult_fprint_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: MAXException Class Reference",
"href":"cpp_ref/class_m_a_x_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: MAXFileOpenDialog Class Reference",
"href":"cpp_ref/class_m_a_x_file_open_dialog.html",
"description":"",
"ancestors":[]},
{"title":"C++: MAXFileSaveDialog Class Reference",
"href":"cpp_ref/class_m_a_x_file_save_dialog.html",
"description":"",
"ancestors":[]},
{"title":"C++: MAXScriptException Class Reference",
"href":"cpp_ref/class_m_a_x_script_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: MAXScriptPrefs Class Reference",
"href":"cpp_ref/class_m_a_x_script_prefs.html",
"description":"",
"ancestors":[]},
{"title":"C++: MCDeviceBinding Class Reference",
"href":"cpp_ref/class_m_c_device_binding.html",
"description":"",
"ancestors":[]},
{"title":"C++: MCInputDevice Class Reference",
"href":"cpp_ref/class_m_c_input_device.html",
"description":"",
"ancestors":[]},
{"title":"C++: MEdge Class Reference",
"href":"cpp_ref/class_m_edge.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNChamferData Class Reference",
"href":"cpp_ref/class_m_n_chamfer_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNChamferData10 Class Reference",
"href":"cpp_ref/class_m_n_chamfer_data10.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNDiagonalHitData Class Reference",
"href":"cpp_ref/class_m_n_diagonal_hit_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNEdge Class Reference",
"href":"cpp_ref/class_m_n_edge.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNEdgeClusters Class Reference",
"href":"cpp_ref/class_m_n_edge_clusters.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNFace Class Reference",
"href":"cpp_ref/class_m_n_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNFaceClusters Class Reference",
"href":"cpp_ref/class_m_n_face_clusters.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNFaceElement Class Reference",
"href":"cpp_ref/class_m_n_face_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMap Class Reference",
"href":"cpp_ref/class_m_n_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMapFace Class Reference",
"href":"cpp_ref/class_m_n_map_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMapPreserveData Class Reference",
"href":"cpp_ref/class_m_n_map_preserve_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMesh Class Reference",
"href":"cpp_ref/class_m_n_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMeshBorder Class Reference",
"href":"cpp_ref/class_m_n_mesh_border.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class MNMesh",
"href":"cpp_ref/class_m_n_mesh_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMeshSelectionConverter Class Reference",
"href":"cpp_ref/class_m_n_mesh_selection_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMeshUtilities Class Reference",
"href":"cpp_ref/class_m_n_mesh_utilities.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNNormalFace Class Reference",
"href":"cpp_ref/class_m_n_normal_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNNormalSpec Class Reference",
"href":"cpp_ref/class_m_n_normal_spec.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNTempData Class Reference",
"href":"cpp_ref/class_m_n_temp_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNVert Class Reference",
"href":"cpp_ref/class_m_n_vert.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSpin Class Reference",
"href":"cpp_ref/class_m_spin.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSAtmosXtnd Class Reference",
"href":"cpp_ref/class_m_s_atmos_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSAutoEParamDlg Class Reference",
"href":"cpp_ref/class_m_s_auto_e_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSAutoMParamDlg Class Reference",
"href":"cpp_ref/class_m_s_auto_m_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSCameraXtnd Class Reference",
"href":"cpp_ref/class_m_s_camera_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSClassFactory Class Reference",
"href":"cpp_ref/class_m_s_class_factory.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSCustAttrib Class Reference",
"href":"cpp_ref/class_m_s_cust_attrib.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSCustAttribDef Class Reference",
"href":"cpp_ref/class_m_s_cust_attrib_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSDisplayFilterCallback Class Reference",
"href":"cpp_ref/class_m_s_display_filter_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSEffectXtnd Class Reference",
"href":"cpp_ref/class_m_s_effect_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSGeomObjectXtnd Class Reference",
"href":"cpp_ref/class_m_s_geom_object_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSHelperXtnd Class Reference",
"href":"cpp_ref/class_m_s_helper_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSLightXtnd Class Reference",
"href":"cpp_ref/class_m_s_light_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSModifierXtnd Class Reference",
"href":"cpp_ref/class_m_s_modifier_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSMtlXtnd Class Reference",
"href":"cpp_ref/class_m_s_mtl_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSObjectXtnd< TYPE, MS_SUPER > Class Template Reference",
"href":"cpp_ref/class_m_s_object_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSOLEObject Class Reference",
"href":"cpp_ref/class_m_s_o_l_e_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPlugin Class Reference",
"href":"cpp_ref/class_m_s_plugin.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginAtmos Class Reference",
"href":"cpp_ref/class_m_s_plugin_atmos.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginCamera Class Reference",
"href":"cpp_ref/class_m_s_plugin_camera.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginDesc Class Reference",
"href":"cpp_ref/class_m_s_plugin_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginEffect Class Reference",
"href":"cpp_ref/class_m_s_plugin_effect.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginGeomObject Class Reference",
"href":"cpp_ref/class_m_s_plugin_geom_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginHelper Class Reference",
"href":"cpp_ref/class_m_s_plugin_helper.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginLight Class Reference",
"href":"cpp_ref/class_m_s_plugin_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginModifier Class Reference",
"href":"cpp_ref/class_m_s_plugin_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginMtl Class Reference",
"href":"cpp_ref/class_m_s_plugin_mtl.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginObject< TYPE > Class Template Reference",
"href":"cpp_ref/class_m_s_plugin_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginPBAccessor Class Reference",
"href":"cpp_ref/class_m_s_plugin_p_b_accessor.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginShape Class Reference",
"href":"cpp_ref/class_m_s_plugin_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginSimpleManipulator Class Reference",
"href":"cpp_ref/class_m_s_plugin_simple_manipulator.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginSimpleMod Class Reference",
"href":"cpp_ref/class_m_s_plugin_simple_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginSimpleObject Class Reference",
"href":"cpp_ref/class_m_s_plugin_simple_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginSpecialFX< TYPE > Class Template Reference",
"href":"cpp_ref/class_m_s_plugin_special_f_x.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginTexmap Class Reference",
"href":"cpp_ref/class_m_s_plugin_texmap.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginTrackViewUtility Class Reference",
"href":"cpp_ref/class_m_s_plugin_track_view_utility.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSPluginValueMigrator Class Reference",
"href":"cpp_ref/class_m_s_plugin_value_migrator.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSRightClickMenu Class Reference",
"href":"cpp_ref/class_m_s_right_click_menu.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSSelectFilterCallback Class Reference",
"href":"cpp_ref/class_m_s_select_filter_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSShapeXtnd Class Reference",
"href":"cpp_ref/class_m_s_shape_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSSimpleManipulatorXtnd Class Reference",
"href":"cpp_ref/class_m_s_simple_manipulator_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSSimpleModXtnd Class Reference",
"href":"cpp_ref/class_m_s_simple_mod_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSSimpleObjectXtnd Class Reference",
"href":"cpp_ref/class_m_s_simple_object_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSSpecialFXXtnd< TYPE, MS_SUPER > Class Template Reference",
"href":"cpp_ref/class_m_s_special_f_x_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSTexmapXtnd Class Reference",
"href":"cpp_ref/class_m_s_texmap_xtnd.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSZipPackage Class Reference",
"href":"cpp_ref/class_m_s_zip_package.html",
"description":"",
"ancestors":[]},
{"title":"C++: MSZipPackageFileDropType Class Reference",
"href":"cpp_ref/class_m_s_zip_package_file_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: MXSEditor_Interface Class Reference",
"href":"cpp_ref/class_m_x_s_editor___interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: MXSEditor_Interface2 Class Reference",
"href":"cpp_ref/class_m_x_s_editor___interface2.html",
"description":"",
"ancestors":[]},
{"title":"C++: MXS_Editor_Interface Class Reference",
"href":"cpp_ref/class_m_x_s___editor___interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: MZPExtraction Class Reference",
"href":"cpp_ref/class_m_z_p_extraction.html",
"description":"",
"ancestors":[]},
{"title":"C++: NamedPolySelSetList Class Reference",
"href":"cpp_ref/class_named_poly_sel_set_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: NamedSegSelSetList Class Reference",
"href":"cpp_ref/class_named_seg_sel_set_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: NamedVertSelSetList Class Reference",
"href":"cpp_ref/class_named_vert_sel_set_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: NameAccum Class Reference",
"href":"cpp_ref/class_name_accum.html",
"description":"",
"ancestors":[]},
{"title":"C++: NameMaker Class Reference",
"href":"cpp_ref/class_name_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: NameTab Class Reference",
"href":"cpp_ref/class_name_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: NaturalLightClassBaseImp Class Reference",
"href":"cpp_ref/class_natural_light_class_base_imp.html",
"description":"",
"ancestors":[]},
{"title":"C++: NodeAndAnims Class Reference",
"href":"cpp_ref/class_node_and_anims.html",
"description":"",
"ancestors":[]},
{"title":"C++: NodeDisplayCallback Class Reference",
"href":"cpp_ref/class_node_display_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: NodeDisplayCallbackEx Class Reference",
"href":"cpp_ref/class_node_display_callback_ex.html",
"description":"",
"ancestors":[]},
{"title":"C++: NodeIterator Class Reference",
"href":"cpp_ref/class_node_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: NodeTab Class Reference",
"href":"cpp_ref/class_node_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: NoteAnimProperty Class Reference",
"href":"cpp_ref/class_note_anim_property.html",
"description":"",
"ancestors":[]},
{"title":"C++: NoteKey Class Reference",
"href":"cpp_ref/class_note_key.html",
"description":"",
"ancestors":[]},
{"title":"C++: NoteKeyClipObject Class Reference",
"href":"cpp_ref/class_note_key_clip_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: NoteKeyTab Class Reference",
"href":"cpp_ref/class_note_key_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: NoteTrack Class Reference",
"href":"cpp_ref/class_note_track.html",
"description":"",
"ancestors":[]},
{"title":"C++: NotifyCollapseEnumProc Class Reference",
"href":"cpp_ref/class_notify_collapse_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: NotifyCollapseMaintainCustAttribEnumProc Class Reference",
"href":"cpp_ref/class_notify_collapse_maintain_cust_attrib_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: NotifyCollapseMaintainCustAttribEnumProc2 Class Reference",
"href":"cpp_ref/class_notify_collapse_maintain_cust_attrib_enum_proc2.html",
"description":"",
"ancestors":[]},
{"title":"C++: NoMethodError Class Reference",
"href":"cpp_ref/class_no_method_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: NumList Class Reference",
"href":"cpp_ref/class_num_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBS1RailSweepSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s1_rail_sweep_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBS2RailSweepSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s2_rail_sweep_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSBlendCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_blend_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSBlendSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_blend_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSCapSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_cap_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSChamferCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_chamfer_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSControlVertex Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_control_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSCurveConstPoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_curve_const_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSCurveCurveIntersectionPoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_curve_curve_intersection_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSCurveOnSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_curve_on_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSCurveSurfaceIntersectionPoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_curve_surface_intersection_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSCVCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_c_v_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSCVSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_c_v_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSDisplay Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_display.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSExtrudeSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_extrude_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSFilletCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_fillet_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSFilletSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_fillet_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSFuseCurveCV Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_fuse_curve_c_v.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSFuseSurfaceCV Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_fuse_surface_c_v.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSIndependentPoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_independent_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSIsoCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_iso_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSLatheSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_lathe_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSMirrorCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_mirror_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSMirrorSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_mirror_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSMultiCurveTrimSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_multi_curve_trim_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSNBlendSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_n_blend_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSObject Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSOffsetCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_offset_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSOffsetSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_offset_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSPoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSPointConstPoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_point_const_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSPointCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_point_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSPointCurveOnSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_point_curve_on_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSPointSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_point_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSProceeduralCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_proceedural_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSProceeduralSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_proceedural_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSProjectNormalCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_project_normal_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSProjectVectorCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_project_vector_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSRuledSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_ruled_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSSet Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSSurfaceEdgeCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_surface_edge_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSSurfaceNormalCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_surface_normal_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSSurfConstPoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_surf_const_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSSurfSurfIntersectionCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_surf_surf_intersection_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSTextureChannel Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_texture_channel.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSTextureChannelSet Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_texture_channel_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSTexturePoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_texture_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSTextureSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_texture_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSTrimPoint Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_trim_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSULoftSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_u_loft_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSUVLoftSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_u_v_loft_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSXFormCurve Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_x_form_curve.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSXFormSurface Class Reference",
"href":"cpp_ref/class_n_u_r_b_s_x_form_surface.html",
"description":"",
"ancestors":[]},
{"title":"C++: NUScaleCtrlApparatusCMode Class Reference",
"href":"cpp_ref/class_n_u_scale_ctrl_apparatus_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: NUScaleModBoxCMode Class Reference",
"href":"cpp_ref/class_n_u_scale_mod_box_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: Object Class Reference",
"href":"cpp_ref/class_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: ObjectConverter Class Reference",
"href":"cpp_ref/class_object_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: ObjectDataReaderCallback Class Reference",
"href":"cpp_ref/class_object_data_reader_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Object",
"href":"cpp_ref/class_object_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: ObjectState Class Reference",
"href":"cpp_ref/class_object_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: ObjectWrapper Class Reference",
"href":"cpp_ref/class_object_wrapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: ObjLightDesc Class Reference",
"href":"cpp_ref/class_obj_light_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: OneClickCreateCallBack Class Reference",
"href":"cpp_ref/class_one_click_create_call_back.html",
"description":"",
"ancestors":[]},
{"title":"C++: OpenBezFont Class Reference",
"href":"cpp_ref/class_open_bez_font.html",
"description":"",
"ancestors":[]},
{"title":"C++: OrbazTrueBlock Class Reference",
"href":"cpp_ref/class_orbaz_true_block.html",
"description":"",
"ancestors":[]},
{"title":"C++: OrbazTrueBlockEnumerator Class Reference",
"href":"cpp_ref/class_orbaz_true_block_enumerator.html",
"description":"",
"ancestors":[]},
{"title":"C++: OrbazTrueBlockIterator Class Reference",
"href":"cpp_ref/class_orbaz_true_block_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: OrbazTrueEnumerator Class Reference",
"href":"cpp_ref/class_orbaz_true_enumerator.html",
"description":"",
"ancestors":[]},
{"title":"C++: Osnap Class Reference",
"href":"cpp_ref/class_osnap.html",
"description":"",
"ancestors":[]},
{"title":"C++: OsnapHit Class Reference",
"href":"cpp_ref/class_osnap_hit.html",
"description":"",
"ancestors":[]},
{"title":"C++: OsnapMarker Class Reference",
"href":"cpp_ref/class_osnap_marker.html",
"description":"",
"ancestors":[]},
{"title":"C++: OwnerThunk Class Reference",
"href":"cpp_ref/class_owner_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: OSnapDecorator Class Reference",
"href":"cpp_ref/class_o_snap_decorator.html",
"description":"",
"ancestors":[]},
{"title":"C++: OSModifier Class Reference",
"href":"cpp_ref/class_o_s_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamBlock2PLCB Class Reference",
"href":"cpp_ref/class_param_block2_p_l_c_b.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamBlockDesc Class Reference",
"href":"cpp_ref/class_param_block_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamBlockDesc2 Class Reference",
"href":"cpp_ref/class_param_block_desc2.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamBlockDescID Class Reference",
"href":"cpp_ref/class_param_block_desc_i_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamBlockPLCB Class Reference",
"href":"cpp_ref/class_param_block_p_l_c_b.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamBlockPLCBEx Class Reference",
"href":"cpp_ref/class_param_block_p_l_c_b_ex.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamDimension Class Reference",
"href":"cpp_ref/class_param_dimension.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamDimensionBase Class Reference",
"href":"cpp_ref/class_param_dimension_base.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamDlg Class Reference",
"href":"cpp_ref/class_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamMap2UserDlgProc Class Reference",
"href":"cpp_ref/class_param_map2_user_dlg_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamMapUserDlgProc Class Reference",
"href":"cpp_ref/class_param_map_user_dlg_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamRef Class Reference",
"href":"cpp_ref/class_param_ref.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamUIDesc Class Reference",
"href":"cpp_ref/class_param_u_i_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamVersionDesc Class Reference",
"href":"cpp_ref/class_param_version_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: Parser Class Reference",
"href":"cpp_ref/class_parser.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleChannelMask Class Reference",
"href":"cpp_ref/class_particle_channel_mask.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleData Class Reference",
"href":"cpp_ref/class_particle_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleMatData Class Reference",
"href":"cpp_ref/class_particle_mat_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleObject Class Reference",
"href":"cpp_ref/class_particle_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticlePtrTab Class Reference",
"href":"cpp_ref/class_particle_ptr_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleSys Class Reference",
"href":"cpp_ref/class_particle_sys.html",
"description":"",
"ancestors":[]},
{"title":"C++: PartwithMtl Class Reference",
"href":"cpp_ref/class_partwith_mtl.html",
"description":"",
"ancestors":[]},
{"title":"C++: PartwithTex Class Reference",
"href":"cpp_ref/class_partwith_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: Patch Class Reference",
"href":"cpp_ref/class_patch.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchCapper Class Reference",
"href":"cpp_ref/class_patch_capper.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchCapInfo Class Reference",
"href":"cpp_ref/class_patch_cap_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchCapPoly Class Reference",
"href":"cpp_ref/class_patch_cap_poly.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchCapVec Class Reference",
"href":"cpp_ref/class_patch_cap_vec.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchCapVert Class Reference",
"href":"cpp_ref/class_patch_cap_vert.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchCapWork Class Reference",
"href":"cpp_ref/class_patch_cap_work.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchEdge Class Reference",
"href":"cpp_ref/class_patch_edge.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchHitData Class Reference",
"href":"cpp_ref/class_patch_hit_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchMesh Class Reference",
"href":"cpp_ref/class_patch_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class PatchMesh",
"href":"cpp_ref/class_patch_mesh_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchNamedSelClip Class Reference",
"href":"cpp_ref/class_patch_named_sel_clip.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchObject Class Reference",
"href":"cpp_ref/class_patch_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchObjectRestore Class Reference",
"href":"cpp_ref/class_patch_object_restore.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchSeg Class Reference",
"href":"cpp_ref/class_patch_seg.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchSubHitRec Class Reference",
"href":"cpp_ref/class_patch_sub_hit_rec.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchTVert Class Reference",
"href":"cpp_ref/class_patch_t_vert.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchVec Class Reference",
"href":"cpp_ref/class_patch_vec.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchVert Class Reference",
"href":"cpp_ref/class_patch_vert.html",
"description":"",
"ancestors":[]},
{"title":"C++: PathConfigDropType Class Reference",
"href":"cpp_ref/class_path_config_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: PerData Class Reference",
"href":"cpp_ref/class_per_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: PickerControlFilter Class Reference",
"href":"cpp_ref/class_picker_control_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: PickerControlMode Class Reference",
"href":"cpp_ref/class_picker_control_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: PickClassCallback Class Reference",
"href":"cpp_ref/class_pick_class_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: PickCommandMode Class Reference",
"href":"cpp_ref/class_pick_command_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: PickModeCallback Class Reference",
"href":"cpp_ref/class_pick_mode_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: PickNodeCallback Class Reference",
"href":"cpp_ref/class_pick_node_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: PickObjectProc Class Reference",
"href":"cpp_ref/class_pick_object_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: Pipe Class Reference",
"href":"cpp_ref/class_pipe.html",
"description":"",
"ancestors":[]},
{"title":"C++: PixelBufT< T > Class Template Reference",
"href":"cpp_ref/class_pixel_buf_t.html",
"description":"",
"ancestors":[]},
{"title":"C++: Plane Class Reference",
"href":"cpp_ref/class_plane.html",
"description":"",
"ancestors":[]},
{"title":"C++: PluginClassDefPLCB1 Class Reference",
"href":"cpp_ref/class_plugin_class_def_p_l_c_b1.html",
"description":"",
"ancestors":[]},
{"title":"C++: PluginClassDefPLCB2 Class Reference",
"href":"cpp_ref/class_plugin_class_def_p_l_c_b2.html",
"description":"",
"ancestors":[]},
{"title":"C++: PluginLocalThunk Class Reference",
"href":"cpp_ref/class_plugin_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: PluginMethod Class Reference",
"href":"cpp_ref/class_plugin_method.html",
"description":"",
"ancestors":[]},
{"title":"C++: PluginParamThunk Class Reference",
"href":"cpp_ref/class_plugin_param_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: PodObj Class Reference",
"href":"cpp_ref/class_pod_obj.html",
"description":"",
"ancestors":[]},
{"title":"C++: Point2 Class Reference",
"href":"cpp_ref/class_point2.html",
"description":"",
"ancestors":[]},
{"title":"C++: Point3 Class Reference",
"href":"cpp_ref/class_point3.html",
"description":"",
"ancestors":[]},
{"title":"C++: Point4 Class Reference",
"href":"cpp_ref/class_point4.html",
"description":"",
"ancestors":[]},
{"title":"C++: PolyLine Class Reference",
"href":"cpp_ref/class_poly_line.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class PolyLine",
"href":"cpp_ref/class_poly_line_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: PolyLineProc Class Reference",
"href":"cpp_ref/class_poly_line_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: PolyObject Class Reference",
"href":"cpp_ref/class_poly_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: PolyPt Class Reference",
"href":"cpp_ref/class_poly_pt.html",
"description":"",
"ancestors":[]},
{"title":"C++: PolyShape Class Reference",
"href":"cpp_ref/class_poly_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class PolyShape",
"href":"cpp_ref/class_poly_shape_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: PostLoadCallback Class Reference",
"href":"cpp_ref/class_post_load_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: PostPatchProc Class Reference",
"href":"cpp_ref/class_post_patch_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: PreciseTimeValue Class Reference",
"href":"cpp_ref/class_precise_time_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: PreviewParams Class Reference",
"href":"cpp_ref/class_preview_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: PrintManager Class Reference",
"href":"cpp_ref/class_print_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: PropertyEnum Class Reference",
"href":"cpp_ref/class_property_enum.html",
"description":"",
"ancestors":[]},
{"title":"C++: PropertyThunk Class Reference",
"href":"cpp_ref/class_property_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: PtrVec< T > Class Template Reference",
"href":"cpp_ref/class_ptr_vec.html",
"description":"",
"ancestors":[]},
{"title":"C++: PtrVector Class Reference",
"href":"cpp_ref/class_ptr_vector.html",
"description":"",
"ancestors":[]},
{"title":"C++: PB2Param Class Reference",
"href":"cpp_ref/class_p_b2_param.html",
"description":"",
"ancestors":[]},
{"title":"C++: PBAccessor Class Reference",
"href":"cpp_ref/class_p_b_accessor.html",
"description":"",
"ancestors":[]},
{"title":"C++: PBBitmap Class Reference",
"href":"cpp_ref/class_p_b_bitmap.html",
"description":"",
"ancestors":[]},
{"title":"C++: PBValidator Class Reference",
"href":"cpp_ref/class_p_b_validator.html",
"description":"",
"ancestors":[]},
{"title":"C++: CreatedChannelLinker Class Reference",
"href":"cpp_ref/class_p_f_1_1_created_channel_linker.html",
"description":"",
"ancestors":[]},
{"title":"C++: PFActionStateDesc Class Reference",
"href":"cpp_ref/class_p_f_action_state_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: PFHitData Class Reference",
"href":"cpp_ref/class_p_f_hit_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: PFSimpleAction Class Reference",
"href":"cpp_ref/class_p_f_simple_action.html",
"description":"",
"ancestors":[]},
{"title":"C++: PFSimpleActionState Class Reference",
"href":"cpp_ref/class_p_f_simple_action_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: PFSimpleOperator Class Reference",
"href":"cpp_ref/class_p_f_simple_operator.html",
"description":"",
"ancestors":[]},
{"title":"C++: PFSimpleTest Class Reference",
"href":"cpp_ref/class_p_f_simple_test.html",
"description":"",
"ancestors":[]},
{"title":"C++: POModRecord Class Reference",
"href":"cpp_ref/class_p_o_mod_record.html",
"description":"",
"ancestors":[]},
{"title":"C++: POPickPatchAttach Class Reference",
"href":"cpp_ref/class_p_o_pick_patch_attach.html",
"description":"",
"ancestors":[]},
{"title":"C++: PRVertex Class Reference",
"href":"cpp_ref/class_p_r_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: PStamp Class Reference",
"href":"cpp_ref/class_p_stamp.html",
"description":"",
"ancestors":[]},
{"title":"C++: Quantizer Class Reference",
"href":"cpp_ref/class_quantizer.html",
"description":"",
"ancestors":[]},
{"title":"C++: Quat Class Reference",
"href":"cpp_ref/class_quat.html",
"description":"",
"ancestors":[]},
{"title":"C++: RadiosityEffect Class Reference",
"href":"cpp_ref/class_radiosity_effect.html",
"description":"",
"ancestors":[]},
{"title":"C++: RadiosityInterface Class Reference",
"href":"cpp_ref/class_radiosity_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: RadiosityMesh Class Reference",
"href":"cpp_ref/class_radiosity_mesh.html",
"description":"",
"ancestors":[]},
{"title":"C++: Random Class Reference",
"href":"cpp_ref/class_random.html",
"description":"",
"ancestors":[]},
{"title":"C++: RandGenerator Class Reference",
"href":"cpp_ref/class_rand_generator.html",
"description":"",
"ancestors":[]},
{"title":"C++: RandObjLinker Class Reference",
"href":"cpp_ref/class_rand_obj_linker.html",
"description":"",
"ancestors":[]},
{"title":"C++: Ray Class Reference",
"href":"cpp_ref/class_ray.html",
"description":"",
"ancestors":[]},
{"title":"C++: RealWorldMapSizeInterface Class Reference",
"href":"cpp_ref/class_real_world_map_size_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: RealWorldScaleRecord< T > Class Template Reference",
"href":"cpp_ref/class_real_world_scale_record.html",
"description":"",
"ancestors":[]},
{"title":"C++: RedrawViewsCallback Class Reference",
"href":"cpp_ref/class_redraw_views_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ReferenceMaker Class Reference",
"href":"cpp_ref/class_reference_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: ReferenceSaveManager Class Reference",
"href":"cpp_ref/class_reference_save_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: ReferenceSaveManager::PostSave Class Reference",
"href":"cpp_ref/class_reference_save_manager_1_1_post_save.html",
"description":"",
"ancestors":[]},
{"title":"C++: ReferenceSaveManager::PreSave Class Reference",
"href":"cpp_ref/class_reference_save_manager_1_1_pre_save.html",
"description":"",
"ancestors":[]},
{"title":"C++: ReferenceTarget Class Reference",
"href":"cpp_ref/class_reference_target.html",
"description":"",
"ancestors":[]},
{"title":"C++: RefEnumProc Class Reference",
"href":"cpp_ref/class_ref_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: RefMgr< T > Class Template Reference",
"href":"cpp_ref/class_ref_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: RefMgrAddDeleteRestore< T > Class Template Reference",
"href":"cpp_ref/class_ref_mgr_add_delete_restore.html",
"description":"",
"ancestors":[]},
{"title":"C++: RefTarget Class Reference",
"href":"cpp_ref/class_ref_target.html",
"description":"",
"ancestors":[]},
{"title":"C++: RefTargMonitorRefMaker Class Reference",
"href":"cpp_ref/class_ref_targ_monitor_ref_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: RemapDir Class Reference",
"href":"cpp_ref/class_remap_dir.html",
"description":"",
"ancestors":[]},
{"title":"C++: Renderer Class Reference",
"href":"cpp_ref/class_renderer.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderData Class Reference",
"href":"cpp_ref/class_render_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderGlobalContext Class Reference",
"href":"cpp_ref/class_render_global_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderInfo Class Reference",
"href":"cpp_ref/class_render_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderInstance Class Reference",
"href":"cpp_ref/class_render_instance.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderMapsContext Class Reference",
"href":"cpp_ref/class_render_maps_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: RenderPresetsContext Class Reference",
"href":"cpp_ref/class_render_presets_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: RendContext Class Reference",
"href":"cpp_ref/class_rend_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: RendParams Class Reference",
"href":"cpp_ref/class_rend_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: RendParamDlg Class Reference",
"href":"cpp_ref/class_rend_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: RendPickProc Class Reference",
"href":"cpp_ref/class_rend_pick_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: RendProgressCallback Class Reference",
"href":"cpp_ref/class_rend_progress_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ResourceMakerCallback Class Reference",
"href":"cpp_ref/class_resource_maker_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: RestoreObj Class Reference",
"href":"cpp_ref/class_restore_obj.html",
"description":"",
"ancestors":[]},
{"title":"C++: RightClickMenu Class Reference",
"href":"cpp_ref/class_right_click_menu.html",
"description":"",
"ancestors":[]},
{"title":"C++: RightClickMenuManager Class Reference",
"href":"cpp_ref/class_right_click_menu_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: RolloutChangeCallback Class Reference",
"href":"cpp_ref/class_rollout_change_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: RolloutControlThunk Class Reference",
"href":"cpp_ref/class_rollout_control_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: RolloutLocalThunk Class Reference",
"href":"cpp_ref/class_rollout_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: RotateCtrlApparatus Class Reference",
"href":"cpp_ref/class_rotate_ctrl_apparatus.html",
"description":"",
"ancestors":[]},
{"title":"C++: RotateCtrlApparatusCMode Class Reference",
"href":"cpp_ref/class_rotate_ctrl_apparatus_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: RotateModBox Class Reference",
"href":"cpp_ref/class_rotate_mod_box.html",
"description":"",
"ancestors":[]},
{"title":"C++: RotateModBoxCMode Class Reference",
"href":"cpp_ref/class_rotate_mod_box_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: RotateTransformer Class Reference",
"href":"cpp_ref/class_rotate_transformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: RotationValue Class Reference",
"href":"cpp_ref/class_rotation_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: RuntimeError Class Reference",
"href":"cpp_ref/class_runtime_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: RCMenuItemThunk Class Reference",
"href":"cpp_ref/class_r_c_menu_item_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: RCMenuLocalThunk Class Reference",
"href":"cpp_ref/class_r_c_menu_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: RCMData Class Reference",
"href":"cpp_ref/class_r_c_m_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: RNormal Class Reference",
"href":"cpp_ref/class_r_normal.html",
"description":"",
"ancestors":[]},
{"title":"C++: RVertex Class Reference",
"href":"cpp_ref/class_r_vertex.html",
"description":"",
"ancestors":[]},
{"title":"C++: Sampler Class Reference",
"href":"cpp_ref/class_sampler.html",
"description":"",
"ancestors":[]},
{"title":"C++: SamplingCallback Class Reference",
"href":"cpp_ref/class_sampling_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: SaveEnumProc Class Reference",
"href":"cpp_ref/class_save_enum_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: ScaleCtrlApparatus Class Reference",
"href":"cpp_ref/class_scale_ctrl_apparatus.html",
"description":"",
"ancestors":[]},
{"title":"C++: ScaleModBox Class Reference",
"href":"cpp_ref/class_scale_mod_box.html",
"description":"",
"ancestors":[]},
{"title":"C++: ScaleTransformer Class Reference",
"href":"cpp_ref/class_scale_transformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: ScaleValue Class Reference",
"href":"cpp_ref/class_scale_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: SceneExport Class Reference",
"href":"cpp_ref/class_scene_export.html",
"description":"",
"ancestors":[]},
{"title":"C++: SceneFileDropType Class Reference",
"href":"cpp_ref/class_scene_file_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: SceneImport Class Reference",
"href":"cpp_ref/class_scene_import.html",
"description":"",
"ancestors":[]},
{"title":"C++: SceneNodeByNameCache Class Reference",
"href":"cpp_ref/class_scene_node_by_name_cache.html",
"description":"",
"ancestors":[]},
{"title":"C++: SchematicViewProperty Class Reference",
"href":"cpp_ref/class_schematic_view_property.html",
"description":"",
"ancestors":[]},
{"title":"C++: Script Class Reference",
"href":"cpp_ref/class_script.html",
"description":"",
"ancestors":[]},
{"title":"C++: ScriptEditor Class Reference",
"href":"cpp_ref/class_script_editor.html",
"description":"",
"ancestors":[]},
{"title":"C++: ScriptFileDropType Class Reference",
"href":"cpp_ref/class_script_file_drop_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: ScriptItem Class Reference",
"href":"cpp_ref/class_script_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: SelectionIterator Class Reference",
"href":"cpp_ref/class_selection_iterator.html",
"description":"",
"ancestors":[]},
{"title":"C++: SelectionProcessor Class Reference",
"href":"cpp_ref/class_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: SelectCtrlApparatus Class Reference",
"href":"cpp_ref/class_select_ctrl_apparatus.html",
"description":"",
"ancestors":[]},
{"title":"C++: SelectCtrlApparatusCMode Class Reference",
"href":"cpp_ref/class_select_ctrl_apparatus_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SelectFilterCallback Class Reference",
"href":"cpp_ref/class_select_filter_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: SelectModBox Class Reference",
"href":"cpp_ref/class_select_mod_box.html",
"description":"",
"ancestors":[]},
{"title":"C++: SelectModBoxCMode Class Reference",
"href":"cpp_ref/class_select_mod_box_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SetKeyModeCallback Class Reference",
"href":"cpp_ref/class_set_key_mode_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: SetKeyModeInterface Class Reference",
"href":"cpp_ref/class_set_key_mode_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: SetMorphTargetPacket Class Reference",
"href":"cpp_ref/class_set_morph_target_packet.html",
"description":"",
"ancestors":[]},
{"title":"C++: SetXFormPacket Class Reference",
"href":"cpp_ref/class_set_x_form_packet.html",
"description":"",
"ancestors":[]},
{"title":"C++: Shader Class Reference",
"href":"cpp_ref/class_shader.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShaderParamDlg Class Reference",
"href":"cpp_ref/class_shader_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShadeContext Class Reference",
"href":"cpp_ref/class_shade_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShadeOutput Class Reference",
"href":"cpp_ref/class_shade_output.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShadowGenerator Class Reference",
"href":"cpp_ref/class_shadow_generator.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShadowParamDlg Class Reference",
"href":"cpp_ref/class_shadow_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShadowType Class Reference",
"href":"cpp_ref/class_shadow_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShadBufRenderer Class Reference",
"href":"cpp_ref/class_shad_buf_renderer.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeContextCallback Class Reference",
"href":"cpp_ref/class_shape_context_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeHierarchy Class Reference",
"href":"cpp_ref/class_shape_hierarchy.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeHitData Class Reference",
"href":"cpp_ref/class_shape_hit_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeNamedPolySelClip Class Reference",
"href":"cpp_ref/class_shape_named_poly_sel_clip.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeNamedSegSelClip Class Reference",
"href":"cpp_ref/class_shape_named_seg_sel_clip.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeNamedVertSelClip Class Reference",
"href":"cpp_ref/class_shape_named_vert_sel_clip.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeObject Class Reference",
"href":"cpp_ref/class_shape_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapePSel Class Reference",
"href":"cpp_ref/class_shape_p_sel.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeSubHitRec Class Reference",
"href":"cpp_ref/class_shape_sub_hit_rec.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeSSel Class Reference",
"href":"cpp_ref/class_shape_s_sel.html",
"description":"",
"ancestors":[]},
{"title":"C++: ShapeVSel Class Reference",
"href":"cpp_ref/class_shape_v_sel.html",
"description":"",
"ancestors":[]},
{"title":"C++: SignalException Class Reference",
"href":"cpp_ref/class_signal_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleData Class Reference",
"href":"cpp_ref/class_simple_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleDataMat Class Reference",
"href":"cpp_ref/class_simple_data_mat.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleDataMatTex Class Reference",
"href":"cpp_ref/class_simple_data_mat_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleDataTex Class Reference",
"href":"cpp_ref/class_simple_data_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleManipulator Class Reference",
"href":"cpp_ref/class_simple_manipulator.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleManipHitData Class Reference",
"href":"cpp_ref/class_simple_manip_hit_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleMod Class Reference",
"href":"cpp_ref/class_simple_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleMod2 Class Reference",
"href":"cpp_ref/class_simple_mod2.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleObject Class Reference",
"href":"cpp_ref/class_simple_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleObject2 Class Reference",
"href":"cpp_ref/class_simple_object2.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleOSMToWSMMod Class Reference",
"href":"cpp_ref/class_simple_o_s_m_to_w_s_m_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleOSMToWSMMod2 Class Reference",
"href":"cpp_ref/class_simple_o_s_m_to_w_s_m_mod2.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleOSMToWSMObject Class Reference",
"href":"cpp_ref/class_simple_o_s_m_to_w_s_m_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleParticle Class Reference",
"href":"cpp_ref/class_simple_particle.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleShape Class Reference",
"href":"cpp_ref/class_simple_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleSpline Class Reference",
"href":"cpp_ref/class_simple_spline.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleSplineDlgProc Class Reference",
"href":"cpp_ref/class_simple_spline_dlg_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleWSMMod Class Reference",
"href":"cpp_ref/class_simple_w_s_m_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleWSMMod2 Class Reference",
"href":"cpp_ref/class_simple_w_s_m_mod2.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleWSMObject Class Reference",
"href":"cpp_ref/class_simple_w_s_m_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleWSMObject2 Class Reference",
"href":"cpp_ref/class_simple_w_s_m_object2.html",
"description":"",
"ancestors":[]},
{"title":"C++: SingleRefMaker Class Reference",
"href":"cpp_ref/class_single_ref_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: SingleRefMakerPatchMtl Class Reference",
"href":"cpp_ref/class_single_ref_maker_patch_mtl.html",
"description":"",
"ancestors":[]},
{"title":"C++: SingleRefMakerPatchNode Class Reference",
"href":"cpp_ref/class_single_ref_maker_patch_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: SingleRefMakerSplineMtl Class Reference",
"href":"cpp_ref/class_single_ref_maker_spline_mtl.html",
"description":"",
"ancestors":[]},
{"title":"C++: SingleRefMakerSplineNode Class Reference",
"href":"cpp_ref/class_single_ref_maker_spline_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: SkyLightEval Class Reference",
"href":"cpp_ref/class_sky_light_eval.html",
"description":"",
"ancestors":[]},
{"title":"C++: Snippet Class Reference",
"href":"cpp_ref/class_snippet.html",
"description":"",
"ancestors":[]},
{"title":"C++: SoundObj Class Reference",
"href":"cpp_ref/class_sound_obj.html",
"description":"",
"ancestors":[]},
{"title":"C++: SourceFileWrapper Class Reference",
"href":"cpp_ref/class_source_file_wrapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: SourcePositionWrapper Class Reference",
"href":"cpp_ref/class_source_position_wrapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: SpaceArrayCallback Class Reference",
"href":"cpp_ref/class_space_array_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: SpecialFX Class Reference",
"href":"cpp_ref/class_special_f_x.html",
"description":"",
"ancestors":[]},
{"title":"C++: SphereGizmoObject Class Reference",
"href":"cpp_ref/class_sphere_gizmo_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: Spline3D Class Reference",
"href":"cpp_ref/class_spline3_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Spline3D",
"href":"cpp_ref/class_spline3_d_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: SplineKnot Class Reference",
"href":"cpp_ref/class_spline_knot.html",
"description":"",
"ancestors":[]},
{"title":"C++: SplineKnotAssy Class Reference",
"href":"cpp_ref/class_spline_knot_assy.html",
"description":"",
"ancestors":[]},
{"title":"C++: SplinePoint Class Reference",
"href":"cpp_ref/class_spline_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: SplineShape Class Reference",
"href":"cpp_ref/class_spline_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: SplineShapePointTab Class Reference",
"href":"cpp_ref/class_spline_shape_point_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: SplineShapeVertexDelta Class Reference",
"href":"cpp_ref/class_spline_shape_vertex_delta.html",
"description":"",
"ancestors":[]},
{"title":"C++: SpringClass Class Reference",
"href":"cpp_ref/class_spring_class.html",
"description":"",
"ancestors":[]},
{"title":"C++: SpringSys Class Reference",
"href":"cpp_ref/class_spring_sys.html",
"description":"",
"ancestors":[]},
{"title":"C++: SpringSysClient Class Reference",
"href":"cpp_ref/class_spring_sys_client.html",
"description":"",
"ancestors":[]},
{"title":"C++: SquashCtrlApparatusCMode Class Reference",
"href":"cpp_ref/class_squash_ctrl_apparatus_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SquashModBoxCMode Class Reference",
"href":"cpp_ref/class_squash_mod_box_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: Stack< T > Class Template Reference",
"href":"cpp_ref/class_stack.html",
"description":"",
"ancestors":[]},
{"title":"C++: StandardData Class Reference",
"href":"cpp_ref/class_standard_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: StandardDataMat Class Reference",
"href":"cpp_ref/class_standard_data_mat.html",
"description":"",
"ancestors":[]},
{"title":"C++: StandardDataMatTex Class Reference",
"href":"cpp_ref/class_standard_data_mat_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: StandardDataTex Class Reference",
"href":"cpp_ref/class_standard_data_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: StaticInterfaceMethod Class Reference",
"href":"cpp_ref/class_static_interface_method.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdControl Class Reference",
"href":"cpp_ref/class_std_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdCubic Class Reference",
"href":"cpp_ref/class_std_cubic.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdFog Class Reference",
"href":"cpp_ref/class_std_fog.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdIKClipObject Class Reference",
"href":"cpp_ref/class_std_i_k_clip_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdMat Class Reference",
"href":"cpp_ref/class_std_mat.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdMat2 Class Reference",
"href":"cpp_ref/class_std_mat2.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class StdMat",
"href":"cpp_ref/class_std_mat_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdMirror Class Reference",
"href":"cpp_ref/class_std_mirror.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdTexoutGen Class Reference",
"href":"cpp_ref/class_std_texout_gen.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdUVGen Class Reference",
"href":"cpp_ref/class_std_u_v_gen.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class StdUVGen",
"href":"cpp_ref/class_std_u_v_gen_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: StdXYZGen Class Reference",
"href":"cpp_ref/class_std_x_y_z_gen.html",
"description":"",
"ancestors":[]},
{"title":"C++: Strip Class Reference",
"href":"cpp_ref/class_strip.html",
"description":"",
"ancestors":[]},
{"title":"C++: StripData Class Reference",
"href":"cpp_ref/class_strip_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: Struct Class Reference",
"href":"cpp_ref/class_struct.html",
"description":"",
"ancestors":[]},
{"title":"C++: StructMemberThunk Class Reference",
"href":"cpp_ref/class_struct_member_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: StructMethod Class Reference",
"href":"cpp_ref/class_struct_method.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubClassList Class Reference",
"href":"cpp_ref/class_sub_class_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubControlSelectionProcessor Class Reference",
"href":"cpp_ref/class_sub_control_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubModSelectionProcessor Class Reference",
"href":"cpp_ref/class_sub_mod_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubObjAxisCallback Class Reference",
"href":"cpp_ref/class_sub_obj_axis_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubObjHitList Class Reference",
"href":"cpp_ref/class_sub_obj_hit_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubPatchHitList Class Reference",
"href":"cpp_ref/class_sub_patch_hit_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubShapeHitList Class Reference",
"href":"cpp_ref/class_sub_shape_hit_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: SuspendAll Class Reference",
"href":"cpp_ref/class_suspend_all.html",
"description":"",
"ancestors":[]},
{"title":"C++: SvGraphNodeReference Class Reference",
"href":"cpp_ref/class_sv_graph_node_reference.html",
"description":"",
"ancestors":[]},
{"title":"C++: SyntaxError Class Reference",
"href":"cpp_ref/class_syntax_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: SystemGlobalThunk Class Reference",
"href":"cpp_ref/class_system_global_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: SClassUIInfo Class Reference",
"href":"cpp_ref/class_s_class_u_i_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: SFXParamDlg Class Reference",
"href":"cpp_ref/class_s_f_x_param_dlg.html",
"description":"",
"ancestors":[]},
{"title":"C++: SMCallContext Class Reference",
"href":"cpp_ref/class_s_m_call_context.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSBindCMode Class Reference",
"href":"cpp_ref/class_s_s_bind_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSBindMouseProc Class Reference",
"href":"cpp_ref/class_s_s_bind_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSBooleanCMode Class Reference",
"href":"cpp_ref/class_s_s_boolean_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSBooleanMouseProc Class Reference",
"href":"cpp_ref/class_s_s_boolean_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSChamferCMode Class Reference",
"href":"cpp_ref/class_s_s_chamfer_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSChamferMouseProc Class Reference",
"href":"cpp_ref/class_s_s_chamfer_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSChamferSelectionProcessor Class Reference",
"href":"cpp_ref/class_s_s_chamfer_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSChamferTransformer Class Reference",
"href":"cpp_ref/class_s_s_chamfer_transformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSConstraintPoint Class Reference",
"href":"cpp_ref/class_s_s_constraint_point.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSCopyTangentCMode Class Reference",
"href":"cpp_ref/class_s_s_copy_tangent_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSCopyTangentMouseProc Class Reference",
"href":"cpp_ref/class_s_s_copy_tangent_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSCreateLineCMode Class Reference",
"href":"cpp_ref/class_s_s_create_line_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSCreateLineMouseProc Class Reference",
"href":"cpp_ref/class_s_s_create_line_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSCrossInsertCMode Class Reference",
"href":"cpp_ref/class_s_s_cross_insert_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSCrossInsertMouseProc Class Reference",
"href":"cpp_ref/class_s_s_cross_insert_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSCrossSectionCMode Class Reference",
"href":"cpp_ref/class_s_s_cross_section_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSCrossSectionMouseProc Class Reference",
"href":"cpp_ref/class_s_s_cross_section_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSExtendCMode Class Reference",
"href":"cpp_ref/class_s_s_extend_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSExtendMouseProc Class Reference",
"href":"cpp_ref/class_s_s_extend_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSFilletCMode Class Reference",
"href":"cpp_ref/class_s_s_fillet_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSFilletMouseProc Class Reference",
"href":"cpp_ref/class_s_s_fillet_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSFilletSelectionProcessor Class Reference",
"href":"cpp_ref/class_s_s_fillet_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSFilletTransformer Class Reference",
"href":"cpp_ref/class_s_s_fillet_transformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSNamedSelSetList Class Reference",
"href":"cpp_ref/class_s_s_named_sel_set_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSOutlineCMode Class Reference",
"href":"cpp_ref/class_s_s_outline_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSOutlineMouseProc Class Reference",
"href":"cpp_ref/class_s_s_outline_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSOutlineSelectionProcessor Class Reference",
"href":"cpp_ref/class_s_s_outline_selection_processor.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSOutlineTransformer Class Reference",
"href":"cpp_ref/class_s_s_outline_transformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSParticle Class Reference",
"href":"cpp_ref/class_s_s_particle.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSParticleCache Class Reference",
"href":"cpp_ref/class_s_s_particle_cache.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSPasteTangentCMode Class Reference",
"href":"cpp_ref/class_s_s_paste_tangent_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSPasteTangentMouseProc Class Reference",
"href":"cpp_ref/class_s_s_paste_tangent_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSPickSplineAttach Class Reference",
"href":"cpp_ref/class_s_s_pick_spline_attach.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSRefineConnectCMode Class Reference",
"href":"cpp_ref/class_s_s_refine_connect_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSRefineConnectMouseProc Class Reference",
"href":"cpp_ref/class_s_s_refine_connect_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSSegBreakCMode Class Reference",
"href":"cpp_ref/class_s_s_seg_break_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSSegBreakMouseProc Class Reference",
"href":"cpp_ref/class_s_s_seg_break_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSSegBreakTransformer Class Reference",
"href":"cpp_ref/class_s_s_seg_break_transformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSSegRefineCMode Class Reference",
"href":"cpp_ref/class_s_s_seg_refine_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSSegRefineMouseProc Class Reference",
"href":"cpp_ref/class_s_s_seg_refine_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSSpring Class Reference",
"href":"cpp_ref/class_s_s_spring.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSTrimCMode Class Reference",
"href":"cpp_ref/class_s_s_trim_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSTrimMouseProc Class Reference",
"href":"cpp_ref/class_s_s_trim_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSVertConnectCMode Class Reference",
"href":"cpp_ref/class_s_s_vert_connect_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSVertConnectMouseProc Class Reference",
"href":"cpp_ref/class_s_s_vert_connect_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSVertInsertCMode Class Reference",
"href":"cpp_ref/class_s_s_vert_insert_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: SSVertInsertMouseProc Class Reference",
"href":"cpp_ref/class_s_s_vert_insert_mouse_proc.html",
"description":"",
"ancestors":[]},
{"title":"C++: Tab< T > Class Template Reference",
"href":"cpp_ref/class_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: TabDialogPointer Class Reference",
"href":"cpp_ref/class_tab_dialog_pointer.html",
"description":"",
"ancestors":[]},
{"title":"C++: TabHd< T > Class Template Reference",
"href":"cpp_ref/class_tab_hd.html",
"description":"",
"ancestors":[]},
{"title":"C++: TabMZPExtraction Class Reference",
"href":"cpp_ref/class_tab_m_z_p_extraction.html",
"description":"",
"ancestors":[]},
{"title":"C++: Template Class Reference",
"href":"cpp_ref/class_template.html",
"description":"",
"ancestors":[]},
{"title":"C++: Template3D Class Reference",
"href":"cpp_ref/class_template3_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: TempBitmapManagerSilentMode Class Reference",
"href":"cpp_ref/class_temp_bitmap_manager_silent_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: TempQuietMode Class Reference",
"href":"cpp_ref/class_temp_quiet_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: TempStore Class Reference",
"href":"cpp_ref/class_temp_store.html",
"description":"",
"ancestors":[]},
{"title":"C++: TessApprox Class Reference",
"href":"cpp_ref/class_tess_approx.html",
"description":"",
"ancestors":[]},
{"title":"C++: Tex3D Class Reference",
"href":"cpp_ref/class_tex3_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: Texmap Class Reference",
"href":"cpp_ref/class_texmap.html",
"description":"",
"ancestors":[]},
{"title":"C++: TexmapContainer Class Reference",
"href":"cpp_ref/class_texmap_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class Texmap",
"href":"cpp_ref/class_texmap_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: TextureInfo Class Reference",
"href":"cpp_ref/class_texture_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: TextureOutput Class Reference",
"href":"cpp_ref/class_texture_output.html",
"description":"",
"ancestors":[]},
{"title":"C++: TexDADMgr Class Reference",
"href":"cpp_ref/class_tex_d_a_d_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: TexHandle Class Reference",
"href":"cpp_ref/class_tex_handle.html",
"description":"",
"ancestors":[]},
{"title":"C++: TexHandleMaker Class Reference",
"href":"cpp_ref/class_tex_handle_maker.html",
"description":"",
"ancestors":[]},
{"title":"C++: TexMatData Class Reference",
"href":"cpp_ref/class_tex_mat_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: ThunkReference Class Reference",
"href":"cpp_ref/class_thunk_reference.html",
"description":"",
"ancestors":[]},
{"title":"C++: TimeChange Class Reference",
"href":"cpp_ref/class_time_change.html",
"description":"",
"ancestors":[]},
{"title":"C++: TimeChangeCallback Class Reference",
"href":"cpp_ref/class_time_change_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: TimeMap Class Reference",
"href":"cpp_ref/class_time_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToneOperator Class Reference",
"href":"cpp_ref/class_tone_operator.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToneOperatorInterface Class Reference",
"href":"cpp_ref/class_tone_operator_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToneOperatorInvertable Class Reference",
"href":"cpp_ref/class_tone_operator_invertable.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolButtonItem Class Reference",
"href":"cpp_ref/class_tool_button_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolItem Class Reference",
"href":"cpp_ref/class_tool_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolLocalThunk Class Reference",
"href":"cpp_ref/class_tool_local_thunk.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolMacroItem Class Reference",
"href":"cpp_ref/class_tool_macro_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolOtherItem Class Reference",
"href":"cpp_ref/class_tool_other_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolSeparatorItem Class Reference",
"href":"cpp_ref/class_tool_separator_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolStatusItem Class Reference",
"href":"cpp_ref/class_tool_status_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolTab Class Reference",
"href":"cpp_ref/class_tool_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: ToolTipExtender Class Reference",
"href":"cpp_ref/class_tool_tip_extender.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackClipObject Class Reference",
"href":"cpp_ref/class_track_clip_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackHitRecord Class Reference",
"href":"cpp_ref/class_track_hit_record.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackSelectionSetMgr Class Reference",
"href":"cpp_ref/class_track_selection_set_mgr.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackViewActionCallback Class Reference",
"href":"cpp_ref/class_track_view_action_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackViewFilter Class Reference",
"href":"cpp_ref/class_track_view_filter.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackViewPick Class Reference",
"href":"cpp_ref/class_track_view_pick.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackViewUtility Class Reference",
"href":"cpp_ref/class_track_view_utility.html",
"description":"",
"ancestors":[]},
{"title":"C++: Transformer Class Reference",
"href":"cpp_ref/class_transformer.html",
"description":"",
"ancestors":[]},
{"title":"C++: TransformCtrlApparatus Class Reference",
"href":"cpp_ref/class_transform_ctrl_apparatus.html",
"description":"",
"ancestors":[]},
{"title":"C++: TransformModBox Class Reference",
"href":"cpp_ref/class_transform_mod_box.html",
"description":"",
"ancestors":[]},
{"title":"C++: Transition Class Reference",
"href":"cpp_ref/class_transition.html",
"description":"",
"ancestors":[]},
{"title":"C++: TranInfo Class Reference",
"href":"cpp_ref/class_tran_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: TriObject Class Reference",
"href":"cpp_ref/class_tri_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: TriObjectNormalXTC Class Reference",
"href":"cpp_ref/class_tri_object_normal_x_t_c.html",
"description":"",
"ancestors":[]},
{"title":"C++: TriStrip Class Reference",
"href":"cpp_ref/class_tri_strip.html",
"description":"",
"ancestors":[]},
{"title":"C++: TypedHit Class Reference",
"href":"cpp_ref/class_typed_hit.html",
"description":"",
"ancestors":[]},
{"title":"C++: TypeError Class Reference",
"href":"cpp_ref/class_type_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: TCBGraphParams Class Reference",
"href":"cpp_ref/class_t_c_b_graph_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: TVFace Class Reference",
"href":"cpp_ref/class_t_v_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: TVNodeNotify Class Reference",
"href":"cpp_ref/class_t_v_node_notify.html",
"description":"",
"ancestors":[]},
{"title":"C++: TVPatch Class Reference",
"href":"cpp_ref/class_t_v_patch.html",
"description":"",
"ancestors":[]},
{"title":"C++: UndoNotify Class Reference",
"href":"cpp_ref/class_undo_notify.html",
"description":"",
"ancestors":[]},
{"title":"C++: UnknownSystemException Class Reference",
"href":"cpp_ref/class_unknown_system_exception.html",
"description":"",
"ancestors":[]},
{"title":"C++: UserGeneric Class Reference",
"href":"cpp_ref/class_user_generic.html",
"description":"",
"ancestors":[]},
{"title":"C++: UserProp Class Reference",
"href":"cpp_ref/class_user_prop.html",
"description":"",
"ancestors":[]},
{"title":"C++: UserThrownError Class Reference",
"href":"cpp_ref/class_user_thrown_error.html",
"description":"",
"ancestors":[]},
{"title":"C++: UserType Class Reference",
"href":"cpp_ref/class_user_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: UtilityObj Class Reference",
"href":"cpp_ref/class_utility_obj.html",
"description":"",
"ancestors":[]},
{"title":"C++: URLTab Class Reference",
"href":"cpp_ref/class_u_r_l_tab.html",
"description":"",
"ancestors":[]},
{"title":"C++: UScaleCtrlApparatusCMode Class Reference",
"href":"cpp_ref/class_u_scale_ctrl_apparatus_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: UScaleModBoxCMode Class Reference",
"href":"cpp_ref/class_u_scale_mod_box_c_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: UTF8Str Class Reference",
"href":"cpp_ref/class_u_t_f8_str.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVGen Class Reference",
"href":"cpp_ref/class_u_v_gen.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVVertSet Class Reference",
"href":"cpp_ref/class_u_v_vert_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVWMapper Class Reference",
"href":"cpp_ref/class_u_v_w_mapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVWMapperDesc Class Reference",
"href":"cpp_ref/class_u_v_w_mapper_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: Value Class Reference",
"href":"cpp_ref/class_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: ValueConverter Class Reference",
"href":"cpp_ref/class_value_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: ValueHolderMember Class Reference",
"href":"cpp_ref/class_value_holder_member.html",
"description":"",
"ancestors":[]},
{"title":"C++: ValueLoader Class Reference",
"href":"cpp_ref/class_value_loader.html",
"description":"",
"ancestors":[]},
{"title":"C++: ValueLoadCallback Class Reference",
"href":"cpp_ref/class_value_load_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ValueLoadPLCB Class Reference",
"href":"cpp_ref/class_value_load_p_l_c_b.html",
"description":"",
"ancestors":[]},
{"title":"C++: ValueMapper Class Reference",
"href":"cpp_ref/class_value_mapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: ValueMetaClass Class Reference",
"href":"cpp_ref/class_value_meta_class.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertexBuffer Class Reference",
"href":"cpp_ref/class_vertex_buffer.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertexNormalsCallback Class Reference",
"href":"cpp_ref/class_vertex_normals_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertexNormalsControl Class Reference",
"href":"cpp_ref/class_vertex_normals_control.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertexShaderCache Class Reference",
"href":"cpp_ref/class_vertex_shader_cache.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertMove Class Reference",
"href":"cpp_ref/class_vert_move.html",
"description":"",
"ancestors":[]},
{"title":"C++: View Class Reference",
"href":"cpp_ref/class_view.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewportDisplayCallback Class Reference",
"href":"cpp_ref/class_viewport_display_callback.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewportTextButton Class Reference",
"href":"cpp_ref/class_viewport_text_button.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewExp Class Reference",
"href":"cpp_ref/class_view_exp.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewExp10 Class Reference",
"href":"cpp_ref/class_view_exp10.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewExp11 Class Reference",
"href":"cpp_ref/class_view_exp11.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewExp13 Class Reference",
"href":"cpp_ref/class_view_exp13.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups for Class ViewExp",
"href":"cpp_ref/class_view_exp_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewFile Class Reference",
"href":"cpp_ref/class_view_file.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewParams Class Reference",
"href":"cpp_ref/class_view_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewWindow Class Reference",
"href":"cpp_ref/class_view_window.html",
"description":"",
"ancestors":[]},
{"title":"C++: VDataDelta Class Reference",
"href":"cpp_ref/class_v_data_delta.html",
"description":"",
"ancestors":[]},
{"title":"C++: VEdge Class Reference",
"href":"cpp_ref/class_v_edge.html",
"description":"",
"ancestors":[]},
{"title":"C++: VIZableClipFmt Class Reference",
"href":"cpp_ref/class_v_i_zable_clip_fmt.html",
"description":"",
"ancestors":[]},
{"title":"C++: WireMeshData Class Reference",
"href":"cpp_ref/class_wire_mesh_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: WithTex Class Reference",
"href":"cpp_ref/class_with_tex.html",
"description":"",
"ancestors":[]},
{"title":"C++: Wrangler Class Reference",
"href":"cpp_ref/class_wrangler.html",
"description":"",
"ancestors":[]},
{"title":"C++: WStr Class Reference",
"href":"cpp_ref/class_w_str.html",
"description":"",
"ancestors":[]},
{"title":"C++: WSModifier Class Reference",
"href":"cpp_ref/class_w_s_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: WSMObject Class Reference",
"href":"cpp_ref/class_w_s_m_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: XFormModes Class Reference",
"href":"cpp_ref/class_x_form_modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: XMLAnimTreeEntry Class Reference",
"href":"cpp_ref/class_x_m_l_anim_tree_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: XMLAnimTreeEntryList Class Reference",
"href":"cpp_ref/class_x_m_l_anim_tree_entry_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: XTCContainer Class Reference",
"href":"cpp_ref/class_x_t_c_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: XTCObject Class Reference",
"href":"cpp_ref/class_x_t_c_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: XYZGen Class Reference",
"href":"cpp_ref/class_x_y_z_gen.html",
"description":"",
"ancestors":[]},
{"title":"C++: client.h File Reference",
"href":"cpp_ref/client_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: cmdmode.h File Reference",
"href":"cpp_ref/cmdmode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/compiler/codetree.h File Reference",
"href":"cpp_ref/codetree_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/kernel/collectable.h File Reference",
"href":"cpp_ref/collectable_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/collection.h File Reference",
"href":"cpp_ref/collection_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/colors.h File Reference",
"href":"cpp_ref/colors_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: color.h File Reference",
"href":"cpp_ref/color_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/color.inl File Reference",
"href":"cpp_ref/color_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: contextids.h File Reference",
"href":"cpp_ref/contextids_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/controller.inl File Reference",
"href":"cpp_ref/controller_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: control.h File Reference",
"href":"cpp_ref/control_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: coreexp.h File Reference",
"href":"cpp_ref/coreexp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/corenames.inl File Reference",
"href":"cpp_ref/corenames_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/create.inl File Reference",
"href":"cpp_ref/create_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: custattrib.h File Reference",
"href":"cpp_ref/custattrib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: custcont.h File Reference",
"href":"cpp_ref/custcont_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: dbgprint.h File Reference",
"href":"cpp_ref/dbgprint_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: decomp.h File Reference",
"href":"cpp_ref/decomp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/define_abstract_functions.h File Reference",
"href":"cpp_ref/define__abstract__functions_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/define_external_functions.h File Reference",
"href":"cpp_ref/define__external__functions_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/define_implementations.h File Reference",
"href":"cpp_ref/define__implementations_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/define_instantiation_functions.h File Reference",
"href":"cpp_ref/define__instantiation__functions_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/delegexp.h File Reference",
"href":"cpp_ref/delegexp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Deprecated List",
"href":"cpp_ref/deprecated.html",
"description":"",
"ancestors":[]},
{"title":"C++: dllutilities.h File Reference",
"href":"cpp_ref/dllutilities_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: dpoint3.h File Reference",
"href":"cpp_ref/dpoint3_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: dummy.h File Reference",
"href":"cpp_ref/dummy_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: dynamic.h File Reference",
"href":"cpp_ref/dynamic_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: enums, \#defines, and Other Lists",
"href":"cpp_ref/enums_defines_and_other_lists_root_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: euler.h File Reference",
"href":"cpp_ref/euler_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: evrouter.h File Reference",
"href":"cpp_ref/evrouter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: evuser.h File Reference",
"href":"cpp_ref/evuser_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/kernel/exceptions.h File Reference",
"href":"cpp_ref/exceptions_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: excllist.h File Reference",
"href":"cpp_ref/excllist_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: expmtlControl.h File Reference",
"href":"cpp_ref/expmtl_control_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: export.h File Reference",
"href":"cpp_ref/export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: exprlib.h File Reference",
"href":"cpp_ref/exprlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: expr.h File Reference",
"href":"cpp_ref/expr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: filters.h File Reference",
"href":"cpp_ref/filters_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fltapi.h File Reference",
"href":"cpp_ref/fltapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: fltlib.h File Reference",
"href":"cpp_ref/fltlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gamma.h File Reference",
"href":"cpp_ref/gamma_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gbuf.h File Reference",
"href":"cpp_ref/gbuf_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gencam.h File Reference",
"href":"cpp_ref/gencam_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/generics.inl File Reference",
"href":"cpp_ref/generics_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/generic_class.h File Reference",
"href":"cpp_ref/generic__class_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: genhier.h File Reference",
"href":"cpp_ref/genhier_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: genlight.h File Reference",
"href":"cpp_ref/genlight_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: genshape.h File Reference",
"href":"cpp_ref/genshape_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: geomlib.h File Reference",
"href":"cpp_ref/geomlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: geom.h File Reference",
"href":"cpp_ref/geom_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gfloat.h File Reference",
"href":"cpp_ref/gfloat_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gfxlib.h File Reference",
"href":"cpp_ref/gfxlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gfx.h File Reference",
"href":"cpp_ref/gfx_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gizmoimp.h File Reference",
"href":"cpp_ref/gizmoimp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gizmo.h File Reference",
"href":"cpp_ref/gizmo_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gport2.h File Reference",
"href":"cpp_ref/gport2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gport.h File Reference",
"href":"cpp_ref/gport_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Alignment Positions",
"href":"cpp_ref/group__bitmap_alignment_positions.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Close Types",
"href":"cpp_ref/group__bitmap_close_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Copy Image Operations",
"href":"cpp_ref/group__bitmap_copy_image_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: Custom Bitmap Flags",
"href":"cpp_ref/group__bitmap_custom_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Error (result) Codes",
"href":"cpp_ref/group__bitmap_error_codes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Filename Resolution Functions",
"href":"cpp_ref/group__bitmap_filename.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Filter Types",
"href":"cpp_ref/group__bitmap_filter_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Flags",
"href":"cpp_ref/group__bitmap_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: BitmapIO Capability Flags",
"href":"cpp_ref/group__bitmap_i_o_capability_flag.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Open Mode Types",
"href":"cpp_ref/group__bitmap_open_mode_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Storage Types",
"href":"cpp_ref/group__bitmap_storage_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Types",
"href":"cpp_ref/group__bitmap_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Shape Capping Types",
"href":"cpp_ref/group__cap_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: CUI Docking Panel Locations",
"href":"cpp_ref/group__cui_docking_panel_locations.html",
"description":"",
"ancestors":[]},
{"title":"C++: CUI Frame Orientations",
"href":"cpp_ref/group__cui_frame_orientations.html",
"description":"",
"ancestors":[]},
{"title":"C++: CUI Frame Position Types",
"href":"cpp_ref/group__cui_frame_position_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: CUI Frame Size Types",
"href":"cpp_ref/group__cui_frame_size_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Custom Curve Control Flags",
"href":"cpp_ref/group__custom_curve_control_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Dimension Types",
"href":"cpp_ref/group__dim_type.html",
"description":"",
"ancestors":[]},
{"title":"C++: DropTypes",
"href":"cpp_ref/group__drop_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Expression Return Codes",
"href":"cpp_ref/group__expression_return_codes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Expression Types",
"href":"cpp_ref/group__expression_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Expression Variable Types",
"href":"cpp_ref/group__expression_variable_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Extended Display Modes",
"href":"cpp_ref/group__extended_display_modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Extra Flags Field of RendParams",
"href":"cpp_ref/group__extra_flags__field__of___rend_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: First Edge-Visibility Bit Field",
"href":"cpp_ref/group__first__edge__visibility__bit__field.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPStatus values",
"href":"cpp_ref/group__fp_status_values.html",
"description":"",
"ancestors":[]},
{"title":"C++: G-Buffer Channel Indices",
"href":"cpp_ref/group__g_buf_channel_indices.html",
"description":"",
"ancestors":[]},
{"title":"C++: G-Buffer Channel Types",
"href":"cpp_ref/group__g_buf_channel_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Image (G-Buffer) Channels",
"href":"cpp_ref/group__g_buf_image_channels.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImageFilter Capability Flags",
"href":"cpp_ref/group__image_filter_capability_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImageFilter-Related Messages",
"href":"cpp_ref/group__image_filter_related_messages.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface::Execute Command Options",
"href":"cpp_ref/group__interface_exec_command_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface7::SetNodeAttribute Defines",
"href":"cpp_ref/group__interface_set_node_attributes.html",
"description":"",
"ancestors":[]},
{"title":"C++: I/O Results",
"href":"cpp_ref/group__io_results.html",
"description":"",
"ancestors":[]},
{"title":"C++: Flag Bits for Keys",
"href":"cpp_ref/group__key_flag_bits.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bezier-specific Key Flags",
"href":"cpp_ref/group__key_flag_bits__bezier_specific.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bezier Tangeant Types",
"href":"cpp_ref/group__key_flag_bits__bezier_tangent_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: General Key Flags",
"href":"cpp_ref/group__key_flag_bits__general_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Macros to Access Hybrid Tangent Types",
"href":"cpp_ref/group__key_flag_bits__hybrid_tangeant_access_macros.html",
"description":"",
"ancestors":[]},
{"title":"C++: In and Out types",
"href":"cpp_ref/group__key_flag_bits__in_out_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Key Flagbit Macros",
"href":"cpp_ref/group__key_flag_bits__macros.html",
"description":"",
"ancestors":[]},
{"title":"C++: TCB-specific Key Flags",
"href":"cpp_ref/group__key_flag_bits__tcb_specific.html",
"description":"",
"ancestors":[]},
{"title":"C++: Map Slot Types",
"href":"cpp_ref/group__map_slot_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material Flags",
"href":"cpp_ref/group__material_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material Requirements Flags",
"href":"cpp_ref/group__material_requirements_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: 3ds Max Commands",
"href":"cpp_ref/group__max_command_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material Editor Dialog Mode values",
"href":"cpp_ref/group__mtl_dlg_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: New Scene Options",
"href":"cpp_ref/group__new__scene__options.html",
"description":"",
"ancestors":[]},
{"title":"C++: File Process Type",
"href":"cpp_ref/group__notify__file__process__type.html",
"description":"",
"ancestors":[]},
{"title":"C++: number of ShapeObject references/subanims",
"href":"cpp_ref/group__number__of___shape_object__references__subanims.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSAutoParam Types",
"href":"cpp_ref/group__nurb_auto_param_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSConst Types",
"href":"cpp_ref/group__nurb_const_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSMirrorAxis Types",
"href":"cpp_ref/group__nurb_mirror_axis_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSObject Kinds",
"href":"cpp_ref/group__nurb_object_kinds.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSObject Types",
"href":"cpp_ref/group__nurb_object_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSParameterization Types",
"href":"cpp_ref/group__nurb_parameterization_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBS Results",
"href":"cpp_ref/group__nurb_results.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSSubObjectLevel Options",
"href":"cpp_ref/group__nurb_sub_object_level_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSTess Types",
"href":"cpp_ref/group__nurb_tess_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBSTextureSurface Types",
"href":"cpp_ref/group__nurb_texture_surface_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: NURBS Trim Directions",
"href":"cpp_ref/group__nurb_trim_directions.html",
"description":"",
"ancestors":[]},
{"title":"C++: Out of Range Types",
"href":"cpp_ref/group__out_of_range_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Painter Interface Color Defines",
"href":"cpp_ref/group__painter_color_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Painter Interface Pressure Defines",
"href":"cpp_ref/group__painter_pressure_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Arc Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__arc.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bend Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__bend.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bomb Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__bomb.html",
"description":"",
"ancestors":[]},
{"title":"C++: Box Object Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__box_object.html",
"description":"",
"ancestors":[]},
{"title":"C++: Circle Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__circle.html",
"description":"",
"ancestors":[]},
{"title":"C++: Cone Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__cone.html",
"description":"",
"ancestors":[]},
{"title":"C++: Cylinder Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__cylinder.html",
"description":"",
"ancestors":[]},
{"title":"C++: Deflector Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__deflector.html",
"description":"",
"ancestors":[]},
{"title":"C++: Displace Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__displace.html",
"description":"",
"ancestors":[]},
{"title":"C++: Donut Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__donut.html",
"description":"",
"ancestors":[]},
{"title":"C++: Ellipse Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__ellipse.html",
"description":"",
"ancestors":[]},
{"title":"C++: Extrude Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__extrude.html",
"description":"",
"ancestors":[]},
{"title":"C++: Gravity Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__gravity.html",
"description":"",
"ancestors":[]},
{"title":"C++: Grid Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__grid.html",
"description":"",
"ancestors":[]},
{"title":"C++: Hedra Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__hedra.html",
"description":"",
"ancestors":[]},
{"title":"C++: Helix Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__helix.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material Mod Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__material_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material Modifier Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__material_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: NGon Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__ngon.html",
"description":"",
"ancestors":[]},
{"title":"C++: Noise Mod Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__noise_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: Normal Mod Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__normal_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: Normal Modifier Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__normal_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: Optimize Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__optimize.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchGrid Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__patch_grid.html",
"description":"",
"ancestors":[]},
{"title":"C++: Rain/Snow Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__rain_snow.html",
"description":"",
"ancestors":[]},
{"title":"C++: Rectangle Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__rectangle.html",
"description":"",
"ancestors":[]},
{"title":"C++: Ripple/Wave Binding (modifier) Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__ripple_wave_binding.html",
"description":"",
"ancestors":[]},
{"title":"C++: Ripple/Wave Modifier Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__ripple_wave_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: Skew Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__skew.html",
"description":"",
"ancestors":[]},
{"title":"C++: Smoothing Group Modifier Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__smoothing_group_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: Smooth Mod Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__smooth_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: Sphere Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__sphere.html",
"description":"",
"ancestors":[]},
{"title":"C++: Star Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__star.html",
"description":"",
"ancestors":[]},
{"title":"C++: SurfRev (Lathe) Modifier Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__surf_rev_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: Taper Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__taper.html",
"description":"",
"ancestors":[]},
{"title":"C++: Tea Pot Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__tea_pot.html",
"description":"",
"ancestors":[]},
{"title":"C++: Tessellation Mod Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__tessellation_mod.html",
"description":"",
"ancestors":[]},
{"title":"C++: Text Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__text.html",
"description":"",
"ancestors":[]},
{"title":"C++: Torus Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__torus.html",
"description":"",
"ancestors":[]},
{"title":"C++: Tube Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__tube.html",
"description":"",
"ancestors":[]},
{"title":"C++: Twist Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__twist.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVW Xform Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__uvm_xform.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVW Map Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__uvw_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: Volume Selection Modifier Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__volume_selection_modifier.html",
"description":"",
"ancestors":[]},
{"title":"C++: Wind Parameter Block IDs",
"href":"cpp_ref/group__param_block_i_ds__wind.html",
"description":"",
"ancestors":[]},
{"title":"C++: PartID",
"href":"cpp_ref/group__partids.html",
"description":"",
"ancestors":[]},
{"title":"C++: PartIDs for Changing Display Properties",
"href":"cpp_ref/group__partid__disp__props.html",
"description":"",
"ancestors":[]},
{"title":"C++: Miscellaneous PartIDs",
"href":"cpp_ref/group__partid__misc.html",
"description":"",
"ancestors":[]},
{"title":"C++: Node Global Illumination Property PartIDs",
"href":"cpp_ref/group__partid__node__global__illumination__property.html",
"description":"",
"ancestors":[]},
{"title":"C++: Node Render Property PartIDs",
"href":"cpp_ref/group__partid__node__render__property.html",
"description":"",
"ancestors":[]},
{"title":"C++: Object Channel PartIDs",
"href":"cpp_ref/group__partid__object__channel.html",
"description":"",
"ancestors":[]},
{"title":"C++: PropertySet Options",
"href":"cpp_ref/group__property_set_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Proxy Load Request values",
"href":"cpp_ref/group__proxy_load.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Proxy Refresh Request values",
"href":"cpp_ref/group__proxy_refresh.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Proxy Render Mode",
"href":"cpp_ref/group__proxy_render_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Proxy Request flags, used by LoadInto()",
"href":"cpp_ref/group__proxy_request_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Proxy Size Factor values",
"href":"cpp_ref/group__proxy_size_factor.html",
"description":"",
"ancestors":[]},
{"title":"C++: Render Preset Category Defines",
"href":"cpp_ref/group__render_preset_cat_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: Render Setting IDs",
"href":"cpp_ref/group__render_setting_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Right-Click Contexts",
"href":"cpp_ref/group__right_click_menu_contexts.html",
"description":"",
"ancestors":[]},
{"title":"C++: Spline IK Parameters",
"href":"cpp_ref/group__spline_i_k_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: Standard Color IDs",
"href":"cpp_ref/group__standard_color_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Standard Command Modes",
"href":"cpp_ref/group__std_command_modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: System Error Log Message Types",
"href":"cpp_ref/group__system_error_log_message_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Texture Symmetry Flags",
"href":"cpp_ref/group__texture_symmetry_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Screen-Time-Value Macros",
"href":"cpp_ref/group__time_to_screen.html",
"description":"",
"ancestors":[]},
{"title":"C++: Tool Item Types",
"href":"cpp_ref/group__tool_item_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Trackview Filter Mask Types",
"href":"cpp_ref/group__track_view_filter_mask_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Track View Picking Flags IDs",
"href":"cpp_ref/group__track_view_pick_dlg_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Transform Lock Axis",
"href":"cpp_ref/group__transform_lock_axis.html",
"description":"",
"ancestors":[]},
{"title":"C++: Transform Lock Types",
"href":"cpp_ref/group__transform_lock_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Viewport Degradation Flags",
"href":"cpp_ref/group__vieport_degradation_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewportDrawingColors",
"href":"cpp_ref/group__viewport_drawing_colors.html",
"description":"",
"ancestors":[]},
{"title":"C++: Viewport Rendering Levels",
"href":"cpp_ref/group__viewport_rendering_level.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef Flag Bits",
"href":"cpp_ref/group__xref_flag_bits.html",
"description":"",
"ancestors":[]},
{"title":"C++: Action Context IDs",
"href":"cpp_ref/group___action_context_id_constants.html",
"description":"",
"ancestors":[]},
{"title":"C++: ActionTableId Constants",
"href":"cpp_ref/group___action_table_id_constants.html",
"description":"",
"ancestors":[]},
{"title":"C++: Animatable Flags",
"href":"cpp_ref/group___animatable_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Assert macros",
"href":"cpp_ref/group___assert_macros.html",
"description":"",
"ancestors":[]},
{"title":"C++: Attach to Group Commands",
"href":"cpp_ref/group___attach__to___group___commands.html",
"description":"",
"ancestors":[]},
{"title":"C++: Auto-Crossing Selection Mode",
"href":"cpp_ref/group___auto___crossing___selection___mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: Arguments for BaseObject::NewSetByOperator()",
"href":"cpp_ref/group___base_object_____new_set_by_operator______arguments.html",
"description":"",
"ancestors":[]},
{"title":"C++: Actions performed by the behavior",
"href":"cpp_ref/group___behavior_actions.html",
"description":"",
"ancestors":[]},
{"title":"C++: Biped Interface 10",
"href":"cpp_ref/group___biped_interface10.html",
"description":"",
"ancestors":[]},
{"title":"C++: Biped Interface 11",
"href":"cpp_ref/group___biped_interface11.html",
"description":"",
"ancestors":[]},
{"title":"C++: Biped Interface 12",
"href":"cpp_ref/group___biped_interface12.html",
"description":"",
"ancestors":[]},
{"title":"C++: Biped Interface 8",
"href":"cpp_ref/group___biped_interface8.html",
"description":"",
"ancestors":[]},
{"title":"C++: Biped Interface 9",
"href":"cpp_ref/group___biped_interface9.html",
"description":"",
"ancestors":[]},
{"title":"C++: BIP file controller and max object load options",
"href":"cpp_ref/group___biped_load_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: Biped Modes",
"href":"cpp_ref/group___biped_modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: BIP file load max object retargeting options",
"href":"cpp_ref/group___biped_object_retarget_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: BIP file controller and max object save options",
"href":"cpp_ref/group___biped_save_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: Biped Snapshot Types",
"href":"cpp_ref/group___biped_snapshot_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Biped TCB/IK Paste Options",
"href":"cpp_ref/group___biped_t_c_b_i_k_paste_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: Bitmap Proxy Subject Info",
"href":"cpp_ref/group___bitmap_proxy_info_access.html",
"description":"",
"ancestors":[]},
{"title":"C++: Boolean Operations for Meshes",
"href":"cpp_ref/group___boolean___operations__for___meshes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Button Constants",
"href":"cpp_ref/group___button___constants.html",
"description":"",
"ancestors":[]},
{"title":"C++: conversion methods",
"href":"cpp_ref/group___b_s_t_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: CapVert Flags",
"href":"cpp_ref/group___cap_vert__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Conversion Classes",
"href":"cpp_ref/group___casting.html",
"description":"",
"ancestors":[]},
{"title":"C++: Category strings for space warp objects",
"href":"cpp_ref/group___category__strings__for__space__warp__objects.html",
"description":"",
"ancestors":[]},
{"title":"C++: Chunk IDs saved by base class",
"href":"cpp_ref/group___chunk___i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Predefined Class IDs",
"href":"cpp_ref/group___class_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Clipping Distances",
"href":"cpp_ref/group___clipping___distances.html",
"description":"",
"ancestors":[]},
{"title":"C++: Page Query Methods",
"href":"cpp_ref/group___code.html",
"description":"",
"ancestors":[]},
{"title":"C++: Command Classes",
"href":"cpp_ref/group___command___classes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Command IDs",
"href":"cpp_ref/group___command___i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Command Super Classes",
"href":"cpp_ref/group___command___super___classes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Comparison Operators and methods",
"href":"cpp_ref/group___comparators.html",
"description":"",
"ancestors":[]},
{"title":"C++: Components defines",
"href":"cpp_ref/group___components__defines.html",
"description":"",
"ancestors":[]},
{"title":"C++: Compound line types",
"href":"cpp_ref/group___compound__line__types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Constructors",
"href":"cpp_ref/group___constructors.html",
"description":"",
"ancestors":[]},
{"title":"C++: Controller Events",
"href":"cpp_ref/group___controller_event_methods.html",
"description":"",
"ancestors":[]},
{"title":"C++: methods Instance methods for converting to other encodings.",
"href":"cpp_ref/group___conversion.html",
"description":"",
"ancestors":[]},
{"title":"C++: Core Interface Management",
"href":"cpp_ref/group___core_interface_management.html",
"description":"",
"ancestors":[]},
{"title":"C++: Customization of Grips",
"href":"cpp_ref/group___customization.html",
"description":"",
"ancestors":[]},
{"title":"C++: Operation Modes",
"href":"cpp_ref/group___customized.html",
"description":"",
"ancestors":[]},
{"title":"C++: Custom Windows Messages",
"href":"cpp_ref/group___custom___windows___messages.html",
"description":"",
"ancestors":[]},
{"title":"C++: Data Types for Mash Vertices",
"href":"cpp_ref/group___data___types__for___mash___vertices.html",
"description":"",
"ancestors":[]},
{"title":"C++: Default Interpolation Settings",
"href":"cpp_ref/group___default___interpolation___settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: Default Action System: Actions",
"href":"cpp_ref/group___def_sys_default_actions.html",
"description":"",
"ancestors":[]},
{"title":"C++: Default Action System: Events",
"href":"cpp_ref/group___def_sys_events.html",
"description":"",
"ancestors":[]},
{"title":"C++: Display Events",
"href":"cpp_ref/group___display_event_methods.html",
"description":"",
"ancestors":[]},
{"title":"C++: Display Flags",
"href":"cpp_ref/group___display___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Display State of the Graphics Window",
"href":"cpp_ref/group___display___state__of__the___graphics___window.html",
"description":"",
"ancestors":[]},
{"title":"C++: DrawPhase values",
"href":"cpp_ref/group___draw_phase__values.html",
"description":"",
"ancestors":[]},
{"title":"C++: Driver types",
"href":"cpp_ref/group___driver___types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Dual_Plane_Buffer_Types",
"href":"cpp_ref/group___dual___plane___buffer___types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Duplicate Material Name Actions",
"href":"cpp_ref/group___dup_mtl_name_actions.html",
"description":"",
"ancestors":[]},
{"title":"C++: Duplicate Node Name Actions",
"href":"cpp_ref/group___dup_node_name_actions.html",
"description":"",
"ancestors":[]},
{"title":"C++: Edge's Visibility Constants",
"href":"cpp_ref/group___edge__s__visibility__constants.html",
"description":"",
"ancestors":[]},
{"title":"C++: Edge Visibility Flags",
"href":"cpp_ref/group___edge__visibility__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Edge Styles",
"href":"cpp_ref/group___edge___styles.html",
"description":"",
"ancestors":[]},
{"title":"C++: Setter Methods. These set the MaxString's content based on the string passed in.",
"href":"cpp_ref/group___encoding.html",
"description":"",
"ancestors":[]},
{"title":"C++: Auxilliary File Enumeration Flags",
"href":"cpp_ref/group___enum_aux_files.html",
"description":"",
"ancestors":[]},
{"title":"C++: Environment Range Distances",
"href":"cpp_ref/group___environment___range___distances.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExposureMaterialControl: How to Implement",
"href":"cpp_ref/group___exposure_material_control_imp_class.html",
"description":"",
"ancestors":[]},
{"title":"C++: methods",
"href":"cpp_ref/group___factory.html",
"description":"",
"ancestors":[]},
{"title":"C++: Fixed font related methods",
"href":"cpp_ref/group___fixed_font_methods.html",
"description":"",
"ancestors":[]},
{"title":"C++: Flags for the View class",
"href":"cpp_ref/group___flags__for__the___view__class_____view____flags__.html",
"description":"",
"ancestors":[]},
{"title":"C++: Flags for AddAnimatable() and SvTravereseAnimGraph()",
"href":"cpp_ref/group___flags__for___add_animatable______and___sv_traverese_anim_graph____.html",
"description":"",
"ancestors":[]},
{"title":"C++: Flags for PushLevel()",
"href":"cpp_ref/group___flags__for___push_level______.html",
"description":"",
"ancestors":[]},
{"title":"C++: Flags for Sub Object Hit Test",
"href":"cpp_ref/group___flags__for___sub___object___hit___test.html",
"description":"",
"ancestors":[]},
{"title":"C++: General Purpose Graphics Constants",
"href":"cpp_ref/group___general___purpose___graphics___constants.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenerateMesh Options",
"href":"cpp_ref/group___generate_mesh___options.html",
"description":"",
"ancestors":[]},
{"title":"C++: GraphicsWindow::querySupport() Arguments",
"href":"cpp_ref/group___graphics_window____query_support_____arguments.html",
"description":"",
"ancestors":[]},
{"title":"C++: GraphicsWindow::querySupport() Return Values",
"href":"cpp_ref/group___graphics_window____query_support_____return___values.html",
"description":"",
"ancestors":[]},
{"title":"C++: Grid Types",
"href":"cpp_ref/group___grid___types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Handle Box Types",
"href":"cpp_ref/group___handle___box___types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Hidden Map Channels / Numbers",
"href":"cpp_ref/group___hidden___map___channels_______numbers.html",
"description":"",
"ancestors":[]},
{"title":"C++: Hierarchy Events",
"href":"cpp_ref/group___hierarchy_event_methods.html",
"description":"",
"ancestors":[]},
{"title":"C++: Instance Manager Make Unique Options",
"href":"cpp_ref/group___instance_mgr_make_unique_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of interface IDs supported by different plugin types",
"href":"cpp_ref/group___interface_i_d_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: Interface ID",
"href":"cpp_ref/group___interface___i_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: Internally Used Graphics Constants",
"href":"cpp_ref/group___internally__used__graphics__constants.html",
"description":"",
"ancestors":[]},
{"title":"C++: Internal Flags",
"href":"cpp_ref/group___internal___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Index_Arguments Interpolation Parameter Block Index Arguments",
"href":"cpp_ref/group___interpolation___parameter___block__.html",
"description":"",
"ancestors":[]},
{"title":"C++: IChannelContainer.h",
"href":"cpp_ref/group___i_channel_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMXSParticleContainer.h",
"href":"cpp_ref/group___i_m_x_s_particle_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannel.h",
"href":"cpp_ref/group___i_particle_channel.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelAmount.h",
"href":"cpp_ref/group___i_particle_channel_amount.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelAngAxis.h",
"href":"cpp_ref/group___i_particle_channel_ang_axis.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelBool.h",
"href":"cpp_ref/group___i_particle_channel_bool.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelExt.h",
"href":"cpp_ref/group___i_particle_channel_ext.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelFloat.h",
"href":"cpp_ref/group___i_particle_channel_float.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelInt.h",
"href":"cpp_ref/group___i_particle_channel_int.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelID.h",
"href":"cpp_ref/group___i_particle_channel_i_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelINode.h",
"href":"cpp_ref/group___i_particle_channel_i_node.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMap.h",
"href":"cpp_ref/group___i_particle_channel_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMatrix3.h",
"href":"cpp_ref/group___i_particle_channel_matrix3.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelMeshMap.h",
"href":"cpp_ref/group___i_particle_channel_mesh_map.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelNew.h",
"href":"cpp_ref/group___i_particle_channel_new.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelPTV.h",
"href":"cpp_ref/group___i_particle_channel_p_t_v.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelQuat.h",
"href":"cpp_ref/group___i_particle_channel_quat.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelTabTVFace.h",
"href":"cpp_ref/group___i_particle_channel_tab_t_v_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelTabUVVert.h",
"href":"cpp_ref/group___i_particle_channel_tab_u_v_vert.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleChannelVoid.h",
"href":"cpp_ref/group___i_particle_channel_void.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleContainer.h",
"href":"cpp_ref/group___i_particle_container.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleGroup.h",
"href":"cpp_ref/group___i_particle_group.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleGroupExt.h",
"href":"cpp_ref/group___i_particle_group_ext.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFAction.h",
"href":"cpp_ref/group___i_p_f_action.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionExt.h",
"href":"cpp_ref/group___i_p_f_action_ext.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionList.h",
"href":"cpp_ref/group___i_p_f_action_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionListPool.h",
"href":"cpp_ref/group___i_p_f_action_list_pool.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionListSet.h",
"href":"cpp_ref/group___i_p_f_action_list_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFActionState.h",
"href":"cpp_ref/group___i_p_f_action_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFArrow.h",
"href":"cpp_ref/group___i_p_f_arrow.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFIntegrator.h",
"href":"cpp_ref/group___i_p_f_integrator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFOperator.h",
"href":"cpp_ref/group___i_p_f_operator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFRender.h",
"href":"cpp_ref/group___i_p_f_render.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFSystem.h",
"href":"cpp_ref/group___i_p_f_system.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFSystemPool.h",
"href":"cpp_ref/group___i_p_f_system_pool.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFTest.h",
"href":"cpp_ref/group___i_p_f_test.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPFViewport.h",
"href":"cpp_ref/group___i_p_f_viewport.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPViewItem.h",
"href":"cpp_ref/group___i_p_view_item.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPViewItemCreator.h",
"href":"cpp_ref/group___i_p_view_item_creator.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPViewManager.h",
"href":"cpp_ref/group___i_p_view_manager.html",
"description":"",
"ancestors":[]},
{"title":"C++: as one part of one customized mode's shortcut.",
"href":"cpp_ref/group___key.html",
"description":"",
"ancestors":[]},
{"title":"C++: Knot types",
"href":"cpp_ref/group___knot__types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Lighting Constants",
"href":"cpp_ref/group___lighting___constants.html",
"description":"",
"ancestors":[]},
{"title":"C++: Light object's attenuation range distance",
"href":"cpp_ref/group___light__object__s__attenuation__range__distance__.html",
"description":"",
"ancestors":[]},
{"title":"C++: Light Attenuation Types",
"href":"cpp_ref/group___light___attenuation___types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Line types",
"href":"cpp_ref/group___line__types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Manipulate Grip Items",
"href":"cpp_ref/group___manipulate_grips.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mapping Flags",
"href":"cpp_ref/group___mapping___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material Events",
"href":"cpp_ref/group___material_event_methods.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material Browser Flags",
"href":"cpp_ref/group___material___browser___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Material ID Masks",
"href":"cpp_ref/group___material___i_d___masks.html",
"description":"",
"ancestors":[]},
{"title":"C++: Texture Map Indices",
"href":"cpp_ref/group___material___texture_map___i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Memory Limit Auto Mode",
"href":"cpp_ref/group___memory_limit_auto_mode.html",
"description":"",
"ancestors":[]},
{"title":"C++: Memory Limit Percentage",
"href":"cpp_ref/group___memory_limit_percentage.html",
"description":"",
"ancestors":[]},
{"title":"C++: Memory Padding",
"href":"cpp_ref/group___memory_padding.html",
"description":"",
"ancestors":[]},
{"title":"C++: Menu Contexts.",
"href":"cpp_ref/group___menu_contexts.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mesh, Vertex and Face Flags",
"href":"cpp_ref/group___mesh_vertex_face_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mesh Normal Display Flags",
"href":"cpp_ref/group___mesh___normal___display___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mesh Selection Level Bits",
"href":"cpp_ref/group___mesh___selection___level___bits.html",
"description":"",
"ancestors":[]},
{"title":"C++: Model Events",
"href":"cpp_ref/group___model_event_methods.html",
"description":"",
"ancestors":[]},
{"title":"C++: button as one part of one customized mode's shortcut.",
"href":"cpp_ref/group___mouse.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mouse Drag Modes",
"href":"cpp_ref/group___mouse__drag__modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mouse Callback Messages",
"href":"cpp_ref/group___mouse___callback___messages.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mouse Call Back Flags",
"href":"cpp_ref/group___mouse___call___back___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: MAX Directory IDs",
"href":"cpp_ref/group___m_a_x_dir_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMesh Display Flags",
"href":"cpp_ref/group___m_n_d_i_s_p___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMesh Component Flags",
"href":"cpp_ref/group___m_n_mesh___component___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMesh Flags",
"href":"cpp_ref/group___m_n___m_e_s_h___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: The name change notifications.",
"href":"cpp_ref/group___name_change_notifications.html",
"description":"",
"ancestors":[]},
{"title":"C++: Node Reparent Actions",
"href":"cpp_ref/group___node_reparent_actions.html",
"description":"",
"ancestors":[]},
{"title":"C++: Normal Face Usage Flags",
"href":"cpp_ref/group___normal___face___usage___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: System Notification Codes",
"href":"cpp_ref/group___notification_codes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Object Channels",
"href":"cpp_ref/group___object_channels.html",
"description":"",
"ancestors":[]},
{"title":"C++: OneClickCreateCallBack.h",
"href":"cpp_ref/group___one_click_create_call_back.html",
"description":"",
"ancestors":[]},
{"title":"C++: Concatenation Operators",
"href":"cpp_ref/group___operators.html",
"description":"",
"ancestors":[]},
{"title":"C++: Optimization Flags",
"href":"cpp_ref/group___optimization___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Optional Plug-in DLL Functions",
"href":"cpp_ref/group___optional_plugin_dll_function.html",
"description":"",
"ancestors":[]},
{"title":"C++: Option for PolyLine::Cap3DS / PolyShape::Make3DSCap",
"href":"cpp_ref/group___option__for___poly_line_____cap3_d_s_______poly_shape_____make3_d_s_cap.html",
"description":"",
"ancestors":[]},
{"title":"C++: Page File Path",
"href":"cpp_ref/group___page_file_path.html",
"description":"",
"ancestors":[]},
{"title":"C++: used by some customized operation mode.",
"href":"cpp_ref/group___parameter.html",
"description":"",
"ancestors":[]},
{"title":"C++: Parameter block reference indices",
"href":"cpp_ref/group___parameter__block__reference__indices.html",
"description":"",
"ancestors":[]},
{"title":"C++: Parameter types.",
"href":"cpp_ref/group___parameter__types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Parameter types for shape interpolation",
"href":"cpp_ref/group___parameter__types__for__shape__interpolation.html",
"description":"",
"ancestors":[]},
{"title":"C++: Parameter Wire Menu Flags",
"href":"cpp_ref/group___param_wire_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleChannelMask.h",
"href":"cpp_ref/group___particle_channel_mask.html",
"description":"",
"ancestors":[]},
{"title":"C++: Pass Identification for Multi-Pass Rendering",
"href":"cpp_ref/group___pass___identification__for___multi___pass___rendering.html",
"description":"",
"ancestors":[]},
{"title":"C++: Pick Modes",
"href":"cpp_ref/group___pick___modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Point flags for PolyShape representation",
"href":"cpp_ref/group___point__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: PolyLine Flags",
"href":"cpp_ref/group___poly_line___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Predefined PolyPt Flags",
"href":"cpp_ref/group___predefined___poly_pt__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Predefined PolyPt flags2",
"href":"cpp_ref/group___predefined___poly_pt__flags2.html",
"description":"",
"ancestors":[]},
{"title":"C++: Private spline flags",
"href":"cpp_ref/group___private__spline__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Property Events",
"href":"cpp_ref/group___property_event_methods.html",
"description":"",
"ancestors":[]},
{"title":"C++: PFSimpleTest.h",
"href":"cpp_ref/group___p_f_simple_test.html",
"description":"",
"ancestors":[]},
{"title":"C++: Pi Constants",
"href":"cpp_ref/group___p_i___constants.html",
"description":"",
"ancestors":[]},
{"title":"C++: Reference Messages",
"href":"cpp_ref/group___reference___messages.html",
"description":"",
"ancestors":[]},
{"title":"C++: Region Directions",
"href":"cpp_ref/group___region___direction.html",
"description":"",
"ancestors":[]},
{"title":"C++: Region Types",
"href":"cpp_ref/group___region___types___used__for___hit___testing.html",
"description":"",
"ancestors":[]},
{"title":"C++: Rendering Modes",
"href":"cpp_ref/group___rendering___modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Render Instance Flags",
"href":"cpp_ref/group___render___instance___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Render Options Flags",
"href":"cpp_ref/group___render___options___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Required Plug-in DLL Functions",
"href":"cpp_ref/group___required_plugin_dll_function.html",
"description":"",
"ancestors":[]},
{"title":"C++: Returne valuse of ParticleCenter()",
"href":"cpp_ref/group___returne__valuse__of___particle_center______.html",
"description":"",
"ancestors":[]},
{"title":"C++: RVertex Flags",
"href":"cpp_ref/group___r_vertex__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Scene and Node Hit Testing Flags",
"href":"cpp_ref/group___scene_and_node_hit_test_flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Scene and Node Hit Test Types.",
"href":"cpp_ref/group___scene_and_node_hit_test_types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Schematic view colors",
"href":"cpp_ref/group___schematic__view__colors.html",
"description":"",
"ancestors":[]},
{"title":"C++: Selection Level Flags",
"href":"cpp_ref/group___selection___level___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Shadow types used by the light.",
"href":"cpp_ref/group___shadow__types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Snap Flags",
"href":"cpp_ref/group___snap__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Snap modes",
"href":"cpp_ref/group___snap__modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Snap types",
"href":"cpp_ref/group___snap__types.html",
"description":"",
"ancestors":[]},
{"title":"C++: Snap Flags",
"href":"cpp_ref/group___snap___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Special Command IDs",
"href":"cpp_ref/group___special___command___i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: SplitFilename - Split a filename into its components",
"href":"cpp_ref/group___split_filename.html",
"description":"",
"ancestors":[]},
{"title":"C++: SplitFilenameOld - Split a filename into its components",
"href":"cpp_ref/group___split_filename_old.html",
"description":"",
"ancestors":[]},
{"title":"C++: Spotlight Shapes",
"href":"cpp_ref/group___spotlight___shapes.html",
"description":"",
"ancestors":[]},
{"title":"C++: Standard Parameter flags",
"href":"cpp_ref/group___standard___parameter__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Steps Arguments",
"href":"cpp_ref/group___steps___arguments.html",
"description":"",
"ancestors":[]},
{"title":"C++: Sub-Object Centers and TMs",
"href":"cpp_ref/group___sub___object___centers__and___t_ms.html",
"description":"",
"ancestors":[]},
{"title":"C++: Super Class IDs",
"href":"cpp_ref/group___super_class_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Access to services exposed by the 3ds Max core",
"href":"cpp_ref/group___system_core_interface_access.html",
"description":"",
"ancestors":[]},
{"title":"C++: Schematic View Filter bits",
"href":"cpp_ref/group___s_v___filter__bits.html",
"description":"",
"ancestors":[]},
{"title":"C++: Internal Dialog IDs",
"href":"cpp_ref/group___tab_dialog_i_ds.html",
"description":"",
"ancestors":[]},
{"title":"C++: Tab Dialog Messages",
"href":"cpp_ref/group___tab_dialog_messages.html",
"description":"",
"ancestors":[]},
{"title":"C++: Texture channel type flags",
"href":"cpp_ref/group___texture__channel__type__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Texture Alpha Sources",
"href":"cpp_ref/group___texture___alpha___sources.html",
"description":"",
"ancestors":[]},
{"title":"C++: Texture Operations",
"href":"cpp_ref/group___texture___operations.html",
"description":"",
"ancestors":[]},
{"title":"C++: Texture Scale Factors",
"href":"cpp_ref/group___texture___scale___factors.html",
"description":"",
"ancestors":[]},
{"title":"C++: Texture Tiling Modes",
"href":"cpp_ref/group___texture___tiling___modes.html",
"description":"",
"ancestors":[]},
{"title":"C++: TraverseVolume flags",
"href":"cpp_ref/group___traverse_volume__flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Grip Value Types",
"href":"cpp_ref/group___type.html",
"description":"",
"ancestors":[]},
{"title":"C++: of zoom in direction used in customized zoom mode.",
"href":"cpp_ref/group___types.html",
"description":"",
"ancestors":[]},
{"title":"C++: User Interface (UI) font related methods",
"href":"cpp_ref/group___u_i_font_methods.html",
"description":"",
"ancestors":[]},
{"title":"C++: Values Passed to SetCurField()",
"href":"cpp_ref/group___values__passed__to___set_cur_field____.html",
"description":"",
"ancestors":[]},
{"title":"C++: Values Returned from Progress()",
"href":"cpp_ref/group___values__returned__from___progress____.html",
"description":"",
"ancestors":[]},
{"title":"C++: Version Macros",
"href":"cpp_ref/group___version_macros.html",
"description":"",
"ancestors":[]},
{"title":"C++: Vertex Data Index Options",
"href":"cpp_ref/group___vertex___data___index___options.html",
"description":"",
"ancestors":[]},
{"title":"C++: Vertex Dot Types",
"href":"cpp_ref/group___vertex___dot___types.html",
"description":"",
"ancestors":[]},
{"title":"C++: View Panel Layout Configurations",
"href":"cpp_ref/group___view_panel_layout_config_ids.html",
"description":"",
"ancestors":[]},
{"title":"C++: View Volume Clip Flags",
"href":"cpp_ref/group___view___volume___clip___flags.html",
"description":"",
"ancestors":[]},
{"title":"C++: Object Xref Options",
"href":"cpp_ref/group___x_ref_object_options.html",
"description":"",
"ancestors":[]},
{"title":"C++: gupapi.h File Reference",
"href":"cpp_ref/gupapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: guplib.h File Reference",
"href":"cpp_ref/guplib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gup.h File Reference",
"href":"cpp_ref/gup_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: gutil.h File Reference",
"href":"cpp_ref/gutil_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/hashtable.h File Reference",
"href":"cpp_ref/hashtable_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: helpsys.h File Reference",
"href":"cpp_ref/helpsys_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: hitdata.h File Reference",
"href":"cpp_ref/hitdata_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: hold.h File Reference",
"href":"cpp_ref/hold_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: hotcheck.h File Reference",
"href":"cpp_ref/hotcheck_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: hsv.h File Reference",
"href":"cpp_ref/hsv_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iassemblymgr.h File Reference",
"href":"cpp_ref/iassemblymgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iassembly.h File Reference",
"href":"cpp_ref/iassembly_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetManagement/iassetmanager.h File Reference",
"href":"cpp_ref/iassetmanager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ibrowser.h File Reference",
"href":"cpp_ref/ibrowser_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: icollision.h File Reference",
"href":"cpp_ref/icollision_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: icolorman.h File Reference",
"href":"cpp_ref/icolorman_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: icommandpanel.h File Reference",
"href":"cpp_ref/icommandpanel_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: icurvctl.h File Reference",
"href":"cpp_ref/icurvctl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: icustattribcontainer.h File Reference",
"href":"cpp_ref/icustattribcontainer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: icustrendpresets.h File Reference",
"href":"cpp_ref/icustrendpresets_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: id3d9graphicswindow.h File Reference",
"href":"cpp_ref/id3d9graphicswindow_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: id3dgraphicswindow.h File Reference",
"href":"cpp_ref/id3dgraphicswindow_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: idatachannel.h File Reference",
"href":"cpp_ref/idatachannel_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: idraganddrop.h File Reference",
"href":"cpp_ref/idraganddrop_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: idx8pixelshader.h File Reference",
"href":"cpp_ref/idx8pixelshader_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: idx8vertexshader.h File Reference",
"href":"cpp_ref/idx8vertexshader_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: idx9pixelshader.h File Reference",
"href":"cpp_ref/idx9pixelshader_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: idx9vertexshader.h File Reference",
"href":"cpp_ref/idx9vertexshader_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: COLORREF: DWORD Color Format",
"href":"cpp_ref/idx__r_colorref_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Explicit Mesh Conversion Functions",
"href":"cpp_ref/idx__r_explicit_conversion_functions_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Function ApplyKeyReduction()",
"href":"cpp_ref/idx__r_function_applykeyreducti_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of BezierShape Display Flags",
"href":"cpp_ref/idx__r_list_of_beziershape_display_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Class IDs",
"href":"cpp_ref/idx__r_list_of_class_ids_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Clip Flags",
"href":"cpp_ref/idx__r_list_of_clip_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Color Conversion Utilities",
"href":"cpp_ref/idx__r_list_of_color_conversion_utilities_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Additional Controller Related Functions",
"href":"cpp_ref/idx__r_list_of_controller_related_methods_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of ControlType2 Choices",
"href":"cpp_ref/idx__r_list_of_controltype2_choices_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Display Flags",
"href":"cpp_ref/idx__r_list_of_display_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Edge Data Index Options",
"href":"cpp_ref/idx__r_list_of_edge_data_index_options_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Front End Controller Menu Items",
"href":"cpp_ref/idx__r_list_of_fe_controller_menu_items_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Front End Controller Tool Bar Buttons",
"href":"cpp_ref/idx__r_list_of_fe_controller_tool_ids_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Geometric Utility Functions",
"href":"cpp_ref/idx__r_list_of_geometric_utility_functions_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of IGraphObjectManager Filter Bits",
"href":"cpp_ref/idx__r_list_of_igraphobjectman_filter_bits_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Job Text Types",
"href":"cpp_ref/idx__r_list_of_job_text_types_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Macro Recorder Value Types",
"href":"cpp_ref/idx__r_list_of_macro_recorder_value_types_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Mesh Mapping Channel Index Values",
"href":"cpp_ref/idx__r_list_of_mapping_channel_index_values_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Marker Types",
"href":"cpp_ref/idx__r_list_of_marker_types_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Material Browser Flags",
"href":"cpp_ref/idx__r_list_of_material_browser_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of MaxNet Errors",
"href":"cpp_ref/idx__r_list_of_maxnet_errors_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Mesh Flags",
"href":"cpp_ref/idx__r_list_of_mesh_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Miscellaneous Utility Functions",
"href":"cpp_ref/idx__r_list_of_miscellaneous_utility_functions_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Windows Related Functions",
"href":"cpp_ref/idx__r_list_of_miscellaneous_windows_related_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Miscellaneous Control Functions and Templates",
"href":"cpp_ref/idx__r_list_of_misc_ctrl_funcs_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Mouse Callback Flags",
"href":"cpp_ref/idx__r_list_of_mouse_callback_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Mouse Callback Messages",
"href":"cpp_ref/idx__r_list_of_mouse_callback_messages_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Parameter Types",
"href":"cpp_ref/idx__r_list_of_parameter_types_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of ParamTags Choices",
"href":"cpp_ref/idx__r_list_of_paramtags_choices_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Patch Display Flags",
"href":"cpp_ref/idx__r_list_of_patch_display_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Procedural Texture Functions",
"href":"cpp_ref/idx__r_list_of_procedural_texture_clamping_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Parameter Types for PolyLine Interpolation",
"href":"cpp_ref/idx__r_list_of_ptypes_for_polyline_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Parameter Types for Shape Interpolation",
"href":"cpp_ref/idx__r_list_of_ptypes_for_shape_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Parameter Types for Spline3D Interpolation",
"href":"cpp_ref/idx__r_list_of_ptypes_for_spline3d_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Rendering Limits",
"href":"cpp_ref/idx__r_list_of_rendering_limits_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Render Instance Flags",
"href":"cpp_ref/idx__r_list_of_render_instance_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Schematic View AddAnimatable Flags",
"href":"cpp_ref/idx__r_list_of_sch_view_addanimflags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Shader Standard Parameter Flags",
"href":"cpp_ref/idx__r_list_of_shader_standard_parameter_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Snap Flags",
"href":"cpp_ref/idx__r_list_of_snap_flags_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Spline Knot Types",
"href":"cpp_ref/idx__r_list_of_spline_knot_types_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Spline Line Types",
"href":"cpp_ref/idx__r_list_of_spline_line_types_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Spline Parameter Types",
"href":"cpp_ref/idx__r_list_of_spline_parameter_types_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Standard Command Modes",
"href":"cpp_ref/idx__r_list_of_standard_command_modes_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Standard Sub-Object Modes",
"href":"cpp_ref/idx__r_list_of_standard_sub_object_modes_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Super Class IDs",
"href":"cpp_ref/idx__r_list_of_super_class_ids_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of ParamType2 Choices",
"href":"cpp_ref/idx__r_list_of_type_2_params_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Vertex Data Index Options",
"href":"cpp_ref/idx__r_list_of_vertex_data_index_options_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Video Color Check Utilities",
"href":"cpp_ref/idx__r_list_of_video_color_check_utilities_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Viewport Drawing Color Indices",
"href":"cpp_ref/idx__r_list_of_viewport_drawing_color_indices_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNMesh Note on Debugging",
"href":"cpp_ref/idx__r_mnmesh_notes_on_debugging_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Time Functions and Macros",
"href":"cpp_ref/idx__r_time_function_reference_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: List of Trigonometry Macros",
"href":"cpp_ref/idx__r_trigonometry_macros_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: Units of Measurement Reference",
"href":"cpp_ref/idx__r_units_of_measurement_reference_html.html",
"description":"",
"ancestors":[]},
{"title":"C++: iemissioncolor.h File Reference",
"href":"cpp_ref/iemissioncolor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iepoly.h File Reference",
"href":"cpp_ref/iepoly_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ifacedatamgr.h File Reference",
"href":"cpp_ref/ifacedatamgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ifnpub.h File Reference",
"href":"cpp_ref/ifnpub_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: igrip.h File Reference",
"href":"cpp_ref/igrip_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iguest.h File Reference",
"href":"cpp_ref/iguest_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ihardwarematerial.h File Reference",
"href":"cpp_ref/ihardwarematerial_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ihardwaremesh.h File Reference",
"href":"cpp_ref/ihardwaremesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ihardwaremnmesh.h File Reference",
"href":"cpp_ref/ihardwaremnmesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ihardwarerenderer.h File Reference",
"href":"cpp_ref/ihardwarerenderer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ihardwareshader.h File Reference",
"href":"cpp_ref/ihardwareshader_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iiksys.h File Reference",
"href":"cpp_ref/iiksys_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iimageviewer.h File Reference",
"href":"cpp_ref/iimageviewer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ikctrl.h File Reference",
"href":"cpp_ref/ikctrl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ikhierarchy.h File Reference",
"href":"cpp_ref/ikhierarchy_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iksolver.h File Reference",
"href":"cpp_ref/iksolver_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ilag.h File Reference",
"href":"cpp_ref/ilag_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ilayermanager.h File Reference",
"href":"cpp_ref/ilayermanager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ilayer.h File Reference",
"href":"cpp_ref/ilayer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imacroscript.h File Reference",
"href":"cpp_ref/imacroscript_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imaterial.h File Reference",
"href":"cpp_ref/imaterial_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imblur.h File Reference",
"href":"cpp_ref/imblur_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imenuman.h File Reference",
"href":"cpp_ref/imenuman_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imenus.h File Reference",
"href":"cpp_ref/imenus_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: impapi.h File Reference",
"href":"cpp_ref/impapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: impexpintf.h File Reference",
"href":"cpp_ref/impexpintf_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: impexp.h File Reference",
"href":"cpp_ref/impexp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrAdvancedTranslation.h File Reference",
"href":"cpp_ref/imr_advanced_translation_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrLightTranslation.h File Reference",
"href":"cpp_ref/imr_light_translation_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrMaterialCustAttrib.h File Reference",
"href":"cpp_ref/imr_material_cust_attrib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrPhysicalSkyEnvironmentMap.h File Reference",
"href":"cpp_ref/imr_physical_sky_environment_map_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrPhysicalSkyLight.h File Reference",
"href":"cpp_ref/imr_physical_sky_light_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrPhysicalSunLight.h File Reference",
"href":"cpp_ref/imr_physical_sun_light_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrPreferences.h File Reference",
"href":"cpp_ref/imr_preferences_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrShader.h File Reference",
"href":"cpp_ref/imr_shader_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrShaderClassDesc.h File Reference",
"href":"cpp_ref/imr_shader_class_desc_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrShaderTranslation.h File Reference",
"href":"cpp_ref/imr_shader_translation_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrSkyPortalLight.h File Reference",
"href":"cpp_ref/imr_sky_portal_light_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/imrTranslation.h File Reference",
"href":"cpp_ref/imr_translation_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imszip.h File Reference",
"href":"cpp_ref/imszip_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imtledit.h File Reference",
"href":"cpp_ref/imtledit_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imtl.h File Reference",
"href":"cpp_ref/imtl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: 3ds Max SDK C++ Reference Documentation",
"href":"cpp_ref/index.html",
"description":"",
"ancestors":[]},
{"title":"C++: inode.h File Reference",
"href":"cpp_ref/inode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: interactiverender.h File Reference",
"href":"cpp_ref/interactiverender_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: DataNodeWrapper< HeldType_ > Interface Template Reference",
"href":"cpp_ref/interface_managed_services_1_1_data_node_wrapper.html",
"description":"",
"ancestors":[]},
{"title":"C++: interpik.h File Reference",
"href":"cpp_ref/interpik_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/kernel/interupts.h File Reference",
"href":"cpp_ref/interupts_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: interval.h File Reference",
"href":"cpp_ref/interval_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ioapi.h File Reference",
"href":"cpp_ref/ioapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iparamb2.h File Reference",
"href":"cpp_ref/iparamb2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iparamb2Typedefs.h File Reference",
"href":"cpp_ref/iparamb2_typedefs_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iparamb.h File Reference",
"href":"cpp_ref/iparamb_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iparamm2.h File Reference",
"href":"cpp_ref/iparamm2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iparamm.h File Reference",
"href":"cpp_ref/iparamm_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iparamwire.h File Reference",
"href":"cpp_ref/iparamwire_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ipipelineclient.h File Reference",
"href":"cpp_ref/ipipelineclient_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ipoint2.h File Reference",
"href":"cpp_ref/ipoint2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ipoint3.h File Reference",
"href":"cpp_ref/ipoint3_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ipointcache.h File Reference",
"href":"cpp_ref/ipointcache_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: irefhierarchy.h File Reference",
"href":"cpp_ref/irefhierarchy_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: irollupsettings.h File Reference",
"href":"cpp_ref/irollupsettings_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iskincodes.h File Reference",
"href":"cpp_ref/iskincodes_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iskin.h File Reference",
"href":"cpp_ref/iskin_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ispringctrl.h File Reference",
"href":"cpp_ref/ispringctrl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: istddualvs.h File Reference",
"href":"cpp_ref/istddualvs_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: istdplug.h File Reference",
"href":"cpp_ref/istdplug_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: itreevw.h File Reference",
"href":"cpp_ref/itreevw_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iunwrap.h File Reference",
"href":"cpp_ref/iunwrap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iADTCategory.h File Reference",
"href":"cpp_ref/i_a_d_t_category_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iADTObjMgr.h File Reference",
"href":"cpp_ref/i_a_d_t_obj_mgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iADTStyle.h File Reference",
"href":"cpp_ref/i_a_d_t_style_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iBlockMgr.h File Reference",
"href":"cpp_ref/i_block_mgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iBlockRef.h File Reference",
"href":"cpp_ref/i_block_ref_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iEditNormals.h File Reference",
"href":"cpp_ref/i_edit_normals_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iEPolyMod.h File Reference",
"href":"cpp_ref/i_e_poly_mod_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iInstanceMgr.h File Reference",
"href":"cpp_ref/i_instance_mgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iLuminaire.h File Reference",
"href":"cpp_ref/i_luminaire_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iMorphByBone.h File Reference",
"href":"cpp_ref/i_morph_by_bone_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iRenderPresets.h File Reference",
"href":"cpp_ref/i_render_presets_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iSkinPose.h File Reference",
"href":"cpp_ref/i_skin_pose_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iTargetedIO.h File Reference",
"href":"cpp_ref/i_targeted_i_o_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: iTrackSet.h File Reference",
"href":"cpp_ref/i_track_set_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXrefAtmos.h File Reference",
"href":"cpp_ref/i_xref_atmos_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXrefCtrl.h File Reference",
"href":"cpp_ref/i_xref_ctrl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXrefItem.h File Reference",
"href":"cpp_ref/i_xref_item_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXrefMaterial.h File Reference",
"href":"cpp_ref/i_xref_material_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXrefObj.h File Reference",
"href":"cpp_ref/i_xref_obj_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXrefObjMgr.h File Reference",
"href":"cpp_ref/i_xref_obj_mgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXrefProxy.h File Reference",
"href":"cpp_ref/i_xref_proxy_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXRefObjMgr8.h File Reference",
"href":"cpp_ref/i_x_ref_obj_mgr8_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XRef/iXRefObjRecord.h File Reference",
"href":"cpp_ref/i_x_ref_obj_record_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/kernel.inl File Reference",
"href":"cpp_ref/kernel_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: keyreduc.h File Reference",
"href":"cpp_ref/keyreduc_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: linklist.h File Reference",
"href":"cpp_ref/linklist_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: linshape.h File Reference",
"href":"cpp_ref/linshape_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/listener.h File Reference",
"href":"cpp_ref/listener_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Lists and Functions",
"href":"cpp_ref/lists_and_functions.html",
"description":"",
"ancestors":[]},
{"title":"C++: C:/dev/doctools/doctools/proposal/projects/3ds_Max_SDK/input/lists_and_functions.txt File Reference",
"href":"cpp_ref/lists__and__functions_8txt.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/local_abstract_generic_functions.h File Reference",
"href":"cpp_ref/local__abstract__generic__functions_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/local_class.h File Reference",
"href":"cpp_ref/local__class_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/local_class_instantiations.h File Reference",
"href":"cpp_ref/local__class__instantiations_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/local_external_declarations.h File Reference",
"href":"cpp_ref/local__external__declarations_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/local_implementations.h File Reference",
"href":"cpp_ref/local__implementations_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: lockid.h File Reference",
"href":"cpp_ref/lockid_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: log.h File Reference",
"href":"cpp_ref/log_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: lslights.h File Reference",
"href":"cpp_ref/lslights_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: macrorec.h File Reference",
"href":"cpp_ref/macrorec_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: C:/dev/doctools/doctools/proposal/projects/3ds_Max_SDK/input/mainpage.txt File Reference",
"href":"cpp_ref/mainpage_8txt.html",
"description":"",
"ancestors":[]},
{"title":"C++: manipulator.h File Reference",
"href":"cpp_ref/manipulator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: marketDefaults.h File Reference",
"href":"cpp_ref/market_defaults_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/mathgeneric.inl File Reference",
"href":"cpp_ref/mathgeneric_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/math.inl File Reference",
"href":"cpp_ref/math_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: matrix2.h File Reference",
"href":"cpp_ref/matrix2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: matrix3.h File Reference",
"href":"cpp_ref/matrix3_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/matrix.inl File Reference",
"href":"cpp_ref/matrix_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxapi.h File Reference",
"href":"cpp_ref/maxapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxbinarystream.h File Reference",
"href":"cpp_ref/maxbinarystream_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxchar.h File Reference",
"href":"cpp_ref/maxchar_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/maxclasses.h File Reference",
"href":"cpp_ref/maxclasses_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxcom.h File Reference",
"href":"cpp_ref/maxcom_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxheapdirect.h File Reference",
"href":"cpp_ref/maxheapdirect_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxicon.h File Reference",
"href":"cpp_ref/maxicon_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxnet.h File Reference",
"href":"cpp_ref/maxnet_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxnet_archive.h File Reference",
"href":"cpp_ref/maxnet__archive_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxnet_file.h File Reference",
"href":"cpp_ref/maxnet__file_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxnet_job.h File Reference",
"href":"cpp_ref/maxnet__job_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxnet_manager.h File Reference",
"href":"cpp_ref/maxnet__manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxnet_platform.h File Reference",
"href":"cpp_ref/maxnet__platform_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxnet_types.h File Reference",
"href":"cpp_ref/maxnet__types_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxscript.h File Reference",
"href":"cpp_ref/maxscript_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxstring.h File Reference",
"href":"cpp_ref/maxstring_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxtess.h File Reference",
"href":"cpp_ref/maxtess_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxtextfile.h File Reference",
"href":"cpp_ref/maxtextfile_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxtypes.h File Reference",
"href":"cpp_ref/maxtypes_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxvariant.h File Reference",
"href":"cpp_ref/maxvariant_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxversion.h File Reference",
"href":"cpp_ref/maxversion_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: max.h File Reference",
"href":"cpp_ref/max_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/max_commands.inl File Reference",
"href":"cpp_ref/max__commands_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: mcapdev.h File Reference",
"href":"cpp_ref/mcapdev_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/mentalrayInMax.h File Reference",
"href":"cpp_ref/mentalray_in_max_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: meshacc.h File Reference",
"href":"cpp_ref/meshacc_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: meshadj.h File Reference",
"href":"cpp_ref/meshadj_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: meshdelta.h File Reference",
"href":"cpp_ref/meshdelta_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: meshdlib.h File Reference",
"href":"cpp_ref/meshdlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: meshlib.h File Reference",
"href":"cpp_ref/meshlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/meshselection.h File Reference",
"href":"cpp_ref/meshselection_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mesh.h File Reference",
"href":"cpp_ref/mesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Method Groups",
"href":"cpp_ref/method_groups.html",
"description":"",
"ancestors":[]},
{"title":"C++: C:/dev/doctools/doctools/proposal/projects/3ds_Max_SDK/input/method_group_pages.txt File Reference",
"href":"cpp_ref/method__group__pages_8txt.html",
"description":"",
"ancestors":[]},
{"title":"C++: midiman.h File Reference",
"href":"cpp_ref/midiman_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mnbigmat.h File Reference",
"href":"cpp_ref/mnbigmat_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mncommon.h File Reference",
"href":"cpp_ref/mncommon_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mnmath.h File Reference",
"href":"cpp_ref/mnmath_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mnmesh.h File Reference",
"href":"cpp_ref/mnmesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: modstack.h File Reference",
"href":"cpp_ref/modstack_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mouseman.h File Reference",
"href":"cpp_ref/mouseman_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mouseproc.h File Reference",
"href":"cpp_ref/mouseproc_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/mousetool.h File Reference",
"href":"cpp_ref/mousetool_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/mousetool.inl File Reference",
"href":"cpp_ref/mousetool_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/shared_src/mrShaderButtonHandler.cpp File Reference",
"href":"cpp_ref/mr_shader_button_handler_8cpp.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/shared_src/mrShaderButtonHandler.h File Reference",
"href":"cpp_ref/mr_shader_button_handler_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/shared_src/mrShaderFilter.cpp File Reference",
"href":"cpp_ref/mr_shader_filter_8cpp.html",
"description":"",
"ancestors":[]},
{"title":"C++: mentalray/shared_src/mrShaderFilter.h File Reference",
"href":"cpp_ref/mr_shader_filter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: mtl.h File Reference",
"href":"cpp_ref/mtl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/mxskeys.h File Reference",
"href":"cpp_ref/mxskeys_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/mxsmaterial.h File Reference",
"href":"cpp_ref/mxsmaterial_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/mxsobjects.h File Reference",
"href":"cpp_ref/mxsobjects_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/mxstime.h File Reference",
"href":"cpp_ref/mxstime_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/mxsplugin/mxsCustomAttributes.h File Reference",
"href":"cpp_ref/mxs_custom_attributes_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/mxsMaxFileVersion.h File Reference",
"href":"cpp_ref/mxs_max_file_version_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/mxsplugin/mxsPlugin.h File Reference",
"href":"cpp_ref/mxs_plugin_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/mxsZipPackage.h File Reference",
"href":"cpp_ref/mxs_zip_package_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: namesel.h File Reference",
"href":"cpp_ref/namesel_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATS Namespace Reference",
"href":"cpp_ref/namespace_a_t_s.html",
"description":"",
"ancestors":[]},
{"title":"C++: GFX_MESH Namespace Reference",
"href":"cpp_ref/namespace_g_f_x___m_e_s_h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ImportExportInterface Namespace Reference",
"href":"cpp_ref/namespace_import_export_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: IKSys Namespace Reference",
"href":"cpp_ref/namespace_i_k_sys.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightingModel Namespace Reference",
"href":"cpp_ref/namespace_lighting_model.html",
"description":"",
"ancestors":[]},
{"title":"C++: ManagedServices Namespace Reference",
"href":"cpp_ref/namespace_managed_services.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxGraphics Namespace Reference",
"href":"cpp_ref/namespace_max_graphics.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxGraphics::BackfaceWireframe Namespace Reference",
"href":"cpp_ref/namespace_max_graphics_1_1_backface_wireframe.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxSDK Namespace Reference",
"href":"cpp_ref/namespace_max_s_d_k.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxSDK::AssetManagement Namespace Reference",
"href":"cpp_ref/namespace_max_s_d_k_1_1_asset_management.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxSDK::CUI Namespace Reference",
"href":"cpp_ref/namespace_max_s_d_k_1_1_c_u_i.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxSDK::DebuggingTools Namespace Reference",
"href":"cpp_ref/namespace_max_s_d_k_1_1_debugging_tools.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxSDK::Graphics Namespace Reference",
"href":"cpp_ref/namespace_max_s_d_k_1_1_graphics.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxSDK::PerformanceTools Namespace Reference",
"href":"cpp_ref/namespace_max_s_d_k_1_1_performance_tools.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxSDK::Util Namespace Reference",
"href":"cpp_ref/namespace_max_s_d_k_1_1_util.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxSDK::Util::TextFile Namespace Reference",
"href":"cpp_ref/namespace_max_s_d_k_1_1_util_1_1_text_file.html",
"description":"",
"ancestors":[]},
{"title":"C++: NodeEventNamespace Namespace Reference",
"href":"cpp_ref/namespace_node_event_namespace.html",
"description":"",
"ancestors":[]},
{"title":"C++: PF Namespace Reference",
"href":"cpp_ref/namespace_p_f.html",
"description":"",
"ancestors":[]},
{"title":"C++: SceneEventNamespace Namespace Reference",
"href":"cpp_ref/namespace_scene_event_namespace.html",
"description":"",
"ancestors":[]},
{"title":"C++: UtilityInterface Namespace Reference",
"href":"cpp_ref/namespace_utility_interface.html",
"description":"",
"ancestors":[]},
{"title":"C++: nametab.h File Reference",
"href":"cpp_ref/nametab_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/name.h File Reference",
"href":"cpp_ref/name_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: naturalLight.h File Reference",
"href":"cpp_ref/natural_light_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/MaxNet.h File Reference",
"href":"cpp_ref/network_2maxnet_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: nodedisp.h File Reference",
"href":"cpp_ref/nodedisp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/node.inl File Reference",
"href":"cpp_ref/node_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/notekey.inl File Reference",
"href":"cpp_ref/notekey_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: notetrck.h File Reference",
"href":"cpp_ref/notetrck_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: notify.h File Reference",
"href":"cpp_ref/notify_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: nsclip.h File Reference",
"href":"cpp_ref/nsclip_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/numbers.h File Reference",
"href":"cpp_ref/numbers_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/objectsets.h File Reference",
"href":"cpp_ref/objectsets_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: object.h File Reference",
"href":"cpp_ref/object_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: objectClassId.h File Reference",
"href":"cpp_ref/object_class_id_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: objmode.h File Reference",
"href":"cpp_ref/objmode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: omanapi.h File Reference",
"href":"cpp_ref/omanapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: osnapapi.h File Reference",
"href":"cpp_ref/osnapapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: osnaphit.h File Reference",
"href":"cpp_ref/osnaphit_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: osnapmk.h File Reference",
"href":"cpp_ref/osnapmk_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: osnap.h File Reference",
"href":"cpp_ref/osnap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: palutil.h File Reference",
"href":"cpp_ref/palutil_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: paramtype.h File Reference",
"href":"cpp_ref/paramtype_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/compiler/parser.h File Reference",
"href":"cpp_ref/parser_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: partclib.h File Reference",
"href":"cpp_ref/partclib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: particle.h File Reference",
"href":"cpp_ref/particle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: patchcap.h File Reference",
"href":"cpp_ref/patchcap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: patchlib.h File Reference",
"href":"cpp_ref/patchlib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: patchobj.h File Reference",
"href":"cpp_ref/patchobj_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: patch.h File Reference",
"href":"cpp_ref/patch_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/pathname.h File Reference",
"href":"cpp_ref/pathname_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: pbbitmap.h File Reference",
"href":"cpp_ref/pbbitmap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/physiqueblend.inl File Reference",
"href":"cpp_ref/physiqueblend_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/physiquemod.inl File Reference",
"href":"cpp_ref/physiquemod_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/physiquevertex.inl File Reference",
"href":"cpp_ref/physiquevertex_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/pipe.h File Reference",
"href":"cpp_ref/pipe_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: pixelbuf.h File Reference",
"href":"cpp_ref/pixelbuf_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: plugapi.h File Reference",
"href":"cpp_ref/plugapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: plugin.h File Reference",
"href":"cpp_ref/plugin_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: pod.h File Reference",
"href":"cpp_ref/pod_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: point2.h File Reference",
"href":"cpp_ref/point2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: point3.h File Reference",
"href":"cpp_ref/point3_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: point4.h File Reference",
"href":"cpp_ref/point4_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: polyobj.h File Reference",
"href":"cpp_ref/polyobj_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: polyshp.h File Reference",
"href":"cpp_ref/polyshp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/primitives.inl File Reference",
"href":"cpp_ref/primitives_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: printmanager.h File Reference",
"href":"cpp_ref/printmanager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/progn.inl File Reference",
"href":"cpp_ref/progn_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: props.h File Reference",
"href":"cpp_ref/props_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ptrvec.h File Reference",
"href":"cpp_ref/ptrvec_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: quat.h File Reference",
"href":"cpp_ref/quat_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/quat.inl File Reference",
"href":"cpp_ref/quat_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: radiosity.h File Reference",
"href":"cpp_ref/radiosity_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: radiosityMesh.h File Reference",
"href":"cpp_ref/radiosity_mesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: randgenerator.h File Reference",
"href":"cpp_ref/randgenerator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: random.h File Reference",
"href":"cpp_ref/random_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/readonlytextfilestream.h File Reference",
"href":"cpp_ref/readonlytextfilestream_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: referencemgr.h File Reference",
"href":"cpp_ref/referencemgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ref.h File Reference",
"href":"cpp_ref/ref_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: renderelements.h File Reference",
"href":"cpp_ref/renderelements_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: render.h File Reference",
"href":"cpp_ref/render_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/UI/rollouts.h File Reference",
"href":"cpp_ref/rollouts_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: rtclick.h File Reference",
"href":"cpp_ref/rtclick_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: samplers.h File Reference",
"href":"cpp_ref/samplers_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: sbmtlapi.h File Reference",
"href":"cpp_ref/sbmtlapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: sceneapi.h File Reference",
"href":"cpp_ref/sceneapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/sceneio.h File Reference",
"href":"cpp_ref/sceneio_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: scenetraversal.h File Reference",
"href":"cpp_ref/scenetraversal_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/scriptcontroller.h File Reference",
"href":"cpp_ref/scriptcontroller_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/editor/scripteditor.h File Reference",
"href":"cpp_ref/scripteditor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/script_resource_file_utils.h File Reference",
"href":"cpp_ref/script__resource__file__utils_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/maxwrapper/selectionsets.h File Reference",
"href":"cpp_ref/selectionsets_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: setkeymode.h File Reference",
"href":"cpp_ref/setkeymode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: sfx.h File Reference",
"href":"cpp_ref/sfx_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: shadbuf.h File Reference",
"href":"cpp_ref/shadbuf_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: shaders.h File Reference",
"href":"cpp_ref/shaders_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: shadgen.h File Reference",
"href":"cpp_ref/shadgen_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/shadows.inl File Reference",
"href":"cpp_ref/shadows_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: shape.h File Reference",
"href":"cpp_ref/shape_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: shphier.h File Reference",
"href":"cpp_ref/shphier_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: shpsels.h File Reference",
"href":"cpp_ref/shpsels_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: simpmod.h File Reference",
"href":"cpp_ref/simpmod_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: simpobj.h File Reference",
"href":"cpp_ref/simpobj_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: simpshp.h File Reference",
"href":"cpp_ref/simpshp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: simpspl.h File Reference",
"href":"cpp_ref/simpspl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: snap.h File Reference",
"href":"cpp_ref/snap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: soundobj.h File Reference",
"href":"cpp_ref/soundobj_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: spacearraycallback.h File Reference",
"href":"cpp_ref/spacearraycallback_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: spline3d.h File Reference",
"href":"cpp_ref/spline3d_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: splshape.h File Reference",
"href":"cpp_ref/splshape_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: springsys.h File Reference",
"href":"cpp_ref/springsys_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: sse.h File Reference",
"href":"cpp_ref/sse_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: stack3.h File Reference",
"href":"cpp_ref/stack3_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: stack.h File Reference",
"href":"cpp_ref/stack_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: stdmat.h File Reference",
"href":"cpp_ref/stdmat_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: strbasic.h File Reference",
"href":"cpp_ref/strbasic_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: strclass.h File Reference",
"href":"cpp_ref/strclass_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/streams.h File Reference",
"href":"cpp_ref/streams_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/streams.inl File Reference",
"href":"cpp_ref/streams_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/strings.h File Reference",
"href":"cpp_ref/strings_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/strings.inl File Reference",
"href":"cpp_ref/strings_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: binding Struct Reference",
"href":"cpp_ref/structbinding.html",
"description":"",
"ancestors":[]},
{"title":"C++: bindShape Struct Reference",
"href":"cpp_ref/structbind_shape.html",
"description":"",
"ancestors":[]},
{"title":"C++: class_key Struct Reference",
"href":"cpp_ref/structclass__key.html",
"description":"",
"ancestors":[]},
{"title":"C++: class_table Struct Reference",
"href":"cpp_ref/structclass__table.html",
"description":"",
"ancestors":[]},
{"title":"C++: edit_window Struct Reference",
"href":"cpp_ref/structedit__window.html",
"description":"",
"ancestors":[]},
{"title":"C++: free_mem Struct Reference",
"href":"cpp_ref/structfree__mem.html",
"description":"",
"ancestors":[]},
{"title":"C++: gbuff_chan_code Struct Reference",
"href":"cpp_ref/structgbuff__chan__code.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrLightTranslation::AreaPrimitive::AreaLight_cylinder Struct Reference",
"href":"cpp_ref/structimr_light_translation_1_1_area_primitive_1_1_area_light__cylinder.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrLightTranslation::AreaPrimitive::AreaLight_disc Struct Reference",
"href":"cpp_ref/structimr_light_translation_1_1_area_primitive_1_1_area_light__disc.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrLightTranslation::AreaPrimitive::AreaLight_rectangle Struct Reference",
"href":"cpp_ref/structimr_light_translation_1_1_area_primitive_1_1_area_light__rectangle.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrLightTranslation::AreaPrimitive::AreaLight_sphere Struct Reference",
"href":"cpp_ref/structimr_light_translation_1_1_area_primitive_1_1_area_light__sphere.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrLightTranslation::VectorStruct Struct Reference",
"href":"cpp_ref/structimr_light_translation_1_1_vector_struct.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrShaderTranslation::AdditionalDependency Struct Reference",
"href":"cpp_ref/structimr_shader_translation_1_1_additional_dependency.html",
"description":"",
"ancestors":[]},
{"title":"C++: layout_data Struct Reference",
"href":"cpp_ref/structlayout__data.html",
"description":"",
"ancestors":[]},
{"title":"C++: mbm_window Struct Reference",
"href":"cpp_ref/structmbm__window.html",
"description":"",
"ancestors":[]},
{"title":"C++: message_box_data Struct Reference",
"href":"cpp_ref/structmessage__box__data.html",
"description":"",
"ancestors":[]},
{"title":"C++: node_find Struct Reference",
"href":"cpp_ref/structnode__find.html",
"description":"",
"ancestors":[]},
{"title":"C++: node_get Struct Reference",
"href":"cpp_ref/structnode__get.html",
"description":"",
"ancestors":[]},
{"title":"C++: node_map Struct Reference",
"href":"cpp_ref/structnode__map.html",
"description":"",
"ancestors":[]},
{"title":"C++: parm_desc Struct Reference",
"href":"cpp_ref/structparm__desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: property_accessors Struct Reference",
"href":"cpp_ref/structproperty__accessors.html",
"description":"",
"ancestors":[]},
{"title":"C++: rollout_control Struct Reference",
"href":"cpp_ref/structrollout__control.html",
"description":"",
"ancestors":[]},
{"title":"C++: secondary Struct Reference",
"href":"cpp_ref/structsecondary.html",
"description":"",
"ancestors":[]},
{"title":"C++: superclass_table Struct Reference",
"href":"cpp_ref/structsuperclass__table.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/structs.h File Reference",
"href":"cpp_ref/structs_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: z_stream_s Struct Reference",
"href":"cpp_ref/structz__stream__s.html",
"description":"",
"ancestors":[]},
{"title":"C++: ActionDescription Struct Reference",
"href":"cpp_ref/struct_action_description.html",
"description":"",
"ancestors":[]},
{"title":"C++: AffineParts Struct Reference",
"href":"cpp_ref/struct_affine_parts.html",
"description":"",
"ancestors":[]},
{"title":"C++: AlertData Struct Reference",
"href":"cpp_ref/struct_alert_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMMBitmapList Struct Reference",
"href":"cpp_ref/struct_b_m_m_bitmap_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMMFilterList Struct Reference",
"href":"cpp_ref/struct_b_m_m_filter_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMMGammaSettings Struct Reference",
"href":"cpp_ref/struct_b_m_m_gamma_settings.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMMImageInfo Struct Reference",
"href":"cpp_ref/struct_b_m_m_image_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMMStorageList Struct Reference",
"href":"cpp_ref/struct_b_m_m_storage_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMMVfbPalette Struct Reference",
"href":"cpp_ref/struct_b_m_m_vfb_palette.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_Color_24 Struct Reference",
"href":"cpp_ref/struct_b_m_m___color__24.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_Color_32 Struct Reference",
"href":"cpp_ref/struct_b_m_m___color__32.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_Color_48 Struct Reference",
"href":"cpp_ref/struct_b_m_m___color__48.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_Color_64 Struct Reference",
"href":"cpp_ref/struct_b_m_m___color__64.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_Color_fl Struct Reference",
"href":"cpp_ref/struct_b_m_m___color__fl.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_Pyramid Struct Reference",
"href":"cpp_ref/struct_b_m_m___pyramid.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMM_SAT Struct Reference",
"href":"cpp_ref/struct_b_m_m___s_a_t.html",
"description":"",
"ancestors":[]},
{"title":"C++: CameraState Struct Reference",
"href":"cpp_ref/struct_camera_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: ClassDescReplaced Struct Reference",
"href":"cpp_ref/struct_class_desc_replaced.html",
"description":"",
"ancestors":[]},
{"title":"C++: ClientInfo Struct Reference",
"href":"cpp_ref/struct_client_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: Color24 Struct Reference",
"href":"cpp_ref/struct_color24.html",
"description":"",
"ancestors":[]},
{"title":"C++: Color48 Struct Reference",
"href":"cpp_ref/struct_color48.html",
"description":"",
"ancestors":[]},
{"title":"C++: Color64 Struct Reference",
"href":"cpp_ref/struct_color64.html",
"description":"",
"ancestors":[]},
{"title":"C++: CombustionJob Struct Reference",
"href":"cpp_ref/struct_combustion_job.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConfigurationBlock Struct Reference",
"href":"cpp_ref/struct_configuration_block.html",
"description":"",
"ancestors":[]},
{"title":"C++: ConstraintInOut Struct Reference",
"href":"cpp_ref/struct_constraint_in_out.html",
"description":"",
"ancestors":[]},
{"title":"C++: CIRCLE Struct Reference",
"href":"cpp_ref/struct_c_i_r_c_l_e.html",
"description":"",
"ancestors":[]},
{"title":"C++: D3D10SceneLight Struct Reference",
"href":"cpp_ref/struct_d3_d10_scene_light.html",
"description":"",
"ancestors":[]},
{"title":"C++: DelayedMatrix3::DelayedOp Struct Reference",
"href":"cpp_ref/struct_delayed_matrix3_1_1_delayed_op.html",
"description":"",
"ancestors":[]},
{"title":"C++: DelayedMatrix3::OpQueue Struct Reference",
"href":"cpp_ref/struct_delayed_matrix3_1_1_op_queue.html",
"description":"",
"ancestors":[]},
{"title":"C++: DispInfo Struct Reference",
"href":"cpp_ref/struct_disp_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: DumpValueData Struct Reference",
"href":"cpp_ref/struct_dump_value_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: DxGeneralFunctions Struct Reference",
"href":"cpp_ref/struct_dx_general_functions.html",
"description":"",
"ancestors":[]},
{"title":"C++: DX8VSConstant Struct Reference",
"href":"cpp_ref/struct_d_x8_v_s_constant.html",
"description":"",
"ancestors":[]},
{"title":"C++: DX9VSConstant Struct Reference",
"href":"cpp_ref/struct_d_x9_v_s_constant.html",
"description":"",
"ancestors":[]},
{"title":"C++: Edge Struct Reference",
"href":"cpp_ref/struct_edge.html",
"description":"",
"ancestors":[]},
{"title":"C++: EditFileResult Struct Reference",
"href":"cpp_ref/struct_edit_file_result.html",
"description":"",
"ancestors":[]},
{"title":"C++: EffectsInfo Struct Reference",
"href":"cpp_ref/struct_effects_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: FlectForces Struct Reference",
"href":"cpp_ref/struct_flect_forces.html",
"description":"",
"ancestors":[]},
{"title":"C++: FBox2 Struct Reference",
"href":"cpp_ref/struct_f_box2.html",
"description":"",
"ancestors":[]},
{"title":"C++: FPEnum::enum_code Struct Reference",
"href":"cpp_ref/struct_f_p_enum_1_1enum__code.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenEdge Struct Reference",
"href":"cpp_ref/struct_gen_edge.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenFace Struct Reference",
"href":"cpp_ref/struct_gen_face.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenSoftSelData Struct Reference",
"href":"cpp_ref/struct_gen_soft_sel_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenTri Struct Reference",
"href":"cpp_ref/struct_gen_tri.html",
"description":"",
"ancestors":[]},
{"title":"C++: GenTriPoints Struct Reference",
"href":"cpp_ref/struct_gen_tri_points.html",
"description":"",
"ancestors":[]},
{"title":"C++: GetBoundBoxRequestData Struct Reference",
"href":"cpp_ref/struct_get_bound_box_request_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: GetParticleDataRequest Struct Reference",
"href":"cpp_ref/struct_get_particle_data_request.html",
"description":"",
"ancestors":[]},
{"title":"C++: GetSubObjectRequestData Struct Reference",
"href":"cpp_ref/struct_get_sub_object_request_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: GetTimeDataRequest Struct Reference",
"href":"cpp_ref/struct_get_time_data_request.html",
"description":"",
"ancestors":[]},
{"title":"C++: Groupdata Struct Reference",
"href":"cpp_ref/struct_groupdata.html",
"description":"",
"ancestors":[]},
{"title":"C++: GBufData Struct Reference",
"href":"cpp_ref/struct_g_buf_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: HitTestRequestData Struct Reference",
"href":"cpp_ref/struct_hit_test_request_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: HSERVER Struct Reference",
"href":"cpp_ref/struct_h_s_e_r_v_e_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBaseGrip::ComboLabel Struct Reference",
"href":"cpp_ref/struct_i_base_grip_1_1_combo_label.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBaseGrip::GripValue Struct Reference",
"href":"cpp_ref/struct_i_base_grip_1_1_grip_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightControlledLightSystem::DaylightSimulationParams Struct Reference",
"href":"cpp_ref/struct_i_daylight_controlled_light_system_1_1_daylight_simulation_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGeometryChecker::OutputVal Struct Reference",
"href":"cpp_ref/struct_i_geometry_checker_1_1_output_val.html",
"description":"",
"ancestors":[]},
{"title":"C++: DofSet Struct Reference",
"href":"cpp_ref/struct_i_k_sys_1_1_dof_set.html",
"description":"",
"ancestors":[]},
{"title":"C++: IterJoint::JointAxes Struct Reference",
"href":"cpp_ref/struct_i_k_sys_1_1_iter_joint_1_1_joint_axes.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMetaDataManager::ParamDescriptor Struct Reference",
"href":"cpp_ref/struct_i_meta_data_manager_1_1_param_descriptor.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionRenderHandler::ProjectionResult Struct Reference",
"href":"cpp_ref/struct_i_projection_render_handler_1_1_projection_result.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISect Struct Reference",
"href":"cpp_ref/struct_i_sect.html",
"description":"",
"ancestors":[]},
{"title":"C++: IVertexPaint::FaceColor Struct Reference",
"href":"cpp_ref/struct_i_vertex_paint_1_1_face_color.html",
"description":"",
"ancestors":[]},
{"title":"C++: Job Struct Reference",
"href":"cpp_ref/struct_job.html",
"description":"",
"ancestors":[]},
{"title":"C++: JobList Struct Reference",
"href":"cpp_ref/struct_job_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: JobRenderElement Struct Reference",
"href":"cpp_ref/struct_job_render_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: JobServer Struct Reference",
"href":"cpp_ref/struct_job_server.html",
"description":"",
"ancestors":[]},
{"title":"C++: JobText Struct Reference",
"href":"cpp_ref/struct_job_text.html",
"description":"",
"ancestors":[]},
{"title":"C++: JOBFRAMES Struct Reference",
"href":"cpp_ref/struct_j_o_b_f_r_a_m_e_s.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightDispInfo Struct Reference",
"href":"cpp_ref/struct_light_disp_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightState Struct Reference",
"href":"cpp_ref/struct_light_state.html",
"description":"",
"ancestors":[]},
{"title":"C++: LoadSubAnimInfo Struct Reference",
"href":"cpp_ref/struct_load_sub_anim_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: LogLUV24Pixel Struct Reference",
"href":"cpp_ref/struct_log_l_u_v24_pixel.html",
"description":"",
"ancestors":[]},
{"title":"C++: LogLUV32Pixel Struct Reference",
"href":"cpp_ref/struct_log_l_u_v32_pixel.html",
"description":"",
"ancestors":[]},
{"title":"C++: StringConverter< char_type > Struct Template Reference",
"href":"cpp_ref/struct_managed_services_1_1_string_converter.html",
"description":"",
"ancestors":[]},
{"title":"C++: ManagerInfo Struct Reference",
"href":"cpp_ref/struct_manager_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxJob Struct Reference",
"href":"cpp_ref/struct_max_job.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxJobRenderElements Struct Reference",
"href":"cpp_ref/struct_max_job_render_elements.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetId Struct Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_asset_management_1_1_asset_id.html",
"description":"",
"ancestors":[]},
{"title":"C++: AutoPtrRef< OtherType > Struct Template Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_auto_ptr_ref.html",
"description":"",
"ancestors":[]},
{"title":"C++: DeviceCaps Struct Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_graphics_1_1_device_caps.html",
"description":"",
"ancestors":[]},
{"title":"C++: HLSLMaterialHandle::ParameterDesc Struct Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_graphics_1_1_h_l_s_l_material_handle_1_1_parameter_desc.html",
"description":"",
"ancestors":[]},
{"title":"C++: LockedRect Struct Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_graphics_1_1_locked_rect.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaterialRequiredStreamElement Struct Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_graphics_1_1_material_required_stream_element.html",
"description":"",
"ancestors":[]},
{"title":"C++: SimpleVertexStream Struct Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_graphics_1_1_simple_vertex_stream.html",
"description":"",
"ancestors":[]},
{"title":"C++: TextureCoordStream Struct Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_graphics_1_1_texture_coord_stream.html",
"description":"",
"ancestors":[]},
{"title":"C++: StaticAssert< true > Struct Template Reference",
"href":"cpp_ref/struct_max_s_d_k_1_1_util_1_1_static_assert_3_01true_01_4.html",
"description":"",
"ancestors":[]},
{"title":"C++: MenuEvent Struct Reference",
"href":"cpp_ref/struct_menu_event.html",
"description":"",
"ancestors":[]},
{"title":"C++: MAXScript_TLS Struct Reference",
"href":"cpp_ref/struct_m_a_x_script___t_l_s.html",
"description":"",
"ancestors":[]},
{"title":"C++: NameChange Struct Reference",
"href":"cpp_ref/struct_name_change.html",
"description":"",
"ancestors":[]},
{"title":"C++: NetworkStatus Struct Reference",
"href":"cpp_ref/struct_network_status.html",
"description":"",
"ancestors":[]},
{"title":"C++: NotifyCustomAttribute Struct Reference",
"href":"cpp_ref/struct_notify_custom_attribute.html",
"description":"",
"ancestors":[]},
{"title":"C++: NotifyInfo Struct Reference",
"href":"cpp_ref/struct_notify_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: NotifyPreEval_FrameInfo Struct Reference",
"href":"cpp_ref/struct_notify_pre_eval___frame_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: NET_ARCHIVE_HEADER Struct Reference",
"href":"cpp_ref/struct_n_e_t___a_r_c_h_i_v_e___h_e_a_d_e_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: NET_ARCHIVE_LIST Struct Reference",
"href":"cpp_ref/struct_n_e_t___a_r_c_h_i_v_e___l_i_s_t.html",
"description":"",
"ancestors":[]},
{"title":"C++: ObjectDefinitionChangeNotificationParam Struct Reference",
"href":"cpp_ref/struct_object_definition_change_notification_param.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamAlias Struct Reference",
"href":"cpp_ref/struct_param_alias.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamBlockDesc2::map_spec Struct Reference",
"href":"cpp_ref/struct_param_block_desc2_1_1map__spec.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamDef Struct Reference",
"href":"cpp_ref/struct_param_def.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleID Struct Reference",
"href":"cpp_ref/struct_particle_i_d.html",
"description":"",
"ancestors":[]},
{"title":"C++: PerformOut Struct Reference",
"href":"cpp_ref/struct_perform_out.html",
"description":"",
"ancestors":[]},
{"title":"C++: PB2Value Struct Reference",
"href":"cpp_ref/struct_p_b2_value.html",
"description":"",
"ancestors":[]},
{"title":"C++: PFActiveActionDataRequest Struct Reference",
"href":"cpp_ref/struct_p_f_active_action_data_request.html",
"description":"",
"ancestors":[]},
{"title":"C++: RealPixel Struct Reference",
"href":"cpp_ref/struct_real_pixel.html",
"description":"",
"ancestors":[]},
{"title":"C++: SaveSubAnimInfo Struct Reference",
"href":"cpp_ref/struct_save_sub_anim_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: SceneInfo Struct Reference",
"href":"cpp_ref/struct_scene_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: Schedule Struct Reference",
"href":"cpp_ref/struct_schedule.html",
"description":"",
"ancestors":[]},
{"title":"C++: ServerInfo Struct Reference",
"href":"cpp_ref/struct_server_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: ServerList Struct Reference",
"href":"cpp_ref/struct_server_list.html",
"description":"",
"ancestors":[]},
{"title":"C++: Slot Struct Reference",
"href":"cpp_ref/struct_slot.html",
"description":"",
"ancestors":[]},
{"title":"C++: SnapInfo Struct Reference",
"href":"cpp_ref/struct_snap_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: SourceInfo Struct Reference",
"href":"cpp_ref/struct_source_info.html",
"description":"",
"ancestors":[]},
{"title":"C++: SphereData Struct Reference",
"href":"cpp_ref/struct_sphere_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: Statistics Struct Reference",
"href":"cpp_ref/struct_statistics.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubRendParams Struct Reference",
"href":"cpp_ref/struct_sub_rend_params.html",
"description":"",
"ancestors":[]},
{"title":"C++: SurfTabEntry Struct Reference",
"href":"cpp_ref/struct_surf_tab_entry.html",
"description":"",
"ancestors":[]},
{"title":"C++: TabHdr Struct Reference",
"href":"cpp_ref/struct_tab_hdr.html",
"description":"",
"ancestors":[]},
{"title":"C++: TangentBasis Struct Reference",
"href":"cpp_ref/struct_tangent_basis.html",
"description":"",
"ancestors":[]},
{"title":"C++: TextBufferOutput Struct Reference",
"href":"cpp_ref/struct_text_buffer_output.html",
"description":"",
"ancestors":[]},
{"title":"C++: TABDLG_NMHDR Struct Reference",
"href":"cpp_ref/struct_t_a_b_d_l_g___n_m_h_d_r.html",
"description":"",
"ancestors":[]},
{"title":"C++: TMComponentsArg Struct Reference",
"href":"cpp_ref/struct_t_m_components_arg.html",
"description":"",
"ancestors":[]},
{"title":"C++: UserCoord Struct Reference",
"href":"cpp_ref/struct_user_coord.html",
"description":"",
"ancestors":[]},
{"title":"C++: ViewWindowMetaData Struct Reference",
"href":"cpp_ref/struct_view_window_meta_data.html",
"description":"",
"ancestors":[]},
{"title":"C++: WeekSchedule Struct Reference",
"href":"cpp_ref/struct_week_schedule.html",
"description":"",
"ancestors":[]},
{"title":"C++: surflib.h File Reference",
"href":"cpp_ref/surflib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: surf_api.h File Reference",
"href":"cpp_ref/surf__api_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: svcore.h File Reference",
"href":"cpp_ref/svcore_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: systemutilities.h File Reference",
"href":"cpp_ref/systemutilities_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: tab.h File Reference",
"href":"cpp_ref/tab_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: tcbgraph.h File Reference",
"href":"cpp_ref/tcbgraph_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: templt.h File Reference",
"href":"cpp_ref/templt_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: tessint.h File Reference",
"href":"cpp_ref/tessint_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/textures.inl File Reference",
"href":"cpp_ref/textures_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: texutil.h File Reference",
"href":"cpp_ref/texutil_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/thread_locals.inl File Reference",
"href":"cpp_ref/thread__locals_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/compiler/thunks.h File Reference",
"href":"cpp_ref/thunks_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/timefunctions.inl File Reference",
"href":"cpp_ref/timefunctions_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/time.inl File Reference",
"href":"cpp_ref/time_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: toneop.h File Reference",
"href":"cpp_ref/toneop_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: toolmap.h File Reference",
"href":"cpp_ref/toolmap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/transform.inl File Reference",
"href":"cpp_ref/transform_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: trig.h File Reference",
"href":"cpp_ref/trig_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: triobj.h File Reference",
"href":"cpp_ref/triobj_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: tvnode.h File Reference",
"href":"cpp_ref/tvnode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: tvutil.h File Reference",
"href":"cpp_ref/tvutil_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/UI/uiextend.h File Reference",
"href":"cpp_ref/uiextend_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: imrLightTranslation::AreaPrimitive Union Reference",
"href":"cpp_ref/unionimr_light_translation_1_1_area_primitive.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaterialRequiredStreamElement::DataUnion Union Reference",
"href":"cpp_ref/union_max_s_d_k_1_1_graphics_1_1_material_required_stream_element_1_1_data_union.html",
"description":"",
"ancestors":[]},
{"title":"C++: RasterizerState::DepthBias Union Reference",
"href":"cpp_ref/union_max_s_d_k_1_1_graphics_1_1_rasterizer_state_1_1_depth_bias.html",
"description":"",
"ancestors":[]},
{"title":"C++: units.h File Reference",
"href":"cpp_ref/units_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: utilapi.h File Reference",
"href":"cpp_ref/utilapi_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: utilexp.h File Reference",
"href":"cpp_ref/utilexp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: utilintf.h File Reference",
"href":"cpp_ref/utilintf_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: utillib.h File Reference",
"href":"cpp_ref/utillib_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/kernel/value.h File Reference",
"href":"cpp_ref/value_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/macros/value_locals.h File Reference",
"href":"cpp_ref/value__locals_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/vector.inl File Reference",
"href":"cpp_ref/vector_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: vedge.h File Reference",
"href":"cpp_ref/vedge_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: viewfile.h File Reference",
"href":"cpp_ref/viewfile_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/visualmaxscript.h File Reference",
"href":"cpp_ref/visualmaxscript_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: winutil.h File Reference",
"href":"cpp_ref/winutil_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: wrangler.h File Reference",
"href":"cpp_ref/wrangler_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/protocols/xrefs.inl File Reference",
"href":"cpp_ref/xrefs_8inl.html",
"description":"",
"ancestors":[]},
{"title":"C++: xtcobject.h File Reference",
"href":"cpp_ref/xtcobject_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: zlibdll.h File Reference",
"href":"cpp_ref/zlibdll_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Animatable.h File Reference",
"href":"cpp_ref/_animatable_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimatableFlags.h File Reference",
"href":"cpp_ref/_animatable_flags_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimatableInterfaceIDs.h File Reference",
"href":"cpp_ref/_animatable_interface_i_ds_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/AnimationWBImp.h File Reference",
"href":"cpp_ref/_animation_w_b_imp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimAppData.h File Reference",
"href":"cpp_ref/_anim_app_data_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimEnum.h File Reference",
"href":"cpp_ref/_anim_enum_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimProperty.h File Reference",
"href":"cpp_ref/_anim_property_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimPropertyID.h File Reference",
"href":"cpp_ref/_anim_property_i_d_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AnimPropertyList.h File Reference",
"href":"cpp_ref/_anim_property_list_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AppDataChunk.h File Reference",
"href":"cpp_ref/_app_data_chunk_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: containers/Array.h File Reference",
"href":"cpp_ref/_array_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: containers/Array.imp.h File Reference",
"href":"cpp_ref/_array_8imp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: containers/Array.inline.h File Reference",
"href":"cpp_ref/_array_8inline_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetEnumCallback.h File Reference",
"href":"cpp_ref/_asset_enum_callback_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetManagement/AssetId.h File Reference",
"href":"cpp_ref/_asset_id_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetManagement/AssetType.h File Reference",
"href":"cpp_ref/_asset_type_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetManagement/AssetUser.h File Reference",
"href":"cpp_ref/_asset_user_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/AtomicRefCounter.h File Reference",
"href":"cpp_ref/_atomic_ref_counter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Util/BailOut.h File Reference",
"href":"cpp_ref/_bail_out_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/BaseMaterialHandle.h File Reference",
"href":"cpp_ref/_base_material_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/BaseRasterHandle.h File Reference",
"href":"cpp_ref/_base_raster_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/Biped10Api.h File Reference",
"href":"cpp_ref/_biped10_api_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/Biped11Api.h File Reference",
"href":"cpp_ref/_biped11_api_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/Biped12Api.h File Reference",
"href":"cpp_ref/_biped12_api_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/Biped8Api.h File Reference",
"href":"cpp_ref/_biped8_api_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/Biped9Api.h File Reference",
"href":"cpp_ref/_biped9_api_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/BipedApi.h File Reference",
"href":"cpp_ref/_biped_api_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: BuildWarnings.h File Reference",
"href":"cpp_ref/_build_warnings_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/BIPEXP.H File Reference",
"href":"cpp_ref/_b_i_p_e_x_p_8_h.html",
"description":"",
"ancestors":[]},
{"title":"C++: BMMExport.h File Reference",
"href":"cpp_ref/_b_m_m_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/CharBinaryStream.h File Reference",
"href":"cpp_ref/_char_binary_stream_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/CharStream.h File Reference",
"href":"cpp_ref/_char_stream_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/ClientInfo.h File Reference",
"href":"cpp_ref/_client_info_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/ConfigurationBlock.h File Reference",
"href":"cpp_ref/_configuration_block_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CoreExport.h File Reference",
"href":"cpp_ref/_core_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CoreFunctions.h File Reference",
"href":"cpp_ref/_core_functions_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/CreatedChannelLinker.h File Reference",
"href":"cpp_ref/_created_channel_linker_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/CustomRenderItemHandle.h File Reference",
"href":"cpp_ref/_custom_render_item_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/CSConstants.h File Reference",
"href":"cpp_ref/_c_s_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/DataBridgeExport.h File Reference",
"href":"cpp_ref/_data_bridge_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ManagedServices/DataNodeWrapper.h File Reference",
"href":"cpp_ref/_data_node_wrapper_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: DebuggingTools.h File Reference",
"href":"cpp_ref/_debugging_tools_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: DefaultActions.H File Reference",
"href":"cpp_ref/_default_actions_8_h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/DeviceCaps.h File Reference",
"href":"cpp_ref/_device_caps_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/DisplayCallbackContext.h File Reference",
"href":"cpp_ref/_display_callback_context_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/DrawContext.h File Reference",
"href":"cpp_ref/_draw_context_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: EditParamFlags.h File Reference",
"href":"cpp_ref/_edit_param_flags_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: EditSoftSelectionMode.h File Reference",
"href":"cpp_ref/_edit_soft_selection_mode_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ExcludeListConstants.h File Reference",
"href":"cpp_ref/_exclude_list_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: FileEnumConstants.h File Reference",
"href":"cpp_ref/_file_enum_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/FileStream.h File Reference",
"href":"cpp_ref/_file_stream_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: FLTExport.h File Reference",
"href":"cpp_ref/_f_l_t_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/GenerateMeshRenderItemsContext.h File Reference",
"href":"cpp_ref/_generate_mesh_render_items_context_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/GeometryEnums.h File Reference",
"href":"cpp_ref/_geometry_enums_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/GeometryRenderItemHandle.h File Reference",
"href":"cpp_ref/_geometry_render_item_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: GeomExport.h File Reference",
"href":"cpp_ref/_geom_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: GeoTableItem.h File Reference",
"href":"cpp_ref/_geo_table_item_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: GetCOREInterface.h File Reference",
"href":"cpp_ref/_get_c_o_r_e_interface_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: GetResourceString.h File Reference",
"href":"cpp_ref/_get_resource_string_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: GraphicsConstants.h File Reference",
"href":"cpp_ref/_graphics_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/GraphicsEnums.h File Reference",
"href":"cpp_ref/_graphics_enums_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/GraphicsExport.h File Reference",
"href":"cpp_ref/_graphics_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: GraphicsTypes.h File Reference",
"href":"cpp_ref/_graphics_types_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: GraphicsViewportColorConstants.h File Reference",
"href":"cpp_ref/_graphics_viewport_color_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: GraphicsWindow.h File Reference",
"href":"cpp_ref/_graphics_window_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: HoldBegin.h File Reference",
"href":"cpp_ref/_hold_begin_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/HLSLMaterialHandle.h File Reference",
"href":"cpp_ref/_h_l_s_l_material_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWIndex.h File Reference",
"href":"cpp_ref/_h_w_index_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWMesh.h File Reference",
"href":"cpp_ref/_h_w_mesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: HWVertex.h File Reference",
"href":"cpp_ref/_h_w_vertex_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/ImmediateFragment.h File Reference",
"href":"cpp_ref/_immediate_fragment_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/ImmediateRenderItemHandle.h File Reference",
"href":"cpp_ref/_immediate_render_item_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IndexBufferHandle.h File Reference",
"href":"cpp_ref/_index_buffer_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Util/IniUtil.h File Reference",
"href":"cpp_ref/_ini_util_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IActionItemOverrideManager.h File Reference",
"href":"cpp_ref/_i_action_item_override_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: AssetManagement/IAssetAccessor.h File Reference",
"href":"cpp_ref/_i_asset_accessor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IAutoTangentMan.h File Reference",
"href":"cpp_ref/_i_auto_tangent_man_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATS/IATSCustomDeps.h File Reference",
"href":"cpp_ref/_i_a_t_s_custom_deps_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATS/IATSMax.h File Reference",
"href":"cpp_ref/_i_a_t_s_max_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATS/IATSNotifications.h File Reference",
"href":"cpp_ref/_i_a_t_s_notifications_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATS/IATSProvider.h File Reference",
"href":"cpp_ref/_i_a_t_s_provider_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ATS/IATSProviderExport.h File Reference",
"href":"cpp_ref/_i_a_t_s_provider_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBatchRenderManager.h File Reference",
"href":"cpp_ref/_i_batch_render_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBlobMesh.h File Reference",
"href":"cpp_ref/_i_blob_mesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IBrushPresets.h File Reference",
"href":"cpp_ref/_i_brush_presets_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IChannelContainer.h File Reference",
"href":"cpp_ref/_i_channel_container_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IColorCorrectionMgr.h File Reference",
"href":"cpp_ref/_i_color_correction_mgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICompositeShader.h File Reference",
"href":"cpp_ref/_i_composite_shader_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IContainerManager.h File Reference",
"href":"cpp_ref/_i_container_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IContainerObject.h File Reference",
"href":"cpp_ref/_i_container_object_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IConversionManager.h File Reference",
"href":"cpp_ref/_i_conversion_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/ICustomRenderItem.h File Reference",
"href":"cpp_ref/_i_custom_render_item_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICustAttribCollapseManager.h File Reference",
"href":"cpp_ref/_i_cust_attrib_collapse_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ICUIMouseConfigManager.h File Reference",
"href":"cpp_ref/_i_c_u_i_mouse_config_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightControlledLightSystem.h File Reference",
"href":"cpp_ref/_i_daylight_controlled_light_system_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDaylightSystem.h File Reference",
"href":"cpp_ref/_i_daylight_system_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDialogMonitor.h File Reference",
"href":"cpp_ref/_i_dialog_monitor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IDisplayCallback.h File Reference",
"href":"cpp_ref/_i_display_callback_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IDisplayManager.h File Reference",
"href":"cpp_ref/_i_display_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IDisposable.h File Reference",
"href":"cpp_ref/_i_disposable_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Util/IDlgShowingStatusForPolyObj.h File Reference",
"href":"cpp_ref/_i_dlg_showing_status_for_poly_obj_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDxMaterial.h File Reference",
"href":"cpp_ref/_i_dx_material_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IDX10HardwareRenderer.h File Reference",
"href":"cpp_ref/_i_d_x10_hardware_renderer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFileResolutionManager.h File Reference",
"href":"cpp_ref/_i_file_resolution_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IFrameTagManager.h File Reference",
"href":"cpp_ref/_i_frame_tag_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGame.h File Reference",
"href":"cpp_ref/_i_game_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameControl.h File Reference",
"href":"cpp_ref/_i_game_control_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameError.h File Reference",
"href":"cpp_ref/_i_game_error_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameExport.h File Reference",
"href":"cpp_ref/_i_game_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameFX.h File Reference",
"href":"cpp_ref/_i_game_f_x_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameMaterial.h File Reference",
"href":"cpp_ref/_i_game_material_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameModifier.h File Reference",
"href":"cpp_ref/_i_game_modifier_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameObject.h File Reference",
"href":"cpp_ref/_i_game_object_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameProperty.h File Reference",
"href":"cpp_ref/_i_game_property_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameRenderedSurface.h File Reference",
"href":"cpp_ref/_i_game_rendered_surface_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameStd.h File Reference",
"href":"cpp_ref/_i_game_std_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IGameType.h File Reference",
"href":"cpp_ref/_i_game_type_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGeometryChecker.h File Reference",
"href":"cpp_ref/_i_geometry_checker_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGlobalDXDisplayManager.h File Reference",
"href":"cpp_ref/_i_global_d_x_display_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IHeightManager.h File Reference",
"href":"cpp_ref/_i_height_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IHLSLMaterialTranslator.h File Reference",
"href":"cpp_ref/_i_h_l_s_l_material_translator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIndirectRefMaker.h File Reference",
"href":"cpp_ref/_i_indirect_ref_maker_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IIndirectRefTargContainer.h File Reference",
"href":"cpp_ref/_i_indirect_ref_targ_container_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IICEFlowFileBirthSetup.h File Reference",
"href":"cpp_ref/_i_i_c_e_flow_file_birth_setup_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IICEFlowParticleFactory.h File Reference",
"href":"cpp_ref/_i_i_c_e_flow_particle_factory_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IICEFlowShapeControl.h File Reference",
"href":"cpp_ref/_i_i_c_e_flow_shape_control_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILayerControl.h File Reference",
"href":"cpp_ref/_i_layer_control_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILayerProperties.h File Reference",
"href":"cpp_ref/_i_layer_properties_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILightingUnits.h File Reference",
"href":"cpp_ref/_i_lighting_units_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILimitCtrl.h File Reference",
"href":"cpp_ref/_i_limit_ctrl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILinkTMCtrl.h File Reference",
"href":"cpp_ref/_i_link_t_m_ctrl_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILoadSaveAnimation.h File Reference",
"href":"cpp_ref/_i_load_save_animation_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILockedContainerUpdate.h File Reference",
"href":"cpp_ref/_i_locked_container_update_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ILockedTracks.h File Reference",
"href":"cpp_ref/_i_locked_tracks_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMaterialBrowserEntryInfo.h File Reference",
"href":"cpp_ref/_i_material_browser_entry_info_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMaterialViewportShading.h File Reference",
"href":"cpp_ref/_i_material_viewport_shading_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IMeshDisplay2.h File Reference",
"href":"cpp_ref/_i_mesh_display2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMetaData.h File Reference",
"href":"cpp_ref/_i_meta_data_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/IMixer8.h File Reference",
"href":"cpp_ref/_i_mixer8_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/IMixer.h File Reference",
"href":"cpp_ref/_i_mixer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/IMoFlow.h File Reference",
"href":"cpp_ref/_i_mo_flow_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMtlBrowserFilter.h File Reference",
"href":"cpp_ref/_i_mtl_browser_filter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IMtlRender_Compatibility.h File Reference",
"href":"cpp_ref/_i_mtl_render___compatibility_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/IMXSDebugger.h File Reference",
"href":"cpp_ref/_i_m_x_s_debugger_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IMXSParticleContainer.h File Reference",
"href":"cpp_ref/_i_m_x_s_particle_container_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INamedSelectionSetManager.h File Reference",
"href":"cpp_ref/_i_named_selection_set_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeBakeProperties.h File Reference",
"href":"cpp_ref/_i_node_bake_properties_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeDisplayProperties.h File Reference",
"href":"cpp_ref/_i_node_display_properties_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeExposure.h File Reference",
"href":"cpp_ref/_i_node_exposure_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeGIProperties.h File Reference",
"href":"cpp_ref/_i_node_g_i_properties_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeLayerProperties.h File Reference",
"href":"cpp_ref/_i_node_layer_properties_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeMentalRayProperties.h File Reference",
"href":"cpp_ref/_i_node_mental_ray_properties_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeMonitor.h File Reference",
"href":"cpp_ref/_i_node_monitor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeShadingProperties.h File Reference",
"href":"cpp_ref/_i_node_shading_properties_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeTab.h File Reference",
"href":"cpp_ref/_i_node_tab_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeTransformModes.h File Reference",
"href":"cpp_ref/_i_node_transform_modes_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeTransformMonitor.h File Reference",
"href":"cpp_ref/_i_node_transform_monitor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: INodeValidity.h File Reference",
"href":"cpp_ref/_i_node_validity_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IObjectDisplay2.h File Reference",
"href":"cpp_ref/_i_object_display2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IObjectDisplay.h File Reference",
"href":"cpp_ref/_i_object_display_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPainterInterface.h File Reference",
"href":"cpp_ref/_i_painter_interface_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IParameterTranslator.h File Reference",
"href":"cpp_ref/_i_parameter_translator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannels.h File Reference",
"href":"cpp_ref/_i_particle_channels_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannel.h File Reference",
"href":"cpp_ref/_i_particle_channel_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelAcceleration.h File Reference",
"href":"cpp_ref/_i_particle_channel_acceleration_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelAmount.h File Reference",
"href":"cpp_ref/_i_particle_channel_amount_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelAngAxis.h File Reference",
"href":"cpp_ref/_i_particle_channel_ang_axis_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelBirthTime.h File Reference",
"href":"cpp_ref/_i_particle_channel_birth_time_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelBool.h File Reference",
"href":"cpp_ref/_i_particle_channel_bool_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelDeathTime.h File Reference",
"href":"cpp_ref/_i_particle_channel_death_time_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelEventStart.h File Reference",
"href":"cpp_ref/_i_particle_channel_event_start_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelExt2.h File Reference",
"href":"cpp_ref/_i_particle_channel_ext2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelExt.h File Reference",
"href":"cpp_ref/_i_particle_channel_ext_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelFloat.h File Reference",
"href":"cpp_ref/_i_particle_channel_float_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelInt.h File Reference",
"href":"cpp_ref/_i_particle_channel_int_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelID.h File Reference",
"href":"cpp_ref/_i_particle_channel_i_d_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelINode.h File Reference",
"href":"cpp_ref/_i_particle_channel_i_node_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelINodeHandle.h File Reference",
"href":"cpp_ref/_i_particle_channel_i_node_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelLifespan.h File Reference",
"href":"cpp_ref/_i_particle_channel_lifespan_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMap.h File Reference",
"href":"cpp_ref/_i_particle_channel_map_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMaterialIndex.h File Reference",
"href":"cpp_ref/_i_particle_channel_material_index_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMatrix3.h File Reference",
"href":"cpp_ref/_i_particle_channel_matrix3_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMesh.h File Reference",
"href":"cpp_ref/_i_particle_channel_mesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMeshMap.h File Reference",
"href":"cpp_ref/_i_particle_channel_mesh_map_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMXSFloat.h File Reference",
"href":"cpp_ref/_i_particle_channel_m_x_s_float_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMXSInteger.h File Reference",
"href":"cpp_ref/_i_particle_channel_m_x_s_integer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMXSMatrix.h File Reference",
"href":"cpp_ref/_i_particle_channel_m_x_s_matrix_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelMXSVector.h File Reference",
"href":"cpp_ref/_i_particle_channel_m_x_s_vector_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelNew.h File Reference",
"href":"cpp_ref/_i_particle_channel_new_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelOrientation.h File Reference",
"href":"cpp_ref/_i_particle_channel_orientation_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelPoint3.h File Reference",
"href":"cpp_ref/_i_particle_channel_point3_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelPosition.h File Reference",
"href":"cpp_ref/_i_particle_channel_position_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelPTV.h File Reference",
"href":"cpp_ref/_i_particle_channel_p_t_v_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelQuat.h File Reference",
"href":"cpp_ref/_i_particle_channel_quat_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelScale.h File Reference",
"href":"cpp_ref/_i_particle_channel_scale_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelSelection.h File Reference",
"href":"cpp_ref/_i_particle_channel_selection_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelShape.h File Reference",
"href":"cpp_ref/_i_particle_channel_shape_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelShapeNodeHandle.h File Reference",
"href":"cpp_ref/_i_particle_channel_shape_node_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelShapeTexture.h File Reference",
"href":"cpp_ref/_i_particle_channel_shape_texture_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelSpeed.h File Reference",
"href":"cpp_ref/_i_particle_channel_speed_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelSpin.h File Reference",
"href":"cpp_ref/_i_particle_channel_spin_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelTabTVFace.h File Reference",
"href":"cpp_ref/_i_particle_channel_tab_t_v_face_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelTabUVVert.h File Reference",
"href":"cpp_ref/_i_particle_channel_tab_u_v_vert_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelTime.h File Reference",
"href":"cpp_ref/_i_particle_channel_time_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelTrueFalseIterator2.h File Reference",
"href":"cpp_ref/_i_particle_channel_true_false_iterator2_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelTrueFalseIterator.h File Reference",
"href":"cpp_ref/_i_particle_channel_true_false_iterator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleChannelVoid.h File Reference",
"href":"cpp_ref/_i_particle_channel_void_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleContainer.h File Reference",
"href":"cpp_ref/_i_particle_container_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleGroup.h File Reference",
"href":"cpp_ref/_i_particle_group_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IParticleGroupExt.h File Reference",
"href":"cpp_ref/_i_particle_group_ext_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IParticleObjectExt.h File Reference",
"href":"cpp_ref/_i_particle_object_ext_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IPathConfigMgr.h File Reference",
"href":"cpp_ref/_i_path_config_mgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IPrimitiveRenderer.h File Reference",
"href":"cpp_ref/_i_primitive_renderer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionMod.h File Reference",
"href":"cpp_ref/_i_projection_mod_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjectionRenderHandler.h File Reference",
"href":"cpp_ref/_i_projection_render_handler_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IProjection_WorkingModelInfo.h File Reference",
"href":"cpp_ref/_i_projection___working_model_info_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFAction.h File Reference",
"href":"cpp_ref/_i_p_f_action_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFActionExt.h File Reference",
"href":"cpp_ref/_i_p_f_action_ext_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFActionList.h File Reference",
"href":"cpp_ref/_i_p_f_action_list_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFActionListMaterialHolder.h File Reference",
"href":"cpp_ref/_i_p_f_action_list_material_holder_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFActionListPool.h File Reference",
"href":"cpp_ref/_i_p_f_action_list_pool_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFActionListSet.h File Reference",
"href":"cpp_ref/_i_p_f_action_list_set_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFActionState.h File Reference",
"href":"cpp_ref/_i_p_f_action_state_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFArrow.h File Reference",
"href":"cpp_ref/_i_p_f_arrow_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFIntegrator.h File Reference",
"href":"cpp_ref/_i_p_f_integrator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFOperator.h File Reference",
"href":"cpp_ref/_i_p_f_operator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFOperatorPhysXWorld.h File Reference",
"href":"cpp_ref/_i_p_f_operator_phys_x_world_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFRender.h File Reference",
"href":"cpp_ref/_i_p_f_render_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFSystem.h File Reference",
"href":"cpp_ref/_i_p_f_system_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFSystemPool.h File Reference",
"href":"cpp_ref/_i_p_f_system_pool_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFTest.h File Reference",
"href":"cpp_ref/_i_p_f_test_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPFViewport.h File Reference",
"href":"cpp_ref/_i_p_f_viewport_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPViewItem.h File Reference",
"href":"cpp_ref/_i_p_view_item_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPViewItemCreator.h File Reference",
"href":"cpp_ref/_i_p_view_item_creator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/IPViewManager.h File Reference",
"href":"cpp_ref/_i_p_view_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRadiosityPreferences.h File Reference",
"href":"cpp_ref/_i_radiosity_preferences_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IRefObject.h File Reference",
"href":"cpp_ref/_i_ref_object_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRefTargContainer.h File Reference",
"href":"cpp_ref/_i_ref_targ_container_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRefTargMonitor.h File Reference",
"href":"cpp_ref/_i_ref_targ_monitor_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRefTargMonitorClass.h File Reference",
"href":"cpp_ref/_i_ref_targ_monitor_class_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IRenderGeometry.h File Reference",
"href":"cpp_ref/_i_render_geometry_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IRenderItemContainer.h File Reference",
"href":"cpp_ref/_i_render_item_container_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IRenderStateManager.h File Reference",
"href":"cpp_ref/_i_render_state_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRTShaderNode.h File Reference",
"href":"cpp_ref/_i_r_t_shader_node_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IRTShaderParameterBinding.h File Reference",
"href":"cpp_ref/_i_r_t_shader_parameter_binding_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISceneEventManager.h File Reference",
"href":"cpp_ref/_i_scene_event_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISceneStateManager.h File Reference",
"href":"cpp_ref/_i_scene_state_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IShaderManager.h File Reference",
"href":"cpp_ref/_i_shader_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IShadeContextExtension8.h File Reference",
"href":"cpp_ref/_i_shade_context_extension8_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISimpleFaceDataChannel.h File Reference",
"href":"cpp_ref/_i_simple_face_data_channel_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISimpleFaceDataManager.h File Reference",
"href":"cpp_ref/_i_simple_face_data_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/ISimpleMaterial.h File Reference",
"href":"cpp_ref/_i_simple_material_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISkinWrapMesh.h File Reference",
"href":"cpp_ref/_i_skin_wrap_mesh_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ISkinWrapPatch.h File Reference",
"href":"cpp_ref/_i_skin_wrap_patch_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ITabDialog.h File Reference",
"href":"cpp_ref/_i_tab_dialog_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/ITextureDisplay.h File Reference",
"href":"cpp_ref/_i_texture_display_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IUtilityPanel.h File Reference",
"href":"cpp_ref/_i_utility_panel_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportButton.h File Reference",
"href":"cpp_ref/_i_viewport_button_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportManager.h File Reference",
"href":"cpp_ref/_i_viewport_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewportShadingMgr.h File Reference",
"href":"cpp_ref/_i_viewport_shading_mgr_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IViewportViewSetting.h File Reference",
"href":"cpp_ref/_i_viewport_view_setting_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewPanel.h File Reference",
"href":"cpp_ref/_i_view_panel_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IViewPanelManager.h File Reference",
"href":"cpp_ref/_i_view_panel_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/IVirtualDevice.h File Reference",
"href":"cpp_ref/_i_virtual_device_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IWorkingPivot.h File Reference",
"href":"cpp_ref/_i_working_pivot_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: IGame/IXrefManager.h File Reference",
"href":"cpp_ref/_i_xref_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/JobFrames.h File Reference",
"href":"cpp_ref/_job_frames_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/JobServer.h File Reference",
"href":"cpp_ref/_job_server_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/KeyTrack.h File Reference",
"href":"cpp_ref/_key_track_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: LightTypeEnums.h File Reference",
"href":"cpp_ref/_light_type_enums_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/ManagerInfo.h File Reference",
"href":"cpp_ref/_manager_info_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/MaterialRequiredStreams.h File Reference",
"href":"cpp_ref/_material_required_streams_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/Matrix44.h File Reference",
"href":"cpp_ref/_matrix44_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/kernel/MaxscriptTypedefs.h File Reference",
"href":"cpp_ref/_maxscript_typedefs_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/MaxContext.h File Reference",
"href":"cpp_ref/_max_context_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxDirectories.h File Reference",
"href":"cpp_ref/_max_directories_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Util/MaxExceptions.h File Reference",
"href":"cpp_ref/_max_exceptions_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxHeap.h File Reference",
"href":"cpp_ref/_max_heap_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxMixer.h File Reference",
"href":"cpp_ref/_max_mixer_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/MaxNetExport.h File Reference",
"href":"cpp_ref/_max_net_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MaxWindowsVersion.h File Reference",
"href":"cpp_ref/_max_windows_version_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Mergeable.h File Reference",
"href":"cpp_ref/_mergeable_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/MeshElementDescription.h File Reference",
"href":"cpp_ref/_mesh_element_description_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshFaceFlagConstants.h File Reference",
"href":"cpp_ref/_mesh_face_flag_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MeshNormalSpec.h File Reference",
"href":"cpp_ref/_mesh_normal_spec_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MtlBaseList.h File Reference",
"href":"cpp_ref/_mtl_base_list_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/kernel/MAXScript_TLS.h File Reference",
"href":"cpp_ref/_m_a_x_script___t_l_s_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNChamferData10.h File Reference",
"href":"cpp_ref/_m_n_chamfer_data10_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: MNNormalSpec.h File Reference",
"href":"cpp_ref/_m_n_normal_spec_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/editor/MXS_Editor_Interface.h File Reference",
"href":"cpp_ref/_m_x_s___editor___interface_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/NetworkStatus.h File Reference",
"href":"cpp_ref/_network_status_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Noncopyable.h File Reference",
"href":"cpp_ref/_noncopyable_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ObjectWrapper.h File Reference",
"href":"cpp_ref/_object_wrapper_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/OneClickCreateCallBack.h File Reference",
"href":"cpp_ref/_one_click_create_call_back_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/OurExp.h File Reference",
"href":"cpp_ref/_our_exp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/OLE.classids.h File Reference",
"href":"cpp_ref/_o_l_e_8classids_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/OLE.h File Reference",
"href":"cpp_ref/_o_l_e_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/util/OLE.CExcepInfo.h File Reference",
"href":"cpp_ref/_o_l_e_8_c_excep_info_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParamDimension.h File Reference",
"href":"cpp_ref/_param_dimension_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/ParticleChannelMask.h File Reference",
"href":"cpp_ref/_particle_channel_mask_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: PatchTypeConstants.h File Reference",
"href":"cpp_ref/_patch_type_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Path.h File Reference",
"href":"cpp_ref/_path_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: PerformanceTools.h File Reference",
"href":"cpp_ref/_performance_tools_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/Phyexp.h File Reference",
"href":"cpp_ref/_phyexp_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: PodTypeCheck.h File Reference",
"href":"cpp_ref/_pod_type_check_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PreciseTimeValue.h File Reference",
"href":"cpp_ref/_precise_time_value_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ProductDefaults.h File Reference",
"href":"cpp_ref/_product_defaults_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ProductFileSupport.h File Reference",
"href":"cpp_ref/_product_file_support_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: PB2Export.h File Reference",
"href":"cpp_ref/_p_b2_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFActionStateDesc.h File Reference",
"href":"cpp_ref/_p_f_action_state_desc_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFClassIDs.h File Reference",
"href":"cpp_ref/_p_f_class_i_ds_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFExport.h File Reference",
"href":"cpp_ref/_p_f_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFMessages.h File Reference",
"href":"cpp_ref/_p_f_messages_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFSimpleAction.h File Reference",
"href":"cpp_ref/_p_f_simple_action_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFSimpleActionState.h File Reference",
"href":"cpp_ref/_p_f_simple_action_state_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFSimpleOperator.h File Reference",
"href":"cpp_ref/_p_f_simple_operator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFSimpleTest.h File Reference",
"href":"cpp_ref/_p_f_simple_test_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/PFVrayClassIDs.h File Reference",
"href":"cpp_ref/_p_f_vray_class_i_ds_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ParticleFlow/RandObjLinker.h File Reference",
"href":"cpp_ref/_rand_obj_linker_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: RealWorldMapUtils.h File Reference",
"href":"cpp_ref/_real_world_map_utils_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ReferenceSaveManager.h File Reference",
"href":"cpp_ref/_reference_save_manager_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/RenderEnums.h File Reference",
"href":"cpp_ref/_render_enums_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/RenderItemHandle.h File Reference",
"href":"cpp_ref/_render_item_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/RenderItemHandleArray.h File Reference",
"href":"cpp_ref/_render_item_handle_array_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/RenderItemHandleDecorator.h File Reference",
"href":"cpp_ref/_render_item_handle_decorator_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/RenderNodeHandle.h File Reference",
"href":"cpp_ref/_render_node_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/RenderStates.h File Reference",
"href":"cpp_ref/_render_states_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: RendType.h File Reference",
"href":"cpp_ref/_rend_type_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: RollupConstants.h File Reference",
"href":"cpp_ref/_rollup_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: RTMax.h File Reference",
"href":"cpp_ref/_r_t_max_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: SchematicViewProperty.h File Reference",
"href":"cpp_ref/_schematic_view_property_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/ScripterExport.h File Reference",
"href":"cpp_ref/_scripter_export_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/ServerInfo.h File Reference",
"href":"cpp_ref/_server_info_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/ServerList.h File Reference",
"href":"cpp_ref/_server_list_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: SingleWeakRefMaker.h File Reference",
"href":"cpp_ref/_single_weak_ref_maker_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/SmartHandle.h File Reference",
"href":"cpp_ref/_smart_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/SolidColorMaterialHandle.h File Reference",
"href":"cpp_ref/_solid_color_material_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/StandardMaterialHandle.h File Reference",
"href":"cpp_ref/_standard_material_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Util/StaticAssert.h File Reference",
"href":"cpp_ref/_static_assert_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/Statistics.h File Reference",
"href":"cpp_ref/_statistics_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: StopWatch.h File Reference",
"href":"cpp_ref/_stop_watch_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: ManagedServices/StringConverter.h File Reference",
"href":"cpp_ref/_string_converter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Strip.h File Reference",
"href":"cpp_ref/_strip_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/SubobjectDisplayUtility.h File Reference",
"href":"cpp_ref/_subobject_display_utility_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: SubObjAxisCallback.h File Reference",
"href":"cpp_ref/_sub_obj_axis_callback_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: SysNodeContext.h File Reference",
"href":"cpp_ref/_sys_node_context_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: TabTypes.h File Reference",
"href":"cpp_ref/_tab_types_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/TargetHandle.h File Reference",
"href":"cpp_ref/_target_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/TextureHandle.h File Reference",
"href":"cpp_ref/_texture_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/TextureHandleUtility.h File Reference",
"href":"cpp_ref/_texture_handle_utility_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: TextureMapIndexConstants.h File Reference",
"href":"cpp_ref/_texture_map_index_constants_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/TextureMaterialHandle.h File Reference",
"href":"cpp_ref/_texture_material_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: TimeMap.h File Reference",
"href":"cpp_ref/_time_map_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: CS/Tracks.h File Reference",
"href":"cpp_ref/_tracks_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackClipObject.h File Reference",
"href":"cpp_ref/_track_clip_object_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackFlags.h File Reference",
"href":"cpp_ref/_track_flags_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackHitRecord.h File Reference",
"href":"cpp_ref/_track_hit_record_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: TrackScreenUtils.h File Reference",
"href":"cpp_ref/_track_screen_utils_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/Types.h File Reference",
"href":"cpp_ref/_types_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/UpdateDisplayContext.h File Reference",
"href":"cpp_ref/_update_display_context_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/UpdateNodeContext.h File Reference",
"href":"cpp_ref/_update_node_context_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/UpdateViewContext.h File Reference",
"href":"cpp_ref/_update_view_context_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: network/Util.h File Reference",
"href":"cpp_ref/_util_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVWMapper.h File Reference",
"href":"cpp_ref/_u_v_w_mapper_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: UVWMapTypes.h File Reference",
"href":"cpp_ref/_u_v_w_map_types_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/ValueHolder.h File Reference",
"href":"cpp_ref/_value_holder_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/ValueHolderMember.h File Reference",
"href":"cpp_ref/_value_holder_member_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: VariableGuard.h File Reference",
"href":"cpp_ref/_variable_guard_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/VertexBufferHandle.h File Reference",
"href":"cpp_ref/_vertex_buffer_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: Graphics/VertexColorMaterialHandle.h File Reference",
"href":"cpp_ref/_vertex_color_material_handle_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: VertexNormal.h File Reference",
"href":"cpp_ref/_vertex_normal_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: WindowsDefines.h File Reference",
"href":"cpp_ref/_windows_defines_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: WindowsMessageFilter.h File Reference",
"href":"cpp_ref/_windows_message_filter_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: maxscript/foundation/WindowStream.h File Reference",
"href":"cpp_ref/_window_stream_8h.html",
"description":"",
"ancestors":[]},
{"title":"C++: XMLAnimTreeEntry.h File Reference",
"href":"cpp_ref/_x_m_l_anim_tree_entry_8h.html",
"description":"",
"ancestors":[]}]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIZNgYJKoZIhvcNAQcCoIIZJzCCGSMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFGEl+6gBI6c9
// SIG // f+3E0nTO9Q7oPgULoIIUMDCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIFhTCCBG2gAwIBAgIQKcFbP6rNUmpOZ708
// SIG // Tn4/8jANBgkqhkiG9w0BAQUFADCBtDELMAkGA1UEBhMC
// SIG // VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
// SIG // VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYD
// SIG // VQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cu
// SIG // dmVyaXNpZ24uY29tL3JwYSAoYykxMDEuMCwGA1UEAxMl
// SIG // VmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAx
// SIG // MCBDQTAeFw0xMjA3MjUwMDAwMDBaFw0xNTA5MjAyMzU5
// SIG // NTlaMIHIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2Fs
// SIG // aWZvcm5pYTETMBEGA1UEBxMKU2FuIFJhZmFlbDEWMBQG
// SIG // A1UEChQNQXV0b2Rlc2ssIEluYzE+MDwGA1UECxM1RGln
// SIG // aXRhbCBJRCBDbGFzcyAzIC0gTWljcm9zb2Z0IFNvZnR3
// SIG // YXJlIFZhbGlkYXRpb24gdjIxHzAdBgNVBAsUFkRlc2ln
// SIG // biBTb2x1dGlvbnMgR3JvdXAxFjAUBgNVBAMUDUF1dG9k
// SIG // ZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCoYmDrmd0Gq8ezSsDlfgaJFEFplNPNhWzM
// SIG // 2uFQaYAB/ggpQ11+N4B6ao+TqrNIWDIqt3JKhaU889nx
// SIG // l/7teWGwuOurstI2Z0bEDhXiXam/bicK2HVLyntliQ+6
// SIG // tT+nlgfN8tgB2NzM0BpE1YCnU2b6DwQw4V7BV+/F//83
// SIG // yGFOpePlumzXxNw9EKWkaq81slmmTxf7UxZgP9PGbLw8
// SIG // gLAPk4PTJI97+5BBqhkLb1YqSfWn3PNMfsNKhw/VwAN0
// SIG // dRKeM6H8SkOdz+osr+NyH86lsKQuics4fwK5uFSHQHsI
// SIG // t6Z0tqWvminRqceUi9ugRlGryh9X1ZqCqfL/ggdzYa3Z
// SIG // AgMBAAGjggF7MIIBdzAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDBABgNVHR8EOTA3MDWgM6Axhi9odHRwOi8v
// SIG // Y3NjMy0yMDEwLWNybC52ZXJpc2lnbi5jb20vQ1NDMy0y
// SIG // MDEwLmNybDBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBxcD
// SIG // MCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9ycGEwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // cQYIKwYBBQUHAQEEZTBjMCQGCCsGAQUFBzABhhhodHRw
// SIG // Oi8vb2NzcC52ZXJpc2lnbi5jb20wOwYIKwYBBQUHMAKG
// SIG // L2h0dHA6Ly9jc2MzLTIwMTAtYWlhLnZlcmlzaWduLmNv
// SIG // bS9DU0MzLTIwMTAuY2VyMB8GA1UdIwQYMBaAFM+Zqep7
// SIG // JvRLyY6P1/AFJu/j0qedMBEGCWCGSAGG+EIBAQQEAwIE
// SIG // EDAWBgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG
// SIG // 9w0BAQUFAAOCAQEA2OkGvuiY7TyI6yVTQAYmTO+MpOFG
// SIG // C8MflHSbofJiuLxrS1KXbkzsAPFPPsU1ouftFhsXFtDQ
// SIG // 8rMTq/jwugTpbJUREV0buEkLl8AKRhYQTKBKg1I/puBv
// SIG // bkJocDE0pRwtBz3xSlXXEwyYPcbCOnrM3OZ5bKx1Qiii
// SIG // vixlcGWhO3ws904ssutPFf4mV5PDi3U2Yp1HgbBK/Um/
// SIG // FLr6YAYeZaA8KY1CfQEisF3UKTwm72d7S+fJf++SOGea
// SIG // K0kumehVcbavQJTOVebuZ9V+qU0nk1lMrqve9BnQK69B
// SIG // QqNZu77vCO0wm81cfynAxkOYKZG3idY47qPJOgXKkwmI
// SIG // 2+92ozCCBgowggTyoAMCAQICEFIA5aolVvwahu2WydRL
// SIG // M8cwDQYJKoZIhvcNAQEFBQAwgcoxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UE
// SIG // CxMxKGMpIDIwMDYgVmVyaVNpZ24sIEluYy4gLSBGb3Ig
// SIG // YXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVy
// SIG // aVNpZ24gQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0
// SIG // aWZpY2F0aW9uIEF1dGhvcml0eSAtIEc1MB4XDTEwMDIw
// SIG // ODAwMDAwMFoXDTIwMDIwNzIzNTk1OVowgbQxCzAJBgNV
// SIG // BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEf
// SIG // MB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7
// SIG // MDkGA1UECxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8v
// SIG // d3d3LnZlcmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNV
// SIG // BAMTJVZlcmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5n
// SIG // IDIwMTAgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQD1I0tepdeKuzLp1Ff37+THJn6tGZj+qJ19
// SIG // lPY2axDXdYEwfwRof8srdR7NHQiM32mUpzejnHuA4Jnh
// SIG // 7jdNX847FO6G1ND1JzW8JQs4p4xjnRejCKWrsPvNamKC
// SIG // TNUh2hvZ8eOEO4oqT4VbkAFPyad2EH8nA3y+rn59wd35
// SIG // BbwbSJxp58CkPDxBAD7fluXF5JRx1lUBxwAmSkA8taEm
// SIG // qQynbYCOkCV7z78/HOsvlvrlh3fGtVayejtUMFMb32I0
// SIG // /x7R9FqTKIXlTBdOflv9pJOZf9/N76R17+8V9kfn+Bly
// SIG // 2C40Gqa0p0x+vbtPDD1X8TDWpjaO1oB21xkupc1+NC2J
// SIG // AgMBAAGjggH+MIIB+jASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MHAGA1UdIARpMGcwZQYLYIZIAYb4RQEHFwMwVjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L2NwczAqBggrBgEFBQcCAjAeGhxodHRwczovL3d3dy52
// SIG // ZXJpc2lnbi5jb20vcnBhMA4GA1UdDwEB/wQEAwIBBjBt
// SIG // BggrBgEFBQcBDARhMF+hXaBbMFkwVzBVFglpbWFnZS9n
// SIG // aWYwITAfMAcGBSsOAwIaBBSP5dMahqyNjmvDz4Bq1EgY
// SIG // LHsZLjAlFiNodHRwOi8vbG9nby52ZXJpc2lnbi5jb20v
// SIG // dnNsb2dvLmdpZjA0BgNVHR8ELTArMCmgJ6AlhiNodHRw
// SIG // Oi8vY3JsLnZlcmlzaWduLmNvbS9wY2EzLWc1LmNybDA0
// SIG // BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6
// SIG // 